/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.SessionId;

class CommandCoercer
extends TypeCoercer<Command> {
    CommandCoercer() {
    }

    @Override
    public boolean test(Class<?> aClass) {
        return Command.class.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Command> apply(Type type) {
        return (jsonInput, setting) -> {
            Map json = (Map)jsonInput.read(Json.MAP_TYPE);
            SessionId sessionId = this.createSessionId(json.get("sessionId"));
            String name = (String)json.get("name");
            HashMap parameters = new HashMap();
            if (json.get("parameters") instanceof Map) {
                ((Map)json.get("parameters")).forEach((key, value) -> parameters.put(String.valueOf(key), value));
            }
            return new Command(sessionId, name, parameters);
        };
    }

    private SessionId createSessionId(Object value) {
        if (value instanceof String) {
            return new SessionId((String)value);
        }
        if (value instanceof Map) {
            return this.createSessionId(((Map)value).get("value"));
        }
        return null;
    }
}

