/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.MappingException;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.persister.collection.QueryableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCollectionLoader
extends CollectionLoader {
    private static final Logger log = LoggerFactory.getLogger(BasicCollectionLoader.class);

    public BasicCollectionLoader(QueryableCollection collectionPersister, SessionFactoryImplementor session, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(collectionPersister, 1, session, loadQueryInfluencers);
    }

    public BasicCollectionLoader(QueryableCollection collectionPersister, int batchSize, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(collectionPersister, batchSize, null, factory, loadQueryInfluencers);
    }

    protected BasicCollectionLoader(QueryableCollection collectionPersister, int batchSize, String subquery, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(collectionPersister, factory, loadQueryInfluencers);
        BasicCollectionJoinWalker walker = new BasicCollectionJoinWalker(collectionPersister, batchSize, subquery, factory, loadQueryInfluencers);
        this.initFromWalker(walker);
        this.postInstantiate();
        log.debug("Static select for collection " + collectionPersister.getRole() + ": " + this.getSQLString());
    }
}

