/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.DateRangeCriterion;
import com.isomorphic.criteria.criterion.DoubleRangeCriterion;
import com.isomorphic.criteria.criterion.FloatRangeCriterion;
import com.isomorphic.criteria.criterion.IntegerRangeCriterion;
import com.isomorphic.criteria.criterion.LongRangeCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.RelativeDateRangeCriterion;
import com.isomorphic.log.Logger;
import com.isomorphic.util.date.DateUtil;
import com.isomorphic.util.date.RelativeDate;
import com.isomorphic.util.date.RelativeDateRangePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RangeOperator
extends OperatorBase {
    private static final String MAX_KEY = "end";
    private static final String MIN_KEY = "start";
    private static Logger log = new Logger(RangeOperator.class.getName());

    @Override
    public abstract String getID();

    @Override
    public boolean isRequiresFieldName() {
        return true;
    }

    @Override
    public boolean isRequiresValue() {
        return false;
    }

    @Override
    public boolean isRequiresCriteria() {
        return false;
    }

    @Override
    public Criterion parseCriterion(Map criteriaData) {
        super.parseCriterion(criteriaData);
        String fieldName = (String)criteriaData.get("fieldName");
        Object minValue = criteriaData.get(MIN_KEY);
        Object maxValue = criteriaData.get(MAX_KEY);
        if (minValue instanceof Double || maxValue instanceof Double) {
            return new DoubleRangeCriterion(fieldName, this.getID(), (Double)minValue, (Double)maxValue);
        }
        if (minValue instanceof Float || maxValue instanceof Float) {
            return new FloatRangeCriterion(fieldName, this.getID(), (Float)minValue, (Float)maxValue);
        }
        if (minValue instanceof Long || maxValue instanceof Long) {
            return new LongRangeCriterion(fieldName, this.getID(), (Long)minValue, (Long)maxValue);
        }
        if (minValue instanceof Integer || maxValue instanceof Integer) {
            return new IntegerRangeCriterion(fieldName, this.getID(), (Integer)minValue, (Integer)maxValue);
        }
        if (minValue instanceof Date && maxValue instanceof Date) {
            return new DateRangeCriterion(fieldName, this.getID(), (Date)minValue, (Date)maxValue);
        }
        if (DateUtil.isRelativeDate(minValue) && DateUtil.isRelativeDate(maxValue)) {
            Map minValueMap = (Map)minValue;
            Map maxValueMap = (Map)maxValue;
            RelativeDate min2 = new RelativeDate((String)minValueMap.get("value"), RelativeDateRangePosition.START);
            RelativeDate max2 = new RelativeDate((String)maxValueMap.get("value"), RelativeDateRangePosition.END);
            return new RelativeDateRangeCriterion(fieldName, this.getID(), min2, max2);
        }
        if (DateUtil.isRelativeDate(minValue) && maxValue instanceof Date) {
            Map minValueMap = (Map)minValue;
            RelativeDate min3 = new RelativeDate((String)minValueMap.get("value"), RelativeDateRangePosition.START);
            return new RelativeDateRangeCriterion(fieldName, this.getID(), min3, (Date)maxValue);
        }
        if (minValue instanceof Date && DateUtil.isRelativeDate(maxValue)) {
            Map maxValueMap = (Map)maxValue;
            RelativeDate max3 = new RelativeDate((String)maxValueMap.get("value"), RelativeDateRangePosition.END);
            return new RelativeDateRangeCriterion(fieldName, this.getID(), (Date)minValue, max3);
        }
        if (minValue instanceof Comparable && maxValue instanceof Comparable) {
            return new RangeCriterion(fieldName, this.getID(), (Comparable)minValue, (Comparable)maxValue);
        }
        log.error("Unknown class for range comparison " + (minValue == null ? "null" : minValue.getClass()));
        return null;
    }

    public Criterion parseCriterion(String fieldName, Object value, List criterias) {
        return null;
    }

    public Map convertToMap(Criterion criterion) {
        RangeCriterion sc = (RangeCriterion)criterion;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("operator", sc.getOperatorId());
        result.put("fieldName", sc.getFieldName());
        result.put(MIN_KEY, sc.getMin());
        result.put(MAX_KEY, sc.getMax());
        return result;
    }
}

