/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IDoNotAdapt;
import com.isomorphic.util.LocaleMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DSField
extends DataTypeMap
implements IDoNotAdapt {
    public static final String STRING_IN_BROWSER = "stringInBrowser";
    private static Logger log = new Logger(DSField.class);
    private boolean _1ManyRelation = false;
    private boolean _manyManyRelation = false;
    private String _relatedDSName;
    private String _joinDSName;
    private Boolean isCustomSQL = null;

    public DSField(Map fieldData) {
        this(fieldData, null);
    }

    public DSField(Map fieldData, BasicDataSource ds) {
        String fk;
        BasicDataSource superDS;
        DSField superField;
        boolean hidden;
        DataTools.mapMerge(fieldData, (Map)((Object)this));
        boolean ignore = this.getBoolean("ignore");
        if (ignore && !(hidden = this.getBoolean("hidden"))) {
            this.put("hidden", Boolean.TRUE);
        }
        if (this.get("tableName") != null && this.get("canEdit") == null) {
            this.put("canEdit", Boolean.FALSE);
        }
        if (this.get("type") == null && ds.getSuper() != null && (superField = (superDS = ds.getSuper()).getField(this.getName())) != null && superField.getType() != null && !DataTools.getBoolean((Map)((Object)superField), "unknownType")) {
            this.put("type", superField.getType());
            this.put("typeInherited", true);
            if (!this.containsKey("length") && superField.containsKey("length")) {
                this.put("length", superField.get("length"));
            }
        }
        if (this.get("type") != null) {
            this.put("typeExplicitlyDeclared", true);
        }
        if (ds != null) {
            try {
                String typeName = (String)fieldData.get("type");
                Map typeDef = BasicDataSource.getBuiltinType(typeName);
                if (typeDef != null) {
                    if (this.get("hidden") == null && typeDef.get("hidden") != null) {
                        this.put("hidden", typeDef.get("hidden"));
                    }
                    if (this.get("canView") == null && typeDef.get("canView") != null) {
                        this.put("canView", typeDef.get("canView"));
                    }
                    if (this.get("canSave") == null && typeDef.get("canSave") != null) {
                        this.put("canSave", typeDef.get("canSave"));
                    }
                    if (this.get("canEdit") == null && typeDef.get("canEdit") != null) {
                        this.put("canEdit", typeDef.get("canEdit"));
                    }
                    if (this.get("sqlStorageStrategy") == null && typeDef.get("sqlStorageStrategy") != null) {
                        this.put("sqlStorageStrategy", typeDef.get("sqlStorageStrategy"));
                    }
                    if (this.getType().equals("boolean") && this.get("sqlStorageStrategy") == null) {
                        if (ds.getConfig().get("defaultBooleanStorageStrategy") != null) {
                            this.put("sqlStorageStrategy", ds.getConfig().get("defaultBooleanStorageStrategy"));
                        } else if (Config.getProperty("sql.defaultBooleanStorageStrategy") != null) {
                            this.put("sqlStorageStrategy", (String)Config.getProperty("sql.defaultBooleanStorageStrategy"));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn(e);
            }
        }
        this.setIsBinary(ds);
        this.setIsJSON(ds);
        if (this.getBoolean("multiple") && (fk = this.getString("foreignKey")) != null && fk.length() > 0) {
            String[] elements = fk.split("\\.");
            if (elements.length == 2) {
                this._1ManyRelation = true;
                this._relatedDSName = elements[0];
            } else if (elements.length == 3) {
                this._manyManyRelation = true;
                this._joinDSName = elements[0];
                this._relatedDSName = elements[1];
            } else {
                log.warn("Unexpected foreignKey structure for field '" + this.getName() + "': " + fk + ". Expected structure is 'RelatedDS.relatedField' for one-to-many relations and 'JoinDS.RelatedDS.relatedField' for many-to-many relations.  See the 'Relations' article in client documentation for more details");
            }
        }
    }

    public boolean is1ManyRelation() {
        return this._1ManyRelation;
    }

    public boolean isManyManyRelation() {
        return this._manyManyRelation;
    }

    public boolean isRelation() {
        return this._1ManyRelation || this._manyManyRelation;
    }

    public String getRelatedDSName() {
        return this._relatedDSName;
    }

    public String getJoinDSName() {
        return this._joinDSName;
    }

    private void setIsBinary(DataSource ds) {
        boolean isBinary = false;
        if (ds != null) {
            try {
                isBinary = ds.simpleTypeInheritsFrom(this.getType(), "binary");
            }
            catch (Exception exception) {}
        } else {
            isBinary = DataSource.simpleTypeInheritsFromBuiltInType(this.getType(), "binary");
        }
        if (isBinary) {
            this.put("isBinary", true);
        }
    }

    private void setIsJSON(DataSource ds) {
        boolean isJSON = false;
        if (ds != null) {
            try {
                isJSON = ds.simpleTypeInheritsFrom(this.getType(), "json");
            }
            catch (Exception exception) {}
        } else {
            isJSON = DataSource.simpleTypeInheritsFromBuiltInType(this.getType(), "json");
        }
        if (isJSON) {
            this.put("isJSON", true);
        }
    }

    public boolean typeIsDefaulted() {
        return !Boolean.TRUE.equals(this.get("typeExplicitlyDeclared")) && !Boolean.TRUE.equals(this.get("typeInherited"));
    }

    public boolean getBoolean(String key) {
        return DataTools.getBoolean((Map)((Object)this), key);
    }

    public boolean getBoolean(String key, boolean dft) {
        Object value = this.get(key);
        if (value == null) {
            return dft;
        }
        return this.getBoolean(key);
    }

    public String getName() {
        return (String)this.get("name");
    }

    public boolean isMultiple() {
        return this.getBoolean("multiple");
    }

    protected boolean canFallbackToSingle() {
        return this.getBoolean("fallbackToSingle");
    }

    protected boolean isCommaSeparated() {
        return this.getBoolean("commaSeparated");
    }

    public boolean isDerived() {
        return this.getBoolean("derived");
    }

    public boolean isRequired() {
        return this.getBoolean("required");
    }

    public boolean isConditionallyRequired() {
        return this.getBoolean("conditionallyRequired") && this.getIncludeFrom() == null;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public Long getLength() {
        return this.getDataSizeNumBytes("length");
    }

    public Object get(Object key) {
        Object value = this.decorated().get(key);
        if ("length".equals(key)) {
            return DSField.dataSizeNumBytes(value, null);
        }
        return value;
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(Locale locale) {
        Object title = this.get("title");
        if (title instanceof LocaleMessage) {
            return ((LocaleMessage)title).getMessage(locale);
        }
        return title == null ? null : title.toString();
    }

    public String getTitleKey() {
        Object title = this.get("title");
        if (title instanceof LocaleMessage) {
            return ((LocaleMessage)title).getKey();
        }
        return null;
    }

    public boolean isPrimaryKey() {
        return this.getBoolean("primaryKey");
    }

    public boolean isAutoGenerated() {
        if ("sequence".equals(this.getType())) {
            return true;
        }
        return this.getBoolean("autoGenerated");
    }

    public String getForeignKey() {
        return (String)this.get("foreignKey");
    }

    public boolean isForeignKey() {
        return this.get("foreignKey") != null;
    }

    public void setForeignKey(String fk) {
        this.put("foreignKey", fk);
    }

    public String getOtherFKs() {
        return (String)this.get("otherFKs");
    }

    public void setOtherFKs(String otherFKs) {
        this.put("otherFKs", otherFKs);
    }

    protected List<String> getAllFKs() {
        return this.getAllFKs(true, true);
    }

    protected List<String> getAllFKs(boolean includeMultipleFKs, boolean includeSingleFKs) {
        String fk;
        ArrayList<String> fks = new ArrayList<String>();
        if ((this.isMultiple() && includeMultipleFKs || !this.isMultiple() && includeSingleFKs) && (fk = this.getForeignKey()) != null && !"".equals(fk.trim())) {
            fks.add(fk.trim());
            String otherFKs = this.getProperty("otherFKs");
            if (otherFKs != null) {
                for (String otherFK : otherFKs.split(",")) {
                    if ("".equals(otherFK = otherFK.trim()) || fks.contains(otherFK)) continue;
                    fks.add(otherFK);
                }
            }
        }
        return fks;
    }

    public String getNativeName() {
        return (String)(this.get("nativeName") != null ? this.get("nativeName") : this.get("fieldName"));
    }

    public String getUniqueProperty() {
        return (String)this.get("uniqueProperty");
    }

    public boolean isPropertiesOnly() {
        return this.getBoolean("propertiesOnly");
    }

    public String getValueXPath() {
        return (String)this.get("valueXPath");
    }

    public void setValueXPath(String valueXPath) {
        this.put("valueXPath", valueXPath);
    }

    public String getValueWriteXPath() {
        return (String)this.get("valueWriteXPath");
    }

    public boolean isBinary() {
        return this.getBoolean("isBinary", false);
    }

    public boolean isJSON() {
        return this.getBoolean("isJSON", false);
    }

    public boolean isCalculated() {
        return this.containsKey("customSQLExpression") && this.get("customSQLExpression") != null || this.containsKey("template") && this.get("template") != null || this.containsKey("formula") && this.get("formula") != null || this.containsKey("valueOperation") && this.get("valueOperation") != null;
    }

    public boolean isCustomSQL() {
        if (this.isCustomSQL == null) {
            this.isCustomSQL = this.getBoolean("customSQL", false);
        }
        return this.isCustomSQL;
    }

    public String getProperty(String property) {
        Object val = this.get(property);
        if (val != null) {
            return String.valueOf(val);
        }
        return null;
    }

    public Object getObjectProperty(String property) {
        return this.get(property);
    }

    public List getListProperty(String property) {
        return (List)this.get(property);
    }

    public Map getMapProperty(String property) {
        return (Map)this.get(property);
    }

    public List getValidators() {
        return (List)this.get("validators");
    }

    public String getIncludeFrom() {
        return this.getProperty("includeFrom");
    }

    public IncludeFromDefinition getIncludeFromDefinition(DSRequest dsRequest) {
        IncludeFromDefinition work = null;
        List incFroms = dsRequest.getIncludeFrom();
        for (int i = 0; i < incFroms.size(); ++i) {
            IncludeFromDefinition incFrom = (IncludeFromDefinition)incFroms.get(i);
            if (!this.getName().equals(incFrom.getThisFieldName())) continue;
            work = incFrom;
            break;
        }
        if (work == null) {
            String text = (String)this.get("includeFrom");
            if (text == null) {
                return null;
            }
            work = new IncludeFromDefinition(this, text, dsRequest);
            if (work.getDataSource() == null || work.getIncludedField() == null) {
                work = null;
            }
        }
        return work;
    }

    public String getBeanPropertyName() {
        String propertyName = this.getValueXPath();
        if (propertyName != null) {
            propertyName = propertyName.trim();
            while (propertyName.startsWith("/")) {
                propertyName = propertyName.substring(1);
            }
            propertyName = propertyName.replace('/', '.');
            return propertyName;
        }
        return this.getName();
    }

    public boolean shouldEncodeInResponse() {
        return this.isBinary() && this.getBoolean("encodeInResponse", false);
    }

    public boolean canView() {
        return DataTools.getBoolean((Map)((Object)this), "canView", true);
    }

    public boolean isInapplicable() {
        return DataTools.getBoolean((Map)((Object)this), "inapplicable", false);
    }

    public int getJoinType() {
        return this.getJoinType(true);
    }

    public int getJoinType(boolean returnDefaultIfUnset) {
        if ("outer".equals(this.get("joinType"))) {
            return 1;
        }
        if ("inner".equals(this.get("joinType"))) {
            return 0;
        }
        return returnDefaultIfUnset ? 0 : -1;
    }

    public boolean ignore() {
        return DataTools.getBoolean((Map)((Object)this), "ignore", false);
    }

    public String getNativeFK() {
        return (String)this.get("nativeFK");
    }

    public String getMimeType() {
        return (String)this.get("mimeType");
    }

    public void setMimeType(String mimeType) {
        this.put("mimeType", mimeType);
    }

    public Boolean shouldIgnoreTextMatchStyle() {
        return DataTools.getBooleanObject((Map)((Object)this), "ignoreTextMatchStyle");
    }

    public void setIgnoreTextMatchStyle(Boolean value) {
        this.put("ignoreTextMatchStyle", value);
    }

    public boolean isLenientXPath() {
        return DataTools.getBoolean((Map)((Object)this), "lenientXPath", false);
    }

    public DataTypeMap<String, Object> getValueMap() {
        Object values = this.get("valueMap");
        if (values == null) {
            return null;
        }
        if (values instanceof Map) {
            return new DataTypeMap<String, Object>((Map)values);
        }
        List valueList = (List)values;
        DataTypeMap<String, Object> map = new DataTypeMap<String, Object>();
        for (Object value : valueList) {
            map.put(value.toString(), value);
        }
        return map;
    }

    public String getMultipleStorage() {
        return this.getProperty("multipleStorage");
    }

    public String getMultipleStorageSeparator() {
        return this.getProperty("multipleStorageSeparator");
    }

    public String getMultipleValueSeparator() {
        String separator = this.getProperty("multipleValueSeparator");
        return separator != null ? separator : ", ";
    }

    public boolean shouldStoreMilliseconds() {
        return DataTools.getBoolean((Map)((Object)this), "storeMilliseconds", false);
    }

    public boolean isRequiredForRecord(Map record, BasicDataSource ds, ValidationContext context) throws Exception {
        if (!this.isConditionallyRequired()) {
            return this.isRequired();
        }
        List validators = this.getValidators();
        if (validators == null) {
            return this.isRequired();
        }
        for (Map validator : validators) {
            if (!"required".equals(validator.get("type"))) continue;
            Map condition = (Map)validator.get("applyWhen");
            if (condition == null) {
                return true;
            }
            Map storedRecord = context.getStoredRecord();
            DataTypeMap conditionRecord = new DataTypeMap(storedRecord);
            DataTools.mapMerge(record, conditionRecord);
            return ds.matchesCriteria((Map)((Object)conditionRecord), condition);
        }
        return this.isRequired();
    }

    public String getFieldValueScript() {
        Object obj = this.getObjectProperty("fieldValueScript");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return (String)((Map)obj).get("#text");
        }
        return obj.toString();
    }

    public String getLanguage() {
        Object obj = this.getObjectProperty("fieldValueScript");
        if (obj != null && obj instanceof Map) {
            return (String)((Map)obj).get("language");
        }
        return null;
    }

    public Object getScriptImports() {
        return this.getObjectProperty("scriptImport");
    }

    public String getStoreWithHash() {
        String hash = this.getString("storeWithHash");
        if (hash == null && "password".equals(this.getType())) {
            hash = "bcrypt";
        }
        if ("none".equals(hash)) {
            hash = null;
        }
        return hash;
    }

    public String getDataTranslatorClassName() {
        return this.getProperty("translatorClassName");
    }

    public static final class Type {
        public static final String TEXT = "text";
        public static final String BOOLEAN = "boolean";
        public static final String INTEGER = "integer";
        public static final String FLOAT = "float";
        public static final String DATE = "date";
        public static final String DATETIME = "datetime";
        public static final String TIME = "time";
        public static final String ENUM = "enum";
        public static final String INT_ENUM = "intEnum";
        public static final String SEQUENCE = "sequence";
        public static final String LINK = "link";
        public static final String IMAGE = "image";
        public static final String BINARY = "binary";
        public static final String IMAGE_FILE = "imageFile";
        public static final String PASSWORD = "password";
        public static final String MODIFIER = "modifier";
        public static final String MODIFIER_TIMESTAMP = "modifierTimestamp";
        public static final String CREATOR = "creator";
        public static final String CREATOR_TIMESTAMP = "creatorTimestamp";
    }
}

