/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.taglib.VirtualTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.jsp.JspException;

public class JSStringTag
extends VirtualTag {
    public String filename = null;
    public String var = null;

    public int doStartTag() throws JspException {
        this.init();
        return 2;
    }

    public int doAfterBody() throws JspException {
        String body = this.bodyContent.getString();
        this.bodyContent.clearBody();
        if (body != null && !body.equals("")) {
            try {
                SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(body), "</isomorphicXML>");
                if (this.getFilename() != null) {
                    JSStringTag.parseFile(this.getFilename(), this.getVar(), (Writer)this.getPreviousOut());
                } else {
                    JSStringTag.parseString(body, this.getVar(), (Writer)this.getPreviousOut());
                }
            }
            catch (Throwable e) {
                this.log.error("Exception processing inline String: " + DataTools.getStackTrace(e));
                throw new JspException(DataTools.getStackTrace(e));
            }
        }
        return 0;
    }

    public static void parseFile(String filename, String var, Writer out) throws Exception {
        ISCFile file = ISCFile.newInstance(config.getPath("webRoot") + "/" + filename);
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(file.getReader(), sw);
        JSStringTag.parseString(sw.toString(), var, out);
    }

    public static void parseString(String source, String var, Writer out) throws Exception {
        if (var != null) {
            JSTranslater.instance().toJSVariable(source, var, out);
        } else {
            JSTranslater.instance().toJS(source, out);
        }
    }

    public static void outputParseErrors(Exception e, Writer out) throws Exception {
        staticLog.info("isc:toString tag outputting errors");
        out.write("isc.Log.logWarn(" + JSTranslater.instance().toJS(DataTools.getStackTrace(e)) + ")\n");
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVar() {
        return this.var;
    }

    @Override
    public void setRunat(String runat) {
    }

    @Override
    public String getRunat() {
        return "NOT SUPPORTED";
    }
}

