
package com.smartgwt.client.docs;

/**
 * <h3>Troubleshooting GWT Development Mode (formerly Super Dev Mode)</h3>
 * This topic provides details on configuring and running Development Mode and troubleshooting
 *  any problems.  For an overview, including a discussion of the difference between 
 *  the new Development Mode (formerly known as Super Dev Mode) and Legacy Development Mode,
 *  see {@link com.smartgwt.client.docs.Debugging Debugging: Development Modes in GWT}.
 *  Note that GWT 2.6.x is the minimum supported GWT version as of SmartGWT 6.1.
 *  <P>
 *  <h3>Development Mode in GWT 2.7.0+</h3>
 *  <P>
 *  The recommended way of running (Super) Dev Mode in GWT 2.7.0+ is by installing the
 *  <a href='http://www.gwtproject.org/download.html' target='_blank'>GWT Eclipse Plugin</a>
 *  and launching the 
 * <a href='http://www.gwtproject.org/articles/superdevmode.html' target='_blank'>Super Dev Mode
 * Server</a>
 *  using a <i>GWT Development Mode (DevMode)</i> Run Configuration (if using GWT Plugin v3) or
 *  a <i>Web Application</i> Run Configuration (if using GWT Plugin v2).  In the remainder of
 *  this troubleshooting overview, we'll use <i>Web Application</i> as a generic term to refer to
 *  your Run Configuration, no matter which GWT Plugin version you have.
 *  <P>
 *  For more guidance beyond the overview in the links above, see
 * <a href='http://www.gwtproject.org/usingeclipse.html' target='_blank'>Using GWT with
 * Eclipse</a>.
 *  Note that this approach can also be used with GWT 2.6.x <i>if you have installed GWT Plugin
 *  2.7.0 or newer</i> - or you can use the approach below.
 *  <P>
 *  <h3>Super Dev Mode in GWT 2.6.x and Earlier</h3>
 *  <P>
 *  For GWT releases before GWT 2.7.0, you must run the Code Server directly.  It can be
 * launched in <a href='https://www.eclipse.org/' target='_blank'>Eclipse</a> (with or without a
 * web server),
 *  or you can launch it from the command line.  Unless a web server is launched in Eclipse
 *  with the Code Server, you'll need to deploy the SGWT Web Application separately from the Code
 *  Server.  
 *  <P>
 *  At this point, it's assumed that you have installed the
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>GWT Eclipse Plugin</a>, and
 * that
 *  you already have an Eclipse Project containing your Java code with a valid classpath picking
 *  up the SGWT JARs and the GWT SDK Library (perhaps the same project you use for Dev Mode).
 *  <p>
 *  <h4>Creating a Run Configuration for the Code Server</h4>
 *  <p>
 *  You must first create a new Run Configuration for the GWT Code Server.  To do this:<ul>
 *  <li> Right Click / Run As... / Run Configurations
 *  <li> Select "Java Application", and hit the "New" button
 *  <li> Set the title (very top) to something you'll remember
 *  <li> Set the "Main class" to <code>com.google.gwt.dev.codeserver.CodeServer</code>
 *  <li> If using GWT 2.6.1 or earlier, then in the "Classpath" tab, add
 *       <code>gwt-codeserver.jar</code> using the "Add External Jar" button
 *  <li> In the "Arguments" Tab, add entries for (at a minimum) the source path and 
 *       the module (package, plus name of your .gwt.xml file) - for example:
 *       <code>-src src/ com.smartgwt.sample.BuiltInDS</code></ul>
 *  <p>
 *  For the required JAR above, you can either 
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>download</a> a version of the
 * GWT SDK
 *  and extract the needed JAR, or locate it in your Eclipse installation (from the GWT Plugin).
 *  Additional arguments beyond those mentioned in the last step above are supported in the
 *  "Arguments" Tab, such as specifying a port, bind address, etc.  Your Run Configuration 
 *  should now be complete.
 *  <p>
 *  <h4>Configuring your GWT Project</h4>
 *  <p>
 *  A few additions to your GWT Project must be made if you're using a GWT SDK version older
 *  than 2.7.  (They are included as comments in the "Built in DS" sample GWT Project, 
 *  BuiltInDS.gwt.xml.)  If you're running GWT SDK 2.6 or older, you must add:
 *  <p>
 *  <code>&lt;add-linker name="xsiframe" /&gt;</code>
 *  <p>
 *  <h4>Running the Code Server</h4>
 *  <p>
 *  At this stage you should be able to start the code server:<ul>
 *  <li> Right Click / Run As... / Run Configurations 
 *  <li> Select the new configuration you added</ul>
 *  <p>
 *  You should see a bunch of logging in the console tab of Eclipse, followed by a URL.  Visit
 *  that URL in your browser, and drag the "Dev Mode On" and "Dev Mode Off" buttons up to your
 *  browser bookmarks toolbar.  These bookmarks allow you to easily switch to Super Dev Mode
 *  (recompiling your Web Application) or switch back to Production Mode.
 *  <p>
 *  <h4>Deploying your Web Application</h4>
 *  <p>
 *  You should now launch the "Web Application" Run Configuration that it was suggested you use -
 *  the simplest way is to Right Click on the Project / Run As / Web Application.  Visit the URL
 *  generated by Eclipse, without the <code>gwt.codesvr</code> parameter.  You may see a
 *  warning about needing a recompile - you can either ignore this or run a full compile once to
 *  get rid of it.  (If you've deployed your Web Application manually outside of Eclipse, this
 *  section can be skipped.)
 *  <p>
 *  <h4>Entering Super Dev Mode</h4>
 *  <p>
 *  Visit the Production Mode URL of the running Web Application.  The bookmarks created earlier
 *  can now be used to enter Super Dev Mode:<ul>
 *  <li>hit the "Dev Mode On" bookmark link
 *  <li>on the pop-up, select the button to "Compile"</ul>
 *  <p>
 *  If you make code changes, you can update Super Dev Mode using the "Dev Mode On" bookmark.
 *  <P>
 *  <h3>Super Dev Mode in Java 9+</h3>
 *  Starting with Java 9, it has been reported that the built-in Jetty server used by the GWT
 *  Plugin v3 no longer works, even with the latest GWT SDK 2.8.2, throwing either a
 *  <code>ClassNotFoundException</code> or <code>NoClassDefFoundError</code>, and potentially
 *  reporting, "Found resouce but unrecognized URL format."  Java 8 is still receiving updates,
 *  but may not be an option due to Oracle's 
 * <a
 * href='https://upperedge.com/oracle/using-java-heres-how-oracles-new-2019-java-se-licensing-affects-you/'
 * target='_blank'>new licensing requirements</a>.
 *  <P>
 *  Until the GWT Plugin v3 is updated, one solution is to use Tomcat Web Server as a replacement
 *  for Jetty.  You can read how to set up the GWT CodeServer to work with Tomcat
 * <a
 * href='https://gwt-plugins.github.io/documentation/gwt-eclipse-plugin/debugging/GWTDevModeAndTomcatWebServer.html'
 * target='_blank'>here</a>.  You can also add a comment to the
 * <a href='https://github.com/gwtproject/gwt/issues/9582' target='_blank'>GWT Jetty bug
 * report</a> to let them
 *  know you're affected.
 *  <P>
 *  <h3>Script Tags in Super Dev Mode</h3>
 *  <P>
 *  The official GWT Super Dev Mode linker (the default linker in GWT 2.7.0+) does not support
 *  including modules which load javascript files.  SmartGWT restores support for script tags
 *  by modifying some of the generated files with a post link step.  However, going forward
 *  it is recommended to migrate away from script tags in modules since we cannot control future
 *  changes to GWT that may introduce additional incompatibilities.
 *  <P>
 *  To avoid script tags if you're inheriting the standard module 
 *  <code>com.smartgwtee.SmartGwtEE</code>, you'll need to switch that to
 *  <code>com.smartgwtee.SmartGwtEENoScript</code>, and add the following
 *  lines to your bootstrap HTML file (under the "war" directory):
 *  <pre><code>
 *     &lt;script src="[app]/sc/modules/ISC_Core.js"&gt;          &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Foundation.js"&gt;    &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Containers.js"&gt;    &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Grids.js"&gt;         &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Forms.js"&gt;         &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_RichTextEditor.js"&gt;&lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Calendar.js"&gt;      &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_DataBinding.js"&gt;   &lt;/script&gt;
 * 
 *     &lt;script src="[app]/sc/skins/[skinname]/load_skin.js"&gt;&lt;/script&gt;</code></pre>
 *  In the above lines:<ul>
 *  <li>Replace "<code>[app]</code>" with the directory containing the "sc" lib - determined by
 *  the "rename-to" attribute in your .gwt.xml file -- for example "builtinds" or "dsdmi".
 *  <li>Replace "<code>[skinname]</code>" with the name of the skin you want to use -- for
 *  example "Enterprise" or "Graphite".</ul>
 *  <p>
 *  <h4>Understanding the Relevant Behavior of SDM</h4>
 *  <p>
 *  SmartGWT's custom linker generates a file named <code>loadScriptTagFiles.js</code> in the same
 *  directory as the GWT-generated file <code>&lt;moduleName&gt;.nocache.js</code> to force-load
 *  the script tags rejected by the SuperDevMode linker.  SmartGWT attempts to load
 *  <code>loadScriptTagFiles.js</code> directly in the root HTML page (see the BuiltInDS sample
 *  project), and also injects a hook directly into
 *  <code>&lt;moduleName&gt;.nocache.js</code> to load it.  If it's not loaded, or doesn't contain
 *  the required script files (typically Smart GWT Framework JS files), the GWT page won't
 *  load, errors will appear in the console,  and the browser will show a blank page.  Thus,
 *  it's important to understand when such problems may occur.
 *  <p>
 *  If you build your GWT project (GWT 2.7.0+, non-SDM) using a command-line tool such as
 * <a href='https://ant.apache.org/' target='_blank'>Ant</a>, or run SDM in Eclipse using the
 * CodeServer
 *  approach from above (for GWT Plugin version 2.6.x), then the root HTML page should pick up
 *  the correct <code>loadScriptTagFiles.js</code>.  However, if you're running GWT SuperDevMode
 *  as a Web Application using the latest GWT Plugin, the &lt;script&gt; tag in our root HTML
 *  page that normally loads <code>&lt;moduleName&gt;.nocache.js</code> really just triggers the
 *  delayed generation and loading of that file, and neither it nor
 *  <code>loadScriptTagFiles.js</code> is ever actually written to your war directory as
 *  configured in Eclipse.
 *  <p>
 *  More broadly stated, when SDM is run as a Web Application, all of the GWT linker output,
 *  including SmartGWT's custom linker output, is only available through the CodeServer URL (e.g.
 *  something like <code>http://localhost:9876/&lt;moduleName&gt;/...</code>), and that content
 *  is generated after the page has been loaded - so after the body of the root SmartGWT HTML
 *  page as already been run.  This is part of GWT's SuperDevMode architecture, so there's no way
 *  to avoid the delayed execution.
 *  <p>
 *  <h4>Troubleshooting Script Tag Loading in SDM</h4>
 *  <p>
 *  <i>How do you make sure the needed Smart GWT Framework script files are loaded when running
 *  SDM as a Web Application - that <code>loadScriptTagFiles.js</code> is valid?  The easiest way
 *  is probably just to run the GWT Plugin in Legacy Dev Mode once before running SDM (and again
 *  if you change your script tags).</i>  That mode can be toggled in the GWT Plugin tab of the
 *  Run or Debug Configuration in Eclipse.  This won't work if you're running SuperDevMode in GWT
 *  2.6.1, since the non-SDM linker for that release accepts script tags and thus Legacy Dev
 *  Mode doesn't generate <code>loadScriptTagFiles.js</code>.  In this case you should either run
 *  SDM using the older CodeServer approach, or you can navigate to the generated
 *  <code>loadScriptTagFiles.js</code> file (after you've attempted to run SDM at least once)
 *  using the URL <code>http://localhost:9876/&lt;moduleName&gt;/loadScriptTagFiles.js</code>,
 *  and "save as" the page into your Eclipse war directory.
 *  <p>
 *  <h4>Using Script Tags in IntelliJ IDEA</h4>
 *  <p>
 *  You may run into problems using script tags with the IntelliJ IDEA GWT Plugin that aren't
 *  fixed by following the advice above (for Eclipse).  The problem is that in IntelliJ, the
 *  <code>loadScriptTagFiles.js</code> file generated during GWT compilation is never persisted
 *  to the file system, even in "Legacy Dev Mode", which differs from the behavior in Eclipse.
 *  <p>
 *  To ensure that script tags are loaded properly, follow these steps:<ul>
 *  <li>Start "Legacy Dev Mode" just as we suggest for Eclipse
 *  <li>Create a directory for your module under the "war" directory in your project, either via
 *  an OS command shell, or via right-clicking on the "war" directory and selecting New >>
 *  Directory.  The directory name must match the module name defined at the top of your GWT
 *  module file.  For our BuiltInDS sample project, the name is "builtinds".
 *  <li>Open the module directory you just created in a browser (Firefox tested).  You don't need
 *  the Classic GWT Plugin.  For the BuiltInDS sample project, it will be at URL: 
 *  "http://127.0.0.1:8888/builtinds/".  You should see the file 
 *  <code>loadScriptTagFiles.js</code>.  Right click to "save link as" a file inside the module
 *  directory in the actual file system.
 *  <li>Now if you stop the server, and switch to SuperDevMode, that file should be present after
 *  the compile, and the required Framework files should get loaded.</ul>
 *  <p>
 *  <h3> Browser Source Map Support</h3>
 *  Most current browsers should support source maps, required for source debugging, as discussed
 * in {@link com.smartgwt.client.docs.Debugging Debugging: Dev Mode and Super Dev Mode}.  If
 * they're not working, make
 *  sure that they're enabled in the settings of your browser's developer tools.  For example, to
 *  enable them in Chrome, make sure the "Enable JavaScript Source Maps" checkbox is ticked in
 *  the Developer Tools preferences.  When the page is loaded and you've hit the "Dev Mode On"
 *  bookmark, you should be able to browse the Java source in the debugger (under the "sources
 *  tab"), and set breakpoints in Java code.
 *  <p>
 *  <h3><u>Troubleshooting</u></h3>
 *  <table width="90%" class="normal" align="center" border="1" cellpadding="5">
 *  <tr bgcolor="#b0b0b0">
 *   <td width="30%"><b>Problem</b></td>
 *   <td width="30%"><b>Possible Causes</b></td>
 *   <td width="40%"><b>Solution</b></td>
 *  </tr><tr>
 *  <td>Missing GWT classes or JARs are reported when project is compiled.</td>
 *  <td>GWT Eclipse Plugin with GWT SDK is not installed or project was built with version
 *   different from what's configured in Eclipse and needs to be rebuilt.</td>
 *  <td>Install plugin (ticking checkbox for GWT SDK) from 
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>here</a> and/or rebuild
 * project.</td>
 *  </tr><tr>
 *  <td>Error reported: "Could not find or load main class 
 *  com.google.gwt.dev.codeserver.<wbr>CodeServer".</td>
 *  <td>In GWT 2.6.1 and earlier, adding the GWT SDK library to your project's build path
 *  doesn't automatically add the gwt-codeserver.jar (included in the GWT SDK zip) to the build
 *  path.</td>
 *  <td>Add gwt-codeserver.jar as a separate JAR to the project build path.</td>
 *  </tr><tr>
 *  <td>Errors are reported by GWT about the "linker not supporting script tags" when your
 *  project is oompiled.</td>
 *  <td>The SmartGWT Linker has been enhanced to work around this issue, so you should no
 *  longer be affected by it when migrating from earlier GWT versions.</td>
 * <td>Report any remaining issues at <a href='http://forums.smartclient.com'
 * target='_blank'>http://forums.smartclient.com</a>.</td>
 *  </tr><tr>
 *  <td>Nothing happens when you visit the "Dev Mode On" bookmark.</td>
 *  <td>The GWT Code Server is not running or the bookmark is not valid.</td>
 *  <td>Start the Code Server or create new bookmarks from the URL displayed in the Eclipse
 *  console when the Code Server launches.</td>
 *  </tr><tr>
 *  <td>No GWT projects are found/available for recompiling when the modal dialog opens
 *  from clicking "Dev Mode On" bookmark, and you're running GWT 2.6 or earlier.</td>
 *  <td>Needed lines of the GWT Project file (gwt.xml) are missing or commented.</td>
 *  <td>Read section "Configuring your GWT Project" above and uncomment the appropriate
 *  gwt.xml lines based on your GWT version, or copy them from BuiltInDS.gwt.xml</td>
 *  </tr><tr>
 *  <td>When you launch your Web Application from Eclipse as directed above, you see an error
 *  in the browser indicating the GWT Plugin is missing (and perhaps that it's not available).
 *  </td><td>
 *  You've forgotten to remove the <code>gwt.codesvr</code> argument from the URL as
 *  we instructed above and the browser is not able to find the GWT Dev Mode Plugin.</td>
 *  <td>Remove the <code>gwt.codesvr</code> argument from the URL, or don't use the Eclipse GWT
 *  "Web Application" Run Configuration template (intended originally for Dev Mode) to launch
 *  your Web Application.  You may deploy your Web Application manually outside of Eclipse.</td>
 *  </tr><tr>
 *  <td>Skins aren't loaded when the application loads, resulting in missing icons and missized
 *  controls and fonts.  Failed file requests are logged by the browser, but no errors are
 *  reported by GWT in Eclipse.</td>
 *  <td>You've failed to set global variable <code>isomorphicDir</code> in the application's root
 *  HTML page, so the Framework is unable to locate the skin files.</td>
 *  <td>Add a <code>&lt;script&gt;</code> declaration in the root HTML page defining
 *  <code>isomorphicDir</code> to be "[MODULE_NAME]/sc", where the actual name of
 *  your project is substituted for the variable, as it appears in the
 *  <code>&lt;module&gt;</code> declaration in your project (gwt.xml) file.
 *  <p><br>
 *  For example, see the file <p><pre>helloworld-2.0/war/HelloWorld.html</pre><p> in the "Hello
 *  World" sample for SGWT LGPL, or the file <p><pre>built-in-ds/war/BuiltInDS.html</pre><p>
 *  in the "Built-in DS" sample for  SGWT EE.</td>
 *  </tr><tr>
 *  <td>When the SDM Server is launched in Eclipse, the SGWT Application fails to
 *  load, resource or configuration files are reported missing, or browser errors are hit
 *  because the core Smart GWT JavaScript Framework files haven't been loaded properly.  
 *  Missing symbols may be reported, such as "isc is not defined".
 *  </td><td>JavaScript Framework or linker-created files are missing from the war directory, or
 *  your GWT project uses script tags, but you're not using or have not merged your app's main
 *  page from the BuiltInDS Sample Project HTML.  The linkers used by GWT for SDM don't support
 *  script tags, but SGWT generates code to load them for you automatically.  However, this
 *  requires that your app's HTML load the file loadScriptTagFiles.js as in the BuiltInDS Sample
 *  Project.</td>
 *  <td>Make sure to run the GWT Plugin in <i>Legacy Dev Mode</i> at least once, to install the
 *  Framework resources and generate loadScriptTagFiles.js.  Then, if not already present, merge
 *  the line loading loadScriptTagFiles.js into your application's main HTML page from the
 *  BuiltInDS Sample Project.  (If you hit the latter issue, please add your opinion to the
 * <a href='https://github.com/gwtproject/gwt/issues/9149' target='_blank'>GWT Issue report</a> to
 * help
 *  get it resolved.)<br>
 *  Alternatively, you may run the Code Server Java app directly (even in GWT 2.7.0) rather than
 *  using the GWT SDM Server.  See the instructions above provided for GWT 2.6.x and ealier.</td>
 *  </tr><tr>
 *  <td>You're not able to connect to the SDM Code Server from a remote machine, even though
 *  you've launched it with -bindAddress 0.0.0.0 to enable all IP addresses to connect.</td>
 * <td>You're hitting a <a href='https://github.com/gwtproject/gwt/issues/8910'
 * target='_blank'>known issue</a>
 *  with SDM in GWT that affects any situation where the fully qualified server name is not
 *  available via DNS lookup on the client, even if you access the server by IP address.</td>
 *  <td>Ensure DNS lookup is available for the server on the client, or add a binding to your
 *  hosts files.</td>
 *  </tr><tr>
 *  <td>When SuperDevMode is run, Java exceptions are thrown and the server fails to start
 *  (e.g. ExecutionException, ClassNotFoundException, IllegalStateException, ...).</td><td>
 *  JARs in the <code>WEB&#8209;INF/lib</code> directory of the filesystem are interfering with
 *  those added by the SDM server.</td><td>Remove the contents of <code>WEB&#8209;INF/lib</code>
 *  at the filesystem level, using an OS shell or file explorer.  SDM will auomatically populate
 *  the served content of that directory using the project classpath when it's run.</td>
 *  </tr><tr>
 *  <td>An exception involving org.objectweb.asm.ClassVisitor near the top frame is thrown in
 *  Eclipse, and the project won't run.</td><td>
 *  You have a version conflict involving the 
 * <a href='https://asm.ow2.io/index.html' target='_blank'>asm JAR</a>.  GWT itself as well as
 * other JARs
 *  may depend on a specific version of the asm JAR.  In Eclipse, the classpath is distinct from
 *  JARs copied into your WEB-INF/lib directory, so the problem might also be that the version
 *  of asm in your classpath is right, but it should be removed from WEB-INF/lib.</td><td>
 *  Fix your classpath in Eclipse to pick up the proper asm JAR version, based on your GWT
 *  version, and other JAR dependencies, such as Hibernate and Spring.  If possible, Remove the
 *  asm JAR from your WEB-INF/lib directory.  To verify your project JAR dependencies you can
 *  manually
 * <a href='https://mvnrepository.com/artifact/com.google.gwt/gwt-dev/2.9.0' target='_blank'>check
 * Maven</a>,
 * or to have Maven automatically manage your dependencies, see {@link
 * com.smartgwt.client.docs.MavenSupport}.
 *  To run our BuiltInDS sample project with GWT 2.9.0, ensure asm-8.x is in your classpath but
 *  not WEB-INF/lib.</td>
 *  </tr></table>
 *  <p><b>
 *  A useful discussion of some other problems and solutions related to GWT Super Dev Mode can be
 * found <a href='http://stackoverflow.com/questions/18330001/super-dev-mode-in-gwt'
 * target='_blank'>here</a>.
 *  </b>
     * @see com.smartgwt.client.docs.Debugging
 */
public interface SuperDevModeTroubleshooting {
}
