package com.smartgwt.sample.client;

import com.google.gwt.core.client.EntryPoint;
import com.smartgwt.client.core.KeyIdentifier;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;

import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.util.*;


/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class MultiWinPOC implements EntryPoint {

    String windowName;

    /**
     * This is the entry point method.
     */
    public void onModuleLoad() {
        KeyIdentifier debugKey = new KeyIdentifier();
        debugKey.setCtrlKey(true);
        debugKey.setKeyName("D");

        Page.registerKey(debugKey, new PageKeyHandler() {
            public void execute(String keyName) {
                SC.showConsole();
            }
        });

        NotifySettings settings = new NotifySettings();
        settings.setPosition(EdgeName.T);
        Notify.configureDefaultSettings(settings);

        if (MultiWindow.isMainWindow()) {
            // no OpenFin; use MW fallback mode
            if (!Browser.getIsOpenFin()) {
                Browser.setIsMultiWindow(true);
            }
            // setup initial DataContext to share
            DataContextPane.setupInitialDataContext();
            ApplicationContext.setupSharedInstance();

            // load supplyItem DS into main window
            DataSource.load("supplyItem", null);
        }

        windowName = MultiWindow.getLocalWindow().getName();
        Page.setTitle("MultiWindow PoC [" + windowName + "]");

        TabSet tabSet = new TabSet();
        Tab windowsTab = new Tab("Windows");
        windowsTab.setPane(new WindowsPane());

        Tab dataContextTab = new Tab("DataContext");
        dataContextTab.setPane(new DataContextPane());

        Tab dataSourcesTab = new Tab("DataSources");
        dataSourcesTab.setPane(new DataSourcePane());

        tabSet.setTabs(windowsTab, dataContextTab, dataSourcesTab);

        if (SC.hasRealtimeMessaging()) {
            Tab messagingTab   = new Tab("Messaging");
            messagingTab.setPane(new MessagingPane());
            tabSet.addTab(messagingTab);
        }

        SectionStackSection section = new SectionStackSection(windowName);
        section.setCanCollapse(false);
        section.addItem(tabSet);

        SectionStack theApp = new SectionStack();
        theApp.setWidth("100%");
        theApp.setHeight("100%");
        theApp.addSection(section);

        theApp.draw();
    }

}
