/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class HTMLPanel
extends ComplexPanel {
    private static com.google.gwt.dom.client.Element hiddenDiv;

    public static String createUniqueId() {
        return Document.get().createUniqueId();
    }

    public static HTMLPanel wrap(com.google.gwt.dom.client.Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        HTMLPanel html = new HTMLPanel(element);
        html.onAttach();
        RootPanel.detachOnWindowClose(html);
        return html;
    }

    public HTMLPanel(@IsSafeHtml String html) {
        this.setElement(Document.get().createDivElement());
        this.getElement().setInnerHTML(html);
    }

    public HTMLPanel(SafeHtml safeHtml) {
        this(safeHtml.asString());
    }

    @SuppressIsSafeHtmlCastCheck
    public HTMLPanel(String tag, @IsSafeHtml String html) {
        if ("".equals(html)) {
            this.setElement(Document.get().createElement(tag));
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append('<').append(tag).append('>').append(html);
        b.append("</").append(tag).append('>');
        DivElement scratchDiv = Document.get().createDivElement();
        scratchDiv.setInnerHTML(b.toString());
        this.setElement(scratchDiv.getFirstChildElement());
        this.getElement().removeFromParent();
    }

    private HTMLPanel(com.google.gwt.dom.client.Element elem) {
        this.setElement(elem);
    }

    @Override
    public void add(Widget widget) {
        this.add(widget, this.getElement());
    }

    public void add(Widget widget, String id) {
        Element elem = this.getElementById(id);
        if (elem == null) {
            throw new NoSuchElementException(id);
        }
        this.add(widget, (com.google.gwt.dom.client.Element)elem);
    }

    @Override
    public void add(Widget widget, com.google.gwt.dom.client.Element elem) {
        super.add(widget, elem);
    }

    public final void addAndReplaceElement(Widget widget, com.google.gwt.dom.client.Element toReplace) {
        this.addAndReplaceElement(widget, DOM.asOld(toReplace));
    }

    @Deprecated
    public void addAndReplaceElement(Widget widget, Element toReplace) {
        if (toReplace == widget.getElement()) {
            return;
        }
        widget.removeFromParent();
        Widget toRemove = null;
        Iterator<Widget> children = this.getChildren().iterator();
        while (children.hasNext()) {
            Widget next = children.next();
            if (!toReplace.isOrHasChild(next.getElement())) continue;
            if (next.getElement() == toReplace) {
                toRemove = next;
                break;
            }
            children.remove();
        }
        this.getChildren().add(widget);
        if (toRemove == null) {
            toReplace.getParentNode().replaceChild(widget.getElement(), toReplace);
        } else {
            toReplace.getParentNode().insertBefore(widget.getElement(), toReplace);
            this.remove(toRemove);
        }
        this.adopt(widget);
    }

    @Deprecated
    public void addAndReplaceElement(IsWidget widget, Element toReplace) {
        this.addAndReplaceElement(widget.asWidget(), toReplace);
    }

    public void addAndReplaceElement(IsWidget widget, com.google.gwt.dom.client.Element toReplace) {
        this.addAndReplaceElement(widget.asWidget(), toReplace);
    }

    public void addAndReplaceElement(Widget widget, String id) {
        Element toReplace = this.getElementById(id);
        if (toReplace == null) {
            throw new NoSuchElementException(id);
        }
        this.addAndReplaceElement(widget, (com.google.gwt.dom.client.Element)toReplace);
    }

    public void addAndReplaceElement(IsWidget widget, String id) {
        this.addAndReplaceElement(widget.asWidget(), id);
    }

    public Element getElementById(String id) {
        com.google.gwt.dom.client.Element elem = this.isAttached() ? Document.get().getElementById(id) : this.attachToDomAndGetElement(id);
        return DOM.asOld(elem);
    }

    private com.google.gwt.dom.client.Element attachToDomAndGetElement(String id) {
        if (hiddenDiv == null) {
            hiddenDiv = Document.get().createDivElement();
            UIObject.setVisible(hiddenDiv, false);
            RootPanel.getBodyElement().appendChild(hiddenDiv);
        }
        com.google.gwt.dom.client.Element origParent = this.getElement().getParentElement();
        com.google.gwt.dom.client.Element origSibling = this.getElement().getNextSiblingElement();
        hiddenDiv.appendChild(this.getElement());
        com.google.gwt.dom.client.Element child = Document.get().getElementById(id);
        if (origParent != null) {
            origParent.insertBefore(this.getElement(), origSibling);
        } else {
            hiddenDiv.removeChild(this.getElement());
        }
        return child;
    }
}

