/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * User Interface component allowing a user to add a new saved search or edit an existing search.  Automatically used by
 * {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem} and {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getCanSaveSearches ListGrid.canSaveSearches}; cannot be used directly and is
 * documented only for skinning and internationalization purposes.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("SavedSearchEditor")
public class SavedSearchEditor extends VLayout {

    public static SavedSearchEditor getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new SavedSearchEditor(jsObj);
        } else {
            assert refInstance instanceof SavedSearchEditor;
            return (SavedSearchEditor)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(SavedSearchEditor.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.SavedSearchEditor.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(SavedSearchEditor.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.SavedSearchEditor.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public SavedSearchEditor(){
        scClassName = "SavedSearchEditor";
    }

    public SavedSearchEditor(JavaScriptObject jsObj){
        scClassName = "SavedSearchEditor";
        setJavaScriptObject(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * 
     *
     * @param addSearchText New addSearchText value. Default value is "Enter a name for your Saved View, then enter criteria below."
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setAddSearchText(String addSearchText)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("addSearchText", addSearchText, false);
    }

    /**
     * 
     *
     * @return Current addSearchText value. Default value is "Enter a name for your Saved View, then enter criteria below."
     */
    public String getAddSearchText()  {
        return getAttributeAsString("addSearchText");
    }
    

    /**
     * Button used to cancel changes.
     * <p>
     * This component is an AutoChild named "cancelButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current cancelButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public IButton getCancelButton() throws IllegalStateException {
        errorIfNotCreated("cancelButton");
        return (IButton)IButton.getByJSObject(getAttributeAsJavaScriptObject("cancelButton"));
    }
    

    /**
     * Checkbox shown when {@link com.smartgwt.client.widgets.SavedSearchEditor#getIsAdmin isAdmin} is true and the current
     * search is marked as a shared search (via the {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox}), allowing an admin to
     * designate a search  as the default search for users that have not chosen some other search as their default. <P> If
     * checked, the {@link com.smartgwt.client.data.SavedSearches#setDefaultAdminSearchOperation
     * SavedSearches.setDefaultAdminSearchOperation} will be invoked  after the search being edited has been saved. This will
     * typically be invoked as a {@link com.smartgwt.client.rpc.RPCManager#startQueue queued request} in the same transaction
     * that adds or updates the search being edited. <P> See the <b>Saving default searches</b> section of the {@link
     * com.smartgwt.client.data.SavedSearches SavedSearches overview} for more information on marking searches as a default.
     * <P> Only ever appears if there is a {@link com.smartgwt.client.data.SavedSearches#getAdminDefaultField
     * SavedSearches.adminDefaultField} in the {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource
     * SavedSearches.defaultDataSource}. <p> Titled with {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getDefaultSearchTitle defaultSearchTitle}.
     * <p>
     * This component is an AutoChild named "defaultSearchCheckbox".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current defaultSearchCheckbox value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public CheckboxItem getDefaultSearchCheckbox() throws IllegalStateException {
        errorIfNotCreated("defaultSearchCheckbox");
        return CheckboxItem.getOrCreateRef(getAttributeAsJavaScriptObject("defaultSearchCheckbox"));
    }
    

    /**
     * Title for the {@link com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox}.
     *
     * @param defaultSearchTitle New defaultSearchTitle value. Default value is "Mark as default"
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setDefaultSearchTitle(String defaultSearchTitle)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("defaultSearchTitle", defaultSearchTitle, false);
    }

    /**
     * Title for the {@link com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox}.
     *
     * @return Current defaultSearchTitle value. Default value is "Mark as default"
     */
    public String getDefaultSearchTitle()  {
        return getAttributeAsString("defaultSearchTitle");
    }
    

    /**
     * 
     *
     * @param editSearchText New editSearchText value. Default value is "Enter a new name for your Saved View, and edit criteria below."
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setEditSearchText(String editSearchText)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("editSearchText", editSearchText, false);
    }

    /**
     * 
     *
     * @return Current editSearchText value. Default value is "Enter a new name for your Saved View, and edit criteria below."
     */
    public String getEditSearchText()  {
        return getAttributeAsString("editSearchText");
    }
    

    /**
     * FilterBuilder used to enter criteria. <p> By default, {@link
     * com.smartgwt.client.widgets.form.FilterBuilder#getTopOperatorAppearance FilterBuilder.topOperatorAppearance} is set to
     * "radio" (considered the simpler mode) and {@link com.smartgwt.client.widgets.form.FilterBuilder#getShowModeSwitcher
     * FilterBuilder.showModeSwitcher} is set true. <p> If existing criteria cannot be displayed in simple ("radio") mode,
     * advanced mode is automatically chosen.
     * <p>
     * This component is an AutoChild named "filterBuilder".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current filterBuilder value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public FilterBuilder getFilterBuilder() throws IllegalStateException {
        errorIfNotCreated("filterBuilder");
        return (FilterBuilder)FilterBuilder.getByJSObject(getAttributeAsJavaScriptObject("filterBuilder"));
    }
    

    /**
     * 
     *
     * @param gridAddSearchText New gridAddSearchText value. Default value is "Enter a name for your Saved View. The current configuration and filter criteria of the grid will be saved."
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setGridAddSearchText(String gridAddSearchText)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("gridAddSearchText", gridAddSearchText, false);
    }

    /**
     * 
     *
     * @return Current gridAddSearchText value. Default value is "Enter a name for your Saved View. The current configuration and filter criteria of the grid will be saved."
     */
    public String getGridAddSearchText()  {
        return getAttributeAsString("gridAddSearchText");
    }
    

    /**
     * Whether the editor is in admin mode, in which case the {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox} appears to allow admins to
     * define shared searches, and the {@link com.smartgwt.client.widgets.SavedSearchEditor#getDefaultSearchCheckbox
     * defaultSearchCheckbox} appears to enable an admin to designate a search as the (shared) default. <p> If {@link
     * com.smartgwt.client.data.SavedSearches#getAdminRole SavedSearches.adminRole} is defined and {@link
     * com.smartgwt.client.util.Authentication#hasRole Authentication.hasRole()} indicates the current user has the
     * <code>adminRole</code>, <code>isAdmin</code> is true by default, otherwise false.
     *
     * @param isAdmin New isAdmin value. Default value is null
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setIsAdmin(Boolean isAdmin)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("isAdmin", isAdmin, false);
    }

    /**
     * Whether the editor is in admin mode, in which case the {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox} appears to allow admins to
     * define shared searches, and the {@link com.smartgwt.client.widgets.SavedSearchEditor#getDefaultSearchCheckbox
     * defaultSearchCheckbox} appears to enable an admin to designate a search as the (shared) default. <p> If {@link
     * com.smartgwt.client.data.SavedSearches#getAdminRole SavedSearches.adminRole} is defined and {@link
     * com.smartgwt.client.util.Authentication#hasRole Authentication.hasRole()} indicates the current user has the
     * <code>adminRole</code>, <code>isAdmin</code> is true by default, otherwise false.
     *
     * @return Current isAdmin value. Default value is null
     */
    public Boolean getIsAdmin()  {
        return getAttributeAsBoolean("isAdmin");
    }
    

    /**
     * In "normal" the search editor shows a {@link com.smartgwt.client.widgets.form.FilterBuilder} for editing criteria.  In
     * "grid" mode there is only a field for naming (or renaming) a search, since the grid has built-in interfaces for editing
     * criteria.
     *
     * @param mode New mode value. Default value is "normal"
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setMode(SearchEditorMode mode)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("mode", mode == null ? null : mode.getValue(), false);
    }

    /**
     * In "normal" the search editor shows a {@link com.smartgwt.client.widgets.form.FilterBuilder} for editing criteria.  In
     * "grid" mode there is only a field for naming (or renaming) a search, since the grid has built-in interfaces for editing
     * criteria.
     *
     * @return Current mode value. Default value is "normal"
     */
    public SearchEditorMode getMode()  {
        return EnumUtil.getEnum(SearchEditorMode.values(), getAttribute("mode"));
    }
    

    /**
     * Confirmation message to show when a user attempts to save a view with a searchName, componentID, and (if present)
     * screenID / projectID which collides with another existing  saved view. <P> This is the message that will be shown in a
     * confirmation dialog if, for example, a user attempts to save a new view with the same name as an existing saved view for
     * the same grid.
     *
     * @param overwriteSearchConfirmationMessage New overwriteSearchConfirmationMessage value. Default value is "There is already a Saved View with this name - Overwrite?"
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     */
    public SavedSearchEditor setOverwriteSearchConfirmationMessage(String overwriteSearchConfirmationMessage) {
        return (SavedSearchEditor)setAttribute("overwriteSearchConfirmationMessage", overwriteSearchConfirmationMessage, true);
    }

    /**
     * Confirmation message to show when a user attempts to save a view with a searchName, componentID, and (if present)
     * screenID / projectID which collides with another existing  saved view. <P> This is the message that will be shown in a
     * confirmation dialog if, for example, a user attempts to save a new view with the same name as an existing saved view for
     * the same grid.
     *
     * @return Current overwriteSearchConfirmationMessage value. Default value is "There is already a Saved View with this name - Overwrite?"
     */
    public String getOverwriteSearchConfirmationMessage()  {
        return getAttributeAsString("overwriteSearchConfirmationMessage");
    }
    

    /**
     * Confirmation message to show when a user attempts to save a view with a searchName, componentID, and (if present)
     * screenID / projectID which collides with another existing  shared saved view. <P> This is the message that will be shown
     * in a confirmation dialog if, for example, a user attempts to save a new view with the same name as an existing shared
     * saved view for the same grid.
     *
     * @param overwriteSharedSearchConfirmationMessage New overwriteSharedSearchConfirmationMessage value. Default value is "There is already a shared Saved View with this name - Overwrite?"
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     */
    public SavedSearchEditor setOverwriteSharedSearchConfirmationMessage(String overwriteSharedSearchConfirmationMessage) {
        return (SavedSearchEditor)setAttribute("overwriteSharedSearchConfirmationMessage", overwriteSharedSearchConfirmationMessage, true);
    }

    /**
     * Confirmation message to show when a user attempts to save a view with a searchName, componentID, and (if present)
     * screenID / projectID which collides with another existing  shared saved view. <P> This is the message that will be shown
     * in a confirmation dialog if, for example, a user attempts to save a new view with the same name as an existing shared
     * saved view for the same grid.
     *
     * @return Current overwriteSharedSearchConfirmationMessage value. Default value is "There is already a shared Saved View with this name - Overwrite?"
     */
    public String getOverwriteSharedSearchConfirmationMessage()  {
        return getAttributeAsString("overwriteSharedSearchConfirmationMessage");
    }
    

    /**
     * Label at the top of the interface, used to show instruction text, which is either {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getAddSearchText addSearchText} or {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getEditSearchText editSearchText} depending on whether the user is editing
     * a pre-existing search. <p> For {@link com.smartgwt.client.widgets.SavedSearchEditor#getMode grid mode}, when adding a
     * new search, the instructions text is {@link com.smartgwt.client.widgets.SavedSearchEditor#getGridAddSearchText
     * gridAddSearchText} instead.
     * <p>
     * This component is an AutoChild named "promptLabel".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current promptLabel value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Label getPromptLabel() throws IllegalStateException {
        errorIfNotCreated("promptLabel");
        return (Label)Label.getByJSObject(getAttributeAsJavaScriptObject("promptLabel"));
    }
    

    /**
     * Button used to save changes.
     * <p>
     * This component is an AutoChild named "saveButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current saveButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public IButton getSaveButton() throws IllegalStateException {
        errorIfNotCreated("saveButton");
        return (IButton)IButton.getByJSObject(getAttributeAsJavaScriptObject("saveButton"));
    }
    

    /**
     * TextItem where the user enters the name for the saved search.
     * <p>
     * This component is an AutoChild named "searchNameItem".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current searchNameItem value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public TextItem getSearchNameItem() throws IllegalStateException {
        errorIfNotCreated("searchNameItem");
        return TextItem.getOrCreateRef(getAttributeAsJavaScriptObject("searchNameItem"));
    }
    

    /**
     * Checkbox shown when {@link com.smartgwt.client.widgets.SavedSearchEditor#getIsAdmin isAdmin} is true, allowing an admin
     * to designate a search as an admin search that all users will see.  Titled with {@link
     * com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchTitle sharedSearchTitle}.
     * <p>
     * This component is an AutoChild named "sharedSearchCheckbox".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current sharedSearchCheckbox value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public CheckboxItem getSharedSearchCheckbox() throws IllegalStateException {
        errorIfNotCreated("sharedSearchCheckbox");
        return CheckboxItem.getOrCreateRef(getAttributeAsJavaScriptObject("sharedSearchCheckbox"));
    }
    

    /**
     * Title for the {@link com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox}.
     *
     * @param sharedSearchTitle New sharedSearchTitle value. Default value is "Shared view (all users will see it)"
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public SavedSearchEditor setSharedSearchTitle(String sharedSearchTitle)  throws IllegalStateException {
        return (SavedSearchEditor)setAttribute("sharedSearchTitle", sharedSearchTitle, false);
    }

    /**
     * Title for the {@link com.smartgwt.client.widgets.SavedSearchEditor#getSharedSearchCheckbox sharedSearchCheckbox}.
     *
     * @return Current sharedSearchTitle value. Default value is "Shared view (all users will see it)"
     */
    public String getSharedSearchTitle()  {
        return getAttributeAsString("sharedSearchTitle");
    }
    

    /**
     * Notification message to show to the user in a warn dialog when an attempted save fails due to server validation
     * error(s). <P> Validation errors will be appended to this string in the format <i>fieldName: errorMessage</i>.
     *
     * @param validationFailedMessage New validationFailedMessage value. Default value is "A validation failure occurred:&lt;br&gt;"
     * @return {@link com.smartgwt.client.widgets.SavedSearchEditor SavedSearchEditor} instance, for chaining setter calls
     */
    public SavedSearchEditor setValidationFailedMessage(String validationFailedMessage) {
        return (SavedSearchEditor)setAttribute("validationFailedMessage", validationFailedMessage, true);
    }

    /**
     * Notification message to show to the user in a warn dialog when an attempted save fails due to server validation
     * error(s). <P> Validation errors will be appended to this string in the format <i>fieldName: errorMessage</i>.
     *
     * @return Current validationFailedMessage value. Default value is "A validation failure occurred:&lt;br&gt;"
     */
    public String getValidationFailedMessage()  {
        return getAttributeAsString("validationFailedMessage");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param savedSearchEditorProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(SavedSearchEditor savedSearchEditorProperties) /*-{
        if (savedSearchEditorProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(SavedSearchEditor.@java.lang.Object::getClass()(), "setDefaultProperties", savedSearchEditorProperties.@java.lang.Object::getClass()());
        }
        savedSearchEditorProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = savedSearchEditorProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.SavedSearchEditor.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(SavedSearchEditorLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.addSearchText = getAttributeAsString("addSearchText");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.addSearchText:" + t.getMessage() + "\n";
        }
        try {
            s.defaultSearchTitle = getAttributeAsString("defaultSearchTitle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.defaultSearchTitle:" + t.getMessage() + "\n";
        }
        try {
            s.editSearchText = getAttributeAsString("editSearchText");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.editSearchText:" + t.getMessage() + "\n";
        }
        try {
            s.gridAddSearchText = getAttributeAsString("gridAddSearchText");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.gridAddSearchText:" + t.getMessage() + "\n";
        }
        try {
            s.isAdmin = getAttributeAsString("isAdmin");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.isAdmin:" + t.getMessage() + "\n";
        }
        try {
            s.mode = getAttributeAsString("mode");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.mode:" + t.getMessage() + "\n";
        }
        try {
            s.overwriteSearchConfirmationMessage = getAttributeAsString("overwriteSearchConfirmationMessage");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.overwriteSearchConfirmationMessage:" + t.getMessage() + "\n";
        }
        try {
            s.overwriteSharedSearchConfirmationMessage = getAttributeAsString("overwriteSharedSearchConfirmationMessage");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.overwriteSharedSearchConfirmationMessage:" + t.getMessage() + "\n";
        }
        try {
            s.sharedSearchTitle = getAttributeAsString("sharedSearchTitle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.sharedSearchTitle:" + t.getMessage() + "\n";
        }
        try {
            s.validationFailedMessage = getAttributeAsString("validationFailedMessage");
        } catch (Throwable t) {
            s.logicalStructureErrors += "SavedSearchEditor.validationFailedMessage:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        SavedSearchEditorLogicalStructure s = new SavedSearchEditorLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
