/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a request to AI to generate summaries of records, using data in the records, relevant general knowledge, and
 * reasonable inferences from the data. Summaries may include relevant supplemental information for each record. <p> The
 * provided {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records} are split into batches of varying
 * lengths (see {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getMaxRecordsPerBatch maxRecordsPerBatch}). For each
 * batch, a {@link com.smartgwt.client.ai.SummarizeRecordsPartialResult} will be generated with either information about
 * the reason for a non-successful outcome, or the generated summaries for records in the batch.
 */
@BeanFactory.FrameworkClass
public class SummarizeRecordsRequest extends DataBoundAIRequest {

    public static SummarizeRecordsRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof SummarizeRecordsRequest) {
            existingObj.setJsObj(jsObj);
            return (SummarizeRecordsRequest)existingObj;
        } else

        {
            return new SummarizeRecordsRequest(jsObj);
        }
    }
        


    public SummarizeRecordsRequest(){
        
    }

    public SummarizeRecordsRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * The {@link com.smartgwt.client.ai.AIFieldRequest} generated from a natural language description of how to summarize each
     * record, which may include a request for relevant supplemental information.
     *
     * @param aiFieldRequest New aiFieldRequest value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.ai.AI#buildAIFieldRequest
     */
    public SummarizeRecordsRequest setAIFieldRequest(AIFieldRequest aiFieldRequest) {
        return (SummarizeRecordsRequest)setAttribute("aiFieldRequest", aiFieldRequest == null ? null : aiFieldRequest.getJsObj());
    }

    /**
     * The {@link com.smartgwt.client.ai.AIFieldRequest} generated from a natural language description of how to summarize each
     * record, which may include a request for relevant supplemental information.
     *
     * @return Current aiFieldRequest value. Default value is null
     * @see com.smartgwt.client.ai.AI#buildAIFieldRequest
     */
    public AIFieldRequest getAIFieldRequest()  {
        return new AIFieldRequest(getAttributeAsJavaScriptObject("aiFieldRequest"));
    }
    

    /**
     * The source of the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest aiFieldRequest}.
     *
     * @param aiFieldRequestSource New aiFieldRequestSource value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setAiFieldRequestSource(AIMessageSource aiFieldRequestSource) {
        return (SummarizeRecordsRequest)setAttribute("aiFieldRequestSource", aiFieldRequestSource == null ? null : aiFieldRequestSource.getValue());
    }

    /**
     * The source of the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest aiFieldRequest}.
     *
     * @return Current aiFieldRequestSource value. Default value is null
     */
    public AIMessageSource getAiFieldRequestSource()  {
        return EnumUtil.getEnum(AIMessageSource.values(), getAttribute("aiFieldRequestSource"));
    }
    

    /**
     * If provided, the {@link com.smartgwt.client.util.CancellationController} that will be looked to for whether the record
     * summarization operation is canceled.
     *
     * @param cancellationController New cancellationController value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setCancellationController(CancellationController cancellationController) {
        return (SummarizeRecordsRequest)setAttribute("cancellationController", cancellationController == null ? null : cancellationController.getOrCreateJsObj());
    }

    /**
     * If provided, the {@link com.smartgwt.client.util.CancellationController} that will be looked to for whether the record
     * summarization operation is canceled.
     *
     * @return Current cancellationController value. Default value is null
     */
    public CancellationController getCancellationController()  {
        return CancellationController.getOrCreateRef(getAttributeAsJavaScriptObject("cancellationController"));
    }
    

    /**
     * If specified, the {@link com.smartgwt.client.widgets.DataBoundComponent} that is displaying or managing the {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records}. <p> The component should be bound to the same {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getDataSource dataSource} of the request or a <code>DataSource</code>
     * inheriting from it.
     *
     * @param component New component value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setComponent(DataBoundComponent component) {
        return (SummarizeRecordsRequest)setAttribute("component", component == null ? null : ((Canvas)component).getOrCreateJsObj());
    }

    /**
     * If specified, the {@link com.smartgwt.client.widgets.DataBoundComponent} that is displaying or managing the {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records}. <p> The component should be bound to the same {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getDataSource dataSource} of the request or a <code>DataSource</code>
     * inheriting from it.
     *
     * @return Current component value. Default value is null
     */
    public DataBoundComponent getComponent()  {
        return (DataBoundComponent)Canvas.getByJSObject(getAttributeAsJavaScriptObject("component"));
    }
    

    /**
     * The {@link com.smartgwt.client.data.DataSource} containing the {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records}. <p> If {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getComponent component} is also specified, then the component should be
     * bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setDataSource(DataSource dataSource) {
        return (SummarizeRecordsRequest)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj());
    }

    /**
     * The {@link com.smartgwt.client.data.DataSource} containing the {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getRecords records}. <p> If {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getComponent component} is also specified, then the component should be
     * bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @return Current dataSource value. Default value is null
     */
    public DataSource getDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("dataSource"));
    }
    

    /**
     * Maximum number of batches being summarized at any given time.
     *
     * @param maxConcurrent New maxConcurrent value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setMaxConcurrent(Integer maxConcurrent) {
        return (SummarizeRecordsRequest)setAttribute("maxConcurrent", maxConcurrent);
    }

    /**
     * Maximum number of batches being summarized at any given time.
     *
     * @return Current maxConcurrent value. Default value is null
     */
    public Integer getMaxConcurrent()  {
        return getAttributeAsInt("maxConcurrent");
    }
    

    /**
     * If set, the maximum number of records that will be processed via AI in a single request. This can be further or
     * alternatively limited by the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest aiFieldRequest}'s
     * {@link com.smartgwt.client.ai.AIFieldRequest#getMaxRecordsPerBatch maxRecordsPerBatch} setting. <p> By default, requests
     * will be filled with as many records as will fit into a single request to the selected {@link
     * com.smartgwt.client.ai.AIEngine}(s).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param maxRecordsPerBatch New maxRecordsPerBatch value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setMaxRecordsPerBatch(Integer maxRecordsPerBatch) {
        return (SummarizeRecordsRequest)setAttribute("maxRecordsPerBatch", maxRecordsPerBatch);
    }

    /**
     * If set, the maximum number of records that will be processed via AI in a single request. This can be further or
     * alternatively limited by the {@link com.smartgwt.client.ai.SummarizeRecordsRequest#getAIFieldRequest aiFieldRequest}'s
     * {@link com.smartgwt.client.ai.AIFieldRequest#getMaxRecordsPerBatch maxRecordsPerBatch} setting. <p> By default, requests
     * will be filled with as many records as will fit into a single request to the selected {@link
     * com.smartgwt.client.ai.AIEngine}(s).
     *
     * @return Current maxRecordsPerBatch value. Default value is null
     */
    public Integer getMaxRecordsPerBatch()  {
        return getAttributeAsInt("maxRecordsPerBatch");
    }
    

    /**
     * The maximum number of retries of any one particular request to an {@link com.smartgwt.client.ai.AIEngine}.
     *
     * @param maxRetries New maxRetries value. Default value is 2
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setMaxRetries(Integer maxRetries) {
        return (SummarizeRecordsRequest)setAttribute("maxRetries", maxRetries);
    }

    /**
     * The maximum number of retries of any one particular request to an {@link com.smartgwt.client.ai.AIEngine}.
     *
     * @return Current maxRetries value. Default value is 2
     */
    public Integer getMaxRetries()  {
        return getAttributeAsInt("maxRetries");
    }
    

    /**
     * The records to summarize, from {@link com.smartgwt.client.data.DataSource} {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getDataSource dataSource}.
     *
     * @param records New records value. Default value is null
     * @return {@link com.smartgwt.client.ai.SummarizeRecordsRequest SummarizeRecordsRequest} instance, for chaining setter calls
     */
    public SummarizeRecordsRequest setRecords(Record... records) {
        return (SummarizeRecordsRequest)setAttribute("records", records);
    }

    /**
     * The records to summarize, from {@link com.smartgwt.client.data.DataSource} {@link
     * com.smartgwt.client.ai.SummarizeRecordsRequest#getDataSource dataSource}.
     *
     * @return Current records value. Default value is null
     */
    public Record[] getRecords()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfRecord(getAttributeAsJavaScriptObject("records"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
