package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 */
public enum WaitForType implements ValueEnum {
    /**
     * wait for a specific amount of time
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "duration".
     */
    DURATION("duration"),
    /**
     * wait for the page to become quiet as reported by {@link com.smartgwt.client.util.AutoTest#isSystemDone
     * AutoTest.isSystemDone()}.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "systemDone".
     */
    SYSTEMDONE("systemDone"),
    /**
     * wait for a specific {@link com.smartgwt.client.docs.AutoTestLocator} to become ready.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "locator".
     */
    LOCATOR("locator");
    private String value;

    WaitForType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
