/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractNativeScrollbar;
import com.google.gwt.user.client.ui.AttachDetachException;
import com.google.gwt.user.client.ui.HorizontalScrollbar;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.NativeHorizontalScrollbar;
import com.google.gwt.user.client.ui.NativeVerticalScrollbar;
import com.google.gwt.user.client.ui.ResizeLayoutPanel;
import com.google.gwt.user.client.ui.ScrollImpl;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalScrollbar;
import com.google.gwt.user.client.ui.Widget;

public class CustomScrollPanel
extends ScrollPanel {
    private static Resources DEFAULT_RESOURCES;
    private static int IGNORE_SCROLL_TIMEOUT;
    private boolean alwaysShowScrollbars;
    private final ResizeLayoutPanel.Impl containerResizeImpl = (ResizeLayoutPanel.Impl)GWT.create(ResizeLayoutPanel.Impl.class);
    private final com.google.gwt.dom.client.Element cornerElem;
    private final Layout.Layer cornerLayer;
    private double ignoreContentUntil = 0.0;
    private double ignoreScrollbarsUntil = 0.0;
    private final Layout layout;
    private final Layout.Layer scrollableLayer;
    private HorizontalScrollbar hScrollbar;
    private int hScrollbarHeight;
    private HandlerRegistration hScrollbarHandler;
    private Layout.Layer hScrollbarLayer;
    private VerticalScrollbar vScrollbar;
    private int vScrollbarWidth;
    private HandlerRegistration vScrollbarHandler;
    private Layout.Layer vScrollbarLayer;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public CustomScrollPanel() {
        this(CustomScrollPanel.getDefaultResources());
    }

    public CustomScrollPanel(Resources resources) {
        super(DOM.createDiv(), DOM.createDiv(), DOM.createDiv());
        Style style = resources.customScrollPanelStyle();
        style.ensureInjected();
        this.setStyleName(style.customScrollPanel());
        this.layout = new Layout(this.getElement());
        Element containerElem = this.getContainerElement();
        containerElem.setClassName(CommonResources.getInlineBlockStyle());
        Element scrollable = this.getScrollableElement();
        scrollable.getStyle().setOverflow(Style.Overflow.SCROLL);
        scrollable.appendChild(containerElem);
        this.scrollableLayer = this.layout.attachChild(scrollable);
        this.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.cornerElem = Document.get().createDivElement();
        this.cornerElem.addClassName(style.customScrollPanelCorner());
        this.cornerLayer = this.layout.attachChild(this.cornerElem);
        NativeHorizontalScrollbar.Resources hResources = (NativeHorizontalScrollbar.Resources)GWT.create(NativeHorizontalScrollbar.ResourcesTransparant.class);
        this.setHorizontalScrollbar(new NativeHorizontalScrollbar(hResources), AbstractNativeScrollbar.getNativeScrollbarHeight());
        NativeVerticalScrollbar.Resources vResources = (NativeVerticalScrollbar.Resources)GWT.create(NativeVerticalScrollbar.ResourcesTransparant.class);
        this.setVerticalScrollbar(new NativeVerticalScrollbar(vResources), AbstractNativeScrollbar.getNativeScrollbarWidth());
        ResizeLayoutPanel.Impl.Delegate containerResizeDelegate = new ResizeLayoutPanel.Impl.Delegate(){

            @Override
            public void onResize() {
                CustomScrollPanel.this.maybeUpdateScrollbars();
            }
        };
        this.containerResizeImpl.init(this.getContainerElement(), containerResizeDelegate);
        Event.sinkEvents(this.getElement(), 16384);
        Event.sinkEvents(this.getScrollableElement(), 16384);
    }

    public CustomScrollPanel(Widget child) {
        this(CustomScrollPanel.getDefaultResources());
        this.setWidget(child);
    }

    public HorizontalScrollbar getHorizontalScrollbar() {
        return this.hScrollbar;
    }

    public VerticalScrollbar getVerticalScrollbar() {
        return this.vScrollbar;
    }

    @Override
    public void onBrowserEvent(Event event) {
        double curTime;
        if (16384 == event.getTypeInt() && (curTime = Duration.currentTimeMillis()) > this.ignoreContentUntil) {
            this.ignoreScrollbarsUntil = curTime + (double)IGNORE_SCROLL_TIMEOUT;
            this.maybeUpdateScrollbarPositions();
        }
        super.onBrowserEvent(event);
    }

    @Override
    public void onResize() {
        this.maybeUpdateScrollbars();
        super.onResize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Widget w) {
        Widget vScrollbarWidget;
        if (w.getParent() != this) {
            return false;
        }
        if (w == this.getWidget()) {
            boolean toRet = super.remove(w);
            this.maybeUpdateScrollbars();
            return toRet;
        }
        try {
            this.orphan(w);
        }
        catch (Throwable throwable) {
            Widget vScrollbarWidget2;
            w.getElement().removeFromParent();
            Widget hScrollbarWidget = this.hScrollbar == null ? null : this.hScrollbar.asWidget();
            Widget widget = vScrollbarWidget2 = this.vScrollbar == null ? null : this.vScrollbar.asWidget();
            if (w == hScrollbarWidget) {
                this.hScrollbar = null;
                this.hScrollbarHandler.removeHandler();
                this.hScrollbarHandler = null;
                this.layout.removeChild(this.hScrollbarLayer);
                this.hScrollbarLayer = null;
            } else if (w == vScrollbarWidget2) {
                this.vScrollbar = null;
                this.vScrollbarHandler.removeHandler();
                this.vScrollbarHandler = null;
                this.layout.removeChild(this.vScrollbarLayer);
                this.vScrollbarLayer = null;
            }
            throw throwable;
        }
        w.getElement().removeFromParent();
        Widget hScrollbarWidget = this.hScrollbar == null ? null : this.hScrollbar.asWidget();
        Widget widget = vScrollbarWidget = this.vScrollbar == null ? null : this.vScrollbar.asWidget();
        if (w == hScrollbarWidget) {
            this.hScrollbar = null;
            this.hScrollbarHandler.removeHandler();
            this.hScrollbarHandler = null;
            this.layout.removeChild(this.hScrollbarLayer);
            this.hScrollbarLayer = null;
        } else if (w == vScrollbarWidget) {
            this.vScrollbar = null;
            this.vScrollbarHandler.removeHandler();
            this.vScrollbarHandler = null;
            this.layout.removeChild(this.vScrollbarLayer);
            this.vScrollbarLayer = null;
        }
        this.maybeUpdateScrollbars();
        return true;
    }

    public void removeHorizontalScrollbar() {
        if (this.hScrollbar != null) {
            this.remove(this.hScrollbar);
        }
    }

    public void removeVerticalScrollbar() {
        if (this.vScrollbar != null) {
            this.remove(this.vScrollbar);
        }
    }

    @Override
    public void setAlwaysShowScrollBars(boolean alwaysShow) {
        if (this.alwaysShowScrollbars != alwaysShow) {
            this.alwaysShowScrollbars = alwaysShow;
            this.maybeUpdateScrollbars();
        }
    }

    public void setHorizontalScrollbar(final HorizontalScrollbar scrollbar, int height) {
        this.hScrollbarLayer = this.add(scrollbar, this.hScrollbar, this.hScrollbarLayer);
        this.hScrollbar = scrollbar;
        this.hScrollbarHeight = height;
        if (scrollbar != null) {
            this.hScrollbarHandler = scrollbar.addScrollHandler(new ScrollHandler(){
                final /* synthetic */ CustomScrollPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onScroll(ScrollEvent event) {
                    double curTime = Duration.currentTimeMillis();
                    if (curTime > this.this$0.ignoreScrollbarsUntil) {
                        this.this$0.ignoreContentUntil = curTime + (double)IGNORE_SCROLL_TIMEOUT;
                        int hPos = scrollbar.getHorizontalScrollPosition();
                        if (this.this$0.getHorizontalScrollPosition() != hPos) {
                            this.this$0.setHorizontalScrollPosition(hPos);
                        }
                    }
                }
            });
        }
        this.maybeUpdateScrollbars();
    }

    public void setVerticalScrollbar(final VerticalScrollbar scrollbar, int width) {
        this.vScrollbarLayer = this.add(scrollbar, this.vScrollbar, this.vScrollbarLayer);
        this.vScrollbar = scrollbar;
        this.vScrollbarWidth = width;
        if (scrollbar != null) {
            this.vScrollbarHandler = scrollbar.addScrollHandler(new ScrollHandler(){
                final /* synthetic */ CustomScrollPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onScroll(ScrollEvent event) {
                    double curTime = Duration.currentTimeMillis();
                    if (curTime > this.this$0.ignoreScrollbarsUntil) {
                        this.this$0.ignoreContentUntil = curTime + (double)IGNORE_SCROLL_TIMEOUT;
                        int vPos = scrollbar.getVerticalScrollPosition();
                        int v = this.this$0.getVerticalScrollPosition();
                        if (this.this$0.getVerticalScrollPosition() != vPos) {
                            this.this$0.setVerticalScrollPosition(vPos);
                        }
                    }
                }
            });
        }
        this.maybeUpdateScrollbars();
    }

    @Override
    public void setWidget(Widget w) {
        if (w == this.getWidget()) {
            return;
        }
        super.setWidget(w);
        this.maybeUpdateScrollbars();
    }

    @Override
    protected void doAttachChildren() {
        AttachDetachException.tryCommand(AttachDetachException.attachCommand, this.getWidget(), this.hScrollbar, this.vScrollbar);
    }

    @Override
    protected void doDetachChildren() {
        AttachDetachException.tryCommand(AttachDetachException.detachCommand, this.getWidget(), this.hScrollbar, this.vScrollbar);
    }

    @Override
    protected void onAttach() {
        super.onAttach();
        this.containerResizeImpl.onAttach();
        this.layout.onAttach();
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        this.containerResizeImpl.onDetach();
        this.layout.onDetach();
    }

    @Override
    protected void onLoad() {
        this.hideNativeScrollbars();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            @Override
            public void execute() {
                CustomScrollPanel.this.maybeUpdateScrollbars();
            }
        });
    }

    private Layout.Layer add(IsWidget w, IsWidget toReplace, Layout.Layer layer) {
        if (w == toReplace) {
            return layer;
        }
        if (w != null) {
            w.asWidget().removeFromParent();
        }
        if (toReplace != null) {
            this.remove(toReplace);
        }
        Layout.Layer toRet = null;
        if (w != null) {
            toRet = this.layout.attachChild(w.asWidget().getElement());
            this.adopt(w.asWidget());
        }
        return toRet;
    }

    private void hideNativeScrollbars() {
        int barWidth = AbstractNativeScrollbar.getNativeScrollbarWidth();
        int barHeight = AbstractNativeScrollbar.getNativeScrollbarHeight();
        this.scrollableLayer.setTopBottom(0.0, Style.Unit.PX, -barHeight, Style.Unit.PX);
        if (AbstractNativeScrollbar.isScrollbarLeftAlignedInRtl() && ScrollImpl.get().isRtl(this.getScrollableElement())) {
            this.scrollableLayer.setLeftRight(-barWidth, Style.Unit.PX, 0.0, Style.Unit.PX);
        } else {
            this.scrollableLayer.setLeftRight(0.0, Style.Unit.PX, -barWidth, Style.Unit.PX);
        }
        this.layout.layout();
    }

    private void maybeUpdateScrollbarPositions() {
        if (!this.isAttached()) {
            return;
        }
        if (this.hScrollbar != null) {
            int hPos = this.getHorizontalScrollPosition();
            if (this.hScrollbar.getHorizontalScrollPosition() != hPos) {
                this.hScrollbar.setHorizontalScrollPosition(hPos);
            }
        }
        if (this.vScrollbar != null) {
            int vPos = this.getVerticalScrollPosition();
            if (this.vScrollbar.getVerticalScrollPosition() != vPos) {
                this.vScrollbar.setVerticalScrollPosition(vPos);
            }
        }
        if (this.getElement().getScrollLeft() != 0) {
            this.getElement().setScrollLeft(0);
        }
        if (this.getElement().getScrollTop() != 0) {
            this.getElement().setScrollTop(0);
        }
    }

    private void maybeUpdateScrollbars() {
        if (!this.isAttached()) {
            return;
        }
        Widget w = this.getWidget();
        int contentHeight = w == null ? 0 : w.getOffsetHeight();
        int contentWidth = w == null ? 0 : w.getOffsetWidth();
        int realScrollbarHeight = 0;
        int realScrollbarWidth = 0;
        if (this.hScrollbar != null && (this.alwaysShowScrollbars || this.getElement().getClientWidth() < contentWidth)) {
            realScrollbarHeight = this.hScrollbarHeight;
        }
        if (this.vScrollbar != null && (this.alwaysShowScrollbars || this.getElement().getClientHeight() < contentHeight)) {
            realScrollbarWidth = this.vScrollbarWidth;
        }
        if (w != null) {
            if (realScrollbarHeight > 0) {
                w.getElement().getStyle().setMarginBottom(realScrollbarHeight, Style.Unit.PX);
                contentHeight += realScrollbarHeight;
            } else {
                w.getElement().getStyle().clearMarginBottom();
            }
        }
        boolean isRtl = ScrollImpl.get().isRtl(this.getScrollableElement());
        if (realScrollbarHeight > 0) {
            this.hScrollbarLayer.setVisible(true);
            if (isRtl) {
                this.hScrollbarLayer.setLeftRight(realScrollbarWidth, Style.Unit.PX, 0.0, Style.Unit.PX);
            } else {
                this.hScrollbarLayer.setLeftRight(0.0, Style.Unit.PX, realScrollbarWidth, Style.Unit.PX);
            }
            this.hScrollbarLayer.setBottomHeight(0.0, Style.Unit.PX, realScrollbarHeight, Style.Unit.PX);
            this.hScrollbar.setScrollWidth(Math.max(0, contentWidth - realScrollbarWidth));
        } else if (this.hScrollbarLayer != null) {
            this.hScrollbarLayer.setVisible(false);
        }
        if (realScrollbarWidth > 0) {
            this.vScrollbarLayer.setVisible(true);
            this.vScrollbarLayer.setTopBottom(0.0, Style.Unit.PX, realScrollbarHeight, Style.Unit.PX);
            if (isRtl) {
                this.vScrollbarLayer.setLeftWidth(0.0, Style.Unit.PX, realScrollbarWidth, Style.Unit.PX);
            } else {
                this.vScrollbarLayer.setRightWidth(0.0, Style.Unit.PX, realScrollbarWidth, Style.Unit.PX);
            }
            this.vScrollbar.setScrollHeight(Math.max(0, contentHeight - realScrollbarHeight));
        } else if (this.vScrollbarLayer != null) {
            this.vScrollbarLayer.setVisible(false);
        }
        this.cornerLayer.setBottomHeight(0.0, Style.Unit.PX, realScrollbarHeight, Style.Unit.PX);
        if (isRtl) {
            this.cornerLayer.setLeftWidth(0.0, Style.Unit.PX, realScrollbarWidth, Style.Unit.PX);
        } else {
            this.cornerLayer.setRightWidth(0.0, Style.Unit.PX, realScrollbarWidth, Style.Unit.PX);
        }
        this.cornerLayer.setVisible(this.hScrollbarHeight > 0 && this.vScrollbarWidth > 0);
        this.layout.layout();
        this.maybeUpdateScrollbarPositions();
    }

    static {
        IGNORE_SCROLL_TIMEOUT = 500;
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"com/google/gwt/user/client/ui/CustomScrollPanel.css"})
        public Style customScrollPanelStyle();
    }

    @CssResource.ImportedWithPrefix(value="gwt-CustomScrollPanel")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/client/ui/CustomScrollPanel.css";

        public String customScrollPanel();

        public String customScrollPanelCorner();
    }
}

