/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.crypto.CryptoUtil;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceDMI;
import com.isomorphic.datasource.DataTranslator;
import com.isomorphic.datasource.RequiresCompleteRESTResponse;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.cachesync.CacheSyncStrategy;
import com.isomorphic.datasource.cachesync.RESTRefetchStrategy;
import com.isomorphic.datasource.cachesync.RESTRequestValuesPlusKeysStrategy;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.HttpUtil;
import com.isomorphic.util.SimpleHttpResponse;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XmlToMapHandler;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class RestConnector
extends BasicDataSource {
    private static Logger log = new Logger(RestConnector.class.getName());
    private static ConcurrentHashMap<String, AuthToken> authTokenCache = new ConcurrentHashMap();
    protected String[] deferredAttributes = new String[]{"requestTemplate", "responseTemplate"};
    protected String[] serializeAsJSONAttributes = new String[]{"requestTemplate", "responseTemplate"};

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
        this.registerCacheSyncStrategy("refetch", new RESTRefetchStrategy());
        this.registerCacheSyncStrategy("requestValuesPlusSequences", new RESTRequestValuesPlusKeysStrategy());
    }

    @Override
    protected String getDefaultAllowTemplateRefs() {
        return "all";
    }

    @Override
    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeUpdate(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeRemove(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeCustom(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeReplace(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeDownload(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataTypeMap resolveAuth(DataTypeMap serverConfig) throws Exception {
        String authType;
        DataTypeMap<String, String> headers;
        DataTypeMap authConfig = serverConfig.getMap("auth");
        if (authConfig == null) {
            return serverConfig;
        }
        AuthToken authToken = null;
        DataTypeMap authRecord = null;
        String authDataSource = authConfig.getString("dataSource");
        if (authDataSource != null) {
            Object object;
            authToken = authTokenCache.get(authDataSource);
            if (authToken == null) {
                object = authTokenCache;
                synchronized (object) {
                    authToken = authTokenCache.get(authDataSource);
                    if (authToken == null) {
                        authToken = new AuthToken(authConfig);
                        authTokenCache.put(authDataSource, authToken);
                    }
                }
            }
            if (authToken.isExpired()) {
                object = authToken;
                synchronized (object) {
                    if (authToken.isExpired()) {
                        authToken.renew();
                    }
                }
            }
            authRecord = authToken.getAuthRecord();
        }
        String jwt = null;
        DataTypeMap jwtConfig = authConfig.getMap("jwt");
        if (jwtConfig != null) {
            DataTypeMap jwtHeader = jwtConfig.getMap("header");
            DataTypeMap jwtBody = jwtConfig.getMap("body");
            if (jwtBody == null) {
                jwtBody = jwtConfig.getMap("claims");
            }
            JwtBuilder jwtBuilder = Jwts.builder();
            if (jwtHeader != null) {
                jwtBuilder.setHeader((Map)((Object)jwtHeader));
            }
            if (jwtBody != null) {
                jwtBuilder.setClaims((Map)((Object)jwtBody));
            }
            String signature = jwtConfig.getString("signature");
            String algorithm = jwtConfig.getString("algorithm");
            if (signature != null && algorithm != null) {
                if (algorithm.startsWith("RS")) {
                    PrivateKey privateKey = CryptoUtil.pemToPrivateKey(DataTools.base64DecodeToString(signature));
                    jwtBuilder.signWith(SignatureAlgorithm.forName((String)algorithm), (Key)privateKey);
                } else {
                    jwtBuilder.signWith(SignatureAlgorithm.forName((String)algorithm), DataTools.base64DecodeToBytes(signature));
                }
            }
            jwt = jwtBuilder.compact();
        }
        if ((headers = (serverConfig = (DataTypeMap)((Object)this.deepCloneWithVelocityEval((Object)serverConfig, "jwt/authRecord interpolation", (Map)((Object)DataTools.buildMap(new Object[]{"authRecord", authRecord, "jwt", jwt}))))).getMap("headers")) == null) {
            headers = new DataTypeMap<String, String>();
            serverConfig.put("headers", headers);
        }
        if (headers.get("Authorization") == null && authToken != null && ("authHeader".equals(authType = authConfig.getString("type")) || "bearerToken".equals(authType))) {
            headers.put("Authorization", authToken.getAuthorizationHeader());
        }
        return serverConfig;
    }

    public static RESTRequestElements getRESTRequestElements(DSRequest dsRequest) throws Exception {
        RESTRequestElements elements = new RESTRequestElements();
        RestConnector ds = (RestConnector)dsRequest.getDataSource();
        ds.processRequest(dsRequest, true, elements);
        return elements;
    }

    protected DSResponse processRequest(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DSResponse processRequest(DSRequest dsRequest, boolean skipExecution, RESTRequestElements elements) throws Exception {
        Object data;
        Object outboundData;
        Object requestTemplateObj;
        boolean multiRecord;
        String requestFormat;
        DataTypeMap authConfig;
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        if (serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        log.debug("server config: " + DataTools.prettyPrint((Object)serverConfig));
        serverConfig = this.resolveAuth(serverConfig);
        log.debug("serverConfig after resolveAuth: " + DataTools.prettyPrint((Object)serverConfig));
        String opType = dsRequest.getOperationType();
        String httpMethod = RestConnector.isAdd(opType) ? serverConfig.getString("addHttpMethod", serverConfig.getString("httpMethod", "POST")) : (RestConnector.isUpdate(opType) ? serverConfig.getString("updateHttpMethod", serverConfig.getString("httpMethod", "PUT")) : (RestConnector.isRemove(opType) ? serverConfig.getString("removeHttpMethod", serverConfig.getString("httpMethod", "DELETE")) : (RestConnector.isFetch(opType) ? serverConfig.getString("fetchHttpMethod", serverConfig.getString("httpMethod", "GET")) : serverConfig.getString("httpMethod", "GET"))));
        String dataURL = null;
        if (RestConnector.isAdd(opType)) {
            dataURL = serverConfig.getString("addURL");
        } else if (RestConnector.isUpdate(opType)) {
            dataURL = serverConfig.getString("updateURL");
        } else if (RestConnector.isRemove(opType)) {
            dataURL = serverConfig.getString("removeURL");
        } else if (RestConnector.isFetch(opType)) {
            dataURL = serverConfig.getString("fetchURL");
        }
        if (dataURL == null) {
            dataURL = serverConfig.getString("dataURL");
        }
        if (dataURL == null) {
            throw new Exception("Can't determine dataURL for operationType: " + opType);
        }
        log.info("dataURL: " + dataURL);
        DataTypeMap<String, Object> opts = new DataTypeMap<String, Object>();
        DataTypeMap headers = serverConfig.getMap("headers", (Map)((Object)new DataTypeMap()));
        opts.put("headers", (Object)headers);
        DataTypeMap params = new DataTypeMap();
        opts.put("params", (Object)params);
        if (serverConfig.getMap("params") != null) {
            params.putAll(serverConfig.getMap("params"));
        }
        if ((authConfig = serverConfig.getMap("auth")) != null) {
            String authHeader;
            String authType = authConfig.getString("type", "basic");
            if ("basic".equals(authType)) {
                opts.put("username", authConfig.getString("username"));
                opts.put("password", authConfig.getString("password"));
            } else if ("bearerToken".equals(authType) && authConfig.get("dataSource") == null) {
                String authToken = authConfig.getString("authToken");
                if (authToken != null) {
                    opts.getMap("headers").put("Authorization", "Bearer " + authToken);
                }
            } else if ("authHeader".equals(authType) && authConfig.get("dataSource") == null && (authHeader = authConfig.getString("authHeader")) != null) {
                opts.getMap("headers").put("Authorization", authHeader);
            }
        }
        if ((requestFormat = this.getRequestFormat(serverConfig, opType)) == null) {
            throw new Exception("Could not derive a requestFormat for an operation of type '" + opType + "' in RestConnector '" + this.dsName + "'");
        }
        String responseFormat = this.getResponseFormat(serverConfig, opType);
        if (responseFormat == null) {
            throw new Exception("Could not derive a responseFormat for an operation of type '" + opType + "' in RestConnector '" + this.dsName + "'");
        }
        dsRequest.setAttribute("_restResponseFormat", responseFormat);
        boolean bl = multiRecord = dsRequest.getValueSets().size() > 1;
        if (multiRecord) {
            dsRequest.setAttribute("originalValueSets", dsRequest.getValueSets());
        }
        if ((requestTemplateObj = serverConfig.get("requestTemplate")) != null) {
            if (requestTemplateObj instanceof String) {
                String requestTemplate = serverConfig.getString("requestTemplate");
                requestTemplate = requestTemplate.trim();
                if (!requestFormat.equals("json") && !requestFormat.equals("params") && !requestFormat.equals("xml")) throw new Exception("requestFormat: " + requestFormat + " is not supported");
                if (multiRecord) {
                    if (!requestFormat.equals("json")) {
                        throw new Exception("DataSource '" + this.getID() + "', operationType '" + opType + "', operationId '" + dsRequest.getOperationId() + "': " + (multiRecord ? "We received multiple records on the DSRequest" : "This operation is marked wrapInList:true") + ", but this operation has a requestFormat of '" + requestFormat + "', and we only support 'json' for multiple add/update/remove");
                    }
                    outboundData = this.handleMultipleValueSets(dsRequest, (Object)new DataTypeMap(), serverConfig);
                } else {
                    requestTemplate = (String)this.applyValueSetToTemplate(dsRequest, 0, requestTemplate, "requestTemplate");
                    outboundData = requestFormat.equals("xml") ? XML.toDSRecords(new StringReader(requestTemplate)) : JSTranslater.instance().fromJS(requestTemplate);
                }
            } else {
                if (!(requestTemplateObj instanceof Map)) throw new Exception("requestTemplate is of an unexpected type (" + requestTemplateObj.getClass().getCanonicalName() + ")");
                outboundData = (Map)requestTemplateObj;
            }
        } else {
            outboundData = new HashMap();
        }
        Boolean wrapInList = null;
        if (RestConnector.isAdd(opType)) {
            wrapInList = serverConfig.getBoolean("wrapAddInList");
        } else if (RestConnector.isUpdate(opType)) {
            wrapInList = serverConfig.getBoolean("wrapUpdateInList");
        } else if (RestConnector.isRemove(opType)) {
            wrapInList = serverConfig.getBoolean("wrapRemoveInList");
        }
        if (wrapInList == null) {
            wrapInList = serverConfig.getBoolean("wrapInList");
        }
        if (requestTemplateObj == null) {
            if (multiRecord || Boolean.TRUE.equals(wrapInList)) {
                if (!requestFormat.equals("json")) {
                    throw new Exception("DataSource '" + this.getID() + "', operationType '" + opType + "', operationId '" + dsRequest.getOperationId() + "': " + (multiRecord ? "We received multiple records on the DSRequest" : "This operation is marked wrapInList:true") + ", but this operation has a requestFormat of '" + requestFormat + "', and we only support 'json' for multiple add/update/remove");
                }
                outboundData = this.handleMultipleValueSets(dsRequest, outboundData, serverConfig);
            } else if (!serverConfig.getBoolean((Object)"suppressAutoMappings", false)) {
                this.applyValuesOrCriteriaToRequest((Map)outboundData, dsRequest);
            }
        }
        log.debug("outboundData: " + DataTools.prettyPrint(outboundData));
        if ("params".equals(requestFormat)) {
            if (!(outboundData instanceof Map)) throw new Exception("requestFormat: params, but derived source object is of type: " + outboundData.getClass().getName());
            params.putAll((Map)outboundData);
        } else {
            String body;
            if (requestFormat.equals("json")) {
                body = JSTranslater.instance().strictJSONMode().toJS(outboundData);
            } else {
                if (!requestFormat.equals("xml")) throw new Exception("requestFormat: " + requestFormat + " is not supported");
                StringWriter sw = new StringWriter();
                if (outboundData instanceof List) {
                    XML.recordsToXML(serverConfig.getString("xmlTag"), (List)outboundData, sw, true, dsRequest);
                } else if (outboundData instanceof Map) {
                    XML.recordToXML(serverConfig.getString("xmlTag"), (Map)outboundData, sw, true, dsRequest);
                }
                body = sw.toString();
            }
            log.debug("outbound body:\n" + body);
            if (serverConfig.getString("implicitRequestCharset") == null) {
                if (requestFormat.equals("json")) {
                    opts.put("body", new StringEntity(body, ContentType.APPLICATION_JSON));
                } else if (requestFormat.equals("xml")) {
                    opts.put("body", new StringEntity(body, ContentType.APPLICATION_XML));
                } else {
                    opts.put("body", body);
                }
            } else {
                opts.put("body", body);
            }
        }
        if (headers.get("Content-Type") == null) {
            if (requestFormat.equals("json")) {
                headers.put("Content-Type", "application/json; charset=UTF-8");
            } else if (requestFormat.equals("xml")) {
                headers.put("Content-Type", "application/xml; charset=UTF-8");
            }
        }
        opts.put("implicitRequestCharset", serverConfig.getString("implicitRequestCharset"));
        DSResponse dsResponse = new DSResponse(this);
        opts.put("redirectStrategy", serverConfig.getString("redirectStrategy"));
        opts.put("sslTrustStrategy", serverConfig.getString("sslTrustStrategy"));
        opts.put("numRetriesServerDown", serverConfig.getInteger((Object)"numRetriesServerDown", null));
        opts.put("retryDelayServerDown", serverConfig.getInteger((Object)"retryDelayServerDown", null));
        opts.put("numRetriesFileNotFound", serverConfig.getInteger((Object)"numRetriesFileNotFound", null));
        opts.put("retryDelayFileNotFound", serverConfig.getInteger((Object)"retryDelayFileNotFound", null));
        opts.put("timeout", serverConfig.getInteger((Object)"socketTimeout", config.getInteger((Object)"rest.default.socket.timeout", null)));
        opts.put("skipExecution", skipExecution);
        SimpleHttpResponse httpResponse = HttpUtil.httpRequest(httpMethod, dataURL, opts);
        if (skipExecution) {
            if (elements == null) {
                log.warn("In RESTDataSource.processRequest, skipExecution was passed as true, but the RESTRequestElements parameter was null.  This is not valid, please pass a RESTRequestElements object when skipping execution");
                return null;
            } else {
                elements.setUrl((String)opts.get("_url"));
                elements.setMethod((String)opts.get("_method"));
                elements.setBody((String)opts.get("_body"));
                elements.setHeaders((Map)opts.get("_headers"));
            }
            return null;
        }
        if (httpResponse == null) {
            log.warn("Server unreachable");
            dsResponse.setFailure();
            dsResponse.setData("Server unreachable");
            return dsResponse;
        }
        String responseBody = httpResponse.getBodyAsString(this.defaultCharset());
        int statusCode = httpResponse.getStatusCode();
        log.info("HTTP response code: " + httpResponse.getStatusCode());
        log.debug("Raw response body: " + responseBody);
        if (!httpResponse.isSuccess()) {
            log.warn("HTTP response indicates failure - code: " + statusCode);
            dsResponse.setFailure();
            dsResponse.setData(responseBody);
            return dsResponse;
        }
        dsRequest.addToScriptContext("responseText", responseBody);
        if ("json".equals(responseFormat)) {
            long t1 = System.currentTimeMillis();
            data = JSTranslater.instance().fromJS(responseBody);
            long t2 = System.currentTimeMillis();
            log.debug("Parsing with JSTranslater took " + (t2 - t1) + "ms");
        } else if ("xml".equals(responseFormat)) {
            long t1 = System.currentTimeMillis();
            XmlToMapHandler xmlToMapHandler = new XmlToMapHandler();
            xmlToMapHandler.setUseListsForMultipleElements(true);
            xmlToMapHandler.setIncludeTopLevelElement(true);
            data = XML.parseXMLToMap(responseBody, xmlToMapHandler);
            long t2 = System.currentTimeMillis();
            log.debug("Parsing with XML.parseXMLToMap() took " + (t2 - t1) + "ms");
        } else if ("csv".equals(responseFormat)) {
            Object dataImport = Reflection.instantiateClass("com.isomorphic.tools.DataImport", "CSV", serverConfig.getString("csvDelimiter", ","), serverConfig.getString("csvQuoteCharacter", "\""));
            Method method = Reflection.findMethod(dataImport.getClass(), "importToRows", Reader.class, Map.class, Map.class, DataSource.class, DSRequest.class);
            Map<String, DataTranslator> translators = this.getConfiguredTranslators();
            dsRequest.setAttribute("_skipCSVTranslation", true);
            data = Reflection._invokeMethod(method, dataImport, new StringReader(responseBody), this.native2DSFieldMap, translators, this, dsRequest);
        } else {
            if (!"text".equals(responseFormat)) throw new Exception("responseFormat: " + responseFormat + " is not supported");
            data = responseBody;
        }
        log.debug("Parsed response pre-templating: " + DataTools.prettyPrint(data));
        if (this instanceof RequiresCompleteRESTResponse || serverConfig.getBoolean((Object)"requiresCompleteRESTResponse", false)) {
            dsResponse.setProperty("completeData", data);
            dsRequest.addToScriptContext("completeData", data);
        }
        if ("json".equals(responseFormat) || "xml".equals(responseFormat) || "csv".equals(responseFormat)) {
            String recordXPath;
            if (("json".equals(responseFormat) || "xml".equals(responseFormat)) && (recordXPath = serverConfig.getString("recordXPath")) != null && data != null) {
                JXPathContext context = JXPathContext.newContext((Object)data);
                data = context.getValue(recordXPath);
            }
            ArrayList<Object> dataList = null;
            if (data instanceof List) {
                dataList = (ArrayList<Object>)data;
            } else {
                dataList = new ArrayList<Object>();
                dataList.add(data);
            }
            if (!DataSource.isFetch(opType)) {
                dsResponse.setParameter("_responseValues", dataList);
                dsRequest.setParameter("_responseValues", dataList);
                this.doCacheSync(dsRequest, dsResponse);
            } else {
                dsResponse.setData(dataList);
            }
            if (RestConnector.isFetch(opType) || dsResponse.isCacheSyncComplete()) {
                HashMap<String, ArrayList<Object>> transformContext = new HashMap<String, ArrayList<Object>>();
                transformContext.put("responseObjectsUnfiltered", dataList);
                this.applyEarlyResponseTransformations(dsRequest, dsResponse, transformContext);
                this.transformResponse(dsResponse.getDataList(), dsRequest, dsResponse);
                dsRequest.setAttribute("transformResponseApplied", true);
                this.applyTransformResponseScript(dsRequest, dsResponse, null);
            }
            if (RestConnector.isFetch(opType)) {
                long t1 = System.currentTimeMillis();
                List records = dsResponse.getDataList();
                ArrayList<Map> filtered = new ArrayList<Map>();
                ValidationContext vc = new ValidationContext();
                vc.setSkipNonTypeValidations(true);
                boolean dropExtraFields = dsResponse.getDropExtraFields() == null ? this.dropExtraFields() : dsResponse.getDropExtraFields().booleanValue();
                for (int i = 0; i < records.size(); ++i) {
                    Map record = (Map)records.get(i);
                    List outputs = dsRequest.getConsolidatedOutputs();
                    record = outputs != null && outputs.size() > 0 ? this.getProperties(record, outputs) : this.getProperties((Object)record, dropExtraFields, false);
                    if (record == null) continue;
                    for (Object key : record.keySet()) {
                        DSField field;
                        String fieldName = key.toString();
                        if (this.fieldhasTranslatorsOrFieldValueScript(fieldName, dsRequest) || (field = this.getField(fieldName)) == null || DataTools.getBoolean((Map)((Object)field), "skipTypeCoercion")) continue;
                        Object value = this.validateFieldValue(record, field, record.get(fieldName), vc);
                        record.put(fieldName, value);
                    }
                    filtered.add(record);
                }
                dsResponse.setData(filtered);
                this.applyFieldValueScripts(dsRequest, dsResponse);
                dsResponse.setBypassDataFilter(true);
                this.applyStartEndRow(serverConfig, dsRequest, dsResponse);
                long t2 = System.currentTimeMillis();
                log.debug("Processing XPaths, pre-validating and applying fieldValueScripts took " + (t2 - t1) + "ms");
            }
        }
        dsResponse.setSuccess();
        return dsResponse;
    }

    public void applyValuesOrCriteriaToRequest(Map outboundData, DSRequest dsRequest) throws Exception {
        if (dsRequest.getIsAdvancedCriteria()) {
            throw new Exception("RestConnector DataSource '" + this.getName() + "' received a DSRequest containing AdvancedCriteria, which it cannot process automatically. Criteria will not be applied.  You can fix this issue by either creating a RestConnector subclass and overriding its applyValuesOrCriteria() method, or by providing a requestTemplate to this operation (see client-side docs for details of RestConnector's templating features");
        }
        this.setProperties(dsRequest.getValues(), outboundData, dsRequest);
        this.applyNativeNames(outboundData);
    }

    private void applyNativeNames(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String fieldName = (String)entry.getKey();
            DSField field = this.getField(fieldName);
            if (field == null || field.getNativeName() == null) continue;
            i.remove();
            map.put(field.getNativeName(), entry.getValue());
        }
    }

    protected void applyStartEndRow(DataTypeMap serverConfig, DSRequest req, DSResponse resp) throws Exception {
        long end;
        List records = resp.getDataList();
        boolean apply = serverConfig.getBoolean((Object)"trimResponseDataUsingStartAndEndRow", false);
        if (!apply) {
            resp.setStartRow(0L);
            resp.setEndRow(records.size());
            resp.setTotalRows(records.size());
            return;
        }
        long start = req.getStartRow();
        if (start < 0L) {
            start = 0L;
        }
        if (start > (long)(records.size() - 1)) {
            start = records.size() - 1;
        }
        if ((end = req.getEndRow()) < start) {
            end = start + 1L;
        }
        if (end > (long)records.size()) {
            end = records.size();
        }
        ArrayList<Map> trimmed = new ArrayList<Map>();
        if (end > Integer.MAX_VALUE) {
            throw new Exception("DSRequest endRow value exceeds Integer.MAX_VALUE");
        }
        for (int i = (int)start; i < (int)end; ++i) {
            trimmed.add((Map)records.get(i));
        }
        resp.setData(trimmed);
        resp.setTotalRows(records.size());
        resp.setStartRow(start);
        resp.setEndRow(end);
    }

    private Object processResponseTemplate(DSRequest dsRequest, DSResponse dsResponse, Object data, DataTypeMap serverConfig, String responseFormat) throws Exception {
        Object templateData;
        if (!(data instanceof Map)) {
            Object firstElement;
            if (data instanceof Collection && ((Collection)data).size() == 1 && (firstElement = ((Collection)data).iterator().next()) instanceof Map) {
                data = firstElement;
            }
            if (!(data instanceof Map)) {
                throw new Exception("responseTemplate is defined, but response (after recordXPath) is of type: " + data.getClass().getName() + ".  Template handling requires something implementing Map or List<Map>");
            }
        }
        Map<Object, Object> velocityContext = Velocity.getStandardContextMap(dsRequest);
        velocityContext.put("dsResponse", dsResponse);
        velocityContext.put("restResponseData", data);
        velocityContext.put(serializeAsJSONAttr, true);
        String responseTemplate = serverConfig.getString("responseTemplate");
        responseTemplate = (String)this.doVelocityEval(responseTemplate, "responseTemplate", velocityContext, true);
        if (responseFormat.equals("xml")) {
            try {
                XmlToMapHandler xmlToMapHandler = new XmlToMapHandler();
                xmlToMapHandler.setUseListsForMultipleElements(true);
                xmlToMapHandler.setIncludeTopLevelElement(true);
                templateData = XML.parseXMLToMap(responseTemplate, xmlToMapHandler);
            }
            catch (Exception e) {
                templateData = JSTranslater.instance().fromJS(responseTemplate);
            }
        } else {
            templateData = JSTranslater.instance().fromJS(responseTemplate);
        }
        if (templateData != null) {
            data = serverConfig.getBoolean((Object)"includeExtraValuesInTemplatedResponse", false) ? DataTools.setProperties((Map)data, templateData) : templateData;
        }
        return templateData;
    }

    private void doCacheSync(DSRequest req, DSResponse resp) throws Exception {
        CacheSyncStrategy strategy = req.getCacheSyncStrategy();
        boolean shouldSync = strategy.shouldRunCacheSync(req);
        if (shouldSync && !req.shouldDeferCacheSync()) {
            final List cacheSyncData = strategy.getCacheSyncData(req, resp);
            if (!config.getBoolean((Object)"rest.return.multiple.cache.sync.data.in.relatedUpdates", false)) {
                resp.setData(cacheSyncData);
            } else {
                resp.setData(new ArrayList(){
                    {
                        this.add(cacheSyncData.get(0));
                    }
                });
                for (int i = 1; i < cacheSyncData.size(); ++i) {
                    DSResponse relatedResp = new DSResponse(this);
                    relatedResp.setStatus(0);
                    relatedResp.setData(cacheSyncData.get(i));
                    resp.addRelatedUpdate(relatedResp);
                }
            }
            resp.setCacheSyncComplete(true);
        } else if (!shouldSync) {
            resp.setInvalidateCache(true);
        }
    }

    protected List handleMultipleValueSets(DSRequest req, Object outboundData, DataTypeMap serverConfig) throws Exception {
        ArrayList result = new ArrayList();
        List valueSets = req.getValueSets();
        for (int i = 0; i < valueSets.size(); ++i) {
            Map record = (Map)valueSets.get(i);
            Map processed = new HashMap((Map)outboundData);
            String requestTemplate = serverConfig.getString("requestTemplate");
            if (requestTemplate != null) {
                requestTemplate = (String)this.applyValueSetToTemplate(req, i, requestTemplate, "requestTemplate");
                Object parsed = JSTranslater.instance().fromJS(requestTemplate);
                if (!(parsed instanceof Map)) {
                    throw new Exception("Request template does not parse to a Java Map object.");
                }
                processed = (Map)parsed;
            }
            if (!serverConfig.getBoolean((Object)"suppressAutoMappings", false)) {
                processed = (Map)this.setProperties(record, processed, req);
                this.applyNativeNames(processed);
            }
            result.add(processed);
        }
        return result;
    }

    @Override
    public boolean shouldDeferParsing(String key, Object value) {
        for (int i = 0; i < this.deferredAttributes.length; ++i) {
            if (!this.deferredAttributes[i].equals(key) || value == null || !(value instanceof String) || !((String)value).trim().startsWith("{")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldSerializeAsJSON(String key, Object value) {
        for (int i = 0; i < this.serializeAsJSONAttributes.length; ++i) {
            if (!this.serializeAsJSONAttributes[i].equals(key) || value == null || !(value instanceof String) || !((String)value).trim().startsWith("{")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldApplyDefaultTranslators(DSRequest dsRequest) {
        return "csv".equals(dsRequest.getAttribute("_restResponseFormat"));
    }

    public void transformRawResponse(List untransformed, DSRequest dsRequest, DSResponse dsResponse) throws Exception {
    }

    public String getRequestFormat(DataTypeMap serverConfig, String opType) {
        String requestFormat = null;
        if (RestConnector.isAdd(opType)) {
            requestFormat = serverConfig.getString("addRequestFormat");
        } else if (RestConnector.isUpdate(opType)) {
            requestFormat = serverConfig.getString("updateRequestFormat");
        } else if (RestConnector.isRemove(opType)) {
            requestFormat = serverConfig.getString("removeRequestFormat");
        } else if (RestConnector.isFetch(opType)) {
            requestFormat = serverConfig.getString("fetchRequestFormat");
        }
        String dataFormat = serverConfig.getString("dataFormat");
        if (requestFormat == null) {
            requestFormat = serverConfig.getString("requestFormat", dataFormat);
        }
        return requestFormat;
    }

    public String getResponseFormat(DataTypeMap serverConfig, String opType) {
        String responseFormat = null;
        if (RestConnector.isAdd(opType)) {
            responseFormat = serverConfig.getString("addResponseFormat");
        } else if (RestConnector.isUpdate(opType)) {
            responseFormat = serverConfig.getString("updateResponseFormat");
        } else if (RestConnector.isRemove(opType)) {
            responseFormat = serverConfig.getString("removeResponseFormat");
        } else if (RestConnector.isFetch(opType)) {
            responseFormat = serverConfig.getString("fetchResponseFormat");
        }
        String dataFormat = serverConfig.getString("dataFormat", "json");
        if (responseFormat == null) {
            responseFormat = serverConfig.getString("responseFormat", dataFormat);
        }
        return responseFormat;
    }

    public void applyTransformRawResponseScript(DSRequest dsRequest, DSResponse dsResponse) throws Exception {
        Object data;
        if (this.transformRawResponseScriptExists(dsRequest)) {
            dsRequest.addToScriptContext("dsResponse", dsResponse);
            if (dsResponse.getData() instanceof List) {
                dsRequest.addToScriptContext("responseObjects", dsResponse.getData());
                if (((List)dsResponse.getData()).size() > 0) {
                    dsRequest.addToScriptContext("responseObject", ((List)dsResponse.getData()).get(0));
                } else {
                    dsRequest.addToScriptContext("responseObject", null);
                }
                if (!dsRequest.getScriptContext().containsKey("responseRecords")) {
                    dsRequest.addToScriptContext("responseRecords", dsResponse.getData());
                    if (((List)dsResponse.getData()).size() > 0) {
                        dsRequest.addToScriptContext("responseObject", ((List)dsResponse.getData()).get(0));
                    } else {
                        dsRequest.addToScriptContext("responseObject", null);
                    }
                }
            } else {
                dsRequest.addToScriptContext("responseObject", dsResponse.getData());
                ArrayList<Object> work = new ArrayList<Object>();
                work.add(dsResponse.getData());
                dsRequest.addToScriptContext("responseObjects", work);
                if (!dsRequest.getScriptContext().containsKey("responseRecords")) {
                    dsRequest.addToScriptContext("responseRecord", dsResponse.getData());
                    dsRequest.addToScriptContext("responseRecords", work);
                }
            }
        }
        if (this.getTransformRawResponseScript(dsRequest, false) != null && (data = DataSourceDMI.evalInlineScript(dsRequest, dsRequest.getRPCManager(), dsRequest.getContext(), null, "transformRawResponseScript")) != null) {
            dsResponse.setData(data);
        }
        if (this.getTransformRawResponseScript(dsRequest, true) != null) {
            DataTypeMap opBinding = this.getOperationBinding(dsRequest);
            Object data2 = DataSourceDMI.evalInlineScript(dsRequest, dsRequest.getRPCManager(), dsRequest.getContext(), (Map)((Object)opBinding), "transformRawResponseScript");
            if (data2 != null) {
                dsResponse.setData(data2);
            }
        }
        log.debug("Response data after transformRawResponseScript processing: " + DataTools.prettyPrint(dsResponse.getData()));
    }

    private boolean transformRawResponseScriptExists(DSRequest dsRequest) {
        DataTypeMap op = this.getOperationBinding(dsRequest);
        return this.dsConfig.get("transformRawResponseScript") != null || op != null && op.get("transformRawResponseScript") != null;
    }

    public Object getTransformRawResponseScript(DSRequest dsRequest, boolean getOpBindingScript) throws Exception {
        if (getOpBindingScript) {
            DataTypeMap opBinding = this.getOperationBinding(dsRequest);
            if (opBinding != null && opBinding.containsKey("transformRawResponseScript")) {
                return opBinding.get("transformRawResponseScript");
            }
            return null;
        }
        return this.dsConfig.get("transformRawResponseScript");
    }

    @Override
    public void applyEarlyResponseTransformations(DSRequest dsRequest, DSResponse dsResponse, Map transformContext) throws Exception {
        if (Boolean.TRUE.equals(dsRequest.getAttribute("earlyResponseTransformationsApplied"))) {
            return;
        }
        ArrayList<Object> dataList = dsResponse.getDataList();
        if (dataList == null) {
            dsRequest.setAttribute("earlyResponseTransformationsApplied", true);
            return;
        }
        this.transformRawResponse(dataList, dsRequest, dsResponse);
        dsResponse.setData(dataList);
        this.applyTransformRawResponseScript(dsRequest, dsResponse);
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        String responseTemplate = serverConfig.getString("responseTemplate");
        String responseFormat = this.getResponseFormat(serverConfig, dsRequest.getOperationType());
        if (responseTemplate != null) {
            if (!"json".equals(responseFormat) && !"xml".equals(responseFormat)) {
                throw new Exception("responseFormat: " + responseFormat + " is not supported for templated responses");
            }
            dsRequest.addToScriptContext("responseRecordsBeforeTemplating", dataList);
            ArrayList<Object> processed = new ArrayList<Object>();
            for (int i = 0; i < dataList.size(); ++i) {
                processed.add(this.processResponseTemplate(dsRequest, dsResponse, dataList.get(i), serverConfig, responseFormat));
            }
            dataList = processed;
            dsResponse.setData(dataList);
            log.debug("dataList after responseTemplate processing: " + DataTools.prettyPrint(dataList));
            dsRequest.addToScriptContext("responseRecords", dataList);
        } else {
            dsRequest.addToScriptContext("responseRecords", dataList);
        }
        dsRequest.setAttribute("earlyResponseTransformationsApplied", true);
    }

    @Override
    public String getDefaultCacheSyncStrategyName() {
        return config.getString("default.rest.cache.sync.strategy");
    }

    @Override
    public String getDefaultCacheSyncTiming() {
        return config.getString("default.rest.cache.sync.timing");
    }

    @Override
    public boolean shouldAutoSwitchCacheSyncTiming() {
        return true;
    }

    protected Charset defaultCharset() {
        String charsetName = config.getString("rest.default.charset");
        if (charsetName != null) {
            return Charset.forName(charsetName);
        }
        return Config.defaultCharset();
    }

    private class AuthToken {
        DataTypeMap authConfig;
        DateTime expires;
        boolean neverExpires = false;
        DataTypeMap authRecord;
        int renewWindow = 30;
        String authorizationHeader;

        public AuthToken(DataTypeMap authConfig) {
            this.authConfig = authConfig;
            this.renewWindow = authConfig.getInt("renewWindow", this.renewWindow);
            this.neverExpires = authConfig.getBoolean((Object)"neverExpires", false);
        }

        public DataTypeMap getAuthRecord() {
            return this.authRecord;
        }

        public String getAuthorizationHeader() throws Exception {
            return this.authorizationHeader;
        }

        public void expire() {
            this.expires = null;
        }

        public boolean isExpired() {
            if (this.neverExpires) {
                return false;
            }
            if (this.expires == null) {
                return true;
            }
            return this.expires.isBefore((ReadableInstant)DateTime.now().plusSeconds(this.renewWindow));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void renew() throws Exception {
            String authDataSource = this.authConfig.getString("dataSource");
            if (authDataSource == null) {
                throw new Exception("You must define an auth dataSource");
            }
            Map _record = new DSRequest(authDataSource, "fetch").execute().getDataMap();
            if (_record == null) {
                throw new Exception("Failed to renew token - no valid record in response");
            }
            this.authRecord = new DataTypeMap(new ConcurrentHashMap(_record));
            log.debug("received authRecord: " + DataTools.prettyPrint((Object)this.authRecord));
            String tokenField = this.authConfig.getString("tokenField", "access_token");
            String expiresField = this.authConfig.getString("expiresField", "expires");
            String expiresInField = this.authConfig.getString("expiresInField", "expires_in");
            String authorizationHeaderField = this.authConfig.getString("authorizationHeaderField", "authorizationHeader");
            this.authorizationHeader = this.authRecord.getString(authorizationHeaderField);
            if (this.authorizationHeader == null) {
                String authType = this.authConfig.getString("type");
                if (!"bearerToken".equals(authType)) throw new Exception("Unable to derive authorizatioHeader - explicit value not present at fieldName: " + authorizationHeaderField);
                String token = this.authRecord.getString(tokenField);
                if (token == null) {
                    throw new Exception("Bearer token not found at field: " + tokenField);
                }
                this.authorizationHeader = "Bearer " + token;
            } else {
                log.debug("Using explicit authorizationHeader: " + this.authorizationHeader);
            }
            Long expires = this.authRecord.getLong(expiresField);
            if (expires == null) {
                Integer expiresIn = this.authRecord.getInteger(expiresInField);
                if (expiresIn == null) {
                    throw new Exception("Unable to find either an " + expiresField + " or " + expiresInField + " field on the response.");
                }
                this.expires = DateTime.now().plusSeconds(expiresIn.intValue());
                return;
            } else if (expires == -1L) {
                log.info("Accepted a non-expiring token");
                this.neverExpires = true;
                return;
            } else {
                this.expires = new DateTime((Object)expires);
            }
        }
    }

    public static class RESTRequestElements {
        private String url;
        private String method;
        private String body;
        private Map<String, String> headers;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }
    }
}

