/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.assembly;

import com.isomorphic.assembly.Component;
import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.SystemSchemaTranslation;
import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.ICompression;
import com.isomorphic.interfaces.IInstanceSingleton;
import com.isomorphic.interfaces.IObfuscator;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSSyntaxScanner;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCSystem;
import com.isomorphic.xml.XML;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.output.TeeOutputStream;

public class FileAssembler
extends Base
implements IAssembly,
IInstanceSingleton {
    private static Logger log;
    private static boolean canObfuscate;
    private static boolean canCompress;
    private static final List<String> optionalModules;
    private static List stripTokenDefaults;
    public static String webRoot;
    private static boolean devenv;
    private static String devMode;
    private static List devStripTokens;
    public static Date backCompatDate;
    private static final SimpleDateFormat sdf;
    public static boolean forceObfuscation;
    public static boolean sourceMode;
    private static List prodStripTokens;
    private boolean syntaxScanComponentFiles = config.getBoolean((Object)"FileAssembler.syntaxScanComponentFiles", devenv);
    public List configFiles = null;
    public String cacheDir = null;
    private boolean assembleInMemory = config.getBoolean((Object)"FileAssembler.assembleInMemory", false);
    public boolean cacheAssemblyInstructions = false;
    public Map assemblyInstructions;
    String virtualPath;
    Map assemblyData;
    boolean debugMode;
    List components;
    public IObfuscator obfuscator = null;
    Map strippedStructCache = Collections.synchronizedMap(new HashMap());
    private static final Pattern DEFERRED_LOADING_DIRECTIVE_PATTERN;
    public static final Pattern BACKCOMPAT_START_PATTERN;
    public static final Pattern BACKCOMPAT_END_PATTERN;
    private static final String LINE_TERMINATOR_SEQUENCE_REGEX = "\n|\r(?!\n)|\u2028|\u2029|\r\n";
    private static final Pattern NO_LINE_TERMINATOR_WHITE_SPACE_PATTERN;
    private static final Pattern WHITE_SPACE_PATTERN;
    static final PrintStream err;

    public void setAssembleInMemory(boolean assembleInMemory) {
        this.assembleInMemory = assembleInMemory;
    }

    public static String getModeSuffix() {
        if (devMode.equals("prod")) {
            return "-build";
        }
        return "";
    }

    public Map loadFileAssembly() throws Exception {
        if (this.cacheAssemblyInstructions && this.assemblyInstructions != null) {
            return this.assemblyInstructions;
        }
        boolean haveExplicitConfigFiles = false;
        if (this.configFiles == null) {
            this.configFiles = new ArrayList();
            String xmlConfig = webRoot + "/isomorphicConfig/fileAssembly.xml";
            String jsConfig = webRoot + "/isomorphicConfig/fileAssembly.js";
            String configFile = FileAssembler.checkConfigFile(xmlConfig);
            if (configFile == null) {
                configFile = FileAssembler.checkConfigFile(jsConfig);
            }
            if (configFile == null) {
                throw new Exception("Can't find default fileAssembly file.  I tried: " + xmlConfig + " and " + jsConfig);
            }
            this.configFiles.add(configFile);
        } else {
            haveExplicitConfigFiles = true;
        }
        if (!haveExplicitConfigFiles && config.getBoolean((Object)"devenv", false)) {
            String xmlProjectConfig = webRoot + "/isomorphicConfig/fileAssembly-project.xml";
            String jsProjectConfig = webRoot + "/isomorphicConfig/fileAssembly-project.js";
            String projectConfigFile = FileAssembler.checkConfigFile(xmlProjectConfig);
            if (projectConfigFile == null) {
                projectConfigFile = FileAssembler.checkConfigFile(jsProjectConfig);
            }
            if (projectConfigFile != null) {
                this.configFiles.add(projectConfigFile);
            }
        }
        this.assemblyInstructions = new LinkedHashMap();
        for (String configFile : this.configFiles) {
            if (configFile.endsWith(".js")) {
                DataTools.mapMerge((Map)DataStructCache.getSingleDataMap((String)configFile), (Map)this.assemblyInstructions);
            } else {
                Map fa = (Map)XML.toDSRecords((String)configFile, (boolean)true);
                if (fa != null && fa.get("assemblies") != null) {
                    DataTools.mapMerge((Map)((Map)fa.get("assemblies")), (Map)this.assemblyInstructions);
                }
            }
            log.info((Object)("read config file: " + configFile));
        }
        return this.assemblyInstructions;
    }

    public Map getVirtualXMLInstructions() throws Exception {
        HashMap<String, String> data = null;
        try {
            data = this.loadFileAssembly();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data == null) {
            log.info((Object)"Couldn't load fileAssembly instructions, switching to basic mode");
            data = new HashMap<String, String>();
            data.put("jsStripping", "none");
            data.put("compress", "false");
        }
        if (data.containsKey("virtualXML")) {
            return (Map)data.get("virtualXML");
        }
        return new HashMap();
    }

    public Map getAssemblyInstructions() throws Exception {
        Map data = this.loadFileAssembly();
        if (data.containsKey("assemblies")) {
            data = (Map)data.get("assemblies");
        }
        return data;
    }

    public String getCacheDir() throws Exception {
        ISCFile file;
        if (this.cacheDir == null) {
            this.cacheDir = webRoot + "/isomorphicCache" + FileAssembler.getModeSuffix();
            if (ISCFile.inContainerIOMode() || this.assembleInMemory) {
                this.cacheDir = "ram://" + this.cacheDir;
            }
        }
        if (!(file = ISCFile.newInstance((String)this.cacheDir)).isDirectory()) {
            file.mkdir();
        }
        return file.getPath();
    }

    public String getXMLCacheDir() throws Exception {
        ISCFile xmlDir = ISCFile.newInstance((String)(this.getCacheDir() + "/xml"));
        if (!xmlDir.isDirectory()) {
            xmlDir.mkdir();
        }
        return xmlDir.getPath();
    }

    public boolean pathIsRegistered(String virtualPath) throws Exception {
        return this.getAssemblyInstructions().containsKey(virtualPath);
    }

    public void registerAssemblyData(String virtualPath, Map assemblyData) throws Exception {
        this.getAssemblyInstructions().put(virtualPath, assemblyData);
    }

    public Map getAssemblyData(String virtualPath) throws Exception {
        Map assemblyData = (Map)this.getAssemblyInstructions().get(virtualPath);
        if (assemblyData != null) {
            return assemblyData;
        }
        return null;
    }

    public String fileNameForType(String type, String name) throws Exception {
        if ("ds".equals(type) && "$systemSchema".equals(name)) {
            return "$systemSchema";
        }
        String location = null;
        if (type.equals("ds") || type.equals("type")) {
            location = "datasources";
        } else if (type.equals("app")) {
            location = "apps";
        } else if (type.equals("ui")) {
            location = "ui";
        }
        String fileName = DataStructCache.getInstanceFile((String)name, (String)location, (String)type);
        if (fileName == null) {
            throw new Exception("can't locate file for component type: " + type + " with name: " + name);
        }
        String webRootC = ISCFile.newInstance((String)(webRoot + "/WEB-INF/web.xml")).getCanonicalPath();
        String computedWebRoot = webRootC.substring(0, webRootC.length() - "/WEB-INF/web.xml".length());
        fileName = ISCFile.canonicalizePath((String)fileName.substring(computedWebRoot.length()));
        return fileName;
    }

    public String assembleVirtualComponent(String type, String name) throws Exception {
        log.debug((Object)("assembleVirtualComponent type: " + type + " name: " + (String)name));
        if (type.equals("xmlFile")) {
            if (!new File((String)name).isAbsolute()) {
                name = webRoot + "/" + (String)name;
            }
        } else if (type.equals("ds") || type.equals("app") || type.equals("ui")) {
            name = this.fileNameForType(type, (String)name);
        } else {
            throw new Exception("Virtual type '" + type + "' is not supported.");
        }
        Object virtualPath = name = ISCFile.canonicalizePath((String)name);
        if (((String)name).startsWith(webRoot)) {
            virtualPath = ((String)virtualPath).substring(webRoot.length());
        }
        virtualPath = "/virtualXML" + DataTools.makePathAppendable((String)virtualPath) + ".js";
        log.debug((Object)("Derived virtualPath: " + (String)virtualPath));
        HashMap assemblyData = new HashMap();
        ArrayList<Map> components = new ArrayList<Map>();
        assemblyData.put("components", components);
        Map component = DataTools.mapMerge((Map)this.getVirtualXMLInstructions(), (Map)DataTools.buildMap((Object[])new Object[]{"type", "xmlFile", "fileName", name}));
        components.add(component);
        this.configure((String)virtualPath, assemblyData, config.getBoolean((Object)"debug", false));
        return this.assemble();
    }

    public String assembleFile(String virtualPath) throws Exception {
        return this.assembleFile(virtualPath, config.getBoolean((Object)"debug", false));
    }

    public String assembleFile(String virtualPath, boolean debug) throws Exception {
        Map assemblyData = this.getAssemblyData(virtualPath);
        if (assemblyData == null) {
            return null;
        }
        this.configure(virtualPath, assemblyData, debug);
        return this.assemble();
    }

    public Object staticInstance() throws Exception {
        return new FileAssembler();
    }

    public FileAssembler() {
        try {
            if (canObfuscate) {
                this.obfuscator = (IObfuscator)InterfaceProvider.load((String)"IObfuscator");
            }
        }
        catch (Exception e) {
            log.fatal((Object)"Configuration error - unable to load IObfuscator interface", (Throwable)e);
            throw new Error(e.toString());
        }
    }

    public Map getAssemblyConfig() throws Exception {
        return this.loadFileAssembly();
    }

    public List getRegisteredURLs() throws Exception {
        return new ArrayList(this.loadFileAssembly().keySet());
    }

    public FileAssembler(String virtualPath, Map assemblyData, boolean debugMode) {
        this();
        this.configure(virtualPath, assemblyData, debugMode);
    }

    public void configure(String virtualPath, Map assemblyData, boolean debugMode) {
        this.virtualPath = virtualPath;
        this.assemblyData = assemblyData;
        this.debugMode = debugMode;
    }

    public String assemble() throws Exception {
        OutputStream fileOutputStream;
        log.info((Object)("Processing dynamically assembled file " + this.virtualPath));
        boolean compress = DataTools.getBoolean((Map)this.assemblyData, (Object)"compress");
        if (compress && !canCompress) {
            log.error((Object)("Compression is enabled for: " + this.virtualPath + ", but compression module is not present - unable to compress."));
            compress = false;
        }
        if (compress && !config.getBoolean((Object)"servlet.compress", false)) {
            log.warn((Object)("Compression is enabled for: " + this.virtualPath + ", but compression is globally disabled via servlet.compress: false in server.properties"));
            compress = false;
        }
        String assembledFileName = ISCFile.canonicalizePath((String)(this.getCacheDir() + "/" + this.virtualPath));
        ISCFile assembledFile = ISCFile.newInstance((String)assembledFileName);
        log.debug((Object)("Assembled file name: " + assembledFileName));
        ISCFile parentDir = ISCFile.newInstance((String)assembledFile.getParent());
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
        }
        if (!assembledFile.exists()) {
            log.debug((Object)("Initial creation for assembled file " + assembledFileName));
        }
        long assembledFileLastModified = new Date().getTime();
        this.components = (List)this.assemblyData.get("components");
        this.components = this.makeComponentObjects(this.components);
        if (this.componentsUpToDate(assembledFile.lastModified(), this.components)) {
            log.debug((Object)("Assembled file " + assembledFileName + " is up to date"));
            return ISCFile.canonicalizePath((String)assembledFileName);
        }
        log.debug((Object)("Assembled file " + assembledFileName + " is stale, rebuilding"));
        OutputStream masterOut = fileOutputStream = assembledFile.getOutputStream();
        String gzFileName = assembledFileName + ".gz";
        ISCFile gzFile = ISCFile.newInstance((String)gzFileName);
        if (compress) {
            log.debug((Object)("Also preparing gzipped version of " + this.virtualPath));
            ICompression compression = (ICompression)InterfaceProvider.load((String)"ICompression");
            String mimeType = (String)this.assemblyData.get("mimeType");
            if (mimeType == null) {
                mimeType = DataTools.mimeTypeForFileName((String)assembledFileName);
            }
            OutputStream gzFileOutputStream = compression.getPrimedGZIPOutputStream(gzFile.getOutputStream(), mimeType);
            masterOut = new TeeOutputStream(fileOutputStream, gzFileOutputStream);
        } else {
            try {
                if (gzFile.exists()) {
                    gzFile.delete();
                }
            }
            catch (Exception compression) {
                // empty catch block
            }
        }
        OutputStreamWriter masterWriter = new OutputStreamWriter(masterOut);
        for (Component component : this.components) {
            if (component instanceof JSFileListComponent) {
                Object stripType = ((JSFileListComponent)component).componentData.get((Object)"jsStripping");
                Object explicitForceObfuscationSetting = ((JSFileListComponent)component).componentData.get((Object)"forceObfuscation");
                StringWriter sw = new StringWriter();
                List outputs = (List)component.getOutput();
                Iterator f = outputs.iterator();
                while (f.hasNext()) {
                    IOUtil.addOutput((Writer)sw, f.next());
                }
                String buffer = sw.toString();
                if (!forceObfuscation || "false".equals(explicitForceObfuscationSetting) || "none".equals(stripType) || "debug".equals(stripType)) {
                    buffer = buffer.replaceAll("(?s)/\\*-=-.*?\\*/", " ");
                    buffer = buffer.replaceAll("(?m)[\t ]+$", "");
                    buffer = buffer.replaceAll("\t", "    ");
                    IOUtil.addOutput((Writer)masterWriter, (Object)buffer);
                } else {
                    buffer = FileAssembler.stripWhitespace(buffer, true);
                    buffer = buffer.replaceAll("(?m)[\t ]+$", "");
                    buffer = buffer.replace("\t", "    ");
                    List bufferPieces = DataTools.perl5Split((String)buffer, (String)"/\\*.*?\\*/");
                    for (int i = 0; i < bufferPieces.size(); ++i) {
                        String bufferPiece = (String)bufferPieces.get(i);
                        if (bufferPiece.startsWith("/*") && bufferPiece.endsWith("*/")) {
                            IOUtil.addOutput((Writer)masterWriter, (Object)bufferPiece);
                            continue;
                        }
                        IOUtil.addOutput((Writer)masterWriter, (Object)FileAssembler.safeMinify(bufferPiece));
                    }
                }
            } else {
                Object outputObj = component.getOutput();
                IOUtil.addOutput((Writer)masterWriter, (Object)outputObj);
            }
            masterWriter.append('\n');
        }
        try {
            masterWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            masterOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            assembledFile.setLastModified(assembledFileLastModified);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compress && gzFile != null) {
            try {
                gzFile.setLastModified(assembledFileLastModified);
                log.info((Object)("Final sizes: " + assembledFile.length() / 1024L + " kb normal, " + gzFile.length() / 1024L + " kb compressed"));
            }
            catch (Exception exception) {}
        } else {
            try {
                log.info((Object)("Final size: " + assembledFile.length() / 1024L + " kb normal, compression disabled."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ISCFile.canonicalizePath((String)assembledFileName);
    }

    boolean componentsUpToDate(long lastBuilt, List components) throws Exception {
        for (int i = 0; i < components.size(); ++i) {
            Component component = (Component)components.get(i);
            if (component.upToDate(lastBuilt)) continue;
            return false;
        }
        return true;
    }

    List makeComponentObjects(List componentsData) throws Exception {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < componentsData.size(); ++i) {
            Object componentData = componentsData.get(i);
            if (componentData instanceof String) {
                String fileName = (String)componentData;
                HashMap instructions = new HashMap(this.assemblyData);
                if (fileName.endsWith(".xml") && this.virtualPath.endsWith(".js")) {
                    components.add(new XMLFileComponent(fileName, instructions));
                    continue;
                }
                components.add(new FileComponent(fileName, instructions));
                continue;
            }
            if (componentData instanceof Map) {
                Map m = (Map)componentData;
                if (m.get("jsStripping") == null) {
                    m.put("jsStripping", this.assemblyData.get("jsStripping"));
                }
                if (m.get("jsObfuscation") == null) {
                    m.put("jsObfuscation", this.assemblyData.get("jsObfuscation"));
                }
                components.add(this.makeComponent((Map)componentData));
                continue;
            }
            throw new Exception("Unsupported assembled file component format" + String.valueOf(componentData));
        }
        return components;
    }

    Component makeComponent(Map componentData) throws Exception {
        Component component;
        String type = (String)componentData.get("type");
        if (type == null) {
            Exception e = new Exception("Component has no type: " + String.valueOf(componentData));
            log.warn((Object)"Exception in makeComponent: ", (Throwable)e);
            log.warn((Object)("assemblyData: " + String.valueOf(this.assemblyData)));
            log.warn((Object)("assemblyInstructions: " + String.valueOf(this.assemblyInstructions)));
            throw e;
        }
        if (type.equals("file")) {
            String fileName = (String)componentData.get("fileName");
            if (fileName == null) {
                throw new Exception("Can't find a 'fileName' attribute on component with config block: " + DataTools.prettyPrint((Object)componentData));
            }
            return new FileComponent(fileName, componentData);
        }
        if (type.equals("jsFileList") || type.equals("jsModule")) {
            return new JSFileListComponent(componentData);
        }
        if (type.equals("xmlFile")) {
            String name = (String)componentData.get("fileName");
            if (name == null) {
                name = (String)componentData.get("name");
            }
            return new XMLFileComponent(name, componentData);
        }
        if (type.equals("datasource") || type.equals("ds")) {
            String name = (String)componentData.get("name");
            if (name == null) {
                name = (String)componentData.get("id");
            }
            try {
                return new DataSourceComponent(name, componentData);
            }
            catch (Exception dsException) {
                try {
                    return new TypeComponent(name, componentData);
                }
                catch (Exception ignored) {
                    throw dsException;
                }
            }
        }
        if (type.equals("type")) {
            String name = (String)componentData.get("name");
            if (name == null) {
                name = (String)componentData.get("id");
            }
            return new TypeComponent(name, componentData);
        }
        if (type.equals("app")) {
            String name = (String)componentData.get("name");
            if (name == null) {
                name = (String)componentData.get("id");
            }
            return new AppComponent(name, componentData);
        }
        if (type.equals("ui")) {
            String name = (String)componentData.get("name");
            if (name == null) {
                name = (String)componentData.get("id");
            }
            return new UIComponent(name, componentData);
        }
        try {
            component = (Component)Reflection.newInstance((String)type, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new Exception("Can't create a component of type '" + type + "', " + DataTools.getStackTrace((Throwable)e));
        }
        component.init(componentData);
        return component;
    }

    private Reader getStrippedFile(String fileName, Map stripConfig, boolean syntaxScan) throws Exception {
        String strippedFileName = this.getStrippedFileName(fileName);
        String obfuscationLevel = (String)stripConfig.get("jsObfuscation");
        if (!(!this.strippedFileIsUpToDate(fileName) || "2".equals(obfuscationLevel) && canObfuscate)) {
            return ISCFile.newInstance((String)strippedFileName).getReader();
        }
        Reader strippedReader = this.stripJSFile(fileName, stripConfig);
        if (this.syntaxScanComponentFiles && syntaxScan) {
            String absFileName = webRoot + "/" + fileName;
            JSSyntaxScanner ss = new JSSyntaxScanner();
            String strippedFileContents = IOUtil.readerToString((Reader)strippedReader);
            ss.scanJS(strippedFileContents, absFileName);
            strippedReader = new StringReader(strippedFileContents);
        }
        return strippedReader;
    }

    boolean strippedFileIsUpToDate(String fileName) throws Exception {
        ISCFile origFile = ISCFile.newInstance((String)(webRoot + "/" + fileName));
        String strippedFileName = this.getStrippedFileName(fileName);
        ISCFile strippedFile = ISCFile.newInstance((String)strippedFileName);
        if (!origFile.exists()) {
            if (!strippedFile.exists()) {
                throw new FileNotFoundException("Neither original file '" + origFile.getPath() + "' nor stripped version '" + strippedFile.getPath() + "' is present, can't assemble file!");
            }
            log.debug((Object)("Producion mode: only stripped version of original file '" + origFile.getName() + "' is present"));
        }
        return strippedFile.exists() && strippedFile.lastModified() >= origFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getStrippedDataMap(String fileName, Map stripConfig, boolean syntaxScan) throws Exception {
        Map data;
        if (this.strippedStructCache.get(fileName) != null && this.strippedFileIsUpToDate(fileName)) {
            return (Map)this.strippedStructCache.get(fileName);
        }
        Object mergedStripConfig = DataTools.buildMap((Object[])new Object[]{"jsStripping", "none"});
        mergedStripConfig = DataTools.mapMerge((Map)stripConfig, (Map)mergedStripConfig);
        try (Reader reader = this.getStrippedFile(fileName, (Map)mergedStripConfig, syntaxScan);){
            data = (Map)JSTranslater.instance().fromJSMap(reader);
        }
        this.strippedStructCache.put(fileName, data);
        return data;
    }

    private static String safeMinify(String buffer) {
        if (buffer.indexOf(96) >= 0) {
            return buffer;
        }
        buffer = buffer.replaceAll("\\s*[\\n\\r]+", "\n");
        buffer = buffer.replaceAll("[\\n\\r]+([;:.?,|&=\\])}])", "$1");
        buffer = buffer.replaceAll("([;:.?,|&=\\[{(])[\\n\\r]+", "$1");
        buffer = buffer.replaceAll("([^+]\\+)[\\n\\r]+", "$1");
        buffer = buffer.replaceAll("[\\n\\r]+(\\+[^+])", "$1");
        return buffer;
    }

    private Reader stripJSFile(String fileName, Map stripConfig) throws Exception {
        int preOb;
        int tokenStart;
        String stripType = null;
        String obfuscationLevel = null;
        boolean obfuscatePrivateIdentifiers = false;
        boolean doXmlTransform = stripConfig.get("doXmlTransform") != null;
        boolean stripLog = DataTools.getBoolean((Map)stripConfig, (Object)"jsLogStripping");
        boolean rewriteAddMethods = DataTools.getBoolean((Map)stripConfig, (Object)"rewriteAddMethods");
        boolean combineInternalMethods = DataTools.getBoolean((Map)stripConfig, (Object)"combineInternalMethods");
        String globalsReporting = null;
        boolean captureCrashFrame = false;
        if (stripConfig != null) {
            DataTypeMap typedStripConfig = new DataTypeMap(stripConfig);
            stripType = typedStripConfig.getString((Object)"jsStripping");
            String explicitForceObfuscationSetting = typedStripConfig.getString((Object)"forceObfuscation");
            String type = typedStripConfig.getString((Object)"type");
            if (forceObfuscation && !"false".equals(explicitForceObfuscationSetting) && fileName.endsWith(".js") && (type == null || !type.equals("jsFileList") && !type.equals("jsModule"))) {
                stripType = "full";
            }
            obfuscationLevel = typedStripConfig.getString((Object)"jsObfuscation");
            if (forceObfuscation && !"false".equals(explicitForceObfuscationSetting) && fileName.endsWith(".js") && (type == null || !type.equals("jsFileList") && !type.equals("jsModule"))) {
                obfuscationLevel = "1";
            }
            if (obfuscationLevel != null && !canObfuscate) {
                if (forceObfuscation) {
                    throw new Exception("This package requires obfuscation.");
                }
                log.warn((Object)(fileName + " requests obfuscation level " + obfuscationLevel + " - but this package is not capable of obfuscation - NOT OBFUSCATING"));
                obfuscationLevel = null;
            }
            if ((globalsReporting = typedStripConfig.getString((Object)"jsGlobalsReporting")) != null && !canObfuscate) {
                log.warn((Object)(fileName + " requests globals reporting - but this package is not capable of globals reporting - GLOBALS REPORTING OFF"));
                globalsReporting = null;
            }
            boolean bl = captureCrashFrame = !"prod".equals(devMode) && typedStripConfig.getBoolean((Object)"captureCrashFrame", false);
            if (captureCrashFrame && !canObfuscate) {
                log.warn((Object)(fileName + " requests capture of crash frame reporting - but this package is not capable of capture crash frames - CAPTURE CRASH FRAME OFF"));
                captureCrashFrame = false;
            }
            obfuscatePrivateIdentifiers = typedStripConfig.getBoolean((Object)"obfuscatePrivateIdentifiers", false);
            if (forceObfuscation && !"false".equals(explicitForceObfuscationSetting)) {
                obfuscatePrivateIdentifiers = true;
            }
            if (obfuscatePrivateIdentifiers && !canObfuscate) {
                if (forceObfuscation && !"false".equals(explicitForceObfuscationSetting)) {
                    throw new Exception("This package requires obfuscation");
                }
                log.warn((Object)(fileName + " requests private identifier obfuscation - but this package is not capable of obfuscation - NOT OBFUSCATING"));
                obfuscatePrivateIdentifiers = false;
            }
            if (!(globalsReporting == null && !captureCrashFrame || obfuscationLevel != null || forceObfuscation && !"false".equals(explicitForceObfuscationSetting))) {
                obfuscationLevel = "0";
            }
            if (combineInternalMethods && (!rewriteAddMethods || !obfuscatePrivateIdentifiers || obfuscationLevel == null || "0".equals(obfuscationLevel))) {
                combineInternalMethods = false;
                log.warn((Object)"combineInternalMethods disabled - requires local variable obfuscation, private identifier obfuscation and rewriteAddMethods to enable");
            }
            if (sourceMode && (!forceObfuscation || "false".equals(explicitForceObfuscationSetting))) {
                obfuscationLevel = null;
                rewriteAddMethods = false;
                combineInternalMethods = false;
                globalsReporting = null;
                stripLog = false;
                stripType = "none";
                captureCrashFrame = false;
            }
        }
        List stripTokens = this.getStripTokens(stripConfig, fileName);
        String origFileName = webRoot + "/" + fileName;
        ISCFile origFile = ISCFile.newInstance((String)origFileName);
        Reader reader = null;
        if (doXmlTransform) {
            StringWriter out = new StringWriter();
            if (stripTokens != null && stripTokens.size() > 0) {
                reader = origFile.getReader();
                IOUtil.copyCharacterStreams((Reader)reader, (Writer)out);
                String buf = FileAssembler.doStripTokens(out.toString(), stripTokens);
                out = new StringWriter();
                XML.toJS((String)buf, (Writer)out);
            } else {
                XML.toJS((ISCFile)origFile, (Writer)out);
            }
            reader = new StringReader(out.toString());
        } else {
            reader = origFile.getReader();
        }
        if (stripType == null) {
            log.debug((Object)"jsStripping is null, returning unmodified file");
            return reader;
        }
        StringWriter bufferWriter = new StringWriter();
        IOUtil.copyCharacterStreams((Reader)reader, (Writer)bufferWriter);
        reader.close();
        Object buffer = bufferWriter.toString();
        log.debug((Object)("===== Processing " + origFile.getName() + " ====="));
        int oldSize = ((String)buffer).length();
        long start = System.currentTimeMillis();
        if (stripLog) {
            buffer = this.obfuscator.removeLogging((String)buffer);
        }
        if (!this.debugMode) {
            buffer = ((String)buffer).replaceAll("(?s)//>DEBUG.*?//<DEBUG", "");
        }
        boolean last = false;
        int c = 1;
        HashMap<CallSite, String> pieces = new HashMap<CallSite, String>();
        String dns = "DoNotStrip";
        String codePrelude = "var _thisWillBeObfuscated='";
        String tokenPrelude = "doNotStripPiece";
        String codeCoda = "';";
        DecimalFormat nf = new DecimalFormat("0000");
        while ((tokenStart = ((String)buffer).indexOf("//>" + dns)) != -1) {
            int tokenEnd = ((String)buffer).indexOf("//<" + dns);
            if (tokenEnd == -1) {
                tokenEnd = ((String)buffer).length() - ("//<" + dns).length();
            }
            String piece = ((String)buffer).substring(tokenStart + ("//>" + dns).length(), tokenEnd);
            String key = tokenPrelude + nf.format(c++);
            pieces.put((CallSite)((Object)key), piece);
            buffer = ((String)buffer).substring(0, tokenStart) + codePrelude + key + codeCoda + ((String)buffer).substring(tokenEnd += ("//<" + dns).length());
        }
        buffer = FileAssembler.doStripTokens((String)buffer, stripTokens);
        if ("full".equals(stripType) && backCompatDate != null) {
            buffer = FileAssembler.stripBackCompat((String)buffer, backCompatDate);
        }
        if (this.obfuscator != null) {
            buffer = this.obfuscator.stripJSBuffer(fileName, (String)buffer, stripConfig, stripType);
        }
        if (!stripType.equals("none")) {
            // empty if block
        }
        if (!"none".equals(stripType) && !"debug".equals(stripType) || obfuscationLevel != null && !"0".equals(obfuscationLevel)) {
            long stripStart = System.currentTimeMillis();
            buffer = FileAssembler.stripWhitespace((String)buffer, false);
            long stripTime = System.currentTimeMillis() - stripStart;
            Logger.timing.debug((Object)("Basic strip: " + stripTime + "ms"));
        }
        if (!stripType.equals("debug") && (stripType.equals("full") || obfuscationLevel != null)) {
            if (obfuscationLevel != null) {
                preOb = ((String)buffer).length();
                this.obfuscator.setObfuscationLevel(obfuscationLevel);
                this.obfuscator.setCombineInternalMethods(combineInternalMethods);
                this.obfuscator.setRewriteAddMethods(rewriteAddMethods);
                this.obfuscator.setGlobalsReporting(globalsReporting);
                this.obfuscator.setCaptureCrashFrame(captureCrashFrame);
                buffer = this.obfuscator.obfuscate((String)buffer, origFile.getName());
                log.debug((Object)("Obfuscated " + origFile.getName() + ": " + preOb + " -> " + ((String)buffer).length()));
            }
            buffer = ((String)buffer).replaceAll("(?m)//\\!((DONT(OBFUSCATE|COMBINE))|(OBFUSCATEOK)).*$", "");
        }
        if (!stripType.equals("debug") && obfuscatePrivateIdentifiers) {
            preOb = ((String)buffer).length();
            buffer = this.obfuscator.obfuscatePrivateIdentifiers(fileName, (String)buffer);
            log.debug((Object)("Obfuscated private identifiers " + origFile.getName() + ": " + preOb + " -> " + ((String)buffer).length()));
        }
        if (stripType.equals("full")) {
            buffer = ((String)buffer).replaceAll(";\\s*}", "}");
        } else if (!stripType.equals("none")) {
            // empty if block
        }
        String deferredLoading = (String)stripConfig.get("deferredLoading");
        if ("true".equals(deferredLoading)) {
            log.warn((Object)"checking for Deferred code blocks");
            boolean codeWasDeferred = false;
            JSTranslater jsTrans = JSTranslater.instance();
            Matcher matcher = DEFERRED_LOADING_DIRECTIVE_PATTERN.matcher((CharSequence)buffer);
            while (matcher.reset((CharSequence)buffer).find()) {
                codeWasDeferred = true;
                String deferredCode = matcher.group(1);
                int deferStart = matcher.start();
                int deferEnd = matcher.end();
                buffer = ((String)buffer).substring(0, deferStart) + "isc.defer(" + jsTrans.toJS((Object)deferredCode) + ");" + ((String)buffer).substring(deferEnd);
            }
            if (codeWasDeferred) {
                log.warn((Object)("code after deferrals:" + (String)buffer));
            }
        }
        if (stripType.equals("full")) {
            buffer = ((String)buffer).replaceAll("(?m)//\\![<>]Deferred.*$", "");
        }
        if (stripType.equals("full")) {
            buffer = FileAssembler.safeMinify((String)buffer);
        }
        buffer = ((String)buffer).replaceAll(";isc\\.__cr;", "\n");
        for (String token : pieces.keySet()) {
            String piece = (String)pieces.get(token);
            int tokenStart2 = ((String)buffer).indexOf(token);
            if (tokenStart2 < 7) {
                log.warn((Object)("Found DoNotStrip placeholder '" + token + "' in an impossible position - ignoring"));
                continue;
            }
            int tokenFound = tokenStart2;
            while (tokenStart2 >= 3) {
                if (((String)buffer).charAt(--tokenStart2) != ' ' || ((String)buffer).charAt(tokenStart2 - 1) != 'r' || ((String)buffer).charAt(tokenStart2 - 2) != 'a' || ((String)buffer).charAt(tokenStart2 - 3) != 'v') continue;
                tokenStart2 -= 3;
                break;
            }
            int tokenEnd = tokenFound + token.length() + codeCoda.length();
            buffer = ((String)buffer).substring(0, tokenStart2) + piece + ((String)buffer).substring(tokenEnd);
        }
        long totalTime = System.currentTimeMillis() - start;
        log.info((Object)("Stripped " + origFile.getName() + ": " + oldSize + " -> " + ((String)buffer).length() + " (" + (this.debugMode ? "keepDebug" : "stripDebug") + ", " + stripType + (stripLog ? ", stripLog" : "") + (obfuscatePrivateIdentifiers ? ", obfuscatePrivateIdents" : "") + ") Total time: " + totalTime + "ms"));
        IOUtil.atomicWrite((String)buffer, (ISCFile)ISCFile.newInstance((String)this.getStrippedFileName(fileName)));
        return new StringReader((String)buffer);
    }

    public static String stripWhitespace(String buffer, boolean isFinalStrip) throws Exception {
        StringBuilder out = new StringBuilder(buffer.length());
        int pos = 0;
        char c = '\uffffffff';
        int TT_COMMENT = -2;
        char c2 = '\ufffffffd';
        char c3 = '\ufffffffc';
        char c4 = '\ufffffffb';
        char c5 = '\ufffffffa';
        char lastToken = c;
        block8: while (pos < buffer.length()) {
            char theChar = buffer.charAt(pos);
            switch (theChar) {
                case '\"': 
                case '\'': {
                    char c6;
                    int out_length;
                    int end = FileAssembler.matchString(buffer, pos);
                    if (isFinalStrip) {
                        boolean stringPlus = false;
                        for (out_length = out.length(); out_length > 0; --out_length) {
                            c6 = out.charAt(out_length - 1);
                            if (stringPlus && c6 == theChar) {
                                ++pos;
                                out.setLength(out_length - 1);
                                break;
                            }
                            if (!stringPlus && c6 == '+') {
                                stringPlus = true;
                                continue;
                            }
                            if (c6 != ' ' && c6 != '\n') break;
                        }
                    }
                    out.append(buffer, pos, end);
                    pos = end;
                    lastToken = c2;
                    continue block8;
                }
                case '`': {
                    int end = FileAssembler.matchTemplateLiteral(buffer, pos);
                    out.append(buffer, pos, end);
                    pos = end;
                    lastToken = c2;
                    continue block8;
                }
                case '\t': 
                case ' ': {
                    if (!isFinalStrip && lastToken == c) {
                        if (theChar == '\t') {
                            out.append("    ");
                        } else {
                            out.append(theChar);
                        }
                    }
                    ++pos;
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (lastToken == c4) {
                        out.append(' ');
                    }
                    out.append(theChar);
                    lastToken = c3;
                    ++pos;
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    char c7;
                    int out_length;
                    for (out_length = out.length(); out_length > 0 && (c7 = out.charAt(out_length - 1)) == ' '; --out_length) {
                    }
                    out.setLength(out_length);
                    if (lastToken != c) {
                        out.append('\n');
                    }
                    ++pos;
                    lastToken = c;
                    continue block8;
                }
                case '/': {
                    char c6;
                    int out_length;
                    int end;
                    if (buffer.charAt(pos + 1) == '/') {
                        char c22;
                        String restOfLine;
                        end = FileAssembler.findEOL(buffer, pos + 2);
                        if (!isFinalStrip && buffer.charAt(pos + 2) == '!' && end > pos + 5 && ((restOfLine = buffer.substring(pos + 4, end)).startsWith("Deferred") || restOfLine.startsWith("ONTOBFUSCATE") || restOfLine.startsWith("ONTCOMBINE") || restOfLine.startsWith("BFUSCATEOK"))) {
                            out.append(buffer, pos, end);
                            out.append('\n');
                            pos = end;
                            lastToken = c;
                            continue block8;
                        }
                        for (out_length = out.length(); out_length > 0 && (c22 = out.charAt(out_length - 1)) == ' '; --out_length) {
                        }
                        out.setLength(out_length);
                        if (lastToken != c) {
                            out.append('\n');
                        }
                        pos = end;
                        lastToken = c;
                        continue block8;
                    }
                    if (buffer.charAt(pos + 1) == '*') {
                        end = buffer.indexOf("*/", pos + 2) + 2;
                        if (isFinalStrip) {
                            out.append(buffer, pos, end).append('\n');
                        }
                        pos = end;
                        continue block8;
                    }
                    boolean definitelyNotRegex = false;
                    if (lastToken == c) {
                        c6 = lastToken;
                        for (end = pos - 2; end > 0 && ((c6 = (char)buffer.charAt(end)) == '\n' || c6 == '\r' || c6 == ' '); --end) {
                        }
                        if ('0' <= c6 && c6 <= '9' || c6 == ')' || c6 == ']') {
                            definitelyNotRegex = true;
                            for (out_length = out.length(); out_length > 0 && ((c6 = (char)out.charAt(out_length - 1)) == '\n' || c6 == '\r' || c6 == ' '); --out_length) {
                            }
                            out.setLength(out_length);
                        }
                    } else {
                        boolean bl = definitelyNotRegex = lastToken == c4 || lastToken == c3 || lastToken == ')' || lastToken == ']';
                    }
                    if (definitelyNotRegex) {
                        out.append(theChar);
                        ++pos;
                        lastToken = theChar;
                        continue block8;
                    }
                    end = FileAssembler.matchString(buffer, pos);
                    if (end == -1) {
                        out.append(theChar);
                        ++pos;
                        lastToken = theChar;
                        continue block8;
                    }
                    out.append(buffer, pos, end);
                    pos = end;
                    lastToken = c5;
                    continue block8;
                }
            }
            if (Character.isJavaIdentifierStart(theChar)) {
                String id = FileAssembler.grabIdentifier(buffer, pos);
                if (lastToken == c4) {
                    out.append(' ');
                }
                lastToken = c4;
                out.append(id);
                pos += id.length();
                continue;
            }
            out.append(theChar);
            lastToken = theChar;
            ++pos;
        }
        return out.toString();
    }

    public static List filesNewerThan(long timestamp, List files) throws IOException {
        ArrayList<String> newerFiles = new ArrayList<String>();
        for (String fileName : files) {
            ISCFile checkFile = ISCFile.newInstance((String)fileName);
            if (!checkFile.exists()) {
                log.warning((Object)("filesNewerThan(): file " + fileName + " doesn't exist, ignoring"));
                continue;
            }
            if (checkFile.lastModified() <= timestamp) continue;
            newerFiles.add(fileName);
        }
        return newerFiles;
    }

    public String getStrippedFileName(String fileName) throws Exception {
        ISCFile file = ISCFile.newInstance((String)(this.getCacheDir() + "/stripped/" + fileName));
        ISCFile parentDir = ISCFile.newInstance((String)file.getParent());
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
        }
        return file.getPath();
    }

    private List getStripTokens(Map stripConfig, String fileName) throws Exception {
        ArrayList<String> stripTokens = new ArrayList<String>();
        stripTokens.addAll(stripTokenDefaults);
        Object obj = stripConfig.get("stripTokens");
        if (obj != null) {
            if (obj instanceof List) {
                stripTokens.addAll((List)obj);
            } else if (obj instanceof Map) {
                DataTypeMap stripTokenConfig = new DataTypeMap((Map)obj);
                for (String token : stripTokenConfig.keySet()) {
                    Boolean includeToken = stripTokenConfig.getBoolean((Object)token);
                    if (includeToken == null) {
                        throw new Exception("Unrecognized value '" + stripTokenConfig.get((Object)token).toString() + "' for stripToken '" + token + "' in stripConfig for filename: " + fileName);
                    }
                    if (includeToken.booleanValue()) {
                        stripTokens.add(token);
                        continue;
                    }
                    stripTokens.remove(token);
                }
            } else {
                throw new Exception("Unsupported stripTokens type: " + obj.getClass().getName() + " in stripConfig for filename: " + fileName);
            }
        }
        stripTokens.addAll(devStripTokens);
        stripTokens.addAll(prodStripTokens);
        return stripTokens;
    }

    private static String doStripTokens(String buffer, List stripTokens) throws Exception {
        if (stripTokens != null) {
            for (String token : stripTokens) {
                buffer = buffer.replaceAll("(?s)//>" + token + "[\\s\\r\\n](.*?)//<" + token, "");
            }
        }
        return buffer;
    }

    public static String stripBackCompat(String buffer, Date backCompatDate) throws Exception {
        if (backCompatDate == null) {
            return buffer;
        }
        StringWriter out = new StringWriter();
        Matcher matcher = BACKCOMPAT_START_PATTERN.matcher(buffer);
        int lastStartPos = 0;
        while (matcher.find()) {
            ((Writer)out).write(buffer, lastStartPos, matcher.start());
            boolean doStrip = true;
            if (matcher.group(1) == null) {
                log.warn((Object)"No date provided for BackCompat token");
                doStrip = false;
            } else {
                try {
                    Date parsedDate = sdf.parse(matcher.group(1));
                    if (backCompatDate.compareTo(parsedDate) <= 0) {
                        doStrip = false;
                    }
                }
                catch (ParseException e) {
                    log.warn((Object)"Invalid date provided for BackCompat token");
                    doStrip = false;
                }
            }
            String token = matcher.group();
            buffer = buffer.substring(matcher.end());
            if (doStrip) {
                if (matcher.usePattern(BACKCOMPAT_END_PATTERN).reset(buffer).find()) {
                    buffer = buffer.substring(matcher.end());
                    continue;
                }
                log.warn((Object)"Closing tag not found for BackCompat token");
            }
            ((Writer)out).write(token);
        }
        ((Writer)out).write(buffer);
        return ((Object)out).toString();
    }

    public static int matchString(String text, int startPos) {
        char quoteChar = text.charAt(startPos++);
        while (startPos < text.length()) {
            char theChar = text.charAt(startPos);
            if (theChar == '\n' || theChar == '\r') {
                return -1;
            }
            if (theChar == quoteChar) {
                return startPos + 1;
            }
            if (theChar == '\\') {
                ++startPos;
            }
            ++startPos;
        }
        return text.length();
    }

    public static int matchTemplateLiteral(String text, int startPos) {
        assert (text.charAt(startPos) == '`');
        ++startPos;
        while (startPos < text.length()) {
            char theChar = text.charAt(startPos);
            if (theChar == '`') {
                return startPos + 1;
            }
            if (theChar == '\\') {
                ++startPos;
            } else if (theChar == '$') {
                if (startPos + 1 >= text.length()) {
                    return -1;
                }
                char nextChar = text.charAt(startPos + 1);
                if (nextChar == '{') {
                    startPos += 2;
                    int braceLevel = 1;
                    while (startPos < text.length()) {
                        if ((startPos = FileAssembler.skipStringsAndComments(text, startPos)) < 0 || startPos >= text.length()) {
                            return -1;
                        }
                        theChar = text.charAt(startPos);
                        if (theChar == '{') {
                            ++braceLevel;
                        } else if (theChar == '}' && --braceLevel <= 0) break;
                        ++startPos;
                    }
                }
            }
            ++startPos;
        }
        return text.length();
    }

    public static int findStringStart(String text, int pos) {
        int singleIndex = text.indexOf(39, pos);
        int doubleIndex = text.indexOf(34, pos);
        if (singleIndex == -1) {
            singleIndex = text.length() - 1;
        }
        if (doubleIndex == -1) {
            doubleIndex = text.length() - 1;
        }
        return Math.min(singleIndex, doubleIndex);
    }

    public static int matchExpression(String text, int startPos) {
        block6: while (startPos < text.length()) {
            if ((startPos = FileAssembler.skipStringsAndComments(text, startPos)) < 0 || startPos >= text.length()) {
                return -1;
            }
            char theChar = text.charAt(startPos);
            switch (theChar) {
                case ',': 
                case ';': {
                    return startPos + 1;
                }
                case '(': {
                    startPos = FileAssembler.matchNested(text, startPos, '(', ')');
                    continue block6;
                }
                case '{': {
                    startPos = FileAssembler.matchNested(text, startPos, '{', '}');
                    continue block6;
                }
                case '[': {
                    startPos = FileAssembler.matchNested(text, startPos, '[', ']');
                    continue block6;
                }
            }
            ++startPos;
        }
        return startPos;
    }

    public static int matchNested(String text, int startPos, char matchStart, char matchEnd) {
        int matchCount = 0;
        while (startPos < text.length()) {
            char theChar;
            if ((startPos = FileAssembler.skipStringsAndComments(text, startPos)) < 0 || startPos >= text.length()) {
                return -1;
            }
            if ((theChar = text.charAt(startPos++)) == matchEnd && --matchCount == 0) {
                return startPos;
            }
            if (theChar != matchStart) continue;
            ++matchCount;
        }
        return -1;
    }

    public static int matchWhiteSpaceBefore(String text, int pos) {
        for (int i = pos - 1; i >= 0; --i) {
            char theChar = text.charAt(i);
            if (" \t\r\n".indexOf(theChar) != -1) continue;
            return i;
        }
        return -1;
    }

    public static int matchWhiteSpaceAfter(String text, int pos) {
        for (int i = pos; i < text.length(); ++i) {
            char theChar = text.charAt(i);
            if (" \t\r\n".indexOf(theChar) != -1) continue;
            return i;
        }
        return -1;
    }

    public static int matchNoLineTerminatorWhiteSpaceAfter(String text, int pos) {
        if (pos < text.length()) {
            Matcher matcher = NO_LINE_TERMINATOR_WHITE_SPACE_PATTERN.matcher(text.substring(pos));
            if (matcher.lookingAt()) {
                return pos + matcher.end();
            }
            return pos;
        }
        return -1;
    }

    public static int matchWhiteSpaceAfter2(String text, int pos) {
        if (pos < text.length()) {
            Matcher matcher = WHITE_SPACE_PATTERN.matcher(text.substring(pos));
            if (matcher.lookingAt()) {
                return pos + matcher.end();
            }
            return pos;
        }
        return -1;
    }

    public static boolean indexIsActiveCode(String text, int index) {
        int lineStart = FileAssembler.findLastEOL(text, index);
        int eol = FileAssembler.findEOL(text, index);
        int currentPos = lineStart;
        while (currentPos < eol) {
            if (currentPos == index) {
                return true;
            }
            int newPos = FileAssembler.skipStringsAndComments(text, currentPos);
            if (newPos < 0 || newPos >= text.length()) break;
            if (newPos > currentPos) {
                currentPos = newPos;
                if (currentPos <= index) continue;
                return false;
            }
            ++currentPos;
        }
        log.warn((Object)"error in indexIsActiveCode");
        return true;
    }

    public static int indexOfRegEx(String input, String regex, int startPos) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find(startPos)) {
            return matcher.start();
        }
        return -1;
    }

    public static int findIdentifier(String identifierRegEx, String text, int startPos) throws Exception {
        int currentPos = startPos;
        while (currentPos < text.length()) {
            String candidate;
            String textBeforeCandidate;
            int commentIndex;
            int candidateIndex = FileAssembler.indexOfRegEx(text, identifierRegEx, currentPos);
            if (candidateIndex == -1) {
                return -1;
            }
            while (currentPos < candidateIndex && (commentIndex = (textBeforeCandidate = text.substring(currentPos, candidateIndex)).indexOf("/*")) != -1) {
                if (!FileAssembler.indexIsActiveCode(textBeforeCandidate, commentIndex)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ignoring block comment start within string, line is: " + FileAssembler.lineAroundIndex(textBeforeCandidate, commentIndex)));
                    }
                    currentPos += commentIndex + 2;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found block comment start, line is: " + FileAssembler.lineAroundIndex(textBeforeCandidate, commentIndex)));
                }
                if ((currentPos = FileAssembler.skipStringsAndComments(text, currentPos + commentIndex)) >= 0 && currentPos < text.length()) continue;
                return -1;
            }
            if (currentPos > candidateIndex) continue;
            int lineStart = FileAssembler.findLastEOL(text, candidateIndex);
            int eol = FileAssembler.findEOL(text, candidateIndex);
            for (currentPos = Math.max(lineStart, startPos); currentPos < eol; currentPos += candidate.length()) {
                if ((currentPos = FileAssembler.findNextIdentifierStart(text, currentPos)) == -1) {
                    return -1;
                }
                candidate = FileAssembler.grabIdentifier(text, currentPos);
                if (!candidate.matches(identifierRegEx)) continue;
                return currentPos;
            }
        }
        return -1;
    }

    public static int findNextIdentifierStart(String text, int startPos) {
        while (startPos < text.length()) {
            if ((startPos = FileAssembler.skipStringsAndComments(text, startPos)) < 0 || startPos >= text.length()) {
                return -1;
            }
            char theChar = text.charAt(startPos);
            if (JSTranslater.isJSIdentifierStart((char)theChar)) {
                return startPos;
            }
            ++startPos;
        }
        return -1;
    }

    public static String grabIdentifier(String text, int startPos) throws Exception {
        char theChar = text.charAt(startPos);
        if (!JSTranslater.isJSIdentifierStart((char)theChar)) {
            throw new Exception("not at the start of an identifier");
        }
        int endPos = startPos;
        while (endPos++ < text.length() && JSTranslater.isJSIdentifierPart((char)(theChar = text.charAt(endPos)))) {
        }
        return text.substring(startPos, endPos);
    }

    static String grabIdentifierBefore(String text, int startPos) throws Exception {
        char theChar = text.charAt(startPos);
        if (!Character.isJavaIdentifierPart(theChar)) {
            throw new Exception("not on a legal identifier char");
        }
        int endPos = startPos;
        while (endPos-- > 0 && Character.isJavaIdentifierPart(theChar = text.charAt(endPos))) {
        }
        return text.substring(endPos + 1, startPos + 1);
    }

    static int skipStringsAndComments(String text, int startPos) {
        while (0 <= startPos && startPos < text.length()) {
            int end;
            char theChar = text.charAt(startPos);
            if (theChar == '\"' || theChar == '\'') {
                startPos = end = FileAssembler.matchString(text, startPos);
                continue;
            }
            if (theChar == '`') {
                end = FileAssembler.matchTemplateLiteral(text, startPos);
                if (end >= text.length() && startPos < text.length()) {
                    return -1;
                }
                startPos = end;
                continue;
            }
            if (theChar == '/') {
                if (text.charAt(startPos + 1) == '/') {
                    startPos = end = FileAssembler.findEOL(text, startPos + 2);
                    continue;
                }
                if (text.charAt(startPos + 1) == '*') {
                    int closeComment = text.indexOf("*/", startPos + 2);
                    if (closeComment == -1) {
                        log.warn((Object)("unterminated block comment, starting in line: " + FileAssembler.lineAroundIndex(text, startPos)));
                        return text.length();
                    }
                    startPos = end = closeComment + 2;
                    continue;
                }
                int lastToken = FileAssembler.matchWhiteSpaceBefore(text, startPos);
                if (lastToken == -1 || !Character.isJavaIdentifierPart(text.charAt(lastToken)) && text.charAt(lastToken) != ')' && text.charAt(lastToken) != ']') {
                    startPos = end = FileAssembler.matchString(text, startPos);
                    continue;
                }
            }
            return startPos;
        }
        return startPos;
    }

    public static int findEOL(String text, int startPos) {
        int pos;
        for (pos = startPos; pos < text.length(); ++pos) {
            char theChar = text.charAt(pos);
            if (theChar != '\r' && theChar != '\n') continue;
            return pos;
        }
        return pos;
    }

    public static int findLastEOL(String text, int startPos) {
        for (int pos = startPos; pos >= 0; --pos) {
            char theChar = text.charAt(pos);
            if (theChar != '\r' && theChar != '\n') continue;
            return pos;
        }
        return 0;
    }

    public static String lineAroundIndex(String text, int index) {
        return text.substring(FileAssembler.findLastEOL(text, index), FileAssembler.findEOL(text, index));
    }

    public static String lineBeforeIndex(String text, int index) {
        return text.substring(FileAssembler.findLastEOL(text, index), index);
    }

    public void generateIdentifierStats() throws Exception {
        String virtualPath = "/isomorphic/system/Isomorphic_SmartClient.js";
        ISCSystem.execute((String)"clearAssemblyCache").waitFor();
        Map assemblyData = this.getAssemblyData(virtualPath);
        List components = (List)assemblyData.get("components");
        for (Map component : components) {
            if (!"isomorphic/system/Isomorphic_SmartClient.js".equals(component.get("fileName"))) continue;
            component.put("obfuscatePrivateIdentifiers", "true");
            component.put("jsObfuscation", "1");
        }
        this.configure(virtualPath, assemblyData, true);
        if (this.obfuscator != null) {
            this.obfuscator.setReportPrivateIdentifierStats(true);
        }
        log.warn((Object)this.assemble());
    }

    public void addConfigFile(String configFile) {
        if (this.configFiles == null) {
            this.configFiles = new ArrayList();
        }
        if (!this.configFiles.contains(configFile)) {
            this.configFiles.add(configFile);
        }
    }

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "FileAssembler [options]";
        Options options = new Options();
        options.addOption("h", "help", false, "Show usage message and exit");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Use configuration file (default is $webRoot/fileAssembly.xml). You may specify more than one config file - in that case the configs will be merged (last config wins for URI conflicts).");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"webRoot");
        OptionBuilder.withDescription((String)"webRoot directory (default is defined in config) - the webRoot dir is used as the base dir for relative file reference in the fileAssembly config");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"dir");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.withLongOpt((String)"outputDir");
        OptionBuilder.withDescription((String)"output directory (default is $webRoot/isomorphicCache");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"dir");
        options.addOption(OptionBuilder.create((char)'o'));
        if (devenv) {
            options.addOption("d", "debug", false, "Include debug code (default is false).");
            options.addOption("n", "nodebug", false, "Do not include debug code (default is true),");
            options.addOption("f", "forceObfuscation", false, "Force obfuscation of component files.");
            options.addOption("x", "sourceMode", false, "Source mode - no obfuscation, or transforms, just token stripping.");
            OptionBuilder.withLongOpt((String)"symbolTableFile");
            OptionBuilder.withDescription((String)"Override for symbol table location.");
            OptionBuilder.hasArg();
            OptionBuilder.withValueSeparator((char)' ');
            OptionBuilder.withArgName((String)"file");
            options.addOption(OptionBuilder.create((String)"y"));
            OptionBuilder.withLongOpt((String)"stripTokens");
            OptionBuilder.withDescription((String)"comma-separated (with no whitespaces) list of tokens to strip (defaults to config property fileAssembly.stripTokenDefaults)");
            OptionBuilder.hasArg();
            OptionBuilder.withValueSeparator((char)' ');
            OptionBuilder.withArgName((String)"tokenList");
            options.addOption(OptionBuilder.create((char)'s'));
        }
        boolean debugMode = config.getBoolean((Object)"debug", false);
        FileAssembler fa = new FileAssembler();
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("d") && line.hasOption("n")) {
            throw new Exception("only one of -n or -d may be specified");
        }
        if (devenv && line.hasOption("d")) {
            debugMode = true;
        }
        if (devenv && line.hasOption("n")) {
            debugMode = false;
        }
        if (devenv && line.hasOption("f")) {
            forceObfuscation = true;
        }
        if (devenv && line.hasOption("x")) {
            sourceMode = true;
        }
        if (line.hasOption("h")) {
            FileAssembler.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        if (line.hasOption("w")) {
            webRoot = line.getOptionValue("w");
            config.put((Object)"webRoot", (Object)webRoot);
            if (fa.obfuscator != null) {
                fa.obfuscator.setWebRoot(webRoot);
            }
        }
        if (line.hasOption("y")) {
            String symbolTableFile = line.getOptionValue("y");
            if (fa.obfuscator != null) {
                fa.obfuscator.setSymbolTableFile(symbolTableFile);
            }
        }
        String errorPrefix = "Specified webRoot '" + webRoot + "' ";
        if (DataTools.isContainerIOPath((String)webRoot)) {
            throw new Exception(errorPrefix + "relies on containerIO - this is not supported from the command line.");
        }
        ISCFile file = ISCFile.newInstance((String)webRoot);
        if (!file.exists()) {
            throw new Exception(errorPrefix + "does not exist");
        }
        if (!file.isDirectory()) {
            throw new Exception(errorPrefix + "is not a directory");
        }
        if (!file.canRead()) {
            throw new Exception(errorPrefix + "is not readable");
        }
        log.info((Object)("Using webRoot: " + webRoot));
        if (line.hasOption("c")) {
            fa.configFiles = DataTools.arrayToList((Object[])line.getOptionValues("c"));
            for (String configFile : fa.configFiles) {
                if (FileAssembler.checkConfigFile(configFile) != null) continue;
                throw new Exception("Specified configFile: " + configFile + " does not exist");
            }
        }
        if (line.hasOption("o")) {
            fa.cacheDir = line.getOptionValue("o");
            file = ISCFile.newInstance((String)fa.cacheDir);
            errorPrefix = "Specified outputDir '" + fa.cacheDir + "' ";
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new Exception(errorPrefix + "is not a directory");
                }
                if (!file.canRead()) {
                    throw new Exception(errorPrefix + "is not readable");
                }
                if (!file.canWrite()) {
                    throw new Exception(errorPrefix + "is not writeable");
                }
            } else {
                log.info((Object)(errorPrefix + "does not exist - attempting to auto-create."));
                fa.getCacheDir();
            }
        }
        if (devenv && line.hasOption("s")) {
            String tokenList = line.getOptionValue("s");
            stripTokenDefaults = DataTools.simpleSplit((String)tokenList, (String)",");
        }
        for (String fileName : fa.getAssemblyInstructions().keySet()) {
            System.out.println("Assembling " + fileName);
            try {
                fa.assembleFile(fileName, debugMode);
            }
            catch (Exception ee) {
                log.error((Object)("Top level exception assembling file '" + fileName), (Throwable)ee);
                throw ee;
            }
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "");
    }

    protected static String checkConfigFile(String configFile) throws Exception {
        if (DataTools.pathIsRelative((String)(configFile = ISCFile.canonicalizePath((String)configFile)))) {
            configFile = ISCFile.canonicalizePath((String)(config.getString((Object)"webRoot") + "/" + configFile));
        }
        ISCFile file = ISCFile.newInstance((String)configFile);
        String errorPrefix = "Specified config file '" + configFile + "' ";
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            throw new Exception(errorPrefix + "exist, but is a directory");
        }
        if (!file.canRead()) {
            throw new Exception(errorPrefix + "exists, but is not readable");
        }
        return configFile;
    }

    static {
        String backCompat;
        log = new Logger(FileAssembler.class.getName());
        canObfuscate = InterfaceProvider.exists((String)"IObfuscator", (boolean)false);
        canCompress = InterfaceProvider.exists((String)"ICompression", (boolean)false);
        optionalModules = Arrays.asList("RealtimeMessaging", "Analytics", "AI");
        stripTokenDefaults = config.getList((Object)"fileAssembly.stripTokenDefaults", new ArrayList());
        webRoot = config.getPath("webRoot");
        devenv = config.getBoolean((Object)"devenv", false);
        devMode = config.getString((Object)"devMode", "dev");
        devStripTokens = config.getList((Object)"devStripTokens", new ArrayList());
        backCompatDate = null;
        sdf = new SimpleDateFormat("yyyy.MM.dd");
        forceObfuscation = false;
        sourceMode = false;
        prodStripTokens = new ArrayList();
        if ("prod".equals(devMode)) {
            try {
                forceObfuscation = true;
                String project = config.getString((Object)"project");
                String subproject = config.getString((Object)"dev.branch");
                prodStripTokens = devStripTokens;
                log.warn((Object)"FileAssembler operating in 'prod' mode.  Forcing obfuscation on and writing cache to $webRoot/isomorphicCache_prod");
                log.info((Object)("Using stripTokensfor project: " + project + ", subproject: " + subproject + ": " + prodStripTokens.toString()));
            }
            catch (Exception e) {
                throw new Error("Error setting up 'prod' mode: " + e.getMessage());
            }
        }
        if ((backCompat = config.getString((Object)"backCompatDate")) != null && !"".equals(backCompat)) {
            try {
                backCompatDate = sdf.parse(backCompat);
            }
            catch (ParseException e) {
                log.warn((Object)"backCompatDate unparseable", (Object)backCompat);
            }
        }
        DEFERRED_LOADING_DIRECTIVE_PATTERN = Pattern.compile("(?s)//\\!>Deferred[\\s\\r\\n](.*?)//\\!<Deferred");
        BACKCOMPAT_START_PATTERN = Pattern.compile("//>!BackCompat\\s+([\\d\\.]+)?");
        BACKCOMPAT_END_PATTERN = Pattern.compile("//<!BackCompat");
        NO_LINE_TERMINATOR_WHITE_SPACE_PATTERN = Pattern.compile("(?:[\t\u000b\f \u00a0\ufeff\\p{Zs}]|/\\*(?:[^\n\r*\u2028\u2029]|\\*[^\n\r/\u2028\u2029])*\\*/)+(//[^\n\r\u2028\u2029]*)?");
        WHITE_SPACE_PATTERN = Pattern.compile("(?:[\t\u000b\f \u00a0\ufeff\\p{Zs}]|/\\*(?:[^*]|\\*[^/])*\\*/|//[^\n\r\u2028\u2029]*(?:\n|\r(?!\n)|\u2028|\u2029|\r\n|$))+");
        err = System.err;
    }

    class JSFileListComponent
    implements Component {
        List files;
        DataTypeMap componentData;
        String moduleName;
        boolean reloadedList = false;

        JSFileListComponent(Map componentData) throws Exception {
            this.componentData = new DataTypeMap(componentData);
            this.loadJSFileList();
        }

        void loadJSFileList() throws Exception {
            String fileName = (String)this.componentData.get((Object)"fileName");
            this.moduleName = (String)this.componentData.get((Object)"moduleName");
            if (this.moduleName == null) {
                this.moduleName = fileName;
                if (this.moduleName.indexOf("/") != -1) {
                    this.moduleName = this.moduleName.substring(this.moduleName.lastIndexOf("/") + 1);
                }
                if (this.moduleName.indexOf(".") != -1) {
                    this.moduleName = this.moduleName.substring(0, this.moduleName.indexOf("."));
                }
                if (this.moduleName.startsWith("ISC_")) {
                    this.moduleName = this.moduleName.substring(4);
                }
            }
            if (!FileAssembler.this.strippedFileIsUpToDate(fileName)) {
                this.reloadedList = true;
                log.info((Object)("Reloading list of component files for: " + fileName));
            }
            DataTypeMap stripConfig = DataTools.buildMap((Object[])new Object[]{"stripTokens", this.componentData.get((Object)"stripTokens")});
            stripConfig.put("type", "jsFileList");
            Map fileListData = FileAssembler.this.getStrippedDataMap(fileName, (Map)stripConfig, false);
            List fileNameList = (List)fileListData.get((String)this.componentData.get((Object)"variable"));
            log.debug((Object)("File " + fileName + " contained list of " + fileNameList.size() + " component files"));
            List excludeFiles = (List)this.componentData.get((Object)"excludeFiles");
            if (excludeFiles != null) {
                for (String excludeFile : excludeFiles) {
                    if (!fileNameList.remove(excludeFile)) {
                        log.warn((Object)("File list in " + fileName + " doesn't contain explicitly excluded file: " + excludeFile));
                        continue;
                    }
                    log.info((Object)("File: " + excludeFile + " explicitly excluded."));
                }
            }
            String basePath = (String)this.componentData.get((Object)"basePath");
            ArrayList<FileComponent> fileComponents = new ArrayList<FileComponent>();
            for (Object entry : fileNameList) {
                Map config;
                String path;
                if (entry instanceof String) {
                    path = basePath + (String)entry;
                    config = DataTools.mapMerge((Map)this.componentData, new HashMap());
                } else {
                    Map fileConfig = (Map)entry;
                    path = basePath + (String)fileConfig.get("path");
                    Map baseConfigCopy = DataTools.mapMerge((Map)this.componentData, new HashMap());
                    config = DataTools.mapMerge((Map)fileConfig, (Map)baseConfigCopy);
                }
                if (path.indexOf(".") == -1) {
                    path = path + ".js";
                }
                if (path.endsWith(".xml")) {
                    config.put("doXmlTransform", Boolean.TRUE);
                }
                config.put("type", "file");
                if (path.endsWith(".ds.xml")) {
                    Object newPath = path;
                    if (((String)newPath).contains("/")) {
                        newPath = ((String)newPath).substring(((String)newPath).lastIndexOf("/") + 1);
                    }
                    if (((String)newPath).contains(".")) {
                        newPath = ((String)newPath).substring(0, ((String)newPath).indexOf("."));
                    }
                    fileComponents.add(new DataSourceComponent(path, (String)newPath, config));
                    continue;
                }
                fileComponents.add(new FileComponent(path, config));
            }
            this.files = fileComponents;
        }

        @Override
        public void init(Map componentData) throws Exception {
        }

        @Override
        public boolean upToDate(long lastBuilt) throws Exception {
            if (this.reloadedList) {
                this.reloadedList = false;
                return false;
            }
            for (int i = 0; i < this.files.size(); ++i) {
                Component component = (Component)this.files.get(i);
                if (component.upToDate(lastBuilt)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object getOutput() throws Exception {
            long start = System.currentTimeMillis();
            ArrayList<Object> outputs = new ArrayList<Object>();
            boolean isCore = "Core".equals(this.moduleName);
            boolean isFileLoader = "FileLoader".equals(this.moduleName);
            boolean isHistory = "History".equals(this.moduleName);
            boolean outputAsString = !devMode.equals("prod") && DataTools.getBoolean((Map)this.componentData, (Object)"outputAsString");
            String jsStripping = this.componentData.getString((Object)"jsStripping");
            String explicitForceObfuscationSetting = this.componentData.getString((Object)"forceObfuscation");
            String tsCode = "(isc.timestamp?isc.timestamp():new Date().getTime())";
            String moduleLoadStart = "isc._moduleStart=isc._" + this.moduleName + "_start=" + tsCode + ";";
            moduleLoadStart = moduleLoadStart + "if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'" + this.moduleName + " load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};\nif(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');\nelse if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;\nelse isc._preLog=[isc._pTM]}";
            moduleLoadStart = moduleLoadStart + "isc.definingFramework=true;";
            String moduleLoadEnd = "debug".equals(jsStripping) || !forceObfuscation || "false".equals(explicitForceObfuscationSetting) || this.componentData.getBoolean((Object)"obfuscatePrivateIdentifiers", false) ? "isc._debugModules = (isc._debugModules != null ? isc._debugModules : []);isc._debugModules.push('" + this.moduleName + "');" : "isc._nonDebugModules = (isc._nonDebugModules != null ? isc._nonDebugModules : []);isc._nonDebugModules.push('" + this.moduleName + "');";
            moduleLoadEnd = moduleLoadEnd + "isc.checkForDebugAndNonDebugModules();isc._moduleEnd=isc._" + this.moduleName + "_end=" + tsCode + ";";
            moduleLoadEnd = moduleLoadEnd + "if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('" + this.moduleName + " module init time: ' + (isc._moduleEnd-isc._moduleStart) + 'ms','loadTime');";
            moduleLoadEnd = moduleLoadEnd + "delete isc.definingFramework;";
            moduleLoadEnd = moduleLoadEnd + "if (isc.Page) isc.Page.handleEvent(null, \"moduleLoaded\", { moduleName: '" + this.moduleName + "', loadTime: (isc._moduleEnd-isc._moduleStart)});";
            if (isCore || isFileLoader || isHistory) {
                outputs.add("var isc = window.isc ? window.isc : {};");
            }
            String coreDefined = isCore || isFileLoader || isHistory ? "" : "&&window.isc.module_Core";
            outputs.add("if(window.isc" + coreDefined + "&&!window.isc.module_" + this.moduleName + "){isc.module_" + this.moduleName + "=1;");
            outputs.add(moduleLoadStart);
            if (outputAsString && !isFileLoader && !isHistory) {
                boolean seenObjectJS = false;
                for (int i = 0; i < this.files.size(); ++i) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    Component component = (Component)this.files.get(i);
                    IOUtil.addOutput((OutputStream)os, (Object)component.getOutput());
                    IOUtil.addOutput((OutputStream)os, (Object)"\n");
                    String code = os.toString();
                    List<String> chunks = Arrays.asList(code.split("isc\\.evalBoundary;"));
                    String longestChunk = null;
                    long longestChunkLength = 0L;
                    for (String chunk : chunks) {
                        if ((long)chunk.length() > longestChunkLength) {
                            longestChunk = chunk;
                            longestChunkLength = chunk.length();
                        }
                        String chunkAsString = JSTranslater.instance().toJS((Object)chunk);
                        if (Base.config.getBoolean((Object)"devenv", false)) {
                            chunkAsString = chunkAsString.replaceAll("([^\\\\])(\\\\n)+", "$1\\\\n\\\\\n");
                        }
                        if (isCore && !seenObjectJS) {
                            outputs.add("eval(");
                            outputs.add(chunkAsString);
                            outputs.add(");\n");
                            continue;
                        }
                        outputs.add("eval(isc.doEval(");
                        outputs.add(chunkAsString);
                        outputs.add("));\n");
                    }
                    if (component instanceof FileComponent && ((FileComponent)component).fileName.endsWith("/Object.js")) {
                        seenObjectJS = true;
                    }
                    if (!(component instanceof FileComponent)) continue;
                }
                outputs.add("isc.finalEval();");
            } else {
                for (int i = 0; i < this.files.size(); ++i) {
                    Component component = (Component)this.files.get(i);
                    outputs.add(component.getOutput());
                }
            }
            outputs.add(moduleLoadEnd);
            outputs.add("}else{if(window.isc && isc.Log && isc.Log.logWarn)isc.Log.logWarn(\"Duplicate load of module '" + this.moduleName + "'.\");}");
            if (optionalModules.contains(this.moduleName)) {
                outputs.add("/** " + this.moduleName + "Module End **/");
            }
            long time = System.currentTimeMillis() - start;
            Logger.timing.debug((Object)("Total " + this.moduleName + " preparation time: " + time));
            if (FileAssembler.this.obfuscator != null) {
                log.debug((Object)("Short identifiers found during obfuscation: " + String.valueOf(FileAssembler.this.obfuscator.getShortIdentifiers().keySet())));
            }
            return outputs;
        }
    }

    class XMLFileComponent
    extends FileComponent {
        XMLFileComponent(String fileName, Map componentData) throws Exception {
            super(fileName, componentData);
            componentData.put("doXmlTransform", Boolean.TRUE);
        }
    }

    class FileComponent
    implements Component {
        protected String fileName;
        protected Map componentData;

        FileComponent(String fileName, Map componentData) throws Exception {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            this.fileName = fileName;
            this.componentData = componentData;
        }

        @Override
        public void init(Map componentData) throws Exception {
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final Map getComponentData() {
            return this.componentData;
        }

        @Override
        public boolean upToDate(long timestamp) throws Exception {
            if (this.fileName.equals("$systemSchema")) {
                return false;
            }
            ISCFile theFile = ISCFile.newInstance((String)(webRoot + "/" + this.fileName));
            return theFile.lastModified() <= timestamp;
        }

        @Override
        public Object getOutput() throws Exception {
            return FileAssembler.this.getStrippedFile(this.fileName, this.componentData, true);
        }
    }

    class DataSourceComponent
    extends XMLFileComponent {
        protected String name;

        DataSourceComponent(String name, Map componentData) throws Exception {
            super(FileAssembler.this.fileNameForType("ds", name), componentData);
            this.name = name;
        }

        DataSourceComponent(String fileName, String name, Map componentData) throws Exception {
            super(fileName, componentData);
            this.name = name;
        }

        @Override
        public Object getOutput() throws Exception {
            StringWriter sw = new StringWriter();
            if ("$systemSchema".equals(this.name)) {
                sw.write(SystemSchemaTranslation.getTranslatedSystemSchema());
            } else {
                DataSource ds = DataSourceManager.getDataSource((String)this.name, null);
                if (ds == null) {
                    throw new Exception("Unable to load DataSource for ID: " + this.name);
                }
                try {
                    JSTranslater.get().toJS((Object)ds, (Writer)sw);
                }
                finally {
                    DataSourceManager.freeDataSource((DataSource)ds);
                }
            }
            String output = sw.toString();
            IOUtil.atomicWrite((String)output, (ISCFile)ISCFile.newInstance((String)FileAssembler.this.getStrippedFileName(this.fileName)));
            return new StringReader(output);
        }
    }

    class TypeComponent
    extends XMLFileComponent {
        protected String name;

        TypeComponent(String name, Map componentData) throws Exception {
            super(FileAssembler.this.fileNameForType("type", name), componentData);
            this.name = name;
        }

        TypeComponent(String fileName, String name, Map componentData) throws Exception {
            super(fileName, componentData);
            this.name = name;
        }

        @Override
        public Object getOutput() throws Exception {
            String typeConfigFile = DataStructCache.getInstanceFile((String)this.name, (String)"datasources", (String)"type");
            Object type = null;
            if (typeConfigFile != null) {
                type = DataStructCache.loadInstance((String)typeConfigFile, (String)this.name, (String)"type");
            }
            if (type == null) {
                throw new Exception("Unable to load type for name: " + this.name);
            }
            StringWriter sw = new StringWriter();
            JSTranslater.get().toJS(type, (Writer)sw);
            String output = sw.toString();
            IOUtil.atomicWrite((String)output, (ISCFile)ISCFile.newInstance((String)FileAssembler.this.getStrippedFileName(this.fileName)));
            return new StringReader(output);
        }
    }

    class AppComponent
    extends XMLFileComponent {
        AppComponent(String name, Map componentData) throws Exception {
            super(FileAssembler.this.fileNameForType("app", name), componentData);
        }
    }

    class UIComponent
    extends XMLFileComponent {
        UIComponent(String name, Map componentData) throws Exception {
            super(FileAssembler.this.fileNameForType("ui", name), componentData);
        }
    }
}

