package com.smartgwt.sample.client;

import java.util.Random;

import com.smartgwt.client.types.*;
import com.smartgwt.client.util.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.rpc.*;

import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.form.fields.events.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.browser.window.events.*;


public class MessagingPane extends DynamicForm implements MessagingCallback {

    public static final String CHANNEL = "BigData";

    private static final String MESSAGE_CHARS = 
	        "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";

    DataSizeItem dataSizeItem;
    TextAreaItem receivedItem;

    public MessagingPane() {
        setIsGroup(true);
        setGroupTitle("Shared Messaging on Channel '" + CHANNEL + "'");

        setTitleOrientation(TitleOrientation.TOP);
        setColWidths(125, "*");

        final MessagingCallback handler = this;
        ButtonItem subscribeButtonItem   = new InlineButtonItem("subscribe",   "Subscribe");
        subscribeButtonItem.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                Messaging.subscribe(CHANNEL, handler);
            }
        });

        ButtonItem unsubscribeButtonItem = new InlineButtonItem("unsubscribe", "Usubscribe");
        unsubscribeButtonItem.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                Messaging.unsubscribe(CHANNEL);
                receivedItem.clearValue();
            }
        });

        ButtonItem sendButtonItem = new InlineButtonItem("send", "Send");
        sendButtonItem.setStartRow(true);
        sendButtonItem.addClickHandler(new ClickHandler() {
            public void onClick(ClickEvent event) {
                int dataLength = dataSizeItem.getSendDataLength();
                String randomData = getRandomChars(dataLength);
                Messaging.send(CHANNEL, randomData, null);
            }
        });
        dataSizeItem = new DataSizeItem("dataSize");
        
        receivedItem = new TextAreaItem("received", "Received Message");
        receivedItem.setWidth("100%");
        receivedItem.setColSpan(2);

        setItems(subscribeButtonItem, unsubscribeButtonItem, sendButtonItem, dataSizeItem,
                 receivedItem);
    }

    

    String getRandomChars(int length){
        Random random = new Random();
		StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; i++){
            int charpos = random.nextInt(MESSAGE_CHARS.length());
            buffer.append(MESSAGE_CHARS.charAt(charpos));
        }
        return buffer.toString();
    }

    public void execute(Object data) {
        receivedItem.setValue(data);
    }

    public static class InlineButtonItem extends ButtonItem {
        public InlineButtonItem(String name, String title) {
            super(name, title);
            setStartRow(false);
            setEndRow(false);
            setWidth(100);
        }
    }

    public static class DataSizeItem extends SliderItem
        implements ChangedHandler
    {
        public DataSizeItem(String name) {
            super(name);
            setMinValue(1);
            setMaxValue(7);
            setNumValues(7);
            addChangedHandler(this);
            setDefaultValue(1.0);
        }

        @Override
        public SliderItem setDefaultValue(double defaultValue) {
            super.setDefaultValue(defaultValue);
            int length = getSendDataLength(defaultValue);
            updatePayloadSizeItemTitle(length);
            return this;
        }

        public void onChanged(ChangedEvent event) {
            updatePayloadSizeItemTitle(getSendDataLength());
        }

        int getSendDataLength() {
            return getSendDataLength(getValueAsFloat());
        }

        int getSendDataLength(double exponent) {
            return ((int) Math.pow(10, exponent)) / 2;
        }

        void updatePayloadSizeItemTitle(int length) {
            String title;
            if (length >= 10000) title = (length/1000) + "KB";
            else                 title = length + "B";
            title += " Data Payload (logarithmic control)";
            setTitle(title);
            // must redraw to refresh title if drawn
            if (isCreated() && isDrawn()) redraw();
        }
    }
    
}
