/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.EnumType;
import org.hibernate.AssertionFailure;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class EnumJavaType<T extends Enum<T>>
extends AbstractClassJavaType<T> {
    public EnumJavaType(Class<T> type) {
        super(type, ImmutableMutabilityPlan.instance());
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        int sqlType;
        JdbcTypeRegistry jdbcTypeRegistry = context.getTypeConfiguration().getJdbcTypeRegistry();
        EnumType type = context.getEnumeratedType();
        boolean preferNativeEnumTypesEnabled = context.isPreferNativeEnumTypesEnabled();
        switch (type == null ? EnumType.ORDINAL : type) {
            case ORDINAL: {
                if (preferNativeEnumTypesEnabled && jdbcTypeRegistry.hasRegisteredDescriptor(6002)) {
                    sqlType = 6002;
                    break;
                }
                if (preferNativeEnumTypesEnabled && jdbcTypeRegistry.hasRegisteredDescriptor(6003)) {
                    sqlType = 6003;
                    break;
                }
                sqlType = this.hasManyValues() ? 5 : -6;
                break;
            }
            case STRING: {
                if (jdbcTypeRegistry.hasRegisteredDescriptor(6000)) {
                    sqlType = 6000;
                    break;
                }
                if (preferNativeEnumTypesEnabled && jdbcTypeRegistry.hasRegisteredDescriptor(6001)) {
                    sqlType = 6001;
                    break;
                }
                if (context.getColumnLength() == 1L) {
                    sqlType = context.isNationalized() ? -15 : 1;
                    break;
                }
                sqlType = context.isNationalized() ? -9 : 12;
                break;
            }
            default: {
                throw new AssertionFailure("unknown EnumType");
            }
        }
        return jdbcTypeRegistry.getDescriptor(sqlType);
    }

    public boolean hasManyValues() {
        return ((Enum[])this.getJavaTypeClass().getEnumConstants()).length > 128;
    }

    @Override
    public String toString(T value) {
        return value == null ? "<null>" : ((Enum)value).name();
    }

    @Override
    public T fromString(CharSequence string) {
        return string == null ? null : (T)Enum.valueOf(this.getJavaTypeClass(), string.toString());
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (String.class.equals(type)) {
            return (X)this.toName(value);
        }
        if (Long.class.equals(type)) {
            return (X)this.toLong(value);
        }
        if (Integer.class.equals(type)) {
            return (X)this.toInteger(value);
        }
        if (Short.class.equals(type)) {
            return (X)this.toShort(value);
        }
        if (Byte.class.equals(type)) {
            return (X)this.toByte(value);
        }
        return (X)value;
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.fromName((String)value);
        }
        if (value instanceof Long) {
            return this.fromLong((Long)value);
        }
        if (value instanceof Integer) {
            return this.fromInteger((Integer)value);
        }
        if (value instanceof Short) {
            return this.fromShort((Short)value);
        }
        if (value instanceof Byte) {
            return this.fromByte((Byte)value);
        }
        if (value instanceof Number) {
            return this.fromLong(((Number)value).longValue());
        }
        return (T)((Enum)value);
    }

    public Byte toByte(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (byte)((Enum)domainForm).ordinal();
    }

    public Short toShort(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (short)((Enum)domainForm).ordinal();
    }

    public Integer toInteger(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Long toLong(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Integer toOrdinal(T domainForm) {
        return this.toInteger(domainForm);
    }

    public T fromByte(Byte relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromShort(Short relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromInteger(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromLong(Long relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm.intValue()];
    }

    public T fromOrdinal(Integer relationalForm) {
        return this.fromInteger(relationalForm);
    }

    public String toName(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).name();
    }

    public T fromName(String relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return Enum.valueOf(this.getJavaTypeClass(), relationalForm.trim());
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType jdbcType, BasicValueConverter<?, ?> converter, Dialect dialect) {
        if (converter != null) {
            return null;
        }
        if (jdbcType.isInteger()) {
            int max = ((Enum[])this.getJavaTypeClass().getEnumConstants()).length - 1;
            return dialect.getCheckCondition(columnName, 0L, max);
        }
        if (jdbcType.isString()) {
            return dialect.getCheckCondition(columnName, this.getJavaTypeClass());
        }
        return null;
    }
}

