/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.base.Config;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.file.ISCUrlFile;
import com.isomorphic.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ISCContainerFile
extends ISCUrlFile {
    private static Logger log = new Logger(ISCContainerFile.class.getName());
    private static Set illegalCharFilenames = new HashSet();
    protected String strippedFilename;

    public ISCContainerFile(String filename, DSRequest request) throws IOException {
        super(filename, request, false);
        int lastSlash;
        String unqualified;
        if (servletContext == null) {
            throw new IOException("Configured for containerIO, but servletContext not available!  You need to install the Init servlet");
        }
        this.strippedFilename = ISCContainerFile.stripContainerIOPrefix(filename);
        if (!this.strippedFilename.startsWith("/")) {
            this.strippedFilename = "/" + this.strippedFilename;
        }
        String string = unqualified = (lastSlash = this.strippedFilename.lastIndexOf(47)) == -1 ? this.strippedFilename : this.strippedFilename.substring(lastSlash + 1);
        if (Config.getGlobal().getBoolean((Object)"allow.illegal.filename.characters", false) || ISCContainerFile.isSafeFilename(unqualified)) {
            this.url = servletContext.getResource(this.strippedFilename);
        } else {
            this.url = null;
            if (!illegalCharFilenames.contains(unqualified)) {
                log.info("Not calling getResource() for name '" + this.strippedFilename + "' because it contains a character that is not allowed in the Windows OS.  Set property 'allow.illegal.filename.characters' true in your server.properties file to suppress this condition and allow the getResource() call");
                illegalCharFilenames.add(unqualified);
            }
        }
    }

    public ISCContainerFile(String path) throws IOException {
        this(path, null);
    }

    @Override
    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        Evaluator eval = new Evaluator(criteria, "exact");
        Object path = this.strippedFilename.endsWith("/") ? this.strippedFilename : this.strippedFilename + "/";
        Set allChildren = servletContext.getResourcePaths((String)path);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(allChildren.size());
        for (String eachChild : allChildren) {
            ISCContainerFile child;
            Map<String, Object> attributes;
            if (eachChild.endsWith("/") || !eval.valuesMatchCriteria(attributes = (child = new ISCContainerFile(eachChild, request)).readAttributes())) continue;
            result.add(attributes);
        }
        return result;
    }

    @Override
    public List<ISCFile> findChildren(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        Evaluator eval = new Evaluator(criteria, "exact");
        Object path = this.strippedFilename.endsWith("/") ? this.strippedFilename : this.strippedFilename + "/";
        Set allChildren = servletContext.getResourcePaths((String)path);
        ArrayList<ISCFile> result = new ArrayList<ISCFile>(allChildren.size());
        for (String eachChild : allChildren) {
            ISCContainerFile child;
            Map<String, Object> attributes;
            if (eachChild.endsWith("/") || !eval.valuesMatchCriteria(attributes = (child = new ISCContainerFile(eachChild, request)).readAttributes())) continue;
            result.add(child);
        }
        return result;
    }

    @Override
    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) throws IOException {
        Set<String> keys;
        if (request == null) {
            request = this.requestContext;
        }
        if ((keys = primaryKeys.keySet()).containsAll(DataSource.FS_PRIMARY_KEYS)) {
            return this.getChild(ISCContainerFile.expandFileExtensions(primaryKeys), request);
        }
        try {
            List<ISCFile> children = this.findChildren(primaryKeys, request);
            if (children.size() == 0) {
                return this.getChild(ISCContainerFile.expandFileExtensions(primaryKeys), request);
            }
            if (children.size() > 1) {
                log.warn("getChild found more than one file -- returning first");
            }
            return children.get(0);
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            return this.getChild(ISCContainerFile.expandFileExtensions(primaryKeys), request);
        }
    }

    @Override
    public ISCFile getChild(String path, DSRequest request) throws IOException {
        if (request == null) {
            request = this.requestContext;
        }
        String fullPath = this.filename + (this.filename.endsWith("/") ? "" : "/") + path;
        return new ISCContainerFile(fullPath, request);
    }
}

