/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.compression;

import com.isomorphic.base.Base;
import com.isomorphic.interfaces.ICompression;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class CompressFile
extends Base {
    private static Logger log = new Logger(CompressFile.class.getName());

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "CompressFile [options] fileList";
        Options options = new Options();
        options.addOption("h", "help", false, "Show usage message and exit");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("h")) {
            CompressFile.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        ICompression compression = (ICompression)InterfaceProvider.load((String)"ICompression");
        String[] fileList = line.getArgs();
        for (int i = 0; i < fileList.length; ++i) {
            String fileName = fileList[i];
            String outFileName = fileName + ".gz";
            boolean addPadding = fileName.endsWith(".js");
            ISCFile inFile = ISCFile.newInstance((String)fileName);
            ByteArrayOutputStream compressedBuf = compression.compressStream(inFile.getInputStream(), addPadding);
            AtomicFileOutputStream outStream = new AtomicFileOutputStream(outFileName);
            IOUtil.copyStreams((InputStream)new ByteArrayInputStream(compressedBuf.toByteArray()), (OutputStream)outStream);
            outStream.flush();
            outStream.close();
            log.info((Object)("Compressed: " + fileName + " to: " + outFileName));
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "");
    }
}

