/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.TextInterpreter;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class DisclosurePanelParser
implements ElementParser {
    private static final String CUSTOM = "customHeader";
    private static final String HEADER = "header";
    private static final String OPEN_IMAGE = "openImage";
    private static final String CLOSED_IMAGE = "closedImage";

    @Override
    public void parse(XMLElement panelElem, String panelField, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        Children children = this.findChildren(panelElem, writer);
        if (children.body != null) {
            if (!writer.isWidgetElement(children.body)) {
                writer.die(children.body, "Must be a widget", new Object[0]);
            }
            FieldWriter bodyField = writer.parseElementToField(children.body);
            writer.addStatement("%s.add(%s);", new Object[]{panelField, bodyField.getNextReference()});
        }
        if (children.customHeader != null) {
            XMLElement headerElement = children.customHeader.consumeSingleChildElement();
            if (!writer.isWidgetElement(headerElement)) {
                writer.die(headerElement, "Must be a widget", new Object[0]);
            }
            FieldWriter headerField = writer.parseElementToField(headerElement);
            writer.addStatement("%s.setHeader(%s);", new Object[]{panelField, headerField.getNextReference()});
        }
        if (children.header != null) {
            String openImage = children.header.consumeImageResourceAttribute(OPEN_IMAGE);
            String closedImage = children.header.consumeImageResourceAttribute(CLOSED_IMAGE);
            String headerText = children.header.consumeInnerTextEscapedAsHtmlStringLiteral((XMLElement.Interpreter)new TextInterpreter(writer));
            if (openImage == null ^ closedImage == null) {
                writer.die(children.header, "Both %s and %s must be specified, or neither", new Object[]{OPEN_IMAGE, CLOSED_IMAGE});
            }
            String panelTypeName = type.getQualifiedSourceName();
            if (openImage != null) {
                writer.setFieldInitializer(panelField, String.format("new %s(%s, %s, \"%s\")", panelTypeName, openImage, closedImage, headerText));
            } else {
                writer.setFieldInitializer(panelField, String.format("new %s(\"%s\")", panelTypeName, headerText));
            }
        }
    }

    private Children findChildren(final XMLElement elem, final UiBinderWriter writer) throws UnableToCompleteException {
        final Children children = new Children();
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){
            final /* synthetic */ DisclosurePanelParser this$0;
            {
                this.this$0 = this$0;
            }

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (this.hasTag(child, DisclosurePanelParser.HEADER)) {
                    this.assertFirstHeader();
                    children.header = child;
                    return true;
                }
                if (this.hasTag(child, DisclosurePanelParser.CUSTOM)) {
                    this.assertFirstHeader();
                    children.customHeader = child;
                    return true;
                }
                if (children.body != null) {
                    writer.die(elem, "May have only one body element", new Object[0]);
                }
                children.body = child;
                return true;
            }

            void assertFirstHeader() throws UnableToCompleteException {
                if (children.header != null || children.customHeader != null) {
                    writer.die(elem, "May have only one <%1$s:header> or <%1$s:customHeader>", new Object[]{elem.getPrefix()});
                }
            }

            private boolean hasTag(XMLElement child, String tag) {
                return elem.getNamespaceUri().equals(child.getNamespaceUri()) && tag.equals(child.getLocalName());
            }
        });
        return children;
    }

    private static class Children {
        XMLElement body;
        XMLElement header;
        XMLElement customHeader;

        private Children() {
        }
    }
}

