/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.TextMatchStyle;
import com.isomorphic.jpa.JPADataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GAEJPADataSource
extends JPADataSource {
    private static final String CLASS_NAME = GAEJPADataSource.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String GAE_VERSION_PROPERTY = "com.google.appengine.runtime.version";
    public static final String GAE_RUNTIME_PROPERTY = "com.google.appengine.runtime.environment";
    public static final boolean BIGTABLE_ACTIVE = System.getProperty("com.google.appengine.runtime.environment") != null;

    @Override
    public Map<String, Object> deriveDS(String schemaBean, String id, boolean extended) {
        Map<String, Object> schemaDSConfig = super.deriveDS(schemaBean, id, extended);
        if (schemaDSConfig != null) {
            schemaDSConfig.put("serverConstructor", "com.isomorphic.jpa.GAEJPADataSource");
            schemaDSConfig.put("allowAdvancedCriteria", Boolean.FALSE);
        }
        return schemaDSConfig;
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        Object typedParameterValue;
        log.debug((Object)"Executing fetch.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        String qStr = "select " + this.beanName + " from " + (this.useQualifiedClassName != false ? this.beanClass.getName() : this.beanClass.getSimpleName()) + " " + this.beanName;
        String qCountStr = "select count (" + this.beanName + "." + this.getPrimaryKey() + ") from " + (this.useQualifiedClassName != false ? this.beanClass.getName() : this.beanClass.getSimpleName()) + " " + this.beanName;
        Object wherePart = "";
        Object orderByPart = "";
        int parameterCounter = 0;
        ArrayList<CallSite> parameterNames = new ArrayList<CallSite>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Class> beanParametersTypes = new ArrayList<Class>();
        Map criteria = req.getCriteria();
        if (criteria != null) {
            if (this.isAdvancedCriteria(criteria)) {
                throw new UnsupportedOperationException("Advanced criteria is not implemented.");
            }
            for (Object fieldName : criteria.keySet()) {
                DSField field = this.getField((String)fieldName);
                if (field == null) {
                    log.warn((Object)("Field name: '" + (String)fieldName + "' specified in criteria is not defined in data source. Skipping."));
                    continue;
                }
                String propertyName = field.getBeanPropertyName();
                Object value = criteria.get(fieldName);
                Class propertyType = DataTools.getPropertyType((Class)this.beanClass, (String)propertyName);
                if (value == null) {
                    if (!"".equals(wherePart)) {
                        wherePart = (String)wherePart + " and ";
                    }
                    wherePart = (String)wherePart + this.beanName + "." + propertyName + " is null";
                    continue;
                }
                if (value instanceof Iterable) {
                    Iterable valueList = (Iterable)value;
                    boolean hasNulls = false;
                    Object wherePartList = "";
                    for (Object singleValue : valueList) {
                        Object typedParameterValue2 = null;
                        try {
                            typedParameterValue2 = DataTools.castValue(singleValue, (Class)propertyType);
                            if (typedParameterValue2 == null) {
                                hasNulls = true;
                                continue;
                            }
                            if (!"".equals(wherePartList)) {
                                wherePartList = (String)wherePartList + " or ";
                            }
                            wherePartList = (String)wherePartList + this.beanName + "." + propertyName + " = :p" + parameterCounter;
                            parameterNames.add((CallSite)((Object)("p" + parameterCounter++)));
                            parameters.add(typedParameterValue2);
                            beanParametersTypes.add(propertyType);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to cast value for field '" + (String)fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                        }
                    }
                    if (!"".equals(wherePart)) {
                        wherePart = (String)wherePart + " and ";
                    }
                    if (!"".equals(wherePartList)) {
                        if (hasNulls) {
                            wherePart = (String)wherePart + "(" + (String)wherePartList + " or " + this.beanName + "." + propertyName + " is null)";
                            continue;
                        }
                        wherePart = (String)wherePart + "((" + (String)wherePartList + ") and " + this.beanName + "." + propertyName + " is not null)";
                        continue;
                    }
                    if (hasNulls) {
                        wherePart = (String)wherePart + "(" + this.beanName + "." + propertyName + " is null)";
                        continue;
                    }
                    wherePart = (String)wherePart + "1=2";
                    continue;
                }
                if (DataTools.isTextType((Class)propertyType)) {
                    if (TextMatchStyle.SUBSTRING.getValue().equals(req.getTextMatchStyle()) || TextMatchStyle.STARTS_WITH.getValue().equals(req.getTextMatchStyle())) {
                        if (!"".equals(wherePart)) {
                            wherePart = (String)wherePart + " and ";
                        }
                        wherePart = (String)wherePart + this.beanName + "." + propertyName + " like :p" + parameterCounter + " escape '" + ESCAPE_CHARACTER + "'";
                        parameterNames.add((CallSite)((Object)("p" + parameterCounter++)));
                        parameters.add(GAEJPADataSource.escapeValueForFilter(value, ESCAPE_CHARACTER.charValue()) + "%");
                        beanParametersTypes.add(propertyType);
                        continue;
                    }
                    typedParameterValue = null;
                    try {
                        typedParameterValue = DataTools.castValue(value, (Class)propertyType);
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Failed to cast value for field '" + (String)fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                        continue;
                    }
                    if (!"".equals(wherePart)) {
                        wherePart = (String)wherePart + " and ";
                    }
                    wherePart = (String)wherePart + this.beanName + "." + propertyName + " = :p" + parameterCounter;
                    parameterNames.add((CallSite)((Object)("p" + parameterCounter++)));
                    parameters.add(typedParameterValue);
                    beanParametersTypes.add(propertyType);
                    continue;
                }
                typedParameterValue = null;
                try {
                    typedParameterValue = DataTools.castValue(value, (Class)propertyType);
                }
                catch (Exception ex) {
                    log.warn((Object)("Failed to cast value for field '" + (String)fieldName + "'.\n" + ex.getMessage() + "\nSkipping."));
                    continue;
                }
                if (!"".equals(wherePart)) {
                    wherePart = (String)wherePart + " and ";
                }
                wherePart = (String)wherePart + this.beanName + "." + propertyName + " = :p" + parameterCounter;
                parameterNames.add((CallSite)((Object)("p" + parameterCounter++)));
                parameters.add(typedParameterValue);
                beanParametersTypes.add(propertyType);
            }
        }
        List sortBy = req.getSortByFields();
        for (String fieldName : sortBy) {
            DSField field = this.getField(fieldName.startsWith("-") ? fieldName.substring(1) : fieldName);
            if (field == null) {
                log.warn((Object)("Field name: '" + fieldName + "' specified in sort-by is not defined in data source. Skipping."));
                continue;
            }
            String propertyName = field.getBeanPropertyName();
            if (!"".equals(orderByPart)) {
                orderByPart = (String)orderByPart + ", ";
            }
            if (fieldName.startsWith("-")) {
                orderByPart = (String)orderByPart + this.beanName + "." + propertyName + " desc";
                continue;
            }
            orderByPart = (String)orderByPart + this.beanName + "." + propertyName;
        }
        if (!"".equals(wherePart)) {
            qStr = qStr + " where " + (String)wherePart;
            qCountStr = qCountStr + " where " + (String)wherePart;
        }
        if (!"".equals(orderByPart)) {
            qStr = qStr + " order by " + (String)orderByPart;
        }
        log.debug((Object)("Query string: " + qStr));
        Query q = this.em.createQuery(qStr);
        Query qCount = this.em.createQuery(qCountStr);
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameterValue = parameters.get(i);
            Class beanParameterType = (Class)beanParametersTypes.get(i);
            typedParameterValue = DataTools.castValue(parameterValue, (Class)beanParameterType);
            q.setParameter((String)parameterNames.get(i), typedParameterValue);
            qCount.setParameter((String)parameterNames.get(i), typedParameterValue);
            log.debug((Object)("Parameter " + (String)parameterNames.get(i) + ": " + String.valueOf(typedParameterValue)));
        }
        long totalRows = -1L;
        if (req.isPaged()) {
            Long rowCount;
            if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                req._setBatchSize(req.getEndRow() - req.getStartRow());
            }
            totalRows = (rowCount = Long.valueOf(Long.parseLong(qCount.getSingleResult().toString()))) == null ? 0L : rowCount;
            q.setFirstResult((int)req.getStartRow());
            q.setMaxResults((int)req.getBatchSize());
        }
        ArrayList results = null;
        results = totalRows == 0L ? new ArrayList() : q.getResultList();
        if (totalRows == -1L) {
            totalRows = results.size();
        }
        dsResponse.setTotalRows(totalRows);
        long startRow = 0L;
        long endRow = 0L;
        if (totalRows != 0L) {
            startRow = req.getStartRow();
            endRow = startRow + (long)results.size();
        }
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.toJS(results);
        dsResponse.setData(results);
        return dsResponse;
    }

    @Override
    public DSResponse executeAdd(DSRequest req) throws Exception {
        log.debug((Object)"Executing add.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        Object record = this.beanClass.newInstance();
        this.setProperties(req.getValues(), record);
        this.em.persist(record);
        this.em.refresh(record);
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.toJS(record);
        dsResponse.setData(record);
        this.increaseOpCount();
        return dsResponse;
    }

    @Override
    public DSResponse executeUpdate(DSRequest req) throws Exception {
        log.debug((Object)"Executing update.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        String primaryKeyFieldName = this.getPrimaryKey();
        Serializable id = (Serializable)req.getFieldValue((Object)primaryKeyFieldName);
        DSField primaryKeyField = this.getField(primaryKeyFieldName);
        if (primaryKeyField == null) {
            throw new Exception("Field name: '" + primaryKeyFieldName + "' is not defined in data source.");
        }
        String primaryKeyPropertyName = primaryKeyField.getBeanPropertyName();
        Object record = this.em.find(this.beanClass, DataTools.castValue((Object)id, (Class)DataTools.getPropertyType((Class)this.beanClass, (String)primaryKeyPropertyName)));
        this.setProperties(req.getValues(), record);
        this.em.persist(record);
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.toJS(record);
        dsResponse.setData(record);
        this.increaseOpCount();
        return dsResponse;
    }

    @Override
    public boolean canJoinIncludedFields() {
        return false;
    }
}

