/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.JsParser;
import com.google.gwt.dev.js.ast.JsArrayLiteral;
import com.google.gwt.dev.js.ast.JsBinaryOperation;
import com.google.gwt.dev.js.ast.JsBinaryOperator;
import com.google.gwt.dev.js.ast.JsBooleanLiteral;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsModVisitor;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsNumberLiteral;
import com.google.gwt.dev.js.ast.JsPostfixOperation;
import com.google.gwt.dev.js.ast.JsPrefixOperation;
import com.google.gwt.dev.js.ast.JsRootScope;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsUnaryOperator;
import com.google.gwt.dev.js.ast.JsValueLiteral;
import com.google.gwt.dev.js.ast.JsVisitable;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.Serializer;
import com.google.gwt.user.server.Base64Utils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public final class ClientSerializationStreamReader
extends AbstractSerializationStreamReader {
    private RpcDecoder decoder;
    private int index;
    private Serializer serializer;

    public ClientSerializationStreamReader(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void prepareToRead(String encoded) throws SerializationException {
        try {
            List stmts = JsParser.parse((SourceInfo)SourceOrigin.UNKNOWN, (JsScope)JsRootScope.INSTANCE, (Reader)new StringReader(encoded));
            ArrayConcatEvaler arrayConcatEvaler = new ArrayConcatEvaler();
            arrayConcatEvaler.acceptList(stmts);
            StringConcatEvaler stringConcatEvaler = new StringConcatEvaler();
            stringConcatEvaler.acceptList(stmts);
            this.decoder = new RpcDecoder();
            this.decoder.acceptList(stmts);
        }
        catch (Exception e) {
            throw new SerializationException("Failed to parse RPC payload", e);
        }
        this.index = this.decoder.getValues().size();
        super.prepareToRead(encoded);
        if (this.getVersion() < 5 || this.getVersion() > 8) {
            throw new IncompatibleRemoteServiceException("Got version " + this.getVersion() + ", expected version between " + 5 + " and " + 8);
        }
        if (!this.areFlagsValid()) {
            throw new IncompatibleRemoteServiceException("Got an unknown flag from server: " + this.getFlags());
        }
    }

    @Override
    public boolean readBoolean() {
        JsValueLiteral literal = this.decoder.getValues().get(--this.index);
        return literal.isBooleanTrue();
    }

    @Override
    public byte readByte() {
        JsNumberLiteral literal = (JsNumberLiteral)this.decoder.getValues().get(--this.index);
        return (byte)literal.getValue();
    }

    @Override
    public char readChar() {
        JsNumberLiteral literal = (JsNumberLiteral)this.decoder.getValues().get(--this.index);
        return (char)literal.getValue();
    }

    @Override
    public double readDouble() {
        JsValueLiteral valueLiteral = this.decoder.getValues().get(--this.index);
        if (valueLiteral instanceof JsNumberLiteral) {
            JsNumberLiteral literal = (JsNumberLiteral)valueLiteral;
            return literal.getValue();
        }
        if (valueLiteral instanceof JsStringLiteral) {
            JsStringLiteral literal = (JsStringLiteral)valueLiteral;
            return Double.parseDouble(literal.getValue());
        }
        throw new RuntimeException("Can't read double from " + valueLiteral.getKind() + " literal");
    }

    @Override
    public float readFloat() {
        return (float)this.readDouble();
    }

    @Override
    public int readInt() {
        JsNumberLiteral literal = (JsNumberLiteral)this.decoder.getValues().get(--this.index);
        return (int)literal.getValue();
    }

    @Override
    public long readLong() {
        return Base64Utils.longFromBase64(((JsStringLiteral)this.decoder.getValues().get(--this.index)).getValue());
    }

    @Override
    public short readShort() {
        JsNumberLiteral literal = (JsNumberLiteral)this.decoder.getValues().get(--this.index);
        return (short)literal.getValue();
    }

    @Override
    public String readString() {
        return this.getString(this.readInt());
    }

    @Override
    protected Object deserialize(String typeSignature) throws SerializationException {
        int id = this.reserveDecodedObjectIndex();
        Object instance = this.serializer.instantiate(this, typeSignature);
        this.rememberDecodedObject(id, instance);
        this.serializer.deserialize(this, instance, typeSignature);
        return instance;
    }

    @Override
    protected String getString(int index) {
        return index > 0 ? this.decoder.getStringTable().get(index - 1) : null;
    }

    private static class ArrayConcatEvaler
    extends JsModVisitor {
        private ArrayConcatEvaler() {
        }

        public boolean visit(JsInvocation invoke, JsContext ctx) {
            JsExpression expr = invoke.getQualifier();
            if (!(expr instanceof JsNameRef)) {
                return super.visit(invoke, ctx);
            }
            JsNameRef name = (JsNameRef)expr;
            if (!name.getIdent().equals("concat")) {
                return super.visit(invoke, ctx);
            }
            JsArrayLiteral headElements = (JsArrayLiteral)name.getQualifier();
            for (JsExpression ex : invoke.getArguments()) {
                JsArrayLiteral arg = (JsArrayLiteral)ex;
                headElements.getExpressions().addAll(arg.getExpressions());
            }
            ctx.replaceMe((JsVisitable)headElements);
            return true;
        }
    }

    private static class StringConcatEvaler
    extends JsModVisitor {
        private StringConcatEvaler() {
        }

        public boolean visit(JsBinaryOperation x, JsContext ctx) {
            StringBuilder builder;
            if (x.getOperator() != JsBinaryOperator.ADD) {
                return super.visit(x, ctx);
            }
            int stringLength = this.getStringLength((JsExpression)x);
            if (stringLength >= 0 && this.expressionToString((JsExpression)x, builder = new StringBuilder(stringLength))) {
                ctx.replaceMe((JsVisitable)new JsStringLiteral(x.getSourceInfo(), builder.toString()));
            }
            return true;
        }

        private boolean expressionToString(JsExpression expression, StringBuilder builder) {
            if (expression instanceof JsStringLiteral) {
                builder.append(((JsStringLiteral)expression).getValue());
                return true;
            }
            if (expression instanceof JsBinaryOperation) {
                JsBinaryOperation operation = (JsBinaryOperation)expression;
                if (operation.getOperator() != JsBinaryOperator.ADD) {
                    return false;
                }
                return this.expressionToString(operation.getArg1(), builder) && this.expressionToString(operation.getArg2(), builder);
            }
            return false;
        }

        private int getStringLength(JsExpression expression) {
            if (expression instanceof JsStringLiteral) {
                return ((JsStringLiteral)expression).getValue().length();
            }
            if (expression instanceof JsBinaryOperation) {
                JsBinaryOperation operation = (JsBinaryOperation)expression;
                if (operation.getOperator() != JsBinaryOperator.ADD) {
                    return -1;
                }
                int arg1Length = this.getStringLength(operation.getArg1());
                int arg2Length = this.getStringLength(operation.getArg2());
                return arg1Length >= 0 && arg2Length >= 0 ? arg1Length + arg2Length : -1;
            }
            return -1;
        }
    }

    private static class RpcDecoder
    extends JsVisitor {
        private static final String JS_INFINITY_LITERAL = "Infinity";
        private static final String JS_NAN_LITERAL = "NaN";
        State state = State.EXPECTING_PAYLOAD_BEGIN;
        List<String> stringTable = new ArrayList<String>();
        List<JsValueLiteral> values = new ArrayList<JsValueLiteral>();
        boolean negative;

        private RpcDecoder() {
        }

        public void endVisit(JsArrayLiteral x, JsContext ctx) {
            if (this.state == State.IN_STRING_TABLE) {
                this.state = State.EXPECTING_END;
            }
        }

        public List<String> getStringTable() {
            return this.stringTable;
        }

        public List<JsValueLiteral> getValues() {
            return this.values;
        }

        public boolean visit(JsArrayLiteral x, JsContext ctx) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.state = State.EXPECTING_STRING_TABLE;
                    return true;
                }
                case 1: {
                    this.state = State.IN_STRING_TABLE;
                    return true;
                }
            }
            throw new RuntimeException("Unexpected array in RPC payload. The string table has already started.");
        }

        public boolean visit(JsBooleanLiteral x, JsContext ctx) {
            this.values.add((JsValueLiteral)x);
            return true;
        }

        public boolean visit(JsNameRef x, JsContext ctx) {
            String ident = x.getIdent();
            if (ident.equals(JS_NAN_LITERAL)) {
                this.values.add((JsValueLiteral)new JsNumberLiteral((SourceInfo)SourceOrigin.UNKNOWN, Double.NaN));
            } else if (ident.equals(JS_INFINITY_LITERAL)) {
                double val = this.negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                this.negative = false;
                this.values.add((JsValueLiteral)new JsNumberLiteral((SourceInfo)SourceOrigin.UNKNOWN, val));
            } else {
                throw new RuntimeException("Unexpected identifier: " + ident);
            }
            return true;
        }

        public boolean visit(JsNumberLiteral x, JsContext ctx) {
            if (this.negative) {
                x = new JsNumberLiteral(x.getSourceInfo(), -x.getValue());
                this.negative = false;
            }
            this.values.add((JsValueLiteral)x);
            return true;
        }

        public boolean visit(JsPrefixOperation x, JsContext ctx) {
            if (x.getOperator().equals((Object)JsUnaryOperator.NEG)) {
                this.negative = !this.negative;
                return true;
            }
            throw new RuntimeException("Unexpected prefix operator: " + x.toSource());
        }

        public boolean visit(JsPostfixOperation x, JsContext ctx) {
            throw new RuntimeException("Unexpected postfix operator: " + x.toSource());
        }

        public boolean visit(JsStringLiteral x, JsContext ctx) {
            if (this.state == State.IN_STRING_TABLE) {
                this.stringTable.add(x.getValue());
            } else {
                this.values.add((JsValueLiteral)x);
            }
            return true;
        }

        static enum State {
            EXPECTING_PAYLOAD_BEGIN,
            EXPECTING_STRING_TABLE,
            IN_STRING_TABLE,
            EXPECTING_END;

        }
    }
}

