/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.DynamicScreenGenerator;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.Screen;
import com.isomorphic.xml.XML;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class ScreenLoaderServlet
extends BaseServlet {
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_SCREEN_NAME = "screenName";
    public static final String PARAM_MISSING_DS = "missingDSIsNotFatal";
    public static final String PARAM_OMIT_DATASOURCES = "omitDataSources";
    public static final String PROJECT_UI = "project.ui";
    public static final String PARAM_STRUCTURED_RESPONSE = "structuredResponse";
    private static final Map<String, String> TYPE_SUFFIXES = new HashMap<String, String>(){
        {
            this.put("ui", "ui");
            this.put("processes", "proc");
        }
    };
    private static Logger log = new Logger(ScreenLoaderServlet.class.getName());
    private static DynamicScreenGenerator defaultDynamicScreenGenerator = null;
    private static Map dynamicScreenGenerators = Collections.synchronizedMap(new LinkedHashMap());

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/javascript;charset=" + encoding);
        } else {
            response.setContentType("application/javascript");
        }
        Locale locale = null;
        String localeName = request.getParameter("locale");
        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
            log.warn("Locale name " + localeName + " is not valid - ignoring");
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        try {
            StringWriter writer = new StringWriter();
            String screenNames = request.getParameter(PARAM_SCREEN_NAME);
            String typeName = request.getParameter(PARAM_TYPE);
            if (typeName == null || "".equals(typeName)) {
                typeName = "ui";
            }
            boolean missingDSIsNotFatal = "true".equals(request.getParameter(PARAM_MISSING_DS));
            if (screenNames == null) {
                log.warn("Parameter \"screenName\" is not specified.");
            } else if ("".equals(screenNames.trim())) {
                log.warn("No data specified in parameter \"screenName\".");
            } else {
                log.debug("Requested screens:" + screenNames);
                if (request.getParameter(PARAM_STRUCTURED_RESPONSE) == null) {
                    for (String screenName : DataTools.commaSeparatedStringToList(screenNames)) {
                        screenName = screenName.trim();
                        log.debug("Processing screen \"" + screenName + "\".");
                        if (!"".equals(screenName)) {
                            try {
                                String screen = this._loadScreen(screenName, locale, request, missingDSIsNotFatal, typeName);
                                if (screen == null) {
                                    log.warn("Screen \"" + screenName + "\" not found in configured locations. Skipping.");
                                    continue;
                                }
                                ((Writer)writer).write(screen.toString());
                                ((Writer)writer).write("\r\n");
                            }
                            catch (Exception ex) {
                                log.error((Object)("Failed to load screen \"" + screenName + "\". Skipping."), ex);
                            }
                            continue;
                        }
                        log.warn("Empty string specified as screen name. Skipping.");
                    }
                } else {
                    ((Writer)writer).write("{\n\r");
                    ((Writer)writer).write("  screens: [\n\r");
                    int separator = 32;
                    String current = request.getParameter("defaultScreen");
                    for (String screenName : DataTools.commaSeparatedStringToList(screenNames)) {
                        screenName = screenName.trim();
                        log.debug("Processing screen \"" + screenName + "\".");
                        if (!"".equals(screenName)) {
                            try {
                                String screen = this._loadScreen(screenName, locale, request, missingDSIsNotFatal, typeName);
                                if (screen == null) {
                                    log.warn("Screen \"" + screenName + "\" not found in configured locations. Skipping.");
                                    continue;
                                }
                                ((Writer)writer).write("      " + (char)separator + "{ screenName:\"" + screenName + "\",");
                                ((Writer)writer).write("        source:\"" + StringEscapeUtils.escapeJavaScript((String)screen.toString()) + "\"");
                                if (screenName.equals(current)) {
                                    ((Writer)writer).write(",        isProjectDefault: true}");
                                } else {
                                    ((Writer)writer).write("}");
                                }
                                ((Writer)writer).write("\r\n");
                                separator = 44;
                            }
                            catch (Exception ex) {
                                log.error((Object)("Failed to load screen \"" + screenName + "\". Skipping."), ex);
                            }
                            continue;
                        }
                        log.warn("Empty string specified as screen name. Skipping.");
                    }
                    ((Writer)writer).write("      ]\n\r");
                    ((Writer)writer).write("}\n\r");
                    ((Writer)writer).write("\r\n");
                }
            }
            log.debug("Generated response:" + ((Object)writer).toString());
            response.setStatus(200);
            PrintWriter rw = response.getWriter();
            rw.print(((Object)writer).toString());
            rw.close();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException writer) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _loadScreen(String screenName, Locale locale, HttpServletRequest request, boolean missingDSIsNotFatal, String typeName) throws Exception {
        String screenJS;
        boolean mockMode = false;
        String mockModeString = request.getParameter("mockMode");
        if (mockModeString != null) {
            mockMode = "true".equals(mockModeString.toLowerCase());
        }
        List<String> excludedDS = null;
        String excludedDSString = request.getParameter(PARAM_OMIT_DATASOURCES);
        if (excludedDSString != null) {
            excludedDS = Arrays.asList(excludedDSString.split(","));
        }
        if ((screenJS = ScreenLoaderServlet.loadScreen(screenName, locale, mockMode, missingDSIsNotFatal, typeName, excludedDS)) == null && "ui".equals(typeName)) {
            Config iscConfig;
            String shareId = request.getParameter("shareId");
            boolean isShared = false;
            if (shareId != null) {
                DSRequest sharedDSRequest = new DSRequest("isc_sharedProjects", "fetch");
                sharedDSRequest.setCriteria((Object)DataTools.buildMap("shareId", Arrays.asList(shareId.split(","))));
                DSResponse sharedDSResponse = sharedDSRequest.execute();
                Map<String, Object> record = sharedDSResponse.getRecord();
                if (record == null) {
                    throw new Exception("Invalid shareId");
                }
                isShared = true;
            }
            if ((iscConfig = Config.getGlobal()).getBoolean((Object)"project.deployment.shareScreens", false) && request.getAttribute("vbt_isDeployment") != null) {
                isShared = true;
            }
            Screen screen = null;
            ValidationContext vc = new ValidationContext();
            vc.setExcludedDS(excludedDS);
            try {
                screen = isShared ? Screen.load(screenName, mockMode, vc) : Screen.load(screenName, request.getRemoteUser(), mockMode, vc);
            }
            finally {
                vc.freeResources();
            }
            if (screen != null) {
                JSTranslater jst = JSTranslater.instance();
                jst.setLocale(locale);
                jst.setObfuscation(false);
                StringWriter sw = new StringWriter();
                screen.toJSON(sw, jst);
                return sw.toString();
            }
        }
        return screenJS;
    }

    public static String loadScreen(String screenName, Locale locale) throws Exception {
        return ScreenLoaderServlet.loadScreen(screenName, locale, false, false, "ui");
    }

    public static String loadProcess(String processId, Locale locale) throws Exception {
        return ScreenLoaderServlet.loadScreen(processId, locale, false, true, "processes");
    }

    public static String loadScreen(String screenName, Locale locale, boolean mockMode, boolean missingDSIsNotFatal, String screenType) throws Exception {
        return ScreenLoaderServlet.loadScreen(screenName, locale, mockMode, missingDSIsNotFatal, screenType, null);
    }

    public static String loadScreen(String screenName, Locale locale, boolean mockMode, boolean missingDSIsNotFatal, String screenType, List<String> excludedDS) throws Exception {
        String screenFile;
        boolean allowDynamic = "ui".equals(screenType);
        String fileSuffix = TYPE_SUFFIXES.get(screenType);
        if (fileSuffix == null) {
            fileSuffix = screenType;
        }
        String screen = allowDynamic ? ScreenLoaderServlet.getDynamicScreen(screenName) : null;
        String filename = null;
        if (screen == null && (screenFile = DataStructCache.getInstanceFile(screenName, screenType, fileSuffix)) != null) {
            ISCFile file = ISCFile.newInstance(screenFile);
            filename = file.getName();
            screen = file.getAsString();
        }
        if (screen != null) {
            StringWriter screenWriter = new StringWriter();
            StringReader screenReader = new StringReader("<isomorphicXML xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\">" + screen + "</isomorphicXML>");
            ValidationContext context = new ValidationContext();
            context.setExcludedDS(excludedDS);
            context.setUseMockMode(mockMode);
            context.setSource(screenType);
            context.setSourceFilename(filename);
            context.put(PARAM_MISSING_DS, missingDSIsNotFatal);
            Object records = XML.toDSRecords(screenReader, context);
            context.freeResources();
            JSTranslater jst = JSTranslater.instance();
            jst.setLocale(locale);
            jst.setObfuscation(false);
            jst.toJS(records, screenWriter);
            return ((Object)screenWriter).toString();
        }
        return null;
    }

    public static void addDynamicScreenGenerator(DynamicScreenGenerator dsg) {
        defaultDynamicScreenGenerator = dsg;
    }

    public static void addDynamicScreenGenerator(DynamicScreenGenerator dsg, String prefix) {
        dynamicScreenGenerators.put(prefix, dsg);
    }

    public static void addDynamicScreenGenerator(DynamicScreenGenerator dsg, Pattern regex) {
        dynamicScreenGenerators.put(regex, dsg);
    }

    public static DynamicScreenGenerator removeDynamicScreenGenerator() {
        DynamicScreenGenerator dsg = defaultDynamicScreenGenerator;
        defaultDynamicScreenGenerator = null;
        return dsg;
    }

    public static DynamicScreenGenerator removeDynamicScreenGenerator(String prefix) {
        if (dynamicScreenGenerators.containsKey(prefix)) {
            DynamicScreenGenerator dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(prefix);
            dynamicScreenGenerators.remove(prefix);
            return dsg;
        }
        return null;
    }

    public static DynamicScreenGenerator removeDynamicScreenGenerator(Pattern regex) {
        if (dynamicScreenGenerators.containsKey(regex)) {
            DynamicScreenGenerator dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(regex);
            dynamicScreenGenerators.remove(regex);
            return dsg;
        }
        return null;
    }

    public static void clearDynamicScreenGenerators() {
        defaultDynamicScreenGenerator = null;
        dynamicScreenGenerators.clear();
    }

    private static String getDynamicScreen(String id) {
        DynamicScreenGenerator dsg = null;
        for (Object keyObj : dynamicScreenGenerators.keySet()) {
            if (keyObj instanceof String) {
                if (id.indexOf((String)keyObj) != 0) continue;
                dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(keyObj);
                break;
            }
            if (keyObj instanceof Pattern) {
                Pattern p = (Pattern)keyObj;
                Matcher m = p.matcher(id);
                if (!m.find()) continue;
                dsg = (DynamicScreenGenerator)dynamicScreenGenerators.get(keyObj);
                break;
            }
            log.warn("In the dynamicScreenGenerators list, we found a key of type " + keyObj.getClass().getName() + ". Ignoring");
        }
        if (dsg == null) {
            dsg = defaultDynamicScreenGenerator;
        }
        String screen = null;
        if (dsg != null) {
            screen = dsg.getScreen(id);
        }
        return screen;
    }
}

