/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByScLocator
extends By {
    public static final String AUTOTEST_LOADED = "window.isc && isc.AutoTest && isc.Page.isLoaded()";
    public static final String GET_ELEMENT = "window.isc && isc.AutoTest && isc.Page.isLoaded()&& isc.AutoTest.getElement";
    public static final String GET_PAGE_COORDS = "window.isc && isc.AutoTest && isc.Page.isLoaded()&& isc.AutoTest.getPageCoords";
    private static final int WAIT_TIMEOUT_MILLIS = 5000;
    private static final int WAIT_QUANTUM_MILLIS = 200;
    private static final ThreadLocal<PrintStream> localError = new ThreadLocal<PrintStream>(){

        @Override
        public PrintStream initialValue() {
            return System.err;
        }
    };
    private static Duration defaultTimeout = Duration.ofMillis(5000L);
    private Duration timeout;
    private final String scLocator;

    ByScLocator(String scLocator) {
        this.scLocator = scLocator.replaceAll("\\\"", "'").replaceAll("\\'", "'").trim();
        this.timeout = defaultTimeout;
    }

    public static void setThreadLocalErrorStream(PrintStream errorStream) {
        localError.set(errorStream);
    }

    public static void clearThreadLocalErrorStream() {
        localError.remove();
    }

    public static void setDefaultWaitTimeout(int timeoutInSeconds) {
        if (timeoutInSeconds <= 0) {
            throw new IllegalArgumentException("The default timeout must be positive");
        }
        defaultTimeout = Duration.ofSeconds(timeoutInSeconds);
    }

    public void setWaitTimeout(int timeoutInSeconds) {
        if (timeoutInSeconds <= 0) {
            throw new IllegalArgumentException("The default timeout must be positive");
        }
        this.timeout = Duration.ofSeconds(timeoutInSeconds);
    }

    public List<WebElement> findElements(SearchContext context) {
        JavascriptExecutor js = (JavascriptExecutor)context;
        ArrayList<WebElement> list = new ArrayList<WebElement>();
        try {
            Object element = js.executeScript("return window.isc && isc.AutoTest && isc.Page.isLoaded()&& isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
            if (element != null) {
                list.add((WebElement)element);
            }
        }
        catch (NoSuchSessionException | NoSuchWindowException e) {
            throw e;
        }
        catch (Exception e) {
            localError.get().println("ByScLocator.findElements failed: " + String.valueOf(e));
        }
        return list;
    }

    public WebElement findElement(SearchContext context) {
        JavascriptExecutor js = (JavascriptExecutor)context;
        long maximumTicks = this.timeout.toMillis() / 200L;
        try {
            int tick = 0;
            while ((long)tick <= maximumTicks) {
                Object element = js.executeScript("return window.isc && isc.AutoTest && isc.Page.isLoaded()&& isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
                if (element != null) {
                    return (WebElement)element;
                }
                Thread.sleep(200L);
                ++tick;
            }
        }
        catch (NoSuchSessionException | NoSuchWindowException e) {
            throw e;
        }
        catch (InterruptedException e) {
            localError.get().println("ByScLocator.findElement interrupted:" + String.valueOf(e));
        }
        catch (Exception e) {
            localError.get().println("ByScLocator.findElement failed: " + String.valueOf(e));
        }
        throw new NoSuchElementException(this.scLocator);
    }

    public Point findElementCoordinates(JavascriptExecutor js) {
        String command = "window.isc && isc.AutoTest && isc.Page.isLoaded()&& isc.AutoTest.getPageCoords(arguments[0])";
        List coords = (List)js.executeScript("return " + command, new Object[]{this.scLocator});
        if (coords == null || coords.size() != 2) {
            return null;
        }
        Number x = (Number)coords.get(0);
        Number y = (Number)coords.get(1);
        Long xCoord = x instanceof Double ? Math.round((Double)x) : (Long)x;
        Long yCoord = y instanceof Double ? Math.round((Double)y) : (Long)y;
        return coords == null || coords.size() != 2 ? null : new Point(xCoord.intValue(), yCoord.intValue());
    }

    public String toJavaString() {
        return "ByScLocator.scLocator(\"" + this.scLocator.replace("\"", "\\\"") + "\")";
    }

    public String toString() {
        return "By.scLocator: " + this.scLocator;
    }

    public String getLocatorString() {
        return this.scLocator.replace("\\", "");
    }

    public boolean isEdge() {
        return this.scLocator.matches(".*/[TBLR]+");
    }

    public static By scLocator(String scLocator) {
        if (scLocator == null) {
            throw new IllegalArgumentException("Cannot find elements with a null scLocator attribute.");
        }
        return new ByScLocator(scLocator);
    }

    String getBaseLocator() {
        return this.scLocator.substring(0, this.scLocator.lastIndexOf(47));
    }

    private String getPartLocator() {
        if (this.scLocator != null && this.scLocator.contains("/")) {
            return this.scLocator.substring(this.scLocator.lastIndexOf(47) + 1);
        }
        return "";
    }
}

