/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.componentXML.applications;

import com.smartgwt.client.rpc.LoadScreenCallback;
import com.smartgwt.client.rpc.RPCManager;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class AccountsStarterAppSampleXML extends ShowcasePanel {

    private static final String DESCRIPTION =
        " This application shows you how to use aggregation to produce a simple Dashboard of "+
        "information showing the totals of different invoice statuses, using workflows, has full "+
        "accounts management built in (add invoices, assign/void payments, update and fetch related data), "+
        "how to embed screens within grids (using grid expansion features) how to use grid summary features "+
        "and much more."+
        "<P>"+
        "To add an invoice, just click the + icon above the grid, add your invoice header and hit save and "+
        "notice how, via workflows, the application shows you all potential order lines that could be valid "+
        "for this invoice. select the order lines you want to add to this invoice and hit Assign Order Lines "+
        "and you will see all of the lines are automatically added to the invoice in a new grid. These features "+
        "are all made possible using Workflows to control screen behavior and business process flow."+
        "<P>"+
        "Click the right arrow next to any row in the grid and see all of the invoice lines for this invoice."+
        "<P>"+
        "Double-clicking any record allows you to edit that invoice. Try double-clicking a reconciled/paid invoice "+
        "and notice how all of the fields are read-only."+
        "<P>"+
        "Select each of the tabs and you will see various metrics on each one (charts, dashboard counts, and totals). "+
        "Add new invoices, customers, and payments and see the dashboard values and counts dynamically change when you "+
        "save. Workflows allow you to add highly sophisticated logic to all of your screens to get this kind of result."+
        "<P>"+
        "Click on the Customer's Tab and see how aggregated invoice data has been grouped by Customer to show Invoice "+
        "totals by Customer. This is achieved using Workflows to aggregate the data once the Chart component has been drawn.";

    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            AccountsStarterAppSampleXML panel = new AccountsStarterAppSampleXML();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final Canvas layout = new Canvas();
        layout.setHeight100();
        layout.setWidth100();
        RPCManager.loadScreen("accountsStarterApp", new LoadScreenCallback() {
            @Override
            public void execute() {
                layout.addChild(this.getScreen());
                RPCManager.cacheScreens(new String[] {"invoiceLinesView","orderLinesView"}, null);
            }
        });
        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }
    
    @Override
    protected boolean isFullscreenMode() {
        return true;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("accountsStarterApp.ui.xml", XML, "source/accountsStarterApp.ui.xml.html", true),
            new SourceEntity("invoiceLinesView.ui.xml", XML, "source/invoiceLinesView.ui.xml.html", true),
            new SourceEntity("orderLinesView.ui.xml", XML, "source/orderLinesView.ui.xml.html", true),
            new SourceEntity("acc_Product.ds.xml", XML, "source/acc_Product.ds.xml.html", true),
            new SourceEntity("acc_invoiceLine.ds.xml", XML, "source/acc_invoiceLine.ds.xml.html", true),
            new SourceEntity("acc_Invoice.ds.xml", XML, "source/acc_Invoice.ds.xml.html", true),
            new SourceEntity("acc_Order.ds.xml", XML, "source/acc_Order.ds.xml.html", true),
            new SourceEntity("acc_OrderLine.ds.xml", XML, "source/acc_OrderLine.ds.xml.html", true),
            new SourceEntity("acc_Customer.ds.xml", XML, "source/acc_Customer.ds.xml.html", true)
        };
    }
}
