/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ProjectLoadSettings {
    private static Logger log = new Logger(ProjectLoadSettings.class.getName());
    String currentScreenName;
    String ownerId;
    Locale locale;
    String shareId;
    List<String> screenNames;
    Boolean singleScreenMode;
    boolean drawFirstScreen;
    Boolean mockMode;
    Map<String, String> dsOverrides;
    boolean includeSavedSearches;
    boolean includeCustomizations;
    Boolean allowPlaceholders;
    AuthenticatedUser currentUser;
    String testUserId;
    String callbackJS;
    List<String> excludedDS;
    Map<String, Object> dataContext;
    boolean includeXML;

    public ProjectLoadSettings() {
    }

    public ProjectLoadSettings(String currentScreenName, String ownerId, String localeName, Locale requestLocale, String shareId, List<String> screenNames, boolean drawFirstScreen, boolean includeCustom) {
        this.setCurrentScreenName(currentScreenName);
        this.setOwnerId(ownerId);
        this.setShareId(shareId);
        this.setScreenNames(screenNames);
        this.setDrawFirstScreen(drawFirstScreen);
        this.setLocale(localeName, requestLocale);
        this.setIncludeCustomizations(includeCustom);
    }

    public void setCurrentScreenName(String currentScreenName) {
        this.currentScreenName = currentScreenName;
    }

    public String getCurrentScreenName() {
        return this.currentScreenName;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setLocale(String localeName, Locale requestLocale) {
        if (localeName != null) {
            this.locale = DataTools.deriveLocaleFromName(localeName);
            if (this.locale == null) {
                log.warn("Locale name " + localeName + " is not valid - ignoring");
            }
        }
        if (this.locale == null) {
            this.locale = requestLocale;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    public String getShareId() {
        return this.shareId;
    }

    public void setScreenNames(List<String> screenNames) {
        this.screenNames = screenNames;
    }

    public List<String> getScreenNames() {
        return this.screenNames;
    }

    public void setDrawFirstScreen(boolean drawFirstScreen) {
        this.drawFirstScreen = drawFirstScreen;
    }

    public boolean getDrawFirstScreen() {
        return this.drawFirstScreen;
    }

    public void setIncludeCustomizations(boolean includeCustomizations) {
        this.includeCustomizations = includeCustomizations;
    }

    public boolean getIncludeCustomizations() {
        return this.includeCustomizations;
    }

    public void setIncludeSavedSearches(boolean includeSavedSearches) {
        this.includeSavedSearches = includeSavedSearches;
    }

    public boolean getIncludeSavedSearches() {
        return this.includeSavedSearches;
    }

    public void setAllowPlaceholders(boolean allowPlaceholders) {
        this.allowPlaceholders = allowPlaceholders;
    }

    public boolean getAllowPlaceholders() {
        return this.allowPlaceholders;
    }

    public void setMockMode(Boolean mockMode) {
        this.mockMode = mockMode;
    }

    public Boolean getMockMode() {
        return this.mockMode;
    }

    public void setSingleScreenMode(Boolean singleScreenMode) {
        this.singleScreenMode = singleScreenMode;
    }

    public Boolean getSingleScreenMode() {
        return this.singleScreenMode;
    }

    public void setCurrentUser(AuthenticatedUser user) {
        this.currentUser = user;
    }

    public AuthenticatedUser getCurrentUser() {
        return this.currentUser;
    }

    public void setDataSourceOverrides(Map dsOverrides) {
        this.dsOverrides = dsOverrides;
    }

    public Map getDataSourceOverrides() {
        return this.dsOverrides;
    }

    public void setTestUserId(String userId) {
        this.testUserId = userId;
    }

    public String getTestUserId() {
        return this.testUserId;
    }

    public void setCallbackJS(String callbackJS) {
        this.callbackJS = callbackJS;
    }

    public String getCallbackJS() {
        return this.callbackJS;
    }

    public void setExcludedDS(List<String> excludedDS) {
        this.excludedDS = excludedDS;
    }

    public List<String> getExcludedDS() {
        return this.excludedDS;
    }

    public void setDataContext(Map dataContext) {
        this.dataContext = dataContext;
    }

    public Map<String, Object> getDataContext() {
        return this.dataContext;
    }

    public void setIncludeXML(boolean includeXML) {
        this.includeXML = includeXML;
    }

    public boolean getIncludeXML() {
        return this.includeXML;
    }

    Map toMap() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("drawFirstScreen", this.drawFirstScreen);
        settings.put("allowPlaceholders", this.allowPlaceholders);
        settings.put("dataContext", this.dataContext);
        return settings;
    }
}

