/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server.impl;

import com.google.gwt.i18n.server.AbstractMessage;
import com.google.gwt.i18n.server.AbstractParameter;
import com.google.gwt.i18n.server.MessageTranslation;
import com.google.gwt.i18n.server.Parameter;
import com.google.gwt.i18n.server.Type;
import com.google.gwt.i18n.server.impl.ReflectionMessageInterface;
import com.google.gwt.i18n.server.impl.ReflectionUtils;
import com.google.gwt.i18n.shared.AlternateMessageSelector;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import com.google.gwt.safehtml.shared.SafeHtml;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ReflectionMessage
extends AbstractMessage {
    private final Method method;

    private static <A> A findAnnotation(Annotation[] annotations, Class<A> annotClass) {
        for (Annotation annot : annotations) {
            if (!annot.annotationType().equals(annotClass)) continue;
            return annotClass.cast(annot);
        }
        return null;
    }

    private static <A extends Annotation> A getAnnotation(Method method, Class<A> annotClass) {
        A result = method.getAnnotation(annotClass);
        if (result != null) {
            return result;
        }
        return ReflectionUtils.getAnnotation(method.getDeclaringClass(), annotClass, true);
    }

    public ReflectionMessage(GwtLocaleFactory localeFactory, ReflectionMessageInterface msgIntf, Method method) {
        super(localeFactory, msgIntf);
        this.method = method;
        this.init();
    }

    public List<AlternateMessageSelector> getAlternateSelectors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotClass) {
        return ReflectionMessage.getAnnotation(this.method, annotClass);
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public List<Parameter> getParameters() {
        java.lang.reflect.Type[] paramTypes = this.method.getGenericParameterTypes();
        Annotation[][] paramAnnot = this.method.getParameterAnnotations();
        ArrayList<ReflectionParameter> params = new ArrayList<ReflectionParameter>();
        int n = paramTypes.length;
        for (int i = 0; i < n; ++i) {
            ReflectionParameter param = new ReflectionParameter(i, paramTypes[i], paramAnnot[i]);
            params.add(param);
        }
        return Collections.unmodifiableList(params);
    }

    @Override
    public Type getReturnType() {
        Class<?> type = this.method.getReturnType();
        return this.mapClassToType(type);
    }

    @Override
    public MessageTranslation getTranslation(GwtLocale locale) {
        return this;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotClass) {
        if (this.method.isAnnotationPresent(annotClass)) {
            return true;
        }
        return ReflectionUtils.getAnnotation(this.method.getDeclaringClass(), annotClass, true) != null;
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public String toString() {
        return this.getMessageInterface().toString() + "." + this.method.getName();
    }

    private Type mapClassToType(java.lang.reflect.Type type) {
        ParameterizedType pType;
        java.lang.reflect.Type rawType;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE) {
                    return Type.BOOLEAN;
                }
                if (clazz == Byte.TYPE) {
                    return Type.BYTE;
                }
                if (clazz == Character.TYPE) {
                    return Type.CHAR;
                }
                if (clazz == Double.TYPE) {
                    return Type.DOUBLE;
                }
                if (clazz == Float.TYPE) {
                    return Type.FLOAT;
                }
                if (clazz == Integer.TYPE) {
                    return Type.INT;
                }
                if (clazz == Long.TYPE) {
                    return Type.LONG;
                }
                if (clazz == Short.TYPE) {
                    return Type.SHORT;
                }
            }
            if (clazz == String.class) {
                return Type.STRING;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return Type.NUMBER;
            }
            if (SafeHtml.class.isAssignableFrom(clazz)) {
                return Type.SAFEHTML;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return Type.DATE;
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
                int n = enumConstants.length;
                String[] names = new String[n];
                for (int i = 0; i < n; ++i) {
                    names[i] = enumConstants[i].name();
                }
                return new Type.EnumType(clazz.getCanonicalName(), names);
            }
            if (List.class.isAssignableFrom(clazz)) {
                Type componentType = Type.OBJECT;
                String sourceName = "java.util.List<java.util.Object>";
                return new Type.ListType(sourceName, componentType);
            }
            if (clazz.isArray()) {
                Class<?> componentClass = clazz.getComponentType();
                Type componentType = this.mapClassToType(componentClass);
                return new Type.ArrayType(componentType.toString() + "[]", componentType);
            }
        }
        if (type instanceof ParameterizedType && (rawType = (pType = (ParameterizedType)type).getRawType()) instanceof Class) {
            java.lang.reflect.Type[] typeArgs;
            Class clazz = (Class)rawType;
            if (List.class.isAssignableFrom(clazz)) {
                java.lang.reflect.Type[] typeArgs2 = pType.getActualTypeArguments();
                Type componentType = this.mapClassToType(typeArgs2[0]);
                String sourceName = clazz.getCanonicalName() + "<" + componentType.getSourceName() + ">";
                return new Type.ListType(sourceName, componentType);
            }
            if (Map.class.isAssignableFrom(clazz) && type instanceof ParameterizedType && (typeArgs = pType.getActualTypeArguments()).length == 2 && typeArgs[0] == String.class && typeArgs[1] == String.class) {
                return Type.STRING_MAP;
            }
        }
        return new Type(type.toString());
    }

    private class ReflectionParameter
    extends AbstractParameter {
        private final Annotation[] annotations;

        public ReflectionParameter(int idx, java.lang.reflect.Type type, Annotation[] annotations) {
            super(ReflectionMessage.this.getLocaleFactory(), idx, ReflectionMessage.this.mapClassToType(type));
            this.annotations = annotations;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotClass) {
            return (A)((Annotation)ReflectionMessage.findAnnotation(this.annotations, annotClass));
        }

        @Override
        public String getName() {
            String[] names = ((ReflectionMessageInterface)ReflectionMessage.this.getMessageInterface()).getParameterNames(ReflectionMessage.this.method);
            if (names != null) {
                return names[this.getIndex()];
            }
            return "arg" + this.index;
        }
    }
}

