/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.chart;

import com.smartgwt.client.types.ChartType;
import com.smartgwt.client.util.EnumUtil;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.chart.FacetChart;
import com.smartgwt.client.widgets.cube.Facet;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class ThreeFacetBarChart extends ShowcasePanel {

    private static final String DESCRIPTION = 
            "<p>A Three-Facet Bar or Column Chart.supports showing values for two data label facets, "+
            "shown on the same axis, and a legend facet.  The inner data label facet values for a given "+
            "outer facet value are denoted by a line segment spanning those inner values, centered on the "+
            "outer value.</p>"+
            "<p>"+
            "Use the \"Chart Type\" selector below to see the same data rendered in Bar vs. Column chart types. "+
            "Right-click on the chart to change the way data is visualized.</p>";

    public static class Factory extends ChartSamplePanelFactory {

        @Override
        public String getDescription() {
            return DESCRIPTION;
        }

        @Override
        public String getNodeID() {
            return "ThreeFacetBarChart";
        }

        @Override
        public ShowcasePanel createShowcasePanel() {
            return new ThreeFacetBarChart();
        }
    }

    @Override
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        final FacetChart chart = new FacetChart();
        chart.setData(SimpleChartData.getData());
        // You use facets to define the ways in which you would like the chart to
        // break down the data. In this case, our data has two dimensions: region and product.
        chart.setFacets(new Facet("region", "Region"), new Facet("fuel", "Fuel"), new Facet("product", "Product"));
        chart.setValueProperty("sales");
        chart.setChartType(ChartType.BAR);
        chart.setTitle("Sales by Region, Fuel, and Produc");
        chart.setAllowedChartTypes(ChartType.BAR, ChartType.COLUMN);

        final DynamicForm chartSelector = new DynamicForm();
        final SelectItem chartType = new SelectItem("chartType", "Chart Type");
        chartType.setValueMap(
                ChartType.BAR.getValue(),
                ChartType.COLUMN.getValue()
        );
        chartType.setDefaultToFirstOption(true);
        chartType.addChangedHandler(new ChangedHandler() {
            public void onChanged(ChangedEvent event) {
                final String selectedChartType = chartType.getValueAsString();
                final ChartType chartType = EnumUtil.getEnum(ChartType.values(), selectedChartType);
                if (chartType != null) chart.setChartType(chartType);
            }
        });
        chartSelector.setFields(chartType);

        VLayout layout = new VLayout(15);
        layout.addMember(chartSelector);
        layout.addMember(chart);

        return layout;
    }

    @Override
    public String getIntro() {
        return DESCRIPTION;
    }

    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
                    new SourceEntity("SimpleChartData.java", JAVA, "source/chart/SimpleChartData.java.html", false)
                };
    }
}
