/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-01-27/EVAL Development Only (2026-01-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_AI_Server){isc.module_AI_Server=1;isc._moduleStart=isc._AI_Server_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log&&isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={message:'AI_Server load/parse time: '+(isc._moduleStart-isc._moduleEnd)+'ms',category:'loadTime'};
if(isc.Log&&isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;isc.helpDocuments=isc.helpDocuments||{};isc.aiHelpDocuments=isc.aiHelpDocuments||(isc.Browser.$2812?Object.create(isc.helpDocuments):{});isc.registerHelpDocument=function(_1,_2,_3){if(!_3)_3=isc.helpDocuments;if(_1 in _3){return}
var _4=isc.addPropertiesWithAssign({ID:_1},_2);_3[_1]=_4;if(!isc.Browser.$2812){if(_3===isc.helpDocuments&&!Object.hasOwn(isc.aiHelpDocuments,_1))
{isc.aiHelpDocuments[_1]=_4}
}};isc.registerHelpDocuments=function(_1,_2){for(var _3 in _1){var _4=_1[_3];if(!isc.isAn.Object(_4)||!("content"in _4)){continue}
isc.registerHelpDocument(_3,_4,_2)}};isc.defineClass("HelpDocumentRegistryUtil");isc.A=isc.HelpDocumentRegistryUtil;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.collectHelpDocuments=function isc_c_HelpDocumentRegistryUtil_collectHelpDocuments(_1,_2,_3,_4){if(!_2)_2=isc.helpDocuments;var _5=_2[_1];if(_5&&(!_3||!_3.contains(_5))){if(!_3){_3=[_5]}else{_3.addAt(_5,_3.indexOf(_4))}
var _6=_5.dependencies;if(_6){if(!isc.isAn.Array(_6))_6=[_6];for(var i=0;i<_6.length;++i){var _8=_6[i];this.collectHelpDocuments(_8,_2,_3,_5)}
}
}
return _3}
);isc.B._maxIndex=isc.C+1;isc.registerHelpDocuments({
"JavaScript":{
topic:"JavaScript",
content:
"When generating JavaScript source code, assume that the JavaScript interpreter only supports ECMAScript 5. Do not use newer language features such as:\n* `let` or `const`\n* arrow, async, or generator functions\n* ES6 classes or modules\n* spread, exponentiation, or nullish coalescing operators\n* `for`...`of`\n* Promises\n\nTreat \"let\", \"const\", \"catch\", and \"finally\" as invalid JavaScript identifiers.\n\nFurthermore, assume that the code will run in a very basic web browser environment that only supports HTML 4.",
format:"Markdown"
},
"ComponentActions":{
topic:"Component Actions",
content:
"A Component Action declaratively represents an action to take, typically a method invocation on a target.\n\n## Single method invocation\nInvocation of a single method may be represented with an object containing the following properties:\n* \"target\" (string): The name of a component in the current UI to invoke a method on.\n* \"name\" (string): The name of the method to invoke.\n\nFor these actions, arguments to the method you specify,if any, will be added later.\n\nExample 1: grid1 can show it's records in a separate form1 when grid-records are clicked by setting the grid's recordClick event to this action:\n```\n{\n  \"target\": \"form1\",\n  \"name\": \"editSelectedData\"\n}\n```\n",
format:"Markdown"
},
"class:Canvas:eventMethods":{
topic:"Canvas events",
content:
"The following event methods are available on the Canvas class, as well as the classes that extend Canvas:\n\n## Mouse-related events\n\n* \"mouseOver\": Fired when the mouse enters the component.\n* \"mouseOut\": Fired when the mouse leaves the component.\n* \"mouseMove\": Fired when the mouse moves within the component.\n* \"mouseDown\": Fired when the left mouse button is pressed on the component.\n* \"mouseStillDown\": Repeating notification method for the left mouse button being held down on the component.\n* \"mouseUp\": Fired when the left mouse button is released on the component.\n* \"click\": Fired when the left mouse button is clicked (pressed and then released) on the component.\n* \"doubleClick\": Fired when the left mouse button is clicked twice in rapid succession (within \"doubleClickDelay\" by default) on the component.\n* \"rightMouseDown\": Fired when the right mouse button is pressed on the component.\n* \"showContextMenu\": Fired when the right mouse button is clicked on the component.\n* \"mouseWheel\": Fired when the mouse wheel is actuated on the component.\n\n## Drag-and-drop-related events\n\n* \"dragStart\"\n* \"dragMove\"\n* \"dragStop\"\n* \"dragRepositionStart\"\n* \"dragRepositionMove\"\n* \"dragRepositionStop\"\n* \"dragResizeStart\"\n* \"dragResizeMove\"\n* \"dragResizeStop\"\n* \"willAcceptDrop\"\n* \"dropOver\"\n* \"dropOut\"\n* \"dropMove\"\n* \"drop\"\n\n## Keyboard-related events\n\n* \"keyDown\": Fired when a key is pressed while the component has keyboard focus.\n* \"keyUp\": Fired when a key is released while the component has keyboard focus.\n* \"keyPress\": Fired when a key is pressed and then released while the component has keyboard focus.\n\n## Miscellaneous events\n\n* \"initComplete\": Fired after initWidget(), when initialization of the component is complete.\n* \"drawn\": Fired when the component has been drawn into the page.\n* \"focusChanged\": Fired when the component receives or loses keyboard focus.\n* \"visibilityChanged\": Fired when the component becomes visible or hidden.\n* \"hover\": Fired when the mouse is hovered over the component.\n* \"hoverHidden\": Fired whenever the hover shown in response to handleHover() is hidden.\n* \"parentMoved\": Fired when an ancestor-of-the-component's position changes.\n* \"parentResized\": Fired when the interior size of the parent changes.\n* \"resized\": Fired when the component's size changes.\n* \"scrolled\": Fired when the component is scrolled.\n* \"ruleContextChanged\"",
format:"Markdown"
},
"interface:DataBoundComponent":{
topic:"DataBoundComponent interface",
content:
"DataBoundComponent is an interface implemented by several UI components that connects (or \"binds\") the component to a data source, to load, display, and update data—one or more records—in the data source automatically. Examples include grids (ListGrid), forms (DynamicForm), trees (TreeGrid), and charts (FacetChart). It handles the basic responsibilities of fetching data, tracking changes, and saving edits back to the server for the components that implement the interface.\n\n## Fields\nThe \"fields\" attribute of a DBC is an array of DBCField objects that specifies which properties of records to present, in what order, and how each field should behave and look in the DBC. The basic DBCField attributes are:\n* \"name\" (string): Name of the field. Typically, this is the name of a field of the data source. The name must be unique within the DBC as well as a valid JavaScript identifier.\n* \"title\" (HTML string): A displayable title for the field.\n* \"type\" (string): Type of the field.\n* \"multiple\" (boolean): If set to `true`, then the field is array-valued.\n* \"required\" (boolean): If set to `true`, then records are required to have a value for the field.\n\nDepending on the specific DBC (like ListGrid, DynamicForm, etc.), there are additional field attributes (e.g., validators, picklists, icons) to further configure the behavior and appearance of the field in the DBC.\n\nWhen both \"fields\" and \"dataSource\" are set on the DBC, any fields in \"fields\" with the same name as a data source field inherit the properties of the corresponding DataSourceField object. This allows you to centralize data model information in the data source, but customize the presentation and order of data source fields on a per-component basis.\n\nBy default, only fields mentioned in \"fields\" are presented in the DBC. The \"useAllDataSourceFields\" attribute of the DBC can be set to `true` to present all fields from the data source, with the DBC's \"fields\" acting as field-by-field overrides and/or additional fields.\n\nIf \"dataSource\" is set on the DBC, but not \"fields\", then all of the data source's fields become fields of the DBC.\n\nAfter a DBC has been created, the setFields([newFields]) method may be called to change the DBC's fields. If `newFields` is not specified or null, then the DBC will use the data source fields. Otherwise, the DBC is substantially rebuilt as if it were created with \"fields\" set to `newFields`.\n\nOnce a DBCField object has been set as a field on a DBC, it is invalid to modify the object's attributes directly, unless the attribute is specifically marked as writable. Instead, use setters on the DBC if available to change the field attribute or create a new DBCField object and update the component's fields (via setFields()) with the new DBCField object replacing the old one.\n\n## Data source & fetching data\n\n### Attributes\n* \"dataSource\" (string): The ID of the data source to bind to.\n* \"autoFetchData\" (boolean): If set to `true`, the DBC will perform a one-time fetch of data from the data source to display in the component.\n* \"fetchRequestProperties\" (DSRequest properties): If \"autoFetchData\" is `true`, an object containing properties for the one-time DSRequest to fetch the initial data.\n* \"implicitCriteria\" (AdvancedCriteria object): Criteria that are never shown to or edited by the user and are cumulative with any criteria provided by the user or \"initialCriteria\".\n* \"initialCriteria\" (AdvancedCriteria object): Initial criteria for the DBC. Typically, the user has the ability to modify this, to customize what data is displayed.\n\n### Methods\n* setData([newData]): Sets the data to be displayed in the DBC.\n* setDataSource([newDataSource, fields]): If `newDataSource` is null, then unbinds the DBC from its existing data source. Otherwise, if the DBC is bound to a different data source, then the DBC is bound to the new data source. Any existing data and fields are discarded, and `fields` is used as the DBC's new fields.\n* fetchData([criteria, callback, requestProperties]): Fetches data from the data source. If data has not already been provided via setData(), this method will create a ResultSet and use it from then on.\n* setImplicitCriteria([newImplicitCriteria, callback, initialFetch]): Sets the DBC's \"implicitCriteria\".\n\n## Sorting\nThe \"initialSort\" attribute (array of SortSpecifier objects) specifies the initial sort configuration.\ngetSort() may be used to obtain a copy of the DBC's current sort configuration.\nsetSort([newSortSpecifiers]) may be used to set the DBC's sort configuration.\n\n## Additional notes\nBy default, a DBC will not fetch any data from the data source; the DBC will display no data until fetchData() is called to request data from the data source, or until setData() is called to set the data to display in the DBC. Usually, \"autoFetchData\" should be set to `true`, unless there is a specific reason not to display any data initially, such as:\n- If the component is primarily (or at least initially) for editing new data.\n- The component is there to accept records dropped onto it from other DBCs.\n- If the component displays or edits data related to the user's selection of record(s) in another DBC.",
format:"Markdown",
dependencies:["object:AdvancedCriteria"]
},
"class:DynamicForm":{
topic:"DynamicForm class",
content:
"DynamicForm is a DataBoundComponent that displays a form for viewing and editing the properties of a single record. It can bind to a data source to automatically load, display, validate, and save data. DynamicForms are commonly used for data entry, editing existing records, filtering data in grids, and displaying record details.\n\nDynamicForm handles generating and laying out form controls (form items) based on the fields it is configured with. It also provides extensive support for dynamic behavior, such as showing or hiding fields and enabling/disabling controls.\n\n## Fields/Items\nThe \"fields\" attribute of a DynamicForm is an array of FormItem configuration objects. Each object specifies a single input control in the form. Basic FormItem attributes include:\n* \"name\" (string): Name of the field. This typically corresponds to the name of a field in the data source.\n* \"title\" (HTML string): Label text for the form item.\n* \"showTitle\" (boolean): Whether a title cell should be shown for the form item.\n* \"hint\" (HTML string): String to show next to the form item to indicate something to the user. This string generally appears to the right of the form item.\n* \"type\" (string): The type of data-value edited by the form item.\n* \"editorType\" (string): The name of the FormItem class to use (e.g. TextItem or SelectItem). If not specified, then this is derived automatically from the field \"type\".\n* \"canEdit\" (boolean): Is the form item editable (\"canEdit\":`true`) or read-only (\"canEdit\":`false`)?\n* \"required\" (boolean): If set to `true`, then a value for the form item is required.\n* \"requiredWhen\" (AdvancedCriteria object): Criteria to be evaluated to determine whether the form item should be required.\n* \"defaultValue\": The data-value to use when no value is provided for the form item.\n* \"valueMap\" (object | array of HTML string): A map from the data-value that is stored in the record to the HTML display-value that is shown to the user. If \"valueMap\" is an array, then the data-values are the integer indices into the array.\n* \"shouldSaveValue\" (boolean): Should the form item's value be saved in the form's values? \"shouldSaveValue\":`false` is used to mark form items which do not correspond to the underlying data model. Examples include: visual separators, password re-type fields, and checkboxes used to show/hide other form items.\n* \"validators\" (array of Validator properties): Validators for the form item. Note: These validators will only be run on the client. To do server-enforced validation, validators must be specified via the DataSourceField's \"validators\".\n* \"showErrorIcon\" (boolean): Should an error icon appear next to next to the form item if there is a validation error?\n* \"showErrorText\" (boolean): If there is a validation error, should the validation error message be displayed next to the form item?\n\nLike other DataBoundComponents, if you specify \"fields\" together with \"dataSource\", fields with matching names inherit data source field attributes. If \"fields\" is omitted, the form will use all fields from the data source by default. To include all data source fields but customize some fields selectively, set \"useAllDataSourceFields\" to `true`.\n\nAfter creation, the form's fields can be reconfigured using setFields([newFields]).\n\nFormItem lifecycle is managed by the DynamicForm itself. FormItem instances are created and destroyed automatically when new fields are added to the form.\n\n### SelectItem and ComboBoxItem\nDynamicForm provides specialized FormItems for selecting values from a list: SelectItem and ComboBoxItem. These components present drop-down picklists, but they differ slightly in behavior and configuration options.\n\nSelectItem displays a static list of options in a drop-down. The user must pick from the list (no freeform entry).\n\nComboBoxItem combines a picklist with freeform text entry, allowing the user to either pick an option or type their own value. It is commonly used when there are many possible values or when users might enter new ones.\n\n#### Notes on \"valueMap\" vs. \"optionDataSource\"\n* \"valueMap\" provides a simple, static list of options embedded in the form item configuration.\n* \"optionDataSource\" allows the picklist to be populated dynamically from the specified data source.\n* When \"optionDataSource\" is set, the ComboBoxItem (or SelectItem) automatically issues fetch requests to load matching options as the user types (or when the control is opened).\n* For best results, specify \"displayField\" and \"valueField\" to control what is shown (display-value) vs. stored (data-value).\n\n## Layout and appearance\nDynamicForm provides a flexible layout engine for arranging form controls in a grid-like structure. The overall layout is determined by properties set on the DynamicForm itself, while individual field placement and sizing are configured via attributes on each FormItem.\n\n### DynamicForm-level layout attributes\nThese attributes control the form's general structure and layout behavior:\n* \"numCols\" (integer): The number of columns in the form's grid layout. Default is 2. FormItems are placed left to right in each row and automatically wrap to the next row as needed.\n* \"colWidths\" (array of FormItemWidthSpec): An array specifying the widths of each column. FormItemWidthSpec is either an integer (number of pixels wide) or the string \"*\", which divides the remaining space among the columns that have FormItemWidthSpec \"*\".\n* \"titleOrientation\" (\"top\" | \"left\" | \"right\"): Controls where the title (label) appears relative to the field. The default is \"left\".\n* \"titleSuffix\" (HTML string): String to append after every title. The default is \"&nbsp;:\"\n\n### FormItem-level layout attributes\nEach FormItem has properties to control how it is placed within the form's layout:\n* \"colSpan\" (integer or \"*\"): Number of columns the item occupies. Use \"*\" to span all remaining columns of the current row. The \"colSpan\" does not include the title shown for the form item if \"showTitle\":`true`, so the effective \"colSpan\" is one higher than this setting if this item is showing a title and the title orientation is either \"left\" or \"right\".\n* \"rowSpan\" (integer): Number of rows the item occupies.\n* \"startRow\" (boolean): If `true`, the item starts a new row regardless of the previous item's placement.\n* \"endRow\" (boolean): If `true`, the next item will appear on the next row.\n* \"sectionExpanded\" (boolean): For SectionItems, whether the section starts expanded.\n\n### SectionItems and grouping\nTo organize fields visually and functionally, DynamicForm supports special items:\n* SectionItem: Renders a collapsible section containing other fields. Fields declared after the SectionItem in the \"fields\" array are automatically grouped under it until the next SectionItem or the end of the array.\n* SpacerItem: Creates blank space in the layout grid.\n* RowSpacerItem: Inserts vertical space between rows.\n* BlurbItem / StaticTextItem: Renders uneditable text, often used for instructions or explanations.\n\n### Notes\n* Titles are automatically sized to fit the longest label in the form, unless overridden with \"colWidths\".\n* When showing titles or using \"colSpan\", \"rowSpan\", \"startRow\", and \"endRow\", be aware of how items wrap and how space is allocated across columns and rows.\n\n## Data binding and loading data\n\n### Attributes\n* \"dataSource\" (string): The ID of the data source to bind the form to.\n* \"autoFetchData\" (boolean): If `true`, automatically loads the first record from the data source when the form is initialized.\n\n### Methods\n* editRecord(record): Populates the form with data from the provided record object.\n* editNewRecord([initialValues]): Puts the form into \"new record\" mode for adding a new record.\n* fetchData([criteria, callback, requestProperties]): Fetches data from the data source and populates the form with the first record matching `criteria`.\n* saveData([callback, requestProperties]): Saves the current form values to the data source.\n* reset(): Resets the form's values to their initial state.\n* setValues(values): Sets the current form values without affecting the editing state.\n* getValues(): Returns an object containing the current form values.\n\n## Validation\nDynamicForm automatically performs validation whenever saveData() is called. Each field is validated according to:\n* \"required\" flags\n* \"validators\" specified on the field or corresponding data source field\n* built-in type validations (e.g., integers, dates)\n\nValidation errors are shown next to the corresponding FormItems by default. Form item attributes \"showErrorIcon\", \"showErrorText\", etc. control how validation errors are displayed when they are displayed inline in the form, next to the form item where there is a validation error. To instead display all errors at the top of the form, set the form's \"showInlineErrors\" attribute to `false`.\n\n## Editing behavior\nBy default, DynamicForm:\n* Tracks whether the form has been modified (isDirty()).\n* Validates all fields before saving.\n* Sends an \"add\" or \"update\" operation to the data source when saveData() is called.\n* Resets the form when a save completes successfully (if editing a new record).\n\n## Additional notes\n* FormItems can be shown or hidden dynamically via showItem() and hideItem().\n* You can programmatically validate the form with validate() or validateItem(name).\n* Form values can be retrieved at any time via getValuesAsAdvancedCriteria() for filtering other DataBoundComponents.\n",
format:"Markdown",
dependencies:["interface:DataBoundComponent"]
},
"class:ListGrid":{
topic:"ListGrid class",
content:
"ListGrid displays data in a tabular/grid form, with rows (corresponding to records) and columns (corresponding to fields). It supports built-in features like sorting, filtering, grouping, hiliting, and editing data directly in the grid. ListGrid implements DataBoundComponent.\n\n## Fields\nThe grid's \"fields\" attribute is an array of ListGridField objects.\n",
format:"Markdown",
dependencies:["interface:DataBoundComponent","object:ListGridField"]
},
"object:AdvancedCriteria":{
topic:"AdvancedCriteria",
content:
isc.trimDoc`
                An AdvancedCriteria object expresses record-filtering logic in SmartClient data queries.
                The object usually contains, at minimum, the properties:
                * "_constructor" (only for the top-level object, omitted in subcriteria): the string "AdvancedCriteria"
                * "operator": one of the following operator strings:
                    - Logical operators: "and", "or", "not"
                    - Field operators:
                        * Equality: "equals", "notEqual", "iEquals", "iNotEqual"
                        * Substring: "contains", "notContains", "iContains", "iNotContains"
                        * Prefix: "startsWith", "notStartsWith", "iStartsWith", "iNotStartsWith"
                        * Suffix: "endsWith", "notEndsWith", "iEndsWith", "iNotEndsWith"
                        * Comparison: "greaterThan", "greaterOrEqual", "lessThan", "lessOrEqual"
                        * Null/blank: "isNull", "notNull", "isBlank" (equals null or ""), "notBlank" (neither null nor "")

                    Do not use any other operator.

                You may see that the "_constructor" property has been omitted in the top-level
                object.  That is valid, but it is better to explicitly include "_constructor":"AdvancedCriteria".

                If the "operator" is "equals" (the default), then "operator" may be omitted.

                When using a logical operator, the AdvancedCriteria must have a "criteria" property.
                For "not", this is a single AdvancedCriteria, and for "and"/"or" this is an array
                of two or more AdvancedCriteria.
                The semantics of the logical operators are as follows:
                * "and" requires all subcriteria to be \`true\`.
                * "or" requires at least one subcriterion to be \`true\`.
                * "not" negates the single subcriterion.

                When using a field operator, the AdvancedCriteria object must have the additional properties:
                * "fieldName": the field name
                * "value": the comparison value (omit if "operator" is "isNull", "notNull", "isBlank", or "notBlank")

                For equality and comparison criteria on numeric fields, you must infer the units
                of the field's values from the field's title, description, name or other available
                information about the field. For example, if a field's title is "Area in km^2",
                then you might infer that the field's values have units of square-kilometers.
                Always convert comparison values to the same units that you infer for the
                field's values. For example, if you infer (from the name) that a 'cmLength' field
                has units of centimeters and you want to filter for lengths greater than
                100 inches, then you must convert 100 inches (the comparison value) to the same
                units of the field values (centimeters); "'cmLength' is more than 100 inches"
                can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "greaterThan",
                  "fieldName": "cmLength",
                  "value": 254  // 100 inches converted to centimeters (the units of the 'cmLength' field)
                }
                </code>

                If you are outputting AdvancedCriteria as JSON, then for fields of type "date",
                "value" will be a string in the format "yyyy-MM-dd", where yyyy
                is the four-digit year, MM is the two-digit month (01 = January), and dd is
                the two-digit day of the month. If you are outputting AdvancedCriteria as JavaScript,
                then "value" should be a call to isc.DateUtil.createLogicalDate(year, month, day),
                where \`month\` is 0-based.

                AdvancedCriteria does not support filtering by top-N (e.g. the top 3 records)
                or percentiles directly. To achieve those requirements, configure the "startRow",
                "endRow", and "sortBy" fetch DSRequest properties, or the "dataPageSize" and
                "initialSort" DataBoundComponent properties.

                The equality, substring, prefix, and suffix operators beginning with "i" are
                case-insensitive.

                If the "operator" is "lessThan" or "lessOrEqual" and the field's values may
                be \`null\` (i.e. the field is not "required":\`true\`), then you must be
                explicit about whether to include \`null\` values or not; this is because some
                data queries will treat \`null\` as always less-than any non-\`null\` value,
                but other data queries will not. If you want \`null\` values to be included,
                then use an "or" criterion with one of the subcriteria using "operator":"isNull"
                on the field. If you do not want \`null\` values to be included, then use an
                "and" criterion with one of the subcriteria using "operator":"notNull"
                on the field.
                For example, given a 'testScore' field that is not required (hence, its values
                may be \`null\`):
                "'testScore' is available and less than 75" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "and",
                  "criteria": [
                    {"fieldName": "testScore", "operator": "notNull"},
                    {"fieldName": "testScore", "operator": "lessThan", "value": 75}
                  ]
                }
                </code>
                "'testScore' is not reported or less than 20" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "or",
                  "criteria": [
                    {"fieldName": "testScore", "operator": "isNull"},
                    {"fieldName": "testScore", "operator": "lessThan", "value": 20}
                  ]
                }
                </code>

                Example: "'fieldA' is greater than zero" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "greaterThan",
                  "fieldName": "fieldA",
                  "value": 0
                }
                </code>

                Example: "'orderID' must be non-empty and 'orderTotal' must be more than 0 and
                less than 20" can be represented as:
                <code language="JavaScript">
                {
                  "_constructor": "AdvancedCriteria",
                  "operator": "and",
                  "criteria": [
                    {"fieldName": "orderID", "operator": "notBlank"},
                    {"fieldName": "orderTotal", "operator": "greaterThan", "value": 0},
                    {"fieldName": "orderTotal", "operator": "lessThan", "value": 20}
                  ]
                }
                </code>
            `,
format:"Markdown"
},
"CriteriaShorthand":{
topic:"Criteria Shorthand",
content:'xmlCriteriaShorthand\nAll rules described in this topic are applied any time a property is of type AdvancedCriteria (in both Component XML and JavaScript component creation) and any API declares an AdvancedCriteria param.\n\nA shorthand format for AdvancedCriteria is supported for simple criteria where the outer criterion is assumed to be an "and" operator:\n\n <!-- Simple format -->\n <criteria fieldName="restrictAge" operator="equals" value="true"/>\n \nThis is equivalent to:\n <!-- Normal format -->\n <criteria _constructor="AdvancedCriteria operator="and">\n   <criteria>\n     <criterion fieldName="restrictAge" operator="equals" value="true"/>\n   </criteria> \n </criteria>\n \nAdditionally these defaults are used allowing to simplify AdvancedCriteria declaration:\noperator="and" default is used if criteria is present at the same level\noperator="equals" default is used if fieldName is present at the same level\nvalue="true" default is used if operator="equals" default was applied\nSo, shorthand format above could be simplified even more, for example to conditionally enable a form button:\n <!-- Simple format -->\n <enableWhen fieldName="CustomerGrid.anySelected"/>\n \nFull equivalent:\n <!-- Normal format -->\n <enableWhen _constructor="AdvancedCriteria operator="and">\n   <criteria>\n     <criterion fieldName="CustomerGrid.anySelected" operator="equals" value="true"/>\n   </criteria>\n </enableWhen>\n \nAnother example shows all defaults usage, significantly shortening AdvancedCriteria declaration for boolean dynamic property (see full setup in Boolean Dynamic Properties example):\n <!-- Simple format -->\n <trueWhen>\n     <criteria fieldName="settingsForm/values/exportFieldWidths" />\n     <criteria fieldName="settingsForm/values/exportAs" operator="inSet" >\n         <value>xls</value>\n         <value>ooxml</value>\n     </criteria>\n </trueWhen>\n \nFull equivalent:\n <!-- Normal format -->\n <trueWhen>\n     <AdvancedCriteria operator="and">\n         <criteria>\n             <criterion fieldName="settingsForm/values/exportFieldWidths" operator="equals" value="true"/>\n             <criterion fieldName="settingsForm/values/exportAs" operator="inSet" >\n                 <value>xls</value>\n                 <value>ooxml</value>\n             </criterion>\n         </criteria>\n     </AdvancedCriteria>\n </trueWhen>\n \nJS example:\n // Simple format\n {fieldName: "restrictAge"}\n\n // Normal format\n {\n   _constructor: "AdvancedCriteria",\n   operator: "and",\n   criteria: [\n     {fieldName: "restrictAge", operator: "equals", value: true}\n   ]\n }\n',
format:"Markdown"
},
"class:TabSet":{
topic:"Tabset class",
content:"## TabSet Overview\nThe SmartClient TabSet is a UI control that provides a tabbed interface for managing multiple\ncontent panes within a single container. Each tab displays its associated pane when selected.\nThis allows compact organization of related views in applications like dashboards or wizards.\n\n## Key Concepts\n- Tabs: Clickable labels used to switch views.\n- Panes: Content displayed when a tab is selected.\n- TabSet: Container that holds and manages tabs and their content.\n\n## Creating a TabSet\nUse isc.TabSet.create() to define the tabbed layout and initialize with optional tabs:\n\n  isc.TabSet.create({\n      ID: \"mainTabSet\",\n      width: \"100%\",\n      height: \"100%\",\n      tabs: []\n  });\n\n## Adding Tabs and Panes\nTabs are objects with at least a title and pane (any SmartClient component):\n\n  mainTabSet.addTab({\n      title: \"New Tab\",\n      ID: \"newTab\",\n      pane: isc.HTMLPane.create({ contents: \"<h2>Hello from new tab!</h2>\" })\n  });\n\n## Accessing and Managing Tabs\n- Select a tab:\n    mainTabSet.selectTab(\"tab1\");\n- Remove a tab:\n    mainTabSet.removeTab(\"tab1\");\n- Update a tab:\n    mainTabSet.updateTab(\"tab1\", { title: \"Updated Title\" });\n- Get selected tab:\n    var tab = mainTabSet.getSelectedTab();\n\n## Working with Panes\nPanes are SmartClient components (Canvas, ListGrid, etc.). They can be updated or accessed:\n\n  mainTabSet.updateTab(\"tab1\", {\n      pane: isc.DynamicForm.create({ fields: [...] })\n  });\n\n  var pane = mainTabSet.getTabPane(\"tab1\");\n\n## Events and Interaction\n- tabSelected: Fires when a tab is selected.\n- tabDeselected: Fires before a tab is switched away from.\n- canCloseTabs: Enables close buttons on each tab.\n\n  mainTabSet.tabSelected = function (tabNum, tabPane, ID, tab) {\n      isc.say(\"You selected tab: \" + tab.title);\n  };\n\n## Styling and Configuration Options\n- tabBarPosition: Set to \"top\", \"bottom\", \"left\", or \"right\" to position tabs.\n- canClose: Set true per tab or globally with canCloseTabs: true.\n- Tab picker menu appears automatically if tabs overflow the visible area.\n\n## Summary\nThe TabSet is ideal for managing multiple views in a compact layout. Tabs and their panes can\nbe created, updated, and removed dynamically, making TabSet a flexible layout and navigation\ntool in SmartClient applications.\n",
format:"Markdown"
},
"class:HLayout":{
topic:"HLayout class",
content:"## HLayout Overview\nHLayout is a SmartClient container that arranges its children horizontally, from left to right.\nIt's used when components need to appear side-by-side and automatically manage space and spacing.\n\n## Creating an HLayout\nUse isc.HLayout.create() to define a horizontal layout container:\n\n  isc.HLayout.create({\n      width: \"100%\",\n      height: 100,\n      membersMargin: 10,\n      members: [\n          isc.Label.create({ contents: \"Left\" }),\n          isc.Label.create({ contents: \"Right\" })\n      ]\n  });\n\n## Key Properties\n- members: List of child widgets to be laid out.\n- membersMargin: Spacing between members (in pixels).\n- layoutAlign: Controls vertical alignment (e.g., \"top\", \"center\", \"bottom\").\n- width / height: Specifies the size of the layout container.\n- overflow: Defines how to handle overflow content.\n\n## Dynamic Usage\n- Add a member:\n    myHLayout.addMember(isc.Button.create({ title: \"New Button\" }));\n- Remove a member:\n    myHLayout.removeMember(existingComponent);\n\n## Flexible Sizing\n- Use layoutPolicy: \"fill\" to stretch children.\n- Children can use width: \"*\" to take remaining space.\n\n## Nesting\nHLayouts can be nested within other layouts to build complex horizontal arrangements in UIs.\n\n## Summary\nHLayout helps structure UI horizontally, automatically handling spacing and sizing. Ideal for\ntoolbars, split panes, or any layout requiring side-by-side arrangement of components.\n",
format:"markdown"
},
"class:VLayout":{
topic:"VLayout class",
content:"## VLayout Overview\nVLayout is a SmartClient layout container that arranges child components vertically, top to bottom.\nIt is commonly used for stacking elements in forms, dashboards, or panels.\n\n## Creating a VLayout\nUse isc.VLayout.create() to define a vertical layout structure:\n\n  isc.VLayout.create({\n      width: 300,\n      height: \"100%\",\n      membersMargin: 5,\n      members: [\n          isc.Button.create({ title: \"Top\" }),\n          isc.Button.create({ title: \"Bottom\" })\n      ]\n  });\n\n## Key Properties\n- members: Array of child widgets to be stacked vertically.\n- membersMargin: Sets space between stacked items.\n- layoutAlign: Controls horizontal alignment (e.g., \"left\", \"center\", \"right\").\n- height / width: Overall layout container size.\n- overflow: Behavior when children exceed layout size.\n\n## Dynamic Usage\n- Add a new member dynamically:\n    myVLayout.addMember(isc.Label.create({ contents: \"Dynamic Label\" }));\n- Remove an existing member:\n    myVLayout.removeMember(existingComponent);\n\n## Stretching and Fill\n- Set layoutPolicy: \"fill\" to distribute available space.\n- Children can use height: \"*\" to grow and fill remaining vertical space.\n\n## Nesting\nVLayouts can contain other VLayouts or HLayouts to compose rich, nested UI structures.\n\n## Summary\nVLayout is best suited for top-to-bottom arrangements like stacked buttons, form fields, or\nsections. It simplifies spacing and resizing and is a key building block in SmartClient UIs.\n",
format:"markdown"
},
"class:Button":{
topic:"Button class",
content:"## Button Overview\nThe SmartClient Button class is a subclass of Canvas that provides a clickable UI control with\na caption, built-in styling, and mouse interaction. It is used to trigger actions in response\nto user input.\n\n## Creating a Button\nButtons are created with isc.Button.create() and require at least a title and optionally a\nclick handler:\n\n  isc.Button.create({\n      title: \"Click Me\",\n      width: 120,\n      click: function () {\n          isc.say(\"Button clicked!\");\n      }\n  });\n\n## Pertinent Properties (Not in Canvas)\n- title: String shown on the button face. This is the main label of the button.\n- autoFit: If true, the button automatically sizes to fit its title.\n- icon: URL or image reference to show an icon next to the title.\n- iconOrientation: \"left\" or \"right\" – controls where icon appears relative to title.\n- showRollOver, showDown: Boolean flags that control visual feedback for mouse interactions.\n- baseStyle: CSS style name for customizing the button's appearance.\n\n## Events and Interaction\n- click(): This is the primary interaction event for buttons.\n  Define this function to perform an action when the user presses the button.\n\n  Example:\n    click: function () {\n        doSomethingImportant();\n    }\n\n- mouseOver(), mouseOut(), mouseDown(), mouseUp(): Optional Canvas-based event hooks.\n\n## Styling Buttons\n- You can customize the visual style using baseStyle and skinning system.\n- Use autoFit for buttons that grow/shrink with the label text.\n- For grouped buttons or toolbars, consider placing them in an HLayout or ToolStrip.\n\n## Summary\nSmartClient Buttons provide a ready-to-use interactive element with a title, built-in click\nevent support, and automatic visual feedback. They extend Canvas but introduce user-facing\nproperties like title, autoFit, icon, and the all-important click() handler.\n",
format:"markdown"
},
"class:FacetChart":{
topic:"FacetChart class",
content:"## FacetChart Overview\nFacetChart is a SmartClient data visualization component used to display charts like bar,\nline, pie, and area graphs. It is built on the DrawPane and supports multi-faceted data,\nwith grouping, titles, legends, and interactive features.\n\n## Creating a FacetChart\nCreate a chart with isc.FacetChart.create(), specifying chart type, data, and value metrics:\n\n  isc.FacetChart.create({\n      ID: \"salesChart\",\n      width: \"100%\",\n      height: 300,\n      chartType: \"bar\",\n      facets: [\n          { id: \"region\", title: \"Region\" }\n      ],\n      valueProperty: \"sales\",\n      data: [\n          { region: \"North\", sales: 120 },\n          { region: \"South\", sales: 95 }\n      ]\n  });\n\n## Supported chartType values\n- \"bar\" (default)\n- \"column\"\n- \"line\"\n- \"area\"\n- \"pie\"\n- \"doughnut\"\n- \"radar\"\n\n## Key Properties\n- chartType: Defines the type of chart to render (e.g., \"bar\", \"pie\").\n- facets: Defines dimensions for grouping (like rows or series).\n- valueProperty: The field containing numerical data for plotting.\n- title: Title of the chart.\n- showLegend: Controls visibility of the legend.\n- data: Array of data records, each with facet and value fields.\n\n## Interaction Features\n- showDataValuesMode: never, auto, inChartOnly, inChartOrHover, inChartAndHover, inHoverOnly.\n- click events: valueClick, pointClick, legendClick, dataLabelClick - Define behavior when chart elements are clicked.\n\n  Example:\n    valueClick: function (drawnValue) {\n        isc.say(\"Clicked on: \" + drawnValue);\n    }\n\n## Styling and Configuration\n- Use valueTitle to set labels for data values.\n- Use facets and facetTitles to control groupings and legend labels.\n\n## Summary\nFacetChart allows developers to create rich, interactive visualizations with multiple chart\ntypes. While it supports many standard charts, scatter plots are not supported, and related\nproperties like xAxisMetric must be avoided. Use FacetChart for data summaries, comparisons,\nand visual groupings across multiple dimensions.\n",
format:"markdown"
},
"class:Facet":{
topic:"Facet class",
content:"## Facet Overview\nThe Facet class in SmartClient defines a dimension of categorization for use in components\nlike FacetChart. Each facet represents a field or attribute by which data can be grouped,\nsplit, or compared visually.\n\nFacets are typically passed into the `facets` array of a FacetChart and define how data records\nare bucketed or displayed in charts.\n\n## Basic Structure\nEach facet is a simple object that usually includes an `id`, a `title`, and a `values` array.\n\n  {\n      id: \"region\",\n      title: \"Region\",\n      values: [\n          { id: \"north\", title: \"North\" },\n          { id: \"south\", title: \"South\" }\n      ]\n  }\n\n## Key Properties\n- id: The unique identifier for the facet (used to match data).\n- title: A human-readable label for display in charts and legends.\n- values: An array of objects defining each discrete value in the facet.\n  Each value typically includes:\n    - id: The data value.\n    - title: The label to show in the chart UI.\n\n**Important Note:** The Facet class does NOT use a `valueMap` property.\nInstead, it uses a `values` array with structured objects. If you're trying to customize\ndisplay labels, use `values` with `id` and `title` entries, not a flat valueMap.\n\n## Example Use in a FacetChart\n  isc.FacetChart.create({\n      facets: [\n          {\n              id: \"product\",\n              title: \"Product\",\n              values: [\n                  { id: \"A\", title: \"Product A\" },\n                  { id: \"B\", title: \"Product B\" }\n              ]\n          }\n      ],\n      valueProperty: \"sales\",\n      chartType: \"bar\",\n      data: [\n          { product: \"A\", sales: 120 },\n          { product: \"B\", sales: 90 }\n      ]\n  });\n\n## Summary\nFacets define how SmartClient charts and grids categorize and group data. A facet consists of\nan id, title, and a values array. Unlike form items, facets do not use valueMap — instead, they\nexpect a structured `values` array to define display labels and order. Facets are essential for\ndriving multi-dimensional visualizations in FacetChart.\n",
format:"markdown"
},
"object:DBCField":{
topic:"DBCField object",
content:"## DBCField Overview\nA DBCField is a field declaration used within a DataBoundComponent (such as ListGrid,\nDynamicForm, or DetailViewer) to bind the component to a specific field from its\nDataSource. It is based on the Field type and adds exactly one required property: `name`.\n\n## Relationship to Field\nDBCField inherits from Field, which includes the following properties:\n- canEdit\n- canExport\n- escapeHTML\n- exportTitle\n- multiple\n- primaryKey\n- required\n- sortByField\n- title\n- type\n- valueMap\n\nThese properties define how the field behaves and is rendered in the UI. They do not affect\nserver-side logic.\n\n## DBCField-Specific Property\n- name (String): The ID of the DataSource field this DBCField represents. This is required\n  and is the only property on DBCField that is not already present on Field.\n\n## Example\n  isc.ListGrid.create({\n      dataSource: \"employeesDS\",\n      fields: [\n          { name: \"employeeId\", title: \"ID\", canEdit: false },\n          { name: \"name\", required: true },\n          { name: \"department\", valueMap: [\"HR\", \"Sales\", \"Engineering\"] }\n      ]\n  });\n\n## Summary\nDBCField is the type used in DataBoundComponents to define which DataSource fields to display\nand how. It is identical to Field except that it adds one required property — `name` — to\nidentify the field being bound. All other behavior is inherited from Field.\n",
format:"markdown"
},
"class:Label":{
topic:"Label class",
content:"## Label Overview\nThe SmartClient `Label` class is a lightweight, read-only display widget used to show static\ntext or HTML content in the UI. It extends `Canvas` and is optimized for performance and\nsimplicity when no user interaction or editing is needed.\n\n## Relationship to Canvas\n`Label` is a subclass of `Canvas`, and inherits most layout, sizing, and styling behavior from it.\nHowever, it adds specific properties focused on content display and is stripped of interactive\nfeatures like event handling or child widgets.\n\n## Key Properties\n- contents: (String) — The actual text or HTML to be displayed. This is the main content of the label.\n- wrap: (Boolean) — If true, content wraps within the width of the label. Defaults to true.\n- align: (String) — Horizontal alignment of text: \"left\", \"center\", or \"right\".\n- valign: (String) — Vertical alignment: \"top\", \"center\", or \"bottom\".\n- icon: (String) — Optional URL of an image/icon to show next to the text.\n- iconOrientation: (String) — \"left\" or \"right\" — controls icon position relative to text.\n- iconSize: (Number) — Pixel height and width for the icon (applies to both dimensions).\n- clip: (Boolean) — If true, overflow content is clipped instead of resized or wrapped.\n\n## Example\n  isc.Label.create({\n      ID: \"statusLabel\",\n      contents: \"Status: Ready\",\n      width: 200,\n      height: 20,\n      align: \"left\",\n      styleName: \"statusText\"\n  });\n\n## Usage Notes\n- `Label` is read-only. For editable text, use a `TextItem` in a form instead.\n- It can display raw text or HTML. Use `escapeHTML: false` if rendering custom markup.\n- For performance, prefer `Label` over `Canvas` when no interactivity is needed.\n\n## Summary\nSmartClient `Label` is a display-only widget for rendering text or HTML in a clean, efficient way.\nIt supports basic formatting, alignment, and optional icons. Use it for static UI text such as\ncaptions, titles, messages, and status indicators.\n",
format:"markdown"
},
"RuleScope":{
topic:"RuleScope",
content:"Canvas.ruleScope [IR]\ttype:String, defaultValue: null\n\nID of the component that gathers the context for evaluation of criteria-based rules specified by properties such as FormItem.visibleWhen, Dynamic Properties, and dynamicCriteria such as ListGrid.initialCriteria.\nIf ruleScope is not specified, this component will search through its parentCanvas chain until it either reaches the top or reaches a parent marked isRuleScope. This means that typically, ruleScope does not have to be explicitly specified, since components that want to reference each other often have the same top-level parent (eg, they are part of the same screen). However, you would need to specify ruleScope in scenarios such as a modal Window that wants to reference values in the component it was launched from.\n\nDetermination of the ruleScope happens when the component is first drawn.\n\nThe component designated as the ruleScope manages a nested data structure called the \"rule context\" which contains information from all DataBoundComponents that are registered with the ruleScope. By specifying Criterion.fieldName as a DataPath, AdvancedCriteria defined in properties such as FormItem.visibleWhen can access any part of the rule context.\n\nBy default, the rule context contains data as follows:\n\n- Any DataBoundComponent or ValuesManager that has a DataSource contributes the values of the selected record or record being edited under the ID of the DataSource. For any collision an editable display (such as a form or editable grid) wins over a static display. Hidden or cleared components have lowest priority even if editable. For two editable components the first becomes the contributor.\n- Any ListGrid or other component that manages a selection and has been assigned an explicit ID will contribute values of the selected record under <componentId>.selectedRecord, values of the grid summary under <componentId>.summaryRecord, and selection flags: anySelected, multiSelected, numSelected. Also: <componentId>.selectedRowNum.\n- Any DynamicForm or component that edits values and has an explicit ID contributes its current values under <componentId>.values, and contributes a flag hasChanges.\n- Any DynamicForm or ListGrid with an ID contributes <componentId>.focusField to indicate which field has focus, or absence if no focus.\n- Any ListGrid with an ID contributes a flag isGrouped under <componentId>.\n- Any DataSource included in a DataContext or testDataContext contributes to dataContext.<DataSourceID>. Only the first contribution is saved as dataContext is immutable.\n- A ValuesManager contributes the DataSource-prefixed portion of ruleContext before member forms.\n\nIn addition to data from DataBoundComponent, ruleScope includes entries from the Authentication class (e.g. userId, roles) and device characteristics as follows:\n\n{\n  device : {\n    isPhone : false,\n    isTablet : false,\n    isDesktop : true,\n    isLandscape : true\n  }\n}\n\nFor example, if a ListGrid \"itemGrid\" and DynamicForm \"itemForm\" are bound to the same DataSource with selection/editing:\n\n{\n  supplyItem : { itemID: \"654321\", itemName: \"Sewing Machine\", price: 5.50 },\n  itemForm.values : { itemID: \"654321\", itemName: \"Sewing Machine\", price: 5.50 },\n  itemForm.focusField : \"itemName\",\n  itemForm.hasChanges : true,\n  itemGrid.selectedRecord : { itemID: \"654321\", itemName: \"Sewing Machine\", price: 3.50 },\n  itemGrid.anySelected : true,\n  itemGrid.multiSelected : false,\n  itemGrid.numSelected : 1,\n  itemGrid.isGrouped : false,\n  device : { isPhone: false, isTablet: false, isDesktop: true, isLandscape: true },\n  auth : {\n    currentUser : { userId: \"lisa\", firstName: \"Lisa\", lastName: \"Admin\", roles: \"admin\" },\n    roles : ['admin'],\n    isSuperUser : false\n  }\n}\n\nAn application can put custom data into the ruleScope via provideRuleContext().\n\nValuesManager and RuleContext:\n* WhenRules in member forms of a ValuesManager using short-form references apply only to that form. To reference external field values, use the DataSource-prefixed path.\n\nTroubleshooting RuleScope issues:\nThe system includes provideRuleContext() and removeRuleContext(), and consumers include all criteria-based rules. Enable logging for these categories at Info or Debug levels:\n\n- ruleContext\n- whenRules\n- dynamicProperties\n- dynamicCriteria\n\nUse the Developer Console to add these categories if not already present.\n\nExample log entries, evaluations, and criteria diagnostics are available by enabling Info or Debug priority, as shown above.\n\n## dynamicCriteria\nIf a property indicates it has support for \"dynamic criteria\" it means that values in the criteria may be dynamically derived from the current Canvas.ruleScope using Criterion.valuePath.\n\nIn other words, it allows criteria to be declared using values from nearby drawn components, via the Canvas.ruleScope. Values are pulled from the ruleScope via setting Criterion.valuePath. When values drawn from the ruleScope change, the component where dynamicCriteria is declared will be notified and automatically use the new value.\n\nExample:\n\nisc.DynamicForm.create({\n  ID: \"theForm\",\n  items:[{\n    name: \"lifeSpan\",\n    type: \"text\",\n    title: \"LifeSpan\",\n    defaultValue: \"45\"\n  }]\n});\n\nisc.ListGrid.create({\n  width: 300,\n  height: 400,\n  top: 50,\n  dataSource: \"animals\",\n  initialCriteria: {\n    fieldName: \"lifeSpan\",\n    operator: \"greaterThan\",\n    valuePath: \"theForm.values.lifeSpan\"\n  }\n});",
format:"markdown"
},
"ComponentXML":{
topic:"ComponentXML",
content:"Component XML\nAs covered in the QuickStart Guide Chapter 4, Coding, SmartClient components can be created in either XML or JavaScript format. This section covers further details of using the XML format, called \"SmartClient component XML\".\n\nReferring to previously defined components\n\nTo refer to another component by ID in XML, use <Canvas withID=\"\"/>. For example:\n\n<Canvas ID=\"myCanvas\"/>\n<Canvas ID=\"myCanvas2\"/>\n<VLayout>\n    <members>\n        <Canvas withID=\"myCanvas\"/>\n        <Canvas withID=\"myCanvas2\"/>\n    </members>\n</VLayout>\n\nLoading screens stored in Component XML\n\nSave your Component XML as a file named screenName.ui.xml under webroot/shared/ui/. This makes it visible to the system. You can change this path with the server.properties project.ui setting. screenName must use only valid identifier characters (underscores are OK).\n\nIf you use multiple top-level tags, wrap them in <isomorphicXML> to make valid XML.\n\nScreens are loaded with ScreenLoaderServlet (registered at projectBase/isomorphic/screenLoader by default). If you've edited web.xml, you may need to re-register it.\n\nTo launch a mockup-only application:\n<script src=\"../isomorphic/screenLoader?screenName=screenName\"></script>\n\nTo dynamically load or load multiple screens, use RPCManager.loadScreen().\n\nStrict validation can be enabled to catch XML errors (see Strict Mode).\n\nEmbedding JavaScript code\n\nUse the <JS> tag to embed expressions in XML. Example:\n<VLayout>\n    <width><JS>isc.Page.getWidth() - 20</JS></width>\n</VLayout>\n\nStringMethods like ListGrid.recordClick() can be defined inline:\n<ListGrid>\n    <recordClick>if (record.age > 65) doSomething()</recordClick>\n</ListGrid>\n\nOr using <JS>:\n<ListGrid>\n    <recordClick><JS>function (viewer, record) {\n        if (record.age > 65) doSomething();\n    }</JS></recordClick>\n</ListGrid>\n\nUse &amp; for &&, or wrap code in CDATA to avoid escaping:\n<![CDATA[\n  if (record.status != null && record.age > 65) doSomething()\n]]>\n\nFor non-trivial code, keep JavaScript in separate .js files and keep XML simple.\n\nEvent Handlers & Scripting loaded components\n\nRetrieve components using Canvas.getById(\"id\") and attach handlers:\nisc.Canvas.getById(\"mainGrid\").addMethods({ recordClick: \"editForm.editRecord(record)\" });\n\nAdd loaded screen to a layout:\nexistingLayout.addMember(isc.Canvas.getById(\"componentId\"));\n\nUse <Canvas withID=\"theGrid\"/> inside XML to refer to programmatically created components.\n\nDeclarative Actions\n\nDeclare event responses as Actions:\n<recordClick>\n  <Action target=\"customerDetailViewer\" name=\"viewSelectedData\" mapping=\"viewer\"/>\n</recordClick>\n\ntarget: ID of the component\nname: method name\nmapping: optional parameters (see below)\n\nProcesses can also be defined declaratively:\n<recordClick>\n  <Process>...</Process>\n</recordClick>\n\nMultiple Actions and/or Processes can be declared for one event.\n\nParameters and Actions\n\nParameters go in the mapping attribute and can include:\n- Variable name (e.g., record)\n- this (reference to the declaring component)\n- Literals: 'foo', 17\n- JS expressions: new Date()\n\nExample: viewer is passed by recordClick(), so use mapping=\"viewer\"\n\nGlobal IDs\n\nGlobal IDs can conflict when loading multiple screens. Use RPCManager.loadScreen() to avoid this. It suppresses global IDs and gives generated IDs.\n\nUse getByLocalId() from the root of the loaded screen to find components.\n\nLoading multiple screens\n\nUse RPCManager.cacheScreens() to preload screen definitions. Then call RPCManager.createScreen() to instantiate a screen.\n\nBest practices:\n- Load all screens at startup with cacheScreens()\n- Create screens lazily with createScreen()\n- For huge apps, split cacheScreens() calls by feature group\n\nDynamic Component XML\n\nRegister a DynamicScreenGenerator using ScreenLoaderServlet.addDynamicScreenGenerator().\nExample:\nScreenLoaderServlet.addDynamicScreenGenerator(new DynamicScreenGenerator() {\n  public String getScreen(String id) {\n    if (id.equals(\"testDynamicScreenPrefix3\")) return null;\n    id = id.replace(\"testDynamicScreen\", \"\");\n    return \"\";\n  }\n}, \"testDynamicScreenPrefix\");\n\nOther approaches include JSP tags or XML.toJS():\n<%@ taglib uri=\"http://www.smartclient.com/taglib\" prefix=\"isomorphic\" %>\n<isomorphic:XML>...</isomorphic:XML>\n\nOr server-side:\nXML.toJS(\"<isomorphicXML xmlns:xsi=\\\"nativeType\\\">...<\/isomorphicXML>\");\n\nFor static screens, convert XML to JS as a build step and load it with loadScreen().\n\nTroubleshooting\n\n- XML parsing errors appear in server and Developer Console logs.\n- Use the \"RPC\" tab to view screen loader responses.\n- Use \"Eval XML\" in Developer Console > Results to preview and debug.\n\nLocalization\n\nUse <fmt> tags in XML for i18n, as in DataSource files. See DataSource localization docs.\n\nCustom Properties\n\n<Canvas myProperty=\"false\"/> sets the string \"false\", which is truthy in JavaScript.\nUse xsi:type to set type:\n<myProperty xsi:type=\"xsd:boolean\">false</myProperty>\n\nTo define a nested component instance:\n<myListGrid xsi:type=\"ListGrid\" width=\"500\" height=\"600\"/>\n\nTo define a config object (not an instance):\n<listGridProperties xsi:type=\"ListGrid\" propertiesOnly=\"true\" width=\"500\" height=\"600\"/>\n\nCustom Components\n\nDefine a class in JS with defineClass(), then use constructor in XML:\n<ListGrid constructor=\"MyListGrid\" width=\"500\"/>\n\nComponent Schema\n\nYou can define a Component Schema to support Reify, instead of using constructor/xsi:type.",
format:"markdown"
}
},isc.aiHelpDocuments);
isc.registerHelpDocuments({"APIs list:Canvas":{topic:"APIs list for Canvas",content:"Only the following APIs are available on Canvas:\n\n## Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n## Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Layout":{topic:"APIs list for Layout",content:"Only the following APIs are available on Layout:\n\n## Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:HLayout":{topic:"APIs list for HLayout",content:"Only the following APIs are available on HLayout:\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:VLayout":{topic:"APIs list for VLayout",content:"Only the following APIs are available on VLayout:\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:HStack":{topic:"APIs list for HStack",content:"Only the following APIs are available on HStack:\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:VStack":{topic:"APIs list for VStack",content:"Only the following APIs are available on VStack:\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:SectionStack":{topic:"APIs list for SectionStack",content:"Only the following APIs are available on SectionStack:\n\n## Attributes\n* overflow (Overflow string)\n* styleName (CSSStyleName string)\n* sectionHeaderClass (Classname)\n* headerHeight (number)\n* sections (array of SectionStackSection properties objects)\n* canResizeSections (boolean)\n* canDropComponents (boolean)\n* canTabToHeaders (boolean)\n* scrollSectionIntoView (boolean)\n* animateSections (boolean)\n* visibilityMode (VisibilityMode string)\n* canCollapseAll (boolean)\n* itemIndent (number)\n* itemStartIndent (number)\n* itemEndIndent (number)\n* showExpandControls (boolean)\n* canCloseSections (boolean)\n* closeSectionIcon (SCImgURL string)\n* closeSectionIconSize (number)\n\n## Inherited from Layout\n\n### Attributes\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:SectionStackSection":{topic:"APIs list for SectionStackSection",content:"Only the following APIs are available on SectionStackSection:\n\n## Attributes\n* ID (string)\n* controls (array of Canvas)\n* title (HTML string)\n* showClippedTitleOnHover (boolean)\n* items (array of Canvas | array of Shortcut properties objects)\n* showHeader (boolean)\n* resizeable (boolean)\n* expanded (boolean)\n* hidden (boolean)\n* canCollapse (boolean)\n* canClose (boolean)\n* closeIcon (SCImgURL string)\n* closeIconSize (number)\n",format:"Markdown"
},"APIs list:Window":{topic:"APIs list for Window",content:"Only the following APIs are available on Window:\n\n## Attributes\n* canDragReposition (boolean)\n* keepInParentRect (boolean | array of integer)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* opacity (integer)\n* isModal (boolean)\n* showModalMask (boolean)\n* modalMaskOpacity (number)\n* autoCenter (boolean)\n* dismissOnOutsideClick (boolean)\n* dismissOnEscape (boolean)\n* showBody (boolean)\n* bodyStyle (CSSStyleName string)\n* bodyColor (CSSColor string)\n* hiliteBodyColor (CSSColor string)\n* items (array of Canvas | Canvas | string)\n* src (string)\n* contentsType (string)\n* bodyConstructor (string)\n* bodyDefaults (object)\n* contentLayout (ContentLayoutPolicy string)\n* autoSize (boolean)\n* showHeader (boolean)\n* showHeaderBackground (boolean)\n* headerStyle (CSSStyleName string)\n* headerSrc (SCImgURL string)\n* headerControls (array of string)\n* hiliteHeaderStyle (CSSStyleName string)\n* hiliteHeaderSrc (SCImgURL string)\n* showTitle (boolean)\n* title (HTML string)\n* headerLabelDefaults (object)\n* showHeaderIcon (boolean)\n* headerIconDefaults (object)\n* canFocusInHeaderButtons (boolean)\n* showCloseButton (boolean)\n* showMinimizeButton (boolean)\n* minimized (boolean)\n* defaultMinimizeHeight (number)\n* minimizeHeight (number)\n* animateMinimize (boolean)\n* minimizeTime (number)\n* minimizeAcceleration (AnimationAcceleration string)\n* maximized (boolean)\n* showMaximizeButton (boolean)\n* showFooter (boolean)\n* footerHeight (number)\n* footerControls (array of string)\n* showStatusBar (boolean)\n* showResizer (boolean)\n* showEdges (boolean)\n* showShadow (boolean)\n\n## Inherited from Layout\n\n### Attributes\n* overflow (Overflow string)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* layoutMargin (integer)\n* membersMargin (integer)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* dragRepositionCursor (Cursor string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Dialog":{topic:"APIs list for Dialog",content:"Only the following APIs are available on Dialog:\n\n## Attributes\n* defaultWidth (integer)\n* styleName (CSSStyleName string)\n* showToolbar (boolean)\n* toolbarButtons (array of Button | array of Button properties objects)\n\n## Inherited from Window\n\n### Attributes\n* canDragReposition (boolean)\n* keepInParentRect (boolean | array of integer)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* opacity (integer)\n* isModal (boolean)\n* showModalMask (boolean)\n* modalMaskOpacity (number)\n* autoCenter (boolean)\n* dismissOnOutsideClick (boolean)\n* dismissOnEscape (boolean)\n* showBody (boolean)\n* bodyStyle (CSSStyleName string)\n* bodyColor (CSSColor string)\n* hiliteBodyColor (CSSColor string)\n* items (array of Canvas | Canvas | string)\n* src (string)\n* contentsType (string)\n* bodyConstructor (string)\n* bodyDefaults (object)\n* contentLayout (ContentLayoutPolicy string)\n* autoSize (boolean)\n* showHeader (boolean)\n* showHeaderBackground (boolean)\n* headerStyle (CSSStyleName string)\n* headerSrc (SCImgURL string)\n* headerControls (array of string)\n* hiliteHeaderStyle (CSSStyleName string)\n* hiliteHeaderSrc (SCImgURL string)\n* showTitle (boolean)\n* title (HTML string)\n* headerLabelDefaults (object)\n* showHeaderIcon (boolean)\n* headerIconDefaults (object)\n* canFocusInHeaderButtons (boolean)\n* showCloseButton (boolean)\n* showMinimizeButton (boolean)\n* minimized (boolean)\n* defaultMinimizeHeight (number)\n* minimizeHeight (number)\n* animateMinimize (boolean)\n* minimizeTime (number)\n* minimizeAcceleration (AnimationAcceleration string)\n* maximized (boolean)\n* showMaximizeButton (boolean)\n* showFooter (boolean)\n* footerHeight (number)\n* footerControls (array of string)\n* showStatusBar (boolean)\n* showResizer (boolean)\n* showEdges (boolean)\n* showShadow (boolean)\n\n## Inherited from Layout\n\n### Attributes\n* overflow (Overflow string)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* layoutMargin (integer)\n* membersMargin (integer)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* dragRepositionCursor (Cursor string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:DynamicForm":{topic:"APIs list for DynamicForm",content:"Only the following APIs are available on DynamicForm:\n\n## Attributes\n* autoFetchData (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* fetchRequestProperties (DSRequest properties object)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* items (array of FormItem properties objects)\n* fields (array of FormItem properties objects)\n* initialSort (array of SortSpecifier objects)\n* values (object)\n* itemLayout (FormLayoutType)\n* linearMode (boolean)\n* linearOnMobile (boolean)\n* numCols (number)\n* linearNumCols (number)\n* fixedColWidths (boolean)\n* colWidths (array)\n* minColWidth (number)\n* cellPadding (number)\n* cellBorder (number)\n* sectionVisibilityMode (VisibilityMode string)\n* longTextEditorThreshold (number)\n* longTextEditorType (string)\n* valuesManager (ValuesManager | GlobalId string)\n* titleOrientation (TitleOrientation string)\n* titlePrefix (HTML string)\n* rightTitlePrefix (HTML string)\n* titleSuffix (HTML string)\n* rightTitleSuffix (HTML string)\n* titleWidth (number | the literal string \"*\")\n* wrapItemTitles (boolean)\n* showInlineErrors (boolean)\n* showErrorIcons (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* errorItemProperties (object)\n* errorItemCellStyle (string)\n* errorsPreamble (HTML string)\n* showTitlesWithErrorMessages (boolean)\n* hiliteRequiredFields (boolean)\n* requiredTitlePrefix (HTML string)\n* requiredRightTitlePrefix (HTML string)\n* requiredTitleSuffix (HTML string)\n* requiredRightTitleSuffix (HTML string)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* itemHoverDelay (number)\n* itemHoverWidth (number | string)\n* itemHoverHeight (number | string)\n* itemHoverAlign (Alignment string)\n* itemHoverVAlign (number | string)\n* itemHoverStyle (CSSStyleName string)\n* itemHoverOpacity (number)\n* errors (object)\n* validateOnChange (boolean)\n* unknownErrorMessage (HTML string)\n* autoFocus (boolean)\n* autoFocusOnError (boolean)\n* selectOnFocus (boolean)\n* canFocus (boolean)\n* autoComplete (AutoComplete string)\n* browserSpellCheck (boolean)\n* validationURL (URL string)\n* action (URL string)\n* target (string)\n* method (FormMethod string)\n* encoding (Encoding string)\n* canSubmit (boolean)\n* saveOnEnter (boolean)\n* dataSource (DataSource | ID string)\n* dataArity (string)\n* titleAlign (Alignment string)\n\n## Methods\n* editNewRecord()\n* editSelectedData()\n* reset()\n* saveData()\n* viewSelectedData()\n* setValues()\n* clearValues()\n* validate()\n* itemChanged()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:FormItem":{topic:"APIs list for FormItem",content:"Only the following APIs are available on FormItem:\n\n## Attributes\n* type (FormItemType string)\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* defaultValue (Any)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* fetchMissingValues (boolean)\n* filterLocally (boolean)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* width (integer | string)\n* linearWidth (integer | string)\n* height (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* textBoxStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* saveOnEnter (boolean)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n## Methods\n* click()\n",format:"Markdown"
},"APIs list:TextItem":{topic:"APIs list for TextItem",content:"Only the following APIs are available on TextItem:\n\n## Attributes\n* width (number)\n* height (number)\n* textBoxStyle (FormItemBaseStyle string)\n* length (number)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* fetchMissingValues (boolean)\n* showHintInField (boolean)\n* saveOnEnter (boolean)\n* escapeHTML (boolean)\n\n## Inherited from FormItem\n\n### Attributes\n* type (FormItemType string)\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* defaultValue (Any)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* filterLocally (boolean)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* linearWidth (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:TextAreaItem":{topic:"APIs list for TextAreaItem",content:"Only the following APIs are available on TextAreaItem:\n\n## Attributes\n* defaultValue (string)\n* wrap (TEXTAREA_WRAP string)\n* width (number)\n* height (number)\n* pickerIconHeight (integer)\n* textBoxStyle (FormItemBaseStyle string)\n* length (number)\n* iconVAlign (VerticalAlignment string)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* showHintInField (boolean)\n* escapeHTML (boolean)\n\n## Inherited from FormItem\n\n### Attributes\n* type (FormItemType string)\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* fetchMissingValues (boolean)\n* filterLocally (boolean)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* linearWidth (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* saveOnEnter (boolean)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:SelectItem":{topic:"APIs list for SelectItem",content:"Only the following APIs are available on SelectItem:\n\n## Attributes\n* height (number)\n* addUnknownValues (boolean)\n* defaultValue (Any)\n* defaultToFirstOption (boolean)\n* multiple (boolean)\n* multipleAppearance (MultipleAppearance string)\n* textBoxStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* showFocused (boolean)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* pickerIconSrc (SCImgURL string)\n* showOver (boolean)\n* canSelectText (boolean)\n* allowEmptyValue (boolean)\n* specialValues (ValueMap object)\n* autoFetchData (boolean)\n* showHintInField (boolean)\n* saveOnEnter (boolean)\n* escapeHTML (boolean)\n* optionDataSource (DataSource | string)\n* pickListFields (array of ListGridField objects)\n* optionFilterContext (DSRequest properties object)\n* optionOperationId (string)\n* displayField (string)\n* valueField (string)\n* filterLocally (boolean)\n* pickListCriteria (Criteria object)\n* showOptionsFromDataSource (boolean)\n* pickListProperties (ListGrid properties object)\n\n## Inherited from FormItem\n\n### Attributes\n* type (FormItemType string)\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionCriteria (Criteria object)\n* fetchMissingValues (boolean)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* width (integer | string)\n* linearWidth (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:ComboBoxItem":{topic:"APIs list for ComboBoxItem",content:"Only the following APIs are available on ComboBoxItem:\n\n## Attributes\n* defaultValue (Any)\n* defaultToFirstOption (boolean)\n* showHintInField (boolean)\n* showPickerIcon (boolean)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* pickerIconSrc (SCImgURL string)\n* showPickListOnKeypress (boolean)\n* saveOnEnter (boolean)\n* completeOnTab (boolean)\n* completeOnEnter (boolean)\n* formatOnBlur (boolean)\n* specialValues (ValueMap object)\n* addUnknownValues (boolean)\n* optionDataSource (DataSource | string)\n* pickListFields (array of ListGridField objects)\n* optionFilterContext (DSRequest properties object)\n* optionOperationId (string)\n* displayField (string)\n* valueField (string)\n* filterLocally (boolean)\n* pickListCriteria (Criteria object)\n* showOptionsFromDataSource (boolean)\n* pickListProperties (ListGrid properties object)\n* autoOpenTree (string)\n* autoFetchData (boolean)\n* filterFields (array of string)\n* textMatchStyle (TextMatchStyle string)\n* showAllOptions (boolean)\n* separatorRows (array of ListGridRecord[)\n* allowExpressions (boolean)\n\n## Inherited from TextItem\n\n### Attributes\n* width (number)\n* height (number)\n* textBoxStyle (FormItemBaseStyle string)\n* length (number)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* fetchMissingValues (boolean)\n* escapeHTML (boolean)\n\n## Inherited from FormItem\n\n### Attributes\n* type (FormItemType string)\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionCriteria (Criteria object)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* linearWidth (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:CheckboxItem":{topic:"APIs list for CheckboxItem",content:"Only the following APIs are available on CheckboxItem:\n\n## Attributes\n* defaultValue (boolean)\n* titleStyle (FormItemBaseStyle string)\n* textBoxStyle (FormItemBaseStyle string)\n* width (number)\n* labelAsTitle (boolean)\n* checkedImage (SCImgURL string)\n* uncheckedImage (SCImgURL string)\n* unsetImage (SCImgURL string)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueMap (object | array)\n* allowEmptyValue (boolean)\n* showNullAsTrue (boolean)\n\n## Inherited from FormItem\n\n### Attributes\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* value (Any)\n* ID (GlobalId string)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* fetchMissingValues (boolean)\n* filterLocally (boolean)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* validators (array of Validator)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* titleOrientation (TitleOrientation string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* linearWidth (integer | string)\n* height (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* saveOnEnter (boolean)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:RadioGroupItem":{topic:"APIs list for RadioGroupItem",content:"Only the following APIs are available on RadioGroupItem:\n\n## Attributes\n* vertical (boolean)\n* textBoxStyle (FormItemBaseStyle string)\n* wrap (boolean)\n* disabledValues (array of string)\n\n## Inherited from FormItem\n\n### Attributes\n* type (FormItemType string)\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* defaultValue (Any)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* fetchMissingValues (boolean)\n* filterLocally (boolean)\n* dateFormatter (DateDisplayFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* width (integer | string)\n* linearWidth (integer | string)\n* height (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* textAlign (Alignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* wrapHintText (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* saveOnEnter (boolean)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:DateItem":{topic:"APIs list for DateItem",content:"Only the following APIs are available on DateItem:\n\n## Attributes\n* defaultValue (Date object)\n* wrapHintText (boolean)\n* showHintInField (boolean)\n* useTextField (boolean)\n* textAlign (Alignment string)\n* invalidDateStringMessage (string)\n* startDate (Date object)\n* endDate (Date object)\n* centuryThreshold (number)\n* use24HourTime (boolean)\n* showPickerTimeItem (boolean)\n* dateFormatter (DateDisplayFormat string)\n* inputFormat (DateInputFormat string)\n* selectorFormat (DateItemSelectorFormat string)\n* showChooserFiscalYearPicker (boolean)\n* showChooserWeekPicker (boolean)\n\n## Inherited from FormItem\n\n### Attributes\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* fetchMissingValues (boolean)\n* filterLocally (boolean)\n* timeFormatter (TimeDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* validators (array of Validator)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* width (integer | string)\n* linearWidth (integer | string)\n* height (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* textBoxStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* saveOnEnter (boolean)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:TimeItem":{topic:"APIs list for TimeItem",content:"Only the following APIs are available on TimeItem:\n\n## Attributes\n* wrapHintText (boolean)\n* showHintInField (boolean)\n* showHourItem (boolean)\n* hourItemTitle (HTML string)\n* hourItemPrompt (HTML string)\n* showMinuteItem (boolean)\n* minuteItemTitle (HTML string)\n* minuteItemPrompt (HTML string)\n* showSecondItem (boolean)\n* secondItemTitle (HTML string)\n* secondItemPrompt (HTML string)\n* showMillisecondItem (boolean)\n* millisecondItemTitle (HTML string)\n* millisecondItemPrompt (HTML string)\n* timeFormatter (TimeDisplayFormat string)\n* useTextField (boolean)\n* textAlign (Alignment string)\n* textBoxStyle (CSSStyleName string)\n* hourMinValue (number)\n* hourMaxValue (number)\n* hourIncrement (number)\n* minuteMinValue (number)\n* minuteMaxValue (number)\n* minuteIncrement (number)\n* secondMinValue (number)\n* secondMaxValue (number)\n* secondIncrement (number)\n* millisecondMinValue (number)\n* millisecondMaxValue (number)\n* millisecondIncrement (number)\n\n## Inherited from FormItem\n\n### Attributes\n* editorType (FormItem class name string)\n* name (FieldName string)\n* dataPath (DataPath string)\n* title (HTML string)\n* defaultValue (Any)\n* value (Any)\n* ID (GlobalId string)\n* valueMap (array | ValueMap object)\n* optionDataSource (DataSource | string)\n* optionOperationId (string)\n* valueField (string)\n* displayField (string)\n* fetchMissingValues (boolean)\n* filterLocally (boolean)\n* dateFormatter (DateDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* valueIcons (object)\n* emptyValueIcon (string)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconSize (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* showPickerIcon (boolean)\n* showFocusedPickerIcon (boolean)\n* pickerIconProperties (FormItemIcon properties object)\n* pickerIconSrc (SCImgURL string)\n* pickerIconWidth (integer)\n* pickerIconHeight (integer)\n* validators (array of Validator)\n* required (boolean)\n* requiredWhen (Criteria object)\n* visible (boolean)\n* visibleWhen (AdvancedCriteria object)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* readOnlyWhen (AdvancedCriteria object)\n* disabled (boolean)\n* disableIconsOnReadOnly (boolean)\n* accessKey (string)\n* tabIndex (integer)\n* globalTabIndex (integer)\n* selectOnFocus (boolean)\n* selectOnClick (boolean)\n* changeOnKeypress (boolean)\n* showTitle (boolean)\n* titleOrientation (TitleOrientation string)\n* titleAlign (Alignment string)\n* titleVAlign (VerticalAlignment string)\n* clipTitle (boolean)\n* wrapTitle (boolean)\n* redrawOnChange (boolean)\n* validateOnChange (boolean)\n* validateOnExit (boolean)\n* width (integer | string)\n* linearWidth (integer | string)\n* height (integer | string)\n* cellHeight (number)\n* titleColSpan (number)\n* colSpan (integer | string)\n* linearColSpan (integer | string)\n* rowSpan (number)\n* startRow (boolean)\n* endRow (boolean)\n* linearStartRow (integer | string)\n* linearEndRow (integer | string)\n* align (Alignment string)\n* vAlign (VerticalAlignment string)\n* left (integer)\n* top (integer)\n* autoComplete (AutoComplete string)\n* icons (array of FormItemIcon properties objects)\n* defaultIconSrc (SCImgURL string)\n* showOverIcons (boolean)\n* showFocusedIcons (boolean)\n* iconVAlign (VerticalAlignment string)\n* iconWidth (integer)\n* iconHeight (integer)\n* prompt (HTML string)\n* readOnlyHover (HTML string)\n* disabledHover (HTML string)\n* showIcons (boolean)\n* errorIconHeight (number)\n* errorIconWidth (number)\n* showErrorIcon (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* hint (HTML string)\n* showHint (boolean)\n* showFocused (boolean)\n* showDisabled (boolean)\n* cellStyle (FormItemBaseStyle string)\n* hintStyle (CSSStyleName string)\n* titleStyle (FormItemBaseStyle string)\n* pickerIconStyle (FormItemBaseStyle string)\n* controlStyle (FormItemBaseStyle string)\n* hoverDelay (number)\n* hoverWidth (number | string)\n* hoverHeight (number | string)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* showClippedTitleOnHover (boolean)\n* showClippedValueOnHover (boolean)\n* operator (OperatorId string)\n* formula (UserFormula object)\n* textFormula (UserSummary object)\n* saveOnEnter (boolean)\n* multiple (boolean)\n* errorMessageWidth (integer)\n* implicitSave (boolean)\n* implicitSaveOnBlur (boolean)\n* shouldSaveValue (boolean)\n* canSelectText (boolean)\n* readOnlyCanSelectText (array of ReadOnlyDisplayAppearance string)\n* allowExpressions (boolean)\n\n### Methods\n* click()\n* changed()\n",format:"Markdown"
},"APIs list:Button":{topic:"APIs list for Button",content:"Only the following APIs are available on Button:\n\n## Attributes\n* title (HTML string)\n* hiliteAccessKey (boolean)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* autoFit (boolean)\n* width (number | string)\n* height (number | string)\n* styleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* wrap (boolean)\n* overflow (Overflow string)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* showFocusedAsOver (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* print()\n",format:"Markdown"
},"APIs list:IButton":{topic:"APIs list for IButton",content:"Only the following APIs are available on IButton:\n\n## Inherited from Button\n\n### Attributes\n* title (HTML string)\n* hiliteAccessKey (boolean)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* autoFit (boolean)\n* width (number | string)\n* height (number | string)\n* styleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* wrap (boolean)\n* overflow (Overflow string)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* showFocusedAsOver (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* doubleClick()\n* print()\n",format:"Markdown"
},"APIs list:ToolStrip":{topic:"APIs list for ToolStrip",content:"Only the following APIs are available on ToolStrip:\n\n## Attributes\n* members (array of Canvas)\n* height (number)\n* styleName (CSSStyleName string)\n* vertical (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* separatorClass (string)\n* separatorSize (integer)\n\n## Inherited from Layout\n\n### Attributes\n* overflow (Overflow string)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:ToolStripButton":{topic:"APIs list for ToolStripButton",content:"Only the following APIs are available on ToolStripButton:\n\n## Inherited from Button\n\n### Attributes\n* title (HTML string)\n* hiliteAccessKey (boolean)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* autoFit (boolean)\n* width (number | string)\n* height (number | string)\n* styleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* wrap (boolean)\n* overflow (Overflow string)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* showFocusedAsOver (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* doubleClick()\n* print()\n",format:"Markdown"
},"APIs list:ToolStripSeparator":{topic:"APIs list for ToolStripSeparator",content:"Only the following APIs are available on ToolStripSeparator:\n\n## Attributes\n* skinImgDir (SCImgURL string)\n\n## Inherited from Img\n\n### Attributes\n* name (string)\n* showRollOver (boolean)\n* showFocused (boolean)\n* showFocusedAsOver (boolean)\n* showDown (boolean)\n* showDisabled (boolean)\n* src (SCImgURL string | SCStatefulImgConfig object)\n* prompt (HTML string)\n* activeAreaHTML (HTML string)\n* imageType (ImageStyle string)\n* imageHeight (integer)\n* imageWidth (integer)\n* size (number)\n* showTitle (boolean)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* selected (boolean)\n* state (State string)\n* actionType (SelectionType string)\n* radioGroup (string)\n* styleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* width (number | string)\n* height (number | string)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* showFocusedIcon (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* doubleClick()\n* print()\n",format:"Markdown"
},"APIs list:Label":{topic:"APIs list for Label",content:"Only the following APIs are available on Label:\n\n## Attributes\n* contents (HTML string)\n* dynamicContents (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* wrap (boolean)\n* autoFit (boolean)\n* width (number | string)\n* height (number | string)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* styleName (CSSStyleName string)\n\n## Inherited from Button\n\n### Attributes\n* hiliteAccessKey (boolean)\n* baseStyle (CSSStyleName string)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* overflow (Overflow string)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* showFocusedAsOver (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* print()\n",format:"Markdown"
},"APIs list:Img":{topic:"APIs list for Img",content:"Only the following APIs are available on Img:\n\n## Attributes\n* name (string)\n* showRollOver (boolean)\n* showFocused (boolean)\n* showFocusedAsOver (boolean)\n* showDown (boolean)\n* showDisabled (boolean)\n* src (SCImgURL string | SCStatefulImgConfig object)\n* prompt (HTML string)\n* activeAreaHTML (HTML string)\n* imageType (ImageStyle string)\n* imageHeight (integer)\n* imageWidth (integer)\n* size (number)\n* showTitle (boolean)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* selected (boolean)\n* state (State string)\n* actionType (SelectionType string)\n* radioGroup (string)\n* styleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* width (number | string)\n* height (number | string)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* showFocusedIcon (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* doubleClick()\n* print()\n",format:"Markdown"
},"APIs list:ImgButton":{topic:"APIs list for ImgButton",content:"Only the following APIs are available on ImgButton:\n\n## Attributes\n* hiliteAccessKey (boolean)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* width (number | string)\n* height (number | string)\n* baseStyle (CSSStyleName string)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* showTitle (boolean)\n* labelHPad (number)\n* labelVPad (number)\n* src (SCImgURL string | SCStatefulImgConfig object)\n\n## Inherited from Img\n\n### Attributes\n* name (string)\n* showFocusedAsOver (boolean)\n* prompt (HTML string)\n* activeAreaHTML (HTML string)\n* imageType (ImageStyle string)\n* imageHeight (integer)\n* imageWidth (integer)\n* size (number)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* styleName (CSSStyleName string)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* doubleClick()\n* print()\n",format:"Markdown"
},"APIs list:Menu":{topic:"APIs list for Menu",content:"Only the following APIs are available on Menu:\n\n## Attributes\n* canShowFilterEditor (boolean)\n* canSaveSearches (boolean)\n* data (array of MenuItem objects | array of Record[ | Tree | RecordList)\n* items (array of MenuItem objects)\n* dataSource (DataSource)\n* initialCriteria (Criteria object)\n* autoFetchData (boolean)\n* bodyStyleName (CSSStyleName string)\n* defaultWidth (integer)\n* cellHeight (number)\n* autoDraw (boolean)\n* baseStyle (CSSStyleName string)\n* useKeys (boolean)\n* showKeys (boolean)\n* showIcons (boolean)\n* showSubmenus (boolean)\n* emptyMessage (HTML string)\n* iconWidth (number)\n* iconHeight (number)\n* showAnimationEffect (string)\n* submenuImage (SCImgURL string | ImgHTML properties object)\n* submenuDisabledImage (SCImgURL string | ImgHTML properties object)\n* checkmarkImage (SCImgURL string | ImgHTML properties object)\n* checkmarkDisabledImage (SCImgURL string | ImgHTML properties object)\n* canSelectParentItems (boolean)\n* autoDismiss (boolean)\n* showEdges (boolean)\n* showShadow (boolean)\n\n## Methods\n* fetchData()\n\n## Inherited from ListGrid\n\n### Attributes\n* fetchRequestProperties (DSRequest properties object)\n* implicitCriteria (Criteria object)\n* styleName (CSSStyleName string)\n* dataArity (string)\n* useAllDataSourceFields (boolean)\n* saveDefaultSearch (boolean)\n* savedSearchStoredState (SavedSearchStoredState string)\n* noSavedSearchesText (HTML string)\n* savedSearchText (HTML string)\n* newSearchText (HTML string)\n* savedSearchAdminSeparator (ListGridRecord properties object)\n* savedSearchDS (string)\n* savedSearchAdminRole (string)\n* groupStartOpen (GroupStartOpen string | array)\n* groupTitleColumnProperties (ListGridField properties object)\n* canGroupBy (boolean)\n* groupByField (string | array of string)\n* overflow (Overflow string)\n* autoFitData (Autofit string)\n* autoFitMaxRecords (integer)\n* cellPadding (number)\n* showRecordComponents (boolean)\n* recordComponentPosition (EmbeddedPosition string)\n* hoverStyle (CSSStyleName string)\n* selectionType (SelectionStyle string)\n* showEmptyMessage (boolean)\n* loadingDataMessage (HTML string)\n* showFilterEditor (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* canEdit (boolean)\n* editByCell (boolean)\n* saveByCell (boolean)\n* canRemoveRecords (boolean)\n* warnOnRemoval (boolean)\n* warnOnRemovalMessage (string)\n* editEvent (ListGridEditEvent string)\n* wrapHeaderTitles (boolean)\n* canSort (boolean)\n* canEditHilites (boolean)\n* canDragRecordsOut (boolean)\n* canAcceptDroppedRecords (boolean)\n* canReorderRecords (boolean)\n* dragDataAction (DragDataAction string)\n* skinImgDir (SCImgURL string)\n* canExpandMultipleRecords (boolean)\n* detailField (string)\n* expansionMode (ExpansionMode string)\n* expansionScreen (string)\n* detailDS (string)\n* viewState (ListGridViewState string)\n* autoPersistViewState (array of ListGridViewStatePart string)\n* gridComponents (array of ListGridComponent string | array of Any)\n* autoFitHeaderHeights (boolean)\n* applyFormulaAfterSummary (boolean)\n* showHoverComponents (boolean)\n* hoverMode (HoverMode string)\n* hoverScreen (string)\n* showGridSummary (boolean)\n* hideEmptySummaryRow (boolean)\n* allowFilterExpressions (boolean)\n* updateSummariesDuringEditing (boolean)\n* allowFilterWindow (boolean)\n* showFilterWindowCriteriaIndicator (boolean)\n* searchForm (DynamicForm | ValuesManager)\n* showFilterEditorHovers (boolean)\n* initialSort (array of SortSpecifier objects)\n* recordScreen (string)\n* showGroupSummary (boolean)\n* useAdvancedFieldPicker (boolean)\n* advancedFieldPickerThreshold (integer)\n\n### Methods\n* exportData()\n* filterData()\n* fetchRelatedData()\n* removeSelectedData()\n* exportClientData()\n* recordClick()\n* recordDoubleClick()\n* startEditing()\n* startEditingNew()\n* removeRecordClick()\n* selectionUpdated()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultHeight (integer)\n* minWidth (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* hoverDelay (number)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:MenuItem":{topic:"APIs list for MenuItem",content:"Only the following APIs are available on MenuItem:\n\n## Attributes\n* title (HTML string)\n* submenu (Menu)\n* canSelectParent (boolean)\n* isSeparator (boolean)\n* enabled (boolean)\n* checked (boolean)\n* icon (string)\n* iconWidth (number)\n* iconHeight (number)\n* keys (KeyIdentifier object | array of KeyIdentifier objects)\n* keyTitle (string)\n* enableWhen (AdvancedCriteria object)\n* visibleWhen (AdvancedCriteria object)\n* embeddedComponent (Canvas)\n* embeddedComponentFields (array of string)\n\n## Methods\n* click()\n\n## Inherited from ListGridRecord\n\n### Attributes\n* singleCellValue (HTML string)\n* canDrag (boolean)\n* canAcceptDrop (boolean)\n* linkText (string)\n",format:"Markdown"
},"APIs list:MenuButton":{topic:"APIs list for MenuButton",content:"Only the following APIs are available on MenuButton:\n\n## Attributes\n* title (string)\n* height (number | string)\n* icon (SCImgURL string)\n* showMenuButtonImage (boolean)\n* menuButtonImage (SCImgURL string)\n* menuButtonImageUp (SCImgURL string)\n* hiliteAccessKey (boolean)\n* showMenuBelow (boolean)\n* menu (Menu)\n* menuAnimationEffect (string)\n* showMenuOnRollOver (boolean)\n\n## Inherited from Button\n\n### Attributes\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* autoFit (boolean)\n* width (number | string)\n* styleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* wrap (boolean)\n* overflow (Overflow string)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* showFocusedAsOver (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* print()\n",format:"Markdown"
},"APIs list:TreeGrid":{topic:"APIs list for TreeGrid",content:"Only the following APIs are available on TreeGrid:\n\n## Attributes\n* dataSource (DataSource | ID string)\n* data (Tree)\n* initialData (array of TreeNode objects)\n* loadDataOnDemand (boolean)\n* dataArity (string)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* selectionProperty (string)\n* fields (array of TreeGridField objects)\n* treeFieldTitle (string)\n* showRoot (boolean)\n* separateFolders (boolean)\n* dataProperties (Tree)\n* displayNodeType (DisplayNodeType string)\n* canDragRecordsOut (boolean)\n* canAcceptDroppedRecords (boolean)\n* canReorderRecords (boolean)\n* canDropOnLeaves (boolean)\n* canReparentNodes (boolean)\n* dragDataAction (DragDataAction string)\n* parentAlreadyContainsChildMessage (string)\n* cantDragIntoSelfMessage (string)\n* cantDragIntoChildMessage (string)\n* indentSize (number)\n* iconSize (number)\n* folderIcon (SCImgURL string)\n* dropIconSuffix (string)\n* openIconSuffix (string)\n* closedIconSuffix (string)\n* nodeIcon (SCImgURL string)\n* showOpenIcons (boolean)\n* showDropIcons (boolean)\n* customIconProperty (string)\n* customIconOpenProperty (string)\n* customIconDropProperty (string)\n* showCustomIconOpen (boolean)\n* showCustomIconDrop (boolean)\n* manyItemsImage (SCImgURL string)\n* showConnectors (boolean)\n* openerImage (SCImgURL string | SCStatefulImgConfig object)\n* connectorImage (SCImgURL string | SCStatefulImgConfig object)\n* useAllDataSourceFields (boolean)\n* autoOpenTree (string)\n* animateFolders (boolean)\n* animateFolderTime (number)\n* animateFolderSpeed (number)\n* animateFolderEffect (AnimationAcceleration string)\n\n## Methods\n* fetchData()\n* filterData()\n* exportClientData()\n* startEditingNew()\n* recordDoubleClick()\n* folderClick()\n* leafClick()\n* nodeClick()\n\n## Inherited from ListGrid\n\n### Attributes\n* autoFetchData (boolean)\n* fetchRequestProperties (DSRequest properties object)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* styleName (CSSStyleName string)\n* autoFetchDisplayMap (boolean)\n* saveLocally (boolean)\n* showDetailFields (boolean)\n* titleField (string)\n* saveDefaultSearch (boolean)\n* canSaveSearches (boolean)\n* savedSearchStoredState (SavedSearchStoredState string)\n* noSavedSearchesText (HTML string)\n* savedSearchText (HTML string)\n* newSearchText (HTML string)\n* savedSearchAdminSeparator (ListGridRecord properties object)\n* savedSearchDS (string)\n* savedSearchAdminRole (string)\n* groupStartOpen (GroupStartOpen string | array)\n* groupTitleColumnProperties (ListGridField properties object)\n* groupIconSize (number)\n* groupIndentSize (number)\n* groupByMaxRecords (integer)\n* valueIconSize (number)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* hiliteIcons (array of string)\n* hiliteIconPosition (HiliteIconPosition string)\n* hiliteIconSize (number)\n* hiliteIconWidth (number)\n* hiliteIconHeight (number)\n* hiliteIconLeftPadding (number)\n* hiliteIconRightPadding (number)\n* imageSize (number)\n* headerSpans (array of HeaderSpan objects)\n* headerSpanHeight (integer)\n* showTreeColumnPicker (boolean)\n* modalEditing (boolean)\n* fetchDelay (number)\n* overflow (Overflow string)\n* minHeight (number)\n* showAllRecords (boolean)\n* drawAheadRatio (number)\n* scrollRedrawDelay (integer)\n* dataPageSize (integer)\n* bodyOverflow (Overflow string)\n* bodyBackgroundColor (string)\n* bodyStyleName (CSSStyleName string)\n* emptyCellValue (HTML string)\n* cellHeight (number)\n* fixedRecordHeights (boolean)\n* fixedFieldWidths (boolean)\n* autoFitData (Autofit string)\n* autoFitMaxHeight (integer)\n* autoFitMaxRecords (integer)\n* autoFitMaxWidth (integer | string)\n* autoFitMaxColumns (integer)\n* autoFitFieldWidths (boolean)\n* autoFitWidthApproach (AutoFitWidthApproach string)\n* leaveScrollbarGap (boolean)\n* wrapCells (boolean)\n* cellPadding (number)\n* dateFormatter (DateDisplayFormat string)\n* dateInputFormat (DateInputFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* fastCellUpdates (boolean)\n* baseStyle (CSSStyleName string)\n* editFailedBaseStyle (CSSStyleName string)\n* editFailedCSSText (string)\n* editPendingCSSText (string)\n* recordCustomStyleProperty (string)\n* recordBaseStyleProperty (string)\n* shrinkForFreeze (boolean)\n* alternateRecordStyles (boolean)\n* alternateRecordFrequency (number)\n* generateClickOnSpace (boolean)\n* generateClickOnEnter (boolean)\n* generateDoubleClickOnSpace (boolean)\n* generateDoubleClickOnEnter (boolean)\n* arrowKeyAction (string)\n* showRecordComponents (boolean)\n* recordComponentPosition (EmbeddedPosition string)\n* showRollOver (boolean)\n* canHover (boolean)\n* showHover (boolean)\n* hoverStyle (CSSStyleName string)\n* selectionAppearance (SelectionAppearance string)\n* selectionType (SelectionStyle string)\n* canDragSelect (boolean)\n* checkboxFieldImageWidth (integer)\n* checkboxFieldImageHeight (integer)\n* showEmptyMessage (boolean)\n* emptyMessage (HTML string)\n* emptyMessageStyle (CSSStyleName string)\n* loadingDataMessage (HTML string)\n* loadingDataMessageStyle (CSSStyleName string)\n* loadingMessage (string)\n* singleCellValueProperty (string)\n* isSeparatorProperty (string)\n* showFilterEditor (boolean)\n* canShowFilterEditor (boolean)\n* filterEditorHeight (number)\n* canEdit (boolean)\n* recordEditProperty (string)\n* editByCell (boolean)\n* saveByCell (boolean)\n* validateByCell (boolean)\n* validateOnChange (boolean)\n* neverValidate (boolean)\n* canRemoveRecords (boolean)\n* warnOnRemoval (boolean)\n* warnOnRemovalMessage (string)\n* animateRemoveRecord (boolean)\n* animateRemoveTime (number)\n* animateRemoveSpeed (number)\n* filterByCell (boolean)\n* filterOnKeypress (boolean)\n* waitForSave (boolean)\n* stopOnErrors (boolean)\n* autoSaveEdits (boolean)\n* confirmCancelEditing (boolean)\n* cancelEditingConfirmationMessage (string)\n* confirmDiscardEdits (boolean)\n* confirmDiscardEditsMessage (string)\n* discardEditsSaveButtonTitle (string)\n* rowEndEditAction (RowEndEditAction string)\n* listEndEditAction (RowEndEditAction string)\n* enterKeyEditAction (EnterKeyEditAction string)\n* escapeKeyEditAction (EscapeKeyEditAction string)\n* editEvent (ListGridEditEvent string)\n* editOnFocus (boolean)\n* selectOnEdit (boolean)\n* longTextEditorThreshold (integer)\n* longTextEditorType (string)\n* headerHeight (number)\n* minFieldWidth (integer)\n* showHeader (boolean)\n* headerBarStyle (CSSStyleName string)\n* headerBackgroundColor (CSSColor string)\n* headerButtonConstructor (Class name string)\n* headerBaseStyle (CSSStyleName string)\n* headerTitleStyle (CSSStyleName string)\n* headerButtonDefaults (Button properties object)\n* headerButtonProperties (Button properties object)\n* wrapHeaderTitles (boolean)\n* sorterConstructor (Class name string)\n* sorterDefaults (object)\n* sorterProperties (Button properties object)\n* canSort (boolean)\n* sortField (string | integer)\n* sortDirection (SortDirection string)\n* showSortArrow (SortArrow string)\n* canPickFields (boolean)\n* canFreezeFields (boolean)\n* canAddFormulaFields (boolean)\n* canAddSummaryFields (boolean)\n* canEditHilites (boolean)\n* hilites (array of Hilite objects)\n* showHeaderContextMenu (boolean)\n* showHeaderMenuButton (boolean)\n* headerMenuButtonIconWidth (number)\n* headerMenuButtonIconHeight (number)\n* headerMenuButtonWidth (number)\n* headerMenuButtonHeight (number | string)\n* canReorderFields (boolean)\n* canResizeFields (boolean)\n* dragTrackerMode (DragTrackerMode string)\n* resizeFieldsInRealTime (boolean)\n* skinImgDir (SCImgURL string)\n* sortAscendingImage (SCImgURL string | ImgHTML properties object)\n* sortDescendingImage (SCImgURL string | ImgHTML properties object)\n* trackerImage (SCImgURL string | ImgHTML properties object)\n* booleanTrueImage (SCImgURL string)\n* booleanFalseImage (SCImgURL string)\n* booleanImageWidth (number)\n* booleanImageHeight (number)\n* canExpandRecords (boolean)\n* canExpandMultipleRecords (boolean)\n* detailField (string)\n* expansionMode (ExpansionMode string)\n* expansionScreen (string)\n* detailDS (string)\n* viewState (ListGridViewState string)\n* autoPersistViewState (array of ListGridViewStatePart string)\n* gridComponents (array of ListGridComponent string | array of Any)\n* autoFitHeaderHeights (boolean)\n* applyFormulaAfterSummary (boolean)\n* printHeaderStyle (CSSStyleName string)\n* showHoverComponents (boolean)\n* hoverMode (HoverMode string)\n* hoverScreen (string)\n* showGridSummary (boolean)\n* hideEmptySummaryRow (boolean)\n* allowFilterExpressions (boolean)\n* updateSummariesDuringEditing (boolean)\n* freezeFieldText (HTML string)\n* unfreezeFieldText (HTML string)\n* groupByText (HTML string)\n* allowFilterWindow (boolean)\n* showFilterWindowCriteriaIndicator (boolean)\n* searchForm (DynamicForm | ValuesManager)\n* showFilterEditorHovers (boolean)\n* initialSort (array of SortSpecifier objects)\n* showSortNumerals (boolean)\n* recordScreen (string)\n* showGroupSummary (boolean)\n* useAdvancedFieldPicker (boolean)\n* advancedFieldPickerThreshold (integer)\n\n### Methods\n* exportData()\n* fetchRelatedData()\n* removeSelectedData()\n* recordClick()\n* startEditing()\n* removeRecordClick()\n* selectionUpdated()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* hoverDelay (number)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Tree":{topic:"APIs list for Tree",content:"Only the following APIs are available on Tree:\n\n## Attributes\n* modelType (TreeModelType string)\n* isFolderProperty (string)\n* defaultIsFolder (boolean)\n* reportCollisions (boolean)\n* pathDelim (string)\n* nameProperty (string)\n* titleProperty (string)\n* idField (string)\n* parentIdField (string)\n* childrenProperty (string)\n* openProperty (string)\n* data (array of TreeNode objects)\n* rootValue (string | number)\n* root (TreeNode object)\n* discardParentlessNodes (boolean)\n* showRoot (boolean)\n* autoOpenRoot (boolean)\n* separateFolders (boolean)\n* defaultNodeTitle (string)\n",format:"Markdown"
},"APIs list:TreeNode":{topic:"APIs list for TreeNode",content:"Only the following APIs are available on TreeNode:\n\n## Attributes\n* enabled (boolean)\n* canDrag (boolean)\n* canAcceptDrop (boolean)\n* isFolder (boolean | string)\n* name (string)\n* title (HTML string)\n* id (string | number)\n* parentId (string | number)\n* children (array of TreeNode objects)\n",format:"Markdown"
},"APIs list:ListGrid":{topic:"APIs list for ListGrid",content:"Only the following APIs are available on ListGrid:\n\n## Attributes\n* autoFetchData (boolean)\n* fetchRequestProperties (DSRequest properties object)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* styleName (CSSStyleName string)\n* data (array of ListGridRecord objects)\n* fields (array of ListGridField objects)\n* dataSource (DataSource | ID string)\n* dataArity (string)\n* autoFetchDisplayMap (boolean)\n* saveLocally (boolean)\n* useAllDataSourceFields (boolean)\n* showDetailFields (boolean)\n* titleField (string)\n* dataProperties (ResultSet)\n* saveDefaultSearch (boolean)\n* canSaveSearches (boolean)\n* savedSearchStoredState (SavedSearchStoredState string)\n* noSavedSearchesText (HTML string)\n* savedSearchText (HTML string)\n* newSearchText (HTML string)\n* savedSearchAdminSeparator (ListGridRecord properties object)\n* savedSearchDS (string)\n* savedSearchAdminRole (string)\n* groupStartOpen (GroupStartOpen string | array)\n* groupTitleColumnProperties (ListGridField properties object)\n* groupIconSize (number)\n* groupIndentSize (number)\n* canGroupBy (boolean)\n* groupByMaxRecords (integer)\n* groupByField (string | array of string)\n* valueIconSize (number)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* hiliteIcons (array of string)\n* hiliteIconPosition (HiliteIconPosition string)\n* hiliteIconSize (number)\n* hiliteIconWidth (number)\n* hiliteIconHeight (number)\n* hiliteIconLeftPadding (number)\n* hiliteIconRightPadding (number)\n* imageSize (number)\n* headerSpans (array of HeaderSpan objects)\n* headerSpanHeight (integer)\n* showTreeColumnPicker (boolean)\n* modalEditing (boolean)\n* fetchDelay (number)\n* overflow (Overflow string)\n* minHeight (number)\n* showAllRecords (boolean)\n* drawAheadRatio (number)\n* scrollRedrawDelay (integer)\n* dataPageSize (integer)\n* bodyOverflow (Overflow string)\n* bodyBackgroundColor (string)\n* bodyStyleName (CSSStyleName string)\n* emptyCellValue (HTML string)\n* cellHeight (number)\n* fixedRecordHeights (boolean)\n* fixedFieldWidths (boolean)\n* autoFitData (Autofit string)\n* autoFitMaxHeight (integer)\n* autoFitMaxRecords (integer)\n* autoFitMaxWidth (integer | string)\n* autoFitMaxColumns (integer)\n* autoFitFieldWidths (boolean)\n* autoFitWidthApproach (AutoFitWidthApproach string)\n* leaveScrollbarGap (boolean)\n* wrapCells (boolean)\n* cellPadding (number)\n* dateFormatter (DateDisplayFormat string)\n* dateInputFormat (DateInputFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* fastCellUpdates (boolean)\n* baseStyle (CSSStyleName string)\n* editFailedBaseStyle (CSSStyleName string)\n* editFailedCSSText (string)\n* editPendingCSSText (string)\n* recordCustomStyleProperty (string)\n* recordBaseStyleProperty (string)\n* shrinkForFreeze (boolean)\n* alternateRecordStyles (boolean)\n* alternateRecordFrequency (number)\n* generateClickOnSpace (boolean)\n* generateClickOnEnter (boolean)\n* generateDoubleClickOnSpace (boolean)\n* generateDoubleClickOnEnter (boolean)\n* arrowKeyAction (string)\n* showRecordComponents (boolean)\n* recordComponentPosition (EmbeddedPosition string)\n* showRollOver (boolean)\n* canHover (boolean)\n* showHover (boolean)\n* hoverStyle (CSSStyleName string)\n* selectionAppearance (SelectionAppearance string)\n* selectionType (SelectionStyle string)\n* selectionProperty (string)\n* canDragSelect (boolean)\n* checkboxFieldImageWidth (integer)\n* checkboxFieldImageHeight (integer)\n* showEmptyMessage (boolean)\n* emptyMessage (HTML string)\n* emptyMessageStyle (CSSStyleName string)\n* loadingDataMessage (HTML string)\n* loadingDataMessageStyle (CSSStyleName string)\n* loadingMessage (string)\n* singleCellValueProperty (string)\n* isSeparatorProperty (string)\n* showFilterEditor (boolean)\n* canShowFilterEditor (boolean)\n* filterEditorHeight (number)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* canEdit (boolean)\n* recordEditProperty (string)\n* editByCell (boolean)\n* saveByCell (boolean)\n* validateByCell (boolean)\n* validateOnChange (boolean)\n* neverValidate (boolean)\n* canRemoveRecords (boolean)\n* warnOnRemoval (boolean)\n* warnOnRemovalMessage (string)\n* animateRemoveRecord (boolean)\n* animateRemoveTime (number)\n* animateRemoveSpeed (number)\n* filterByCell (boolean)\n* filterOnKeypress (boolean)\n* waitForSave (boolean)\n* stopOnErrors (boolean)\n* autoSaveEdits (boolean)\n* confirmCancelEditing (boolean)\n* cancelEditingConfirmationMessage (string)\n* confirmDiscardEdits (boolean)\n* confirmDiscardEditsMessage (string)\n* discardEditsSaveButtonTitle (string)\n* rowEndEditAction (RowEndEditAction string)\n* listEndEditAction (RowEndEditAction string)\n* enterKeyEditAction (EnterKeyEditAction string)\n* escapeKeyEditAction (EscapeKeyEditAction string)\n* editEvent (ListGridEditEvent string)\n* editOnFocus (boolean)\n* selectOnEdit (boolean)\n* longTextEditorThreshold (integer)\n* longTextEditorType (string)\n* headerHeight (number)\n* minFieldWidth (integer)\n* showHeader (boolean)\n* headerBarStyle (CSSStyleName string)\n* headerBackgroundColor (CSSColor string)\n* headerButtonConstructor (Class name string)\n* headerBaseStyle (CSSStyleName string)\n* headerTitleStyle (CSSStyleName string)\n* headerButtonDefaults (Button properties object)\n* headerButtonProperties (Button properties object)\n* wrapHeaderTitles (boolean)\n* sorterConstructor (Class name string)\n* sorterDefaults (object)\n* sorterProperties (Button properties object)\n* canSort (boolean)\n* sortField (string | integer)\n* sortDirection (SortDirection string)\n* showSortArrow (SortArrow string)\n* canPickFields (boolean)\n* canFreezeFields (boolean)\n* canAddFormulaFields (boolean)\n* canAddSummaryFields (boolean)\n* canEditHilites (boolean)\n* hilites (array of Hilite objects)\n* showHeaderContextMenu (boolean)\n* showHeaderMenuButton (boolean)\n* headerMenuButtonIconWidth (number)\n* headerMenuButtonIconHeight (number)\n* headerMenuButtonWidth (number)\n* headerMenuButtonHeight (number | string)\n* canDragRecordsOut (boolean)\n* canAcceptDroppedRecords (boolean)\n* canReorderRecords (boolean)\n* canReorderFields (boolean)\n* canResizeFields (boolean)\n* dragTrackerMode (DragTrackerMode string)\n* resizeFieldsInRealTime (boolean)\n* dragDataAction (DragDataAction string)\n* skinImgDir (SCImgURL string)\n* sortAscendingImage (SCImgURL string | ImgHTML properties object)\n* sortDescendingImage (SCImgURL string | ImgHTML properties object)\n* trackerImage (SCImgURL string | ImgHTML properties object)\n* booleanTrueImage (SCImgURL string)\n* booleanFalseImage (SCImgURL string)\n* booleanImageWidth (number)\n* booleanImageHeight (number)\n* canExpandRecords (boolean)\n* canExpandMultipleRecords (boolean)\n* detailField (string)\n* expansionMode (ExpansionMode string)\n* expansionScreen (string)\n* detailDS (string)\n* viewState (ListGridViewState string)\n* autoPersistViewState (array of ListGridViewStatePart string)\n* gridComponents (array of ListGridComponent string | array of Any)\n* autoFitHeaderHeights (boolean)\n* applyFormulaAfterSummary (boolean)\n* printHeaderStyle (CSSStyleName string)\n* showHoverComponents (boolean)\n* hoverMode (HoverMode string)\n* hoverScreen (string)\n* showGridSummary (boolean)\n* hideEmptySummaryRow (boolean)\n* allowFilterExpressions (boolean)\n* updateSummariesDuringEditing (boolean)\n* freezeFieldText (HTML string)\n* unfreezeFieldText (HTML string)\n* groupByText (HTML string)\n* allowFilterWindow (boolean)\n* showFilterWindowCriteriaIndicator (boolean)\n* searchForm (DynamicForm | ValuesManager)\n* showFilterEditorHovers (boolean)\n* initialSort (array of SortSpecifier objects)\n* showSortNumerals (boolean)\n* recordScreen (string)\n* showGroupSummary (boolean)\n* useAdvancedFieldPicker (boolean)\n* advancedFieldPickerThreshold (integer)\n\n## Methods\n* fetchData()\n* exportData()\n* filterData()\n* fetchRelatedData()\n* removeSelectedData()\n* exportClientData()\n* recordClick()\n* recordDoubleClick()\n* startEditing()\n* startEditingNew()\n* removeRecordClick()\n* selectionUpdated()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* hoverDelay (number)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:ListGridField":{topic:"APIs list for ListGridField",content:"Only the following APIs are available on ListGridField:\n\n## Attributes\n* groupingModes (ValueMap object)\n* groupPrecision (integer)\n* groupGranularity (integer)\n* canGroupBy (boolean)\n* canSortClientOnly (boolean)\n* canExport (boolean)\n* summaryValue (HTML string)\n* valueIcons (object)\n* valueIconSize (number)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* editorValueIcons (object)\n* editorValueIconWidth (number)\n* editorValueIconHeight (number)\n* showValueIconOnly (boolean)\n* suppressValueIcon (boolean)\n* valueIconOrientation (string)\n* hiliteIconPosition (HiliteIconPosition string)\n* hiliteIconSize (number)\n* hiliteIconWidth (number)\n* hiliteIconHeight (number)\n* hiliteIconLeftPadding (number)\n* hiliteIconRightPadding (number)\n* imageURLPrefix (string)\n* imageURLSuffix (string)\n* editorImageURLPrefix (string)\n* editorImageURLSuffix (string)\n* imageSize (number)\n* imageWidth (number)\n* imageHeight (number)\n* type (ListGridFieldType string)\n* name (FieldName string)\n* title (HTML string)\n* showTitle (boolean)\n* wrap (boolean)\n* cellPrompt (HTML string)\n* hidden (boolean)\n* visibleWhen (Criteria object)\n* enableWhen (Criteria object)\n* frozen (boolean)\n* showGridSummary (boolean)\n* showGroupSummary (boolean)\n* summaryFunction (SummaryFunction string | array of SummaryFunction string)\n* applyAfterSummary (boolean)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* cellIcon (SCImgURL string)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* icons (array of FormItemIcon properties objects)\n* editorIconWidth (number)\n* editorIconHeight (number)\n* defaultIconSrc (string)\n* iconVAlign (string)\n* width (number | string)\n* minWidth (number)\n* maxWidth (number)\n* align (Alignment string)\n* headerBaseStyle (CSSStyleName string)\n* headerTitleStyle (CSSStyleName string)\n* cellAlign (Alignment string)\n* baseStyle (CSSStyleName string)\n* canSort (boolean)\n* sortDirection (SortDirection string)\n* canEdit (boolean)\n* defaultValue (Any)\n* enterKeyEditAction (EnterKeyEditAction string)\n* escapeKeyEditAction (EscapeKeyEditAction string)\n* editorType (FormItemClassName string)\n* editorProperties (FormItem properties object)\n* initialValue (Any)\n* validateOnChange (boolean)\n* required (boolean)\n* decimalPrecision (number)\n* inputFormat (DateInputFormat string)\n* canFilter (boolean)\n* filterEditorValueMap (object)\n* filterEditorType (FormItemClassName string)\n* defaultFilterValue (Any)\n* filterEditorProperties (FormItem properties object)\n* filterOnKeypress (boolean)\n* escapeHTML (boolean)\n* linkText (string)\n* valueMap (object | array of string)\n* sortByMappedValue (boolean)\n* multiple (boolean)\n* editorValueMap (ValueMap object)\n* emptyCellValue (HTML string)\n* autoFetchDisplayMap (boolean)\n* optionDataSource (string)\n* valueField (string)\n* displayField (FieldName string)\n* sortByDisplayField (boolean)\n* optionCriteria (Criteria object)\n* includeFrom (string)\n* canAutoFitWidth (boolean)\n* autoFit (AutoFitWidthApproach string)\n* autoFitWidth (boolean)\n* autoFitWidthApproach (AutoFitWidthApproach string)\n* showHover (boolean)\n* showHoverComponents (boolean)\n* canToggle (boolean)\n* hideOnPhone (boolean)\n* hideOnTablet (boolean)\n* userFormula (UserFormula object)\n* canEditFormula (boolean)\n* editorFormula (UserFormula object)\n* editorTextFormula (UserSummary object)\n* userSummary (UserSummary object)\n* canEditSummary (boolean)\n\n## Methods\n* valueIconClick()\n* editorEnter()\n* editorExit()\n* recordClick()\n* recordDoubleClick()\n* changed()\n\n## Inherited from Field\n\n### Attributes\n* primaryKey (boolean)\n* exportTitle (HTML string)\n* sortByField (FieldName string)\n",format:"Markdown"
},"APIs list:DetailViewer":{topic:"APIs list for DetailViewer",content:"Only the following APIs are available on DetailViewer:\n\n## Attributes\n* fetchRequestProperties (DSRequest properties object)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* autoFetchData (boolean)\n* data (array of DetailViewerRecord objects | array of Record objects | RecordList)\n* dataArity (string)\n* dataSource (DataSource | ID string)\n* fields (array of DetailViewerField objects)\n* hiliteIcons (array of string)\n* hiliteIconPosition (HiliteIconPosition string)\n* hiliteIconSize (number)\n* hiliteIconWidth (number)\n* hiliteIconHeight (number)\n* hiliteIconLeftPadding (number)\n* hiliteIconRightPadding (number)\n* recordsPerBlock (number)\n* blockSeparator (HTML string)\n* showEmptyField (boolean)\n* emptyCellValue (HTML string)\n* labelPrefix (HTML string)\n* labelSuffix (HTML string)\n* wrapLabel (boolean)\n* wrapValues (boolean)\n* styleName (CSSStyleName string)\n* labelStyle (CSSStyleName string)\n* cellStyle (CSSStyleName string)\n* headerStyle (CSSStyleName string)\n* separatorStyle (CSSStyleName string)\n* dateFormatter (DateDisplayFormat string)\n* showEmptyMessage (boolean)\n* emptyMessage (HTML string)\n* emptyMessageStyle (CSSStyleName string)\n* loadingMessage (HTML string)\n* loadingMessageStyle (CSSStyleName string)\n\n## Methods\n* viewSelectedData()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:DetailViewerField":{topic:"APIs list for DetailViewerField",content:"Only the following APIs are available on DetailViewerField:\n\n## Attributes\n* name (FieldName string)\n* dateFormatter (DateDisplayFormat string)\n* decimalPrecision (number)\n* decimalPad (number)\n* imageSize (integer | string)\n* imageWidth (integer | string)\n* imageHeight (integer | string)\n* linkText (string)\n* linkTextProperty (string)\n* target (string)\n* format (FormatString string)\n* canHilite (boolean)\n* hiliteIconPosition (HiliteIconPosition string)\n* hiliteIconSize (number)\n* hiliteIconWidth (number)\n* hiliteIconHeight (number)\n* hiliteIconLeftPadding (number)\n* hiliteIconRightPadding (number)\n* type (string)\n* title (HTML string)\n* valueMap (object)\n* value (HTML string)\n* height (number)\n* cellStyle (CSSStyleName string)\n* printCellStyle (CSSStyleName string)\n",format:"Markdown"
},"APIs list:TileGrid":{topic:"APIs list for TileGrid",content:"Only the following APIs are available on TileGrid:\n\n## Attributes\n* fields (array of DetailViewerField objects)\n* tiles (array of Canvas)\n* showDetailFields (boolean)\n* data (array of TileRecord objects | array of Record objects | RecordList)\n* dataSource (DataSource | ID string)\n* dataArity (string)\n* autoFetchData (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* fetchRequestProperties (DSRequest properties object)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* selectionType (SelectionStyle string)\n* detailViewerProperties (DetailViewer properties object)\n* showAllRecords (boolean)\n* loadingDataMessage (HTML string)\n* loadingDataMessageStyle (CSSStyleName string)\n* animateTileChange (boolean)\n* styleName (CSSStyleName string)\n* tileScreen (string)\n* canReorderTiles (boolean)\n* canDragTilesOut (boolean)\n* canAcceptDroppedRecords (boolean)\n* dragTrackerStyle (CSSStyleName string)\n* dragDataAction (DragDataAction string)\n* showEmptyMessage (boolean)\n* emptyMessage (HTML string)\n* emptyMessageStyle (CSSStyleName string)\n\n## Methods\n* fetchData()\n* viewSelectedData()\n* recordClick()\n\n## Inherited from TileLayout\n\n### Attributes\n* layoutPolicy (TileLayoutPolicy string)\n* tileSize (integer)\n* tileWidth (integer)\n* tileHeight (integer)\n* tileMargin (integer)\n* tileHMargin (integer)\n* tileVMargin (integer)\n* layoutMargin (integer)\n* paddingAsLayoutMargin (boolean)\n* orientation (Orientation string)\n* tilesPerLine (integer)\n* overflow (Overflow string)\n* expandMargins (boolean)\n* autoWrapLines (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:TileLayout":{topic:"APIs list for TileLayout",content:"Only the following APIs are available on TileLayout:\n\n## Attributes\n* tiles (array of Canvas)\n* layoutPolicy (TileLayoutPolicy string)\n* tileSize (integer)\n* tileWidth (integer)\n* tileHeight (integer)\n* tileMargin (integer)\n* tileHMargin (integer)\n* tileVMargin (integer)\n* layoutMargin (integer)\n* paddingAsLayoutMargin (boolean)\n* animateTileChange (boolean)\n* orientation (Orientation string)\n* tilesPerLine (integer)\n* overflow (Overflow string)\n* expandMargins (boolean)\n* autoWrapLines (boolean)\n* dragDataAction (DragDataAction string)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:TabSet":{topic:"APIs list for TabSet",content:"Only the following APIs are available on TabSet:\n\n## Attributes\n* tabs (array of Tab objects)\n* tabProperties (Tab properties object)\n* useSimpleTabs (boolean)\n* simpleTabBaseStyle (CSSStyleName string)\n* tabBarPosition (Side string)\n* tabBarAlign (Side string | Alignment string)\n* tabBarThickness (number)\n* selectedTab (Tab object | integer)\n* canCloseTabs (boolean)\n* closeTabIcon (SCImgURL string)\n* closeTabIconSize (integer)\n* canReorderTabs (boolean)\n* tabBarControls (array)\n* showTabScroller (boolean)\n* showTabPicker (boolean)\n* animateTabScrolling (boolean)\n* scrollerButtonSize (number)\n* pickerButtonSize (integer)\n* skinImgDir (SCImgURL string)\n* scrollerHSrc (SCImgURL string)\n* scrollerVSrc (SCImgURL string)\n* pickerButtonHSrc (SCImgURL string)\n* pickerButtonVSrc (SCImgURL string)\n* paneContainerClassName (CSSStyleName string)\n* paneContainerOverflow (Overflow string)\n* symmetricEdges (boolean)\n* leftEdgeSizes (EdgeSizes object)\n* topEdgeSizes (EdgeSizes object)\n* bottomEdgeSizes (EdgeSizes object)\n* rightEdgeSizes (EdgeSizes object)\n* leftEdgeOffsets (EdgeSizes object)\n* rightEdgeOffsets (EdgeSizes object)\n* topEdgeOffsets (EdgeSizes object)\n* bottomEdgeOffsets (EdgeSizes object)\n* showPaneContainerEdges (boolean)\n* tabBarProperties (TabBar properties object)\n* showPartialEdges (boolean)\n* destroyPanes (boolean)\n\n## Methods\n* tabSelected()\n* tabDeselected()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Tab":{topic:"APIs list for Tab",content:"Only the following APIs are available on Tab:\n\n## Attributes\n* title (HTML string)\n* pickerTitle (HTML string)\n* pane (Canvas | ID string | Shortcut properties object)\n* ID (GlobalId string)\n* width (number)\n* disabled (boolean)\n* hidden (boolean)\n* visibleWhen (Criteria object)\n* enableWhen (Criteria object)\n* icon (SCImgURL string)\n* canClose (boolean)\n* closeIcon (SCImgURL string)\n\n## Methods\n* tabSelected()\n* tabDeselected()\n",format:"Markdown"
},"APIs list:HTMLFlow":{topic:"APIs list for HTMLFlow",content:"Only the following APIs are available on HTMLFlow:\n\n## Attributes\n* defaultWidth (integer)\n* defaultHeight (integer)\n* overflow (Overflow string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* contentsURL (URL string)\n* loadingMessage (HTML string)\n* contentsURLParams (object)\n* httpMethod (SendMethod string)\n* contentsType (ContentsType string)\n* allowCaching (boolean)\n* evalScriptBlocks (boolean)\n* captureSCComponents (boolean)\n* canSelectText (boolean)\n\n## Methods\n* setContentsURL()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* styleName (CSSStyleName string)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:HTMLPane":{topic:"APIs list for HTMLPane",content:"Only the following APIs are available on HTMLPane:\n\n## Attributes\n* contents (HTML string)\n* contentsURL (URL string)\n* contentsURLParams (object)\n* contentsType (ContentsType string)\n* overflow (Overflow string)\n* defaultHeight (integer)\n\n## Inherited from HTMLFlow\n\n### Attributes\n* defaultWidth (integer)\n* dynamicContents (boolean)\n* loadingMessage (HTML string)\n* httpMethod (SendMethod string)\n* allowCaching (boolean)\n* evalScriptBlocks (boolean)\n* captureSCComponents (boolean)\n* canSelectText (boolean)\n\n### Methods\n* setContentsURL()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* styleName (CSSStyleName string)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:RichTextEditor":{topic:"APIs list for RichTextEditor",content:"Only the following APIs are available on RichTextEditor:\n\n## Attributes\n* value (string)\n* controlGroups (array)\n* styleControls (array of ControlName string)\n* fontControls (array of ControlName string)\n* fontNames (object)\n* fontSizes (object)\n* formatControls (array of ControlName string)\n* colorControls (array of ControlName string)\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Slider":{topic:"APIs list for Slider",content:"Only the following APIs are available on Slider:\n\n## Attributes\n* title (string)\n* length (integer)\n* vertical (boolean)\n* thumbThickWidth (integer)\n* thumbThinWidth (integer)\n* trackWidth (integer)\n* thumbSrc (string)\n* trackSrc (string)\n* trackCapSize (integer)\n* trackImageType (ImageStyle string)\n* showTitle (boolean)\n* showRange (boolean)\n* showValue (boolean)\n* labelWidth (integer)\n* labelHeight (integer)\n* labelSpacing (integer)\n* vLabelSpacing (integer)\n* hLabelSpacing (integer)\n* titleSpacing (integer)\n* value (number)\n* minValue (number)\n* minValueLabel (string)\n* maxValue (number)\n* maxValueLabel (string)\n* numValues (integer)\n* roundValues (boolean)\n* roundPrecision (integer)\n* flipValues (boolean)\n* sliderTarget (Canvas)\n* canFocus (boolean)\n* stepPercent (number)\n* animateThumb (boolean)\n* animateThumbTime (integer)\n* animateThumbInit (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Progressbar":{topic:"APIs list for Progressbar",content:"Only the following APIs are available on Progressbar:\n\n## Attributes\n* percentDone (number)\n* length (number | string)\n* breadth (number)\n* vertical (boolean)\n* src (SCImgURL string)\n* baseStyle (CSSStyleName string)\n\n## Inherited from StretchImg\n\n### Attributes\n* capSize (number)\n* hSrc (SCImgURL string)\n* vSrc (SCImgURL string)\n* imageType (ImageStyle string)\n* items (array of StretchItem objects)\n* showTitle (boolean)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* title (HTML string)\n* selected (boolean)\n* state (State string)\n* showRollOver (boolean)\n* showFocused (boolean)\n* showFocusedAsOver (boolean)\n* showDown (boolean)\n* showDisabled (boolean)\n* actionType (SelectionType string)\n* radioGroup (string)\n* styleName (CSSStyleName string)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* autoFit (boolean)\n* width (number | string)\n* height (number | string)\n* icon (SCImgURL string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* showFocusedIcon (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* doubleClick()\n* print()\n",format:"Markdown"
},"APIs list:SectionHeader":{topic:"APIs list for SectionHeader",content:"Only the following APIs are available on SectionHeader:\n\n## Attributes\n* showClippedTitleOnHover (boolean)\n* icon (SCImgURL string)\n* baseStyle (CSSStyleName string)\n* noDoubleClicks (boolean)\n\n## Inherited from Label\n\n### Attributes\n* contents (HTML string)\n* dynamicContents (boolean)\n* align (Alignment string)\n* valign (VerticalAlignment string)\n* wrap (boolean)\n* autoFit (boolean)\n* width (number | string)\n* height (number | string)\n* iconSize (integer)\n* iconWidth (integer)\n* iconHeight (integer)\n* iconOrientation (string)\n* iconAlign (string)\n* iconSpacing (integer)\n* showDisabledIcon (boolean)\n* showRollOverIcon (boolean)\n* showFocusedIcon (boolean)\n* showDownIcon (boolean)\n* showSelectedIcon (boolean)\n* styleName (CSSStyleName string)\n\n## Inherited from Button\n\n### Attributes\n* hiliteAccessKey (boolean)\n* selected (boolean)\n* radioGroup (string)\n* actionType (SelectionType string)\n* state (State string)\n* showDisabled (boolean)\n* showDown (boolean)\n* showFocused (boolean)\n* showRollOver (boolean)\n* overflow (Overflow string)\n\n## Inherited from StatefulCanvas\n\n### Attributes\n* showFocusedAsOver (boolean)\n* showOverCanvas (boolean)\n* showMenuOnClick (boolean)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* click()\n* print()\n",format:"Markdown"
},"APIs list:SplitPane":{topic:"APIs list for SplitPane",content:"Only the following APIs are available on SplitPane:\n\n## Attributes\n* vertical (boolean)\n* addHistoryEntries (boolean)\n* pageOrientation (PageOrientation string)\n* notifyAfterNavigationClick (boolean)\n* navigationPaneWidth (number | string)\n* showNavigationBar (boolean)\n* currentPane (CurrentPane string)\n* navigationTitle (HTML string)\n* navigationPane (Canvas)\n* listTitle (HTML string)\n* listPane (Canvas)\n* showListToolStrip (boolean)\n* detailTitle (HTML string)\n* detailPane (Canvas)\n* showDetailToolStrip (boolean)\n* detailToolButtons (array of Canvas)\n* showLeftButton (boolean)\n* showRightButton (boolean)\n* listPaneTitleTemplate (HTML string)\n* detailPaneTitleTemplate (HTML string)\n* autoNavigate (boolean)\n\n## Methods\n* navigateListPane()\n* navigateDetailPane()\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:EdgedCanvas":{topic:"APIs list for EdgedCanvas",content:"Only the following APIs are available on EdgedCanvas:\n\n## Attributes\n* skinImgDir (SCImgURL string)\n* edgeImage (SCImgURL string)\n* edgeColor (CSSColor string)\n* customEdges (array of string)\n* showCenter (boolean)\n* edgeSize (integer)\n* edgeLeft (integer)\n* edgeRight (integer)\n* edgeTop (integer)\n* edgeBottom (integer)\n* edgeOffset (integer)\n* edgeOffsetTop (integer)\n* edgeOffsetBottom (integer)\n* edgeOffsetLeft (integer)\n* edgeOffsetRight (integer)\n* centerBackgroundColor (CSSColor string)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Toolbar":{topic:"APIs list for Toolbar",content:"Only the following APIs are available on Toolbar:\n\n## Attributes\n* buttons (array of Button properties objects)\n* vertical (boolean)\n* buttonConstructor (Class name string)\n* canReorderItems (boolean)\n* canResizeItems (boolean)\n* canAcceptDrop (boolean)\n* buttonDefaults (object)\n\n## Inherited from Layout\n\n### Attributes\n* overflow (Overflow string)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:DataSource":{topic:"APIs list for DataSource",content:"Only the following APIs are available on DataSource:\n\n## Attributes\n* serverConfig (DataSource properties object)\n* headers (object)\n* params (object)\n* httpMethod (string)\n* requestFormat (RESTRequestFormat string)\n* responseFormat (RESTResponseFormat string)\n* wrapInList (boolean)\n* requestTemplate (string)\n* responseTemplate (string)\n* requiresCompleteRESTResponse (boolean)\n* ID (Identifier string)\n* description (string)\n* addGlobalId (boolean)\n* dataFormat (DSDataFormat string)\n* useStrictJSON (boolean)\n* dataProtocol (DSProtocol string)\n* callbackParam (string)\n* requestProperties (DSRequest properties object)\n* dataTransport (RPCTransport string)\n* serverType (DSServerType string)\n* tableName (string)\n* schema (string)\n* quoteTableName (boolean)\n* relatedTableAlias (string)\n* dbName (string)\n* quoteColumnNames (boolean)\n* logSlowSQL (integer)\n* logSlowFetch (integer)\n* logSlowAdd (integer)\n* logSlowUpdate (integer)\n* logSlowRemove (integer)\n* logSlowCustom (integer)\n* jsonPrefix (string)\n* jsonSuffix (string)\n* fields (array of DataSourceField objects)\n* inheritsFrom (DataSource ID string)\n* auditedDataSourceID (string)\n* addedAuditFields (array of DataSourceField objects)\n* inheritanceMode (DSInheritanceMode string)\n* useFlatFields (boolean)\n* showLocalFieldsOnly (boolean)\n* useParentFieldOrder (boolean)\n* dropExtraFields (boolean)\n* autoDeriveSchema (boolean)\n* schemaBean (string)\n* idClassName (string)\n* patternSingleWildcard (string | array of string)\n* patternMultiWildcard (string | array of string)\n* translatePatternOperators (boolean)\n* xmlNamespaces (object)\n* serviceNamespace (URN)\n* schemaNamespace (URN)\n* recordXPath (XPathExpression string)\n* dataURL (URL string)\n* tagName (string)\n* useOfflineStorage (boolean)\n* clientOnly (boolean)\n* mockMode (boolean)\n* mockDataRows (integer)\n* mockDataCriteria (Criteria object)\n* criteriaPolicy (CriteriaPolicy string)\n* defaultTextMatchStyle (TextMatchStyle string)\n* ignoreTextMatchStyleCaseSensitive (boolean)\n* arrayCriteriaForceExact (boolean)\n* useLocalValidators (boolean)\n* requiredMessage (HTML string)\n* showPrompt (boolean)\n* enumTranslateStrategy (EnumTranslateStrategy string)\n* enumOrdinalProperty (string)\n* autoDeriveTitles (boolean)\n* sparseUpdates (boolean)\n* noNullUpdates (boolean)\n* requiresAuthentication (boolean)\n* requiresRole (string)\n* requires (VelocityExpression string)\n* creatorOverrides (boolean)\n* ownerIdField (string)\n* guestUserId (string)\n* ownerIdNullRole (string)\n* ownerIdNullAccess (NullAccessType string)\n* autoJoinTransactions (boolean)\n* useSpringTransaction (boolean)\n* tableCode (string)\n* progressiveLoading (boolean)\n* clientRequestMaxRows (integer)\n* requestMaxRows (integer)\n* cacheAllData (boolean)\n* cacheAcrossOperationIds (boolean)\n* cacheData (array of Record objects)\n* autoConvertRelativeDates (boolean)\n* useAnsiJoins (boolean)\n* audit (boolean)\n* auditDataSourceID (string)\n* auditUserFieldName (string)\n* auditTimeStampFieldName (string)\n* auditRevisionFieldName (string)\n* auditChangedFieldsFieldLength (integer)\n* auditTypeFieldName (string)\n* auditDSConstructor (string)\n* autoCreateAuditTable (boolean)\n* compareMetadataForAuditChangeStatus (boolean)\n* unionOf (string)\n* unionFields (string)\n* defaultUnionFieldsStrategy (UnionFieldsStrategy string)\n* title (string)\n* pluralTitle (string)\n* titleField (string)\n* serverConstructor (string)\n* qualifyColumnNames (boolean)\n* validateRelatedRecords (boolean)\n* beanClassName (string)\n* implicitCriteria (Criteria object)\n* globalNamespaces (object)\n* fileNameField (string)\n* fileTypeField (string)\n* fileFormatField (string)\n* fileContentsField (string)\n* fileLastModifiedField (string)\n* fileVersionField (string)\n* projectFileKey (string)\n* projectFileLocations (array of string)\n* isSampleDS (boolean)\n* script (string)\n* transformRequestScript (string)\n* transformResponseScript (string)\n* serverObject (ServerObject object)\n* operationBindings (array of OperationBinding)\n* allowClientRequestedSummaries (boolean)\n* recordName (string)\n* cacheSyncStrategy (CacheSyncStrategy string)\n* cacheSyncTiming (CacheSyncTiming string)\n* defaultMultiUpdatePolicy (MultiUpdatePolicy string)\n* dropUnknownCriteria (boolean)\n* strictSQLFiltering (boolean)\n* allowAdvancedCriteria (boolean)\n* allowAggregation (boolean)\n* suppressManualAggregation (string)\n* allowDynamicTreeJoins (boolean)\n",format:"Markdown"
},"APIs list:DataSourceField":{topic:"APIs list for DataSourceField",content:"Only the following APIs are available on DataSourceField:\n\n## Attributes\n* columnCode (string)\n* name (FieldName string)\n* description (string)\n* type (FieldType string)\n* mimeType (string)\n* required (boolean)\n* requiredMessage (string)\n* nillable (boolean)\n* valueMap (ValueMap object)\n* valueMapEnum (string)\n* validators (array of Validator)\n* length (number)\n* valueXPath (XPathExpression string)\n* valueWriteXPath (XPathExpression string)\n* title (HTML string)\n* escapeHTML (boolean)\n* canView (boolean)\n* canEdit (boolean)\n* canSave (boolean)\n* canFilter (boolean)\n* decimalPrecision (number)\n* decimalPad (number)\n* precision (number)\n* ignore (boolean)\n* detail (boolean)\n* primaryKey (boolean)\n* foreignKey (string)\n* childrenProperty (boolean)\n* rootValue (Any)\n* sequenceName (string)\n* includeFrom (string)\n* includeVia (string)\n* relatedTableAlias (string)\n* otherFKs (string)\n* displayField (string)\n* useLocalDisplayFieldValue (boolean)\n* foreignDisplayField (string)\n* joinType (JoinType string)\n* summaryFunction (SummaryFunction string)\n* valueOperation (string)\n* xmlAttribute (boolean)\n* childTagName (string)\n* group (string)\n* recreateOnChange (boolean)\n* multiple (boolean)\n* multipleStorage (MultipleFieldStorage string)\n* multipleStorageSeparator (string)\n* javaClass (string)\n* javaCollectionClass (string)\n* javaKeyClass (string)\n* exportTitle (string)\n* canExport (boolean)\n* uploadFieldName (string)\n* batchUploadOperationId (string)\n* batchUploadCaseSensitive (boolean)\n* showFileInline (boolean)\n* imageWidth (number | string)\n* imageHeight (number | string)\n* viewRequiresAuthentication (boolean)\n* editRequiresAuthentication (boolean)\n* initRequiresAuthentication (boolean)\n* updateRequiresAuthentication (boolean)\n* viewRequiresRole (string)\n* editRequiresRole (string)\n* initRequiresRole (string)\n* updateRequiresRole (string)\n* viewRequires (VelocityExpression string)\n* editRequires (VelocityExpression string)\n* initRequires (VelocityExpression string)\n* updateRequires (VelocityExpression string)\n* creatorOverrides (boolean)\n* translatorClassName (string)\n* audit (FieldAuditMode string)\n* customSQL (boolean)\n* customSelectExpression (VelocityExpression string)\n* customUpdateExpression (VelocityExpression string)\n* customInsertExpression (VelocityExpression string)\n* customCriteriaExpression (VelocityExpression string)\n* autoQuoteCustomExpressions (boolean)\n* outputWhen (OutputWhen string)\n* nativeName (string)\n* tableName (string)\n* unionOf (string)\n* importStrategyFailedErrorMessage (string)\n* sqlStorageStrategy (string)\n* sqlDateFormat (string)\n* storeMilliseconds (boolean)\n* sqlTrueValue (string)\n* sqlFalseValue (string)\n* stringInBrowser (boolean)\n* sortByField (string)\n* ignoreTextMatchStyle (boolean)\n* canSortClientOnly (boolean)\n* storeWithHash (HashAlgorithm string)\n* maxFileSize (integer)\n* encodeInResponse (boolean)\n* format (FormatString string)\n* exportFormat (FormatString string)\n* fieldValueScript (string)\n* includeSummaryFunction (SummaryFunction string)\n* joinPrefix (string)\n* joinString (string)\n* joinSuffix (string)\n* allowClientRequestedSummaries (boolean)\n* validOperators (array of OperatorId string)\n* filterOn (FieldFilterMode string)\n",format:"Markdown"
},"APIs list:OperationBinding":{topic:"APIs list for OperationBinding",content:"Only the following APIs are available on OperationBinding:\n\n## Attributes\n* headers (string)\n* params (string)\n* httpMethod (string)\n* requestFormat (RESTRequestFormat string)\n* responseFormat (RESTResponseFormat string)\n* wrapInList (boolean)\n* requestTemplate (string)\n* responseTemplate (string)\n* requiresCompleteRESTResponse (string)\n* arrayCriteriaForceExact (boolean)\n* skipAudit (boolean)\n* unionFields (string)\n* beanClassName (string)\n* operationType (DSOperationType string)\n* operationId (string)\n* description (string)\n* requiredCriterion (string)\n* serverMethod (string)\n* methodArguments (string)\n* serverObject (ServerObject object)\n* script (string)\n* transformRequestScript (string)\n* transformResponseScript (string)\n* isDDL (boolean)\n* wsOperation (string)\n* dataURL (URL string)\n* dataProtocol (DSProtocol string)\n* dataFormat (DSDataFormat string)\n* dataTransport (RPCTransport string)\n* callbackParam (string)\n* requestProperties (DSRequest properties object)\n* preventHTTPCaching (boolean)\n* defaultParams (object)\n* useFlatFields (boolean)\n* summaryFunctions (object)\n* groupBy (array of string)\n* recordXPath (XPathExpression string)\n* recordName (string)\n* spoofResponses (boolean)\n* xmlNamespaces (object)\n* responseDataSchema (DataSource)\n* exportResults (boolean)\n* exportAs (ExportFormat string)\n* exportFilename (string)\n* lineBreakStyle (string)\n* autoJoinTransactions (boolean)\n* useSpringTransaction (boolean)\n* includeAnsiJoinsInTableClause (boolean)\n* selectClause (VelocityExpression string)\n* tableClause (VelocityExpression string)\n* whereClause (VelocityExpression string)\n* groupClause (VelocityExpression string)\n* orderClause (VelocityExpression string)\n* valuesClause (VelocityExpression string)\n* applyCriteriaBeforeAggregation (boolean)\n* useHavingClause (boolean)\n* customSQL (VelocityExpression string)\n* customHQL (string)\n* customJQL (string)\n* skipRowCount (boolean)\n* customFields (string | array)\n* customValueFields (string | array)\n* customCriteriaFields (string | array)\n* excludeCriteriaFields (string | array)\n* useForCacheSync (boolean)\n* cacheSyncOperation (string)\n* canSyncCache (boolean)\n* cacheSyncStrategy (CacheSyncStrategy string)\n* cacheSyncTiming (CacheSyncTiming string)\n* sqlType (SQLType string)\n* allowMultiUpdate (boolean)\n* providesMissingKeys (boolean)\n* qualifyColumnNames (boolean)\n* outputs (string)\n* progressiveLoading (boolean)\n* allowAdvancedCriteria (boolean)\n* criteria (array of DSRequestModifier objects)\n* values (array of DSRequestModifier objects)\n* requiresAuthentication (boolean)\n* requiresRole (string)\n* requires (VelocityExpression string)\n* creatorOverrides (boolean)\n* ownerIdField (string)\n* guestUserId (string)\n* mail (Mail)\n",format:"Markdown"
},"APIs list:DSRequest":{topic:"APIs list for DSRequest",content:"Only the following APIs are available on DSRequest:\n\n## Attributes\n* startRow (number)\n* endRow (number)\n* sortBy (FieldName string | array of FieldName string | array of SortSpecifier objects)\n* summaryFunctions (object)\n* groupBy (array of string)\n* applyCriteriaBeforeAggregation (boolean)\n* exportAs (ExportFormat string)\n* exportDisplay (ExportDisplay string)\n",format:"Markdown"
},"APIs list:AdvancedCriteria":{topic:"APIs list for AdvancedCriteria",content:"Only the following APIs are available on AdvancedCriteria:\n\n## Attributes\n* strictSQLFiltering (boolean)\n",format:"Markdown"
},"APIs list:FilterBuilder":{topic:"APIs list for FilterBuilder",content:"Only the following APIs are available on FilterBuilder:\n\n## Attributes\n* criteria (AdvancedCriteria object)\n\n## Inherited from Layout\n\n### Attributes\n* members (array of Canvas)\n* overflow (Overflow string)\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* membersMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:SearchForm":{topic:"APIs list for SearchForm",content:"Only the following APIs are available on SearchForm:\n\n## Attributes\n* searchOnEnter (boolean)\n* criteriaChangedDelay (integer)\n\n## Methods\n* search()\n* criteriaChanged()\n\n## Inherited from DynamicForm\n\n### Attributes\n* autoFetchData (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* fetchRequestProperties (DSRequest properties object)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* items (array of FormItem properties objects)\n* fields (array of FormItem properties objects)\n* initialSort (array of SortSpecifier objects)\n* values (object)\n* itemLayout (FormLayoutType)\n* linearMode (boolean)\n* linearOnMobile (boolean)\n* numCols (number)\n* linearNumCols (number)\n* fixedColWidths (boolean)\n* colWidths (array)\n* minColWidth (number)\n* cellPadding (number)\n* cellBorder (number)\n* sectionVisibilityMode (VisibilityMode string)\n* longTextEditorThreshold (number)\n* longTextEditorType (string)\n* valuesManager (ValuesManager | GlobalId string)\n* titleOrientation (TitleOrientation string)\n* titlePrefix (HTML string)\n* rightTitlePrefix (HTML string)\n* titleSuffix (HTML string)\n* rightTitleSuffix (HTML string)\n* titleWidth (number | the literal string \"*\")\n* wrapItemTitles (boolean)\n* showInlineErrors (boolean)\n* showErrorIcons (boolean)\n* showErrorText (boolean)\n* showErrorStyle (boolean)\n* errorOrientation (Align)\n* errorItemProperties (object)\n* errorItemCellStyle (string)\n* errorsPreamble (HTML string)\n* showTitlesWithErrorMessages (boolean)\n* hiliteRequiredFields (boolean)\n* requiredTitlePrefix (HTML string)\n* requiredRightTitlePrefix (HTML string)\n* requiredTitleSuffix (HTML string)\n* requiredRightTitleSuffix (HTML string)\n* canEdit (boolean)\n* readOnlyDisplay (ReadOnlyDisplayAppearance string)\n* readOnlyTextBoxStyle (FormItemBaseStyle string)\n* itemHoverDelay (number)\n* itemHoverWidth (number | string)\n* itemHoverHeight (number | string)\n* itemHoverAlign (Alignment string)\n* itemHoverVAlign (number | string)\n* itemHoverStyle (CSSStyleName string)\n* itemHoverOpacity (number)\n* errors (object)\n* validateOnChange (boolean)\n* unknownErrorMessage (HTML string)\n* autoFocus (boolean)\n* autoFocusOnError (boolean)\n* selectOnFocus (boolean)\n* canFocus (boolean)\n* autoComplete (AutoComplete string)\n* browserSpellCheck (boolean)\n* validationURL (URL string)\n* action (URL string)\n* target (string)\n* method (FormMethod string)\n* encoding (Encoding string)\n* canSubmit (boolean)\n* dataSource (DataSource | ID string)\n* dataArity (string)\n* titleAlign (Alignment string)\n\n### Methods\n* editNewRecord()\n* editSelectedData()\n* reset()\n* saveData()\n* viewSelectedData()\n* setValues()\n* clearValues()\n* validate()\n* itemChanged()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:ValuesManager":{topic:"APIs list for ValuesManager",content:"Only the following APIs are available on ValuesManager:\n\n## Attributes\n* dataSource (DataSource | GlobalId string)\n* fetchOperation (string)\n* members (array of DynamicForm)\n\n## Methods\n* editNewRecord()\n* editRecord()\n* editSelectedData()\n* saveData()\n* validate()\n* setValues()\n* clearValues()\n* itemChanged()\n",format:"Markdown"
},"APIs list:Portlet":{topic:"APIs list for Portlet",content:"Only the following APIs are available on Portlet:\n\n## Attributes\n* dragType (string)\n* canDrop (boolean)\n* minHeight (number)\n* minWidth (number)\n* height (number | string)\n* rowHeight (number | string)\n* showCloseConfirmationMessage (boolean)\n* closeConfirmationMessage (string)\n* destroyOnClose (boolean)\n\n## Inherited from Window\n\n### Attributes\n* canDragReposition (boolean)\n* keepInParentRect (boolean | array of integer)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* opacity (integer)\n* isModal (boolean)\n* showModalMask (boolean)\n* modalMaskOpacity (number)\n* autoCenter (boolean)\n* dismissOnOutsideClick (boolean)\n* dismissOnEscape (boolean)\n* showBody (boolean)\n* bodyStyle (CSSStyleName string)\n* bodyColor (CSSColor string)\n* hiliteBodyColor (CSSColor string)\n* items (array of Canvas | Canvas | string)\n* src (string)\n* contentsType (string)\n* bodyConstructor (string)\n* bodyDefaults (object)\n* contentLayout (ContentLayoutPolicy string)\n* autoSize (boolean)\n* showHeader (boolean)\n* showHeaderBackground (boolean)\n* headerStyle (CSSStyleName string)\n* headerSrc (SCImgURL string)\n* headerControls (array of string)\n* hiliteHeaderStyle (CSSStyleName string)\n* hiliteHeaderSrc (SCImgURL string)\n* showTitle (boolean)\n* title (HTML string)\n* headerLabelDefaults (object)\n* showHeaderIcon (boolean)\n* headerIconDefaults (object)\n* canFocusInHeaderButtons (boolean)\n* showCloseButton (boolean)\n* showMinimizeButton (boolean)\n* minimized (boolean)\n* defaultMinimizeHeight (number)\n* minimizeHeight (number)\n* animateMinimize (boolean)\n* minimizeTime (number)\n* minimizeAcceleration (AnimationAcceleration string)\n* maximized (boolean)\n* showMaximizeButton (boolean)\n* showFooter (boolean)\n* footerHeight (number)\n* footerControls (array of string)\n* showStatusBar (boolean)\n* showResizer (boolean)\n* showEdges (boolean)\n* showShadow (boolean)\n\n## Inherited from Layout\n\n### Attributes\n* overflow (Overflow string)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* layoutMargin (integer)\n* membersMargin (integer)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* dragRepositionCursor (Cursor string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* dragAppearance (DragAppearance string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:PortalLayout":{topic:"APIs list for PortalLayout",content:"Only the following APIs are available on PortalLayout:\n\n## Attributes\n* overflow (Overflow string)\n* columnOverflow (Overflow string)\n* canStretchColumnWidths (boolean)\n* canShrinkColumnWidths (boolean)\n* preventUnderflow (boolean)\n* preventColumnUnderflow (boolean)\n* preventRowUnderflow (boolean)\n* columnSpacing (integer)\n* portletHSpacing (integer)\n* portletVSpacing (integer)\n* numColumns (integer)\n* showColumnMenus (boolean)\n* columnBorder (string)\n* canResizeColumns (boolean)\n* canResizePortlets (boolean)\n* portletDropTypes (array of string)\n* canAcceptDrop (boolean)\n* dropTypes (array of string)\n\n## Inherited from Layout\n\n### Attributes\n* vertical (boolean)\n* vPolicy (LayoutPolicy string)\n* hPolicy (LayoutPolicy string)\n* minMemberLength (integer)\n* minBreadthMember (string | integer | Canvas)\n* enforcePolicy (boolean)\n* defaultLayoutAlign (Alignment string | VerticalAlignment string)\n* align (Alignment string | VerticalAlignment string)\n* reverseOrder (boolean)\n* paddingAsLayoutMargin (boolean)\n* layoutMargin (integer)\n* layoutLeftMargin (integer)\n* layoutRightMargin (integer)\n* layoutTopMargin (integer)\n* layoutBottomMargin (integer)\n* leaveScrollbarGap (boolean)\n* resizeBarClass (string)\n* resizeBarSize (integer)\n* animateMembers (boolean)\n* animateMemberTime (number)\n* canDropComponents (boolean)\n* dropLineThickness (number)\n* showDragPlaceHolder (boolean)\n* placeHolderProperties (Canvas properties object)\n* placeHolderDefaults (Canvas properties object)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Calendar":{topic:"APIs list for Calendar",content:"Only the following APIs are available on Calendar:\n\n## Attributes\n* chosenDate (Date object)\n* firstDayOfWeek (number)\n* baseStyle (CSSStyleName string)\n* dayHeaderBaseStyle (CSSStyleName string)\n* dayBodyBaseStyle (CSSStyleName string)\n* otherDayHeaderBaseStyle (CSSStyleName string)\n* otherDayBodyBaseStyle (CSSStyleName string)\n* otherDayBlankStyle (CSSStyleName string)\n* showDayView (boolean)\n* showWeekView (boolean)\n* showMonthView (boolean)\n* selectedCellStyle (CSSStyleName string)\n* workdayBaseStyle (CSSStyleName string)\n* workdayStart (Time)\n* workdayEnd (Time)\n* showWorkday (boolean)\n* scrollToWorkday (boolean)\n* nameField (string)\n* descriptionField (string)\n* startDateField (string)\n* endDateField (string)\n* canEditField (string)\n* weekEventBorderOverlap (boolean)\n* eventSnapGap (integer)\n* showQuickEventDialog (boolean)\n* eventEditorFields (array of FormItem)\n* eventDialogFields (array of FormItem)\n* canCreateEvents (boolean)\n* canEditEvents (boolean)\n* showDateChooser (boolean)\n* disableWeekends (boolean)\n* showWeekends (boolean)\n* showDayHeaders (boolean)\n* showOtherDays (boolean)\n* eventOverlapPercent (number)\n* data (array of CalendarEvent objects)\n* dataSource (DataSource | ID string)\n* autoFetchData (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* invalidDateMessage (string)\n* showEventCanvasComponents (boolean)\n* eventScreen (string)\n* zones (array of CalendarEvent objects)\n* indicators (array of CalendarEvent objects)\n\n## Methods\n* fetchData()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:Timeline":{topic:"APIs list for Timeline",content:"Only the following APIs are available on Timeline:\n\n## Inherited from Calendar\n\n### Attributes\n* chosenDate (Date object)\n* firstDayOfWeek (number)\n* baseStyle (CSSStyleName string)\n* dayHeaderBaseStyle (CSSStyleName string)\n* dayBodyBaseStyle (CSSStyleName string)\n* otherDayHeaderBaseStyle (CSSStyleName string)\n* otherDayBodyBaseStyle (CSSStyleName string)\n* otherDayBlankStyle (CSSStyleName string)\n* showDayView (boolean)\n* showWeekView (boolean)\n* showMonthView (boolean)\n* selectedCellStyle (CSSStyleName string)\n* workdayBaseStyle (CSSStyleName string)\n* workdayStart (Time)\n* workdayEnd (Time)\n* showWorkday (boolean)\n* scrollToWorkday (boolean)\n* nameField (string)\n* descriptionField (string)\n* startDateField (string)\n* endDateField (string)\n* canEditField (string)\n* weekEventBorderOverlap (boolean)\n* eventSnapGap (integer)\n* showQuickEventDialog (boolean)\n* eventEditorFields (array of FormItem)\n* eventDialogFields (array of FormItem)\n* canCreateEvents (boolean)\n* canEditEvents (boolean)\n* showDateChooser (boolean)\n* disableWeekends (boolean)\n* showWeekends (boolean)\n* showDayHeaders (boolean)\n* showOtherDays (boolean)\n* eventOverlapPercent (number)\n* data (array of CalendarEvent objects)\n* dataSource (DataSource | ID string)\n* autoFetchData (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* invalidDateMessage (string)\n* showEventCanvasComponents (boolean)\n* eventScreen (string)\n* zones (array of CalendarEvent objects)\n* indicators (array of CalendarEvent objects)\n\n### Methods\n* fetchData()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* skinImgDir (SCImgURL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* overflow (Overflow string)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:DateChooser":{topic:"APIs list for DateChooser",content:"Only the following APIs are available on DateChooser:\n\n## Attributes\n* skinImgDir (SCImgURL string)\n* prevYearIconWidth (integer)\n* prevYearIconHeight (integer)\n* prevMonthIconWidth (integer)\n* prevMonthIconHeight (integer)\n* nextYearIconWidth (integer)\n* nextYearIconHeight (integer)\n* nextMonthIconWidth (integer)\n* nextMonthIconHeight (integer)\n* showDoubleYearIcon (boolean)\n* showTodayButton (boolean)\n* showCancelButton (boolean)\n* todayButtonTitle (string)\n* cancelButtonTitle (string)\n* todayButtonHeight (integer)\n* disableWeekends (boolean)\n* showWeekends (boolean)\n* firstDayOfWeek (integer)\n* baseButtonStyle (CSSStyleName string)\n* baseWeekdayStyle (CSSStyleName string)\n* baseWeekendStyle (CSSStyleName string)\n* headerStyle (CSSStyleName string)\n\n## Inherited from Layout\n\n### Attributes\n* overflow (Overflow string)\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* children (array of Canvas)\n* peers (array of Canvas)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* minHeight (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* styleName (CSSStyleName string)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* canHover (boolean)\n* hoverDelay (number)\n* showHover (boolean)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverStyle (CSSStyleName string)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
},"APIs list:CubeGrid":{topic:"APIs list for CubeGrid",content:"Only the following APIs are available on CubeGrid:\n\n## Attributes\n* styleName (CSSStyleName string)\n* bodyStyleName (CSSStyleName string)\n* baseStyle (CSSStyleName string)\n* alternateRecordStyles (boolean)\n* skinImgDir (SCImgURL string)\n* facetValueHoverWidth (number | string)\n* facetLabelHoverWidth (number | string)\n* facetValueHoverHeight (number | string)\n* facetLabelHoverHeight (number | string)\n* facetValueHoverAlign (Alignment string)\n* facetLabelHoverAlign (Alignment string)\n* facetValueHoverVAlign (VerticalAlignment string)\n* facetLabelHoverVAlign (VerticalAlignment string)\n* facetValueHoverStyle (CSSStyleName string)\n* facetLabelHoverStyle (CSSStyleName string)\n* fixedFacetValues (FacetValueMap object)\n* hilites (array of Hilite objects)\n* dataSource (DataSource)\n* autoFetchData (boolean)\n* autoFetchTextMatchStyle (TextMatchStyle string)\n* fetchRequestProperties (DSRequest properties object)\n* facets (array of Facet)\n* showFacetContextMenus (boolean)\n* showFacetValueContextMenus (boolean)\n* canSelectValues (boolean)\n* canSelectHeaders (boolean)\n* autoSelectHeaders (boolean)\n* autoSelectValues (AutoSelectionModel string)\n* simpleDeselect (boolean)\n* columnFacets (array of string)\n* rowFacets (array of string)\n* hideEmptyFacetValues (boolean)\n* data (array of CellRecord objects)\n* valueProperty (Identifier string)\n* cellIdProperty (Identifier string)\n* canEdit (boolean)\n* editByCell (boolean)\n* saveByCell (boolean)\n* canDragSelect (boolean)\n* canReorderColumns (boolean)\n* canResizeColumns (boolean)\n* canCollapseFacets (boolean)\n* canMinimizeFacets (boolean)\n* sortedFacetValues (FacetValueMap object)\n* sortDirection (SortDirection string)\n* canSortFacets (boolean)\n* canSortData (boolean)\n* canMinimizeColumns (boolean)\n* canMoveFacets (boolean)\n* rowHeaderGridMode (boolean)\n* autoSizeHeaders (boolean)\n* facetTitleAlign (Alignment string)\n* facetValueAlign (Alignment string)\n* cellAlign (Alignment string)\n* wrapFacetTitles (boolean)\n* wrapFacetValueTitles (boolean)\n* padTitles (boolean)\n* defaultFacetWidth (number)\n* rollupValue (string)\n* metricFacetId (string)\n* valueTitle (string)\n* bodyMinWidth (number)\n* bodyMinHeight (number)\n* autoFitFieldWidths (boolean)\n* enableCharting (boolean)\n* chartConstructor (Classname)\n* chartType (ChartType string)\n* chartConfirmThreshold (number)\n\n## Methods\n* exportClientData()\n\n## Inherited from ListGrid\n\n### Attributes\n* initialCriteria (Criteria object)\n* implicitCriteria (Criteria object)\n* fields (array of ListGridField objects)\n* dataArity (string)\n* autoFetchDisplayMap (boolean)\n* saveLocally (boolean)\n* useAllDataSourceFields (boolean)\n* showDetailFields (boolean)\n* titleField (string)\n* dataProperties (ResultSet)\n* saveDefaultSearch (boolean)\n* canSaveSearches (boolean)\n* savedSearchStoredState (SavedSearchStoredState string)\n* noSavedSearchesText (HTML string)\n* savedSearchText (HTML string)\n* newSearchText (HTML string)\n* savedSearchAdminSeparator (ListGridRecord properties object)\n* savedSearchDS (string)\n* savedSearchAdminRole (string)\n* groupStartOpen (GroupStartOpen string | array)\n* groupTitleColumnProperties (ListGridField properties object)\n* groupIconSize (number)\n* groupIndentSize (number)\n* canGroupBy (boolean)\n* groupByMaxRecords (integer)\n* groupByField (string | array of string)\n* valueIconSize (number)\n* valueIconWidth (number)\n* valueIconHeight (number)\n* valueIconLeftPadding (number)\n* valueIconRightPadding (number)\n* hiliteIcons (array of string)\n* hiliteIconPosition (HiliteIconPosition string)\n* hiliteIconSize (number)\n* hiliteIconWidth (number)\n* hiliteIconHeight (number)\n* hiliteIconLeftPadding (number)\n* hiliteIconRightPadding (number)\n* imageSize (number)\n* headerSpans (array of HeaderSpan objects)\n* headerSpanHeight (integer)\n* showTreeColumnPicker (boolean)\n* modalEditing (boolean)\n* fetchDelay (number)\n* overflow (Overflow string)\n* minHeight (number)\n* showAllRecords (boolean)\n* drawAheadRatio (number)\n* scrollRedrawDelay (integer)\n* dataPageSize (integer)\n* bodyOverflow (Overflow string)\n* bodyBackgroundColor (string)\n* emptyCellValue (HTML string)\n* cellHeight (number)\n* fixedRecordHeights (boolean)\n* fixedFieldWidths (boolean)\n* autoFitData (Autofit string)\n* autoFitMaxHeight (integer)\n* autoFitMaxRecords (integer)\n* autoFitMaxWidth (integer | string)\n* autoFitMaxColumns (integer)\n* autoFitWidthApproach (AutoFitWidthApproach string)\n* leaveScrollbarGap (boolean)\n* wrapCells (boolean)\n* cellPadding (number)\n* dateFormatter (DateDisplayFormat string)\n* dateInputFormat (DateInputFormat string)\n* timeFormatter (TimeDisplayFormat string)\n* fastCellUpdates (boolean)\n* editFailedBaseStyle (CSSStyleName string)\n* editFailedCSSText (string)\n* editPendingCSSText (string)\n* recordCustomStyleProperty (string)\n* recordBaseStyleProperty (string)\n* shrinkForFreeze (boolean)\n* alternateRecordFrequency (number)\n* generateClickOnSpace (boolean)\n* generateClickOnEnter (boolean)\n* generateDoubleClickOnSpace (boolean)\n* generateDoubleClickOnEnter (boolean)\n* arrowKeyAction (string)\n* showRecordComponents (boolean)\n* recordComponentPosition (EmbeddedPosition string)\n* showRollOver (boolean)\n* canHover (boolean)\n* showHover (boolean)\n* hoverStyle (CSSStyleName string)\n* selectionAppearance (SelectionAppearance string)\n* selectionType (SelectionStyle string)\n* selectionProperty (string)\n* checkboxFieldImageWidth (integer)\n* checkboxFieldImageHeight (integer)\n* showEmptyMessage (boolean)\n* emptyMessage (HTML string)\n* emptyMessageStyle (CSSStyleName string)\n* loadingDataMessage (HTML string)\n* loadingDataMessageStyle (CSSStyleName string)\n* loadingMessage (string)\n* singleCellValueProperty (string)\n* isSeparatorProperty (string)\n* showFilterEditor (boolean)\n* canShowFilterEditor (boolean)\n* filterEditorHeight (number)\n* recordEditProperty (string)\n* validateByCell (boolean)\n* validateOnChange (boolean)\n* neverValidate (boolean)\n* canRemoveRecords (boolean)\n* warnOnRemoval (boolean)\n* warnOnRemovalMessage (string)\n* animateRemoveRecord (boolean)\n* animateRemoveTime (number)\n* animateRemoveSpeed (number)\n* filterByCell (boolean)\n* filterOnKeypress (boolean)\n* waitForSave (boolean)\n* stopOnErrors (boolean)\n* autoSaveEdits (boolean)\n* confirmCancelEditing (boolean)\n* cancelEditingConfirmationMessage (string)\n* confirmDiscardEdits (boolean)\n* confirmDiscardEditsMessage (string)\n* discardEditsSaveButtonTitle (string)\n* rowEndEditAction (RowEndEditAction string)\n* listEndEditAction (RowEndEditAction string)\n* enterKeyEditAction (EnterKeyEditAction string)\n* escapeKeyEditAction (EscapeKeyEditAction string)\n* editEvent (ListGridEditEvent string)\n* editOnFocus (boolean)\n* selectOnEdit (boolean)\n* longTextEditorThreshold (integer)\n* longTextEditorType (string)\n* headerHeight (number)\n* minFieldWidth (integer)\n* showHeader (boolean)\n* headerBarStyle (CSSStyleName string)\n* headerBackgroundColor (CSSColor string)\n* headerButtonConstructor (Class name string)\n* headerBaseStyle (CSSStyleName string)\n* headerTitleStyle (CSSStyleName string)\n* headerButtonDefaults (Button properties object)\n* headerButtonProperties (Button properties object)\n* wrapHeaderTitles (boolean)\n* sorterConstructor (Class name string)\n* sorterDefaults (object)\n* sorterProperties (Button properties object)\n* canSort (boolean)\n* sortField (string | integer)\n* showSortArrow (SortArrow string)\n* canPickFields (boolean)\n* canFreezeFields (boolean)\n* canAddFormulaFields (boolean)\n* canAddSummaryFields (boolean)\n* canEditHilites (boolean)\n* showCellContextMenus (boolean)\n* showHeaderContextMenu (boolean)\n* showHeaderMenuButton (boolean)\n* headerMenuButtonIconWidth (number)\n* headerMenuButtonIconHeight (number)\n* headerMenuButtonWidth (number)\n* headerMenuButtonHeight (number | string)\n* canDragRecordsOut (boolean)\n* canAcceptDroppedRecords (boolean)\n* canReorderRecords (boolean)\n* canReorderFields (boolean)\n* canResizeFields (boolean)\n* dragTrackerMode (DragTrackerMode string)\n* resizeFieldsInRealTime (boolean)\n* dragDataAction (DragDataAction string)\n* sortAscendingImage (SCImgURL string | ImgHTML properties object)\n* sortDescendingImage (SCImgURL string | ImgHTML properties object)\n* trackerImage (SCImgURL string | ImgHTML properties object)\n* booleanTrueImage (SCImgURL string)\n* booleanFalseImage (SCImgURL string)\n* booleanImageWidth (number)\n* booleanImageHeight (number)\n* canExpandRecords (boolean)\n* canExpandMultipleRecords (boolean)\n* detailField (string)\n* expansionMode (ExpansionMode string)\n* expansionScreen (string)\n* detailDS (string)\n* viewState (ListGridViewState string)\n* autoPersistViewState (array of ListGridViewStatePart string)\n* gridComponents (array of ListGridComponent string | array of Any)\n* autoFitHeaderHeights (boolean)\n* applyFormulaAfterSummary (boolean)\n* printHeaderStyle (CSSStyleName string)\n* showHoverComponents (boolean)\n* hoverMode (HoverMode string)\n* hoverScreen (string)\n* showGridSummary (boolean)\n* hideEmptySummaryRow (boolean)\n* allowFilterExpressions (boolean)\n* updateSummariesDuringEditing (boolean)\n* freezeFieldText (HTML string)\n* unfreezeFieldText (HTML string)\n* groupByText (HTML string)\n* allowFilterWindow (boolean)\n* showFilterWindowCriteriaIndicator (boolean)\n* searchForm (DynamicForm | ValuesManager)\n* showFilterEditorHovers (boolean)\n* initialSort (array of SortSpecifier objects)\n* showSortNumerals (boolean)\n* recordScreen (string)\n* showGroupSummary (boolean)\n* useAdvancedFieldPicker (boolean)\n* advancedFieldPickerThreshold (integer)\n\n### Methods\n* fetchData()\n* exportData()\n* filterData()\n* fetchRelatedData()\n* removeSelectedData()\n* recordClick()\n* recordDoubleClick()\n* startEditing()\n* startEditingNew()\n* removeRecordClick()\n* selectionUpdated()\n\n## Inherited from Canvas\n\n### Attributes\n* ID (GlobalId string)\n* autoDraw (boolean)\n* htmlElement (DOMElement object | string)\n* htmlPosition (DrawPosition string)\n* matchElement (boolean)\n* position (Positioning string)\n* left (number | string)\n* top (number | string)\n* width (number | string)\n* height (number | string)\n* defaultWidth (integer)\n* defaultHeight (integer)\n* minWidth (number)\n* maxWidth (number)\n* maxHeight (number)\n* autoShowParent (boolean)\n* visibility (Visibility string)\n* canSelectText (boolean)\n* contents (HTML string)\n* dynamicContents (boolean)\n* dynamicContentsVars (ValueMap object)\n* margin (number)\n* padding (number)\n* border (string)\n* backgroundColor (CSSColor string)\n* backgroundImage (SCImgURL string)\n* backgroundRepeat (BackgroundRepeat string)\n* appImgDir (URL string)\n* cursor (Cursor string)\n* disabledCursor (Cursor string)\n* opacity (number)\n* showCustomScrollbars (boolean)\n* scrollbarSize (number)\n* disabled (boolean)\n* visibleWhen (AdvancedCriteria object)\n* enableWhen (AdvancedCriteria object)\n* redrawOnResize (boolean)\n* canFocus (boolean)\n* tabIndex (number)\n* accessKey (string)\n* contextMenu (Menu)\n* prompt (HTML string)\n* canDrag (boolean)\n* dragStartDistance (number)\n* canDragScroll (boolean)\n* dragScrollDelay (number)\n* dragIntersectStyle (DragIntersectStyle string)\n* canDragReposition (boolean)\n* dragRepositionCursor (Cursor string)\n* canDragResize (boolean)\n* resizeFrom (array of EdgeName string)\n* hoverDelay (number)\n* hoverWidth (integer)\n* hoverHeight (integer)\n* hoverAlign (Alignment string)\n* hoverVAlign (VerticalAlignment string)\n* hoverWrap (boolean)\n* hoverOpacity (number)\n* hoverMoveWithMouse (boolean)\n* edgeMarginSize (number)\n* edgeCursorMap (object)\n* keepInParentRect (boolean | array of integer)\n* dragAppearance (DragAppearance string)\n* dragType (string)\n* dropTypes (array of string | string)\n* dragTarget (Canvas | string)\n* showDragShadow (boolean)\n* dragOpacity (integer)\n* canDrop (boolean)\n* canAcceptDrop (boolean)\n* canDropBefore (boolean)\n* mouseStillDownInitialDelay (integer)\n* mouseStillDownDelay (integer)\n* doubleClickDelay (integer)\n* noDoubleClicks (boolean)\n* snapTo (string)\n* snapOffsetLeft (integer)\n* snapOffsetTop (integer)\n* snapToGrid (boolean)\n* snapResizeToGrid (boolean)\n* childrenSnapToGrid (boolean)\n* childrenSnapResizeToGrid (boolean)\n* snapHGap (number)\n* snapVGap (number)\n* snapOnDrop (boolean)\n* showPointer (boolean)\n* pointerTarget (AutoTestLocator string | GlobalId string)\n* pointerSettings (PointerSettings object)\n* workflows (array of Process)\n* borderRadius (string)\n* showEdges (boolean)\n* edgeSize (number)\n* edgeOffset (number)\n* edgeImage (SCImgURL string)\n* customEdges (array of string)\n* edgeBackgroundColor (CSSColor string)\n* edgeOpacity (integer)\n* edgeShowCenter (boolean)\n* edgeCenterBackgroundColor (CSSColor string)\n* showShadow (boolean)\n* shadowDepth (number)\n* shadowOffset (number)\n* shadowSoftness (number)\n* shadowImage (SCImgURL string)\n* isGroup (boolean)\n* groupTitle (HTML string)\n* testDataContext (DataContext object)\n* autoPopulateData (boolean)\n* ruleScope (string)\n* isRuleScope (boolean)\n* valuesManager (ValuesManager | GlobalId string)\n* dataPath (DataPath string)\n* animateTime (number)\n* animateAcceleration (AnimationAcceleration string)\n* animateMoveTime (number)\n* animateResizeTime (number)\n* animateRectTime (number)\n* animateFadeTime (number)\n* animateScrollTime (number)\n* animateShowTime (number)\n* animateHideTime (number)\n* animateMoveAcceleration (AnimationAcceleration string)\n* animateResizeAcceleration (AnimationAcceleration string)\n* animateRectAcceleration (AnimationAcceleration string)\n* animateScrollAcceleration (AnimationAcceleration string)\n* animateShowAcceleration (AnimationAcceleration string)\n* animateHideAcceleration (AnimationAcceleration string)\n* layoutAlign (Alignment string | VerticalAlignment string)\n* showResizeBar (boolean)\n* resizeBarTarget (string)\n* extraSpace (positive integer)\n\n### Methods\n* showNextTo()\n* show()\n* hide()\n* print()\n",format:"Markdown"
}},isc.aiHelpDocuments);isc.defineClass("InternalAIMessagesBuilder").addProperties({
messagesSource:"user",
ssMessagesProperty:"userMessages",
ssMessagesPlaceholder:"${userMessages}",
init:function(){
this.Super("init",arguments);
this.aiMessages=[]},
appendPrompt:function(_1){
if(_1==this.ssMessagesPlaceholder){
this.$287x()}else{
this.aiMessages.push({
source:"system",
content:_1.evalDynamicString(this.target,this.evalVars)
})}
},
$287x:function(){
var _1=this.messagesSource;
this.aiMessages.addList(this[this.ssMessagesProperty].map(function(_2){
return{
source:_1,
content:_2.content,
type:_2.type
}}))},
appendPrompts:function(_1){
if(!isc.isAn.Array(_1)){
this.appendPrompt(_1);
return}
for(var i=0;i<_1.length;++i){
this.appendPrompt(_1[i])}
},
appendHelpDocuments:function(_1){
if(_1&&_1.length>0){
var _2="";
for(var h=0;h<_1.length;++h){
var _4=_1[h];
_2+="<requirements-document topic=\""+(_4.topic||_4.ID).trim()+"\"";
if(_4.format)_2+=" format=\""+_4.format.trim()+"\"";
_2+=">\n"
+_4.content.trim()+"\n</requirements-document>\n"}
this.aiMessages.push({
source:"system",
content:_2
})}
},
renderTemplate:function(_1){
var _2=(this.target||isc.AI).render(_1,this.evalVars);
var _3=_2.indexOf(this.ssMessagesPlaceholder);
if(_3<0)_3=0;
else{
if(_3>0){
this.aiMessages.push({
source:"system",
content:_2.substring(0,_3)
})}
this.$287x();
_3+=this.ssMessagesPlaceholder.length}
if(_3<_2.length){
this.aiMessages.push({
source:"system",
content:_2.substring(_3)
})}
}
});
isc.defineClass("InternalAIMessagesBuilder2","InternalAIMessagesBuilder");
isc.A=isc.InternalAIMessagesBuilder2.getPrototype();
isc.A.ssMessagesProperty="ssMessages";
isc.A.ssMessagesPlaceholder="${ssMessages}"
;
isc.defineClass("AIEngine").addClassProperties({
defaultHistoryIntroduction:"You have previously interacted with the user as follows. Each prior message from the user is delineated by ^^^^^^^ both before and after their message. Your responses are delineated by ####### both before and after your message.",
defaultHistoryConclusion:"That is the end of your previous interaction with the user. You are now to respond to the following.",
defaultHistoryDelimiters:{
"system":"\n\n",
"user":"^^^^^^^\n",
"AI":"#######\n"
},
$272z:function(_1){
return _1==null||_1=="text"},
$2720:function(_1){
return _1=="jpegImage"||_1=="pngImage"},
isImageMessage:function(_1){
return this.$2720(_1.type)},
getImageFormat:function(_1){
if(_1=="jpegImage"){
return"jpeg"}else if(_1=="png"||_1=="pngImage"){
return"png"}else{
return null}
},
$269b:function(_1){
this.$102q(this.isImageMessage(_1));
return _1.type=="jpegImage"?"image/jpeg":"image/png"},
containsImageMessage:function(_1){
if(_1!=null){
for(var i=0;i<_1.length;++i){
if(this.isImageMessage(_1[i])){
return true}
}
}
return false},
isVisionRequest:function(_1){
if(this.containsImageMessage(_1.messages)){
return true}
return false},
cloneAIRequest:function(_1){
var _2=isc.addPropertiesWithAssign({},_1);
delete _2.$260u;
if(isc.isAn.Array(_2.messages)){
_2.messages=_2.messages.duplicate()}
return _2},
$2889:"aiResponse,aiRequest"
});
isc.A=isc.AIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.maxRecordsPerBatch=10;
isc.A.$258j=[];
isc.A.recordPickingBatchTimeout=20000;
isc.A.fieldPagingPrompts=[
"A user is interacting with an Isomorphic SmartClient web application.\nThey wish to take the following action - \"${actionDescription}\" - on a data-bound component (such as a ListGrid) based on the following query prompt:",
"${userMessages}",
"The dataSource the component is bound to has a large number of fields, many of which are unlikely to be relevant to the action being performed.\nThe objects in the source-array below represent a subset of these available fields.Using the properties on each field object for the dataSource and your own knowledge, determine which fields are relevant to the user-supplied query prompt.\nFor example, if the query was 'amount is larger than 100', you should look for a field with a name, title or description most related to 'amount'. Note that the user may not use the exact field name or title in their query. For example if the user refers to 'amount' they may be referring to 'quantity', 'price', 'cost' or similar fields. Please return all field objects that could be relevant.\n\nYour response should be an object serialized in JSON format with a single property called 'result'. This property should be set to an array of integers, where each integer is the index of a matching record in the source-array below.  For example, if the first field object in the array below may be relevant to the user's query, your response array must include its source-array index (0) as the first entry.  Similarly, the source-array indices of any other matching field objects must also be in your response array.\n\nIf a field object is not relevant to the query prompt, do not include its index in your response array.\n\nIf no field objects are relevant, the 'result' property in your response object should be set to an empty array.\n\nApart from this object, your response must not include any other preamble or content of any kind."
];
isc.A.$50a=[null,"text","number","object","array"];
isc.A.requestOperationId="createChatCompletion";
isc.A.rateLimitInitialDelay=5000;
isc.A.rateLimitMaxDelay=60000;
isc.A.rateLimitBackoffFactor=2;
isc.A.rateLimitMaxRetries=4;
isc.B.push(isc.A.getRecordsPerPrompt=function isc_AIEngine_getRecordsPerPrompt(_1,_2,_3){
this.$102q(isc.isAn.Array(_1));
var _4=_1;
_2=_2||0;
_3=_3||{};
_3.startIndex=_3.startIndex||0;
var _5={
fixedTokens:isc.isA.Number(parseInt(_2))?parseInt(_2):
this.estimateTokenCount(_2),
responseTokensPerRecord:_3.responseTokensPerRecord,
totalTokens:null,
avgTokens:null,
minTokens:null,
maxTokens:null,
usedTokens:null,
remainingTokens:null
};
var _6=[];
var _7={
status:null,
engineId:this.engineId,
totalRecords:_4.length,
startIndex:_3.startIndex,
numRecords:0,
exactNumRecords:0,
variance:1,
tokenStats:_5,
formatDescription:null,
serializedForm:_6
};
var _8=this.tokenLimit-_5.fixedTokens;
var _9=0;
var _10=_3.serializationFormat||this.serializationFormat;
var _11=_10!="csv";
var _12=_10=="compactJSON";
var _13=(_12?",":(_11?",\n":"\n"));
for(var i=_3.startIndex;i<_4.length;i++){
var _15=_4[i];
var _16={};
_16.record=isc.AI.serializeIndexedRecord(_15,i,_3);
_16.tokenCount=this.estimateTokenCount(_16.record+_13);
if(_7.numRecords==0||_8>=_16.tokenCount){
_6.add(_16);
_7.numRecords++;
_7.exactNumRecords=_7.numRecords;
_9+=_16.tokenCount;
_8-=_16.tokenCount;
if(_8<0){
_7.status="The number of fixed tokens already exceeds the token limit.";
_7.exactNumRecords=0;
break}
}else{
var _17=_16.tokenCount-_8;
_7.exactNumRecords=_7.numRecords+(_17/_16.tokenCount);
break}
if(_3.aiPageSize&&_7.numRecords>=_3.aiPageSize){
break}
}
_5.totalTokens=_9;
_5.minTokens=_6.getProperty("tokenCount").min();
_5.maxTokens=_6.getProperty("tokenCount").max();
_5.avgTokens=Math.ceil(_6.getProperty("tokenCount").sum()/_7.numRecords);
_5.remainingTokens=_8;
_7.variance=_5.maxTokens/_5.minTokens;
return _7}
,isc.A.getBatches=function isc_AIEngine_getBatches(_1,_2,_3){
this.$102q(isc.isAn.Array(_2));
_3=_3||{};
var _4=isc.AI.getFormatDescription(_3);
_1=isc.AIEngine.cloneAIRequest(_1);
if(!_1.messages)_1.messages=[];
_1.messages.push({source:"system",content:_4});
var _5=_1.messages.length-1;
var _6=this.estimateRequestTokenCount(_1);
if(_3.aiPageSize==0)_3.aiPageSize=null;
if(this.maxRecordsPerBatch){
if(!isc.isA.Number(_3.aiPageSize))_3.aiPageSize=this.maxRecordsPerBatch;
else _3.aiPageSize=Math.min(_3.aiPageSize,this.maxRecordsPerBatch)}
var _7=[];
for(var i=0,_9=_2.length;i<_9;){
var _10=isc.addPropertiesWithAssign({},_3);
_10.startIndex=i;
var _11=this.getRecordsPerPrompt(_2,_6,_10);
this.$102q(_11.numRecords>0);
var _12=_11.serializedForm.getProperty("record");
this.$102q(_12.length==_11.numRecords);
var _13=isc.AIEngine.cloneAIRequest(_1);
_13.willHandleError=true;
for(var m=0;m<_5;++m){
var _15=_13.messages[m];
if(_15.source=="system"&&
isc.AIEngine.$272z(_15.type)&&
isc.isA.nonemptyString(_15.content))
{
_15=isc.addPropertiesWithAssign({},_15);
_15.content=_15.content.evalDynamicString(this,_11);
_13.messages[m]=_15}
}
_13.messages[_5]={
source:"system",
content:_4+isc.AI.$2590(_12,_3)
};
_7.push({
aiRequest:_13,
startIndex:i,
length:_11.numRecords,
$270e:_4,
$270f:_12,
$270g:_3
});
i+=_11.numRecords
}
return _7}
,isc.A.splitBatch=function isc_AIEngine_splitBatch(_1){
this.$102q(_1.length>=2);
var _2=_1.startIndex,
_3=_1.length>>1,
_4=_1.startIndex+_3,
_5=_1.length-_3;
this.$102q(_3>=1&&_5>=1);
var _6=_1.aiRequest,
_7=_6.messages.length-1,
_8=_1.$270e,
_9=_1.$270g;
var _10=_1.$270f.slice(0,_3),
_11=isc.AIEngine.cloneAIRequest(_6);
_11.willHandleError=true;
this.$102q(_10.length==_3);
_11.messages[_7]={
source:"system",
content:_8+isc.AI.$2590(_10,_9)
};
var _12=_1.$270f.slice(_3),
_13=isc.AIEngine.cloneAIRequest(_6);
_13.willHandleError=true;
this.$102q(_12.length==_5);
_13.messages[_7]={
source:"system",
content:_8+isc.AI.$2590(_12,_9)
};
return[{
aiRequest:_11,
startIndex:_2,
length:_3,
$270e:_8,
$270f:_10,
$270g:_9
},{
aiRequest:_13,
startIndex:_4,
length:_5,
$270e:_8,
$270f:_12,
$270g:_9
}]}
,isc.A.doPageRecordsPicking=function isc_AIEngine_doPageRecordsPicking(_1,_2,_3,_4){
_4=_4||{};
var _5=this;
var _6=this.$258j;
var _7={
id:"aiTransaction_"+_6.length,
engineId:this.engineId,
postProcessCallback:_3,
progressCallback:_4.progressCallback,
batches:[],
results:[]
};
_6.add(_7);
var _8=_4.cancellationController,
_9=isc.CancellationController.create();
var _10=_2;
if(_10.localData)_10=_10.localData;
var _11=function(_7){
_6.remove(_7);
var _12=[];
for(var i=0;i<_7.batches.length;i++){
var _14=_7.batches[i];
if(_4.keepEmptyMatches){
_5.$102q(_14.result.getLength()==_14.length);
_12.addList(_14.result)}else{
for(var j=0;j<_14.result.length;j++){
var _16=_14.result[j];
var _17=_10.get(_16);
if(_17==null){
_5.logWarn("Unable to find match for index in data: "+_16,"AI")}else{
_12.add(_17)}
}
}
}
_5.logDebug("Completing AI Transaction "+_7.id+", with "+
_7.batches.length+" batches covering "+
_10.length+" total records, and "+_12.length+" matches","AI");
_5.fireCallback(_7.postProcessCallback,"matches,batches",[_12,_7.batches])};
if(!isc.isAn.Array(_10)||_10.length<=0){
this.delayFireCallback(_11,"transaction",[_7]);
return _7}
var _18=0;
var _19=function(_7,_14){
_5.logDebug("Adding batch "+_14.batchId+" to AI-transaction "+_7.id,"AI");
_7.batches.add(_14);
var _20=_14.aiRequest;
_5.sendRequest(_20,function(_29){
_18+=_14.length;
var _21;
if(_29.type!="success"){
_21=[];
_14.nonSuccessfulResult=_29}else{
_21=_29.message&&_29.message.content&&_29.message.content.result;
if(!isc.isAn.Array(_21))_21=[_21]}
if(_4.keepEmptyMatches){
while(_21.length<_14.length){
_21.push(isc.AI.invalidSummaryValue)}
if(_21.length>_14.length)_21.setLength(_14.length)}else{
_21.removeEmpty()}
_14.result.addList(_21);
_7.results.addList(_21);
_14.executing=0;
var _12=_7.results.length;
if(_7.progressCallback){
var _22=_8&&_8.canceled,
_23=_7.progressCallback(_18,_10.length,_12),
_24=!_22&&_23!==false;
if(!_24){
var _25=_22?_8.cancellationReason:"progressCallback() returned `false`.";
if(!_9.canceled){
_9.cancel(_25,"application")}
_5.logDebug("doPageRecordsPicking() transaction "+_7.id+" was canceled by the progressCallback.","AI");
return}
}
if(_7.batches.getProperty("executing").sum()==0){
_11(_7)}
},{
showPrompt:false,
ignoreTokenLimit:true,
requestProperties:{timeout:this.recordPickingBatchTimeout},
maxRetries:_4.maxRetries
})};
var _26={
messages:_1,
responseType:"object",
cancellationController:_9
};
var _27=this.getBatches(_26,_10,_4);
for(var _28=0;_28<_27.length;++_28){
var _14=_27[_28];
isc.addPropertiesWithAssign(_14,{
batchId:_28,
range:[_14.startIndex,_14.startIndex+_14.length-1],
executing:1,
result:[]
});
_19(_7,_14)}
return _7}
,isc.A.shouldUseAIFieldPaging=function isc_AIEngine_shouldUseAIFieldPaging(_1,_2,_3){
if(!isc.AI.useAIFieldPaging)return false;
var _4={
engineId:this.engineId,
fieldNames:_3.salientFieldAttributes||isc.AI.salientFieldAttributes,
serializationFormat:_3.serializationFormat
};
var _5=this.estimateRequestTokenCount(_1);
var _6=this.getRecordsPerPrompt(_2,_5,_4);
return(_6.totalRecords>_6.numRecords)}
,isc.A.retrieveFieldsForPrompt=function isc_AIEngine_retrieveFieldsForPrompt(_1,_2,_3,_4,_5,_6){
var _7=isc.InternalAIMessagesBuilder.create({
userMessages:_1,
target:this,
evalVars:{
actionDescription:_2
}
});
_7.appendPrompts(this.fieldPagingPrompts);
_5=_5||{};
var _8=_5.progressCallback;
var _9=_5.aiPageSize;
if(_9==0)_9=null;
var _10=_6&&_6.salientFieldAttributes;
if(_10==null)_10=isc.AI.salientFieldAttributes;
var _11={
engineId:this.engineId,
fieldNames:_10,
aiPageSize:_9,
progressCallback:_8
};
this.doPageRecordsPicking(_7.aiMessages,_3,function(_12){
isc.AI.fireCallback(_4,"finalFields",[_12])},_11)}
,isc.A.asyncRetrieveFieldsForPrompt=function isc_AIEngine_asyncRetrieveFieldsForPrompt(_1,_2,_3,_4,_5){
var _6=Promise.withResolvers();
this.retrieveFieldsForPrompt(_1,_2,_3,function(_7){
_6.resolve(_7)},_4,_5);
return _6.promise}
,isc.A.estimateTokenCount=function isc_AIEngine_estimateTokenCount(_1){
_1=_1||"";
var _2=_1.trim().split(/\s/);
var _3=3;
var _4=0;
for(var i=0;i<_2.length;i++){
var _6=_2[i].split(/\W/);
_4+=_6.length-1;
for(var _7=0;_7<_6.length;_7++){
_4+=Math.max(1,_6[_7].length/_3)}
}
return Math.ceil(_4)}
,isc.A.estimateMessageTokenCount=function isc_AIEngine_estimateMessageTokenCount(_1){
if(_1.type=="jpegImage"||_1.type=="pngImage"){
return 1000}
var _2=_1.content;
if((_1.type=="array"||_1.type=="object")&&
!isc.isA.String(_2)&&
isc.isAn.Object(_2))
{
_2=isc.AI.$260x(_2)}
return this.estimateTokenCount(String(_2))}
,isc.A.estimateRequestTokenCount=function isc_AIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
var _2=this.makePromptText(_1);
return this.estimateTokenCount(_2)}
,isc.A.getTokenLimit=function isc_AIEngine_getTokenLimit(_1){
return this.tokenLimit}
,isc.A.couldSupportRequest=function isc_AIEngine_couldSupportRequest(_1){
_1=this.normalizeRequest(_1);
if(!this.$50a.contains(_1.responseType)){
return false}
const _2=_1.messages,
_3=this.canSupportVisionRequests();
if(_2!=null){
for(var i=0;i<_2.length;++i){
var _5=_2[i];
if(this.$50a.contains(_5.type)){
continue}
if(_3&&isc.AIEngine.$2720(_5.type)){
continue}
return false}
}
var _6=this.estimateRequestTokenCount(_1);
if(_6>this.getTokenLimit(_1)){
return false}
return true}
,isc.A.canSupportVisionRequests=function isc_AIEngine_canSupportVisionRequests(){
return false}
,isc.A.sendRequest=function isc_AIEngine_sendRequest(_1,_2,_3){
_3=isc.addPropertiesWithAssign({retryIndex:0},_3);
var _4=this.transformRequest(_1,_3);
this.handleSendRequest(_4,_1,_2,_3)}
,isc.A.asyncSendRequest=function isc_AIEngine_asyncSendRequest(_1,_2){
_1.$281m=_1.willHandleError;
_1.willHandleError=true;
const _3=Promise.withResolvers();
this.sendRequest(_1,function(_4,_1,_2,_5,_6){
_1.willHandleError=_1.$281m;
_4.$294d=_5;
_4._dsRequest=_6;
if(_4.type=="success")_3.resolve(_4);
else _3.reject(_4)},_2);
if(!_1.$281m){
return _3.promise
.$274g(function(_7){
const _4=isc.defaultAsyncOperationCatchCallback(_7),
_5=_4.$294d||{},
_6=_4._dsRequest||{};
if(!(_5.status<0)){
_5.status=isc.DSResponse.STATUS_FAILURE;
_5.data=isc.getAsyncMessage(_4)}
if(_4.type!="canceled"||_4.cancellationInitiator!="user"){
isc.RPCManager.$a0(_5,_6)}
return null},
this)}else{
return _3.promise}
}
,isc.A.normalizeRequest=function isc_AIEngine_normalizeRequest(_1){
if(_1.$260u)return _1;
var _2=_1.messages;
var _3=false;
var _4=function(){
_1=isc.addProperties({},_1);
_2=_1.messages=(_2==null?null:_2.duplicate());
_3=true}
if(_2!=null){
for(var i=0;i<_2.length;++i){
var _6=_2[i],
_7=false;
if(_6.source==null||
(_6.source!="system"&&_6.source!="user"&&_6.source!="AI"))
{
if(_6.source!=null){
this.logWarn("Unrecognized AIMessageSource '"+_6.source+"'. Changing to 'user'","AI")}
if(!_3)_4();
if(!_7){
_6=_2[i]=isc.addProperties({},_6);
_7=true}
_6.source="user"}
if(_6.type=="number"&&!isc.isA.String(_6.content)){
if(!_3)_4();
if(!_7){
_6=_2[i]=isc.addProperties({},_6);
_7=true}
_6.content=String(_6.content);
delete _6.type}
if((_6.type=="object"||_6.type=="array")&&
!isc.isA.String(_6.content)&&
isc.isAn.Object(_6.content))
{
if(!_3)_4();
if(!_7){
_6=_2[i]=isc.addProperties({},_6);
_7=true}
_6.content=isc.AI.$260x(_6.content);
delete _6.type}
}
}
if(_1.prompt!=null){
if(!_3)_4();
_1.$260n=_1.prompt;
if(_2==null){
_2=_1.messages=[]}
_2.push({source:"user",content:_1.prompt});
delete _1.prompt}
if(_1.responseType=="number"){
if(!_3)_4();
if(_2==null){
_2=_1.messages=[]}
var _8="Your response must only be a number";
if(_1.responseMinimum!=null){
if(_1.responseMaximum!=null){
_8+=(" between "+_1.responseMinimum+" and "+
_1.responseMaximum+" inclusive.")}else{
_8+=" at least "+_1.responseMinimum+"."}
}else if(_1.responseMaximum!=null){
_8+=" no more than "+_1.responseMaximum+"."}else{
_8+="."}
_2.push({source:"system",content:_8});
delete _1.responseType}
if(_1.responseType=="array"||_1.responseType=="object"){
var _9=false;
if(_2!=null){
for(var i=0;i<_2.length;++i){
var _6=_2[i];
if(isc.AIEngine.$272z(_6.type)&&
/JSON/i.test(_6.content))
{
_9=true;
break}
}
}
if(!_9){
if(!_3)_4();
if(_2==null){
_2=_1.messages=[]}
_2.push({
source:"system",
content:"Your response must only be a JSON "+_1.responseType+"."
})}
}
_1.$260u=true;
return _1}
,isc.A.getTemperature=function isc_AIEngine_getTemperature(_1){
return(_1&&_1.temperature!=null?_1.temperature:this.temperature)}
,isc.A.makeNonTextPromptPart=function isc_AIEngine_makeNonTextPromptPart(_1){
return"*non-text content*\n"}
,isc.A.makePromptParts=function isc_AIEngine_makePromptParts(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
var _2=isc.addProperties({},isc.AIEngine.defaultHistoryDelimiters,_1.historyDelimiters);
var _3=[],
_4=_1.messages;
var _5=(function(_15){
this.$102q(_3.length>0);
var _6=_3[_3.length-1];
if(!isc.isA.String(_6))return true;
return _6.endsWith(_15)}).bind(this);
var _7=function(_15){
if(isc.isA.String(_15)&&
_3.length>0&&
isc.isA.String(_3[_3.length-1]))
{
_3[_3.length-1]+=_15}else{
_3.push(_15)}
};
if(_4!=null){
var _8=(function(_14){
if(_3.length>0){
var _9=String(_2["system"]);
if(_14.source=="system"&&!_5(_9)){
_7(_9)}else if(!_5('\n')){
_7("\n")}
}
if(!isc.AIEngine.$272z(_14.type)){
_7(this.makeNonTextPromptPart(_14))}else{
_7(String(_14.content))}
}).bind(this);
var _10=0;
for(;_10<_4.length;++_10){
var i=_10;
if(_4[i].source!="system"){
break}
_8(_4[i])}
var i=_10,
_12=_4.length;
for(;_12>i&&_4[_12-1].source=="system";--_12){}
if(i<_12){
var _13=_4[_12-1].source;
this.$102q(_13!="system");
for(;_12-1>i&&(_4[_12-1-1].source=="system"||
_4[_12-1-1].source==_13);--_12)
{
}
}
if(i<=_12-2){
_8({
source:"system",
content:(_1.historyIntroduction!=null
?_1.historyIntroduction
:isc.AIEngine.defaultHistoryIntroduction)
});
for(;i<_12-1;++i){
var _14=_4[i],
_9=String(_2[_14.source||"user"]);
if(_14.source!="system"){
if(_3.length>0&&!_5("\n"))_7("\n");
_7(_9)}
_8(_14);
if(_14.source!="system"){
if(_3.length>0&&!_5("\n"))_7("\n");
_7(_9)}
}
_8({
source:"system",
content:(_1.historyConclusion!=null
?_1.historyConclusion
:isc.AIEngine.defaultHistoryConclusion)
})}
for(;i<_4.length;++i){
_8(_4[i])}
}
return _3}
,isc.A.makePromptText=function isc_AIEngine_makePromptText(_1){
var _2=this.makePromptParts(_1);
return _2.join("")}
,isc.A.transformRequest=function isc_AIEngine_transformRequest(_1,_2){
_1=this.normalizeRequest(_1);
var _3=this.makePromptText(_1);
if(!_2.ignoreTokenLimit&&this.tokenLimit!=null){
var _4=this.estimateTokenCount(_3);
if(_4>this.tokenLimit){
this.logWarn("Approximate token count for prompt text is: "+_4+
". This exceeds the token limit for the ai engine: "+this.name+
". This request may be rejected by the AI server (proceeding anyway).","AI")}else{
this.logDebug("Estimated token count for prompt is: "+_4,"AI")}
}
return{
engineId:this.engineId,
model:this.model,
temperature:this.getTemperature(_1),
text:_3
}}
,isc.A.getDataSourceName=function isc_AIEngine_getDataSourceName(_1){
return this.dataSourceName||isc.AI.dataSourceName}
,isc.A.$2500=function isc_AIEngine__getDataSource(_1,_2,_3,_4){
var _5=isc.AI.$2500(this.engineId,_2),
_6=this.getDataSourceName(_2);
if(_5==null&&_6){
if(isc.AI.autoLoadDataSource&&!isc.AI.$257k[_6]){
isc.AI.$260m.push({
engine:this,
dataSourceName:_6,
rawRequest:_1,
aiRequest:_2,
callback:_3,
config:_4
});
isc.AI.loadDataSource(_6)}else{
this.logWarn("No AI DataSource configured","AI")}
}
return _5}
,isc.A.handleSendRequest=function isc_AIEngine_handleSendRequest(_1,_2,_3,_4){
const _5={
operationId:this.requestOperationId,
willHandleError:true,
clientContext:_4.context,
showPrompt:!!_4.showPrompt
};
if(_4.requestProperties!=null){
isc.addPropertiesWithAssign(_5,_4.requestProperties)}
const _6=this.$2500(_1,_2,_3,_4);
if(!_6){
const _7=this.getDataSourceName(_2);
if(!isc.AI.$257l[_7]&&!isc.AI.$257k[_7]){
const _8={
type:"error",
errorMessage:"DataSource '"+String(_7).asHTML()+"' was not found or could not be loaded to make an AI request."
};
this.delayCall("$294e",[_2,_3,_4,_5,null,_8])}
return}
if(_2.cancellationController&&_2.cancellationController.canceled){
const _8=_2.cancellationController.asCanceledResult();
this.delayCall("$294e",[_2,_3,_4,_5,null,_8]);
return}
if(this.logIsDebugEnabled("AI")){
this.logDebug("Prompt text to send to AI: "+this.makePromptText(_2),"AI")}
var _9=_4.responseSpoofingMode||isc.AI.responseSpoofingMode;
if(_9!="none"){
var _10=isc.AI.getSpoofedResponse(_2,this);
if(_10!=null||_9=="full"){
this.logDebug("* Using a spoofed response for the current interaction. responseSpoofingMode is \""+_9+"\". *","AI");
_5.dataProtocol="clientCustom";
if(_5.clientContext==null){
_5.clientContext={}}
_5.clientContext.dataSource=_6;
_5.clientContext.aiEngine=this;
_5.clientContext.aiRequest=_2;
_5.clientContext.spoofingMode=_9;
_5.clientContext.spoofedResponse=_10}
}
const _11=this;
_6.fetchData(
_1,
function(_22,_23,_5){
var _12,
_13;
if(_2.cancellationController&&_2.cancellationController.canceled){
_12=_2.cancellationController.asCanceledResult()}else{
if(_22.$260o&&(_23.makeAIResponse||_23.aiResponse)){
_12=_23.makeAIResponse?_23.makeAIResponse(_2,_11):_23.aiResponse;
_13=_23.makeErrorResponseInfo?_23.makeErrorResponseInfo(_2,_11):_23.errorResponseInfo}else{
var _14=(_22.$260o?_11.makeSpoofedRawResponse(_2,_23.value):_22.completeData||_23);
if(_22.status<0||_11.isErrorResponse(_14,_2)){
_13=_11.getErrorResponseInfo(_14,_1,_2,_4);
_12=isc.createErrorResult(_13&&_13.errorMessage)}else{
_12=_11.transformRawResponse(_14,_1,_2,_4)}
}
var _15=_5.clientContext||{};
if(isc.AI.captureTransactions&&!_15.doNotCapture){
if(!_2){
this.logWarn("Failed to capture transaction at index:"+isc.AI.captureTransactions.length+"\n"+this.echo(_5))}else{
var _16=_11.makePromptText(_2);
var _17=_12.messageText;
isc.AI.captureTransaction({
aiRequest:isc.addProperties({},_2),
aiResponse:isc.addProperties({},_12),
prompt:_16,
value:_17
})}
}
if(_12.type!="success"){
var _18=_13&&_13.errorType;
if(_18)_12.errorType=_18;
var _19=Math.max(0,+_4.retryIndex);
if(isNaN(_19))_19=0;
var _20=Math.max(0,_4.maxRetries!=null?_4.maxRetries:
isc.AI.defaultMaxRetries);
if(isNaN(_20))_20=0;
if(_19>=_20){
_12=isc.createErrorResult("Exceeded the maximum number of retries ("+
_20+").",{lastAIResponse:_12})}else if(_13&&_13.recoverable){
var _21=_13.retryDelay||isc.AI.sendPromptRetryDelay;
_1=_13.newRawRequest||_1;
_4.retryIndex=_19+1;
if(!_4.$2883){
_4.$2883=_5.requestId}
_11.logDebug("Delaying original "+_4.$2883+" for "+
_21+"ms due to rate limiting.  Attempt "+
_4.retryIndex+" / "+_4.maxRetries,"AI");
_11.delayCall("handleSendRequest",[_1,_2,_3,_4],
_21);
return}
}
}
_12=_11.normalizeResponse(_12,_2,_4);
_11.$294e(_2,_3,_4,_5,_22,_12)},
_5
)}
,isc.A.$294e=function isc_AIEngine___handleAIResponse(_1,_2,_3,_4,_5,_6){
if(_1.willHandleError||_6.type=="success"){
this.fireCallback(_2,isc.AIEngine.$2889,[_6,_1,_3,_5,_4])}else if(_6.type!="canceled"||_6.cancellationInitiator!="user"){
if(!_5)_5={};
if(!(_5.status<0)){
_5.status=isc.DSResponse.STATUS_FAILURE;
_5.data=isc.getAsyncMessage(_6)}
isc.RPCManager.$a0(_5,_4)}
}
,isc.A.makeSpoofedRawResponse=function isc_AIEngine_makeSpoofedRawResponse(_1,_2){
return[{
chat_role:"assistant",
chat_content:_2
}]}
,isc.A.isErrorResponse=function isc_AIEngine_isErrorResponse(_1,_2){
return!_1||isc.isA.String(_1)||!!_1.error}
,isc.A.getErrorResponseInfo=function isc_AIEngine_getErrorResponseInfo(_1,_2,_3){
if(isc.isA.String(_1)){
var _4=isc.AI._extractJsonResult(_1);
if(_4&&_4.error)_1=_4;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1||!_1.error)return null;
return{errorMessage:_1.error.message}}
,isc.A.extractAIMessage=function isc_AIEngine_extractAIMessage(_1,_2,_3){
var _4="text";
if(_3.responseType=="array"||_3.responseType=="object"){
var _5=_1.indexOf("```");
if(_5>=0){
if(_1.indexOf("```json",_5)>=0){
_1=isc.AI._extractJsonResult(_1,"```json","```",true)}else{
_1=isc.AI._extractJsonResult(_1,"```","```",true)}
}else if(_3.responseType=="array"&&_1.indexOf("[")>=0){
_1=isc.AI._extractJsonResult(_1,"[","]")}else{
_1=isc.AI._extractJsonResult(_1)}
_4=isc.isAn.Array(_1)?"array":"object"}
return{source:"AI",content:_1,type:_4}}
,isc.A.transformRawResponse=function isc_AIEngine_transformRawResponse(_1,_2,_3,_4){
var _5=isc.isAn.Array(_1)&&_1[0]&&_1[0].chat_content;
if(!isc.isA.String(_5)){
var _6="Unable to extract the message from the AI response";
this.logWarn(_6,"AI");
return isc.createErrorResult(_6)}
this.logDebug("Response text from AI: "+_5,"AI");
return{
type:"success",
message:this.extractAIMessage(_5,_2,_3),
messageText:_5
}}
,isc.A.normalizeResponse=function isc_AIEngine_normalizeResponse(_1,_2,_3){
if(!_1)_1={};
if(_1.type==null||_1.type=="error"){
_1.type="error"}else{
var _4=_1.message;
if(_4){
var _5=_2.responseType||"text";
if(_5=="array"){
if(!isc.isAn.Array(_4.content)){
_4.content=[_4.content];
_4.type="array"}
}else if(_5=="object"){
if(!isc.isAn.Object(_4.content)||isc.isAn.Array(_4.content)){
_4.content={result:_4.content};
_4.type="object"}
}else if(_5=="number"){
_4.content=Number(_4.content);
if(_2.responseMinimum!=null){
_4.content=Math.max(_2.responseMinimum,_4.content)}
if(_2.responseMaximum!=null){
_4.content=Math.min(_4.content,_2.responseMaximum)}
_4.type="number"}
}
}
return _1}
);
isc.B._maxIndex=isc.C+31;
isc.A=isc.AIEngine.getPrototype();
isc.A.temperature=0.7;
isc.A.tokenLimit=4096
;
isc.defineClass("BaseOpenAIEngine",isc.AIEngine);
isc.A=isc.BaseOpenAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="OpenAI";
isc.A.dataSourceName="openAIRestConnector";
isc.A.requestOperationId="fetch";
isc.A.tokenLimit=4096;
isc.A.supportsJSONMode=false;
isc.A.supportsStructuredOutputs=false;
isc.A.rateLimitInstructOffset=5000;
isc.A.rateLimitDelayMode="backoff";
isc.B.push(isc.A.estimateRequestTokenCount=function isc_BaseOpenAIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
var _2=0,
_3=_1.messages;
if(_3!=null){
for(var i=0;i<_3.length;++i){
_2+=this.estimateMessageTokenCount(_3[i])}
}
return _2}
,isc.A.$277z=function isc_BaseOpenAIEngine__mapAIMessageSourceToRole(_1){
if(!_1)return"user";
return _1=="AI"?"assistant":_1}
,isc.A.transformRequest=function isc_BaseOpenAIEngine_transformRequest(_1){
_1=this.normalizeRequest(_1);
var _2=this.canSupportVisionRequests()&&isc.AIEngine.isVisionRequest(_1);
var _3={
model:_2&&this.visionModel?this.visionModel:this.model||this.engineId,
temperature:this.getTemperature(_1),
messages:null
};
var _4=_1.messages;
if(_4!=null){
var _5=_3.messages=new Array(_4.length);
for(var i=0;i<_5.length;++i){
var _7=_4[i];
_5[i]={
role:this.$277z(_7.source),
content:null
};
if(_2&&isc.AIEngine.isImageMessage(_7)){
_5[i].content=[{
type:"image_url",
image_url:{
url:"data:image/"+(_7.type=="jpegImage"?"jpeg":"png")+";base64,"+_7.content
}
}]}else if(!isc.AIEngine.$272z(_7.type)){
_5[i].content=this.makeNonTextPromptPart(_7)}else{
_5[i].content=String(_7.content)}
}
}
if(this.supportsJSONMode){
if(_1.responseType=="object"&&
_1.responseType!="array")
{
_3.response_format={type:"json_object"}}
}
if(this.seed!=null)_3.seed=this.seed;
return _3}
,isc.A.makeSpoofedRawResponse=function isc_BaseOpenAIEngine_makeSpoofedRawResponse(_1,_2){
return{
choices:[{
finish_reason:"stop",
index:0,
message:{
content:_2,
role:"assistant"
}
}]
}}
,isc.A.extractAIMessage=function isc_BaseOpenAIEngine_extractAIMessage(_1,_2,_3){
if((_1.contains('{')||_1.contains('['))&&
_2&&_2.response_format&&_2.response_format.type=="json_object")
{
try{
_1=isc.JSON.decode(_1);
var _4=isc.isAn.Array(_1)?"array":"object";
return{source:"AI",content:_1,type:_4}}catch(e){
this.logWarn("JSON mode was enabled, but the response did not parse as JSON: "+e,"AI")}
}
return this.Super("extractAIMessage",arguments)}
,isc.A.getErrorResponseInfo=function isc_BaseOpenAIEngine_getErrorResponseInfo(_1,_2,_3,_4){
if(isc.isA.String(_1)){
var _5=isc.AI._extractJsonResult(_1);
if(_5&&_5.error)_1=_5;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1||!_1.error)return null;
var _6={errorMessage:_1.error.message};
var _7=_4.rateLimitDelayMode||this.rateLimitDelayMode;
if(_1.error.code=="rate_limit_exceeded"&&_7!="none"){
if(!_4.retryIndex){
if(!_4.maxRetries)_4.maxRetries=this.rateLimitMaxRetries}
switch(_7){
case"instruct":
var _8=_1.error.message;
if(_8){
var _9=_8.match(/token.*limit.*please try again in ([0-9.]+)s/i);
if(_9){
_6.retryDelay=Math.ceil(parseFloat(_9[1])*1000)+
this.rateLimitInstructOffset,
_6.recoverable=true}
}
break;
case"backoff":
if(_4.retryDelay)_4.retryDelay*=this.rateLimitBackoffFactor;
else _4.retryDelay=this.rateLimitInitialDelay;
if(_4.retryDelay>this.rateLimitMaxDelay){
_4.retryDelay=this.rateLimitMaxDelay}
_6.retryDelay=_4.retryDelay;
_6.recoverable=true;
break}
}
return _6}
,isc.A.transformRawResponse=function isc_BaseOpenAIEngine_transformRawResponse(_1,_2,_3){
var _4={type:"error"};
if(!_1){
_4.errorMessage="The response was empty."}else if(_1.error){
_4.errorMessage=_1.error.message}else{
var _5=isc.isAn.Array(_1.choices)&&_1.choices[0];
var _6=_5&&_5.message&&_5.message.content;
if(!isc.isA.String(_6)){
this.logWarn(_4.errorMessage="Unable to extract the message from the AI response","AI")}else{
this.logDebug("Response text from AI: "+_6,"AI");
_4.type="success";
_4.message=this.extractAIMessage(_6,_2,_3);
_4.messageText=_6}
}
return _4}
);
isc.B._maxIndex=isc.C+7;
isc.defineClass("OpenAIReasoningEngine",isc.MultimodalGPTEngine);
isc.A=isc.OpenAIReasoningEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.tokenLimit=200000-25000;
isc.B.push(isc.A.transformRequest=function isc_OpenAIReasoningEngine_transformRequest(_1){
var _2=this.Super("transformRequest",arguments);
_2.max_completion_tokens=25000;
return _2}
);
isc.B._maxIndex=isc.C+1;
isc.defineClass("MultimodalGPTEngine",isc.BaseOpenAIEngine);
isc.A=isc.MultimodalGPTEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.tokenLimit=128000;
isc.B.push(isc.A.canSupportVisionRequests=function isc_MultimodalGPTEngine_canSupportVisionRequests(){
return true}
,isc.A.estimateMessageTokenCount=function isc_MultimodalGPTEngine_estimateMessageTokenCount(_1){
if(isc.AIEngine.isImageMessage(_1)){
return 85}
return this.Super("estimateMessageTokenCount",arguments)}
);
isc.B._maxIndex=isc.C+2;
isc.defineClass("GeminiProAIEngine",isc.AIEngine);
isc.A=isc.GeminiProAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.name="Gemini Pro";
isc.A.provider="Google";
isc.A.tokenLimit=30720;
isc.A.visionTokenLimit=12288;
isc.A.requestOperationId="fetch";
isc.A.dataSourceName="geminiProRestConnector";
isc.A.visionDataSourceName="geminiProVisionRestConnector";
isc.B.push(isc.A.canSupportVisionRequests=function isc_GeminiProAIEngine_canSupportVisionRequests(){
return true}
,isc.A.estimateRequestTokenCount=function isc_GeminiProAIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
if(isc.AIEngine.isVisionRequest(_1)){
var _2=this.makePromptParts(_1),
_3=0;
for(var i=0;i<_2.length;++i){
var _5=_2[i];
if(isc.isA.String(_5)){
_3+=this.estimateTokenCount(_5)}
}
return _3}
var _3=0,
_6=_1.messages;
if(_6!=null){
for(var i=0;i<_6.length;++i){
_3+=this.estimateMessageTokenCount(_6[i])}
}
return _3}
,isc.A.getTokenLimit=function isc_GeminiProAIEngine_getTokenLimit(_1){
return(isc.AIEngine.isVisionRequest(_1)?this.visionTokenLimit:this.tokenLimit)}
,isc.A.getDataSourceName=function isc_GeminiProAIEngine_getDataSourceName(_1){
return(isc.AIEngine.isVisionRequest(_1)?this.visionDataSourceName:this.dataSourceName)}
,isc.A.makeNonTextPromptPart=function isc_GeminiProAIEngine_makeNonTextPromptPart(_1){
if(isc.AIEngine.isImageMessage(_1)){
return{
inlineData:{
mimeType:isc.AIEngine.$269b(_1),
data:_1.content
}
}}
return this.Super("makeNonTextPromptPart",arguments)}
,isc.A.makePromptParts=function isc_GeminiProAIEngine_makePromptParts(_1){
_1=this.normalizeRequest(_1);
var _2=_1.messages,
_3=0,
_4;
if(_2!=null&&
_2.length>0&&
isc.AIEngine.isImageMessage(_4=_2[_2.length-1]))
{
for(var _5=_2.length;_5>0;--_5){
var _6=_2[_5-1];
if(!isc.AIEngine.isImageMessage(_6)||
_4.source!=_6.source)
{
break}
++_3}
}
if(_3==0||_3==_2.length){
return this.Super("makePromptParts",[_1])}
var _7=_2.duplicate();
_7.setLength(_7.length-_3);
var _8=_7[_7.length-1];
if(_8.source!=_4.source){
_7.push({source:_4.source,content:""})}
var _9;
try{
_1.messages=_7;
_9=this.Super("makePromptParts",[_1])}finally{
_1.messages=_2}
for(var i=0;i<_3;++i){
_9.push(this.makeNonTextPromptPart(_2[_2.length-_3+i]))}
return _9}
,isc.A.transformRequest=function isc_GeminiProAIEngine_transformRequest(_1){
_1=this.normalizeRequest(_1);
var _2=_1.messages;
var _3={
contents:null,
generationConfig:{
temperature:this.getTemperature(_1)
}
};
if(isc.AIEngine.isVisionRequest(_1)){
var _4=this.makePromptParts(_1);
for(var i=0;i<_4.length;++i){
if(isc.isA.String(_4[i])){
_4[i]={text:String(_4[i])}}
}
_3.contents=[{parts:_4,role:"user"}]}else if(_2!=null){
var _6=_3.contents=[];
for(var _7=0;_7<_2.length;++_7){
var _8=_2[_7];
this.$102q(!isc.AIEngine.isImageMessage(_8));
var _9={text:String(_8.content)};
var _10=(_8.source=="AI"?"model":"user");
if(_6.length>0&&_6[_6.length-1].role==_10){
_6[_6.length-1].parts.push(_9)}else{
_6.push({
parts:[_9],
role:_10
})}
}
}
return _3}
,isc.A.isErrorResponse=function isc_GeminiProAIEngine_isErrorResponse(_1,_2){
if(!_1)return true;
var _3=_1.promptFeedback;
if(_3&&_3.blockReason)return true;
var _4=_1.candidates;
if(!isc.isAn.Array(_4)||_4.length==0)return true;
return _4[0].finishReason!="STOP"}
,isc.A.getErrorResponseInfo=function isc_GeminiProAIEngine_getErrorResponseInfo(_1,_2,_3){
if(isc.isA.String(_1)){
var _4=isc.AI._extractJsonResult(_1);
if(_4&&_4.finishReason)_1=_4;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1)return null;
var _5,
_6;
var _7=_1.promptFeedback,
_8=_1.candidates;
if(_7&&_7.blockReason){
if(_7.blockReason=="SAFETY"){
_5="The request was deemed unsafe.";
_6="requestUnsafe"}else{
var _9=_1.usageMetadata;
if(_9&&
isc.isA.Number(_9.promptTokenCount)&&
_9.promptTokenCount>this.getTokenLimit(_3))
{
_5="The request contained too many tokens.";
_6="requestSizeLimitExceeded"}else{
_5="The request was blocked for an unspecified reason."}
}
}else if(!isc.isAn.Array(_8)||_8.length==0){
_5="No candidates were generated."}else{
var _10=_8[0].finishReason;
if(_10=="MAX_TOKENS"){
_5="The response contained too many tokens.";
_6="responseSizeLimitExceeded"}else if(_10=="SAFETY"){
_5="The response was blocked for safety reasons.";
_6="responseUnsafe"}else if(_10=="RECITATION"){
_5="The response was blocked for recitation reasons."}else{
_5="The first candidate's finishReason was: "+_10}
}
return{
errorMessage:_5,
errorType:_6
}}
,isc.A.makeSpoofedRawResponse=function isc_GeminiProAIEngine_makeSpoofedRawResponse(_1,_2){
if(_1.responseType=="array"||_1.responseType=="object"){
_2="```json\n"+_2+"\n```"}
return{
candidates:[{
content:{
parts:[{
text:_2
}],
role:"model"
},
finishReason:"STOP"
}]
}}
,isc.A.transformRawResponse=function isc_GeminiProAIEngine_transformRawResponse(_1,_2,_3){
var _4={type:"error"};
var _5=_1&&isc.isAn.Array(_1.candidates)&&_1.candidates[0];
var _6=_5&&_5.content&&_5.content.parts;
if(_6==null||_6.length==0){
this.logWarn(_4.errorMessage="Unable to extract the message from the AI response","AI")}else{
var _7="";
if(_6.length>1)this.logWarn(_6.length+" parts were in the AI response","AI");
for(var i=0;i<_6.length;++i){
var _9=_6[i];
if(!("text"in _9)){
this.logWarn("message part was not text: "+isc.JSON.encode(_9),"AI")}else{
_7=(_7!=""?"\n":"")+_9.text}
}
this.logDebug("Response text from AI: "+_7,"AI");
_4.type="success";
_4.message=this.extractAIMessage(_7,_2,_3);
_4.messageText=_7}
return _4}
);
isc.B._maxIndex=isc.C+11;
isc.defineClass("BedrockAIEngine",isc.AIEngine);
isc.A=isc.BedrockAIEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="Amazon";
isc.A.dataSourceName="bedrockRestConnector";
isc.A.requestOperationId="fetch";
isc.A.tokenLimit=8192;
isc.A.supportsJSONMode=false;
isc.A.supportsStructuredOutputs=false;
isc.B.push(isc.A.canSupportVisionRequests=function isc_BedrockAIEngine_canSupportVisionRequests(){
return true}
,isc.A.estimateRequestTokenCount=function isc_BedrockAIEngine_estimateRequestTokenCount(_1){
_1=this.normalizeRequest(_1);
this.$102q(_1.prompt==null);
if(isc.AIEngine.isVisionRequest(_1)){
var _2=this.makePromptParts(_1),
_3=0;
for(var i=0;i<_2.length;++i){
var _5=_2[i];
if(isc.isA.String(_5)){
_3+=this.estimateTokenCount(_5)}
}
return _3}
var _3=0,
_6=_1.messages;
if(_6!=null){
for(var i=0;i<_6.length;++i){
_3+=this.estimateMessageTokenCount(_6[i])}
}
return _3}
,isc.A.getTokenLimit=function isc_BedrockAIEngine_getTokenLimit(_1){
return(isc.AIEngine.isVisionRequest(_1)?this.visionTokenLimit:this.tokenLimit)}
,isc.A.getDataSourceName=function isc_BedrockAIEngine_getDataSourceName(_1){
return this.dataSourceName}
,isc.A.makeNonTextPromptPart=function isc_BedrockAIEngine_makeNonTextPromptPart(_1){
if(isc.AIEngine.isImageMessage(_1)){
return{
inlineData:{
mimeType:isc.AIEngine.$269b(_1),
data:_1.content
}
}}
return this.Super("makeNonTextPromptPart",arguments)}
,isc.A.makePromptParts=function isc_BedrockAIEngine_makePromptParts(_1){
_1=this.normalizeRequest(_1);
var _2=_1.messages,
_3=0,
_4;
if(_2!=null&&
_2.length>0&&
isc.AIEngine.isImageMessage(_4=_2[_2.length-1]))
{
for(var _5=_2.length;_5>0;--_5){
var _6=_2[_5-1];
if(!isc.AIEngine.isImageMessage(_6)||
_4.source!=_6.source)
{
break}
++_3}
}
if(_3==0||_3==_2.length){
return this.Super("makePromptParts",[_1])}
var _7=_2.duplicate();
_7.setLength(_7.length-_3);
var _8=_7[_7.length-1];
if(_8.source!=_4.source){
_7.push({source:_4.source,content:""})}
var _9;
try{
_1.messages=_7;
_9=this.Super("makePromptParts",[_1])}finally{
_1.messages=_2}
for(var i=0;i<_3;++i){
_9.push(this.makeNonTextPromptPart(_2[_2.length-_3+i]))}
return _9}
,isc.A.$277z=function isc_BedrockAIEngine__mapAIMessageSourceToRole(_1){
if(!_1)return"user";
return _1=="AI"?"assistant":_1}
,isc.A.transformRequest=function isc_BedrockAIEngine_transformRequest(_1){
_1=this.normalizeRequest(_1);
var _2=this.canSupportVisionRequests()&&isc.AIEngine.isVisionRequest(_1);
var _3={
model:_2&&this.visionModel?this.visionModel:this.model||this.engineId,
temperature:this.getTemperature(_1),
messages:null
};
var _4=[];
var _5=_1.messages;
if(_5!=null){
var _6=_3.messages=[];
var m=0;
for(var i=0;i<_5.length;++i){
var _9=_5[i];
var _10=this.$277z(_9.source);
if(_10=="system"){
_4[_4.length]={text:_9.content}}else{
_6[m]={
role:_10,
content:null
};
if(_2&&isc.AIEngine.isImageMessage(_9)){
_6[m].content=[{
image:{
format:isc.AIEngine.getImageFormat(_9.type),
source:{
bytes:_9.content
}
}
}]}else if(!isc.AIEngine.$272z(_9.type)){
_6[m].content=this.makeNonTextPromptPart(_9)}else{
_6[m].content=[];
_6[m].content[0]={
text:String(_9.content)
}}
m++}
}
}
if(_4.length>0){
_3.system=_4}
if(this.supportsJSONMode){
if(_1.responseType=="object"&&
_1.responseType!="array")
{
_3.response_format={type:"json_object"}}
}
if(this.seed!=null)_3.seed=this.seed;
return _3}
,isc.A.isErrorResponse=function isc_BedrockAIEngine_isErrorResponse(_1,_2){
if(!_1)return true;
var _3;
try{
_3=_1.output.message.content}catch(e){
return true}
if(!isc.isAn.Array(_3)||_3.length==0)return true;
if(!_3[0].text)return true;
return _1.stopReason!="end_turn"}
,isc.A.getErrorResponseInfo=function isc_BedrockAIEngine_getErrorResponseInfo(_1,_2,_3,_4){
if(isc.isA.String(_1)){
var _5=isc.AI._extractJsonResult(_1);
if(_5&&_5.message)_1=_5;
else return{errorMessage:"An error occurred. The response from the server was: "+_1}}else if(!_1||!_1.message)return null;
var _6={errorMessage:_1.message};
var _7=_6.errorMessage.indexOf("wait")!=-1&&
_6.errorMessage.indexOf("try")!=-1&&
_6.errorMessage.indexOf("again")!=-1;
if(_7){
if(!_4.retryIndex){
if(!_4.maxRetries)_4.maxRetries=this.rateLimitMaxRetries}
if(_4.retryDelay)_4.retryDelay*=this.rateLimitBackoffFactor;
else _4.retryDelay=this.rateLimitInitialDelay;
if(_4.retryDelay>this.rateLimitMaxDelay){
_4.retryDelay=this.rateLimitMaxDelay}
_6.retryDelay=_4.retryDelay;
_6.recoverable=true;
this.logInfo("Bedrock responded with a 'busy, please retry' response; retrying in "+
_4.retry+" seconds")}
return _6}
,isc.A.makeSpoofedRawResponse=function isc_BedrockAIEngine_makeSpoofedRawResponse(_1,_2){
if(_1.responseType=="array"||_1.responseType=="object"){
_2="```json\n"+_2+"\n```"}
return{
candidates:[{
content:{
parts:[{
text:_2
}],
role:"model"
},
finishReason:"STOP"
}]
}}
,isc.A.transformRawResponse=function isc_BedrockAIEngine_transformRawResponse(_1,_2,_3){
var _4={type:"error"};
if(!_1){
_4.errorMessage="The response was empty."}else if(_1.error){
_4.errorMessage=_1.error.message}else{
if(!_1.output||!_1.output.message||
!isc.isAn.Array(_1.output.message.content)||
!_1.output.message.content[0].text)
{
this.logWarn(_4.errorMessage="Unable to extract the message from the AI response","AI");
_4.errorMessage="The raw response was missing an element in the output/message/content[0]/text hierarchy"}else{
var _5=_1.output.message.content[0].text;
this.logDebug("Response text from AI: "+_5,"AI");
_4.type="success";
_4.message=this.extractAIMessage(_5,_2,_3);
_4.messageText=_5}
}
return _4}
);
isc.B._maxIndex=isc.C+12;
isc.defineClass("PineconeAssistantEngine",isc.BaseOpenAIEngine);
isc.A=isc.PineconeAssistantEngine.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.provider="Pinecone";
isc.A.dataSourceName="pineconeRestConnector";
isc.A.requestOperationId="fetch";
isc.A.model="gpt-4o";
isc.B.push(isc.A.$277z=function isc_PineconeAssistantEngine__mapAIMessageSourceToRole(_1){
if(!_1)_1="user";
return _1=="system"?"assistant":_1}
,isc.A.transformRequest=function isc_PineconeAssistantEngine_transformRequest(_1){
var _2=this.Super("transformRequest",arguments);
_2.stream=false;
return _2}
,isc.A.transformRawResponse=function isc_PineconeAssistantEngine_transformRawResponse(_1,_2,_3){
if(_1&&_1.message){
_1.choices=[{
message:_1.message,
finish_reason:_1.finish_reason,
index:0
}];
delete _1.message;
delete _1.finish_reason}
return this.Super("transformRawResponse",arguments)}
,isc.A.init=function isc_PineconeAssistantEngine_init(){
this.Super("init",arguments);
var _1=isc.AI.getEngine(this.model);
if(!_1){
this.logWarn("Failed to initialize Pinecone Assistant AI Engine.  Could not find AI Engine: "+this.model);
return}
this.tokenLimit=_1.getTokenLimit()}
);
isc.B._maxIndex=isc.C+4;
if(!isc.AI)isc.defineClass("AI");
isc.A=isc.AI;
isc.A.requirementsForDisplayingInformationSectionTitle="Requirements for displaying information to the user"
;
isc.AI.registerTemplates({
summarizeDataSource:function(state,sc,j){
var dataSource=state.dataSource,
fields=state.fields||dataSource.getAllFields(),
dsName=dataSource.getID(),
shortDescription=isc.AI.getShortDSDescription(dataSource),
maskedFields=isc.applyMask(fields,isc.AI.salientFieldAttributes);
for(let f=0;f<maskedFields.length;++f){
const field=maskedFields[f];
if(!field.type)field.type="text"}
return isc.trimDoc`
            DataSource '${dsName}' is summarized as "${shortDescription}" and has the following available ${'field'.pluralize(fields.length)}:
            ${j(maskedFields, true)}`},
applicationDataSourcesPromptSection:function(dataSources,sc,j){
var numDataSources=!isc.isA.nonemptyArray(dataSources)?0:dataSources.length;
return isc.trimDoc`
            ## Application DataSources
            ${sc.if(numDataSources == 0,
                "There are no DataSources in the application.",
                isc.trimDoc`
                    There ${sc.if(numDataSources == 1, "is", "are")} ${numDataSources} ${"DataSource".pluralize(numDataSources)} available in the application.
                    The final user interface may use as many of these DataSources as necessary to fulfill the user request:

                    ${sc.for(dataSources, function (dataSource) {
                        return sc.render("summarizeDataSource", {dataSource: dataSource})}, "\n\n")}`
            )}`},
requirementsForDisplayingInformationPromptSection:function(state,sc,j){
return isc.trimDoc`
            <requirements-document topic="${sc.AI.requirementsForDisplayingInformationSectionTitle}" format="Markdown">
            The user's locale is: ${(sc.FileLoader && sc.FileLoader.currentLocale) || "en"}
            All display text should be translated into that language, and numbers and dates should be formatted for this locale.
            Automatic localized formatting of numbers in UIs may be achieved via the "localeInt"
            and "localeFloat" field types.

            Be concise and brief. Avoid redundancy.

            Use a neutral, professional, analytical tone.
            Avoid casual, emotional, or chatty expressions (e.g. "Let's take a look", "Great job!").

            *Never* refer to the user passively or indirectly (e.g. "the user", "a user").
            *Always* use second-person pronouns to refer to the user ("you"/"your").

            *Never* refer to yourself directly or use first-person pronouns (avoid "I"/"me"/"my"/"myself"/"we"/"us"/"our").

            Do not use overly technical language.
            Do not include programming code.

            Assume that the user understands business applications, including the current application,
            but not the SmartClient framework or its terminology. Use plain language to describe
            things rather than technical terms or identifiers:
            * "AdvancedCriteria" \u2192 "criteria"
            * "DSRequest" used to fetch data \u2192 "query"
            * "ListGrid" \u2192 "table"
            * "FacetChart" \u2192 "chart"
            * "DynamicForm" \u2192 "form"
            * Do not refer to a "ScalarViewer". This type of component displays a single
              number result of a query, along with a title. You should talk about the number,
              its significance, and why you are displaying it rather than talking about the
              ScalarViewer component itself.
            * Do not refer to DataSource field names directly.

            Do not display primary key or foreign key values. Always display titles or labels
            that identify records meaningfully. Any DataBoundComponent that you create should
            also not display primary key or foreign key values. Configure fields with "displayField",
            "valueMap", "optionDataSource", or similar properties.

            Never suggest a fix that wouldn't actually fix the problem. For example, do not
            suggest that the user specify a "by rank" criterion (such as "top 10", "lowest 2%")
            in the description of a filter, because that is not achievable via AdvancedCriteria.
            </requirements-document>`}
});
isc.A=isc.AI;
isc.A.advancedCriteriaAIHelpDocument=isc.aiHelpDocuments["object:AdvancedCriteria"]
;
isc.A=isc.AI;
isc.A.aiWasDisabledMessage="AI was disabled.";
isc.A.defaultAIEngineNotRegisteredErrorMessage="The default AI engine '${defaultEngineId}' is not registered.";
isc.A.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage="No AI engine is registered which supports vision requests.";
isc.A.aiNotAbleToProcessRequestErrorMessage="AI is not able to process your request.";
isc.A.noDataSourcesAvailableOrFoundErrorMessage="There were no data sources available or found.";
isc.A.startingYourRequestDetailMessage="Starting your request\u2026";
isc.A.willSubsetFieldsDetailMessage="Since the data source has a large number of fields, AI will be asked to select which ones are likely to be relevant to your request.";
isc.A.finishedSubsettingFieldsDetailMessage="Finished the request to select the relevant fields.";
isc.A.dataSourceIsRequiredErrorMessage="A globally-installed DataSource with a non-composite primary key is required.";
isc.A.exampleResponseDelineator="$$$$$$$";
isc.A.aiResponseDelineator="#######";
isc.A.scPostDelineator="^^^^^^^";
isc.A.$272z=isc.AIEngine.$272z;
isc.A.$2720=isc.AIEngine.$2720;
isc.A.$262j="context,numStepsCompleted,estimatedNumTotalSteps,newMessages"
;
isc.A=isc.AI;
isc.A.responseTypes=["Execute JavaScript","Clarify","Inspect","Explain Why Not","Ad Hoc UI","Send A Message"];
isc.A.messageTypes=["Notify","Modal Message"];
isc.A.errorTypes={
"ContainsAIDelineator":"The Response should not contain "+isc.AI.aiResponseDelineator+" or "+isc.AI.scPostDelineator,
"NoResponseType":"The Response has no ResponseType, which is invalid.",
"BadResponseType":"The Response has ResponseType ${responseType}, which is not a valid ResponseType.",
"NoMessageType":"The Response has a Message but there is no MessageType, which is invalid.",
"BadMessageType":"The Response has MessageType ${messageType}, which is not a valid MessageType.",
"NoMessage":"ResponseType is ${responseType} but there is no Message in the Response, which is invalid.",
"NoJavaScript":"ResponseType is ${responseType} but there is no JavaScript in the Response, which is invalid.",
"NoCommandComplete":"ResponseType is ${responseType} but the JavaScript code in the Response does not contain a call to isc.AI.commandComplete(). This method should be invoked exactly once when the script's actions are completed",
"JavaScriptError":
"Your attempt to execute JavaScript in the user's session resulted in a JavaScript error.\nThe error message is as follows:\n    ${error.message}\nEnd of error message.\n${hint}The attempted changes have been reverted and no messages have been displayed to the end user.\nPlease provide a revised response in the same format previously described."
}
;
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.defaultMaxFixAttempts=2;
isc.A.allowVoiceAssist=false;
isc.A.serializationFormat="compactJSON";
isc.A.csvFormatDescription="Objects are formatted in a character-separated-values format where each line shows the attribute-values of an object for the following fields:\n${fieldNames}\nAttribute values are separated by ${separator}.\n";
isc.A.separatorCharacter="|";
isc.A.jsonFormatDescription="Objects are serialized as an array of JSON formatted objects.\n";
isc.A.defaultRecordIndexFieldName="data-record index";
isc.A.disabled=true;
isc.A.engineConfigs=[
{
engineId:"gpt-3.5-turbo",
_constructor:"BaseOpenAIEngine",
name:"GPT-3.5 Turbo",
tokenLimit:4096,
supportsJSONMode:true
},
{
engineId:"gpt-4",
_constructor:"BaseOpenAIEngine",
name:"GPT-4",
tokenLimit:8192,
supportsJSONMode:true
},
{
engineId:"gpt-4-turbo",
_constructor:"MultimodalGPTEngine",
name:"GPT-4 Turbo",
tokenLimit:128000,
supportsJSONMode:true
},
{
engineId:"gpt-4o",
_constructor:"MultimodalGPTEngine",
name:"GPT-4o",
tokenLimit:128000,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4o-mini",
_constructor:"MultimodalGPTEngine",
name:"GPT-4o mini",
tokenLimit:128000,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4.1",
_constructor:"MultimodalGPTEngine",
name:"GPT-4.1",
tokenLimit:1047576,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4.1-mini",
_constructor:"MultimodalGPTEngine",
name:"GPT-4.1 mini",
tokenLimit:1047576,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"gpt-4.1-nano",
_constructor:"MultimodalGPTEngine",
name:"GPT-4.1 nano",
tokenLimit:1047576,
supportsJSONMode:true,
supportsStructuredOutputs:true
},
{
engineId:"pinecone-isc-rag",
_constructor:"PineconeAssistantEngine",
name:"Pinecone ISC RAG"
},
{
engineId:"gemini-pro",
_constructor:"GeminiProAIEngine"
},
{
engineId:"o1",
_constructor:"OpenAIReasoningEngine"
},
{
engineId:"o3",
_constructor:"OpenAIReasoningEngine"
},
{
engineId:"o3-mini",
_constructor:"OpenAIReasoningEngine",
canSupportVisionRequests:function(){
return false}
},
{
engineId:"o4-mini",
_constructor:"OpenAIReasoningEngine"
},
{
engineId:"bedrock",
_constructor:"BedrockAIEngine",
name:"AWS Bedrock"
}
];
isc.A.defaultEngineId="gpt-4.1";
isc.A.engines={};
isc.A.assistantKey={altKey:true,keyName:"J"};
isc.A.$273s="result,request";
isc.A.defaultMaxRetries=2;
isc.A.sendPromptRetryDelay=5000;
isc.A.$260m=[];
isc.A.templatedStringFunctionsCache=isc.LRUCache.create({
maxSize:10,
keyEvicted:function(_1){
if(isc.AI.logIsDebugEnabled("AI")){
isc.AI.logDebug("Function for templated string "+isc.AI.$289a(_1)+
" was evicted from the cache.","AI")}
}
});
isc.A.useClientSessionHistory=true;
isc.A.adjacentValidationFailureCount=0;
isc.A.$2542=0;
isc.A.canExport=true;
isc.A.canExportCharts=true;
isc.A.canExportGrids=true;
isc.A.canSaveScreens=true;
isc.A.adHocUIWindowDefaults={
_constructor:"Window",
width:"80%",
height:"80%",
canDragResize:true,canDragReposition:true,
keepInParentRect:false,
autoCenter:true,
isModal:true,
title:"AI created User Interface",
showHeaderIcon:true,
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:9
},
toolStripDefaults:{
_constructor:"ToolStrip",
autoDraw:false,
width:"100%",
height:40
},
helpButtonDefaults:{
_constructor:"ToolStripButton",
autoDraw:false,
name:"helpWithUI",
prompt:"Ask for help with the dynamically created UI",
click:function(){
this.creator.getHelpWithThisUI()}
},
saveButtonDefaults:{
_constructor:"ToolStripButton",
autoDraw:false,
name:"helpWithUI",icon:"[SKINIMG]actions/save.png",
prompt:"Save this UI for future use",
click:function(){
this.creator.saveAdHocUI()}
},
exportButtonDefaults:{
_constructor:"ToolStripButton",
name:"exportUI",icon:"[SKINIMG]actions/export.png",
click:function(){
this.creator.exportUI()}
},
initWidget:function(){
this.headerIconDefaults.src=isc.AI.getIconURL(true);
this.addAutoChild("helpButton",{icon:isc.AI.getIconURL(true)});
this.addAutoChild("saveButton",{showIf:"isc.AI.canSaveScreens"});
this.addAutoChild("exportButton",{showIf:"isc.AI.canExport"});
this.addAutoChild("toolStrip",{members:[this.helpButton,this.saveButton,this.exportButton]});
this.addItem(this.toolStrip);
return this.Super("initWidget",arguments)},
showCloseButton:true,
showMinimizeButton:false,showMaximizeButton:true,
closeClick:function(){
this.destroy()},
setAdHocUI:function(_1,_2){
this.adHocUI=isc.isAn.Array(_1)?_1[0]:_1;
this.response=_2;
var _3=this.adHocUI&&this.adHocUI.getFirstDBC();
if(!_3){
this.exportButton.hide()}else{
this.exportButton.show();
this.exportButton.prompt=isc.isA.ListGrid(_3)?"Export Grid Data":
"Export Chart"}
this.firstDBC=_3;
if(this.adHocUI){
this.addItem(this.adHocUI,0)}
},
getAdHocUI:function(){
return this.adHocUI},
saveAdHocUI:function(){
isc.AI.showSaveUIWindow(this.response)},
getAdHocUISummary:function(){
return this.adHocUI&&this.adHocUI.getUISummary(["data"])},
exportUI:function(){
var _1=this.adHocUI.getFirstDBC();
if(!_1){
isc.logWarn("No exportable UI.");
return}
var _2=isc.isA.ListGrid(_1),
_3=isc.isA.FacetChart(_1),
_4=[]
;
if(_2){
_4=[
{title:"CSV",val:"csv"},
{title:"JSON",val:"json"},
{title:"XML",val:"xml"},
{title:"XLS (Excel97)",val:"xls"},
{title:"OOXML (Excel2007)",val:"ooxml"}
]}else if(_3){
_4=[
{title:"PNG",val:"png"},
{title:"JPEG",val:"jpeg"}
]}
var _5=isc.Menu.create({
autoDraw:false,
items:_4,
keepInParentRect:true,
itemClick:function(_7){
if(_2){
if(_7.val=="json"){
_1.exportClientData({operationId:"customJSONExport"
})}else{
_1.exportClientData({exportAs:_7.val
})}
}else if(_3){
isc.RPCManager.exportImage(_1.getSvgString(),{
exportDisplay:"download",
exportFilename:"export",
exportImageFormat:_7.val,
exportImageQuality:1
})}
}
})
_5.$91y();
_5.draw();
var _6=_5.getVisibleHeight();
_5.placeNear(this.exportButton.getPageLeft(),
this.exportButton.getPageTop()-_6);
_5.show()},
getHelpWithThisUI:function(){
isc.AI.showAssistant({rootCanvas:this.adHocUI})}
};
isc.A.saveUIWindowDefaults={
_constructor:"Window",
width:300,
autoCenter:true,
autoSize:true,
overflow:"visible",
canDragResize:true,
isModal:true,
canDragReposition:true,
title:"Save AI generated UI",
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:9
},
labelDefaults:{
_constructor:"Label",
width:"100%",
height:1,
overflow:"visible",
dynamicContents:true,
contents:"You can save AI-generated screens for later use.  Saved screens are available whenever you open the AI assistant.<br><br>What would you like to name this UI?<br>"
},
formDefaults:{
_constructor:"DynamicForm",
height:"*",
autoFocus:true,
cellPadding:0,
fields:[
{name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",
colSpan:"*",showTitle:false,
hint:"Type a name for your saved UI",showHintInField:true,
keyPress:function(_1,_2,_3,_4){
if(_3=="Enter"){
this.form.creator.saveAdHocUI();
return false}
}
}
]
},
controlsLayoutDefaults:{
_constructor:"HLayout",
width:"100%",
height:1,
overflow:"visible",
align:"right",
membersMargin:8
},
saveButtonDefaults:{
_constructor:"Button",
title:"Save",
autoFit:true,
autoDraw:false,
click:function(){
this.creator.saveAdHocUI()},
layoutAlign:"right"
},
cancelButtonDefaults:{
_constructor:"Button",
title:"Cancel",
autoFit:true,
autoDraw:false,
click:function(){
this.creator.hide();},
layoutAlign:"right"
},
initWidget:function(){
this.Super("initWidget",arguments);
this.addItem(this.addAutoChild("label"));
this.addItem(this.addAutoChild("form"));
this.addAutoChild("saveButton");
this.addAutoChild("cancelButton");
this.addItem(this.addAutoChild("controlsLayout",{members:[this.saveButton,this.cancelButton]}))},
saveAdHocUI:function(){
isc.AI.saveAdHocUI(this.form.getValue("userText"),this.response);
this.hide()},
closeClick:function(){
this.hide()},
setResponse:function(_1){
this.response=_1},
show:function(){
this.form.setValue("userText",(isc.AI.lastUserPrompt||"").substring(0,100));
return this.Super("show",arguments)}
};
isc.A.savedUIStorageKey="savedUI";
isc.A.screensDataSource=null;
isc.A.logLocalDSRequests=false;
isc.A.assistantBlurb="<b>Ask for AI assistance in using this ${isc.AI.isShowcase ? \"Showcase Sample\" : \"application\"}.</b><br><br>You can:<br><br>1. request that the AI configures the existing screen to do something you want (such as configuring complex search criteria for a grid)<br><br>2. request that the AI builds you a custom interface, to enable you to complete tasks more quickly than what the current UI allows. Note that AI-created screens may be saved for future use.<br>";
isc.A.assistantHint="Type your question or request here";
isc.A.assistantWindowDefaults={
_constructor:"Window",
width:500,
autoCenter:true,
autoSize:true,
overflow:"visible",
canDragResize:true,
canDragReposition:true,
title:"SmartClient AI Assistant",
showHeaderIcon:true,
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:10
},
labelDefaults:{
_constructor:"Label",
width:"100%",
dynamicContents:true
},
formDefaults:{
_constructor:"DynamicForm",
height:"*",
autoFocus:true,
cellPadding:0,
fields:[
{name:"userText",type:"textArea",minHeight:50,width:"*",height:"*",
colSpan:"*",showTitle:false,
hint:isc.AI.assistantHint,showHintInField:true,
keyPress:function(_1,_2,_3,_4){
if(_3=="Enter"){
this.form.creator.askTheAI();
return false}
}
}
]
},
controlsLayoutDefaults:{
_constructor:"HLayout",
width:"100%",
height:1,
membersMargin:10,
overflow:"visible"
},
savedUIFormDefaults:{
_constructor:"DynamicForm",
width:360,
minWidth:200,
height:1,
overflow:"visible",
autoFocus:false,
autoDraw:false,
cellPadding:0,
layoutAlign:"left"
},
askButtonDefaults:{
_constructor:"Button",
title:"Ask the AI",
autoFit:true,
click:function(){
this.creator.askTheAI()},
layoutAlign:"right"
},
initWidget:function(){
this.headerIconDefaults.src=isc.AI.getIconURL(true);
this.Super("initWidget",arguments);
this.addItem(this.addAutoChild("label",{
contents:isc.AI.assistantBlurb
}));
this.addItem(this.addAutoChild("form"));
this.addItem(this.addAutoChild("controlsLayout"));
this.addAutoChild("savedUIForm",{
fields:[{
name:"savedUI",type:"select",width:"*",
colSpan:"*",
optionDataSource:isc.AI.getScreensDataSource(),
valueField:"name",displayField:"name",
title:"Saved Screens",
wrapTitle:false,
pickListProperties:{canRemoveRecords:true},
changed:function(){
this.form.creator.loadSavedUI(this.getValue());
return false}
}]
});
this.addAutoChild("askButton");
this.controlsLayout.addMembers([
this.savedUIForm,
isc.LayoutSpacer.create({width:"*"}),
this.askButton
])},
askTheAI:function(){
var _1=this.form.getValue("userText")
isc.AI.command(_1,"userQuery");
isc.Notify.addMessage("Asked the AI: \""+_1+"\"")},
loadSavedUI:function(){
var _1=this.savedUIForm.getValue("savedUI");
isc.AI.getSavedUI(_1,function(_2){
isc.AI.handleAIResponse(_2.response.aiResponse)})
},
close:function(){
this.Super("close",arguments);
isc.AI.assistantClosed()}
};
isc.A.clearHistoryOnClose=true;
isc.A.clarifyWindowDefaults={
_constructor:"Window",
width:300,
autoCenter:true,
autoSize:true,
canDragResize:true,
canDragReposition:true,
height:200,
title:"The AI needs your input",
bodyProperties:{
padding:10,
layoutMargin:10,
membersMargin:9
},
labelContents:"",
labelDefaults:{
_constructor:"Label",
width:"100%",
height:1,
contents:""
},
formDefaults:{
_constructor:"DynamicForm",
height:"*",
autoFocus:true,
cellPadding:0,
fields:[
{name:"userText",type:"textArea",minHeight:50,width:"*",height:80,
colSpan:"*",showTitle:false,
hint:"Type your clarifying information here",showHintInField:true,
keyPress:function(_1,_2,_3,_4){
if(_3=="Enter"){
this.form.creator.tellTheAI();
return false}
}
}
]
},
aiButtonDefaults:{
_constructor:"Button",
title:"Tell the AI",
autoFit:true,
click:function(){
this.creator.tellTheAI()},
layoutAlign:"right"
},
initWidget:function(){
this.Super("initWidget",arguments);
this.addItem(this.addAutoChild("label"));
this.addItem(this.addAutoChild("form"));
this.addItem(this.addAutoChild("aiButton"))},
tellTheAI:function(){
var _1=this.form.getValue("userText")
isc.AI.command(_1,"userClarification");
isc.AI.hideClarifyWindow()}
};
isc.A.$2593={result:"invalid"};
isc.A.$270h="aiResponseForBatch,context";
isc.A.useAIFieldPaging=true;
isc.A.salientFieldAttributes=[
"name",
"type",
"required",
"multiple",
"title",
"description",
"valueMap",
"validOperators",
"displayField",
"foreignKey",
"joinType",
"includeFrom",
"includeVia",
"hidden"
];
isc.A.setFieldsFixedPrompt="This is a request by a user to show and/or hide some ListGrid fields in a web application built with the Isomorphic SmartClient Javascript framework. The user request is as follows:\n'${userPrompt}'\nYour response should be a JSON string containing an object with two attributes.\n\"show\": the fields the user wants to show as an array of strings, or an empty array if the user did not ask to show any fields.\n\"hide\": the fields the user wants to hide as an array of strings, or an empty array if the user did not ask to hide any fields.\n\nDo not include any other text in your response.\n\n";
isc.A.setFieldsHiddenFieldsPromptPrefix="The following fields are not currently visible in the grid but are available to be shown.\n";
isc.A.setFieldsVisibleFieldsPromptPrefix="The grid currently contains the following visible fields which may be hidden.\n";
isc.A.$265j="buildResponse,buildRequest";
isc.A.$274q="asyncBuildCriterion";
isc.B.push(isc.A.init=function isc_c_AI_init(){
this.Super("init",arguments);
this.startAssistant(this.assistantKey);
this.$270z();
this.$2700();
if(this.allowVoiceAssist){
isc.VoiceAssist&&isc.VoiceAssist.enable()}
}
,isc.A.$260x=function isc_c_AI__encodeJSON(_1){
return isc.JSON.encode(_1,{prettyPrint:false})}
,isc.A.doPageRecordsPicking=function isc_c_AI_doPageRecordsPicking(_1,_2,_3,_4){
var _5=[{source:"user",content:_1}],
_6=this.$2678(_5);
return _6.aiEngine.doPageRecordsPicking(_5,_2,_3,_4)
}
,isc.A.$2679=function isc_c_AI__getContextForRequest(_1){
if(this.disabled)return{errorMessage:this.aiWasDisabledMessage};
var _2=this.getEngine();
if(!_2)return{errorMessage:this.defaultAIEngineNotRegisteredErrorMessage.evalDynamicString(this,this)};
this.$102q(this.isEnabled());
var _3,
_4=_2.couldSupportRequest(_1),
_5=isc.AIEngine.containsImageMessage(_1.messages);
if(_4){
_3=_2}else{
var _6=isc.getValues(this.engines),
i=_6.findIndex(_2);
this.$102q(i>=0);
if(i>0){
_6.removeAt(i);
_6.addAt(_2,0)}
for(i=0;i<_6.length;++i){
if(i>0&&_6[i].couldSupportRequest(_1)){
_3=_6[i];
_4=true;
break}
if(!_3&&_5&&_6[i].canSupportVisionRequests()){
_3=_6[i]}
}
}
if(!_3){
return{errorMessage:_5
?this.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage
:"No suitable AIEngine was found."}}
if(!_4){
this.logWarn("Will use AIEngine "+_3.engineId+", but it claims not to support the request","AI")}
return{
cancellationController:_1.cancellationController,
aiEngine:_3,
couldSupportRequest:_4,
isVisionRequest:_5
}}
,isc.A.$2678=function isc_c_AI__getContextForAIMessages(_1){
var _2={messages:_1};
return this.$2679(_2)}
,isc.A.shouldUseAIFieldPaging=function isc_c_AI_shouldUseAIFieldPaging(_1,_2,_3){
var _4={
messages:[{source:"user",content:_1}]
};
var _5=this.$2679(_4);
return _5.aiEngine.shouldUseAIFieldPaging(_4,_2,_3)}
,isc.A.retrieveFieldsForPrompt=function isc_c_AI_retrieveFieldsForPrompt(_1,_2,_3,_4,_5,_6){
var _7=[{content:_1}];
_5=this.$2678(_7);
return _5.aiEngine.retrieveFieldsForPrompt(_7,_2,_3,_4,_5,_6)}
,isc.A.getSerializedFields=function isc_c_AI_getSerializedFields(_1,_2){
if(_2==null)_2={};
var _3={
engineId:_2.engineId,
fieldNames:_2.salientFieldAttributes||isc.AI.salientFieldAttributes,
recordIndexFieldName:"",
serializationFormat:_2.serializationFormat
};
return this.serializeRecords(_1,_3)}
,isc.A.getShortDSDescription=function isc_c_AI_getShortDSDescription(_1){
var _2={
ID:_1.ID
};
if(_1.title!=null){
_2.title=_1.title}
if(_1.pluralTitle!=null){
_2.pluralTitle=_1.pluralTitle}
if(_1.description!=null){
_2.description=_1.description}
if(_1.titleField!=null){
_2.titleField=_1.titleField}
var _3=_1.getPrimaryKeyFieldNames();
if(_3!=null&&_3.length>0){
if(_3.length==1)_3=_3[0];
_2.primaryKey=_3}
return this.echoFull(_2)}
,isc.A.summarizeDataSource=function isc_c_AI_summarizeDataSource(_1,_2,_3,_4){
var _5=this.getShortDSDescription(_1),
_6=isc.isAn.Array(_2)&&!_2.isEmpty(),
_7=_6&&_4!=false?_1.getSalientFields():[];
if(_6){
for(var i=0;i<_2.length;++i){
var _9=_2[i];
if(isc.isA.String(_9))_9=_1.getField(_9);
if(_9==null)continue;
if(_7.find("name",_9.name)==null){
_7.add(_9)}
}
}
_5+=("\nThis dataSource has the following fields that are relevant to the query:\n"+
this.getSerializedFields(_7,_3));
return _5}
,isc.A.serializeRecords=function isc_c_AI_serializeRecords(_1,_2){
if(_2==null)_2={};
if(_1==null)_1=[];
var _3=_2.serializationFormat||this.serializationFormat;
if(_3=="csv"&&_2.fieldNames==null&&_1.length>0){
_2.fieldNames=isc.getKeys(_1[0])}
var _4=[];
for(var i=0;i<_1.length;i++){
_4.add(this.serializeIndexedRecord(_1[i],i,_2))}
return this.getFormatDescription(_2)+this.$2590(_4,_2)}
,isc.A.$2590=function isc_c_AI__joinSerializedRecords(_1,_2){
var _3=_2.serializationFormat||this.serializationFormat;
var _4=_3!="csv";
var _5=_3=="compactJSON";
var _6=(_5?",":(_4?",\n":"\n"));
var _7=
(_5?"[":(_4?"[\n":""))+
_1.join(_6)+
(_5?"]":(_4?"\n]":""));
return _7}
,isc.A.getFormatDescription=function isc_c_AI_getFormatDescription(_1){
if(_1==null)_1={};
var _2=_1.serializationFormat||this.serializationFormat,
_3=_2!="csv",
_4=_1.recordIndexFieldName!=null?_1.recordIndexFieldName:this.defaultRecordIndexFieldName,
_5=_4!="",
_6=_1.fieldNames||[];
if(_5){
_6=_6.duplicate();
_6.unshift(_4)}
var _7=_6.join(","),
_8=!_3?this.csvFormatDescription:this.jsonFormatDescription;
_8=_8.evalDynamicString(this,{
fieldNames:_7,
separator:this.separatorCharacter
});
return _8}
,isc.A.serializeIndexedRecord=function isc_c_AI_serializeIndexedRecord(_1,_2,_3){
if(_1==null)return"";
if(_3==null)_3={};
var _4=_3.serializationFormat||this.serializationFormat;
var _5=_4!="csv";
var _6=_4=="compactJSON";
var _7=_3.fieldNames;
if(!_5&&_7==null){
_7=isc.getKeys(_1);
this.logWarn(
"serializeIndexedRecord is serializing in a format where attribute names are not included in the output.Attributes will be output in the following order:"+_7.join(",")
)}
var _8=(_3.recordIndexFieldName!=null?_3.recordIndexFieldName:this.defaultRecordIndexFieldName);
var _9=(_8!="");
var _10="";
if(_4=="csv"){
if(_9)_10+=this.$2591(String(_2),_3);
for(var _11=0;_11<_7.length;_11++){
_10+=((_9||_11>0?this.separatorCharacter:"")+
this.$2591(_1[_7[_11]],_3))}
}else{
if(_7!=null){
_1=isc.applyMask(_1,_7)}
if(_9){
var _12={};
_12[_8]=_2;
_1=isc.addProperties(_12,_1)}
_10=isc.JSON.encode(_1,{prettyPrint:!_6})}
return _10}
,isc.A.$2591=function isc_c_AI__csvSerializeAttribute(_1,_2){
if(_1==null)return"";
return isc.isA.String(_1)?_1.asSource():_1+""}
,isc.A.isEnabled=function isc_c_AI_isEnabled(){
return this.disabled!=true&&
(this.defaultEngineId in this.engines||
this.engineConfigs.find("engineId",this.defaultEngineId)!=null)}
,isc.A.registerEngine=function isc_c_AI_registerEngine(_1){
if(_1.engineId in this.engines)return false;
this.engines[_1.engineId]=_1;
return true}
,isc.A.unregisterEngine=function isc_c_AI_unregisterEngine(_1){
if(!(_1 in this.engines))return false;
return delete this.engines[_1]}
,isc.A.getEngine=function isc_c_AI_getEngine(_1,_2){
_1=_1||isc.AI.defaultEngineId;
var _3=this.engines[_1];
if(_3==null){
var _4=this.engineConfigs.find("engineId",_1);
if(_4==null)return null;
var _5=isc.addProperties({engineId:_1,name:_1},_4,_2);
var _6=_4._constructor||"AIEngine";
_3=isc[_6].create(_5);
this.engines[_1]=_3}
return _3}
,isc.A.asyncLoadSystemSchema=function isc_c_AI_asyncLoadSystemSchema(){
const _1=Promise.withResolvers();
if(!this.haveSystemSchema()){
this.logInfo("It does not appear that the system schema are loaded. Will attempt to load them...","AI");
const _2={
target:this,
method:function(_3){
if(!this.haveSystemSchema()){
this.logWarn("Failed to load the system schema: "+isc.echo(_3),"AI");
_1.reject()}else{
this.logInfo("System schema are now loaded.","AI");
_1.resolve()}
}
};
isc.RPCManager.loadSystemSchema(_2,{willHandleError:true})}else{
this.logDebug("System schema are already loaded.","AI");
_1.resolve()}
return _1.promise}
,isc.A.haveSystemSchema=function isc_c_AI_haveSystemSchema(){
const _1=isc.DS.get("Canvas");
return!!(_1&&_1.componentSchema)}
,isc.A.allowAssistant=function isc_c_AI_allowAssistant(){
return true}
,isc.A.startAssistant=function isc_c_AI_startAssistant(_1){
if(isc.AI.aiReady)return;
if(!isc.AI.allowAssistant()){
isc.logWarn("No AI engine API key found found.  Can't install AI.","AI");
return}
if(_1)isc.AI.assistantKey=_1;
_1=isc.AI.assistantKey;
var _2=isc.Page.getRegisteredKeyActions(_1);
if(_2&&_2.length>0){
isc.logWarn("Specified AI shortcut-key ("+JSON.stringify(_1)+") is already in use by another handler. To enable the AI assistant shortcut, call isc.AI.startAssistant() with an unused key-name.","AI");
return}
isc.Page.registerKey(_1,function(_1,_3){
_3.showAssistant();
return false},isc.AI);
isc.AI.aiReady=true}
,isc.A.stopAssistant=function isc_c_AI_stopAssistant(){
if(!isc.AI.aiReady){
isc.AI.logWarn("Cannot stop the AI Assistant - it isn't running.");
return}
isc.Page.unregisterKey(isc.AI.assistantKey,isc.AI);
isc.AI.aiReady=false}
,isc.A.$274v=function isc_c_AI__asyncAIOperation(_1,_2){
if(!this.isEnabled()){
return isc.rejectAsDisabled(this.aiWasDisabledMessage)}
var _3=Array.prototype.slice.call(arguments,1);
return isc.AsyncUtil.asyncOperation(_2,function(_4){
_3.push(_4);
return isc.AI[_1].apply(isc.AI,_3)})}
,isc.A.$273t=function isc_c_AI__asyncDataBoundAIOperation(_1,_2){
if(!this.isEnabled()){
return isc.rejectAsDisabled(this.aiWasDisabledMessage)}
var _3=Array.prototype.slice.call(arguments,1);
return isc.AsyncUtil.asyncDataBoundOperation(_2,function(_13){
var _4=_13.component||_13.dataSource;
var _5=_4&&_4.getAllNamedFields();
var _6=_2.relevantFieldNames;
if(_5&&!_5.isEmpty()){
var _7=_5.makeIndex("name"),
_8=isc.getKeys(_7),
_9=_2.excludeFieldNames;
if(_6){
for(var i=0;i<_6.length;++i){
var _11=_6[i];
if(!_11||_11.contains('.'))continue;
if(!_8.contains(_11)&&
!_6.contains(_11,i+1))
{
isc.AI.logWarn("'"+_11+"' is listed in `relevantFieldNames`, but there is no such field.","AI")}
}
_7=isc.applyMask(_7,_6)}
if(_9){
for(var i=0;i<_9.length;++i){
var _12=_9[i];
if(!_12||_12.contains('.'))continue;
if(!_8.contains(_12)&&
!_9.contains(_12,i+1))
{
isc.AI.logWarn("'"+_12+"' is listed in `excludeFieldNames`, but there is no such field.","AI")}
delete _7[_12]}
}
_13.availableFields=isc.getValues(_7);
_13.availableFieldNames=_13.availableFields.getProperty("name");
_13.availableFieldsIndex=_7}else if(_6&&!_6.isEmpty()){
isc.AI.logWarn("Relevant field names were specified, but there are no named fields. Ignoring...","AI")}
_3.push(_13);
return isc.AI[_1].apply(isc.AI,_3)})}
,isc.A.$273v=function isc_c_AI__wrapAsyncDataBoundAIOperation(_1,_2){
var _3=Array.prototype.slice.call(arguments,1,-1),
_4=arguments[arguments.length-1];
var _5=function(_7){
var _6=isc.AI.$273s;
isc.AI.fireCallback(_4,_6,[_7,_2])};
this[_1].apply(this,_3)
.$271y(_5)}
,isc.A.summarizeValue=function isc_c_AI_summarizeValue(_1,_2){
this.$273v("asyncSummarizeValue",_1,_2)}
,isc.A.asyncSummarizeValue=function isc_c_AI_asyncSummarizeValue(_1){
return this.$273t("$271m",_1)}
,isc.A.$271m=function isc_c_AI__asyncSummarizeValue(_1,_2){
var _3=_1.aiRequest;
if(!_3){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiRequest"}))}
var _4=_1.value;
if(!_4){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"value"}))}
var _5=[
"This is a request to supplement a value from a DataSource, using relevant general knowledge and your own reasonable inferences. The supplemental information requested is:",
"${ssMessages}"
];
var _6=[{content:_3.prompt,type:_3.promptType}],
_7=_3.additionalMessages;
if(_7){
_6.addList(_7);
_6.removeEmpty()}
var _8=_2.availableFields,
_9=_1.record,
_10=_1.fieldName,
_11;
if(_8){
var _12=_8,
_13=_2.availableFieldNames;
var _14;
if(_10){
var _15=_13.indexOf(_10);
if(_15<0){
this.logWarn("A field with name '"+_10+"' is not available. Ignoring...","AI");
_10=null}else{
_13.removeAt(_15);
_14=_12[_15]}
}
if(_2.dataSource){
var _16=this.summarizeDataSource(_2.dataSource,_12,{format:"compactJSON"},false);
_5.push(
"The value to be summarized is from "+
(_10?"the '"+_10+"' field of ":"")+
"the DataSource with the following description: "+_16+"\n\n"
)}else{
this.$102q(_2.component);
if(_14){
_5.push(
"The value to be summarized comes from the DataBoundComponent field with the following description (in JSON format): "+
this.serializeIndexedRecord(_14,null,{
recordIndexFieldName:"",
fieldNames:this.salientFieldAttributes,
format:"compactJSON"
})+"\n\n"
)}
}
if(_9){
if(_13.isEmpty()){
this.logWarn("The context record was specified, but no additional fields are relevant to the request.","AI")}else{
_11={
recordIndexFieldName:"",
fieldNames:_13,
format:"compactJSON"
};
_5.push(
"The record that the value is part of is (in JSON format): "+
this.serializeIndexedRecord(_9,null,_11)+"\n\n"
)}
}
}else{
if(_9){
this.logWarn("The record was specified, but no fields are available. Ignoring...","AI")}
if(_10){
this.logWarn("fieldName was specified, but no fields are available. Ignoring...","AI")}
}
var _17=isc.InternalAIMessagesBuilder2.create({
ssMessages:_6,
messagesSource:_1.aiRequestSource||"system",
target:this,
evalVars:{
value:_4
}
});
_17.appendPrompts(_5);
_5=null;
var _18=_17.aiMessages;
var _19=_1.examples;
if(_19&&!_19.isEmpty()){
if(_1.valueType!=null&&_1.valueType!="text"){
this.logWarn("The valueType of examples must be 'text'. Omitting the examples...","AI")}else{
var _20="For example: ";
for(var _21=0;_21<_19.length;++_21){
var _22=_19[_21];
_20+="For the value '"+(_22.value||"")+"'";
if(_11&&_22.record){
_20+=" and record "+this.serializeIndexedRecord(
_22.record,null,_11)}
_20+=", you might generate '"+(_22.summary||"")+"'.\n"}
_18.push({
source:"system",
content:_20
})}
}
_18.push({
source:"system",
content:"Your response should be a single JSON object with one key \"result\" and value being the string of supplemental information for the value. The value is:"
});
_18.push({
content:_4,
type:_1.valueType
});
var _23={
messages:_18,
responseType:"object",
cancellationController:_2.cancellationController,
willHandleError:true
};
var _24=this.$2679(_23);
if(_24.errorMessage)return isc.rejectWithError(_24.errorMessage);
var _25={
maxRetries:_1.maxRetries
};
return _24.aiEngine.asyncSendRequest(_23,_25)
.then(function(_28){
var _26=_28.message.content,
_27;
if(!isc.isAn.Object(_26)||
!isc.isA.String(_26.result)||
!(_27=_26.result.trim()))
{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
return{
type:"success",
summary:_27
}})}
);
isc.evalBoundary;isc.B.push(isc.A.command=function isc_c_AI_command(_1,_2){
if(_1==null)return;
if(_2=="complete"){
if(_1!=null){
}
return}
if(_2!="userQuery"&&_2!="resolveError"&&_2!="userClarification"){
return}
if(_2=="userQuery"){
isc.AI.lastUserPrompt=_1}
var _3=isc.AI.getSession(),
_4=_3[0],
_5=_3[1],
_6=_3[2];
if(_6==null&&this.useClientSessionHistory){
_5={};
_6=this.sessionMessages=[this.getInitiatorMessage(_5)];
_1="** Initial request **\n"+_1}
var _7=function(_10,_11){
isc.AI.handleAIResponse(_10,_11.clientContext)};
var _8=(_6||[]).concat([{source:(_2=="resolveError"?"system":"user"),content:_1}]);
var _9=isc.addProperties({},this.assistantContext,{clientContext:_5});
this.sendRequest({
messages:_8,
historyIntroduction:"You have previously interacted with this user during this session as follows. Input from the user, including contextual information automatically provided by SmartClient, is delineated by "+
isc.AI.scPostDelineator+" at the beginning and end of that information. Your responses are delineated by "+isc.AI.aiResponseDelineator+" at the beginning and end.",
historyConclusion:"** New request **",
historyDelimiters:{
user:isc.AI.scPostDelineator,
model:isc.AI.aiResponseDelineator
}
},_7,_9);
this.addUserRequestToSessionHistory(_1,_5)}
,isc.A.origSendPrompt=function isc_c_AI_origSendPrompt(_1,_2,_3){
this.sendRequest({messages:[{source:"user",content:_1}]},_2,_3)}
,isc.A.sendRequest=function isc_c_AI_sendRequest(_1,_2,_3){
_3=isc.addProperties({},_3);
var _4=isc.AI.getEngine(_3.engineId);
if(!_4){
this.logWarn("Couldn't find any AI Engine with engineId: "+_3.engineId);
return}
_4.sendRequest(_1,function(_6,_1){
var _5=_6.message&&_6.message.content;
if(_5==null){
_4.logWarn("Unable to extract message from AI response","AI");
return}
_4.logDebug("Response text from AI: "+_5,"AI");
isc.AI.fireCallback(_2,"messageContent,config",[_5,_3])},_3)}
,isc.A.$289a=function isc_c_AI___textifyCacheKey(_1){
var _2="In the context of an Isomorphic SmartClient application,";
if(_1.startsWith(_2)){
_1="..."+_1.substring(_2.length)}
_1="'"+_1.replaceAll("\n","\\n")+"'";
if(_1.length>300)_1=_1.substring(0,166)+"..."+_1.substring(_1.length-129);
return _1}
,isc.A.$289b=function isc_c_AI__getPromptFromTemplatedString(_1,_2){
var _3=this.templatedStringFunctionsCache.get(_1);
if(_3){
if(this.logIsDebugEnabled("AI")){
isc.AI.logDebug("Cache hit for templated string "+isc.AI.$289a(_1),"AI")}
}else{
var _4=_1.replaceAll("\\","\\\\")
.replaceAll("`","\\`");
_3=new Function("evalVars","with(evalVars){return`"+_4+"`}");
this.templatedStringFunctionsCache.put(_1,_3)}
try{
return _3(Object(_2))}catch(e){
throw isc.createErrorResult("Failed to evaluate a templated string to make an AI prompt: "+String((e&&e.message)||e).asHTML(),{
templatedString:_1,
evalVars:_2
})}
}
,isc.A.asyncSendPrompt=function isc_c_AI_asyncSendPrompt(_1,_2,_3,_4){
var _5=Promise.withResolvers();
this.sendPrompt(_1,_2,function(_6){
if(!_6||_6.type!="success"){
_5.reject(isc.defaultAsyncOperationCatchCallback(_6))}else{
_5.resolve(_6)}
},_3,_4);
return _5.promise}
,isc.A.sendPrompt=function isc_c_AI_sendPrompt(_1,_2,_3,_4,_5){
var _6=isc.addPropertiesWithAssign({},_5,{willHandleError:true});
try{
_6.prompt=this.$289b(_1,_2)}catch(e){
var _7=isc.defaultAsyncOperationCatchCallback(e);
this.delayFireCallback(_3,isc.AIEngine.$2889,[_7,_6,_4]);
return}
var _8;
if(_4&&_4.engineId){
_8=this.getEngine(_4.engineId);
if(!_8){
this.logWarn("Couldn't find any AI Engine with engineId: "+_4.engineId+
"; using default")}
}
if(!_8){
var _9=this.$2679(_6);
if(_9.errorMessage){
var _7=isc.createErrorResult(_9.errorMessage);
this.delayFireCallback(_3,isc.AIEngine.$2889,[_7,_6,_4]);
return}
_8=_9.aiEngine}
_8.sendRequest(_6,_3,_4)}
,isc.A.estimateTokenCount=function isc_c_AI_estimateTokenCount(_1,_2){
var _3=isc.AI.getEngine(_2&&_2.engineId);
return _3.estimateTokenCount(_1)}
,isc.A.getVB=function isc_c_AI_getVB(){
if(this.isReify)return window.VB;
return null}
,isc.A.commandComplete=function isc_c_AI_commandComplete(_1){
isc.Class.endAEM();
if(this.isReify&&this.$2541){
isc.AI.getVB().destroyProjectState(this.$2541)}
var _2=isc.AI.lastResponse||{};
var _3=_1?isc.JSON.encode(_1):null;
isc.logWarn("commandComplete() called - "+
(_3?"JSON serialized to: "+_3:"no JSON to serialize"));
if(_2.message&&!isc.isAn.emptyString(_2.message)){
if(_2.messageType=="Notify")isc.Notify.addMessage(_2.message);
else isc.say(_2.message)}
if(_3)isc.AI.command(_3,"complete")}
,isc.A.getSessionHistory=function isc_c_AI_getSessionHistory(){
return this.getSession()[0]}
,isc.A.getSessionContext=function isc_c_AI_getSessionContext(){
return this.getSession()[1]}
,isc.A.getSessionMessages=function isc_c_AI_getSessionMessages(){
return this.getSession()[2]}
,isc.A.getSession=function isc_c_AI_getSession(){
var _1=this.sessionHistory;
var _2=this.sessionContext;
var _3=this.sessionMessages;
return[_1,_2,_3]}
,isc.A.clearSession=function isc_c_AI_clearSession(){
delete this.sessionHistory;
delete this.sessionContext;
delete this.sessionMessages}
,isc.A.addUserRequestToSessionHistory=function isc_c_AI_addUserRequestToSessionHistory(_1,_2){
if(this.useClientSessionHistory){
if(!this.sessionHistory)this.sessionHistory="";
this.sessionHistory+="\n"+this.scPostDelineator+_1+this.scPostDelineator;
if(!this.sessionMessages)this.sessionMessages=[];
this.sessionMessages.push({source:"user",content:_1});
if(_2!=null){
if(this.sessionContext==null)this.sessionContext={};
isc.addProperties(this.sessionContext,_2)}
}
}
,isc.A.addAIResponseToSessionHistory=function isc_c_AI_addAIResponseToSessionHistory(_1){
if(this.useClientSessionHistory){
var _2=isc.AI.cleanAIResponse(_1);
if(!this.sessionHistory)this.sessionHistory="";
this.sessionHistory+="\n"+this.aiResponseDelineator+_2+this.aiResponseDelineator;
if(!this.sessionMessages)this.sessionMessages=[];
this.sessionMessages.push({source:"AI",content:_2})}
}
,isc.A.handleAIResponse=function isc_c_AI_handleAIResponse(_1,_2){
this.addAIResponseToSessionHistory(_1);
var _3=isc.AI.validateAIResponse(_1);
this.handleValidatedAIResponse(_3,_2)}
,isc.A.handleValidatedAIResponse=function isc_c_AI_handleValidatedAIResponse(_1,_2){
isc.AI.lastResponse=isc.addProperties({},_1);
if(_1.errors&&_1.errors.length>0){
this.logWarn("The following errors were found during response validation:"+this.echoAll(_1.errors));
if(_1.unableToProcess){
this.adjacentValidationFailureCount++;
if(this.adjacentValidationFailureCount>4){
isc.say("The AI is unable to process this request as written. Please try rephrasing your request.")}else{
var _3="The response you shared was not formatted correctly. Please rewrite the response in the specified format. The specific error(s) encountered are as follows:\n- "+_1.errors.join("\n- ");
this.command(_3,"resolveError")}
return}
}
this.adjacentValidationFailureCount=0;
switch(_1.responseType){
case"Execute JavaScript":
var _4=isc.AI.handleAIJavaScript(_1,_2);
break;
case"Clarify":
this.showClarifyWindow(_1.message);
break;
case"Inspect":
var _4=isc.AI.handleAIJavaScript(_1,_2);
break;
case"Explain Why Not":
case"Send A Message":
var _4=isc.AI.commandComplete();
break;
case"Ad Hoc UI":
var _4=isc.AI.handleAIJavaScript(_1,_2);
break;
default:
}
}
,isc.A.getErrorText=function isc_c_AI_getErrorText(_1,_2){
return isc.AI.errorTypes[_1].evalDynamicString(this,_2)}
,isc.A.validateAIResponse=function isc_c_AI_validateAIResponse(_1){
var _2=[];
var _3={};
if(!_1||isc.isAn.emptyString(_1)){
_2.add("No Response Content");
_3.errors=_2;
_3.unableToProcess=true;
return _3}else{
var _4=isc.AI.parseAIResponse(_1);
_3=_4.response;
var _5=_3.responseType;
if(_4.aiResponse!=_1){
_2.add(this.getErrorText("ContainsAIDelineator",_3))}
if(!_5||_5==""){
_2.add(this.getErrorText("NoResponseType",_3));
_3.unableToProcess=true}else if(!isc.AI.responseTypes.contains(_5)){
_2.add(this.getErrorText("BadResponseType",_3));
_3.unableToProcess=true}
if(_3.message){
if(_5!="Clarify"){
if(!_3.messageType){
_2.add(this.getErrorText("NoMessageType",_3));
_3.unableToProcess=true}else if(!isc.AI.messageTypes.contains(_3.messageType)){
_2.add(this.getErrorText("BadMessageType",_3));
_3.unableToProcess=true}
}
}
if(["Send A Message","Explain Why Not","Clarify"].contains(_3.messageType)){
if(!_3.message||isc.isAn.emptyString(_3.message)){
_2.add(this.getErrorText("NoMessage",_3));
_3.unableToProcess=true}else if(_5!="Clarify"){
if(!isc.AI.messageTypes.contains(_3.messageType)){
_2.add(this.getErrorText("BadMessageType",_3));
_3.unableToProcess=true}
}
}
if((_5=="Inspect"||_5=="Execute JavaScript")&&
(!_3.javaScript||_3.javaScript.length==0)){
_2.add(this.getErrorText("NoJavaScript",_3));
_3.unableToProcess=true}
if(_3.noCommandComplete){
if(_5=="Inspect"){
_2.add(this.getErrorText("NoCommandComplete",_3));
_3.unableToProcess=true}else if(_5=="Execute JavaScript"||_5=="Ad Hoc UI"){
_3.fireCommandComplete=true}
}
}
if(_2.length>0)_3.errors=_2;
_3.aiResponse=_1;
isc.logInfo(isc.echoFull(_3));
return _3}
,isc.A.cleanAIResponse=function isc_c_AI_cleanAIResponse(_1){
var _2=_1.replaceAll(
isc.AI.exampleResponseDelineator,""
).replaceAll(
isc.AI.aiResponseDelineator,""
).replaceAll(
isc.AI.scPostDelineator,""
);
return _2
}
,isc.A.parseAIResponse=function isc_c_AI_parseAIResponse(_1){
var _2=this.cleanAIResponse(_1);
var _3={};
_3.responseType=this.retrieveAttributeValue("ResponseType:",_2);
_3.messageType=this.retrieveAttributeValue("MessageType:",_2);
_3.message=this.retrieveAttributeValue("Message:",_2,["MessageType:","======","ResponseType:"]);
_3.javaScript=this.retrieveAttributeValue("======",_2,["======"]);
if(_3.javaScript){
var _4=new RegExp(/(isc\.AI\.commandComplete\()([\s\S]*?)(\))+/)
if(_3.javaScript.match(_4)==null){
_3.noCommandComplete=true}
}
return{response:_3,aiResponse:_2}}
,isc.A.retrieveAttributeValue=function isc_c_AI_retrieveAttributeValue(_1,_2,_3){
var _4="(?:$|\\n)";
if(_3!=null&&_3.length>0){
_4="(?:$|\\n\\s*"+_3.join("|\\n\\s*")+")"}
var _5="(?:\\n|^)\\s*"+_1+"([\\s\\S]*?)"+_4;
var _6=_2.match(new RegExp(_5));
if(_6!=null)_6=_6.last().trim();
return _6}
,isc.A.handleAIJavaScript=function isc_c_AI_handleAIJavaScript(_1,_2){
if(this.isReify){
this.$2541=isc.AI.getVB().getProjectState()}
var _3=_1.javaScript,
_4=_1.responseType=="Ad Hoc UI",
_5
;
if(_4)_5=isc.noAutoDraw=true;
var _6=this;
delete this.aemError;
var _7=_2&&_2.idMapping;
var _8;
if(_7){
_8={};
for(var _9 in _7){
var _10=isc.AutoTest.getLocatorCanvas(_7[_9][0]);
if(_10!=null){
_8[_9]=_10}
}
}
var _11=isc.Class.evaluateAICode(
_3,
function(_14){
this.aemError=_14;
if(_14.errorType=="Timeout"){
_6.handleAEMTimeout()}else{
_6.handleAEMError(_14.error)}
},
true,
_4,
_8
);
if(this.aemError){
delete this.aemError;
return}
if(_1.fireCommandComplete){
this.commandComplete()}
if(_4){
isc.AI.uiWindow=this.createAdHocUIWindow();
var _12=_11.globals;
var _13=isc.Canvas.$112q(_12,true);
isc.AI.uiWindow.setAdHocUI(_13,_1);
isc.AI.uiWindow.show()}
}
,isc.A.handleAEMError=function isc_c_AI_handleAEMError(_1){
this.resetApplicationState();
this.logWarn("Error executing AI-generated script:"+_1);
var _2=this.errorTypes["JavaScriptError"];
var _3=_1.message,
_4=this.getJSErrorHint(_3)||"";
var _5=_2.evalDynamicString(this,{error:_1,hint:_4});
this.$2542++;
if(this.$2542>2){
this.$2542=0;
isc.say("The AI-generated script has caused an execution error. Please rephrase your request and try again.")}else{
this.command(_5,"resolveError")}
}
,isc.A.resetApplicationState=function isc_c_AI_resetApplicationState(){
if(this.isReify&&this.$2541!=null){
isc.AI.getVB().restoreProjectState(this.$2541);
delete this.$2541}else{
}
}
,isc.A.getJSErrorHint=function isc_c_AI_getJSErrorHint(_1){
var _2="";
if(new RegExp("^\S+ is undefined").test(_1)){
_2="\nSmartClient components are available by the ID in global scope. SmartClient classes may be accessed via their class name with the prefix \"isc.\" in global scope.\n"}
return _2}
,isc.A.handleAEMTimeout=function isc_c_AI_handleAEMTimeout(){
this.logWarn("Timeout after executing AI-generated script - either the code flow failed to complete, or did not invoke AI.commandComplete() when it completed.")}
,isc.A.getDataSourceNames=function isc_c_AI_getDataSourceNames(){
if(this.applicationDataSources!=null){
var _1=[];
for(var i=0;i<this.applicationDataSources.length;i++){
var _3=this.applicationDataSources[i];
if(isc.DataSource.get(_3)!=null){
_1.add(_3)}
}
return _1}
return(isc.AI.isReify?
isc.AI.getVB().getProjectDataSourceNames():
isc.DS.getRegisteredDataSourceObjects(true,true,true,true).getProperty("ID"))}
,isc.A.getDataSourceDefinitions=function isc_c_AI_getDataSourceDefinitions(_1){
if(_1==null)_1="pseudocode";
if(isc.AI.isReify){
return isc.AI.getVB().getProjectDataSourceDefinitions(_1)}else{
var _2=this.getDataSourceNames();
if(_2&&_2.length>0){
_2=_2.map(function(_3){return isc.DataSource.get(_3)})}
return isc.DS.getRegisteredDataSourceDefinitions(_1,false,_2)}
}
,isc.A.getUISummary=function isc_c_AI_getUISummary(_1){
var _2=this.customRootCanvas;
if(!_2)_2=this.applicationRootCanvas;
if(_2==null){
if(isc.AI.isReify){
var _3=isc.AI.getVB();
_2=_3&&_3.getScreenBaseComponent()}else if(isc.AI.isShowcase){
var _4=window["featureExplorer_exampleViewer"];
if(_4){
if(_4.fullScreenExampleWindow&&
_4.fullScreenExampleWindow.isDrawn()&&
_4.fullScreenExampleWindow.isVisible())
{
_2=_4.fullScreenExampleWindow.viewPane.viewContainer}else if(
_4.viewPane&&
_4.viewPane.isDrawn()&&
_4.viewPane.isVisible()
){
_2=_4.viewPane.viewContainer
}
}
}
}
if(_2==null){
var _5=isc.Canvas.$tw||[];
for(var i=0;i<_5.length;i++){
var _7=_5[i];
if(_7==null)continue;
if(isc.isA.ScreenSpan(_7))continue;
if(!_7.isVisible()||!_7.isDrawn()){
continue}
if(isc.isA.Menu(_7))continue;
if(_7==isc.AI.assistantWindow)continue;
if(_7.children!=null){
_2=_7;
break}
}
}
if(_2==null)return"";
var _8=_2.getUISummary(["data"]);
var _9={},
_10=isc.JSON.encode(this.postProcessUISummary(_8,_9));
return _1?[_10,_9]:_10}
,isc.A.postProcessUISummary=function isc_c_AI_postProcessUISummary(_1,_2){
if(isc.isA.Array(_1)){
for(var i=0;i<_1.length;i++){
this.postProcessUISummary(_1[i],_2)}
}else if(isc.isA.Object(_1)&&!isc.isA.Date(_1)){
for(var _4 in _1){
this.postProcessUISummary(_1[_4],_2)}
}
var _5=_1&&_1.smartClientComponentType;
if(_5!=null){
_1.$eu=function(_10,_11,_12){
var _5=this.smartClientComponentType;
var _6={};
var _7=this.id;
var _8=window[_7];
if(_8&&_8._autoAssignedID){
var _9=_8.getLocalId();
var i=0;
_7=_9;
while(_2[_7]!=null){
_7=_9+"_"+(++i)}
_2[_7]=[isc.AutoTest.getObjectLocator(_8),_9,_8.getScreenId()]}
_6.ID=_7;
isc.addProperties(_6,this);
delete _6.$eu;
delete _6.smartClientComponentType;
delete _6.id;
return"isc."+_5+".create("+isc.JSON.encode(_6,{prettyPrint:true,leadingIndent:_10})+")"}
}
return _1}
,isc.A.createAdHocUIWindow=function isc_c_AI_createAdHocUIWindow(){
return isc.Window.create(isc.AI.adHocUIWindowDefaults)}
,isc.A.showSaveUIWindow=function isc_c_AI_showSaveUIWindow(_1){
if(!isc.AI.saveUIWindow){
isc.AI.saveUIWindow=isc.Window.create(isc.AI.saveUIWindowDefaults)}
isc.AI.saveUIWindow.setResponse(_1);
isc.AI.saveUIWindow.show();
isc.AI.saveUIWindow.bringToFront()}
,isc.A.hideSaveUIWindow=function isc_c_AI_hideSaveUIWindow(){
if(isc.AI.saveUIWindow)isc.AI.saveUIWindow.hide()}
,isc.A.getScreensDataSource=function isc_c_AI_getScreensDataSource(){
if(!this.screensDataSource)this.screensDataSource=this.getLocalDataSource();
return this.screensDataSource}
,isc.A.getLocalDataSource=function isc_c_AI_getLocalDataSource(){
return this.$243t({
transformRequest:function(_1){
if(_1.doNotTrackRPC==null)_1.doNotTrackRPC=!isc.ss.logLocalDSRequests;
return _1},
_generated:true,
storageMode:"allRecords",
storageKey:this.savedUIStorageKey
})}
,isc.A.$243t=function isc_c_AI__getLocalDataSource(_1){
var _2=this;
return isc.LocalDataSource.create(_1,{
fields:[
{name:"name",primaryKey:true},
{name:"response",type:"text",length:1000000}
],
destroy:function(){
return this.Super("destroy")}
})}
,isc.A.saveAdHocUI=function isc_c_AI_saveAdHocUI(_1,_2){
isc.AI.getScreensDataSource().addData({name:_1,response:_2});
isc.say("Ad Hoc UI saved.")}
,isc.A.getSavedUI=function isc_c_AI_getSavedUI(_1,_2){
isc.AI.getScreensDataSource().fetchData({name:_1},
function(_3,_4,_5){
if(isc.isAn.Array(_4))_4=_4[0];
if(_2)_2(_4)}
)}
,isc.A.removeSavedUI=function isc_c_AI_removeSavedUI(_1){
isc.AI.getScreensDataSource().removeData({name:_1})}
,isc.A.showAssistant=function isc_c_AI_showAssistant(_1){
if(!isc.AI.assistantWindow){
isc.AI.assistantWindow=isc.Window.create(isc.AI.assistantWindowDefaults)}
isc.AI.initAssistantContext(_1);
isc.AI.assistantWindow.show()}
,isc.A.hideAssistant=function isc_c_AI_hideAssistant(){
if(isc.AI.assistantWindow)isc.AI.assistantWindow.close()}
,isc.A.assistantClosed=function isc_c_AI_assistantClosed(){
if(this.clearHistoryOnClose&&this.useClientSessionHistory)this.clearSession();
delete isc.AI.assistantContext;
delete isc.AI.customRootCanvas}
,isc.A.initAssistantContext=function isc_c_AI_initAssistantContext(_1){
if(isc.AI.assistantWindow){
if(isc.AI.assistantWindow.isVisible())isc.AI.hideAssistant()}else isc.AI.clearSession();
isc.AI.assistantContext=_1;
this.customRootCanvas=_1&&_1.rootCanvas}
,isc.A.useAssistant=function isc_c_AI_useAssistant(_1,_2){
isc.AI.initAssistantContext(_2);
isc.AI.command(_1,"userQuery")}
,isc.A.showClarifyWindow=function isc_c_AI_showClarifyWindow(_1){
if(!isc.AI.clarifyWindow){
isc.AI.clarifyWindow=isc.Window.create(isc.AI.clarifyWindowDefaults)}
var _2=isc.AI.clarifyWindow;
_2.label.setContents(_1);
_2.form.clearValues();
_2.show()}
,isc.A.hideClarifyWindow=function isc_c_AI_hideClarifyWindow(){
if(isc.AI.clarifyWindow)isc.AI.clarifyWindow.hide()}
,isc.A.getIconURL=function isc_c_AI_getIconURL(_1){
return isc.Media.getStockIconSrc("AIAssist")}
,isc.A._extractJsonResult=function isc_c_AI__extractJsonResult(_1,_2,_3,_4){
if(_2==null){
_2='{'}
if(_3==null){
_3='}'}
var _5=_1.lastIndexOf(_3);
if(_5<0)return this.$2593;
_1=_1.substring(0,_5+(_4?0:_3.length));
var _6;
while((_6=_1.indexOf(_2))>=0){
_1=_1.substring(_6+(_4?_2.length:0));
try{
return isc.JSON.decode(_1)}catch($al){
if(!_4)_1=_1.substring(_2.length)}
}
return this.$2593}
,isc.A.asyncRepeatRequestOnBatches=function isc_c_AI_asyncRepeatRequestOnBatches(_1,_2,_3,_4,_5){
var _6=[];
if(!this.isEnabled()){
return isc.rejectAsDisabled(this.aiWasDisabledMessage,{aiResponsesForBatches:_6})}
var _7=_4.cancellationController,
_8;
if(_7){
if(_7.canceled){
return Promise.reject(_7.asCanceledResult({
aiResponsesForBatches:_6
}))}
_8=_7.createSubController()}else{
_8=isc.CancellationController.create()}
var _9=_4.maxPasses==null?2:_4.maxPasses;
if(_9<1){
return isc.rejectWithError("Exceeded the maximum number of passes.",{aiResponsesForBatches:_6})}
var _10=this.$2679(_1);
if(_10.errorMessage)return isc.rejectWithError(_10.errorMessage,{aiResponsesForBatches:_6});
_10.aiResponsesForBatches=_6;
var _11=_10.secondPassBatches=[];
var _12={
maxRetries:_4.maxRetries==null?2:_4.maxRetries
};
var _13={
serializationFormat:"compactJSON",
fieldNames:_3,
maxRetries:_12.maxRetries,
cancellationController:_8,
aiPageSize:_4.maxRecordsPerBatch,
recordIndexFieldName:_4.recordIndexFieldName
};
var _14=_4.$270i;
if(!_14){
_1=isc.addPropertiesWithAssign({},_1);
_1.cancellationController=_8;
_1.willHandleError=true;
_14=_10.aiEngine.getBatches(_1,_2,_13)}else{
_14=_14.duplicate();
for(var i=0;i<_14.length;++i){
var _16=_14[i]=isc.addPropertiesWithAssign({},_14[i]);
_16.aiRequest=isc.addPropertiesWithAssign({},_16.aiRequest);
_16.aiRequest.cancellationController=_8;
_16.aiRequest.willHandleError=true}
}
var _17=_4.stopOnError!=false;
var _18=function(_16,_23){
if(_7&&_7.canceled)return;
_23.startIndex=_16.startIndex;
_23.length=_16.length;
_6.push(_23);
_23.callbackReturnValue=isc.AI.fireCallback(_5,isc.AI.$270h,[_23,_10]);
return _23};
var _19=isc.ResolvedValuesMapper.create({
values:_14,
keepSettledStatus:!_17?true:null,
cancellationController:_7,
maxConcurrent:_4.maxConcurrent,
asyncMap:function(_16){
return _10.aiEngine.asyncSendRequest(_16.aiRequest,_12)
.then(function(_23){
return _18(_16,_23)},function(_23){
var _20=_23.errorType;
if(_9>=2&&_16.length>=2&&
(_20=="requestSizeLimitExceeded"||_20=="responseSizeLimitExceeded"))
{
_11.addList(_10.aiEngine.splitBatch(_16));
return null}
if(_17&&!_8.canceled){
_8.cancel("The request for the batch starting at "+
_16.startIndex+", length "+_16.length+" failed: "+
isc.getAsyncMessage(_23),"external")}
return Promise.reject(_18(_16,_23))})}
});
return _19.getPromise()
.then(function(){
if(_7&&_7.canceled){
return Promise.reject(_7.asCanceledResult({
aiResponsesForBatches:_6
}))}
if(_11.isEmpty()){
isc.AI.$102q(!_17||!_7||!_7.canceled);
return{
type:"success",
aiResponsesForBatches:_6
}}
isc.AI.$102q(_9>=2);
var _21=isc.addPropertiesWithAssign({},_4);
_21.cancellationController=_8;
_21.$270i=_11;
_21.maxPasses=_9-1;
var _22=function(_23,_24){
_6.push(_23);
return isc.AI.fireCallback(_5,isc.AI.$270h,
[_23,_10])};
return isc.AI.asyncRepeatRequestOnBatches(_1,_2,_3,_21,_22)
.then(function(){
return{
type:"success",
aiResponsesForBatches:_6
}})})}
,isc.A.buildSort=function isc_c_AI_buildSort(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false,context:_3});
var _5=_3.grid||_3.rootCanvas;
var _6=_5.getDataSource();
var _7=_6!=null?isc.getValues(_6.getFields()):_5.getFields();
var _8="This is a request for an array of SortSpecifiers to sort the records in a ListGrid in a web application built with the Isomorphic SmartClient Javascript framework.  Your response should fulfill the following user request:\n'"+_1+"'\n\n"
_8+="Your response should be a JSON object with the following properties:\n\"sortSpecifiers\": an array of SortSpecifier objects, one for each sort-field the user requested, where each consists of two attributes - 'property' (the property to sort by) and 'direction' (either 'ascending' or 'descending').\n\"groupSortDirection\": this is the sort-direction for group-headers, as opposed to data-records - only include this property if the user has asked for groups to be sorted - valid values are 'ascending' and 'descending'.  If the user requested that group-sort be cleared, set this attribute to null.\n\n";
_8+="For example, an appropriate response to a user request of 'Sort by supplierName, then by unitCost in descending order' might be as follows:\n{sortSpecifiers:[{\"fieldName\":\"supplierName\",\"direction\":\"ascending\"},[{\"fieldName\":\"unitCost\",\"direction\":\"descending\"}]}\n\n";
_8+="Another example:\nrequest: 'Sort by supplierName and sort groups alphabetically'\nresponse:\n{sortSpecifiers:[{\"fieldName\":\"supplierName\",\"direction\":\"ascending\"}], groupSortDirection: \"ascending\"}\n\n";
_8+="If the user is requesting the existing sort be cleared, set the \"sortSpecifiers\" attribute to an empty array.\n";
_8+="For context, what follows is the list of fields available for use in SortSpecifiers - ";
if(this.shouldUseAIFieldPaging(_8,_7,_4)){
var _9=this;
this.retrieveFieldsForPrompt(
_1,"Apply sorting by field(s)",_7,
function(_10){
_9.$2597(_1,_8,_2,_3,_4,_10)},
_3,_4
)}else{
this.$2597(_1,_8,_2,_3,_4,_7)}
}
,isc.A.$2597=function isc_c_AI__buildSortWithFinalFields(_1,_2,_3,_4,_5,_6){
_2+=this.getSerializedFields(_6,_5)+"\n\n";
var _7=_4.grid||_4.rootCanvas;
_2+="\n\nFinally, here is the grid's current sort-state:\n";
_2+=_7.getSortState()+"\n\n";
var _8=this;
isc.AI.origSendPrompt(
_2,
function(_10){
var _9=_8._extractJsonResult(_10);
_8.fireCallback(_3,"result,context",[_9,_4])},
_5)}
,isc.A.buildSetFields=function isc_c_AI_buildSetFields(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false,context:_3});
var _5=this.setFieldsFixedPrompt.evalDynamicString(this,{userPrompt:_1})
var _6=_3.grid||_3.rootCanvas;
var _7=_6.getAllFields();
var _8=[];
var _9=[];
for(var i=0;i<_7.length;i++){
if(!_6.fieldIsVisible(_7[i])){
_9.add(_7[i])}else{
_8.add(_7[i])}
}
_5+=this.setFieldsVisibleFieldsPromptPrefix;
_5+=this.getSerializedFields(_8,_4)+"\n\n";
if(this.shouldUseAIFieldPaging(_5,_9,_4)){
var _11=this;
this.retrieveFieldsForPrompt(
_1,"Showing and hiding fields in a databound component",_9,
function(_12){
_11.$2598(_1,_5,_2,_3,_4,_12)},
_3,_4
)}else{
this.$2598(_1,_5,_2,_3,_4,_9)}
}
,isc.A.$2598=function isc_c_AI__buildSetFieldsWithFinalFields(_1,_2,_3,_4,_5,_6){
_2+=this.setFieldsHiddenFieldsPromptPrefix;
_2+=this.getSerializedFields(_6,_5);
var _7=this;
isc.AI.origSendPrompt(
_2,
function(_9){
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},
_5)}
,isc.A.buildGroupBy=function isc_c_AI_buildGroupBy(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false,context:_3});
var _5=_3.grid||_3.rootCanvas;
var _6=_5.getFields();
var _7="This is a request to determine which field or fields to pass to ListGrid.groupBy() in a web application built with the Isomorphic SmartClient Javascript framework.";
_7+="Your response should be structured as a JSON array of strings, where array-entries \nare the field-name(s) the user wishes to group by, if any are mentioned.\nIf the user requested any existing grouping be cleared, your response should be an empty array.\n\n";
_7+="Examples of appropriate responses to user requests:\n\nrequest:\nGroup by supplierName\nresponse:\n[\"supplierName\"]\n\nrequest:\nrequest:\nGroup the grid by availability, then by region\nresponse:\n[\"availability\",\"region\"]\n\nrequest:\nClear the current grouping\nresponse:\n[]\n\n";
_7+="For context, what follows is the list of fields in the Grid.\n";
_7+=this.getSerializedFields(_6,_4)+"\n\n";
_7+="And here is the grid's current group-state - this is for comparison only:\n";
_7+=_5.getGroupState()+"\n\n";
_7+="\n\nThe user's request is: \n'"+_1+"'\n";
var _8=this;
isc.AI.origSendPrompt(
_7,
function(_10){
var _9=_8._extractJsonResult(_10,"[","]");
_8.fireCallback(_2,"result,context",[_9,_3])},
_4)}
,isc.A.asyncSendRequest=function isc_c_AI_asyncSendRequest(_1,_2){
var _3=this.$2679(_1);
if(_3.errorMessage)return isc.rejectWithError(_3.errorMessage);
return _3.aiEngine.asyncSendRequest(_1,_2)}
,isc.A.$262k=function isc_c_AI__supportsAIComponentViews(_1,_2){
if(false){
return false}
var _3=_1.getID();
if(_3==null||isc.DS.get(_3)!==_1)return false;
if(!_1.supportsAdvancedCriteria())return false;
var _4=_1.getPrimaryKeyFieldNames();
if(_4==null||_4.length!=1||!_4[0])return false;
return true}
,isc.A.$267n=function isc_c_AI__createBuildViaAIContext(_1,_2,_3){
var _4=_3.cancellationController;
var _5={
$267o:Promise.withResolvers(),
cancellationController:_4,
$274w:_4?_4.createSubController():isc.CancellationController.create(),
$268c:_1,
buildRequest:_2,
referenceTime:_2.referenceTime||new Date,
$261v:0,
$261w:0,
$261x:null,
$261g:{
maxRetries:(_2.maxRetries==null?2:_2.maxRetries),
serializationFormat:"compactJSON"
}
};
if(_1=="asyncApplyAIFilter")_5.applyRequest=_2;
var _6;
if(_4){
_6=isc.observe(_4,"cancel","isc.AI.$2786(returnVal,observed,observer.$266t,reason,initiator)");
isc.addProperties(isc.Page.$2091[_6].observer,{
$266t:_5
})}
var _7=function(_9){
_5.$274w.destroy();
if(_6!=null)isc.ignore(_6);
var _8=_5.$261x;
if(_8&&!_8.destroyed){
if(_9.type=="canceled"){
_8.hide();
_8.destroy()}else{
if(_9.type=="error"){
isc.AI.$262i(
_5,
[{category:"error",content:isc.getAsyncMessage(_9)}],
true)}
_8.finish(_9.type=="success")}
}
};
_5.$267o.promise.then(_7,_7);
return _5}
);
isc.evalBoundary;isc.B.push(isc.A.$262i=function isc_c_AI__fireAIProgressCallback(_1,_2,_3){
if(_1.$274w.canceled)return;
var _4=_1.$261v,
_5=_1.$261w;
this.$102q(_4<=_5);
var _6=_1.$261x;
if(_6){
_6.setProgress(_4,_5);
_6.addMessages(_2);
if(_3)_6.show()}
isc.AI.fireCallback(
_1.buildRequest.progressCallback,
isc.AI.$262j,
[_1,_4,_5,_2]
)}
,isc.A.$265h=function isc_c_AI__cancelBuildViaAI(_1,_2,_3){
_1.$267o.reject({
type:"canceled",
cancellationReason:_2,
cancellationInitiator:_3
})}
,isc.A.$2786=function isc_c_AI___handleCancelBuildViaAI(_1,_2,_3,_4,_5){
if(!_1)return;
this.$102q(_2===_3.cancellationController);
this.$265h(_3,_4,_5)}
,isc.A.$2677=function isc_c_AI__wrapAsyncBuildViaAIOperation(_1,_2,_3){
var _4=function(_6){
var _5=_1=="asyncApplyAIFilter"?isc.AI.$266z:isc.AI.$265j;
isc.AI.fireCallback(_3,_5,[_6,_2])};
return this[_1](_2)
.$271y(_4)}
,isc.A.$267p=function isc_c_AI__asyncSummarizeUserMessages(_1){
var _2=_1.buildRequest,
_3=_2.userAIRequest;
var _4=[{content:_3.prompt,type:_3.promptType}];
if(_3.additionalMessages){
_4.addList(_3.additionalMessages);
_4.removeEmpty()}
_1.$2616=_4;
var _5=[],
_6=[];
for(var _7=0;_7<_4.length;++_7){
if(isc.AIEngine.isImageMessage(_4[_7])){
_5.push(_7);
_6.push(this.$267q(_4[_7],_1))}
}
if(_5.isEmpty()){
_1.$2615=_4;
return Promise.resolve(_4)}
_1.$2615=_4.duplicate();
_1.$261w+=_5.length;
this.$262i(_1,[{category:"detail",content:"AI will be asked to summarize your request."}],true);
return Promise.all(_6)
.then(function(_10){
var _8=_1.$2615;
for(var i=0;i<_5.length;++i){
_8[_5[i]]=_10[i]}
isc.AI.$262i(
_1,
[{
category:"success",
content:"Finished summarizing your request"
}]
);
return _8})}
,isc.A.$267q=function isc_c_AI__asyncSummarizeImage(_1,_2){
var _3={
cancellationController:_2.$274w,
messages:[
{content:"Summarize in detail the following image:",source:"system"},
isc.addProperties({},_1,{source:"user"})
],
willHandleError:true
};
return this.asyncSendRequest(_3,_2.$261g)
.then(function(_4){
++_2.$261v;
isc.AI.$262i(_2);
return{content:"An image described as: "+_4.message.content}})}
,isc.A.$267a=function isc_c_AI__canUseAICriterion(_1,_2){
if(_1.$264d!=null&&_1.$264d!=_2.getID()){
this.logWarn("'aiFilter' criterion built for DataSource '"+_1.$264d+"' is being used with DataSource '"+_2.getID()+"'.","AI")}
if(_1.$264d!=_2.getID()||
!_1.$2615||
!isc.isAn.Array(_1.$263s)||
!isc.isAn.Array(_1.$263t)||
!_1.$263q)
{
return false}
var _3=_2.getPrimaryKeyFieldNames();
if(_1.$263s.length!=_3.length)return false;
for(var i=0;i<_3.length;++i){
if(!_1.$263s.contains(_3[i]))return false}
var _5=_2.getFields();
for(var i=0;i<_1.$263t.length;++i){
if(!(_1.$263t[i]in _5))return false}
if(_1.$263v!=null&&!isc.isA.Class(_1.$263v)){
return false}
if(_1.$264f!=null&&!isc.isA.Class(_1.$264f)){
return false}
return true}
,isc.A.$268n=function isc_c_AI__getPromptText(_1,_2){
if(this.$267a(_1,_2)){
var _3=_1.userAIRequest;
if(_3!=null&&
isc.AIEngine.$272z(_3.promptType)&&
_3.prompt!=null)
{
return String(_3.prompt)}
}
return""}
,isc.A.$267j=function isc_c_AI__applyUsableAIFilterCaches(_1,_2,_3){
var _4={
matchingRecords:null,
remainingRecords:null
};
if(_1.isTrivial){
_4.matchingRecords=_2}else{
var _5=_1.$263v,
_6=_1.$264f;
if(!isc.isA.Class(_5))_5=null;
if(!isc.isA.Class(_6))_6=null;
var _7=_4.matchingRecords=[];
if(_5||_6){
var _8=_4.remainingRecords=[];
var _9=_1.$263s;
if(_9.length==1){
var _10=_9[0];
for(var _11=0;_11<_2.length;++_11){
var _12=_2[_11][_10];
if(_5&&_5.has(_12)){
}else if(_6&&_6.has(_12)){
_7.add(_2[_11])}else{
_8.add(_2[_11])}
}
}else{
this.$102q(false)}
}else _4.remainingRecords=_2}
return _4}
,isc.A.$2665=function isc_c_AI__clearAICriterionState(_1){
delete _1.$2615;
delete _1.$264d;
delete _1.$263s;
delete _1.$263t;
delete _1.$263q;
delete _1.$68o;
if(isc.isA.Class(_1.$263v)){
_1.$263v.clear()}
delete _1.$263v;
delete _1.$2667;
if(isc.isA.Class(_1.$264f)){
_1.$264f.clear()}
delete _1.$264f}
,isc.A.$268o=function isc_c_AI__getCleanAICriterion(_1){
var _2=isc.addPropertiesWithAssign({},_1);
delete _2.$263v;
delete _2.$2667;
delete _2.$264f;
delete _2.$2631;
delete _2.clone;
delete _2.criteria;
return _2}
,isc.A.$268p=function isc_c_AI__createFromCleanAICriterion(_1){
var _2,
_3;
if(isc.isAn.Array(_1.$263s)){
if(_1.$263s.length==1){
_2=isc.Set.create();
_3=isc.Set.create()}else{
_2=isc.TupleSet.create();
_3=isc.TupleSet.create()}
}
return isc.addProperties({},_1,{
_constructor:"AdvancedCriteria",
operator:"aiFilter",
$263v:_2,
$2667:null,
$264f:_3,
$2631:true,
clone:isc.AI.$2668
})}
,isc.A.$2668=function isc_c_AI__aiCriterionCloneImpl(){
return this}
,isc.A.$267r=function isc_c_AI__createBuildCriterionContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
_4.dataSource=_3.dataSource;
var _5=_2.mode;
if(_5==null)_5="hybrid";
else if(_5!="aiAssist"&&_5!="AIDE"&&_5!="hybrid"){
this.logWarn("unsupported AI service mode '"+_5+"'. Switching to 'hybrid'.");
_5="hybrid"}
_4.mode=_5;
if(_2.showProgressDialog==null||_2.showProgressDialog){
_4.$261x=isc.FilterViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
})}
_4.$261w=1;
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildCriterion=function isc_c_AI_buildCriterion(_1,_2){
this.$2677(this.$274q,_1,_2)}
,isc.A.asyncBuildCriterion=function isc_c_AI_asyncBuildCriterion(_1){
return this.$273t("$274x",_1)}
,isc.A.$274x=function isc_c_AI__asyncBuildCriterion(_1,_2){
var _3=this.$267r(this.$274q,_1,_2),
_4=_1.dataSource;
if(!_4||!this.$262k(_4,_3.mode)){
_3.$267o.reject(isc.createErrorResult(this.dataSourceIsRequiredErrorMessage))}else{
this.$267p(_3)
.then(function(_5){
return isc.AI.$267s(
_5,_3)})
.then(function(_5){
_3.$267o.resolve({type:"success",criterion:_5})},function(_5){
_3.$267o.reject(isc.defaultAsyncOperationCatchCallback(_5))})}
return _3.$267o.promise}
);
isc.B._maxIndex=isc.C+107;
isc.AI.registerTemplates({
buildCriterionCommonIntro:function(state,sc){
const purpose=state.purpose;
return isc.trimDoc`
            In the context of a business application developed using the Isomorphic SmartClient Framework,
            this is a request to generate an AdvancedCriteria object to apply to a DataBoundComponent
            for the purpose of ${sc.if(purpose == "hilite",
                "hiliting data-records",
                "filtering the data-records shown in the DataBoundComponent to only the ones"
            )} that match the following natural language description of criteria:
            <criteria-description>\${userMessages}</criteria-description>

            The DataBoundComponent's DataSource is:
            \${dsSummary}`},
buildCriterionAIAssistCommonResponseObjectPropertiesDescription:function(state,sc){
return isc.trimDoc`
            * "fieldSummaries" (object): A map from the name of each field of the DataSource to a string containing
              a shortened summary of all of the following details that you infer about the
              field from the field's title, description, and other available information:
                - For numeric fields, the units of the field's values if applicable,
                  or whether the units are unknown.
                - The pattern or format of the field's values.
                - Whether the field's values may be \`null\`, and hence require special care
                  in less-than comparisons.
                - Any assumptions that you are making about the field's values.
                - Any uncertainties that you have about the field's values.
            * "criteriaSummary" (string): A shortened summary of all of the following details
              that you infer from the criteria-description:
                - The units of any numeric values mentioned in the criteria-description.
                - The list of field names that are relevant.
                - When comparing a value mentioned in the criteria-description to the values
                  of a field, any conversions of units and reformatting that you made to make
                  the comparison value have the same units and format of field values.
                - When selecting field values less-than a comparison value, whether the
                  criteria-description implies that \`null\` values should be included or
                  excluded.
                - Any assumptions that you are making about the described criteria.
                - Any uncertainties that you have about the described criteria.`},
buildCriterionCommonOutro:function(state,sc){
const advancedCriteriaAIHelpDocument=isc.AI.advancedCriteriaAIHelpDocument;
return isc.trimDoc`
            Here is information about the AdvancedCriteria object:
            <requirements-document topic="${advancedCriteriaAIHelpDocument.topic}"${sc.if(advancedCriteriaAIHelpDocument.format, ` format="${advancedCriteriaAIHelpDocument.format}"`)}>
            ${advancedCriteriaAIHelpDocument.content}</requirements-document>

            For reference, consider the current date and time to be: ${state.referenceTime}

            ${sc.render("requirementsForDisplayingInformationPromptSection")}`},
buildCriterionHybridPrompt:function(state,sc){
const purpose=state.purpose;
return isc.trimDoc`
            ${sc.render("buildCriterionCommonIntro", state)}

            There are two methods of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
            the data-records of the DataBoundComponent:
            1. Generate an AdvancedCriteria object that directly corresponds to the criteria-description.
            2. Evaluate each data-record on a case-by-case basis, using the properties of each data-record,
               all reasonable inferences, and your own knowledge to decide whether a data-record matches
               the criteria-description.

            Method 1 is preferred if you can create such an AdvancedCriteria object.

            Your response must be a JSON object.

            If you decide that method 1 is sufficient, your response object must contain the
            following properties:
            ${sc.render("buildCriterionAIAssistCommonResponseObjectPropertiesDescription", state)}
            * "result": The AdvancedCriteria object that fulfills the criteria-description.

            If you decide that method 2 can fulfill the criteria-description, your response
            must be exactly '{ "result": "method2" }'

            In all other cases, your response object must contain the following properties:
            * "result": The string "invalid"
            * "invalidReasoning": A plain text string directed
              at the user containing your reason(s) why you are unable to generate a functional
              AdvancedCriteria object that fulfills the criteria-description and why evaluating
              each data-record on a case-by-case basis is also insufficient. In the "invalidReasoning" string,
              you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}" below
              and phrase things in the context of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
              records.

            ${sc.render("buildCriterionCommonOutro", state)}
        `},
buildCriterionAIAssistPrompt:function(state,sc){
const purpose=state.purpose;
return isc.trimDoc`
            ${sc.render("buildCriterionCommonIntro", state)}

            Your response must be a JSON object with the following properties:
            ${sc.render("buildCriterionAIAssistCommonResponseObjectPropertiesDescription", state)}
            * "result" (string or object):
                - If you are unable to generate a functional AdvancedCriteria object from the
                  criteria-description, "result" must be the string "invalid".
                - Otherwise, "result" must be the AdvancedCriteria object that fulfills the
                  criteria-description.
            * "invalidReasoning" (only if "reason" is "invalid"): A plain text string directed
              at the user containing your reason(s) why you are unable to generate a functional
              AdvancedCriteria object that fulfills the criteria-description. In the "invalidReasoning" string,
              you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}" below
              and phrase things in the context of ${sc.if(purpose == "hilite", "hiliting", "filtering")}
              records.

            ${sc.render("buildCriterionCommonOutro", state)}
        `}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.$268u=[
"and",
"or",
"not",
"isBlank","notBlank",
"isNull","notNull",
"equals","notEqual","iEquals","iNotEqual",
"contains","notContains","iContains","iNotContains",
"startsWith","notStartsWith","iStartsWith","iNotStartsWith",
"endsWith","notEndsWith","iEndsWith","iNotEndsWith",
"greaterThan",
"lessThan",
"greaterOrEqual",
"lessOrEqual"
];
isc.A.fixCriterionPrompts=[
"The user of a web application built with the Isomorphic SmartClient JavaScript Framework has requested to filter the data-records of a data-bound component according to the following filter-query:",
"${userMessages}",
"The data-bound component's DataSource has the following summary:\n${dsSummary}\n\nYou generated the following AdvancedCriteria object:\n${encodedCriterion}\n\nThe reason(s) why this is invalid are:\n${validationErrors}\n\n${encodedValidatedCriterion ? 'We have attempted to fix your AdvancedCriteria as follows:\\n' + encodedValidatedCriterion + '\\n\\n' : ''}Here is information about the AdvancedCriteria object:\n<help-document topic=\""+isc.AI.advancedCriteriaAIHelpDocument.topic+"\" format=\""+isc.AI.advancedCriteriaAIHelpDocument.format+"\">\n"+
isc.AI.advancedCriteriaAIHelpDocument.content,
"</help-document>\n\nYou are to generate a different AdvancedCriteria object that satisfies the user's filter-query *and* avoids the validation errors listed above.\nIf you are unable to do this, then your response should be exactly '{ \"result\": \"invalid\" }'"
];
isc.A.allowedCriterionPropertyNames=["fieldName","fieldQuery","operator","value","valuePath","valueQuery","start","end"];
isc.A.$266z="applyResponse,applyRequest";
isc.A.$274r="asyncApplyAIFilter";
isc.A.applyAIFilterPrompts=[
"The objects in the source-array below represent data-records from a DataSource. Using the properties on each data-record, the summary of the DataSource, and your own knowledge, determine which data-records match the user-supplied filter-query:",
"${userMessages}",
"The DataSource has the following summary:\n${dsSummary}\n\nFor example, if the query was 'amount is larger than 100', you should look for a field with a name most related to 'amount' and compare its value to 100.\n\nYour response should be a JSON object with a single property called 'result'.  This property should be set to an array of integers, where each integer is the index of a matching record in the source-array below.  For example, if the first data-record in the array below matches the user's filter-query, your response array must include its source-array index (0) as the first entry.  Similarly, the source-array indices of any other matching data-records must also be in your response array.\n\nIf a data-record does not match the filter-query, do not include its index in your response array.\n\nIf no data-records match, the 'result' property in your response object should be set to an empty array."
];
isc.A.$274s="asyncBuildHilites";
isc.A.buildHilitesPrompts=[
"This is a request for one or more hilites to apply to a DataBoundComponent (such as a ListGrid) in a web application built with the Isomorphic SmartClient JavaScript Framework.  For reference, consider the current date and time to be: ${referenceTime}.  A hilite applies specific styling (such as a text color, background color, and/or font-weight) to one or more fields of records that match a filter-query.  The user's description of the styling to apply, the fields that should have this styling, and/or the filter-query is:\n<description-of-hilites>",
"${userMessages}",
"</description-of-hilites>\n\nThe DataBoundComponent's DataSource has the following summary:\n${dsSummary}\n\nYour response should be a JSON object with a single key \"hiliteSpecs\": an array of the HiliteSpec objects. Each HiliteSpec object has the following format:\n{\"hiliteDescription\":The user's description for this particular Hilite, as a string.  This should be written from the same perspective/point-of-view as description-of-hilites, as if the user had written this themself,\n\"filterDescription\":Just the description of the filter-query, as a string.  This should be written from the same perspective/point-of-view as description-of-hilites, as if the user had written this themself,\n\"backgroundColor\":If the user requested a background color, a CSS color or color-name of the requested background color,\n\"textColor\":If the user requested a text color, a CSS color or color-name of the requested text color,\n\"cssText\":The CSS source code for any other styling requested by the user, if any,\n\"fieldName\":If the user requested that the styling is applied to certain fields, an array of the field names.  This property should be omitted if the user did not specify any specific fields to have hilite styling,\n\"replacementValue\":If the user requested that certain fields' values be replaced, the replacement value\n}\n\nHere are examples of CSS properties to use within \"cssText\":\nfont-weight: bold\nfont-style: italic\ntext-decoration-line: one of the following keywords: none, underline, overline, strike-through\ntext-decoration-color: a CSS color or color-name for the text decoration line\n\nValid color-names are: white, lightgray, gray, darkgray, black, lightred, red, darkred, lightpink, pink, darkpink, lightpurple, purple, darkpurple, lightorange, orange, darkorange, lightbrown, brown, darkbrown, lightyellow, yellow, darkyellow, lightgreen, green, darkgreen, lightblue, blue, darkblue, turquoise, teal, gold, bronze, beige\n\nNote: If the user-request did not explicitly specify the hilite styling, assume \"make the text color red\".\n\nFor example, if the user request was \"Show a light red background on the userName for records where the payment is overdue\", a valid response might be:\n{\"hiliteSpecs\": [{\"fieldName\":\"userName\",\n\"backgroundColor\":\"lightred\",\n\"filterDescription\":\"payment is overdue\",\n\"hiliteDescription\":\"Show a light red background on the userName for records where the payment is overdue\"}]\n}\n\nOr, if the user request was \"Hilite every row where assetImprovement is less than 5\", a valid response might be:\n{\"hiliteSpecs\": [{\"textColor\":\"red\",\n\"filterDescription\":\"assetImprovement is less than 5\",\n\"hiliteDescription\":\"Hilite every row where assetImprovement is less than 5\"}]\n}\n\nOr, if the user request was \"highlight population with light green background and red text where population is greater than 3000000 and highlight country with red text where continent is Africa\", a valid response might be:\n{\"hiliteSpecs\": [{\"fieldName\":\"population\",\n\"backgroundColor\":\"lightgreen\",\n\"textColor\":\"red\",\n\"filterDescription\":\"population is greater than 3000000\",\n\"hiliteDescription\":\"highlight population with light green background and red text where population is greater than 3000000\"\n}, {\"fieldName\":\"country\",\n\"textColor\":\"red\",\n\"filterDescription\":\"continent is Africa\",\n\"hiliteDescription\":\"highlight country with red text where continent is Africa\"\n}]\n}\n\n",
"If the request is to clear/reset remove all hilites, return an object with an empty \"hiliteSpecs\" array."
];
isc.A.$270x={
"white":"#fff",
"lightgray":"#ddd",
"gray":"#aaa",
"darkgray":"#555",
"black":"#000",
"lightred":"#f88",
"red":"#e00",
"darkred":"#800",
"lightpink":"#f9c",
"pink":"#f69",
"darkpink":"#f06",
"lightpurple":"#ccf",
"purple":"#96f",
"darkpurple":"#60c",
"lightorange":"#fc9",
"orange":"#f71",
"darkorange":"#f42",
"lightbrown":"#eb8",
"brown":"#840",
"darkbrown":"#320",
"lightyellow":"#ffa",
"yellow":"#ff5",
"darkyellow":"#970",
"lightgreen":"#cfc",
"green":"#0f0",
"darkgreen":"#060",
"lightblue":"#cff",
"blue":"#06f",
"darkblue":"#00c",
"turquoise":"#3cc",
"teal":"#088",
"gold":"#fd0",
"bronze":"#775",
"beige":"#db8"
};
isc.A.$270y=null;
isc.A.$265p="workingResponse,validationContext";
isc.A.$265o="buildContext,validationContext,callback";
isc.A.uiCodeSuffixPrompts="Your response does not need to contain any explanatory text in addition to the JavaScript to execute. Please use a single fenced code block to delineate the JavaScript code. This should be a line of three backtick (`) characters followed by the language specifier (javascript) before the code block, and three backtick (`) characters after the code block. For example:\n```javascript\n// JavaScript code to execute here\n```";
isc.A.uiCodeValidationPrompts=[
"This is a request for a fix to a block of JavaScript code to be executed in an Isomorphic SmartClient web application.\nThe following JavaScript code is intended to generate one or more more UI components to achieve the following goal:\n",
"${userMessages}",
"The code is failing validation because some specified property or properties are not valid. The code block is as follows\n```javascript\n${jsCode}\n```\nThe validation errors are reported as follows.\n```JSON\n${errors}\n```\nFor each error the \"nodePath\" attribute uses an xpath-like syntax to describe which component and which field has a problem. For example a nodePath like\n\"root[0||className=ListGrid||ID=grid0]/initialCriteria\"\nwould indicate a problem with the \"initialCriteria\" attribute specified on the first top-level ListGrid component defined in the code, with ID specified as \"grid0\".\nPlease return a fixed version of the code where any invalid attributes have been replaced with an appropriate property based on the Isomorphic SmartClient web framework's documentation."
];
isc.A.defaultBuildUIViaAIValidationTypes=["default"];
isc.A.dataBoundUITypeInfos={
list:{
description:"A ListGrid displaying some data from a dataSource. This is appropriate for any list of multiple records, including lists that are aggregated or grouped by values, sorted, filtered, etc.",
componentType:"ListGrid",
codePrompt:
"Note that for ListGrids, a user may request a simple \"grouped\" view. This is different from a true aggregated view and may be achieved via the \"groupByField\" property of the grid.\nExample listGrids:\nGiven a dataSource with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following code would satisfy a user request to view a list of records where price is less than 100, sorted by price in ascending order:\n```javascript\nisc.ListGrid.create({\n        autoFetchData:true,\n        dataSource: \"myDS\",\n        fields:[\n            {name:\"location\"},\n            {name:\"title\"},\n            {name:\"description\"},\n            {name:\"price\"}\n        ],\n        initialCriteria:{\n            fieldName:\"price\",\n            operator:\"lessThan\",\n            value:100\n        },\n        initialSort:[\n            {\n                property:\"price\",\n                direction:\"ascending\"\n            }\n        ]\n    });\n```\nOr, for the same dataSource, the following code would satisfy a user request to show the average price for each location. Note that because we're inferring the 'price' field to be a currency field, we're applying decimalPrecision:2. If the user had requested a specific precision we would respect that instead. :\n```javascript\nisc.ListGrid.create({\n        autoFetchData:true,\n        dataSource: \"myDS\",\n        fields:[\n            {name:\"location\"},\n            {name:\"price\", decimalPrecision:2}\n        ],\n        fetchRequestProperties:{\n            groupBy:[\"location\"],\n            summaryFunctions:{\n                price:\"avg\"\n            }\n        }\n    });\n```\n\nSetting the \"showFilterEditor\" property to true will show an editor that the user can use to customize the filter on the data of the ListGrid. If the user requested a filterable list, or indicated wanting to change or customize which records are displayed, set \"showFilterEditor\" to true.\nSet the \"width\" property to \"100%\", \"autoFitData\" to \"vertical\", and \"autoFitMaxHeight\" to 400."
},
chart:{
description:"A FacetChart displaying some data from a dataSource. Note that as with lists, a chart may display an aggregated or filtered set of values",
componentType:"FacetChart",
codePrompt:
"Note that the FacetChart you generate should have its \"valueProperty\" set to the numeric-typed field containing data values for records, and facetFields should be used to define facets for the chart.\nThe \"showDataValuesMode\" property should typically be set to \"auto\", unless this conflicts with the user prompt in some way.\nIf a clear, simple title for the chart can be derived from the prompt, include the \"title\" attribute.\nExamples:\nGiven a dataSource with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following code would satisfy a user request to build a chart showing items that cost more than $500 in each location:\n```javascript\nisc.FacetChart.create({\n    dataSource: \"myDS\",\n    facets: [\n        {\n            id: \"location\",\n            title: \"Location\"\n        },\n        {\n            id: \"title\",\n            title: \"Title\"\n        }\n    ],\n    stacked:false,\n    // valueProperty set to numeric field price\n    valueProperty: \"price\",\n    showDataValuesMode:\"auto\",\n    chartType: \"Column\",\n    autoFetchData: true,\n    initialCriteria:{\n        fieldName:\"unitCost\",\n        operator:\"greaterThan\",\n        value:500\n    }\n});\n```\nOr, for the same dataSource, the following code would satisfy a user request to chart the total number of items for each location:\n```javascript\nisc.FacetChart.create({\n    title: \"Total Number of Items by Location\",\n    dataSource: \"myDS\",\n    facets: [\n        {\n            id: \"location\",\n            title: \"Location\"\n        }\n    ],\n    // The fetchRequestProperties block below uses groupBy and summaryFunction\n    // to generate a count of \"code\" values per location.\n    // Since \"code\" is the primary key for this dataSource it is unique per item,\n    // giving us back item count per location.\n    valueProperty: \"code\",\n    showDataValuesMode:\"auto\",\n    autoFetchData: true,\n    fetchRequestProperties:{ \n        groupBy:[\"location\"],\n        summaryFunctions:{\n            code:\"count\"\n        }\n    }\n});\n```\n\nValid values for the \"chartType\" property are:\n\"Column\" - (the default if not specified) a bar chart with vertical bars\n\"Bar\" - a bar chart with horizontal bars\n\"Line\" - a chart where values are displayed side-by-side, connected by lines\n\"Radar\" - a chart where values are displayed around a circle, connected by lines\n\"Pie\" - a pie chart\n\"Doughnut\" - a pie chart with a center hole\n\nSet the \"width\" property to \"100%\" and the \"height\" to 400."
},
value:{
description:"A Label displaying a single value (scalar) derived from the data in a dataSource",
componentType:"ScalarViewer",
codePrompt:
"ScalarViewer is a component based on a SmartClient DynamicForm which uses the attribute \"fieldName\" to extract a single field value from a record and the attribute \"title\" as a title for the single field value.\nOther standard DynamicForm properties such as \"dataSource\", \"autoFetchData\" and \"initialCriteria\" may be used to populate the item with a single record.\nExamples:\nGiven a dataSource with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following code would display the \"description\" for the some record where \"code\" has the value \"abc123\":\n```javascript\nisc.ScalarViewer.create({\n    autoFetchData:true,\n    dataSource: \"myDS\",\n    title:\"Description for item abc123\",\n    fieldName:\"description\",\n    initialCriteria:{\n        fieldName:\"code\",\n        operator:\"equals\",\n        value:\"abc123\"\n    }\n});\n```\nOr, for the same dataSource, the following code would satisfy a user request to show the average price for items in San Francisco:\n```javascript\nisc.ScalarViewer.create({\n    autoFetchData:true,\n    dataSource: \"myDS\",\n    title:\"Average price of items in San Francisco\",\n    fieldName:\"price\",\n    initialCriteria:{\n        fieldName:\"location\",\n        operator:\"equals\",\n        value:\"San Francisco\"\n    },\n    fetchRequestProperties:{ \n        groupBy:[\"location\"], \n        summaryFunctions:{\n            price:\"avg\"\n        }\n    }\n});\n```\n\nTo control which record is retrieved, it may be necessary to sort by a field, by adding a \"sortBy\" property to the ScalarViewer's \"fetchRequestProperties\" object. The \"sortBy\" property is the name of the field that the data are sorted by, prefixed with a minus sign ('-') if the data should be sorted by the field in descending order.\nFor example, using the same \"myDS\" dataSource, the following code would satisfy the request for the \"location with the highest price\":```javascript\nisc.ScalarViewer.create({\n    autoFetchData:true,\n    dataSource: \"myDS\",\n    title:\"Location with the highest price\",\n    fieldName:\"location\",\n    fetchRequestProperties:{ \n        sortBy: \"-price\"\n    }\n});\n```\nIn this example, the first row, when sorted by the price in descending order, is for the location with the highest price in the dataSource."
}
};
isc.A.dataBoundUIInitiatorPrefixPrompts=[
"A user is interacting with an Isomorphic SmartClient web application. They have requested a new user-interface component to display data from a dataSource in some way. The user request is as follows:",
"${userMessages}"
];
isc.A.dataBoundUIInitiatorPrompt_UIOptions="The user may request one of the following types of user interface components:\n${uiTypeDescriptions}\n";
isc.A.dataBoundUIInitiatorPrompt_DSOptions="The following dataSources are available for this component:\n${dsDescriptions}\n";
isc.A.dataBoundUIInitiator_UIResponseFormat="Please respond with a JSON object containing the following attribute(s):\n\"component\": The component type name that best matches the user's request, or \"invalid\" if you are unable to determine what kind of data view the user is asking for. This should be one of the following values:\n${uiTypes}\n";
isc.A.dataBoundUIInitiator_DSResponseFormat="\"dataSource\": The ID of the dataSource that best matches the user's request, or \"invalid\" if you are unable to determine which dataSource the user is attempting to view data from. This should be one of the following values:\n${dsIDs}\n";
isc.A.dataBoundUIInitiatorSuffix="Your response should contain the JSON block and no other text.\nAn example of a valid response might be:\n${responseExample}";
isc.A.generalDataBoundUICodeNotes="Notes:\n- The \"dataSource\" attribute of the component should be set to the ID of the dataSource.\n- In order to fetch data to display, \"autoFetchData\" should be set to true.\n- If criteria should be applied to the fetch, the \"initialCriteria\" attribute should be specified as a SmartClient AdvancedCriteria object.\n- If some form of data aggregation or summarization is required---for example a list of each unique value for some field along with a count of records, or sum of some other numeric field value within that group---this can be achieved by customizing the DSRequest that is used to fetch data for the component. The \"fetchRequestProperties\" attribute for the component can be used to set appropriate \"groupBy\" and \"summaryFunctions\" attributes for the data fetch.\n";
isc.A.dataBoundUICodePrefixPrompts=[
"A user is interacting with an Isomorphic SmartClient web application. They have requested a new ${componentType} component to display data from a dataSource in some way. The user request is as follows:",
"${userMessages}",
"The DataSource has the following summary:\n${dsSummary}\nPlease generate JavaScript code to create a SmartClient ${componentType} bound to this dataSource that meets the user's request.\n${this.generalDataBoundUICodeNotes}${componentCodePrompt}.\n\n"
];
isc.A.$274t="asyncBuildDataBoundUI";
isc.A.fencedCodeRegex=new RegExp("^```(?:javascript)?\\s*\\n((.|\n)*)\\n```","im");
isc.A.autoLoadDataSource=true;
isc.A.dataSourceName="serverAIDataSource";
isc.A.dataSources={};
isc.A.$257l={};
isc.A.$257k={};
isc.A.spoofedResponseDelay=2000;
isc.A.responseSpoofingMode="hybrid";
isc.A.captureTransactions=false;
isc.A.capturedTransactions=[];
isc.A.$2882="ai_capturedTransactions";
isc.A.$259j=[];
isc.A.initiatorPromptTemplate="This is an Isomorphic SmartClient AI Assistant Request (version 1.0).\n*** Overview ***\nFor an Isomorphic SmartClient AI Assistant Request, you are to act as an intelligent agent assisting a user in an Isomorphic SmartClient application.\nDetails of the application and the user request text will be provided at the end after this overview.\nYou should respond to this request with a response in the following structured format. Note that text in square brackets is descriptive. Any other text should be included verbatim:\n\nResponseType: [a response type, as explained below]\nMessage: [a message to be shown to the user, either explaining what you have done or asking for clarifications]\nMessageType: [a message type, as explained below]\n======\n[JavaScript code to perform a requested action when executed in the context of the SmartClient application. Note that the JavaScript should contained between a delineator of 6 equal signs, as shown here. Certain response types (described below) do not require any JavaScript code - in these cases the response may omit this entire block including both sets of equal signs.]\n======\n\n** Response Types **\nThere are six possible response types, described in the following section. \nNote that these are not listed in order of preference - you should choose the appropriate response type based on the prompt you received.\nImmediately after the numeral is the text value you should use for the \"ResponseType\" when responding. Do not include the numeral.\n\n1. Execute JavaScript\nProduce JavaScript code to do what the user wants, along with an explanation of what you have done, to be shown to the user.\nThis ResponseType is appropriate only to perform the same set of actions that a normal user can perform via the running SmartClient application's user interface, and any changes applied to the UI should be reversable by the user, using the UI.\nThis is typically limited to interacting with existing components on the page.\nThe JavaScript you generate should be valid JavaScript and may make use of the Isomorphic SmartClient JavaScript framework APIs.\n* Important Note *\nDetails of the currently visible UI of the application are below in the section titled \"SmartClient application and environment information\"Components listed in this summary may be accessed may be accessed directly by their \"ID\" property, or by passing this property into \"isc.Canvas.getById();\".\nOther documented SmartClient APIs may also be used.\nIf your code either causes a JavaScript error or times out, this will be reported to you.\nThe Message should be some text to display to the user, explaining what was done.\nThe MessageType may be set to either \"Notify\" or \"Modal Message\". MessageType \"Notify\" will show the message as a notification that auto-hides. MessageType \"Modal Message\" will show the message in a modal dialog that the user must explicitly dismiss before proceeding.\nSome examples of requested actions that would require an \"Execute JavaScript\" type response include:\n- Applying sorting to an existing listGrid via \"listGrid.sort();\" or \"listGrid.setSort();\"\n- Changing the filter criteria applied to an existing listGrid via \"listGrid.setFilterEditorCriteria();\" or \"listGridID.filterData();\"\n- Switching to a different tab in a TabSet via \"tabSet.selectTab();\"\nIf the user prompt requires a new UI be created, do not use the \"Execute JavaScript\" response type - use \"Ad Hoc UI\" instead.\n\n2. Ad Hoc UI\nYour generated JavaScript code creates an \"ad hoc\" UI to do whatever the user needs to do.  \nIn this case, the JavaScript code you specify should create SmartClient user interface components. The code will be captured in the same way that SmartClient captures \"screens\" (as in the RPCManager.loadScreen() API) and SmartClient will automatically display the result in a Window component. \nYour code does not need to include this Window component - just create the appropriate UI and it will be displayed to the user as appropriate.\nWhen the Window is closed, the ad-hoc UI created by your code will be destroyed (as in Canvas.destroy()).\nAs with \"Execute JavaScript\":\nThe code you generate should be valid JavaScript and may make use of the Isomorphic SmartClient JavaScript framework APIs.\nThe Message should be some text to display to the user, explaining what was done.\nThe MessageType may be set to either \"Notify\" or \"Modal Message\".\nThe \"Ad Hoc UI\" response type is appropriate for situations where the underlying DataSources provide the ability to achieve the end user's goals, but the UI does not provide an easy way to do what the user wants.  \nSome examples of requested actions that would require an \"Ad Hoc UI\" type response include:\n- Creating an aggregated view of dataSource data when none is available in the default UI. This could be achieved by creating a new ListGrid bound to the appropriate dataSource, and setting \"groupBy\" and  \"summaryFunctions\" on the \"dsRequest\" object passed to listGrid.filterData().\n- Displaying data from a dataSource in a chart by creating a new FacetChart bound to the dataSource, using the \"valuePrompt\" and \"facetFields\" to specify which attributes to chart, and calling fetchData() or filterData() to populate it.\nIn your other kinds of responses, if it's possible to create an ad-hoc UI to do what the user needs, be sure to mention that to the user.  And, if the user specifically requests an ad-hoc UI, take that as a suggestion to use this approach (unless another approach, such as \"Inspect\", is appropriate first).\n\n3. Clarify\nAsk the user for clarifying information.\nFor this type of response, the \"Message\" you specify can be used to ask the user a question. You should not show this message to the user - the application will show it in a modal dialog where the user may type in a response. The user's response will be sent back to you, allowing you to take further action.\nAny \"MessageType\" you specify will be ignored for \"Clarify\" type responses.\n\"Clarify\" type responses do not need to include any JavaScript, but if you do include JavaScript it will be executed in the scope of the application. This allows you to programatically gather information about the current application by using the \"isc.AI.commandComplete()\" method.\nIf you want to make use of this capability, consider the following points when generating your JavaScript code.\n- Your code should always include a call to the method \"isc.AI.commandComplete();\". This method takes a single argument, which can be any JavaScript object or primitive, and we will send this back to you (in addition to the user's response to your question). For example you could determine the current set of (visible) field names in a listGrid by calling \"isc.AI.commandComplete(listGrid.getFieldNames())\".\n- Your code can make use of asynchronous APIs; when your inspection code is complete, it should call the API isc.AI.commandComplete() method, passing any object that can be serialized to JSON. For an asynchronous action, this would typically be done in a callback function.\nFor example - if you wanted to find the total number of records in a DataSource, you could invoke\n  dataSource.fetchData(\n    // criteria - unrestricted fetch\n    null,\n    // callback function\n    function (dsResponse, data, dsRequest) {\n        isc.AI.commandComplete(dsResponse.totalRows);\n    },\n    // dsRequest configuration - use startRow and endRow to avoid returning actual records\n    { startRow:0, endRow:0 }\n  );\nIf you want to return information gathered from multiple APIs, you can combine all necessary information into a single JSON object which your code passes to isc.AI.commandComplete().\n\n4. Inspect\nGenerate JavaScript to gather information\nSimilar to the \"Clarify\" ResponseType explained above, you can generate JavaScript to gather information about the application environment, and have it sent back to you by calling \"isc.AI.commandComplete()\".\nUnlike \"Clarify\" responses, \"Inspect\" responses do not prompt the user for information.\nIf you do include a \"Message\", it will be displayed to the user as either a \"Notification\" or \"Modal Message\" depending on the \"MessageType\" you specified.\nIf necessary you may generate repeated \"Inspect\" type responses to gather multiple pieces of information about the application before finally deciding upon an interactive response to the user, via one of the other ResponseTypes.\n\n5. Send A Message\nThe \"Send A Message\" response type will cause the specified \"Message\" to be displayed to the user and take no other action.\nThis response type should not include any JavaScript to execute.\nThis is useful for cases where you simply want to display a message to the user.\n\n6. Explain Why Not\nExplain to the user that what they want cannot be done, and why.  \nIf possible, provide suggestions for how they might achieve their goals instead, including by contacting other people with administrative access to data.\nThe explanation you provide as the \"Message\" for this response type will appear in a modal SmartClient Window, with a text field below offering the user the ability to provide a revised or clarified command, or the ability to cancel the overall AI interaction.\nThis response type should not include any JavaScript to execute.\nYou should not show this message to the user - the application will show it, according to the MessageType you provide.\n\n** Example **\nAn example of a validly formatted response is below.\nThis response might be appropriate for the following user prompt:\n  \"Show the filterEditor on my listGrid and filter it to only show items that are less than $100 and customer's name contains 'Schwabb'\"\nIn this case we're assuming the application has a listGrid with the ID \"myListGrid\" with fields \"unitCost\" and \"customer\".\nExample response:\n\nResponseType: Execute JavaScript\nMessage: The filter editor for your listGrid has been displayed and the listGrid has been filtered to show only items with unitCost less than $100, where the customer name contains the string \"Schwabb\".\nMessageType: Notify\n======\nmyListGrid.setProperties({showFilterEditor:true});\nmyListGrid.filterData({\n    _constructor:\"AdvancedCriteria\",\n    operator:\"and\",\n    criteria:[\n        {fieldName:\"unitCost\", operator:\"lessThan\", value:100},\n        {fieldName:\"customer\", operator:\"iContains\", value:\"Schwabb\"},\n    ]\n});\n======\n\nDetails about the running application, and the user request are below.\n*** End of overview ***\n";
isc.A.suggestRecordSummaryTitlePrompts=[
"This is a request for a suggested title for a new field of a DataSource. This new field will contain the following information for each record:",
"${ssMessages}",
"The DataSource has the following summary: ${dsSummary}"
];
isc.A.suggestRecordSummaryTitlePrompts_visibleFields="The suggested title should be short (at most 40 characters), succinctly describe the information that will be contained in the new field, and be similar in style to the titles in the following map from existing field names to their titles:\n";
isc.A.suggestRecordSummaryTitlePrompts_noVisibleFields="The suggested title should be short (at most 40 characters) and succinctly describe the information that will be contained in the new field. Each word of the suggested title should be capitalized.";
isc.A.suggestRecordSummaryTitlePrompts_final="Your response should be a single JSON object with one key \"suggestedTitle\" and value being a string containing the suggested title for the new field.";
isc.A.$274u="asyncBuildAIFieldRequest";
isc.A.buildAIFieldRequestTemplatedString=isc.trimDoc`
        In the context of an Isomorphic SmartClient application, this is a request for
        information about the task of generating supplemental data for each record in the
        '\${dsName}' DataSource.

        \${dsSummary}

        The supplemental data that will be generated for each record is:
        <supplemental-data-description>\${aiFieldPrompt}</supplemental-data-description>

        Note: In the supplemental-data-description, disregard directions to "sort by", "order by",
        or similar that do not describe the supplemental data to generate.

        You must decide what class of supplemental data ("valueClass") is described by the
        supplemental-data-description. The options are:
        * "general": Any kind of data. Usually this is textual, but not necessarily always so.
          An example would be a "2-4 sentence summary".
        * "categorical": A fixed list of categories or nominal values. An example would be the
          type of customer issue (e.g. "Technical Issue", "Billing Issue", "General Inquiry").
        * "ordinal": An extension of "categorical" where the categories are also strictly
          ordered from lowest/least to highest/most. An example would be customer satisfaction
          (e.g. "Dissatisfied", "Neutral", "Satisfied", "Very Satisfied").
        * "interval": Strictly numerical data. An example would be temperature in degrees Celsius.
        * "ratio": An extension of "interval" where 0 means the absence of something, and ratios
          between values are meaningful. An example would be weight in pounds, because 0 means
          no weight and 200 pounds is twice as heavy as 100 pounds.

        Your response must be a JSON object with the following properties:
        * "fieldSummaries" (object): A map from the name of each field to a string containing
          a shortened summary of all of the following details that you infer about the
          field\${haveSampleData ? " using the given sample data and" : ""} from the field's title,
          description, and other available information:
            - Whether the field's values are possibly relevant or not at all relevant to the
              task of generating the supplemental data for each record according to the
              supplemental-data-description.
            - For numeric fields, the units of the field's values if applicable,
              or whether the units are unknown.
            - The pattern or format of the field's values.
            - Whether the field's values may be \`null\`, and if so, what the meaning or significance
              of \`null\` is.
            - Any assumptions that you are making about the field's values.
            - Any uncertainties that you have about the field's values.
        * "relevantFieldNames": An array of the names of the fields of the '\${dsName}'
          DataSource that are possibly relevant to generating the supplemental data for each
          record according to the supplemental-data-description.
        * "irrelevantFieldNames": An array of the names of the fields of the '\${dsName}'
          DataSource that appear to be irrelevant to generating the supplemental data for each
          record according to the supplemental-data-description.
        * "valueClass": The "valueClass" for the requested supplemental data, either
          "general", "categorical", "ordinal", "interval", or "ratio".
        * "dataDependentReason" (only if the "valueClass" is "categorical" or "ordinal", it
          is absolutely not possible to make any reasonable choices for the categories without
          examining all of the records in the DataSource, and the data of the records reasonably
          appears to contain the categories): A string containing an explanation of why the list
          of categories absolutely depends on the records in the DataSource.
        * "categories" (only if the "valueClass" is "categorical" or "ordinal" and reasonable
          choices can be made about the categories [i.e. not data-dependent]): An array of the
          category label strings. If the "valueClass" is "ordinal", this array must list the
          categories from lowest/least value to highest/most value. This is not the
          same as your choice for "displayDirection".
        * "categoryHints" (only if the "valueClass" is "categorical" or "ordinal"): An object
          that maps each category label string to a hint for when to use that category rather
          than the other categories.
        * "minValue" (only if the "valueClass" is "interval" or "ratio" and the supplemental-data-description
          specifies or reasonably implies a minimum value): The minimum value as a number.
        * "maxValue" (only if the "valueClass" is "interval" or "ratio" and the supplemental-data-description
          specifies or reasonably implies a maximum value): The maximum value as a number.
        * "displayDirection" (only if the "valueClass" is "ordinal", "interval", or "ratio"):
          If the highest/most values are most emotionally-positive, or most optimistic, or
          likely to be most of interest, specify "most-to-least" (so that the most positive or
          most of interest values appear first).
          Otherwise, specify "least-to-most".
        * "displayDirectionReasoning" (only if the "valueClass" is "ordinal", "interval", or "ratio"):
          A string containing a shortened summary of your reasoning behind your choice of "displayDirection".
    `;
isc.A.invalidSummaryValue="-";
isc.A.$2693="partialResult,context";
isc.A.summarizeRecordsPrompts_general=[
"This is a request to supplement the data in records from a DataSource, using relevant general knowledge and your own reasonable inferences from the data. The supplemental information requested for each record is:",
"${ssMessages}",
"The records specified below are from the DataSource with the following description: ${dsSummary}\n\nYour response should be a single JSON object with one key \"result\" and value being an array of just the strings of supplemental information for each corresponding record. Here are the records:"
]
;
isc.B.push(isc.A.$267s=function isc_c_AI__asyncBuildCriterionWithSummarizedUserMessages(_1,_2){
if(_2.$274w.canceled){
throw _2.$274w.asCanceledResult()}
var _3=isc.InternalAIMessagesBuilder.create({
userMessages:_1,
target:this,
evalVars:{
purpose:_2.buildRequest.purpose,
referenceTime:_2.referenceTime,
dsSummary:"${dsSummary}",
dataSource:_2.dataSource
}
});
if(_2.mode=="aiAssist"){
_3.renderTemplate("buildCriterionAIAssistPrompt")}else if(_2.mode=="AIDE"){
_3.appendPrompts(this.applyAIFilterPrompts)}else{
_3.renderTemplate("buildCriterionHybridPrompt")}
var _4={
messages:_3.aiMessages,
responseType:"object"
};
var _5=this.$2679(_4);
if(_5.errorMessage)return isc.rejectWithError(_5.errorMessage);
var _6=_2.dataSource.getAllFields();
var _7=_5.aiEngine.shouldUseAIFieldPaging(_4,_6,_2.$261g);
if(!_7){
return this.$267t(_6,_4,_2)}
++_2.$261w;
this.$262i(_2,[{category:"detail",content:isc.AI.willSubsetFieldsDetailMessage}],true);
return _5.aiEngine.asyncRetrieveFieldsForPrompt(
_4.messages,
"Filter data-records according to the user's description of the filter criteria",
_6,
_5,
_2.$261g)
.then(function(_8){
++_2.$261v;
isc.AI.$262i(_2,[{category:"success",content:isc.AI.finishedSubsettingFieldsDetailMessage}]);
return isc.AI.$267t(
_8,_4,_2)})}
);
isc.evalBoundary;isc.B.push(isc.A.$267t=function isc_c_AI__asyncBuildCriterionWithFinalFields(_1,_2,_3){
if(_3.$274w.canceled){
throw _3.$274w.asCanceledResult()}
if(_1==null||(_1.removeEmpty(),_1).isEmpty()){
const _4=_3.buildRequest.purpose;
throw isc.createErrorResult("No fields were selected for use in building the "+
(_4||"filter")+" criterion.")}
_3.$261z=_1;
var _5=this.render("summarizeDataSource",{
dataSource:_3.dataSource,
fields:_1
});
_3.$263q=_5;
if(_3.mode=="AIDE"){
return Promise.resolve(this.$2663(_3))}
var _6={
dsSummary:_5
};
var _7={
cancellationController:_3.$274w,
messages:_2.messages.map(function(_13){
if(_13.source=="system"&&isc.AIEngine.$272z(_13.type)){
return{
source:_13.source,
content:String(_13.content).evalDynamicString(this,_6)
}}
return _13},this),
responseType:_2.responseType,
willHandleError:true
};
if(!_3.$274w.canceled&&_3.$261x)_3.$261x.show();
return this.asyncSendRequest(_7,_3.$261g)
.then(function(_13){
++_3.$261v;
isc.AI.$262i(_3);
const _8=_13.message.content;
if(isc.isAn.Object(_8)&&_8.result!="invalid"){
if(_8.result=="method2"){
return isc.AI.$2663(_3)}
var _9;
if(isc.isAn.Object(_8.result))_9=_8.result
else _9=_8;
if(_3.dataSource.isAdvancedCriteria(_9)){
var _10=isc.AI.$268v(_9);
return isc.AI.$268w(_10,_3)}
}
let _11=isc.AI.aiNotAbleToProcessRequestErrorMessage;
if(_8&&isc.isA.String(_8.invalidReasoning)){
const _12=_8.invalidReasoning.trim();
if(_12.length)_11=_12.asHTML()}
throw isc.createErrorResult(_11)})}
,isc.A.$268w=function isc_c_AI__asyncValidateAdvancedCriteria(_1,_2,_3){
var _4=_2.$261z.makeIndex("name"),
_5=[],
_6=this.$268x(isc.DS.copyCriteria(_1),
_4,
_2.dataSource,
_5);
if(_6&&_5.isEmpty()){
return Promise.resolve(_6)}
if(_3){
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
++_2.$261w;
this.$262i(_2,[{category:"error",content:"AI generated invalid criteria. Will request a fix..."}]);
var _7=isc.JSONEncoder.create({
dateFormat:"logicalDateString",
strictQuoting:true
});
var _8=isc.InternalAIMessagesBuilder.create({
userMessages:_2.$2615,
target:this,
evalVars:{
dsSummary:_2.$263q,
encodedCriterion:_7.encode(_1),
validationErrors:_5.join("\n"),
encodedValidatedCriterion:_6&&_7.encode(_6)
}
});
_8.appendPrompts(this.fixCriterionPrompts);
var _9={
messages:_8.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_9,_2.$261g)
.then(function(_12){
++_2.$261v;
isc.AI.$262i(_2);
var _10=_12.message.content;
if(_2.dataSource.isAdvancedCriteria(_10)){
var _11=isc.AI.$268v(_10);
return isc.AI.$268w(_11,_2,true)}else{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
})}
,isc.A.$268v=function isc_c_AI__maskCriterion(_1,_2,_3){
if(_1.operator=="and"||
_1.operator=="or"||
_1.operator=="not")
{
var _4=_1.criteria;
_1={
operator:_1.operator,
criteria:_4
};
if(!isc.isAn.Array(_4))_4=_1.criteria=[_4];
for(var i=0;i<_4.length;){
var _6=_4[i];
if(_6==null){
_4.removeAt(i);
continue}
if(isc.isAn.Array(_6)){
_4.addListAt(_6,i);
_6=_4[i]}
if(isc.isAn.Object(_6))_4[i]=this.$268v(_6,_2,true);
++i}
}else{
_1=isc.applyMask(_1,_2||this.allowedCriterionPropertyNames)}
if(!_3)_1._constructor="AdvancedCriteria";
return _1}
,isc.A.$268x=function isc_c_AI__validateCriterion(_1,_2,_3,_4,_5){
if(!_1.operator){
_4.push("A criterion was missing the 'operator'.");
return null}
var _6=_1.operator,
_7=_3.getSearchOperator(_6);
if(!_7||!this.$268u.contains(_6)){
_4.push("Operator '"+_6+"' is not allowed.");
return null}
if(_7.valueType=="none"){
delete _1.value}else if(_7.valueType=="criteria"){
var _8=_1.criteria;
if(!isc.isAn.Array(_8))_8=_1.criteria=[_8];
for(var i=0;i<_8.length;){
var _10=_8[i];
if(_10==null){
_8.removeAt(i);
continue}
if(!isc.isAn.Object(_10)){
_4.push("A subcriterion was not an object.");
_8.removeAt(i);
continue}
var _11=_8[i]=this.$268x(
_10,_2,_3,_4,true);
if(!_11){
_8.removeAt(i);
continue}
++i}
}else if(_7.valueType&&_7.valueType!="fieldType"){
_4.push("Operator '"+_6+"' is not allowed because the operator valueType is '"+_7.valueType+"'.");
return null}else{
var _12=_1.fieldName;
if(!_12){
_4.push("The '"+_6+"' criterion was missing the 'fieldName'.");
return null}
var _13=(!_2
?_3.getUnderlyingField(_12)
:_2[_12]);
if(!_13){
_4.push("The '"+_6+"' criterion referenced field '"+_12+"', but that field is not allowed.");
return null}
}
if(!_5){
_1=_3.validateCriteria(_1);
_1=this.$268y(_1,_2,_3,_4);
_1=isc.DS.simplifyAdvancedCriteria(_1,true)}
return _1}
,isc.A.$268y=function isc_c_AI__validateCriterion2(_1,_2,_3,_4,_5){
var _6=_1.operator,
_7=_3.getSearchOperator(_6);
this.$102q(_7!=null);
if(_7.valueType=="criteria"){
var _8=_1.criteria;
this.$102q(isc.isAn.Array(_8));
for(var _9=_8.length;_9>0;--_9){
var i=_9-1,
_11=_8[i];
var _12=_8[i]=this.$268y(
_11,_2,_3,_4,true);
if(!_12){
_8.removeAt(i)}
}
}else if("fieldName"in _1){
var _13=_1.fieldName,
_14=(!_2
?_3.getUnderlyingField(_13)
:_2[_13]);
var _15=_3.getFieldOperators(_14);
if(!_15||!_15.contains(_6)){
_4.push("Operator '"+_6+"' is not allowed for field '"+_13+"'.");
return null}
}
return _1}
,isc.A.$2663=function isc_c_AI__buildAIFilter(_1){
var _2=_1.dataSource.getPrimaryKeyFieldNames();
var _3,
_4;
if(_2.length==1){
_3=isc.Set.create();
_4=isc.Set.create()}else{
_3=isc.TupleSet.create();
_4=isc.TupleSet.create()}
var _5=_1.buildRequest.$2664;
if(_5)isc.AI.$2665(_5);
else _5={};
isc.addProperties(_5,{
_constructor:"AdvancedCriteria",
operator:"aiFilter",
userAIRequest:_1.buildRequest.userAIRequest,
isTrivial:false,
$2615:_1.$2615,
$264d:_1.dataSource.getID(),
$263s:_2,
$263t:_1.$261z.getProperty("name"),
$263q:_1.$263q,
$263v:_3,
$2667:null,
$264f:_4,
$2631:true,
clone:isc.AI.$2668
});
return _5}
,isc.A.$267u=function isc_c_AI__createApplyAIFilterContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
this.$102q(_2.aiCriterion.operator=="aiFilter");
var _5=_2.aiCriterion&&_2.aiCriterion.$264d;
_4.dataSource=_5&&isc.DS.get(_5);
if(_2.showProgressDialog==true){
_4.$261x=isc.FilterViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
})}
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.applyAIFilter=function isc_c_AI_applyAIFilter(_1,_2){
this.$2677(this.$274r,_1,_2)}
,isc.A.asyncApplyAIFilter=function isc_c_AI_asyncApplyAIFilter(_1){
return this.$274v("$267w",_1)}
,isc.A.$267w=function isc_c_AI__asyncApplyAIFilter(_1,_2){
if(!_1.aiCriterion||_1.aiCriterion.operator!="aiFilter"){
return isc.rejectWithError("The 'aiFilter' AdvancedCriteria to evaluate is required.")}
if(!_1.records){
return isc.rejectWithError("The records to apply the AI filter to are required.")}
var _3=this.$267u(this.$274r,_1,_2),
_4=_3.dataSource;
if(!_4||!isc.AI.$262k(_4,"AIDE")){
_3.$267o.reject(isc.createErrorResult(isc.AI.dataSourceIsRequiredErrorMessage))}else{
var _5=_1.aiCriterion;
this.$102q(_5.operator=="aiFilter");
if(!isc.AI.$267a(_5,_4)){
_3.$267o.reject(isc.createErrorResult("The 'aiFilter' criterion is not usable."))}else{
this.$267v(_5,_3)
.then(function(_6){
_3.$267o.resolve({type:"success",matchingRecords:_6})},function(_6){
_3.$267o.reject(isc.defaultAsyncOperationCatchCallback(_6))})}
}
return _3.$267o.promise}
,isc.A.$267v=function isc_c_AI__asyncApplyUsableAICriterion(_1,_2){
var _3=_2.applyRequest.records,
_4=_2.applyRequest.$267i||isc.AI.$267j(_1,_3,_2.dataSource);
this.$102q(_4&&
isc.isAn.Array(_4.matchingRecords)&&
_4.matchingRecords.length+(_4.remainingRecords==null
?0
:_4.remainingRecords.length)==_3.length);
if(!_4.remainingRecords||_4.remainingRecords.length==0){
return Promise.resolve(_4.matchingRecords)}
return this.$274y(_4,_1,_2)}
,isc.A.$274y=function isc_c_AI___asyncApplyAIFilter(_1,_2,_3){
if(_3.$274w.canceled){
return Promise.reject(_3.$274w.asCanceledResult())}
var _4=isc.InternalAIMessagesBuilder.create({
userMessages:_2.$2615,
target:this,
evalVars:{dsSummary:_2.$263q}
});
_4.appendPrompts(this.applyAIFilterPrompts);
var _5=_4.aiMessages;
var _6=_1.remainingRecords,
_7=_6.getLength(),
_8=Promise.withResolvers();
var _9=function(){
if(_3.$274w.canceled){
return false}
++_3.$261v;
isc.AI.$262i(_3,null,true)};
var _10={
fieldNames:_2.$263t,
aiPageSize:_3.applyRequest.aiPageSize,
maxRetries:_3.$261g.maxRetries,
serializationFormat:_3.$261g.serializationFormat,
progressCallback:_9
};
var _11=this.$2678(_5);
if(_11.errorMessage)return isc.rejectWithError(_11.errorMessage);
var _12=_11.aiEngine.doPageRecordsPicking(_5,_6,function(_22,_23){
if(_3.$274w.canceled)return;
var _13=_23.find({_constructor:"AdvancedCriteria",fieldName:"nonSuccessfulResult",operator:"notNull"});
if(_13){
_8.reject(_13.nonSuccessfulResult);
return}
_1.matchingRecords.addAll(_22);
var _14=_2.$263s;
var _15=_2.$263v,
_16=null,
_17=_2.$264f;
if(_14.length==1){
var _18=_14[0];
for(var i=0;i<_22.length;++i){
_17.add(_22[i][_18])}
for(var i=0;i<_7;++i){
var _20=_6.get(i)[_18];
if(!_17.has(_20)){
_15.add(_20)}
}
if(!_15.isEmpty()){
_16={
_constructor:"AdvancedCriteria",
fieldName:_18,
operator:"notInSet",
value:_15.getContents()
}}
}else{
isc.AI.$102q(false)}
_2.$2667=_16;
isc.AI.$262i(_3,null,true);
_8.resolve(_1.matchingRecords)},_10);
var _21=_12.batches.length;
_3.$261w+=_21;
this.$262i(_3,[{category:"detail",content:"AI will evaluate the criteria in "+_21+" batch(es) of records."}],true);
return _8.promise}
,isc.A.removeFromAIFilterCaches=function isc_c_AI_removeFromAIFilterCaches(_1,_2){
if(_1.operator!="aiFilter"){
this.logWarn("The AdvancedCriteria passed to removeFromAIFilterCaches() has operator '"+
_1.operator+"'; expecting 'aiFilter'.","AI");
return}
var _3=_1.$263s,
_4=_1.$263v,
_5=_1.$264f;
if(!isc.isA.Class(_4)){
_4=_1.$263v=null;
_1.$2667=null}
if(!isc.isA.Class(_5)){
_5=_1.$264f=null}
if(!isc.isAn.Array(_3))return;
if(_3.length==1){
var _6=_3[0];
if(isc.isA.Class(_4)){
var _7=false;
for(var _8=0;_8<_2.length;++_8){
if(_4.remove(_2[_8][_6]))_7=true}
if(_7){
_1.$2667={
_constructor:"AdvancedCriteria",
fieldName:_6,
operator:"notInSet",
value:_4.getContents()
}}
}
if(isc.isA.Class(_5)){
for(var _8=0;_8<_2.length;++_8){
_5.remove(_2[_8][_6])}
}
}else{
this.$102q(false)}
}
,isc.A.clearAIFilterCaches=function isc_c_AI_clearAIFilterCaches(_1){
if(_1.operator!="aiFilter"){
this.logWarn("The AdvancedCriteria passed to clearAIFilterCaches() has operator '"+
_1.operator+"'; expecting 'aiFilter'.","AI");
return}
if(isc.isA.Class(_1.$263v)){
_1.$263v.clear()}
_1.$263v=null;
_1.$2667=null;
if(isc.isA.Class(_1.$264f)){
_1.$264f.clear()}
_1.$264f=null}
,isc.A.asyncReapplyAIFilter=function isc_c_AI_asyncReapplyAIFilter(_1){
if(!_1.aiCriterion||_1.aiCriterion.operator!="aiFilter"){
return isc.rejectWithError("The 'aiFilter' AdvancedCriteria to re-apply is required.")}
if(!isc.isAn.Array(_1.updatedRecords)){
return isc.rejectWithError("The updated records are required.")}
this.removeFromAIFilterCaches(_1.aiCriterion,_1.updatedRecords);
var _2=isc.addProperties({},_1,{
showProgressDialog:_1.showProgressDialog!=true,
records:_1.updatedRecords,
updatedRecords:null
});
return this.asyncApplyAIFilter(_2)
.then(function(_3){
_3.matchingUpdatedRecords=_3.matchingRecords;
delete _3.matchingRecords;
return _3})}
,isc.A.$2701=function isc_c_AI__createBuildHilitesContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
_4.dataSource=_3.dataSource;
var _5=_2.mode;
if(_5==null)_5="hybrid";
else if(_5!="aiAssist"&&_5!="AIDE"&&_5!="hybrid"){
this.logWarn("unsupported AI service mode '"+_5+"'. Switching to 'hybrid'.");
_5="hybrid"}
_4.mode=_5;
if(_2.showProgressDialog==null||_2.showProgressDialog){
_4.$261x=isc.HiliteViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
})}
_4.$261w=2;
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildHilites=function isc_c_AI_buildHilites(_1,_2){
this.$2677(this.$274s,_1,_2)}
,isc.A.asyncBuildHilites=function isc_c_AI_asyncBuildHilites(_1){
return this.$273t("$274z",_1)}
,isc.A.$274z=function isc_c_AI__asyncBuildHilites(_1,_2){
var _3=this.$2701(this.$274s,_1,_2),
_4=_3.dataSource;
if(!_4||!isc.AI.$262k(_4,_3.mode)){
_3.$267o.reject(isc.createErrorResult(isc.AI.dataSourceIsRequiredErrorMessage))}else{
this.$267p(_3)
.then(function(_5){
return isc.AI.$2702(
_5,_3)})
.then(function(_5){
_3.$267o.resolve({type:"success",hilites:_5})},function(_5){
_3.$267o.reject(isc.defaultAsyncOperationCatchCallback(_5))})}
return _3.$267o.promise}
,isc.A.$270z=function isc_c_AI__extendColorMap(){
var _1=this.$270x;
_1.lightgrey=_1.lightgray;
_1.grey=_1.gray;
_1.darkgrey=_1.darkgray;
_1.silver=_1.gray;
_1.platinum=_1.lightgray}
,isc.A.$2702=function isc_c_AI__asyncBuildHilitesWithSummarizedUserMessages(_1,_2){
if(_2.$274w.canceled){
return Promise.reject(_2.$274w.asCanceledResult())}
var _3=isc.getValues(_2.dataSource.getFields());
var _4=isc.InternalAIMessagesBuilder.create({
cancellationController:_2.$274w,
userMessages:_1,
target:this,
evalVars:{
dsSummary:"${dsSummary}",
referenceTime:_2.referenceTime
}
});
_4.appendPrompts(this.buildHilitesPrompts);
var _5={
messages:_4.aiMessages,
responseType:"object"
};
return this.$2703(_2,_5,_3)}
,isc.A.$2703=function isc_c_AI__asyncBuildHilitesWithFinalFields(_1,_2,_3){
if(_1.$274w.canceled){
return Promise.reject(_1.$274w.asCanceledResult())}
if(_3==null||(_3.removeEmpty(),_3).isEmpty()){
return isc.rejectWithError("No fields were selected for use in building the Hilite.")}
_1.$261z=_3;
var _4=this.summarizeDataSource(_1.dataSource,_3,_1.$261g,false);
_1.$263q=_4;
var _5={
dsSummary:_4
};
var _6={
cancellationController:_1.$274w,
messages:_2.messages.map(function(_13){
if(_13.source=="system"&&isc.AIEngine.$272z(_13.type)){
return{
source:_13.source,
content:String(_13.content).evalDynamicString(this,_5)
}}
return _13},this),
responseType:_2.responseType,
willHandleError:true
};
if(!_1.$274w.canceled&&_1.$261x)_1.$261x.show();
return this.asyncSendRequest(_6,_1.$261g)
.then(function(_13){
var _7=_13.message.content&&_13.message.content.hiliteSpecs;
if(!isc.isAn.Array(_7)){
if(isc.isAn.Object(_7)){
_7=[_7]}else{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
}
for(var _8=_7.length;_8>0;--_8){
var i=_8-1,
_10=_7[i];
if(!isc.isAn.Object(_10)||
!isc.isA.String(_10.filterDescription)||
!isc.isA.String(_10.hiliteDescription)||
!_10.filterDescription.trim()||
!_10.hiliteDescription.trim())
{
_7.removeAt(i)}
}
if(_7.isEmpty()){
}
var _11=_7.length;
++_1.$261v;
isc.AI.$262i(_1,[{category:"success",content:"AI has determined the hilite styling and field(s) that should be hilited, for "+_11+" hilite(s)."},
{category:"detail",content:"Will now validate the hilite and apply the hilite criteria\u2026"}]);
var _12=isc.ResolvedValuesMapper.create({
values:_7,
cancellationController:_1.$274w,
maxConcurrent:3,
asyncMap:function(_10){
return isc.AI.$2704(_1,_10)}
});
return _12.getPromise()})}
,isc.A.$291c=function isc_c_AI__getCSSColorNames(){
if(!this.$270y&&isc.ColorUtils&&isc.ColorUtils.colorNames){
this.$270y=isc.getKeys(isc.ColorUtils.colorNames)}
return this.$270y||[]}
,isc.A.$2700=function isc_c_AI__makeLikelyCSSColorRegExp(){
var _1="\\b(?:"+this.$291c().map(RegExp.$2680).join("|")+")\\b";
_1+="|#[a-f\\d]{3}(?:[a-f\\d](?:[a-f\\d]{2}(?:[a-f\\d]{2})?)?)?\\b";
var _2="(?:[-+]?\\d+(?:\\.\\d*)?(?:[Ee][-+]?\\d+)?%?)";
_1+="|rgba?\\(\\s*"+_2+"\\s*,?\\s*"+_2+"\\s*,?\\s*"+_2+
"(?:\\s*,\\s*"+_2+")?\\)";
this.$2705=new RegExp(_1)}
,isc.A.$2706=function isc_c_AI__extractLikelyCSSColor(_1){
this.$2705.lastIndex=0;
var _2=this.$2705.exec(_1);
return _2&&_2[0]}
,isc.A.$2707=function isc_c_AI__validateCSSColor(_1,_2){
var _3=_1[_2];
if(!isc.isA.String(_3)){
delete _1[_2];
return}
_3=_3.trim().toLowerCase();
var _4;
for(var _5=new RegExp("[a-z]+","g"),_6=_5.exec(_3);_6;_6=_5.exec(_3)){
_4=this.$270x[_6[0]];
if(_4){
break}
}
if(!_4){
_4=this.$2706(_3)}
if(!_4)delete _1[_2];
else _1[_2]=_4}
,isc.A.$2708=function isc_c_AI__removeCSSComments(_1){
var _2=0;
do{
_2=_1.indexOf("/*",_2);
if(_2<0)return _1;
var _3=_1.indexOf("*/",_2+1);
if(_3<0){
return _1.substring(0,_2)}
_1=_1.substring(0,_2)+_1.substring(_3+2)}while(_2<_1.length);
return _1}
,isc.A.$2709=function isc_c_AI__removeCSSProperty(_1,_2,_3,_4){
var _5;
var _6=new RegExp("[\\s;]*"+RegExp.$2680(_2)+"\\s*:([^;]*)[\\s;]*","gim");
var _7;
while(_7=_6.exec(_1)){
_5=_7[1]+" "+(_5||"");
var _8=_1.substring(0,_6.lastIndex-_7[0].length),
_9=_1.substring(_6.lastIndex),
_10=!_8||!_9?"":";";
_1=_8+_10+_9;
_6.lastIndex-=_7[0].length}
_3[_4]=(_3[_4]||"")+" "+_5;
return _1}
,isc.A.$2704=function isc_c_AI__asyncValidateAndFinishHilite(_1,_2){
if(_2.fieldName!=null){
if(!isc.isAn.Array(_2.fieldName))_2.fieldName=[_2.fieldName];
for(var _3=_2.fieldName.length;_3>0;--_3){
var i=_3-1,
_5=_2.fieldName[i];
if(!_1.$261z.find("name",_5)){
isc.logWarn("AI selected an invalid field '"+_5+"'. Deleting...","AI");
_2.fieldName.removeAt(i)}
}
if(_2.fieldName.isEmpty())delete _2.fieldName;
else if(_2.fieldName.length==1)_2.fieldName=_2.fieldName[0]}
if(!isc.isA.String(_2.cssText)){
delete _2.cssText}else{
_2.cssText=this.$2708(_2.cssText);
_2.cssText=this.$2709(_2.cssText,"color",_2,"textColor");
_2.cssText=this.$2709(_2.cssText,"background-color",_2,"backgroundColor");
_2.cssText=this.$2709(_2.cssText,"text-decoration-color",_2,"$271a");
this.$2707(_2,"$271a");
if(_2.$271a){
if(_2.cssText)_2.cssText+="; ";
_2.cssText+="text-decoration-color: "+_2.$271a}
}
this.$2707(_2,"textColor");
this.$2707(_2,"backgroundColor");
if(!_2.textColor){
if(!_2.backgroundColor){
_2.textColor=this.$270x["red"]}else{
if(isc.ColorUtils.isDark(_2.backgroundColor)){
_2.textColor="#fff"}
}
}
var _6={
cancellationController:_1.$274w,
purpose:"hilite",
userAIRequest:{prompt:_2.filterDescription},
dataSource:_1.dataSource,
mode:_1.mode,
maxRetries:_1.buildRequest.maxRetries,
showProgressDialog:false
};
return isc.AI.asyncBuildCriterion(_6)
.then(function(_10){
var _7=isc.applyMask(_2,
["backgroundColor","textColor","cssText","fieldName","replacementValue"]);
var _8=_10.criterion;
_7.criteria=_8;
if(_8.operator!="aiFilter")return _7;
var _9={
cancellationController:_1.$274w,
aiCriterion:_8,
dataSource:_1.dataSource,
mode:_1.mode,
records:_1.buildRequest.records,
maxRetries:_1.buildRequest.maxRetries,
showProgressDialog:false
};
return isc.AI.asyncApplyAIFilter(_9)
.then(Promise.resolve(_7))})}
,isc.A.$2672=function isc_c_AI__validateAIBuiltUI(_1){
var _2=_1.buildRequest;
var _3=_1.$261c,
_4=_1.$261d,
_5;
var _6=function(){
_1.appliedValidationTypes.add(_5);
_4=_1.$261d=_4+1;
_1.$261e=0;
_1.$261f=null;
++_1.$261v;
isc.AI.$262i(_1,[{category:"success",content:"Finished applying '"+_5+"' validation"}])};
for(
;
_4<_3.length;
_6()
){
if(_1.$274w.canceled){
_1.$2671.reject(_1.$274w.asCanceledResult());
return}
_5=_3[_4];
var _7=Math.max(0,+_1.$261e);
if(isNaN(_7))_7=_1.$261e=0;
var _8=Math.max(0,_2.maxValidationRetries==null?1:_2.maxValidationRetries);
if(isNaN(_8))_8=1;
if(_7>_8){
_1.$2671.reject(isc.createErrorResult(
"Exceeded the maximum number of retries ("+_8+") for '"+_5+"' validation."
));
return}
var _9;
if(_5=="custom"){
_9=_2.customValidator;
this.$102q(_9!=null)}else if(_5=="default"){
_9={target:this,methodName:"buildUIViaAIDefaultValidator"}}
if(_9==null){
this.logWarn("validateAIBuiltUI(): Unhandled validation type '"+_5+"'");
continue}
this.fireCallback(_9,isc.AI.$265o,[
_1,
_1.$261f,
function(_12,_13){
var _10=String.prototype.trim.call(_12.jsCode||"");
_1.jsCode=_10;
_1.nodes=_12.nodes;
_1.$261f=_13;
var _11=_12.errorMessage;
if(_11!=null){
isc.AI.logDebug("validateAIBuiltUI(): validation type '"+_5+"' failed: "+_11,"AI");
_11="Validation type '"+_5+"' failed: "+_11;
if(_10==""){
_1.$2671.reject(isc.createErrorResult(
"Validation type '"+_5+"' failed: "+_11
));
return}
++_1.$261e;
if(_1.$261e<=_8){
try{
if(!new RegExp("\\p{P}$","u").test(_11))_11+="."}catch(e){}
if(!/\s$/.test(_11))_11+=" ";
_11+="Will retry\u2026"}
isc.AI.$262i(_1,[{category:"recoverableError",content:_11}])}else{
_6()}
isc.AI.$2672(_1)}
]);
return}
_1.$2671.resolve({
type:"success",
jsCode:_1.jsCode,
nodes:_1.nodes
})}
);
isc.evalBoundary;isc.B.push(isc.A.$261q=function isc_c_AI__getPaletteNodesAndValidationResult(_1,_2,_3){
var _4=function(_6,_7){
var _5;
try{
_5=isc.EditContext.validatePaletteNodeDefaults(_7)}catch(e){
_2(e);
return}
_3(_6,_5)};
isc.EditContext.createPaletteNodesFromJS2(_1,_4)}
,isc.A.buildUIViaAIDefaultValidator=function isc_c_AI_buildUIViaAIDefaultValidator(_1,_2,_3){
var _4=this;
var _5=function(_6){
_4.fireCallback(_3,isc.AI.$265p,[_6,_2])};
if(isc.EditContext==null){
return _5({
jsCode:_1.jsCode,
nodes:_1.nodes
})}
if(_2==null){
_2={
prevJsCode:[],
prevValidationResults:[]
}}
this.$261q(
_1.jsCode,
function(_6){
_4.logWarn("buildUIViaAIDefaultValidator(): Error attempting to validate AI-built code: "+_6);
_5({
errorMessage:"Attempting to validate AI-generated JavaScript caused an error: "+_6
})},
function(_6,_7){
_2.prevJsCode.add(_1.jsCode);
_2.prevValidationResults.add(_7);
if(_7==null||isc.isAn.emptyObject(_7)){
return _5({
jsCode:_1.jsCode,
nodes:_6
})}else{
_4.requestUICodeValidationFix(
_1,
_2,
_7,
_3
);
return}
}
)}
,isc.A.requestUICodeValidationFix=function isc_c_AI_requestUICodeValidationFix(_1,_2,_3,_4){
var _5=function(_13){
isc.AI.fireCallback(_4,isc.AI.$265p,[_13,_2])};
var _6=function(_13){
_5({
type:"error",
errorMessage:_13,
jsCode:_1.jsCode
})};
var _7=isc.InternalAIMessagesBuilder.create({
userMessages:_1.$2615,
target:this,
evalVars:{
jsCode:_1.jsCode,
errors:this.$260x(_3)
}
});
_7.appendPrompts(this.uiCodeValidationPrompts);
_7.appendPrompts(this.uiCodeSuffixPrompts);
var _8={
cancellationController:_1.$274w,
messages:_7.aiMessages,
willHandleError:true
};
this.asyncSendRequest(_8,_1.$261g)
.then(function(_11){
var _9=_11.message.content||"";
var _10=String.prototype.trim.call(isc.AI.extractFencedCode(_9));
if(_10==""){
return _6("AI returned no UI code in response to the request to generate corrected code.")}
isc.AI.$261q(
_10,
function(_13){
isc.AI.logWarn("requestUICodeValidationFix(): Error attempting to validate AI-built code: "+_13);
return _6("Attempting to validate AI-generated JavaScript caused an error: "+_13)},
function(_13,_14){
if(_14==null||isc.isAn.emptyObject(_14)){
return _5({
jsCode:_10,
nodes:_13
})}else{
_5({jsCode:_10,errorMessage:"AI returned code that failed validation. A request was made to correct the code."})}
}
)},function(_13){
var _11=isc.defaultAsyncOperationCatchCallback(_13);
if(_11.type=="canceled"){
var _12="An AI request was canceled. ";
if(_11.cancellationReason)_12+=_11.cancellationReason;
_5({type:_11.type,cancellationReason:_12});
return}
_6("An AI request failed: "+_11.errorMessage)})}
,isc.A.$2670=function isc_c_AI__createBuildUIViaAIContext(_1,_2,_3){
var _4=this.$267n(_1,_2,_3);
var _5=_2.$261c;
if(_5==null){
_5=isc.AI.defaultBuildUIViaAIValidationTypes}
if(_2.customValidator==null){
if(_5.contains("custom")){
_5=_5.duplicate();
_5.remove("custom")}
}else{
if(!_5.contains("custom")){
_5=_5.duplicate();
_5.add("custom")}
}
_4.$261c=_5;
_4.appliedValidationTypes=[];
_4.$261d=0;
_4.$261e=0;
_4.$261f=null;
_4.$2671=Promise.withResolvers();
_4.$261w=2+_5.length;
if(_2.showProgressDialog==null||_2.showProgressDialog){
_4.$261x=isc.BuildUIViaAIProgressDialog.create({
$266t:_4,
canCancel:_2.userCanCancel!=false
});
_4.$261x.show()}
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildDataBoundUI=function isc_c_AI_buildDataBoundUI(_1,_2){
this.$2677(this.$274t,_1,_2)}
,isc.A.asyncBuildDataBoundUI=function isc_c_AI_asyncBuildDataBoundUI(_1){
return this.$274v("$2740",_1)}
,isc.A.$2740=function isc_c_AI__asyncBuildDataBoundUI(_1,_2){
var _3;
var _4=this.$2670(this.$274t,_1,_2);
var _5=_1.availableDataSources||isc.AI.getDataSourceNames();
if(_5==null){
_3=isc.AI.noDataSourcesAvailableOrFoundErrorMessage}else{
if(!isc.isAn.Array(_5))_5=[_5];
var _6=_5.map(function(_10){
return isc.DS.get(_10)});
_6.removeEmpty();
if(_6.isEmpty()){
_3=isc.AI.noDataSourcesAvailableOrFoundErrorMessage}else{
_4._dataSources=_6}
}
var _7,
_8;
if(_3==null){
_7=this.dataBoundUITypeInfos;
if(_1.allowedUITypes!=null){
_7=isc.applyMask(_7,_1.allowedUITypes);
_8=isc.getKeys(_7);
if(_8.length!=_1.allowedUITypes.length){
var _9=_1.allowedUITypes.duplicate();
_9.removeList(_8);
_3="buildDataBoundUI() was passed unknown data-bound UI type(s): "+_9}
}else{
_8=isc.getKeys(_7)}
if(_8.isEmpty()){
_3="At least one UI type must be allowed."}
}
_4.$261h=_8;
_4.$261i=_7;
if(_3!=null){
_4.$267o.reject(isc.createErrorResult(_3))}else{
this.$267p(_4)
.then(function(_10){
return isc.AI.$2673(
_10,_4)})
.then(_4.$267o.resolve,function(_10){
_4.$267o.reject(isc.defaultAsyncOperationCatchCallback(_10))})}
return _4.$267o.promise}
,isc.A.$2673=function isc_c_AI__asyncBuildDataBoundUIWithSummarizedUserMessages(_1,_2){
if(_2.$274w.canceled){
return Promise.reject(_2.$274w.asCanceledResult())}
var _3=_2._dataSources,
_4=_2.$261i,
_5=_2.$261h;
this.$102q(!_3.isEmpty());
this.$102q(!_5.isEmpty());
var _6={
component:_5[0]
};
var _7=(_3.length>1);
if(_7){
_6.dataSource="someDataSourceID"}
var _8="";
for(var i=0;i<_5.length;++i){
var _10=_5[i];
_8+="\n\""+_10+"\": "+_4[_10].description}
var _11={
uiTypeDescriptions:_8,
uiTypes:this.$260x(_5),
responseExample:this.$260x(_6)
};
if(_7){
var _12={};
for(var i=0;i<_3.length;i++){
var _13=_3[i];
_12[_13.ID]=this.getShortDSDescription(_13)}
_11.dsDescriptions=this.$260x(_12);
_11.dsIDs=this.$260x(_3.getProperty("ID"))}
var _14=isc.InternalAIMessagesBuilder.create({
userMessages:_1,
target:this,
evalVars:_11
});
_14.appendPrompts(this.dataBoundUIInitiatorPrefixPrompts);
_14.appendPrompt(this.dataBoundUIInitiatorPrompt_UIOptions);
if(_7){
_14.appendPrompt(this.dataBoundUIInitiatorPrompt_DSOptions)}
_14.appendPrompt(this.dataBoundUIInitiator_UIResponseFormat);
if(_7){
_14.appendPrompt(this.dataBoundUIInitiator_DSResponseFormat)}
_14.appendPrompt(this.dataBoundUIInitiatorSuffix);
var _15={
cancellationController:_2.$274w,
messages:_14.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_15,_2.$261g)
.then(function(_18){
var _16=_18.message.content;
var _10=_16.component;
if(_10==null||
_10=="invald")
{
return isc.rejectWithError("AI could not determine a data-bound UI type to use to satisfy the request.")}
if(!_2.$261h.contains(_10)){
return isc.rejectWithError("AI requested to use the unavailable or unknown UI type '"+_10+"'.")}
_2.uiType=_10;
if(_7){
var _17=_16.dataSource;
if(_17==null||
_17=="invalid")
{
return isc.rejectWithError("AI could not determine which available data source to use to satisfy the request.")}
var _13=_2._dataSources.find("ID",_17);
if(_13==null){
return isc.rejectWithError("AI requested to use the unavailable or unknown data source '"+_17+"'.")}
_2.dataSource=_13}else{
_2.dataSource=_3[0]}
++_2.$261v;
isc.AI.$262i(
_2,
[{
category:"success",
content:"Gathered initial information about your request"
},{
category:"detail",
content:"AI will build a "+_10+
(_7?" using data source '"+_17+"'.":".")
}]
);
return isc.AI.$2674(_2)})}
,isc.A.$2674=function isc_c_AI__asyncRequestDataBoundUICode(_1){
var _2=isc.getValues(_1.dataSource.getFields());
var _3=_1.$261i[_1.uiType];
var _4=isc.InternalAIMessagesBuilder.create({
userMessages:_1.$2615,
target:this,
evalVars:{
componentType:_3.componentType,
dsSummary:"${dsSummary}",
componentCodePrompt:_3.codePrompt
}
});
_4.appendPrompts(this.dataBoundUICodePrefixPrompts);
_4.appendPrompts(this.uiCodeSuffixPrompts);
var _5={
messages:_4.aiMessages
};
var _6=this.$2679(_5);
if(_6.errorMessage)return isc.rejectWithError(_6.errorMessage);
var _7=_6.aiEngine.shouldUseAIFieldPaging(_5,_2,_1.$261g);
if(!_7){
return this.$2675(_2,_5,_1)}
++_1.$261w;
this.$262i(_1,[{category:"detail",content:isc.AI.willSubsetFieldsDetailMessage}],true);
return _6.aiEngine.asyncRetrieveFieldsForPrompt(
_5.messages,
"Build a component to show data from a dataSource",
_2,
_6,
_1.$261g)
.then(function(_8){
++_1.$261v;
this.$262i(_1,[{category:"success",content:isc.AI.finishedSubsettingFieldsDetailMessage}]);
return isc.AI.$2675(
_8,_5,_1)})}
,isc.A.$2675=function isc_c_AI__asyncBuildDataBoundUIWithFinalFields(_1,_2,_3){
if(_3.$274w.canceled){
return Promise.reject(_3.$274w.asCanceledResult())}
if(_1==null||(_1.removeEmpty(),_1).isEmpty()){
return isc.rejectWithError("No fields were selected for use in building the data-bound UI.")}
_3.$261z=_1;
var _4=this.summarizeDataSource(_3.dataSource,_1,_3.$261g,false);
var _5={
dsSummary:_4
};
var _6={
cancellationController:_3.$274w,
messages:_2.messages.map(function(_9){
if(_9.source=="system"&&isc.AIEngine.$272z(_9.type)){
return{
source:_9.source,
content:String(_9.content).evalDynamicString(this,_5)
}}
return _9},this),
willHandleError:true
};
return this.asyncSendRequest(_6,_3.$261g)
.then(function(_9){
if(_3.$274w.canceled){
return Promise.reject(_3.$274w.asCanceledResult())}
var _7=_9.message.content||"";
var _8=String.prototype.trim.call(isc.AI.extractFencedCode(_7));
if(_8==""){
return isc.rejectWithError("AI did not generate any UI code.")}
++_3.$261v;
isc.AI.$262i(_3,[{category:"success",content:"AI generated UI code. Will now validate\u2026"}]);
_3.jsCode=_8;
isc.AI.$2672(_3);
return _3.$2671.promise})}
,isc.A.buildDataUI=function isc_c_AI_buildDataUI(_1,_2,_3,_4){
var _5;
var _6={
userAIRequest:{prompt:_1}
};
if(_3==null){
_5="context is required to build a dataUI"}else{
_6.availableDataSources=_3.dataSources}
if(_5==null){
_6.allowedUITypes=_3.uiTypeNames}
var _7="status,result,context";
if(_5!=null){
return this.fireCallback(_2,_7,[-1,_5,_3])}
this.getEngine().buildDataBoundUI(_6,function(_8){
_5=_8.errorMessage;
if(_5!=null){
isc.AI.fireCallback(_2,_7,[-1,_5,_3])}else{
isc.AI.fireCallback(_2,_7,[0,_8.jsCode,_3])}
})}
,isc.A.extractFencedCode=function isc_c_AI_extractFencedCode(_1){
var _2=_1.match(this.fencedCodeRegex);
if(_2==null||_2.length<2)return _1;
return _2[1]}
,isc.A.getAIModel=function isc_c_AI_getAIModel(_1){
var _2=isc.AI.getEngine(_1);
return _2.model}
,isc.A.loadDataSource=function isc_c_AI_loadDataSource(_1){
if(isc.DS.get(_1)){
this.dataSourceLoaded(_1);
return}
if(!_1||this.$257l[_1])return;
this.$257l[_1]=true;
isc.DS.load(_1,{target:this,methodName:"dataSourceLoaded",args:[_1]},{loadParents:true})}
,isc.A.dataSourceLoaded=function isc_c_AI_dataSourceLoaded(_1){
delete this.$257l[_1];
var _2=this.dataSources[_1]=isc.DataSource.get(_1);
if(_2==null){
this.$257k[_1]=true;
this.logError("DataSource '"+_1+"' was not found or could not be loaded to make an AI request.","AI")}else{
var _3=this.$260m;
this.$260m=[];
for(let i=0;i<_3.length;i++){
const _5=_3[i];
if(_5.dataSourceName!=_1){
this.$260m.push(_5);
continue}
_5.engine.handleSendRequest(
_5.rawRequest,
_5.aiRequest,
_5.callback,
_5.config
)}
}
}
,isc.A.$2500=function isc_c_AI__getDataSource(_1,_2){
var _3=isc.AI.getEngine(_1),
_4=_3.getDataSourceName(_2),
_5=this.dataSources[_4]||isc.DS.get(_4);
if(_5&&!_5.$259m){
_5.addProperties({
$259m:true,
$259n:_5.transformRequest,
transformRequest:function(_8){
if(this.$259n){
var _6=this.$259n(_8)}
if(_8.dataProtocol=="clientCustom"){
var _7=_8.clientContext;
if(_7&&
(_7.spoofingMode=="full"||
_7.spoofedResponse!=null))
{
isc.AI.createSpoofedResponse(_8)}
}
return _6}
})}
return _5}
,isc.A.createSpoofedResponse=function isc_c_AI_createSpoofedResponse(_1){
var _2=_1.clientContext;
if(_2.spoofedResponse==null||_2.spoofingMode=="full"){
this.promptForSpoofedResponse(_1)}else{
if(_2.spoofedResponse.deferProcessSpoofedResponse){
if(_2.spoofedResponse.dsRequest){
this.processSpoofedResponse(_2.spoofedResponse.dsRequest,_2.spoofedResponse)}
_2.spoofedResponse.dsRequest=_1}else{
var _3=_2.spoofedResponse.getDelay||isc.isA.Number(_2.spoofedResponse.delay);
this.delayCall(
"processSpoofedResponse",
[_1,_2.spoofedResponse],
_3?0:this.spoofedResponseDelay
)}
}
}
,isc.A.processSpoofedResponse=function isc_c_AI_processSpoofedResponse(_1,_2){
if(_1===_2.dsRequest){
delete _2.dsRequest}
if(!_2.deferProcessSpoofedResponse&&
(_2.getDelay||isc.isA.Number(_2.delay)))
{
var _3;
if(_2.getDelay){
var _4=_1.clientContext;
_3=_2.getDelay(_4.aiRequest,_4.aiEngine)}else{
_3=_2.delay}
this.delayCall("$2697",[_1,_2],_3)}else{
this.$2697(_1,_2)}
}
,isc.A.$2697=function isc_c_AI__processSpoofedResponse(_1,_2){
_1.clientContext.dataSource.processResponse(
_1.requestId,
{
$260o:true,
status:0,
data:_2
}
)}
,isc.A.promptForSpoofedResponse=function isc_c_AI_promptForSpoofedResponse(_1){
var _2=_1.clientContext;
var _3=isc.DynamicForm.create({
autoDraw:false,
width:"100%",height:"*",
numCols:1,
titleOrientation:top,
items:[
{editorType:"HeaderItem",
value:_2.aiEngine.name+" Request"
},
{
name:"prompt",
titleOrientation:"top",
value:_2.aiRequest.prompt,
width:"*"
},
{name:"messages",
titleOrientation:"top",
editorType:"CanvasItem",
width:"*",height:"*",minHeight:400,
shouldSaveValue:true,
value:_2.aiRequest.messages,
createCanvas:function(){
var _4=this.$260p=isc.ListGrid.create({
$260q:this,
autoDraw:false,
width:"100%",height:"100%",
canEdit:true,
canFilter:false,
canSort:false,
canGroupBy:false,
canRemoveRecords:true,
canReorderFields:false,
wrapCells:true,
fixedRecordHeights:false,
alternateRecordStyles:true,
bodyProperties:{
nativeAutoHideScrollbars:false
},
fields:[{
name:"source",
title:"Source",
width:100,
valueMap:["user","system","AI"]
},{
name:"content",
title:"Content",
width:"*",
editorType:"TextAreaItem",
editorProperties:{
minHeight:100,
canHover:false
},
formatCellValue:function(_14,_15,_16,_17,_18){
if(!_14)return"";
if(_15.type=="jpegImage"||
_15.type=="pngImage")
{
var _5=isc.AIEngine.$269b(_15),
_6=_18.getColumnWidth(1);
return"<img src='data:"+_5+";base64,"+_14.asHTML()+"' style='width:"+_6+"px'>"}else if(isc.isAn.Object(_14)){
return isc.JSON.encode(_14,{dateFormat:"logicalDateString"})}
return String(_14).asHTML()}
}],
getEditorType:function(_14,_15){
if(_14.name=="content"&&_15&&isc.AIEngine.isImageMessage(_15)){
return"Base64ImageDataItem"}
return this.Super("getEditorType",arguments)},
getEditorProperties:function(_14,_15,_16){
var _7=this.Super("getEditorProperties",arguments);
if(_14.name=="content"&&_15&&isc.AIEngine.isImageMessage(_15)){
_7.accept="image/jpeg,image/png";
_7.mimeType=isc.AIEngine.$269b(_15);
_7.changed=function(_17,_18,_19){
var _5=this.mimeType,
_8=this.grid.getEditSession(_16);
_8.$31x.type=_5=="image/jpeg"?"jpegImage":"pngImage"}}
return _7},
getCellVAlign:function(_14,_15,_16){
return(_16==0?"top":"center")},
dataChanged:function(){
this.$260q.storeValue(this.data)}
});
var _9=isc.Button.create({
autoDraw:false,
title:"+",
autoFit:true,
click:function(){
_4.startEditingNew()}
});
return isc.VLayout.create({
autoDraw:false,
width:"100%",height:"100%",
members:[_4,_9]
})},
showValue:function(_14,_15){
if(this.$260p==null)return;
this.$260p.setData(_15)}
},
{editorType:"HeaderItem",
value:"Response"
},
{editorType:"ButtonItem",
title:"Generate AI Response",
click:function(_14){
var _10=_14.getItem("messages"),
_4=_10.$260p;
if(_4)_4.endEditing();
var _11=_14.getItem("$269c");
if(_11)_11.disable();
_2.aiEngine.sendRequest(
isc.addProperties({},_2.aiRequest,{
prompt:_14.getValue("prompt"),
messages:_10.getValue()
}),
function(_15,_16){
if(_11)_11.enable();
var _12=_15.message&&_15.message.content;
if(_15.message&&(_15.message.type=="array"||_15.message.type=="object")){
_12=isc.JSON.encode(_12)}
_14.setValue("response",_12)},
{
responseSpoofingMode:"none",
context:{doNotCapture:true}
}
)}
},
{name:"response",
editorType:"TextAreaItem",showTitle:false,
width:"*",height:100,
value:(_2.spoofedResponse?_2.spoofedResponse.value:null)
},
{
name:"$269c",
editorType:"ButtonItem",
title:"Process Response",
click:function(){
isc.AI.delayCall("processSpoofedResponse",[_1,{value:this.form.getValue("response")}]);
this.form.parentWindow.markForDestroy()}
}
]
});
var _13=isc.Window.create({
title:"Create AI Response",
width:700,height:"90%",
canDragResize:false,
autoCenter:true,
showCloseButton:false,
items:[_3],
bodyProperties:{
alwaysShowScrollbars:true
}
});
_3.parentWindow=_13;
_13.show()}
,isc.A.setDefaultSpoofedResponse=function isc_c_AI_setDefaultSpoofedResponse(_1){
this.$259o=_1==null?null:{value:_1}}
,isc.A.captureTransaction=function isc_c_AI_captureTransaction(_1){
if(!this.captureTransactions)return;
if(this.capturedTransactions==null)this.capturedTransactions=[];
isc.AI.capturedTransactions.push(_1)}
,isc.A.clearCapturedTransactions=function isc_c_AI_clearCapturedTransactions(){
this.captureTransactions=[]}
,isc.A.persistCapturesToOfflineStorage=function isc_c_AI_persistCapturesToOfflineStorage(_1){
isc.Offline.put(
_1||this.$2882,
isc.JSON.encode(
this.capturedTransactions.getProperties(["prompt","value"])
)
)}
,isc.A.setupSpoofInteractionFromCapturedTransactions=function isc_c_AI_setupSpoofInteractionFromCapturedTransactions(_1,_2){
if(_2!=null){
for(var i=0;i<_1.length;i++){
_1[i].matchesPrompt=_2}
}
this.addSpoofedResponses(_1)}
,isc.A.setupSpoofInteractionFromOfflineStorage=function isc_c_AI_setupSpoofInteractionFromOfflineStorage(_1,_2){
var _3=isc.JSON.decode(isc.Offline.get(_2||this.$2882));
if(_3==null){
this.logWarn("Unable to retrieve AI transaction captures from previous session");
return}else{
this.logWarn("Setting up spoofed responses for "+_3.length+" AI transaction captures from previous session")}
this.setupSpoofInteractionFromCapturedTransactions(_3,_1)}
,isc.A.addSpoofedResponses=function isc_c_AI_addSpoofedResponses(_1){
this.$259j.addList(_1)}
,isc.A.addSpoofedResponse=function isc_c_AI_addSpoofedResponse(_1){
this.$259j.add(_1)}
,isc.A.clearSpoofedResponses=function isc_c_AI_clearSpoofedResponses(){
this.$259j=[]}
,isc.A.removeSpoofedResponse=function isc_c_AI_removeSpoofedResponse(_1){
var _2=this.$259j.findIndex(_1);
if(_2!=-1){
this.$259j.removeAt(_2)}
}
,isc.A.removeSpoofedResponses=function isc_c_AI_removeSpoofedResponses(_1){
this.$259j.removeList(_1)}
,isc.A.getSpoofedResponse=function isc_c_AI_getSpoofedResponse(_1,_2){
var _3=_2.makePromptText(_1);
for(var _4=0;_4<this.$259j.length;++_4){
var _5=this.$259j[_4];
var _6=false;
if(isc.isA.Number(_5.numMatchesRemaining)){
if(_5.numMatchesRemaining<=0)continue}else if(_5.singleUse){
_5.numMatchesRemaining=1}
if(_5.matchesPrompt!=null){
_6=_5.matchesPrompt(_3,_5)}else if(_5.prompt!=null){
var _7=_5.textMatchStyle||"iContains",
_8=_7.startsWith("i")?_3.toLowerCase():_3,
_9=_7.startsWith("i")?_5.prompt.toLowerCase():_5.prompt;
switch(_7){
case"contains":
case"iContains":
_6=_8.contains(_9);
break;
case"startsWith":
case"iStartsWith":
_6=_8.startsWith(_9);
break;
case"endsWith":
case"iEndsWith":
_6=_8.endsWith(_9);
break;
case"equals":
case"iEquals":
default:
_6=(_8==_9);
break}
}
if(_6){
if(isc.isA.Number(_5.numMatchesRemaining))--_5.numMatchesRemaining;
if(isc.isAn.Object(_5.value)){
_5.value=isc.JSON.encode(_5.value,{dateFormat:"logicalDateString"})}
return _5}
}
if(this.$259o!=null)return this.$259o}
,isc.A.getInitiatorMessage=function isc_c_AI_getInitiatorMessage(_1){
var _2=this.getDataSourceDefinitions();
var _3=this.getUISummary(true);
var _4=_3[0];
if(_1!=null){
_1.idMapping=_3[1]}
var _5=navigator.userAgent;
var _6=this.initiatorPromptTemplate.evalDynamicString();
_6+=this.getApplicationOverviewPrompt(_2,_4,_5);
return{source:"system",content:_6,type:"text"}}
,isc.A.getApplicationOverviewPrompt=function isc_c_AI_getApplicationOverviewPrompt(_1,_2,_3){
var _4="** SmartClient application and environment information **\n";
if(this.isShowcase){
_4+="The user is interacting with a sample application user interface with the following description:\n\n";
_4+=window["featureExplorer_exampleDescription"].getContents()+"\n\n"}
_4+="Partial code for the DataSources present in this application is below, with only important properties shown:\n";
_4+=_1+"\n\n";
_4+="Partial code for the currently visible UI of the application is below, with only important properties shown.\nComponents listed in this summary may be referenced directly by their \"ID\" property or by passing that ID to \"isc.Canvas.getById()\".\"\n\n"
_4+=_2+"\n\n";
_4+="The SmartClient version is \""+isc.version+
"\" and the browser's userAgent is \""+_3+"\".\n";
return _4}
,isc.A.handleAITransportError=function isc_c_AI_handleAITransportError(_1,_2,_3,_4){
var _5=_1.URL||"";
if(_5.startsWith("https://api.openai.com/")){
return true}else{
return false}
}
,isc.A.asyncSuggestRecordSummaryTitle=function isc_c_AI_asyncSuggestRecordSummaryTitle(_1){
return this.$273t("$273w",_1)}
,isc.A.suggestRecordSummaryTitle=function isc_c_AI_suggestRecordSummaryTitle(_1,_2){
this.$273v("asyncSuggestRecordSummaryTitle",_1,_2)}
,isc.A.$273w=function isc_c_AI__asyncSuggestRecordSummaryTitle(_1,_2){
var _3=_1.aiRequest;
if(!_3){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiRequest"}))}
var _4=_2.dataSource;
if(!_4){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}))}
var _5=[{content:_3.prompt,type:_3.promptType}],
_6=_3.additionalMessages;
if(_6){
_5.addList(_6);
_5.removeEmpty()}
var _7=_5;
var _8=_1.visibleFieldNames,
_9;
if(!_8){
var _10;
if(_2.component&&(_10=_2.component.getVisibleFields())){
var _11=_10.getProperty("name");
_9=isc.getValues(isc.applyMask(_2.availableFieldsIndex,_11))}else{
_9=_2.availableFields.duplicate()}
}else{
var _12=_2.availableFieldNames;
for(var i=0;i<_8.length;++i){
var _14=_8[i];
if(!_12.contains(_14)&&
!_8.contains(_14,i+1))
{
this.logWarn("'"+_14+"' was specified in the list of visible field names, but there is no such available field.","AI")}
}
_9=isc.getValue(isc.applyMask(_2.availableFieldsIndex,_8))}
if(_9){
for(var _15=_9.length;_15>0;--_15){
var i=_15-1,
_16=_9[i],
_14=_16.name,
_17=_16.title;
if(!isc.isA.nonemptyString(_14)||
!isc.isA.String(_17)||isc.isAn.emptyString(_17.trim())||
_16.canView==false||
_16.hidden==true)
{
_9.removeAt(i)}
}
if(_9.isEmpty())_9=null}
var _18=isc.InternalAIMessagesBuilder2.create({
ssMessages:_7,
messagesSource:_1.aiRequestSource,
target:this,
evalVars:{
dsSummary:"${dsSummary}",
dsName:_4.ID
}
});
_18.appendPrompts(this.suggestRecordSummaryTitlePrompts);
if(_9){
var _19={};
for(var i=0;i<_9.length;++i){
var _16=_9[i];
_19[_16.name]=_16.title}
_18.appendPrompt(this.suggestRecordSummaryTitlePrompts_visibleFields+this.$260x(_19))}else{
_18.appendPrompt(this.suggestRecordSummaryTitlePrompts_noVisibleFields)}
_18.appendPrompt(this.suggestRecordSummaryTitlePrompts_final);
var _20={
messages:_18.aiMessages,
responseType:"object"
};
var _21=_2.availableFields,
_22=_2.availableFieldNames;
var _23=this.summarizeDataSource(_4,_21,{format:"compactJSON"},false);
var _24={
dsSummary:_23
};
var _25={
cancellationController:_2.cancellationController,
messages:_20.messages.map(function(_30){
if(_30.source=="system"&&isc.AIEngine.$272z(_30.type)){
return{
source:_30.source,
content:String(_30.content).evalDynamicString(this,_24)
}}
return _30},this),
responseType:_20.responseType,
willHandleError:true
};
var _26=this.$2679(_20);
if(_26.errorMessage)return isc.rejectWithError(_26.errorMessage);
var _27={
maxRetries:_1.maxRetries
};
return _26.aiEngine.asyncSendRequest(_25,_27)
.then(function(_30){
var _28=_30.message.content,
_29;
if(!isc.isAn.Object(_28)||
!isc.isA.String(_28.suggestedTitle)||
!(_29=_28.suggestedTitle.trim()))
{
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
return{
type:"success",
suggestedTitle:_29,
relevantFieldNames:_22
}})}
);
isc.evalBoundary;isc.B.push(isc.A.isAIFieldRequestNumerical=function isc_c_AI_isAIFieldRequestNumerical(_1){
var _2=_1.valueClass;
return _2=="ordinal"||_2=="interval"||_2=="ratio"}
,isc.A.$272h=function isc_c_AI__createBuildAIFieldRequestContext(_1,_2,_3){
var _4=this.$267n(_1,
_2,
_3);
_4.dabOpContext=_3;
if(_2.showProgressDialog==true){
_4.$261x=isc.BuildViaAIProgressDialog.create(_2.progressDialogProperties,{
$266t:_4,
canCancel:_2.userCanCancel!=false
});
_4.$261x.show()}
_4.$261w=1;
this.$262i(_4,[{category:"detail",content:isc.AI.startingYourRequestDetailMessage}]);
return _4}
,isc.A.buildAIFieldRequest=function isc_c_AI_buildAIFieldRequest(_1,_2){
this.$2677(this.$274u,_1,_2)}
,isc.A.asyncBuildAIFieldRequest=function isc_c_AI_asyncBuildAIFieldRequest(_1){
return this.$273t("$272i",_1)}
,isc.A.$272i=function isc_c_AI__asyncBuildAIFieldRequest(_1,_2){
if(!_1.userAIRequest){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"userAIRequest"}))}
var _3=_2.dataSource;
if(!_3){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}))}
var _4=this.$272h(this.$274u,_1,_2);
this.$274f(_1,_2,_4)
.then(function(_5){
_4.$267o.resolve({type:"success",aiFieldRequest:_5})},function(_5){
_4.$267o.reject(isc.defaultAsyncOperationCatchCallback(_5))});
return _4.$267o.promise}
,isc.A.$274f=function isc_c_AI___asyncBuildAIFieldRequest(_1,_2,_3){
var _4=_2.dataSource,
_5=_4.getID(),
_6=_2.availableFields,
_7=_2.availableFieldNames,
_8=_1.userAIRequest;
if(!isc.AIEngine.$272z(_8.promptType)||
isc.isA.nonemptyArray(_8.additionalMessages))
{
throw isc.createErrorResult("A non-text and/or multiple-message 'aiFieldPrompt' is not currently supported.")}
var _9=_8.prompt;
var _10={
dataSource:_4,
dsName:_5,
fields:_6,
aiFieldPrompt:_9
};
_10.dsSummary=this.render("summarizeDataSource",_10);
let _11=_4.sampleData;
if(_10.haveSampleData=isc.isA.nonemptyArray(_11)){
_11=isc.shallowClone(_11);
for(let r=0;r<_11.length;++r){
const _13=_11[r];
for(let n=0;n<_7.length;++n){
const _15=_7[n];
if(!Object.hasOwn(_13,_15)){
_13[_15]=null}
}
}
_11=isc.applyMask(_11,_7);
const _16=_11.length;
_10.dsSummary+="\n\nHere is a sample of "+_16+" record".pluralize(_16)+" (sample data) from the '"+_5+"' DataSource:\n"+
isc.JSON.encode(_11,{
prettyPrint:false,
strictQuoting:true,
dateFormat:"xmlSchema",
circularReferenceMode:"omit"
})}
var _17={
cancellationController:_3.$274w,
responseType:"object"
};
var _18=_7,
_19=_9;
return this.asyncSendPrompt(this.buildAIFieldRequestTemplatedString,_10,_3.$261g,_17)
.then(function(_35){
var _20=_35.message.content;
if(!isc.isAn.Object(_20)){
return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage)}
var _21=_20.relevantFieldNames,
_22;
if(isc.isA.String(_21))_21=[_21];
if(!isc.isAn.Array(_21)){
_22=_18}else{
_22=[];
for(var i=0;i<_21.length;++i){
var _15=_21[i];
if(_15==null||isc.isAn.Object(_15))continue;
_15=String(_15).trim();
if(_18.contains(_15)&&
!_22.contains(_15))
{
_22.push(_15)}
}
if(_22.isEmpty()){
_22=_18}
}
_21=_22;
var _24=_20.valueClass;
if(_24!="categorical"&&
_24!="ordinal"&&
_24!="interval"&&
_24!="ratio")
{
_24="general"}
var _25,
_26;
if(_24=="categorical"||_24=="ordinal"){
var _27=_20.dataDependentReason;
if(_27&&(_27=_27.trim())){
isc.AI.logWarn("AI specified a reason for data-dependence: "+_27,"AI")}
_25=_20.categories;
if(isc.isAn.Array(_25)){
var _28=[];
for(var i=0;i<_25.length;++i){
var _29=_25[i];
if(_29==null||isc.isAn.Object(_29))continue;
_29=String(_29);
if(!(_29=_29.trim())){
isc.AI.logWarn("AI generated an empty string as a category.","AI");
continue}
if(_28.contains(_29)){
isc.AI.logWarn("AI generated duplicate category '"+_29+"'.","AI");
continue}
_28.push(_29)}
_25=_28;
_26={};
if(isc.isAn.Object(_20.categoryHints)){
for(var _29 in _20.categoryHints){
if(!Object.hasOwn(_20.categoryHints,_29))continue;
var _30=_20.categoryHints[_29];
if(!(_29=_29.trim()))continue;
if(!_25.contains(_29)){
isc.AI.logWarn("AI generated a hint for non-existent category '"+_29+"'.","AI");
continue}
if(!isc.isA.String(_30)){
isc.AI.logWarn("AI generated a non-string hint for category '"+_29+"'.","AI");
continue}
if(!(_30=_30.trim()))continue;
_26[_29]=_30}
}
}
if(!isc.isAn.Array(_25)||_25.isEmpty()){
_26=_25=null;
_24="general"}
}
var _31,
_32;
if(_24=="interval"||_24=="ratio"){
_31=parseFloat(_20.minValue);
if(!isc.isA.Number(_31))_31=null;
_32=parseFloat(_20.maxValue);
if(!isc.isA.Number(_32))_32=null;
else if(isc.isA.Number(_31)&&_31>_32){
isc.AI.logWarn("AI selected minValue = "+_31+" greater than maxValue = "+_32+". Ignoring...","AI");
_32=_31=null}
}
const _33=_20.displayDirection;
if(/most-to-least/i.test(_33))_20.sortDirection="descending";
else if(/least-to-most/i.test(_33))_20.sortDirection="ascending";
else delete _20.sortDirection;
var _34;
if((_24=="ordinal"||_24=="interval"||_24=="ratio")&&
(_20.sortDirection=="ascending"||
_20.sortDirection=="descending"))
{
_34=_20.sortDirection;
if(_24=="ordinal"&&_34=="descending"){
_25.reverse();
_34="ascending"}
}
return isc.addPropertiesWithAssign({},_8,{
summarizedAIFieldPrompt:_19,
relevantFieldNames:_21,
valueClass:_24,
categories:_25,
categoryHints:_26,
minValue:_31,
maxValue:_32,
sortDirection:_34
})})}
,isc.A.applyAIFieldRequestToFieldDefaults=function isc_c_AI_applyAIFieldRequestToFieldDefaults(_1,_2){
this.$102q(_2.aiFieldRequest==null||_2.aiFieldRequest===_1);
_2.aiFieldRequest=_1;
var _3=_1.valueClass;
if(_3=="categorical"){
_2.type="enum";
_2.valueMap=_1.categories;
_2.editorType="SelectItem"}else if(_3=="ordinal"){
_2.type="intEnum";
_2.valueMap=isc.addPropertiesWithAssign({},_1.categories);
_2.editorType="SelectItem"}else if(this.isAIFieldRequestNumerical(_1)){
_2.type="float";
if(_1.minValue!=null||_1.maxValue!=null){
var _4=_2.validators;
if(!_4)_4=_2.validators=[];
var _5;
if(_1.minValue!=null){
supplyMinValidator:do{
for(var v=0;v<_4.length;++v){
var _7=_4[v];
if(_7.applyWhen!=null||
_7.serverOnly)
{
continue}
if(_7.type=="integerRange"||
_7.type=="floatLimit"||
_7.type=="floatRange")
{
if(isc.isA.Number(_7.min)&&
_1.minValue<=_7.min)
{
break supplyMinValidator}
}
}
_5={
type:"floatRange",
min:_1.minValue
};
_4.push(_5)}while(false)}
if(_1.maxValue!=null){
supplyMaxValidator:do{
for(var v=0;v<_4.length;++v){
var _7=_4[v];
if(_7.applyWhen!=null||
_7.serverOnly)
{
continue}
if(_7.type=="integerRange"||
_7.type=="floatLimit"||
_7.type=="floatRange")
{
if(isc.isA.Number(_7.max)&&
_1.maxValue>=_7.max)
{
break supplyMaxValidator}
}
}
if(_5!=null){
_5.max=_1.maxValue}else{
_5={
type:"floatRange",
max:_1.maxValue
};
_4.push(_5)}
}while(false)}
}
}else{
_2.type="text"}
_2.sortDirection=_1.sortDirection;
return _2}
,isc.A.asyncSummarizeRecords=function isc_c_AI_asyncSummarizeRecords(_1,_2){
return this.$273t("$274e",_1,_2)}
,isc.A.summarizeRecords=function isc_c_AI_summarizeRecords(_1,_2,_3){
this.$273v("asyncSummarizeRecords",_1,_2,_3)}
);
isc.B._maxIndex=isc.C+78;
isc.AI.registerTemplates({
summarizeRecordsPrompt_categorical:function(state,sc,j){
return isc.trimDoc`
            In the context of an Isomorphic SmartClient application, this is a request to
            supplement the data in \${numRecords} \${'record'.pluralize(numRecords)} (given below) from
            the '${state.dataSource.getID()}' DataSource, using relevant general knowledge and
            your own reasonable inferences from the data.

            ${sc.render("summarizeDataSource", state)}

            For \${numRecords == 1 ? 'the' : 'each'} record given below, you are to select
            exactly one of the following categories:
            ${j(state.categories, true)}

            The descriptions of each category are:
            ${j(state.categoryHints, true)}

            The rule for selecting which category to apply to \${numRecords == 1 ? 'the' : 'each'} record is:
            <category-selection-rule>\${ssMessages}</category-selection-rule>

            Your response must be a single JSON object with the following properties:
            * "result" (array of \${numRecords} \${'string'.pluralize(numRecords)}):
              \${numRecords > 1 ? 'For each record, in the same corresponding order of the records,' : 'A single-element array of'} the category
              that you selected for the record.
            * "reasoning" (array of \${numRecords} \${'string'.pluralize(numRecords)}):
              \${numRecords > 1 ? 'For each record, in the same corresponding order of the records,' : 'A single-element array of'} a string containing
              a shortened summary of the following:
                - The reason why you selected the category for the record according to the category-selection-rule.
                - Any general knowledge that you used in making your selection.
                - Any assumptions that you made in this selection.
                - Any uncertainties that you have.

            Here \${numRecords == 1 ? 'is' : 'are'} the \${numRecords} \${'record'.pluralize(numRecords)}:`}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.summarizeRecordsPrompts_interval=[
"This is a request to calculate a number for records from a DataSource, using relevant general knowledge and your own reasonable inferences from the data. The number to be calculated for each record is:",
"${ssMessages}"
];
isc.A.summarizeRecordsPrompts_interval_minValue="The minimum value is ${minValue}. ";
isc.A.summarizeRecordsPrompts_interval_maxValue="The maximum value is ${maxValue}. ";
isc.A.summarizeRecordsPrompts_interval_final="The records specified below are from the DataSource with the following description: ${dsSummary}\n\nYour response should be a single JSON object with one key \"result\" and value being an array of just the calculated numbers for each corresponding record. Here are the records:";
isc.A.canTranslateViaAI=true;
isc.A.componentActions={
filter:{
methodName:"buildFilter",
description:"Apply filter criteria to the component"
},
hilite:{
methodName:"buildHilite",
description:"Apply hiliting to the component"
},
sort:{
methodName:"buildSort",
description:"Apply a sort to the component's data-rows and/or group-rows"
},
groupBy:{
methodName:"buildGroupBy",
description:"Group the components data by some field(s) or ungroup the component"
},
setFields:{
methodName:"buildSetFields",
description:"Change the visible set of fields for the component"
}
};
isc.A.multiActionAIWindowDefaults={
_constructor:"Window",
width:500,height:300,
autoCenter:true,
showHeaderIcon:true,
headerIconProperties:{src:"AIAnswerEngine:size:22,22;"},
showMinimizeButton:false,
title:"Waiting for AI...",
gridDefaults:{
_constructor:"ListGrid",
width:"100%",height:"100%",
fixedRecordHeights:false,
emptyMessage:"Determining tasks...   ",
wrapCells:true,
border:"none",
canEdit:false,
canShowFilterEditor:false,
fields:[
{name:"type",title:"Task",width:100},
{name:"description",title:"Description",width:"*"},
{name:"status",width:30,title:"",type:"image",align:"center"}
],
initWidget:function(){
var _1=isc.Canvas.imgHTML(this.creator.workingIconSrc);
this.emptyMessage+=_1;
this.fields[2].valueMap=[
this.creator.workingIconSrc,this.creator.successIconSrc,this.creator.failureIconSrc
];
var _2=this.Super("initWidget",arguments);
return _2}
},
successIconSrc:"Accept",
failureIconSrc:"Cancel",
workingIconSrc:"Configure:cssClass:spinElement;",
initWidget:function(){
var _1=this.Super("initWidget",arguments);
this.grid=this.createAutoChild("grid");
this.addItems([this.grid])},
setFirstAction:function(_1,_2){
if(!_1)this.grid.setData([]);
else this.grid.setData([{type:_1,description:_2,status:this.workingIconSrc}]);
this.grid.redraw()},
addActions:function(_1){
for(var _2 in _1){
this.grid.addData({type:_2,description:_1[_2],status:this.workingIconSrc})}
this.grid.redraw()},
updateAction:function(_1,_2){
for(var i=0;i<this.grid.data.length;i++){
var _4=this.grid.data[i];
if(_4.type==_1){
_4.status=_2?this.successIconSrc:this.failureIconSrc;
this.grid.redraw();
return}
}
}
};
isc.B.push(isc.A.$274e=function isc_c_AI__asyncSummarizeRecords(_1,_2,_3){
var _4=_1.aiFieldRequest;
if(!_4){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"aiFieldRequest"}))}
var _5=_3.dataSource;
if(!_5){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"dataSource"}))}
var _6=_1.records;
if(!_6){
return isc.rejectWithError(isc.AsyncUtil.missingRequiredParameterErrorMessage.evalDynamicString(this,{paramName:"records"}))}
var _7;
if(_4.maxRecordsPerBatch){
_7=_4.maxRecordsPerBatch;
if(_1.maxRecordsPerBatch){
_7=Math.min(_7,_1.maxRecordsPerBatch)}
}else{
_7=_1.maxRecordsPerBatch}
var _8=[{content:_4.prompt,type:_4.promptType}],
_9=_4.additionalMessages;
if(_9){
_8.addList(_9);
_8.removeEmpty()}
var _10;
if(!isc.isA.nonemptyArray(_4.relevantFieldNames)){
_10=_3.availableFields;
if(!isc.isA.nonemptyArray(_10)){
return isc.rejectWithError("There are no available fields, so no record values can be sent to AI.")}
}else{
_10=isc.getValues(isc.applyMask(_3.availableFieldsIndex,_4.relevantFieldNames));
if(_10.isEmpty()){
return isc.rejectWithError("No available field is relevant. Therefore, no record values can be sent to AI.")}
}
var _11=_10.getProperty("name");
var _12={
dataSource:_5,
fields:_10,
dsSummary:this.summarizeDataSource(_5,_10,{format:"compactJSON"},false)
};
var _13=isc.InternalAIMessagesBuilder2.create({
ssMessages:_8,
messagesSource:_1.aiFieldRequestSource,
target:this,
evalVars:_12
});
var _14=_4.valueClass,
_15=_4.categories;
if(_14=="interval"||_14=="ratio"){
_13.appendPrompts(this.summarizeRecordsPrompts_interval);
if(isc.isA.Number(_4.minValue)){
if(isc.isA.Number(_4.maxValue)&&_4.minValue>_4.maxValue){
return isc.rejectWithError("`aiFieldRequest.minValue` cannot be greater than `aiFieldRequest.maxValue`.")}
_12.minValue=_4.minValue;
_13.appendPrompt(this.summarizeRecordsPrompts_interval_minValue)}
if(isc.isA.Number(_4.maxValue)){
_12.maxValue=_4.maxValue;
_13.appendPrompt(this.summarizeRecordsPrompts_interval_maxValue)}
_13.appendPrompt(this.summarizeRecordsPrompts_interval_final)}else if(_14=="categorical"||_14=="ordinal"){
for(var i=0;i<_15.length;++i){
var _17=_15[i];
if(!isc.isA.String(_17)){
return isc.rejectWithError("Non-string category at index "+i+" within `aiFieldRequest.categories`.")}
if(_15.contains(_17,i+1)){
return isc.rejectWithError("Duplicate category '"+_17+"' in `aiFieldRequest.categories`.")}
}
if(_15.isEmpty()){
return isc.rejectWithError("No categories are defined.")}
if(_15.length<2){
return isc.rejectWithError("There must be at least two categories.")}
var _18=isc.applyMask(_4.categoryHints,_15);
_12.categories=_15;
_12.categoryHints=_18;
_13.renderTemplate("summarizeRecordsPrompt_categorical")}else{
_13.appendPrompts(this.summarizeRecordsPrompts_general)}
var _19=!this.isAIFieldRequestNumerical(_4);
var _20={
cancellationController:_3.cancellationController,
messages:_13.aiMessages,
responseType:"object"
};
var _21={
cancellationController:_3.cancellationController,
maxConcurrent:_1.maxConcurrent,
maxRecordsPerBatch:_7,
maxRetries:_1.maxRetries==null?2:_1.maxRetries,
stopOnError:false,
recordIndexFieldName:""
};
var _22=[];
var _23={
cancellationController:_3.cancellationController,
request:_1,
partialResults:_22
};
var _24;
return this.asyncRepeatRequestOnBatches(_20,_1.records,_11,_21,function(_36){
if(_3.cancellationController&&_3.cancellationController.canceled)return;
var _25,
_26;
if(_36.type!="success"){
if(!_24)_24=_36;
_25=_36;
_26=isc.addPropertiesWithAssign({},_25)}else{
var _27=_36.message&&
_36.message.content&&
_36.message.content.result;
if(!isc.isAn.Array(_27))_27=[_27];
if(_19){
for(var i=0;i<_27.length;++i){
if(_27[i]==null)continue;
_27[i]=String(_27[i])}
}else if(_14=="ordinal"){
for(var i=0;i<_27.length;++i){
if(_27[i]==null)continue;
if(isc.isAn.Object(_27[i])){
_27[i]=null;
continue}
var _28=_15.indexOf(String(_27[i]));
_27[i]=_28<0?null:_28}
}else{
for(var i=0;i<_27.length;++i){
if(_27[i]==null)continue;
if(isc.isAn.Object(_27[i])){
_27[i]=null;
continue}
var _29=parseFloat(_27[i]);
if(!isc.isA.Number(_29)){
_27[i]=null}else{
if(isc.isA.Number(_4.minValue)){
_29=Math.max(_4.minValue,_29)}
if(isc.isA.Number(_4.maxValue)){
_29=Math.min(_29,_4.maxValue)}
_27[i]=_29}
}
}
var _30=_36.length;
_27.setLength(_30);
_25={
type:"success",
startIndex:_36.startIndex,
length:_30
};
_26=isc.addPropertiesWithAssign({},_25);
if(_19){
_25.recordSummaries=_27;
_26.recordSummaries=_27.duplicate()}else{
_25.recordNumericalSummaries=_27;
_26.recordNumericalSummaries=_27.duplicate()}
}
_22.push(_25);
isc.AI.fireCallback(_2,isc.AI.$2693,
[_26,_23]);
return _25}).$271y(function(_36){
if(_24||_36.type!="success"){
return Promise.reject(isc.addPropertiesWithAssign({},_24||_36,{partialResults:_22}))}
isc.AI.$102q(!_3.cancellationController||
!_3.cancellationController.canceled);
_36.aiResponsesForBatches.sortByProperty("startIndex",true);
var _31=_36.aiResponsesForBatches.getProperty("callbackReturnValue"),
_32=[];
for(var _33=0,i=0;i<_31.length;++i){
var _25=_31[i];
isc.AI.$102q(_33==_25.startIndex);
isc.AI.$102q(_25.length>0);
var _34=_19?_25.recordSummaries:_25.recordNumericalSummaries;
isc.AI.$102q(_34.length==_25.length);
_32.addList(_34);
_33+=_25.length}
var _35={
type:"success",
partialResults:_22
};
if(_19)_35.recordSummaries=_32;
else _35.recordNumericalSummaries=_32;
return _35})}
,isc.A.translateText=function isc_c_AI_translateText(_1,_2,_3,_4){
if(!_1||!_2){
this.logWarn("'phrase' and 'targetLocales' parameters are required");
return}
if(!isc.isAn.Array(_2))_2=[_2];
var _5=_2.duplicate();
if(_2.contains("sr")){
_2.remove("sr");
_2.add("sr-Cyrl")}
var _6="Please translate the source phrase '"+_1+"' to this list of locales: "+_2.join(", ")+".\n\n";
_6+="All punctuation, HTML markup and non-alpha characters in the source phrase should be included in your translation and any word prefixed with a '$' character, such as '$description' or '$titleField', must be included verbatim without translation.\n\n ";
_6+="Your response should be a simple JSON object where property-names are the list of requested locale-codes, and each value is your translation to that locale.  Any content outside of this JSON object, such as a prefix like 'Response:' is invalid and should not be included.\n\n";
if(_4&&_4.attrName){
_6+="For context, the source phrase is the default value for an Isomorphic SmartClient framework property with the approximate name '"+
_4.attrName.replace("_"," ")+"' and the following description: "+
_4.doc+"\n"}
var _7=this;
isc.AI.origSendPrompt(_6,function(_9){
_9=_9.replaceAll("\"sr-Cyrl\"","\"sr\"");
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},{showPrompt:false})}
,isc.A.buildFormula=function isc_c_AI_buildFormula(_1,_2,_3,_4){
_4=isc.addProperties({},_4,{showPrompt:false});
var _5=_3.grid||_3.rootCanvas;
var _6=_3.dataSource;
var _7=_6!=null?isc.getValues(_6.getFields()):_5.getFields();
var _8=["float","integer","int","long","number","decimal","double"];
var _9=[];
for(var i=0;i<_7.length;i++){
if(_8.contains(_7[i].type||"text"))
_9.add(_7[i])}
var _11="You are to generate an Isomorphic SmartClient UserFormula object based on a user-provided description.\n\n";
_11+="A SmartClient UserFormula is an object with two properties - 'text', which is a mathematical formula that can contain variable-names, and 'formulaVars' which is an object mapping those variable-names to the names of fields on an associated data-record.  The variable-names range from A-Z, and then onward to a maximum of ZZZ.  You should map natural language to the most appropriate field-names, which are listed below.  Only fields in this list are allowed.\n\n";
_11+="For example, a user might ask for and expect the following:\n\nuser-prompt: '(field1 plus field2) times 100'\nresponse: {text:'(A+B)*100',formulaVars:{A:'field1',B:'field2'}}\n\nor\n\nuser-prompt: 'Show the average of distance1 and distance2'\nresponse: ({text:'(A+B)/2',formulaVars:{A:'distance1',B:'distance2'}})\n\n";
_11+="A trinary operator may be used if a user requests conditional logic. For example:\n\nuser-prompt: 'if field1 is greater than zero, field2 * field3, otherwise -(field2 * field3)'\nresponse: ({text:'(A > 0) ? (B * C) : -(B*C)',formulaVars:{A:'field1',B:'field2',C:'field3'}})\n\n";
_11+="In addition to simple operators ('+','-','*','/'), the UserFormula text may make use of any of the following MathFunction(s).\nmax(val1,val2): Maximum of two values\nmin(val1,val2): Minimum of two values\nround(value,decimalDigits): Round a value up or down, optionally providing decimalDigits as the maximum number of decimal places to round to. For fixed or precision rounding, use toFixed() and toPrecision() respectively.\nceil(value): Round a value up\nfloor(value): Round a value down\nabs(value): Absolute value\npow(value1,value2): value1 to the power of value2\nsqrt(value): Square root of a value\ndateAdd(value,interval,amount): Excel-compatible dataAdd function: adds quantities of a time interval to a date value. Also supports being passed interval names, like \"hour\" or \"week\".\nyear(value): 4-digit integer that represents the year of a date.\nmonth(value): 1-12 integer that represents the month of a date.\nday(value): 1-31 integer that represents the day of month of a date.\ntoPrecision(value,precision): Format a number to a length of precision digits, rounding or adding a decimal point and zero-padding as necessary. Note that the values 123, 12.3 and 1.23 have an equal precision of 3. Returns a formatted string and should be used as the outermost function call in a formula. For rounding, use round().\ntoFixed(value,digits): Round or zero-pad a number to digits decimal places. Returns a formatted string and should be used as the outermost function call in a formula. To round values or restrict precision, use round() and toPrecision() respectively.\nsin(value): Sine of a value\ncos(value): Cosine of a value\ntan(value): Tangent of a value\nln(value): natural logarithm of a value\nlog(base,value): logarithm of a value with the specified base\nasin(value): Arcsine of a value\nacos(value): Arccosine of a value\natan(value): Arctangent of a value (-PI/2 to PI/2 radians)\natan2(value1,value2): Angle theta of a point (-PI to PI radians)\nexp(value): The value of Evalue\nrandom(): Random number between 0 and 1\n\nFor example:\n\nuser-prompt: 'show the maximum of region1Revenue, region2Revenue'\nresponse: ({text:'max(A,B)',formulaVars:{A:'region1Revenue',B:'region2Revenue'}})\n\n";
_11+="The user-prompt may indicate a name or title to use for the formula.  If not, please generate a short (two to four word) title.  Either way, please include it in the UserFormula object you generate, as the 'title' property.\n\n";
_11+="Here is the list of fields available for use in UserFormula objects - ";
if(this.shouldUseAIFieldPaging(_11,_9,_4)){
var _12=this;
this.retrieveFieldsForPrompt(
_1,"Create a userFormula field for a ListGrid",_9,
function(_13){
_12.$260a(_1,_11,_2,_3,_4,_13)},
_3,_4
)}else{
this.$260a(_1,_11,_2,_3,_4,_9)}
}
,isc.A.$260a=function isc_c_AI__buildFormulaWithFinalFields(_1,_2,_3,_4,_5,_6){
_2+=this.getSerializedFields(_6,_5);
_2+="Your task is to generate a UserFormula object to satisfy this user request: '"+_1+"'\n\n";
_2+="Please respond only with the UserFormula object - any surrounding content will cause JSON decode issues down-stream.\n"
var _7=this;
isc.AI.origSendPrompt(
_2,
function(_9){
var _8=_7._extractJsonResult(_9);
_7.fireCallback(_3,"result,context",[_8,_4])},
_5
)}
,isc.A.getMultiActionAIWindow=function isc_c_AI_getMultiActionAIWindow(){
var w=this.multiActionAIWindow;
if(!w){
w=isc.AI.multiActionAIWindow=isc.Window.create(this.multiActionAIWindowDefaults)}
return w}
,isc.A.buildCompositeViewSettings=function isc_c_AI_buildCompositeViewSettings(_1,_2,_3,_4){
var _5=_3.grid||_3.component;
var _6=_5&&_5.getScClassName();
if(_6==null)_6="ListGrid";
if(!_3.grid)_3.grid=_5;
var _7=_3.actions||isc.getKeys(this.componentActions);
var _8="A user is interacting with a(n) "+_6+" component in an application built with Isomorphic SmartClient Javascript framework.  Should you need to know, today's date is "+isc.DateUtil.format(new Date(),"MMMM dd, yyyy")+".\nThe user has issued the following request:\n\n\""+_1+"\"\n\nThis may be requesting one or more actions of the following action type(s):\n";
for(var i=0;i<_7.length;i++){
var _10=_7[i];
if(this.componentActions[_10]==null)continue;
_8+=_10+": "+this.componentActions[_10].description+"\n"}
_8+="\n\nPlease determine which action(s) the user is requesting and return a series of rephrased queries as a JSON object where each attribute name is the requested action type, and the attribute value is a rephrased version of the part of the query that requests that action type.\n\nAny request for sorting is a 'sort' action.  If the request concerns group-sorting, that part of the request should be considered a 'sort' action and not a 'groupBy' action.  A 'groupBy' action should only ever request group-fields.\n\n"
_8+="Example 1: if the user prompt was: \n'Show only items where cost is greater than 1 and hilite the cost field for items that are on sale'\nAn example response might be:\n"+
'{"filter":"Show only items where cost is greater than 1", "hilite":"hilite the cost field for items that are on sale"}\n\n';
_8+="Example 2: consider the user-prompt 'Group the data by Customer ascending'\nThis prompt requests that the data be grouped, and that the groups be sorted in ascending order. In cases like this, the request to group and group-fields must be provided to a 'groupBy' action, while the request to sort the groups must go to a 'sort' action:"
'{"groupBy":"Group the data by Customer", "sort":"Sort the groups in ascending order"}\n\n';
_8+="Example 3 - consider the user-prompt 'Group the data by Customer ascending, and show the latest orders first'\nThis prompt requests that data be grouped, that groups be sorted in ascending order, and that the non-group data be sorted in descending order by some kind of date field (latest orders first):\nIn this case, an appropriate response might be:\n{\"groupBy\":\"Group by Customer\", \"sort\":\"Sort groups ascending and show the latest orders first\"}\n\n";
_8+="Similarly - if the user prompt was: \n'Show my orders grouped by Customer alphabetically, and show the latest orders first'\nAn example response might be:\n"+
'{"groupBy":"Group by Customer", "sort":"Sort the groups alphabetically and show the latest orders first"}\n\n';
_8+="In most cases, the user-request is additive to the current state - so if the user asks for a single change like 'group by order-date' or 'sort the grid by Customer', that's all they want you to do.  You should not clear other parts of viewState for simple requests like these. ## If the request is for a new view\nIf the prompt says something like 'clear the view and ...' or 'reset and...', that's a new view.  In these cases, you may need to clear the existing filter, group, hilite and sort state, depending on the current view-state, which is provided.\n\nTo do this, when the request seems to be for a new view, you should add actions to clear various pieces of state - for example, if there is a filter in the current viewState and the request does not also ask for a new filter, you should add a 'filter' action to 'clear the filter'.Similarly, if the current viewState has grouping but the request does not mention grouping, you should add a 'groupBy' action to 'clear grouping'.  If hilite information is in the current viewState but the request doesn't mention hilites, you should add a 'hilite' action to 'clear hilites'.  If the grid is sorted and the request doesn't mention sorting, add a 'sort' action to 'clear sort'.\n\nIf the current viewState says the grid is grouped and the request mentions multiple actions but does *not* mention grouping, add a 'groupBy' action to 'clear grouping'.\n\n"
"If the current viewState says the grid has hilites and the request mentions multiple actions but does *not* mention hilites, you should add a 'hilite' action to 'clear hilites'.\n\n"
"Do not attempt to clear all fields with a 'setFields' action.\n\n";
_8+="If you can't determine which of the known actions are being requested, return an empty JSON object.\n\n";
_8+="Your response must be only the JSON object - do not include any text outside of the object, like a description or helpful comment, as that will break code which parses your response.\n\n"
var _11=_5.getDataSource();
if(_11){
var _12=isc.AI.summarizeDataSource(_11);
_8+="Here is the definition of the component's Datasource:\n"+_12+"\n\n"}
_8+="Finally, here is the grid's current view-state, as an object detailing current sort, group, hilite and filter settings:\n";
_8+=_5.getViewState()+"\n\n";
var _13=this;
var _14=function(_16){
_13.processSplitCompositeViewRequests(_16,_1,_2,_3,_4)}
var w=isc.AI.getMultiActionAIWindow();
w.setTitle("Configure via AI - Determining tasks");
w.setFirstAction(null);
w.show();
this.origSendPrompt(_8,_14)}
,isc.A.processSplitCompositeViewRequests=function isc_c_AI_processSplitCompositeViewRequests(_1,_2,_3,_4,_5){
_1=_1.replaceAll("```json","").replaceAll("```","");
var _6=JSON.parse(_1);
var _7=false;
_4.actions=_6;
_4.actionResults={};
_4.callback=_3;
var _8=_4.component;
var w=isc.AI.getMultiActionAIWindow();
w.setTitle("Configure via AI - Executing tasks");
w.addActions(isc.addProperties({},_6));
var _10=this;
for(var _11 in _6){
var _12=_6[_11];
if(this.componentActions[_11]!=null){
_7=true;
var _13=isc.addProperties({
actionType:_11,
originalContext:_4
},_4);
var _14=this.componentActions[_11].methodName;
if(_14=="buildFilter"){
var _15=isc.addProperties({showProgressDialog:false},{
userAIRequest:{prompt:_12},
dataSource:_8.getDataSource(),
mode:_8.filterViaAIMode=="AIDE"?"AIDE":"aiAssist"
});
var _16=isc.addProperties({},_13);
isc.AI.asyncBuildCriterion(_15)
.$271y(this.ns.EH.$2762("PromiseSettled",function(_18){
if(_18.type!="canceled"){
if(_18.type!="success"){
isc.logWarn("buildCriterion() resulted in type: "+_18.type+
", errorMessage: "+_18.errorMessage,"AI")}
}
_10.buildCompositeViewSettingsReply(_18.criterion,_16)}))}else if(_14=="buildHilite"){
var _15={
userAIRequest:{prompt:_12},
records:_8.$2642(),
dataSource:_8.getDataSource(),
mode:_8.hiliteViaAIMode=="AIDE"?"AIDE":"aiAssist",
aiPageSize:_8.aiPageSize,
showProgressDialog:false
};
var _17=isc.addProperties({},_13);
isc.AI.buildHilites(_15,function(_18){
if(_18.type!="success"){
isc.warn("Hilite-via-AI failed: "+_18.errorMessage)}
_10.buildCompositeViewSettingsReply(_18.hilites,_17)})}else{
this[_14](
_12,
function(_18,_13){
_10.buildCompositeViewSettingsReply(_18,_13)},
_13,
_5
)}
}else{
this.logWarn("Unrecognized action type '"+_11+"' for AI-generated partial request:"+_6[_11]);
delete _6[_11]}
}
}
,isc.A.buildCompositeViewSettingsReply=function isc_c_AI_buildCompositeViewSettingsReply(_1,_2){
var _3=_2.actionType;
var _4=_2.originalContext;
_4.actionResults[_2.actionType]=_1;
var w=isc.AI.getMultiActionAIWindow();
w.updateAction(_3,true);
delete _4.actions[_3];
if(isc.isA.emptyObject(_4.actions)){
this.fireCallback(_4.callback,"data,context",[_4.actionResults,_4]);
w.hide()}
}
);
isc.B._maxIndex=isc.C+8;
isc.A=isc.Operators;
isc.A.aiFilterTitle="matches a natural language description of a filter, as determined by AI";
isc.A.aiFilterDescriptionPrefix="Filter via AI: "
;
isc.DataSource.addSearchOperator({
ID:"aiFilter",
titleProperty:"aiFilterTitle",
symbol:"\uD83E\uDD16",
hidden:true,
clientOnly:true,
valueType:"custom",
getDescription:function(_1,_2){
return isc.Operators.aiFilterDescriptionPrefix+isc.AI.$268n(_1,_2).asHTML()},
getCleanCriterion:function(_1,_2){
return isc.AI.$268o(_1)},
fromCleanCriterion:function(_1,_2){
return isc.AI.$268p(_1)},
condition:function(_1,_2,_3,_4){
var _5=_3.criterion;
if(!isc.AI.$267a(_5,_4)||
_5.isTrivial)
{
return true}
var _6=_5.$263s,
_7=_3.record;
if(_6.length==1){
var _8=_7[_6[0]];
if(isc.isA.Class(_5.$263v)&&_5.$263v.has(_8)){
return false}
if(isc.isA.Class(_5.$264f)&&_5.$264f.has(_8)){
return true}
}else{
this.$102q(false)}
if(_4.$59u){
if(!_5.$267f)return false;
return _4.evaluateCriterion(_7,_5.$267f)}else{
if(!_5.$267g)return true;
return _4.evaluateCriterion(_7,_5.$267g)}
},
compareCriteria:function(_1,_2){
if(_1.$264d!=_2.$264d){
return-1}
var _3=isc.DS.getDataSource(_1.$264d);
if(_3==null||
!isc.AI.$267a(_1,_3)||
!isc.AI.$267a(_2,_3))
{
return-1}
if(_1.isTrivial){
if(_2.isTrivial)return 0}else{
if(_2.isTrivial)return 1}
return-1},
getServerCriterion:function(_1,_2,_3){
var _4=_2?isc.DS.$2652:isc.DS.$2653;
if(!isc.AI.$267a(_1,_3)){
return _4}
if(_1.isTrivial){
return isc.DS.$2653}
var _5;
if(_2){
var _6=null,
_7=_1.$263s;
if(_7.length==1){
var _8=_7[0];
if(isc.isA.Class(_1.$264f)){
_6={
_constructor:"AdvancedCriteria",
fieldName:_8,
operator:"inSet",
value:_1.$264f.getContents()
}}
}else{
this.$102q(false)}
_5=_3.combineCriteria(_6,_1.$267f)}else{
_5=_3.combineCriteria(_1.$2667,_1.$267g)}
return _5==null?_4:_5},
asyncFilter:function(_1,_2,_3){
var _4=_3.dataSource;
if(!isc.AI.$267a(_1,_4)){
return Promise.reject(isc.createErrorResult("The 'aiFilter' is not usable."))}
if(_1.isTrivial)return null;
var _5={
aiCriterion:_1,
showProgressDialog:false,
cancellationController:_3.cancellationController
};
if(_3.recordsWereUpdated){
_5.updatedRecords=_2;
return isc.AI.asyncReapplyAIFilter(_5)}
var _6=isc.AI.$267j(_1,_2,_4);
isc.AI.$102q(isc.isAn.Array(_6.matchingRecords)&&
_6.matchingRecords.length+(_6.remainingRecords==null
?0
:_6.remainingRecords.length)==_2.length);
if(!_6.remainingRecords||_6.remainingRecords.length==0){
return null}
_5.records=_2;
_5.$267i=_6;
return isc.AI.asyncApplyAIFilter(_5)},
removeFromFilterCaches:function(_1,_2){
isc.AI.removeFromAIFilterCaches(_1,_2)},
clearFilterCaches:function(_1){
isc.AI.clearAIFilterCaches(_1)},
getDependencies:function(_1){
if(_1.isTrivial)return[];
return _1.$263t}
});
isc.AI.init();
isc.defineClass("MultiStepAIOperation","PausableAsyncOperation");
isc.A=isc.MultiStepAIOperation;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.$284i=function isc_c_MultiStepAIOperation__getNodeType(_1){
return(_1.defaults&&_1.defaults._constructor)||_1._constructor||_1.type}
,isc.A.$284k=function isc_c_MultiStepAIOperation__isInlinedNode(_1){
return!!_1._constructor}
,isc.A.$287s=function isc_c_MultiStepAIOperation__augmentFetchRequestSummaryFunctions(_1,_2,_3){
var _4=_1.getAllFields();
if(_4){
for(var f=0;f<_4.length;++f){
var _6=_4[f],
_7=_6.name;
if(!isc.isA.nonemptyString(_7))continue;
if(!_2.contains(_7)&&!(_7 in _3)){
_3[_7]="first"}
}
}
}
);
isc.B._maxIndex=isc.C+3;
isc.A=isc.MultiStepAIOperation.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.jsonEncoderDefaults={
circularReferenceMode:"omit",
dateFormat:"xmlSchema",
strictQuoting:true,
prettyPrint:false
};
isc.A.maxRecordsPerQuery=15;
isc.A.$287s=isc.MultiStepAIOperation.$287s;
isc.A.$284i=isc.MultiStepAIOperation.$284i;
isc.A.$284k=isc.MultiStepAIOperation.$284k;
isc.B.push(isc.A.init=function isc_MultiStepAIOperation_init(){
this.Super("init",arguments);
if(this.paused){
this.getUnpausePromise()["catch"](isc.noOp);
this.timeLastUnpaused=null}else if(this.timeLastUnpaused==null){
this.timeLastUnpaused=this.$2834()}
if(this.numQueriesMade==null){
this.numQueriesMade=0;
var _1=this.getPrevStepResults(),
_2=!_1?0:_1.length;
for(var p=0;p<_2;++p){
var _4=_1[p];
if(_4.step.type=="executeQuery")++this.numQueriesMade}
}
if(!this.jsonEncoder){
this.jsonEncoder=isc.JSONEncoder.create(this.jsonEncoderDefaults,this.jsonEncoderProperties)}
var _5=this.maxRecordsPerQuery;
if(_5==null||
!isc.isA.Number(_5)||
_5!=Math.trunc(_5)||
_5<0)
{
_5=this.maxRecordsPerQuery=this.getClass().getInstanceProperty("maxRecordsPerQuery");
this.logWarn("Invalid 'maxRecordsPerQuery'. Resetting to "+_5,"AI")}
if(!this.isCanceled()){
this.loadSystemSchemaPromise=isc.AI.asyncLoadSystemSchema()}
}
,isc.A.$2834=function isc_MultiStepAIOperation__getTimeStamp(){
return(this.ns.EH&&this.ns.EH.$2714())||Date.now()}
,isc.A.getPrevStepResults=function isc_MultiStepAIOperation_getPrevStepResults(){
return this.prevStepResults}
,isc.A.handleCancel=function isc_MultiStepAIOperation_handleCancel(_1,_2){
var _3=this.paused;
this.Super("handleCancel",arguments);
if(_1&&_3){
this.timeLastUnpaused=this.$2834()}
}
,isc.A.handlePaused=function isc_MultiStepAIOperation_handlePaused(_1){
this.Super("handlePaused",arguments);
if(!this.paused)return;
if(this.elapsedTimeMillis==null)this.elapsedTimeMillis=0;
this.elapsedTimeMillis+=this.$2834()-this.timeLastUnpaused;
this.timeLastUnpaused=null}
,isc.A.handleUnpaused=function isc_MultiStepAIOperation_handleUnpaused(_1){
this.Super("handleUnpaused",arguments);
if(this.paused)return;
this.timeLastUnpaused=this.$2834()}
,isc.A.customizeQueryBeforeValidation=function isc_MultiStepAIOperation_customizeQueryBeforeValidation(_1,_2,_3){
_2=_1.normalizeFetchRequest(_2);
delete _2.__normalized;
if(_2.data)delete _2.data.__normalized;
_2.applyCriteriaBeforeAggregation=true;
var _4=_2.groupBy;
if(_4){
var _5=_2.summaryFunctions}
return _2}
,isc.A.customizeNodesBeforeValidation=function isc_MultiStepAIOperation_customizeNodesBeforeValidation(_1,_2,_3){
var _4=isc.DS.get("Canvas"),
_5=isc.DS.get("DrawPane");
for(var n=0;n<_1.length;++n){
var _7=_1[n],
_8=_7.defaults;
if(!_8){
_8=_7.defaults={}}
var _9=isc.MultiStepAIOperation.$284i(_7);
if(!_9)continue;
var _10=isc.DS.get(_9);
if(!_10)continue;
var _11=[];
if(_10.inheritsSchema(_4)){
_11.push(
"autoDraw"
);
if(isc.isA.Class(isc[_9])&&
isc[_9].isA("DataBoundComponent"))
{
var _12=isc[_9].speculateInitialFetchRequestProperties(_8,_7,_10);
if(_12&&_12.groupBy){
var _13=isc.SchemaValidator.$2825("dataSource",_8,_7);
_12=_13.normalizeFetchRequest(_12);
if(_12.errorMessage){
if(!_2[n]){
_2[n]=[]}
var _14="The initial fetch request properties, derived from 'fetchRequestProperties', 'implicitCriteria', 'initialCriteria', and/or 'initialSort', are invalid: "+_12.errorMessage;
_2[n].push(_14)}
if(_12.groupBy){
var _15=_8.fetchRequestProperties;
if(!_15){
_15=_8.fetchRequestProperties={}}
_15.applyCriteriaBeforeAggregation=true;
var _16=_15.groupBy=_12.groupBy;
var _17=_15.summaryFunctions=_12.summaryFunctions;
if(_3){
isc.MultiStepAIOperation.$287s(_13,_16,_17)}
}
}
}
}
if(_10.inheritsSchema(_5)){
_11.push("drawingType")}
for(var p=0;p<_11.length;++p){
var _19=_11[p];
delete _8[_19]}
}
return _1}
,isc.A.asyncValidatePaletteNodes=function isc_MultiStepAIOperation_asyncValidatePaletteNodes(_1,_2,_3){
var _4=new Array(_1.length);
_1=this.customizeNodesBeforeValidation(_1,_4);
var _5=this;
return new Promise(function(_11){
var _6=function(_12,_13){
for(var i=0;i<_4.length;++i){
var _8=_1[i],
_9=_8._nodePath,
_10=_4[i];
if(isc.isA.nonemptyArray(_10)){
if(!_12){
_12=[]}
_12.push({
nodePath:_9,
errorMessages:_10
})}
}
_5.validatePaletteNodeTrees(_13,_12,_3);
delete _2.$2850;
_11({
type:"success",
validationContext:_2,
validationErrors:_12,
paletteNodeTrees:_13
})};
if(!_2)_2={};
_2.$2850=true;
isc.EditContext.createTreeAndValidatePaletteNodeDefaults(
_1,_6,_2)})}
,isc.A.validatePaletteNodeTrees=function isc_MultiStepAIOperation_validatePaletteNodeTrees(_1,_2,_3){
}
,isc.A.$284e=function isc_MultiStepAIOperation__removeValidationArtifacts(_1){
var _2={};
isc.EditContext.$2258(_1,_2);
for(var _3 in _2){
var _4=_2[_3];
delete _4._nodePath}
return _1}
,isc.A.customizePaletteNodesAfterValidation=function isc_MultiStepAIOperation_customizePaletteNodesAfterValidation(_1){
return _1}
);
isc.B._maxIndex=isc.C+12;
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.$2855=function isc_c_AI__maskAddComponentResponseObjectNodes(_1){
if(!isc.isAn.Object(_1))throw isc.createErrorResult(this.aiNotAbleToProcessRequestErrorMessage);
var _2=_1.nodes||_1.node;
if(!_2&&
(_1.type||_1._constructor||_1.defaults))
{
_2=[_1];
_1={
nodes:_2
}}
if(!isc.isAn.Array(_2))_2=!_2?[]:[_2];
for(var _3=_2.length;_3>0;--_3){
var n=_3-1,
_5=_2[n];
if(!isc.isAn.Object(_5)){
_2.removeAt(n);
continue}
if(!isc.isAn.Object(_5.defaults))_5.defaults={};
var _6=_5.defaults._constructor||_5.type;
if(!isc.isA.nonemptyString(_6)){
_2.removeAt(n);
continue}
delete _5.defaults._constructor;
var _7=_5.defaults.ID;
if(!isc.isA.String(_7)||!(_7=_7.trim())){
_5.defaults.ID=_5.ID}
_2[n]={
type:_6,
defaults:_5.defaults
};
if(_5.parentComponent!=null){
_2[n].parentComponent=_5.parentComponent}
}
if(_2.isEmpty()){
throw isc.createErrorResult(this.aiNotAbleToProcessRequestErrorMessage)}
for(var n=0;n<_2.length;++n){
var _5=_2[n],
_7=_5.defaults.ID;
if(!isc.isA.String(_7)||
!(_7=_7.trim())||
!String.isValidID(_7))
{
_5.defaults.ID="localAutoID"+n}
}
_1.nodes=_2;
return _1}
,isc.A.userHasAccess=function isc_c_AI_userHasAccess(_1){
var _2=this.dataSourceName;
isc.DS.get(_2,function(){
var _3=isc.DS.get(_2);
_3.performCustomOperation("authorizeChat",null,function(_4,_5){
isc.AI.fireCallback(_1,"authorized,extradata",[_5.authorized,_5])})})}
);
isc.B._maxIndex=isc.C+2;
isc.defineClass("CoTProcess","Process");isc.A=isc.CoTProcess.getPrototype();isc.A.defaultTaskConstructor="CoTTask";isc.A.defaultProcessConstructor="CoTProcess";isc.A.mockMode=false;isc.A.captureMockData=false;isc.A.historyMaxItems=10;isc.A.historyPrimer="Recent actions (most recent last):";isc.A.goalPrimer="End-user goal:";isc.A.transitionsPrimer="You may request a transition by emitting {goTo,intent,stepAfter}.";isc.A.errorsPrimer="Previous attempt failed validation; correct the issues below and try again.";isc.A.maxRetries=2;isc.A.promptModeTaskPromptOnly={omit:["introPrompt","history","historyPrimer","errors","errorsPrimer","goalPrimer","transitionsPrimer"],omitStateVars:["eventStream"]
};isc.A.promptModeTransitionDebug={omit:["introPrompt","history","historyPrimer"],omitStateVars:["eventStream"]
};isc.A.promptModeStateTracking={omit:["introPrompt","transitions","transitionsPrimer","goalPrimer","historyPrimer","errorsPrimer"]
};isc.A.promptModeHistoryOnly={omit:["introPrompt","transitions","transitionsPrimer","taskPrompt","goalPrimer","errorsPrimer"],omitStateVars:["currentSummary","currentSignature"]
};isc.A.promptModeErrorsOnly={omit:["introPrompt","history","historyPrimer","transitions","transitionsPrimer","goalPrimer"],omitStateVars:["currentSummary","currentSignature","eventStream"]
};isc.A.promptModeMinimal={omit:["introPrompt","history","historyPrimer","transitions","transitionsPrimer","errors","errorsPrimer","goalPrimer"],omitStateVars:["eventStream","currentSummary","currentSignature","lastAction","focusComponentId","focusIntent"]
};isc.A.promptModeNoData={omitStateVars:["currentSummary","currentSignature","eventStream"],truncateHistory:3,truncateErrors:5
};isc.A.pauseAtTaskBoundaries=true;isc.A.paused=false;isc.A.asyncOperationParams=null;isc.A=isc.CoTProcess.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.init=function isc_CoTProcess_init(){this.Super("init",arguments);if(!this.history)this.history=[];if(!this.state)this.state={};if(!this.state.history)this.state.history=[];this.$295u=false;this.$295v=false;this.$295w=null;this.$266v=false}
,isc.A.start=function isc_CoTProcess_start(){if(this.$2926){this.logWarn("Process terminated due to mock replay failure: "+this.$2927);this.handleFinished();return}
return this.Super("start",arguments)}
,isc.A.getAsyncOperation=function isc_CoTProcess_getAsyncOperation(){if(!this.$295x){this.$295x=this.$295y()}
return this.$295x}
,isc.A.$295y=function isc_CoTProcess__createAsyncOperation(){var _1=this;var _2=isc.PausableAsyncOperation.create({params:this.asyncOperationParams
});this.observe(_2,"handlePaused",function(){_1.$295z()});this.observe(_2,"handleUnpaused",function(){_1.$2950()});this.observe(_2,"handleCancel",function(_3,_4){if(_3)_1.$2951(_4)});return _2}
,isc.A.asyncStart=function isc_CoTProcess_asyncStart(){var _1=this.getAsyncOperation();this.start();return _1.asyncGetResult()}
,isc.A.pause=function isc_CoTProcess_pause(){return this.getAsyncOperation().pause.apply(this.$295x,arguments)}
,isc.A.unpause=function isc_CoTProcess_unpause(){return this.getAsyncOperation().unpause.apply(this.$295x,arguments)}
,isc.A.cancel=function isc_CoTProcess_cancel(){return this.getAsyncOperation().cancel.apply(this.$295x,arguments)}
,isc.A.isCanceled=function isc_CoTProcess_isCanceled(){return this.$295x&&this.$295x.isCanceled()}
,isc.A.asyncGetResult=function isc_CoTProcess_asyncGetResult(){return this.getAsyncOperation().asyncGetResult()}
,isc.A.$295z=function isc_CoTProcess__handleOperationPaused(){this.$295u=true;this.paused=true}
,isc.A.$2950=function isc_CoTProcess__handleOperationUnpaused(){this.$295u=false;this.paused=false;if(this.$295v){this.$295v=false;this.$2952()}
}
,isc.A.$2951=function isc_CoTProcess__handleOperationCanceled(_1){this.$266v=true;if(this.$2953){this.$2953.abort()}
var _2=_1?_1.cancellationReason:null;this.$2954(_2)}
,isc.A.$2955=function isc_CoTProcess__beforeExecuteElement(_1){if(this.$295u&&this.pauseAtTaskBoundaries){this.$295v=true;this.$295w=_1;return false}
if(this.$266v){return false}
return true}
,isc.A.$2952=function isc_CoTProcess__continueAfterPause(){if(this.$295w){var _1=this.$295w;this.$295w=null;this.start()}
}
,isc.A.processingElement=function isc_CoTProcess_processingElement(_1,_2){}
,isc.A.processingElementResult=function isc_CoTProcess_processingElementResult(_1,_2,_3){}
,isc.A.finished=function isc_CoTProcess_finished(_1){this.Super("finished",arguments);if(this.$295x){var _2=this.$2956(_1);this.$295x.postResult(_2)}
}
,isc.A.$2956=function isc_CoTProcess__buildSuccessResult(_1){return{type:"success",state:_1
}}
,isc.A.$2954=function isc_CoTProcess__handleProcessCanceled(_1){this.logInfo("Process canceled"+(_1?": "+_1:""))}
,isc.A.$2957=function isc_CoTProcess__handleProcessError(_1){if(this.$295x){this.$295x.postResult({type:"error",errorMessage:_1.message||String(_1)
})}
}
,isc.A.getPromptPart=function isc_CoTProcess_getPromptPart(_1,_2){var _3=this;function surround(_14){return _2?_14:("\n"+_14+"\n")}
function one(_14){if(!_14)return'';var _4=/Data$/.test(_14);var _5=_4?_14.slice(0,-4):_14;switch(_5){case'goal':if(_4)return(_3.goal==null?'':String(_3.goal));return surround((_3.goalPrimer||'')+(_3.goal!=null?' '+_3.goal:''));case'history':if(_3.noHistory)return'';var _6=_3.history||[];if(_4)return isc.JSON.encode(_6,{serializeInstances:"skip"});return surround((_3.historyPrimer||'')+"\n"+isc.JSON.encode(_6,{serializeInstances:"skip"}));case'transitions':var _7=_3.currentTask||null;var _8=(_7&&_7.transitions)||[];if(!_8.length)return'';if(_4)return isc.JSON.encode(_8,{serializeInstances:"skip"});return surround((_3.transitionsPrimer||'')+"\n"+isc.JSON.encode(_8,{serializeInstances:"skip"}));case'errors':var _9=(_3.currentTask&&_3.currentTask.errors)||_3.latestErrors||null;if(_4){if(!_9)return'';return isc.JSON.encode(_9,{serializeInstances:"skip"})}
if(!_9)return'';var _10=(_3.currentTask&&_3.currentTask.errorsPrimer)?_3.currentTask.errorsPrimer:(_3.errorsPrimer||'');return surround(_10+"\n"+isc.JSON.encode(_9,{serializeInstances:"skip"}));case'taskPrompt':if(_3.$292e){_3.logWarn("Prevented recursive taskPrompt rendering - taskPrompt templates should not call promptPart(['taskPrompt'])");return''}
_3.$292e=true;try{var _11=_3.$289l(_3.currentTask||null);return surround((_3.currentTask&&_3.currentTask.$289m(_11))||'')}finally{_3.$292e=false}
default:if(_3.optionalPrompts&&_3.optionalPrompts.hasOwnProperty(_14)){return surround(String(_3.optionalPrompts[_14]||''))}
return''}
}
if(_1==null)return'';if(isc.isA.String(_1))return one(_1);var _12='';for(var i=0;i<_1.length;i++)_12+=one(_1[i]);return _12}
,isc.A.$289l=function isc_CoTProcess__makePromptCtx(_1){var _2=this;var _3={process:_2,task:_1,state:_2.state||{},goal:_2.goal,promptPart:function(_4,_5){return _2.getPromptPart(_4,_5)},prt:function(_4,_5){return _2.getPromptPart(_4,_5)}
};return _3}
,isc.A.addHistory=function isc_CoTProcess_addHistory(_1){if(this.noHistory)return;if(!this.history)this.history=[];this.history.push(_1);var _2=(this.historyMaxItems==null?10:this.historyMaxItems);while(this.history.length>_2)this.history.shift();if(!this.state)this.state={};if(!this.state.history)this.state.history=[];this.state.history.push(_1);var _3=(this.stateHistoryMaxItems==null?_2:this.stateHistoryMaxItems);while(this.state.history.length>_3)this.state.history.shift()}
,isc.A.mockOutput=function isc_CoTProcess_mockOutput(_1,_2,_3){if(_3&&_3.aiResponse){return _3.aiResponse}
return null}
,isc.A.setMockReplayFailure=function isc_CoTProcess_setMockReplayFailure(_1){this.$2926=true;this.$2927=_1;this.logWarn("Mock Replay FAILED: "+_1)}
,isc.A.getPartialPrompt=function isc_CoTProcess_getPartialPrompt(_1){if(isc.isA.String(_1)){_1={mode:_1}}
if(!_1)_1={};var _2={};if(_1.mode){var _3="promptMode"+_1.mode.substring(0,1).toUpperCase()+_1.mode.substring(1);var _4=this[_3];if(!_4){this.logInfo("Partial prompt mode '"+_1.mode+"' not found on "+this.getClassName()+", returning full prompt");_4={}}
_2.omit=(_4.omit||[]).duplicate();_2.omitStateVars=(_4.omitStateVars||[]).duplicate();_2.truncateHistory=_4.truncateHistory;_2.truncateErrors=_4.truncateErrors}else{_2.omit=(_1.omit||[]).duplicate();_2.omitStateVars=(_1.omitStateVars||[]).duplicate();_2.truncateHistory=_1.truncateHistory;_2.truncateErrors=_1.truncateErrors}
if(_1.add){for(var i=0;i<_1.add.length;i++){var _6=_1.add[i];_2.omit.remove(_6);_2.omitStateVars.remove(_6)}
}
if(_1.remove){for(var i=0;i<_1.remove.length;i++){var _6=_1.remove[i];if(!_2.omit.contains(_6)){_2.omit.add(_6)}
if(!_2.omitStateVars.contains(_6)){_2.omitStateVars.add(_6)}
}
}
return this.$292y(_2)}
,isc.A.$292y=function isc_CoTProcess__generatePartialPrompt(_1){var _2=this.currentTask;if(!_2){this.logWarn("getPartialPrompt: no current task set on process");return""}
var _3=[];var _4=this;var _5=_1.omit||[];var _6=_1.omitStateVars||[];function shouldOmit(_26){return _5.contains(_26)}
function placeholder(_26){return"["+_26+" omitted]"}
function makePartialCtx(){var _7=_4.$289l(_2);if(_6.length===0){return _7}
var _8=_7.state||{};var _9={};for(var _10 in _8){if(_8.hasOwnProperty(_10)){if(_6.contains(_10)){_9[_10]="[state."+_10+" omitted]"}else{_9[_10]=_8[_10]}
}
}
_7.state=_9;return _7}
if(this.introPrompt){if(shouldOmit("introPrompt")){_3.push(placeholder("introPrompt"))}else{_3.push(this.introPrompt)}
}
if(shouldOmit("goal")){_3.push(placeholder("goal"))}else if(shouldOmit("goalPrimer")){if(this.goal!=null){_3.push(String(this.goal))}
}else{var _11=this.getPromptPart("goal",true);if(_11)_3.push(_11)}
if(shouldOmit("taskPrompt")){_3.push(placeholder("taskPrompt"))}else{var _12=makePartialCtx();var _13=_2.$289m?_2.$289m(_12):"";if(_13)_3.push(_13)}
if(shouldOmit("transitions")){if(_2.transitions&&_2.transitions.length>0){_3.push(placeholder("transitions"))}
}else if(shouldOmit("transitionsPrimer")){var _14=_2.transitions||[];if(_14.length>0){_3.push(isc.JSON.encode(_14,{serializeInstances:"skip"}))}
}else{var _15=this.getPromptPart("transitions",true);if(_15)_3.push(_15)}
var _16=(_2&&_2.errors)||this.latestErrors||null;if(shouldOmit("errors")){if(_16&&_16.length>0){_3.push(placeholder("errors"))}
}else if(_16){var _17=_16;if(_1.truncateErrors!=null&&_16.length>_1.truncateErrors){_17=_16.slice(0,_1.truncateErrors);var _18=_16.length-_1.truncateErrors}
if(shouldOmit("errorsPrimer")){_3.push(isc.JSON.encode(_17,{serializeInstances:"skip"}))}else{var _19=(_2&&_2.errorsPrimer)?_2.errorsPrimer:(this.errorsPrimer||'');_3.push(_19+"\n"+isc.JSON.encode(_17,{serializeInstances:"skip"}))}
if(_1.truncateErrors!=null&&_16.length>_1.truncateErrors){_3.push("["+(_16.length-_1.truncateErrors)+" more errors omitted]")}
}
if(this.noHistory||shouldOmit("history")){if(!this.noHistory&&this.history&&this.history.length>0){_3.push(placeholder("history"))}
}else if(this.history&&this.history.length>0){var _20=this.history;var _21=0;if(_1.truncateHistory!=null&&_20.length>_1.truncateHistory){_21=_20.length-_1.truncateHistory;_20=_20.slice(-_1.truncateHistory)}
if(shouldOmit("historyPrimer")){if(_21>0){_3.push("["+_21+" earlier history entries omitted]")}
_3.push(isc.JSON.encode(_20,{serializeInstances:"skip"}))}else{if(_21>0){_3.push((this.historyPrimer||'')+"\n["+_21+" earlier entries omitted]\n"+isc.JSON.encode(_20,{serializeInstances:"skip"}))}else{_3.push((this.historyPrimer||'')+"\n"+isc.JSON.encode(_20,{serializeInstances:"skip"}))}
}
}
var _22=_3.join("\n\n");if(_1.omitStateVars&&_1.omitStateVars.length>0){for(var i=0;i<_1.omitStateVars.length;i++){var _24=_1.omitStateVars[i];var _25=new RegExp("\\$\\{state\\."+_24+"[^}]*\\}","g");_22=_22.replace(_25,"[state."+_24+" omitted]")}
}
return _22}
);isc.B._maxIndex=isc.C+28;isc.defineClass("CoTTask","Task");isc.A=isc.CoTTask.getPrototype();isc.A.noHistory=false;isc.A.isAsync=true;isc.A=isc.CoTTask.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.init=function isc_CoTTask_init(){this.Super("init",arguments)}
,isc.A.isValid=function isc_CoTTask_isValid(_1){return true}
,isc.A.getInvalidTaskMessage=function isc_CoTTask_getInvalidTaskMessage(_1){return null}
,isc.A.$289n=function isc_CoTTask__renderTemplate(_1,_2){if(_1==null)return'';var _3=this;return String(_1).replace(/\$\{([^}]+)\}/g,function(_6,_7){try{var _4=new Function('ctx','with(ctx){ return ('+_7+')}');var _5=_4(_2);return(_5==null?'':''+_5)}catch(e){_3.logWarn('Template evaluation error in "${'+_7+'}": '+e.message+(e.stack?'\n'+e.stack:''));return''}
})}
,isc.A.$289m=function isc_CoTTask__resolveTaskPrompt(_1){var _2=this.taskPrompt;if(isc.isA.Function(_2))return _2.call(this,_1);return this.$289n(_2||'',_1)}
,isc.A.getPromptContext=function isc_CoTTask_getPromptContext(_1){_1=_1||null;return{process:_1,task:this,state:(_1&&_1.state)?_1.state:{},goal:_1?_1.goal:null,promptPart:function(_2,_3){return(_1&&isc.isA.Function(_1.getPromptPart))?_1.getPromptPart(_2,_3):''},prt:function(_2,_3){return(_1&&isc.isA.Function(_1.getPromptPart))?_1.getPromptPart(_2,_3):''}
}}
,isc.A.getAssembledPrompt=function isc_CoTTask_getAssembledPrompt(_1){var _2=this.prompt;if(!_2){_2="${promptPart(['goal','taskPrompt','transitions','errors','history'])}"}
var _3=this.getPromptContext(_1);if(isc.isA.Function(_2)){return _2.call(this,_3)}
var _4=this;var _5=_3.promptPart;var _6={process:_3.process,task:_3.task,state:_3.state,goal:_3.goal
};var _7=[];_6.promptPart=function(_15,_16){function one(_17){if(_17==='taskPrompt'){if(_7.contains('taskPrompt')){var _8=new Error("Recursion detected");var _9=_8.stack||"Stack trace not available";var _10=_7.join(' -> ')+' -> taskPrompt';var _11="Prevented recursive taskPrompt rendering - taskPrompt templates should not call promptPart(['taskPrompt']) or promptPart(['goal','taskPrompt',...]).\nRecursion path: "+_10+"\nStack trace:\n"+_9;_4.logWarn(_11);return"[RECURSION DETECTED: taskPrompt called while already rendering taskPrompt. Path: "+_10+"]"}
_7.add('taskPrompt');try{var _12=_4.$289m(_6);return _12}finally{_7.remove('taskPrompt')}
}
return _5(_17,_16)}
if(isc.isA.String(_15))return one(_15);var _13='';for(var i=0;i<_15.length;i++)_13+=one(_15[i]);return _13};_6.prt=function(_15,_16){return this.promptPart(_15,_16)};return this.$289n(String(_2),_6)}
,isc.A.processOutputs=function isc_CoTTask_processOutputs(_1,_2){return null}
,isc.A.runOnce=function isc_CoTTask_runOnce(_1){var _2=this.getAssembledPrompt(_1);return{prompt:_2}}
,isc.A.executeElement=function isc_CoTTask_executeElement(_1){if(_1.$2955&&!_1.$2955(this)){return false}
if(_1.processingElement){_1.processingElement(this,_1)}
var _2=this.getAssembledPrompt(_1);this.logDebug("executeElement for "+(this&&this.ID));if(this.logIsDebugEnabled()){this.logDebug("prompt: "+String(_2).slice(0,200))}
var _3=isc.AI.getEngine(this.aiEngineId||_1.aiEngineId);_1.state=_1.state||{};_1.state.$289o={hasAI:!!isc.AI,hasGetEngine:!!(isc.AI&&isc.isA.Function(isc.AI.getEngine)),engine:!!_3,isEnabled:isc.AI.isEnabled()
};var _4=null;if(this.mockMode===true)_4=true;else if(this.mockMode===false)_4=false;else if(_1)_4=!!_1.mockMode;var _5=this;function validateAndCommit(_34){var _6=null;var _7=null;if(_5.outputDS){if(isc.isA.String(_5.outputDS)){_7=isc.DS.get(_5.outputDS)}else if(isc.isAn.Object(_5.outputDS)){_7=isc.DS.create(_5.outputDS)}
}else if(_5.outputFields&&isc.isAn.Array(_5.outputFields)){if(!_5.$290a){var _8=isc.shallowClone(_5.outputFields);_5.$290a=isc.DataSource.create({fields:_8})}
_7=_5.$290a}
if(_7&&isc.isA.Function(_7.validateData)){var _9=_7.validateData(_34);if(_9&&Object.keys(_9).length>0){_6=[];for(var _10 in _9){if(_9.hasOwnProperty(_10)){var _11=_9[_10];if(isc.isAn.Array(_11)){for(var i=0;i<_11.length;i++){_6.push({field:_10,message:String(_11[i])})}
}else if(_11!=null){_6.push({field:_10,message:String(_11)})}
}
}
}
}
if(_6&&_6.length){_5.errors=_6;_1.latestErrors=_6;return{ok:false,errors:_6}}
if(_5.stateUpdates){_1.applyStateUpdates(_5.stateUpdates,_34)}
if(_5.processOutputs&&isc.isA.Function(_5.processOutputs)){var _13=_5.processOutputs(_5,_1,_34,_1.state);if(_13===false){return{ok:true,paused:true}}
}
var _14=_34&&isc.isA.String(_34.goTo)?_34.goTo:null;if(_14){var _15=_1.getElement&&_1.getElement(_14);if(!_15){var _16=[];if(_1.tasks){for(var _17=0;_17<_1.tasks.length;_17++){var t=_1.tasks[_17];if(t&&t.ID)_16.push(t.ID)}
}
var _19=[{message:"Invalid goTo: '"+_14+"' does not exist. Available tasks: "+_16.join(", ")+". Use one of these task IDs or omit goTo to follow the sequence."
}];_5.errors=_19;_1.latestErrors=_19;return{ok:false,errors:_19}}else{var _20=true;if(_5.transitions&&_5.transitions.length){_20=!!_5.transitions.find(function(_37){return _37&&_37.to===_14})}
if(!_20){var _21=[{message:'Invalid transition: '+_14}];_5.errors=_21;_1.latestErrors=_21;return{ok:false,errors:_21}}
if(isc.isA.Function(_1.setNextElement)){_1.setNextElement(_14)}else{_1.nextElement=_14}
}
}
return{ok:true}}
if(_4){var _22=null;if(_1.mockData&&isc.isAn.Array(_1.mockData)&&_1.mockData.length>0)
{if(_1.$2928==null)_1.$2928=0;if(_1.$2928<_1.mockData.length){_22=_1.mockData[_1.$2928];if(_22.taskID&&_22.taskID!==this.ID){_1.setMockReplayFailure("Expected task '"+_22.taskID+"' but got '"+this.ID+"'. The workflow has diverged from the captured run at step "+(_1.$2928+1)+"."
);_1.setTaskOutput(this,{prompt:_2,error:'mockReplayFailed'});_1.start();return false}
_1.$2928++}
}
if(_22&&!_22.aiResponse){_1.setMockReplayFailure("Invalid mockData: entry at index "+(_1.$2928-1)+" for task '"+this.ID+"' is missing required aiResponse property."
);_1.setTaskOutput(this,{prompt:_2,error:'mockReplayFailed'});_1.start();return false}
var _23=null;if(isc.isA.Function(this.mockOutput)){_23=this.mockOutput(_1,_2,_22)}
if(_23==null&&_1&&isc.isA.Function(_1.mockOutput)){_23=_1.mockOutput(this,_2,_22)}
if(_1.$2926){_1.setTaskOutput(this,{prompt:_2,error:'mockReplayFailed'});_1.start();return false}
var _24={prompt:_2};var _25=null;if(_23!=null){_24.aiMessage=_23;_1.state=_1.state||{};_1.state.$289p={mocked:true,replay:_22!=null};if(_5.logIsDebugEnabled()){var _26=this.ID||"unknown";var _27=_22?"replay":"mock";_5.logDebug("["+_26+"] ["+_27+"] "+JSON.stringify(_23))}
_25=validateAndCommit(_23);if(!_25.ok){_24.error='validationOrTransitionError'}else{if(_1.processingElementResult){_1.processingElementResult(_5,_23,_1)}
}
}else{_24.aiSkipped=true}
_1.setTaskOutput(this,_24);if(!_25||!_25.paused){_1.start()}
return false}
var _28=isc.AI.getEngine(this.aiEngineId||_1.aiEngineId);_1.state=_1.state||{};_1.state.$289o={hasAI:!!isc.AI,hasGetEngine:!!(isc.AI&&isc.isA.Function(isc.AI.getEngine)),engine:!!_28,isEnabled:!!(isc.AI&&isc.isA.Function(isc.AI.isEnabled)&&isc.AI.isEnabled())
};function finish(_37){_1.setTaskOutput(_5,_37);_1.start()}
if(!_28||(isc.AI&&isc.isA.Function(isc.AI.isEnabled)&&!isc.AI.isEnabled())){_1.state=_1.state||{};_1.state.$289q={engine:!!_28,enabled:!!(isc.AI&&isc.AI.isEnabled&&isc.AI.isEnabled())};finish({prompt:_2,aiSkipped:true});return false}
this.logDebug("sending to AI engine...");isc.logWarn("CoTTask ["+this.ID+"] - Sending request to AI engine","CoT");var _29=this.systemPrompt||(_1&&_1.systemPrompt);var _30="You are a helpful assistant.";if(_29){var _31=this.getPromptContext(_1);_30=this.$289n(_29,_31)}
_28.asyncSendRequest({messages:[{source:'system',content:_30},{source:'user',content:_2}
],responseType:'object'
}).then(function(_37){_5.logDebug("received AI response");isc.logWarn("CoTTask ["+_5.ID+"] - Received response from AI engine","CoT");if(_5.logIsDebugEnabled()){_5.logDebug("AI resp type: "+_37.type+", keys: "+Object.keys(_37))}
var _24={prompt:_2};if(_37.type==='success'){_24.aiResponse=_37;var _32=_37.message.content;_24.aiMessage=_32;if(_5.logIsDebugEnabled()){var _33=(_32===undefined?'undefined':(_32===null?'null':(isc.isA.String(_32)?'string':(isc.isAn.Object(_32)?'object':'other'))));_5.logDebug("AI content typeof: "+_33+", content: "+(isc.isA.String(_32)?_32:JSON.stringify(_32)))}
var _34=null;if(_32&&isc.isAn.Object(_32)){if(_32&&isc.isA.String(_32.result)){_34=JSON.parse(_32.result)}else{_34=_32}
}else if(isc.isA.String(_32)){_34=JSON.parse(_32)}
if(_5.logIsDebugEnabled()){_5.logDebug("parsed outputsObj: "+JSON.stringify(_34))}
_1.state=_1.state||{};_1.state.$289p={type:_37.type,contentType:(_32===undefined?'undefined':(_32===null?'null':(isc.isA.String(_32)?'string':(isc.isAn.Object(_32)?'object':'other')))),content:_32
};if(_34){if(_5.logIsDebugEnabled()){var _26=this.ID||"unknown";_5.logDebug("["+_26+"] [live] "+JSON.stringify(_34))}
if(_1.captureMockData){if(!_1.mockData)_1.mockData=[];_1.mockData.push({taskID:_5.ID,aiResponse:_34,timestamp:new Date().toISOString()
})}
var _35=validateAndCommit(_34);if(!_35.ok){_24.error='validationOrTransitionError'}else{if(_1.processingElementResult){_1.processingElementResult(_5,_34,_1)}
}
if(_35.paused){return false}
}
}else{_24.error=isc.getAsyncMessage(_37);_1.state=_1.state||{};_1.state.$289p={type:_37.type,error:_24.error};_5.logWarn("AI error: "+_24.error)}
finish(_24)}).catch(function(_37){const _36=isc.defaultAsyncOperationCatchCallback(_37);finish({prompt:_2,error:isc.getAsyncMessage(_36)})});return false}
);isc.B._maxIndex=isc.C+10;isc.defineClass("MetadataEnhancer","CoTProcess");isc.A=isc.MetadataEnhancer.getPrototype();isc.A.tasks=[{ID:'analyzeTypes',title:'Analyze Types',description:'Refine field types using names and sample data',taskPrompt:'Analyze these DataSource definitions and refine field types based on field names and sample values.\n\nDataSources: ${JSON.stringify(state.dsList)}\n\nSample Records: ${JSON.stringify(state.samples)}\n\nReturn JSON with this exact structure: { "enhanced": [...] } where the array contains the DataSource definitions with refined field types. For example, change type "text" to "date" if values look like dates (YYYY-MM-DD), or "currency" for monetary amounts. Keep all other field properties unchanged.\n${prt(["guidance","errors","history"],true)}',mockOutput:function(_1){var _2=(_1&&_1.state&&_1.state.dsList)||[];var _3=(_1&&_1.state&&_1.state.samples)||{};var _4=isc.MetadataEnhancer;var _5=_4.cloneDS(_2);for(var i=0;i<_5.length;i++){var _7=_5[i]||{};var _8=_3[(_7&&(_7.ID||_7.id))]||[];var _9=_7.fields||[];for(var f=0;f<_9.length;f++){var _11=_9[f]||{};var _12=_11.name;if(_4.isLikelyCurrencyField(_12,_8))_11.type='currency';var _13=false,_14=false;for(var r=0;r<_8.length;r++){var v=_8[r]&&_8[r][_12];if(!_4.isLikelyDate(v))continue;if(isc.isA.String(v)&&/T/.test(v)){_13=true}else{_14=true}
}
if(_13)_11.type='datetime';else if(_14)_11.type='date'}
var _17=null;for(var _18=0;_18<_9.length;_18++){var _19=_9[_18]||{};if(String(_19.name).toLowerCase()==='id'){_17=_19;break}
}
if(!_17){var _20=String((_7.ID||_7.id)||'').replace(/s$/,'')+'Id';for(var _21=0;_21<_9.length;_21++){var _22=_9[_21]||{};if(String(_22.name).toLowerCase()===String(_20).toLowerCase()){_17=_22;break}
}
}
if(_17)_17.primaryKey=true;for(var _23=0;_23<_9.length;_23++){var _24=_9[_23]||{};var _25=String(_24.name||'');if(/[ _\-]?id$/i.test(_25)&&!_24.primaryKey){var _26=_4.inferRefDSId(_25,_5);if(_26)_24.foreignKey=_26+'.id'}
}
}
return{enhanced:_5}},stateUpdates:{'enhancedDSList':'$outputs.enhanced'}
},{ID:'inferPrimaryKeys',title:'Infer Primary Keys',description:'Choose stable identifiers per DataSource',taskPrompt:'Analyze these DataSource definitions and mark primary key fields.\n\nDataSources: ${JSON.stringify(state.enhancedDSList || state.dsList)}\n\nFor each DataSource, identify the primary key field and set primaryKey:true on it. Look for fields named "id" or "<entityName>Id" (e.g., "employeeId" for "employees" DS).\n\nReturn JSON with this exact structure: { "enhanced": [...] } where the array contains the complete DataSource definitions with primaryKey marked.\n${prt(["guidance","errors","history"],true)}',mockOutput:function(_1){var _2=isc.MetadataEnhancer;var _3=_2.cloneDS((_1&&_1.state&&_1.state.enhancedDSList)
||(_1&&_1.state&&_1.state.dsList)
||[]
);for(var i=0;i<_3.length;i++){var _5=_3[i]||{};var _6=_5.fields||[];var _7=null;for(var f=0;f<_6.length;f++){var _9=_6[f]||{};if(String(_9.name).toLowerCase()==='id'){_7=_9;break}
}
if(!_7){var _10=String((_5.ID||_5.id)||'').replace(/s$/,'')+'Id';for(var g=0;g<_6.length;g++){var _12=_6[g]||{};if(String(_12.name).toLowerCase()===String(_10).toLowerCase()){_7=_12;break}
}
}
if(_7)_7.primaryKey=true}
return{enhanced:_3}},stateUpdates:{'enhancedDSList':'$outputs.enhanced'}
},{ID:'inferForeignKeys',title:'Infer Foreign Keys',description:'Link child/parent entities via foreignKey',taskPrompt:'Analyze these DataSource definitions and add foreignKey references.\n\nDataSources: ${JSON.stringify(state.enhancedDSList || state.dsList)}\n\nFor fields ending in "Id" (but not the primaryKey), add foreignKey pointing to the related DataSource. For example, "departmentId" in "employees" should have foreignKey:"departments.id".\n\nReturn JSON with this exact structure: { "enhanced": [...] } where the array contains the complete DataSource definitions with foreignKey references added.\n${prt(["guidance","errors","history"],true)}',mockOutput:function(_1){var _2=isc.MetadataEnhancer;var _3=_2.cloneDS((_1&&_1.state&&_1.state.enhancedDSList)
||(_1&&_1.state&&_1.state.dsList)
||[]
);for(var i=0;i<_3.length;i++){var _5=_3[i]||{};var _6=_5.fields||[];for(var f=0;f<_6.length;f++){var _8=_6[f]||{};var _9=String(_8.name||'');if(/[ _\-]?id$/i.test(_9)&&!_8.primaryKey){var _10=_2.inferRefDSId(_9,_3);if(_10)_8.foreignKey=_10+'.id'}
}
}
return{enhanced:_3}},stateUpdates:{'enhancedDSList':'$outputs.enhanced'}
},{ID:'done',title:'Finish'}
];isc.A.startElement='analyzeTypes';isc.A.optionalPrompts={guidance:'Enhance metadata. Prefer explicit primary keys, infer foreign keys, and refine types.'
};isc.A=isc.MetadataEnhancer.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.runEnhancement=function isc_MetadataEnhancer_runEnhancement(_1,_2,_3){this.state=this.state||{};this.state.dsList=_1||[];this.state.samples=_2||{};if(_3&&_3.mockMode!=null)this.mockMode=!!_3.mockMode;var _4=this;return new Promise(function(_5){_4.finished=function(){_5({enhanced:_4.state&&_4.state.enhancedDSList})};_4.start()})}
);isc.B._maxIndex=isc.C+1;isc.A=isc.MetadataEnhancer;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.cloneDS=function isc_c_MetadataEnhancer_cloneDS(_1){var _2=[];for(var i=0;i<(_1||[]).length;i++){var d=_1[i];_2.push(isc.clone(d))}
return _2}
,isc.A.isLikelyCurrencyField=function isc_c_MetadataEnhancer_isLikelyCurrencyField(_1,_2){var n=(_1||'').toLowerCase();if(n.indexOf('amount')>=0||n.indexOf('price')>=0
||n.indexOf('cost')>=0||n.indexOf('total')>=0)
{return true}
var _4=false;if(isc.isAn.Array(_2)){for(var i=0;i<_2.length;i++){var v=_2[i]&&_2[i][_1];if(v==null)continue;if(isc.isA.String(v)){var m=String(v).match(/[\$€£]\s*\d/);if(m)return true}
if(isc.isA.Number(v)){if(Math.abs(v)>=1&&Math.abs(v)<1e9
&&Math.round(v)!==v)
{_4=true}
}
}
}
return _4}
,isc.A.isLikelyDate=function isc_c_MetadataEnhancer_isLikelyDate(_1){if(_1==null)return false;if(isc.isA.Date(_1))return true;if(isc.isA.String(_1)){if(/^\d{4}-\d{2}-\d{2}$/.test(_1))return true;if(/^\d{4}-\d{2}-\d{2}T/.test(_1))return true}
return false}
,isc.A.inferRefDSId=function isc_c_MetadataEnhancer_inferRefDSId(_1,_2){var _3=String(_1||'').replace(/[_\-]?id$/i,'');if(!_3)return null;var _4=_3.toLowerCase();for(var i=0;i<_2.length;i++){var _6=(_2[i]&&(_2[i].ID||_2[i].id))||'';var _7=String(_6).toLowerCase();if(_7===_4||_7===_4+'s'
||(_7.endsWith('s')&&_7.slice(0,-1)===_4))
{return _6||null}
}
return null}
);isc.B._maxIndex=isc.C+4;isc.FieldGeneratorRegistry.register({
ID:"AI",
asyncInitField:function(_1,_2,_3){
if(_1.aiFieldRequest){
isc.AI.applyAIFieldRequestToFieldDefaults(_1.aiFieldRequest,_1);
return null}
var _4;
if(isc.isA.String(_1.aiFieldPrompt)){
_4={prompt:_1.aiFieldPrompt}}else{
_4=_1.aiFieldPrompt}
var _5=[_1.name],
_6=_2.getAllFields();
for(var f=0,_8=!_6?0:_6.length;f<_8;++f){
var _9=_6[f];
if(_9!==_1&&
_2.$275h(_9)===this)
{
_5.push(_9.name)}
}
var _10={
cancellationController:_3.cancellationController,
userAIRequest:_4,
aiFieldSettings:_1.aiFieldSettings,
component:_2,
excludeFieldNames:_5,
showProgressDialog:false
};
return isc.AI.asyncBuildAIFieldRequest(_10)
.$2800(function(_11){
isc.AI.applyAIFieldRequestToFieldDefaults(_11.aiFieldRequest,_1);
return{type:"success"}},
null,
this,
_2.ns.EH)},
asyncGenerateValues:function(_1,_2,_3,_4){
var _5=_3.component,
_6=this.getNonSuccessfulResultAtOutset(_1,_5);
if(_6){
isc.Class.$102q(_6.type!="success");
return Promise.reject(_6)}else if(_2.getLength()>_5.aiMaxRecords){
return isc.rejectAsDisabled(_5.$278z())}
var _7={
cancellationController:_3.cancellationController,
component:_5,
dataSource:_3.dataSource,
excludeFieldNames:_3.excludeFieldNames,
aiFieldRequest:_1.aiFieldRequest,
records:_2
};
return isc.AI.asyncSummarizeRecords(_7,function(_10){
var _8=_10.startIndex,
_9=_8+_10.length;
_10.records=_2.slice(_8,_9);
if(_10.type=="success"){
_10.generatedValues=_10.recordSummaries||_10.recordNumericalSummaries}
isc.AI.fireCallback(_4,"partialResult",[_10])}).then(function(_10){
return{
type:_10.type,
generatedValues:_10.recordSummaries||_10.recordNumericalSummaries
}})},
getNonSuccessfulResultAtOutset:function(_1,_2){
if(!isc.AI.isEnabled()){
return isc.createDisabledResult(isc.AI.aiWasDisabledMessage)}
},
getNonSuccessfulRecordSortResultAtOutset:function(_1,_2){
var _3=_2.getDataAsList();
if(!_3)return;
if(_3.lengthIsKnown&&!_3.lengthIsKnown()){
return isc.createDisabledResult(isc.AsyncUtil.dataBeingFetchedMessage)}else if(_3.getLength()>_2.$273n()){
return isc.createDisabledResult(_2.$2780())}
},
getDependencies:function(_1,_2){
if(!_1.aiFieldRequest)return[];
return _1.aiFieldRequest.relevantFieldNames},
settingFieldPropertyInvalidatesCache:function(_1,_2,_3,_4){
if(_3=="aiFieldRequest"){
if(_1.aiFieldRequest==null)return _4!=null;
else if(_4==null)return true;
else{
isc.Class.$102q(_1.aiFieldRequest!=null&&_4!=null);
return _1.aiFieldRequest!==_4}
}
},
controllingFieldProperties:["aiFieldPrompt","aiFieldSettings","aiFieldRequest"]
});
isc.PseudoFieldGeneratorRegistry.register({
type:"hover",
ID:"AI",
asyncGenerateValue:function(_1,_2,_3){
var _4=_1.masterFieldName;
if(!isc.isA.nonemptyString(_4)){
return isc.rejectWithError("Expecting `masterFieldName` to be a single field name.")}
var _5=_3.component.getSpecifiedField(_4);
if(!_5){
return isc.rejectWithError("No such field named '"+_4+"'")}
var _6=_5.aiHoverRequest;
if(!_6){
return isc.rejectWithError("The master field is missing an `aiHoverRequest`.")}
var _7={
cancellationController:_3.cancellationController,
value:_2[_4],
aiRequest:_6,
examples:_6.examples
};
if(_6.includeRecord!=false){
_7.component=_3.component;
_7.record=_2;
_7.relevantFieldNames=_6.relevantFieldNames;
_7.fieldName=_4}
return isc.AI.asyncSummarizeValue(_7)
.then(function(_8){
return{
type:_8.type,
generatedValue:_8.summary.trim().asHTML()
}})},
getDependencies:function(_1,_2){
var _3=_1.masterFieldName;
if(!isc.isA.nonemptyString(_3))return[];
var _4=_2.getSpecifiedField(_3);
if(!_4)return[];
var _5=_4.aiHoverRequest;
if(!_5)return[];
if(_5.includeRecord!=false)return[_3];
var _6=_5.relevantFieldNames;
if(!_6)return null;
if(!_6.contains(_3)){
_6=_6.duplicate();
_6.push(_3)}
return _6},
getRetryDelay:function(_1,_2){
return _2.aiHoverRetryDelay},
getPlaceholderHoverContents:function(_1,_2,_3){
return _3.placeholderAIHoverContents},
formatHoverContents:function(_1,_2,_3,_4){
var _5=_1.masterFieldName,
_6=!isc.isA.nonemptyString(_5)?null:_3.getSpecifiedField(_5),
_7=(_6&&_6.aiHoverContentsPrefix!=null
?_6.aiHoverContentsPrefix
:_3.aiHoverContentsPrefix)||"";
if(!_4||!(_4=String(_4))){
_7+=_3.emptyAIHoverContents}else{
_7+=_4}
return _7}
});
isc.DS.create({
ID:"isc_answerEngineOperations",
$145w:true,
fields:[{
name:"questionId",
primaryKey:true,
escapeHTML:true
},{
name:"dataQuestion",
type:"custom",
required:true
},{
name:"currentStep",
type:"custom"
},{
name:"$2818",
multiple:true
},{
name:"$2819",
type:"custom"
},{
name:"shortenedDataQuestion",
escapeHTML:true
},{
name:"paused",
type:"boolean"
},{
name:"timeLastUnpaused",
type:"integer"
},{
name:"elapsedTimeMillis",
type:"integer"
},{
name:"numQueriesMade",
type:"integer"
},{
name:"notifyMessageId",
type:"custom",
hidden:true
}],
titleField:"shortenedDataQuestion",
clientOnly:true,
cacheData:[],
dataChanged:function(_1,_2){
this.Super("dataChanged",arguments);
if(_1.operationType=="remove"&&_1.data){
var _3=_1.data;
if(!isc.isAn.Array(_3))_3=[_3];
for(var r=0;r<_3.length;++r){
var _5=_3[r],
_6=_5&&_5.notifyMessageId;
if(_6)isc.Notify.dismissMessage(_6)}
}
},
$282o:function(_1){
var _2=0;
if(!_1.dataQuestion.result&&_1.timeLastUnpaused)_2+=Date.now()-_1.timeLastUnpaused;
if(_1.elapsedTimeMillis)_2+=_1.elapsedTimeMillis;
return _2}
});
isc.defineClass("AnswerEngineOperation","MultiStepAIOperation");
isc.A=isc.AnswerEngineOperation;
isc.A.allDashboardComponentTypes=["list","chart","value"];
isc.A.defaultAllowedComponentBaseTypes={
list:["DataSource","DetailViewerField","DetailViewer","ListGridField","ListGrid"],
chart:["DataSource","FacetChart"],
value:["DataSource","ScalarViewer","StatefulCanvas"]
}
;
isc.A=isc.AnswerEngineOperation.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.showNotify=false;
isc.A.autoShowResult=false;
isc.A.notifySettings={
messagePriority:isc.Notify.MESSAGE,
position:"T",
positionCanvas:null,
autoFitWidth:true,
canDismiss:true,
autoFitMaxWidth:"70%",
duration:0,
actionSeparator:"&emsp;"
};
isc.A.notifyMessageId=null;
isc.B.push(isc.A.init=function isc_AnswerEngineOperation_init(){
var _1=this.dataQuestion;
if(this.shortenedDataQuestion==null){
if(_1&&
_1.userAIRequest&&
isc.AIEngine.$272z(_1.userAIRequest.promptType)&&
_1.userAIRequest.prompt!=null)
{
this.shortenedDataQuestion=String.prototype.trim.call(_1.userAIRequest.prompt);
if(this.shortenedDataQuestion.length>80){
this.shortenedDataQuestion=this.shortenedDataQuestion.substring(0,77)+"..."}
}else{
this.shortenedDataQuestion="[Non-text question]"}
}
this.Super("init",arguments);
if(this.isCanceled()){
_1.result=this.initialCanceledResult}else{
if(_1.result)this.postResult(_1.result);
if(this.showNotify==true){
this.$282l()}
isc.AI.$2801(this);
this.$2802()}
}
,isc.A.getPrevStepResults=function isc_AnswerEngineOperation_getPrevStepResults(){
return this.dataQuestion.prevStepResults}
,isc.A.$282k=function isc_AnswerEngineOperation___updateCaches(_1,_2){
var _3=isc.DS.get("isc_answerEngineOperations"),
_4=this.dataQuestion.ID,
_5=_3.cacheData.find("questionId",_4),
_6=!_5?"add":"update",
_7;
if(!_5||!_1){
_7=_3.copyRecord(this);
_7.questionId=_4}else{
_7={questionId:_4};
isc.addPropertiesWithAssign(_7,isc.applyMask(this,_1))}
if(!_1||_1.contains("dataQuestion")){
_7.dataQuestion=!_7.dataQuestion?null:isc.addPropertiesWithAssign({},_7.dataQuestion)}
if(!_1||_1.contains("currentStep")){
_7.currentStep=!_7.currentStep?null:isc.addPropertiesWithAssign({},_7.currentStep)}
var _8={
status:0,
operationType:_6,
data:_7
};
var _9={
operationType:_6,
dataSource:_3,
data:_7
};
if(_6=="update"){
_9.oldValues=_5}
_3.updateCaches(_8,_9);
return _3.cacheData.find("questionId",_4)}
,isc.A.$282b=function isc_AnswerEngineOperation___getNotifyContents(){
var _1=this.shortenedDataQuestion.asHTML(),
_2=this.dataQuestion.result;
if(_2){
var _3=_2.type=="success";
if(!_3){
return"Answer Engine failed to answer: "+_1}else{
return"Answer Engine has answered: "+_1}
}else if(this.isCanceled()){
return"Work on the question <q>"+_1+"</q> is canceled."}else if(this.paused){
return"Work on the question <q>"+_1+"</q> is paused."}else{
return"Answer Engine is working on: "+_1}
}
,isc.A.$282c=function isc_AnswerEngineOperation___getNotifyActions(){
var _1=[],
_2=this.dataQuestion.result;
if(!_2&&this.isCanceled()){
return _1}
if(_2&&_2.type=="success")
_1.push({
dismissMessage:!!_2,
title:_2?(_2.type=="success"?"View":"View&nbsp;Details"):"View&nbsp;Progress",
target:this,
methodName:"$282h"
});
if(!_2){
if(this.paused){
_1.push({
title:"Resume",
target:this,
methodName:"$282e"
})}else{
_1.push({
title:"Pause",
target:this,
methodName:"$282f"
})}
_1.push({
title:"Cancel",
target:this,
methodName:"$282i"
})}
return _1}
,isc.A.$282h=function isc_AnswerEngineOperation___handleViewNotifyAction(){
var _1=isc.DS.get("isc_answerEngineOperations"),
_2=_1.copyRecord(this);
_2.questionId=this.dataQuestion.ID;
isc.DataQuestionResultViewer.showFor(_2)}
,isc.A.$282e=function isc_AnswerEngineOperation___handleResumeNotifyAction(){
isc.AI.resumeDataQuestion(this.dataQuestion.ID)}
,isc.A.$282i=function isc_AnswerEngineOperation___handleCancelNotifyAction(){
isc.ask("Are you sure you want to cancel the question: <q>"+this.shortenedDataQuestion+"</q>",{
target:this,
method:function(_1){
if(_1)this.cancel(null,"user")}
})}
,isc.A.$282f=function isc_AnswerEngineOperation___handlePauseNotifyAction(){
isc.AI.pauseDataQuestion(this.dataQuestion.ID)}
,isc.A.$282l=function isc_AnswerEngineOperation___showNotify(){
this.notifyMessageId=isc.Notify.addMessage(this.$282b(),
this.$282c(),
"AnswerEngine",
this.notifySettings)}
,isc.A.$282g=function isc_AnswerEngineOperation___updateNotify(){
var _1=this.notifyMessageId;
if(_1==null||!isc.Notify.canDismissMessage(_1)){
this.notifyMessageId=null;
if(this.showNotify&&this.dataQuestion.result&&!this.autoShowResult){
this.$282l()}
return}else if(this.dataQuestion.result&&this.autoShowResult){
isc.Notify.dismissMessage(_1);
this.notifyMessageId=null;
return}
isc.Notify.setMessageContents(_1,this.$282b());
isc.Notify.setMessageActions(_1,this.$282c())}
,isc.A.$282j=function isc_AnswerEngineOperation___dismissNotify(){
var _1=this.notifyMessageId;
if(_1!=null){
if(isc.Notify.canDismissMessage(_1)){
isc.Notify.dismissMessage(_1)}
this.notifyMessageId=null}
}
,isc.A.$280z=function isc_AnswerEngineOperation__getLogIdString(){
return this.getID()+"[questionId: '"+this.dataQuestion.ID+"']"}
,isc.A.handleCancel=function isc_AnswerEngineOperation_handleCancel(_1,_2){
var _3=this.paused;
this.Super("handleCancel",arguments);
if(_1&&_3){
this.$282k(["paused","timeLastUnpaused"],"update")}
}
,isc.A.handlePaused=function isc_AnswerEngineOperation_handlePaused(_1){
this.Super("handlePaused",arguments);
if(!this.paused)return;
this.$282g();
this.$282k(["paused","timeLastUnpaused","elapsedTimeMillis","notifyMessageId"],"update")}
,isc.A.handleUnpaused=function isc_AnswerEngineOperation_handleUnpaused(_1){
this.Super("handleUnpaused",arguments);
if(this.paused)return;
isc.AI.$2801(this,_1)}
,isc.A.$2802=function isc_AnswerEngineOperation___doContinue(){
if(this.dataQuestion.result){
this.logDebug("$2802() called, but already have a result, so returning","AnswerEngine");
return}
var _1=this;
this.$282t(function(){
var _2=_1.currentStep;
if(!_2)_2={};
if(!_2.type){
if(!_1.dataQuestion.summarizedUserMessages){
_2.type="summarizeUserAIRequest"}else{
_2.type="determineNextStep"}
}
return _1.$2804(_2)}).$2800(
function(_4){
this.currentStep=_4;
this.$2802()},
function(_4){
var _3=isc.defaultAsyncOperationCatchCallback(_4);
if(this.logIsDebugEnabled("AnswerEngine")){
this.logDebug("Received a non-successful result: "+isc.echoFull(_3)+
" Have a DQ result: "+!!this.dataQuestion.result,"AnswerEngine")}
if(!this.dataQuestion.result){
this.dataQuestion.result=_3}
this.postResult(_3)},
this
)}
,isc.A.$2804=function isc_AnswerEngineOperation__asyncPerformAndGetNextStep(_1){
var _2=_1.type;
this.logDebug("Performing a step of type '"+_2+"'","AnswerEngine");
if(_2=="summarizeUserAIRequest"){
var _3=this.dataQuestion.userAIRequest,
_4=[{content:_3.prompt,type:_3.promptType}];
if(_3.additionalMessages){
_4.addList(_3.additionalMessages);
_4.removeEmpty()}
this.dataQuestion.summarizedUserMessages=_4;
return Promise.resolve({
type:"determineNextStep",
$282r:_1.$282r
})}else if(_2=="determineNextStep"){
return isc.AI.$281f(this,_1)}else if(_2=="makeQuery"){
return isc.AI.$281g(this,_1)
.$2800(function(_16){
var _5={
step:_1,
dsRequestProperties:_16
};
if(_16.$282s){
_5.$282s=_16.$282s;
delete _16.$282s}
return{
type:"validateQuery",
makeQueryStepResult:_5
}},
null,
this)}else if(_2=="validateQuery"){
return this.$281h(_1)
.$2800(function(_16){
if(_16!=null){
return isc.rejectWithError("not yet implemented")}
return{
type:"executeQuery",
validatedMakeQueryStepResult:_1.makeQueryStepResult
}},
null,
this)}else if(_2=="executeQuery"){
return this.$281j(_1)
.$2800(function(_16){
var _6=_16.data;
if(!isc.isAn.Array(_6)){
if(isc.isAn.Object(_6))_6=[_6];
else _6=[]}
var _7={
step:_1,
data:_16.data
};
if(_16.progressiveLoading!=true){
var _8=_16.totalRows;
if(_8!=null){
_7.totalRows=_8;
_7.estimatedTotalRows=String(_8)}
}else{
_7.estimatedTotalRows=_16.estimatedTotalRows}
if(!this.dataQuestion.prevStepResults)this.dataQuestion.prevStepResults=[];
this.dataQuestion.prevStepResults.push(_7);
if(!isc.isA.Number(this.numQueriesMade))this.numQueriesMade=0;
++this.numQueriesMade;
this.$282k(["dataQuestion","numQueriesMade"],"update");
return{
$282r:_1.validatedMakeQueryStepResult.$282s
}},
null,
this)}else if(_2=="createDashboardComponent"){
return isc.AI.$281q(this,_1)
.$2800(function(_16){
var _9=_16.nodes;
var _10=isc.EditContext.createPaletteNodesFromJSON(_9,false);
var _11={
step:_1,
componentOverview:_16.componentOverview,
paletteNodes:_10
};
return this.loadSystemSchemaPromise
.$2800(function(){
const _12={
type:"validateDashboardComponent",
createDashboardComponentStepResult:_11
};
if(_16.$282s)_12.$282r=_16.$282s;
return _12},function(){
this.logWarn("System schema were not loaded successfully. Skipping dashboard component validation.","AnswerEngine");
const _12={
type:"$281t",
step:_1,
componentOverview:_11.componentOverview,
paletteNodes:_11.paletteNodes
};
if(_16.$282s)_12.$282r=_16.$282s;
return _12},
this)},
null,
this)}else if(_2=="validateDashboardComponent"){
return this.$281r(_1)
.$2800(function(_16){
var _11=_1.createDashboardComponentStepResult,
_13=_11.step;
if(_16.validationErrors){
delete _11.step;
return{
$282r:_1.$282r,
type:"fixDashboardComponent",
createDashboardComponentStep:_13,
prevValidateDashboardComponentStepResults:[_16]
}}
return{
type:"$281t",
step:_13,
componentOverview:_11.componentOverview,
paletteNodes:_11.paletteNodes
}},
null,
this)}else if(_2=="fixDashboardComponent"){
return isc.AI.$281u(this,_1)
.$2800(function(_16){
var _9=_16.node||_16.nodes;
if(!isc.isAn.Array(_9)){
_9=[_9]}
var _10=isc.EditContext.createPaletteNodesFromJSON(_9,false);
var _14={
type:"validateDashboardComponent",
createDashboardComponentStepResult:{
step:_1.createDashboardComponentStep,
componentOverview:_16.componentOverview,
paletteNodes:_10
}
};
return this.$282t(function(){
return this.$281r(_14)},
null,
this)
.$2800(function(_17){
var _11=_14.createDashboardComponentStepResult,
_13=_11.step;
delete _11.step;
if(_17.validationErrors){
var _12=isc.addPropertiesWithAssign({},_1);
_12.prevValidateDashboardComponentStepResults.push(_17);
return _12}
return{
type:"$281t",
step:_13,
componentOverview:_11.componentOverview,
paletteNodes:_11.paletteNodes
}},
null,
this)},
null,
this)}else if(_2=="createDashboard"){
return this.$281s(_1)
.$2800(function(_16){
var _15={
type:"success",
fullAnswer:_1.fullAnswer,
answerOverview:_1.answerOverview,
createDashboardComponentStepResults:_16.map(function(_17){
return _17.value||isc.defaultAsyncOperationCatchCallback(_17.reason)})
};
if(this.logIsDebugEnabled("AnswerEngine")){
this.logDebug("Received a successful result: "+isc.echoFull(_15)+
" Have a DQ result: "+!!this.dataQuestion.result,"AnswerEngine")}
if(!this.dataQuestion.result){
this.dataQuestion.result=_15}
this.postResult(_15);
return null},
null,
this)}else if(_2=="noOp"){
return new Promise(isc.noOp)}
return isc.rejectWithError("The code to perform step type '"+_2+"' is not implemented.")}
,isc.A.$281h=function isc_AnswerEngineOperation__asyncAnswerEngineValidateQuery(_1){
var _2=_1.makeQueryStepResult,
_3=_2.step.dataSourceName,
_4=isc.DS.get(_3),
_5=_2.dsRequestProperties;
_5=this.customizeQueryBeforeValidation(_4,_5);
_2.dsRequestProperties=_5;
return Promise.resolve()}
,isc.A.$281j=function isc_AnswerEngineOperation__asyncAnswerEngineExecuteQuery(_1){
var _2=_1.validatedMakeQueryStepResult,
_3=_2.step.dataSourceName,
_4=_2.dsRequestProperties;
var _5=isc.DS.get(_3);
var _6=isc.addPropertiesWithAssign({},_4,{
showPrompt:false
});
return _5.asyncExecute(_6)}
,isc.A.customizeNodesBeforeValidation=function isc_AnswerEngineOperation_customizeNodesBeforeValidation(_1,_2){
_1=this.Super("customizeNodesBeforeValidation",arguments);
var _3=isc.DS.get("Canvas"),
_4=isc.DS.get("FacetChart"),
_5=isc.DS.get("ListGrid");
for(var n=0;n<_1.length;++n){
var _7=_1[n],
_8=_7.defaults;
if(!_8){
_8=_7.defaults={}}
var _9=_8._constructor||_7.type;
if(!_9)continue;
var _10=isc.DS.get(_9);
if(!_10)continue;
var _11=[];
if(_10.inheritsSchema(_3)){
_11.push(
"overflow",
"minWidth",
"width",
"maxWidth",
"minHeight",
"height",
"maxHeight"
)}
if(_10.inheritsSchema(_4)){
_11.push(
"showDataValuesMode"
)}
if(_10.inheritsSchema(_5)){
_11.push(
"canEdit",
"autoComplete",
"autoConfirmSaveEdits",
"autoSaveEdits",
"canAutoFitFields",
"autoFitData",
"autoFitExtraRecords",
"autoFitFieldWidths",
"autoFitMaxColumns",
"autoFitMaxHeight",
"autoFitMaxRecords",
"autoFitMaxWidth",
"autoFitDateFields",
"autoFitTimeFields",
"autoFitIconFields",
"autoFitWidthApproach",
"autoFitHeaderHeights",
"autoSizeHeaderSpans",
"canSort",
"canMultiSort",
"sortByGroupFirst",
"groupSortDirection",
"canGroupBy",
"canMultiGroup",
"groupByAsyncThreshold",
"groupByMaxRecords",
"groupByMaxRecordsExceededMessage",
"disabledGroupByPrompt",
"showGroupSummaryInHeader",
"isGrouped",
"multiGroupDialogDefaults",
"multiGroupDialogProperties",
"nullGroupTitle",
"showAsynchGroupingPrompt",
"showCollapsedGroupSummary",
"showGroupTitleColumn",
"showGroupTitleInFrozenBody",
"showHilitesInGroupSummary",
"canAddAISortFields"
)}
for(var p=0;p<_11.length;++p){
var _13=_11[p];
delete _8[_13]}
}
return _1}
,isc.A.customizePaletteNodesAfterValidation=function isc_AnswerEngineOperation_customizePaletteNodesAfterValidation(_1){
_1=this.Super("customizePaletteNodesAfterValidation",arguments);
var _2=isc.DS.get("Canvas"),
_3=isc.DS.get("FacetChart"),
_4=isc.DS.get("ListGrid");
for(var p=0;p<_1.length;++p){
var _6=_1[p],
_7=_6.$2826||_6.defaults;
var _8=_7._constructor||_6.type;
if(!_8)continue;
var _9=isc.DS.get(_8);
if(!_9)continue;
if(_9.inheritsSchema(_2)){
_7.width="100%"}
if(_9.inheritsSchema(_3)){
_7.height=400;
_7.showDataValuesMode="inHoverOnly"}
if(_9.inheritsSchema(_4)){
_7.canEdit=false;
_7.autoFitData="vertical";
_7.autoFitMaxHeight=400;
_7.sortByGroupFirst=true;
_7.canMultiGroup=true;
_7.showGroupSummaryInHeader=true;
_7.groupByMaxRecords=1500000}
}
return _1}
,isc.A.$283n=function isc_AnswerEngineOperation___getAllowedComponentBaseTypes(_1){
var _2=this.dataQuestion,
_3=_2.settings,
_4=(_3&&_3.allowedComponentBaseTypes)||isc.AnswerEngineOperation.defaultAllowedComponentBaseTypes;
return _4[_1]}
,isc.A.$281r=function isc_AnswerEngineOperation__asyncAnswerEngineValidateDashboardComponent(_1){
var _2=_1.createDashboardComponentStepResult,
_3=_2.step,
_4=_3.componentType,
_5=_2.paletteNodes,
_6={
componentType:_4,
allowedComponentBaseTypes:this.$283n(_4)
};
return this.asyncValidatePaletteNodes(_5,null,_6)
.then(function(_7){
_7.step=_1;
return _7})}
,isc.A.validatePaletteNodeTrees=function isc_AnswerEngineOperation_validatePaletteNodeTrees(_1,_2,_3){
var _4=_3.componentType,
_5=_3.allowedComponentBaseTypes,
_6=[];
var _7=function(_16){
var _8=_16.$2826||_16.defaults,
_9=_8._constructor||_16.type;
if(_9){
var _10=isc.DS.get(_9);
if(_10){
var a=0;
for(var a=0;a<_5.length;++a){
if(_10.inheritsSchema(_5[a])){
break}
}
if(a>=_5.length&&!_6.contains(_9)){
_6.push(_9);
if(!_2)_2=[];
_2.push({type:"Palette node type '"+_9+"' is not allowed."})}
}
}
var _12=_16.children,
_13=!_12?0:_12.length;
for(var c=0;c<_13;++c){
_7(_12[c])}
};
if(!isc.isAn.Array(_5)){
this.logError("Unknown allowed component base types for component type '"+_4+"'.")}else{
for(var t=0;t<_1.length;++t){
_7(_1[t])}
}
}
,isc.A.$281s=function isc_AnswerEngineOperation__asyncAnswerEngineCreateDashboard(_1){
var _2=isc.CreateDashboardComponentsMapper.create({
cancellationController:this.cancellationController,
values:_1.createDashboardComponentSteps,
answerEngineOperation:this
});
return _2.getPromise()}
);
isc.B._maxIndex=isc.C+26;
isc.defineClass("CreateDashboardComponentsMapper","ResolvedValuesMapper");
isc.A=isc.CreateDashboardComponentsMapper.getPrototype();
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.keepSettledStatus=true;
isc.A.maxConcurrent=3;
isc.B.push(isc.A.asyncMap=function isc_CreateDashboardComponentsMapper_asyncMap(_1,_2){
return this.answerEngineOperation.$282t(function(){
return this.$281x(_1,_1)},null,this)}
,isc.A.$281x=function isc_CreateDashboardComponentsMapper___asyncMap(_1,_2){
return this.answerEngineOperation.$2804(_2)
.$2800(function(_4){
if(!_4)return isc.rejectWithError("No next step");
if(_4.type=="$281t"){
var _3=this.answerEngineOperation.customizePaletteNodesAfterValidation(_4.paletteNodes);
return Promise.resolve({
type:"success",
step:_1,
componentOverview:_4.componentOverview,
paletteNodes:_3
})}
return this.answerEngineOperation.$282t(function(){
return this.$281x(_1,_4)},null,this)},
null,
this)}
);
isc.B._maxIndex=isc.C+2;
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.maxActiveAnswerEngineOperations=10;
isc.A.answerEngineOperations=[];
isc.A.$2806={};
isc.A.$281d="result,dataQuestion";
isc.B.push(isc.A.$2801=function isc_c_AI__touchAnswerEngineOperation(_1,_2){
var _3=_1.dataQuestion,
_4=_3.ID,
_5=this.$2806[_4],
_6=false;
if(_5&&
_5!==_1)
{
_6=true;
if(!_5.isCanceled()){
_5.cancel("A different <code>AnswerEngineOperation</code> instance ("+
_5.getID()+") was working on data question ID '"+
String(_4).asHTML()+"'. Replacing...",_2)}
_5.$282j();
_5.showNotify=false}
this.$2806[_4]=_1;
var _7=false;
while(this.answerEngineOperations.remove(_1)){
_7=true}
this.answerEngineOperations.addAt(_1,0);
_1.$282g();
_1.$282k(null,_6||_7?"update":"add");
var _8=this.maxActiveAnswerEngineOperations;
if(_8<0||_8==Infinity)return;
var _9=0;
for(var o=0;o<this.answerEngineOperations.length;++o){
_1=this.answerEngineOperations[o];
if(_1.isCanceled()||_1.paused)continue;
if(++_9>_8){
_1.cancel("Canceling all but "+Math.trunc(_8)+" active Answer Engine operations.",_2)}
}
}
,isc.A.$2803=function isc_c_AI__removeAnswerEngineOperation(_1){
_1.$282j();
var _2=_1.dataQuestion,
_3=_2.ID,
_4=this.$2806[_3];
if(_4===_1){
_1.$282k(["notifyMessageId"],"update");
delete this.$2806[_3]}
var _5=false;
while(this.answerEngineOperations.remove(_1)){
_5=true}
if(_4===_1){
var _6=isc.DS.get("isc_answerEngineOperations"),
_7=_6.cacheData.find("questionId",_3);
if(_7){
_6.updateCaches({
operationType:"remove",
data:_7
})}
}
}
,isc.A.$281e=function isc_c_AI__createAnswerEngineOperation(_1,_2,_3,_4){
var _5=isc.isA.String(_1)?{prompt:_1}:_1;
if(!_2&&isc.isAn.Object(_3)&&_3.dataSourceNames){
_2=_3.dataSourceNames.map(function(_16){
return isc.DS.get(_16)})}
var _6,
_7;
if(!_2){
_7=this.getDataSourceNames();
_2=_7.map(function(_16){
return isc.DS.get(_16)})}else{
_2=_2.duplicate();
for(var _8=_2.length;_8>0;--_8){
var d=_8-1,
_10=_2[d]=isc.DS.get(_2[d]);
if(!_10||!isc.isA.nonemptyString(_10.ID)){
_2.removeAt(d);
this.logWarn("`dataSources["+d+"]` either is not a global data source name, or the data source does not have a global ID. Removing...","AnswerEngine")}
}
_7=_2.getProperty("ID");
_6=_7}
var _11=isc.addPropertiesWithAssign({},_3);
if(!_3)_3={};
_3.dataSourceNames=_7;
var _12=_3.allowedDashboardComponentTypes;
if(!_12){
_12=isc.AnswerEngineOperation.allDashboardComponentTypes.duplicate()}else{
for(var _13=_12.length;_13>0;--_13){
var t=_13-1,
_15=_12[t];
if(!isc.AnswerEngineOperation.allDashboardComponentTypes.contains(_15)){
this.logWarn("Unknown dashboard component type '"+_15+"' specified in the list of allowed types. Removing...","AnswerEngine");
_12.removeAt(t)}
}
}
return this.acceptDataQuestionResult(isc.AnswerEngineOperation.create(_4,{
dataQuestion:{
ID:_3.$282a||isc.Math.randomUUID(),
userAIRequest:_5,
settings:_3
},
$2818:_6,
$2819:_11,
dataSources:_2,
$261g:{
maxRetries:0,
serializationFormat:"compactJSON"
}
}))}
,isc.A.acceptDataQuestionResult=function isc_c_AI_acceptDataQuestionResult(_1){
_1.asyncGetResult()
.$271y(function(_5){
if(_1.logIsDebugEnabled("AnswerEngine")){
_1.logDebug("acceptDataQuestionResult(): Received a result: "+isc.echoFull(_5),"AnswerEngine")}
var _2=_1.dataQuestion;
_2.result=_5;
var _3=_1.$2834();
if(_1.elapsedTimeMillis==null)_1.elapsedTimeMillis=0;
_1.elapsedTimeMillis+=_3-_1.timeLastUnpaused;
_1.timeLastUnpaused=_3;
if(_5.type=="canceled"&&_5.cancellationInitiator=="user"){
this.$2803(_1)}else{
_1.$282g();
var _4=_1.$282k(null,"update");
if(_1.autoShowResult){
isc.DataQuestionResultViewer.showFor(_4)}
}
},
this);
return _1}
,isc.A.askDataQuestion=function isc_c_AI_askDataQuestion(_1,_2,_3,_4,_5){
var _6=this.$281e(_1,_2,_3,_5);
if(_4){
_6.asyncGetResult()
.$271y(function(_7){
this.fireCallback(_4,this.$281d,
[_7,_6.dataQuestion,_6])},this)}
return _6}
,isc.A.cancelDataQuestion=function isc_c_AI_cancelDataQuestion(_1,_2){
var _3=this.$2806[_1];
if(!_3){
this.logError("Unknown questionId '"+_1+"'","AnswerEngine")}else if(_3.isCanceled()){
this.logWarn("The Answer Engine operation for questionId '"+_1+"' is already canceled.","AnswerEngine")}else{
_3.cancel("AI.cancelDataQuestion() was called to cancel the Answer Engine operation.",_2)}
}
,isc.A.pauseDataQuestion=function isc_c_AI_pauseDataQuestion(_1,_2){
var _3=this.$2806[_1];
if(!_3){
this.logError("Unknown questionId '"+_1+"'","AnswerEngine")}else{
var _4=_3.pause(_2);
if(_4)_4["catch"](isc.noOp)}
}
,isc.A.resumeDataQuestion=function isc_c_AI_resumeDataQuestion(_1,_2){
var _3=this.$2806[_1];
if(!_3){
this.logError("Unknown questionId '"+_1+"'","AnswerEngine")}else{
_3.unpause(_2)}
}
);
isc.B._maxIndex=isc.C+8;
isc.AI.registerTemplates({
AnswerEngine_previousStepsDump:function(state,sc,j){
var previousStepsCount=state.previousStepsCount||0;
if(previousStepsCount<=0){
return"There are no previous steps."}
return isc.trimDoc`
            The last ${previousStepsCount} ${"step".pluralize(previousStepsCount)} you have taken, and the corresponding ${"result".pluralize(previousStepsCount)}, ${sc.if(previousStepsCount == 1, "is", "are")}:
            <previous-steps format="JSON">
            ${j(state.previousSteps, true)}
            </previous-steps>`},
AnswerEngine_prelude:function(state,sc){
return isc.trimDoc`
            You are an intelligent data analyst embedded in an Isomorphic SmartClient application.
            Your responsibility is to provide answers to the user's natural language question about the data
            of the application (the "data-question"), providing as many insights into the user's data-question
            as can possibly be obtained from the data and your analysis of the data.

            ${sc.if(state.applicationPurpose,
                isc.trimDoc`
                    The purpose of the application is:
                    <application-purpose>${state.applicationPurpose}</application-purpose>`
            )}

            This is a multi-step process, where you will be asked to complete a single task at a time.

            The primary tool available to you is to make queries against DataSources in the application,
            so that you may analyze the data of the application for the purposes of answering the
            user's data-question, resolving ambiguities, and identifying uncertainties.

            Do not worry about the number of queries that you make. It is most important that
            you fully analyze the data to determine an answer to the user's data-question.

            Once you have determined an answer to the user's data-question, you will be asked
            to create a dashboard user interface to fully explain the answer and insights that
            you have obtained. Therefore, you will also need to gather the information that
            you need to create the dashboard.

            The user's data-question is:
            <data-question>\${userMessages}</data-question>

            For reference, consider the current date and time to be: ${state.referenceTime}

            ${sc.render("applicationDataSourcesPromptSection", state.dataSources)}

            ## Previous steps and analysis
            ${sc.render("AnswerEngine_previousStepsDump", state)}

            ### EstimatedTotalRows string format
            An EstimatedTotalRows string is the server's estimate of the number of records in a
            DataSource that match the filter criteria. Here are examples of the format of such
            a string:
            * "500+": There are at least 500 records.
            * "-500": There are fewer than 500 records.
            * "450-500": There are between 450 and 500 records.
            * "~500": There are approximately 500 records.
            * "500": There are exactly 500 records.

            ## Paging through result sets
            Where the number of records returned from a query is less than the total number of
            records (or estimated total number of records) that match the filter criteria, you may
            need to "page" through more of the records by re-issuing the query with the same
            criteria and sort, but different "startRow" and/or "endRow" DSRequest properties.

            ${sc.render("requirementsForDisplayingInformationPromptSection", state)}

            ## Your current task`}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.$2887=function(criteria,numRows,totalRows,estimatedTotalRows){
if(totalRows!=null&&totalRows<=numRows){
if(numRows==0)return criteria?"No rows match the filter criteria."
:"There are no rows.";
else if(numRows==1)return`This is the one and only row${criteria ? " that matches the filter criteria" : ""}.`;
else return`This is all ${numRows} rows${criteria ? " that match the filter criteria" : ""}.`}
var note=`Under the "startRow" and "endRow" settings of the query, there ${numRows == 1 ? "was" : "were"} ${numRows} ${"row".pluralize(numRows)} returned`;
if(totalRows!=null){
if(totalRows>numRows){
return note+`, out of ${totalRows} total ${"row".pluralize(totalRows)} available${criteria ? " that match the filter criteria" : ""}.`}
}else if(estimatedTotalRows!=null){
return note+`. The EstimatedTotalRows string for the query is "${estimatedTotalRows}"; this encodes the server's estimate of the total number of rows${criteria ? " that match the filter criteria" : ""}.`}
return note+`. The total number of rows${criteria ? " matching the filter criteria" : ""} is unknown.`}
,isc.A.$281i=function isc_c_AI__getAnswerEngineMessagesBuilder(_1,_2){
var _3=_1.dataQuestion;
var _4=_3.settings;
_2=isc.addPropertiesWithAssign({
referenceTime:_1.referenceTime,
dataSources:_1.dataSources,
applicationPurpose:_4.applicationPurpose,
previousStepsCount:0
},_2);
var _5=isc.InternalAIMessagesBuilder.create({
userMessages:_3.summarizedUserMessages,
target:this,
evalVars:_2
});
_2=_5.evalVars;
var _6=_3.prevStepResults;
if(isc.isA.nonemptyArray(_6)){
var _7=[];
for(var _8=0;_8<_6.length;++_8){
var _9=_6[_8],
_10=_9.step,
_11=_10.type;
var _12=isc.addPropertiesWithAssign({type:null},_10,_9);
if(_11=="executeQuery"){
_11="makeQuery";
var _13=_10.validatedMakeQueryStepResult,
_14=_13.step;
_12=isc.addPropertiesWithAssign({
type:null,
dataSourceName:_14.dataSourceName,
queryPurpose:_14.queryPurpose,
queryDescription:_14.queryDescription,
dsRequest:_13.dsRequestProperties,
results:null
});
var _15=isc.DS.get(_12.dsRequest.dataSource),
_16=isc.DS.checkEmptyCriteria(_12.dsRequest.data,null,_15),
_17=_9.data;
if(!isc.isAn.Array(_17))_17=_17!=null?[_17]:[];
_12.results=_17;
var _18=_9.estimatedTotalRows,
_19;
if(_18!=null&&+_18>=0){
_19=+_18}else{
_19=_9.totalRows}
_12.note=this.$2887(_16,_17.length,_19,_18)}
_12.type=_11;
delete _12.step;
delete _12.$282r;
delete _12.$282s;
_7.push(_12)}
_2.previousSteps=_7;
_2.previousStepsCount=_7.length}
_5.renderTemplate("AnswerEngine_prelude");
return _5}
);
isc.B._maxIndex=isc.C+2;
isc.AI.registerTemplates({
AnswerEngine_determineNextStepPrompt:function(state,sc,j){
return isc.trimDoc`
            You are to determine the next step to take in order to answer the user's data-question.
            Your response must be a single JSON object with key "nextStepType" set to one of
            the following choices, along with the additional step-specific data:

            ### Available "nextStepType" values

            #### "makeQuery"
            Describe a query on one of the DataSources which is likely to result in useful
            information for answering the user's data-question.

            For this step type, the response JSON object must have the following additional properties:
            * "dataSourceName" (string): The ID of the DataSource to query.
            * "queryPurpose" (string): A detailed explanation of the purpose for making the query.
            * "queryDescription" (string): A detailed description of the query to make against
              the selected DataSource. This should include the relevant names of fields to select,
              how to group records, the summary functions (such as count(), sum(), max(), and min())
              to use and on which fields for each group.

            ### "createDashboard"
            Describe a dashboard to visually explain your answer to the user's data-question.

            For this step type, the response JSON object must have the following additional properties:
            * "fullAnswer" (HTML string): An HTML-formatted text string containing
              a complete and detailed: summary of your answer to the user's data-question, specific
              details as to why this is an answer to the user's data-question, any uncertainties
              you have in the answer, and possible follow-up questions and analyses that the
              user may make to learn more. This text will be displayed directly to the
              user, and you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}"
              in this text.
            * "answerOverview" (HTML string): A concise summary of the "fullAnswer", focusing
              mainly on your answer to the user's data-question. This text will be displayed directly to the
              user, and you must abide by the "${sc.AI.requirementsForDisplayingInformationSectionTitle}"
              in this text.
            * "components": An array of objects, where each object has the following properties:
                - "componentType": One of the component types listed below.
                - "description": A string that describes in detail a single component of the
                  specified component type to add to the dashboard.

            The choice of component types are:
            - "list" - A ListGrid which displays data from a single DataSource, and which may:
                * apply a filter to select a subset of the records from the DataSource according to criteria
                * sort the displayed records by one or more fields, with the sort by each field either in ascending or descending order
                * hilite a subset of the records according to criteria
                * group the records by one or more fields
                * apply summary functions to each group of records
                * show the data from a subset of the fields of the DataSource
                * have additional 'formula' fields which contain the result of an arithmetical formula involving values of each record
            - "chart" - A chart, such as a line graph, bar chart, or pie chart to display data from a single DataSource, and which may:
                * apply a filter to select a subset of the records from the DataSource according to criteria
                * plot one or more fields of records from the DataSource
                * have a title and labels for axes of the chart
            - "value" - A label displaying a single value (scalar) derived from the data in a DataSource

            ## Additional notes
            You are free to incorporate the results of previous steps.

            If you do not have enough information to answer the user's data-question, default
            to a "makeQuery" next step, in order to obtain more information from the data.

            If a query with criteria produces no results, try to issue another query with relaxed
            criteria to validate any assumptions about the data in a DataSource that you may be
            making. You may also decide to select the first few records from a DataSource to
            familiarize yourself with the format of data in the records.`}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.allowedDSRequestPropertyNames=["$282s","data","groupBy","summaryFunctions","sortBy","startRow","endRow"];
isc.B.push(isc.A.$281f=function isc_c_AI__asyncAnswerEngineDetermineNextStep(_1,_2){
var _3=this.$281i(_1);
_3.renderTemplate("AnswerEngine_determineNextStepPrompt");
if(this.responseSpoofingMode!="none"&&_2.$282r){
_3.appendPrompt("$282r "+_2.$282r);
delete _2.$282r}
var _4={
cancellationController:_1.cancellationController,
messages:_3.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_4,_1.$261g)
.$2800(function(_23){
var _5=_23.message.content;
if(!isc.isAn.Object(_5))return isc.rejectWithError(isc.AI.aiNotAbleToProcessRequestErrorMessage);
var _6=_5.nextStepType;
if(!isc.isA.nonemptyString(_6))return isc.rejectWithError("AI did not provide a next step type.");
if(_6=="makeQuery"){
var _7=_5.dataSourceName;
if(!isc.isA.nonemptyString(_7))return isc.rejectWithError("AI did not specify a data source.");
var _8=isc.DS.get(_7);
if(!_8)return isc.rejectWithError("AI specified a non-existent data source name '"+String(_8).asHTML()+"'.");
var _9=_1.dataSources;
if(!_9||!_9.contains(_8)){
return isc.rejectWithError("AI did not select an available data source; data source name '"+String(_8).asHTML()+"' is not available.")}
if(!isc.isA.nonemptyString(_5.queryPurpose)){
return isc.rejectWithError("AI did not specify a purpose for making the query.")}
if(!isc.isA.nonemptyString(_5.queryDescription)){
return isc.rejectWithError("AI did not describe the query to make.")}
var _10={
type:"makeQuery",
dataSourceName:_7,
queryPurpose:_5.queryPurpose,
queryDescription:_5.queryDescription
};
if(_5.$282s)_10.$282r=_5.$282s;
return _10}else if(_6=="createDashboard"){
var _11=_5.fullAnswer;
if(!isc.isA.String(_11)||
!(_11=_11.trim()))
{
return isc.rejectWithError("AI did not include its full answer.")}
var _12=_5.answerOverview;
if(!isc.isA.String(_12)||
(_12=_12.trim())=="")
{
return isc.rejectWithError("AI did not include an answer overview.")}
var _13=_5.components;
if(!isc.isAn.Array(_13)||_13.isEmpty()){
return isc.rejectWithError("AI determined to create a dashboard; however, it did not specify any dashboard components.")}
var _14=[],
_15=_1.dataQuestion.settings.allowedDashboardComponentTypes||isc.AnswerEngineOperation.allDashboardComponentTypes;
for(var c=0;c<_13.length;++c){
var _17=_13[c],
_18,
_19;
if(!isc.isAn.Object(_17)||
isc.isAn.Array(_17)||
!isc.isA.String(_18=_17.componentType)||
isc.isAn.emptyString(_18=_18.trim())||
!isc.isA.String(_19=_17.description)||
isc.isAn.emptyString(_19=_19.trim()))
{
this.logDebug("`componentSpecs["+c+"]` does not look like a valid component spec. Skipping...","AnswerEngine");
continue}
if(!_15.contains(_18)){
this.logDebug("componentType '"+_18+"' is "+
(!isc.AnswerEngineOperation.allDashboardComponentTypes.contains(_18)
?"unknown":"not allowed")+". Skipping...","AnswerEngine");
continue}
var _20={
type:"createDashboardComponent",
fullAnswer:_11,
answerOverview:_12,
componentType:_18,
description:_19
};
if(_17.$282s)_20.$282r=_17.$282s;
_14.push(_20)}
if(_14.isEmpty()){
return isc.rejectWithError("AI determined to create a dashboard; however, it did not validly specify any dashboard components.")}
var _21=_14.length;
for(var s=0;s<_21;++s){
var _20=_14[s];
if(s==0)_20.isFirst=true;
if(s==_21-1)_20.isLast=true;
_20.numCreateDashboardComponentSteps=_21}
return{
type:"createDashboard",
fullAnswer:_11,
answerOverview:_12,
createDashboardComponentSteps:_14
}}else if(_6=="noOp")return{type:"noOp"};
return isc.rejectWithError("Unhandled next step type '"+String(_6).asHTML()+"'")},
null,
this)}
,isc.A.$281v=function isc_c_AI__maskFetchDSRequestProperties(_1,_2,_3,_4,_5){
_4=_4||this.allowedDSRequestPropertyNames;
_1=isc.applyMask(_1,_4);
_1.dataSource=_2;
var _6=_1.startRow;
if(_6!=null)_6=_1.startRow=Math.trunc(_6);
if(!isc.isA.Number(_6)){
_6=_1.startRow=0}
var _7=_1.endRow;
if(_7!=null)_7=_1.endRow=Math.trunc(_7);
if(!isc.isA.Number(_7)){
_7=_1.endRow=_6+_3}
if(_7<_6){
var _8=_6;
_6=_7;
_7=_8;
_1.startRow=_6;
_1.endRow=_7}else if(_6==_7){
_7=_1.endRow=_6+1}
if((_7-_6)>_3){
_7=_1.endRow=_6+_3}
var _9=_1.data;
if(isc.isAn.Object(_9)&&!isc.isAn.Array(_9)){
var _10=_2&&isc.DS.get(_2);
if(_10){
if(_10.isAdvancedCriteria(_9)){
_1.data=this.$268v(_9,_5)}else{
}
}
}else{
delete _1.data}
return _1}
);
isc.B._maxIndex=isc.C+2;
isc.AI.registerTemplates({
AnswerEngine_makeQueryPrompt:function(state,sc,j){
return isc.trimDoc`
            You have previously decided to make a query on the '${state.dsName}' DataSource.

            You stated that the purpose of the query is "${state.queryPurpose}"

            A detailed description of the query that you want to make is: "${state.queryDescription}"

            You are now to convert your description of the query into a JSON object, a DSRequest object.

            The following properties are available for a DSRequest object:

            "data": An AdvancedCriteria object that can be used to filter records in the DataSource to only those matching the specified criteria.
            Here is information about the AdvancedCriteria object:
            <help-document topic="${sc.AI.advancedCriteriaAIHelpDocument.topic}" format="${sc.AI.advancedCriteriaAIHelpDocument.format}">
            ${sc.AI.advancedCriteriaAIHelpDocument.content}
            </help-document>

            "groupBy": An array of field name strings to group records by. Note that records are filtered by the AdvancedCriteria before they are grouped.

            "summaryFunctions": An object that maps a field name to the summary function to use on that field. The available summary functions are:
                * "sum"
                * "avg"
                * "max"
                * "min"
                * "count"

            "sortBy": Field name to sort by, prefixed with optional "-" indicating descending sort. For example, to sort by the field "userName" in ascending order, set "sortBy" to just "userName". For descending sort on "userName", set "sortBy" to "-userName".
            To sort by multiple fields, an array of field names is also supported. For example, to sort by the field "department" in ascending order, followed by the field "userName" in descending order, set "sortBy" to: ["department", "-userName"]

            "startRow": Zero-based index of the starting row to fetch from the query results. If not specified, the default is 0.

            "endRow": Zero-based index of the ending row to fetch from the query results. The record at index "endRow" is not included. If not specified, the default is ${state.maxRecordsPerQuery} more than the "startRow".

            Queries are limited to returning at most ${state.maxRecordsPerQuery} records at a time.
            If you need to examine more records, you must "page" through the result set.
        `}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.$281g=function isc_c_AI__asyncAnswerEngineMakeQuery(_1,_2){
var _3=this.$281i(_1),
_4=_3.evalVars,
_5=_2.dataSourceName,
_6=_1.maxRecordsPerQuery;
_4.dsName=_5;
_4.queryPurpose=_2.queryPurpose;
_4.queryDescription=_2.queryDescription;
_4.maxRecordsPerQuery=_6;
_3.renderTemplate("AnswerEngine_makeQueryPrompt");
if(this.responseSpoofingMode!="none"&&_2.$282r){
_3.appendPrompt("$282r "+_2.$282r);
delete _2.$282r}
var _7={
cancellationController:_1.cancellationController,
messages:_3.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_7,_1.$261g)
.$2800(function(_9){
var _8=_9.message.content;
if(!isc.isAn.Object(_8))return isc.rejectWithError(this.aiNotAbleToProcessRequestErrorMessage);
return this.$281v(_8,_5,_6)},
null,
this)}
);
isc.B._maxIndex=isc.C+1;
isc.AI.registerTemplates({
AnswerEngine_createComponentPrompt:function(state,sc,j){
var componentType=state.componentType,
numCreateDashboardComponentSteps=state.numCreateDashboardComponentSteps;
return isc.trimDoc`
            You have previously decided to build a ${componentType} dashboard component.

            Your overview of the answer to the user's question is:
            <answer-overview format="HTML">
            ${state.answerOverview}
            </answer-overview>

            A detailed description of the component to be created is:
            <component-description>
            ${state.description}
            </component-description>

            Please generate a JSON object in the following format:
            {
            "componentOverview":An HTML-formatted text string of a one to four very concise
                    sentences in a Neutral/Analytical tone which introduce the component, the
                    reason(s) for including the component in the dashboard, and how the
                    component provides insight into the answer to the user's question or
                    opportunities for further analysis. Try to avoid redundancy with the
                    answer overview.
                    ${
                        sc.if(numCreateDashboardComponentSteps == 1,
                            "This is the only component of the dashboard, so the text should fully explain why the component answers or significant insight into the question. "
                        ) +
                        sc.if(numCreateDashboardComponentSteps >= 3 && state.isFirst,
                            "This is the first component of the dashboard, so the style of the text should be in the form of an introduction. "
                        ) +
                        sc.if(numCreateDashboardComponentSteps >= 3 && state.isLast,
                            "This is the last component of the dashboard, so a word like \"finally\" or \"lastly\" should be used, and the style of the text should be in the form of a conclusion. "
                        )
                    }This text will be displayed directly to the user, and you must abide by the
                    "${sc.AI.requirementsForDisplayingInformationSectionTitle}" in this text.
            "node":A ${componentType} PaletteNode object that is used to create the SmartClient ${componentType}.
            }

            A ${componentType} PaletteNode is an object of the form:
            {
            "type":"${componentType}",
            "defaults":An object containing the initial properties of the ${componentType}. This is essentially the object that is passed to the isc.${componentType}.create() method which creates the ${componentType} on screen.
            }

            Further instructions for the initial ${componentType} properties are as follows:
            ${state.initialPropertiesPrompt}
        `}
});
isc.A=isc.AI;
isc.A.generalDataBoundInitialPropertiesPrompt="- The \"dataSource\" property should be set to the ID string of the dataSource.\n- In order to fetch data to display, \"autoFetchData\" should be set to true.\n- If criteria should be applied to the fetch, the \"initialCriteria\" property should be specified as an AdvancedCriteria object.\n- If some form of data aggregation or summarization is required---for example a list of each unique value for some field along with a count of records, or sum of some other numeric field value within that group---this can be achieved by customizing the DSRequest that is used to fetch data for the component. The \"fetchRequestProperties\" property for the component can be used to set appropriate \"groupBy\" and \"summaryFunctions\" DSRequest properties for the data fetch.\n\nHere is information about the AdvancedCriteria object:\n<help-document topic=\""+isc.AI.advancedCriteriaAIHelpDocument.topic+"\" format=\""+isc.AI.advancedCriteriaAIHelpDocument.format+"\">\n"+
isc.AI.advancedCriteriaAIHelpDocument.content+"\n</help-document>\n\n"
;
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.A.infoByComponentType={
list:{
type:"ListGrid",
initialPropertiesPrompt:isc.AI.generalDataBoundInitialPropertiesPrompt+
"ListGrids may be displayed in a \"grouped\" view. This is different from a true aggregated view and may be achieved via the \"groupByField\" property of the grid.\nExample listGrids:\nGiven a data source with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following ListGrid PaletteNode would satisfy the requirement to view a list of records where 'price' is less than 100, sorted by 'price' in ascending order:\n```\n{\n    \"type\":\"ListGrid\",\n    \"defaults\":{\n        \"autoFetchData\":true,\n        \"dataSource\":\"myDS\",\n        \"fields\":[\n            {\"name\":\"location\"},\n            {\"name\":\"title\"},\n            {\"name\":\"description\"},\n            {\"name\":\"price\"}\n        ],\n        \"initialCriteria\":{\n            \"fieldName\":\"price\",\n            \"operator\":\"lessThan\",\n            \"value\":100\n        },\n        \"initialSort\":[\n            {\n                \"property\":\"price\",\n                \"direction\":\"ascending\"\n            }\n        ]\n    }\n}\n```\nOr, for the same data source, the following ListGrid PaletteNode would satisfy a requirement to show the average 'price' for each location, using a true aggregated view. Note that because we're inferring the 'price' field to be a currency field, we're applying \"decimalPrecision\":2. If a specific precision is needed, then \"decimalPrecision\" can be changed to that. :\n```\n{\n    \"type\":\"ListGrid\",\n    \"defaults\":{\n        \"autoFetchData\":true,\n        \"dataSource\":\"myDS\",\n        \"fields\":[\n            {\"name\":\"location\"},\n            {\"name\":\"price\", \"decimalPrecision\":2}\n        ],\n        \"fetchRequestProperties\":{\n            \"groupBy\":[\"location\"],\n            \"summaryFunctions\":{\n                \"price\":\"avg\"\n            }\n        }\n    }\n}\n```\n\nSetting the \"showFilterEditor\" property to true will show an editor that the user can use to customize the filter on the data of the ListGrid.\n"
},
chart:{
type:"FacetChart",
initialPropertiesPrompt:isc.AI.generalDataBoundInitialPropertiesPrompt+
"Note that the FacetChart you generate should have its \"valueProperty\" set to the numeric-typed field containing data values for records, and facetFields should be used to define facets for the chart.\nIf a clear, simple title for the chart can be derived, include the \"title\" attribute.\nExamples:\nGiven a data source with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following FacetChart PaletteNode would satisfy a requirement to build a chart showing items that cost more than $500 in each location:\n```\n{\n    \"type\":\"FacetChart\",\n    \"defaults\":{\n        \"title\": \"Items at Each Location Costing More Than $500\",\n        \"dataSource\": \"myDS\",\n        \"facets\": [\n            {\n                \"id\": \"location\",\n                \"title\": \"Location\"\n            },\n            {\n                \"id\": \"title\",\n                \"title\": \"Title\"\n            }\n        ],\n        \"stacked\":false,\n        \"valueProperty\": \"price\",\n        \"showDataValuesMode\":\"auto\",\n        \"chartType\": \"Column\",\n        \"autoFetchData\": true,\n        \"initialCriteria\":{\n            \"fieldName\":\"unitCost\",\n            \"operator\":\"greaterThan\",\n            \"value\":500\n        }\n    }\n}\n```\nOr, for the same data source, the following FacetChart PaletteNode would satisfy a requirement to chart the total number of items for each location:\n```\n{\n    \"type\":\"FacetChart\",\n    \"defaults\":{\n        \"title\": \"Total Number of Items by Location\",\n        \"dataSource\": \"myDS\",\n        \"facets\": [\n            {\n                \"id\": \"location\",\n                \"title\": \"Location\"\n            }\n        ],\n        \"valueProperty\": \"code\",\n        \"showDataValuesMode\":\"auto\",\n        \"autoFetchData\": true,\n        \"fetchRequestProperties\":{ \n            \"groupBy\":[\"location\"],\n            \"summaryFunctions\":{\n                \"code\":\"count\"\n            }\n        }\n    }\n}\n```\n\nValid values for the \"chartType\" property are:\n\"Column\" - (the default if not specified) a bar chart with vertical bars\n\"Bar\" - a bar chart with horizontal bars\n\"Line\" - a chart where values are displayed side-by-side, connected by lines\n\"Radar\" - a chart where values are displayed around a circle, connected by lines\n\"Pie\" - a pie chart\n\"Doughnut\" - a pie chart with a center hole\n"
},
value:{
type:"ScalarViewer",
initialPropertiesPrompt:isc.AI.generalDataBoundInitialPropertiesPrompt+
"ScalarViewer is a component based on a SmartClient DynamicForm which uses the attribute \"fieldName\" to extract a single field value from a record and the attribute \"title\" as a title for the single field value.\nOther standard DynamicForm properties such as \"dataSource\", \"autoFetchData\" and \"initialCriteria\" are used to populate the item with a single record.\nExamples:\nGiven a data source with ID:\"myDS\", and fields  \"code\" (primary key), \"location\", \"title\", \"description\" and \"price\",the following ScalarViewer PaletteNode would display the \"description\" for the record where \"code\" has the value \"abc123\":\n```\n{\n    \"type\": \"ScalarViewer\",\n    \"defaults\": {\n        \"autoFetchData\":true,\n        \"dataSource\": \"myDS\",\n        \"title\":\"Description for item abc123\",\n        \"fieldName\":\"description\",\n        \"initialCriteria\":{\n            \"fieldName\":\"code\",\n            \"operator\":\"equals\",\n            \"value\":\"abc123\"\n        }\n    }\n}\n```\nOr, for the same data source, the following ScalarViewer PaletteNode would satisfy a requirement to show the average price for items in San Francisco:\n```\n{\n    \"type\": \"ScalarViewer\",\n    \"defaults\": {\n        \"autoFetchData\":true,\n        \"dataSource\": \"myDS\",\n        \"title\":\"Average price of items in San Francisco\",\n        \"fieldName\":\"price\",\n        \"initialCriteria\":{\n            \"fieldName\":\"location\",\n            \"operator\":\"equals\",\n            \"value\":\"San Francisco\"\n        },\n        \"fetchRequestProperties\":{ \n            \"groupBy\":[\"location\"], \n            \"summaryFunctions\":{\n                \"price\":\"avg\"\n            }\n        }\n    }\n}\n```\n\nTo control which record is retrieved, it may be necessary to sort by a field, by adding a \"sortBy\" property to the ScalarViewer's \"fetchRequestProperties\" object. The \"sortBy\" property is the name of the field that the data are sorted by, prefixed with a minus sign ('-') if the data should be sorted by the field in descending order.\nFor example, using the same \"myDS\" dataSource, the following ScalarViewer PaletteNode would satisfy a requirement to show the \"location with the highest price\":```\n{\n    \"type\": \"ScalarViewer\",\n    \"defaults\": {\n        \"autoFetchData\":true,\n        \"dataSource\": \"myDS\",\n        \"title\":\"Location with the highest price\",\n        \"fieldName\":\"location\",\n        \"fetchRequestProperties\":{ \n            \"sortBy\": \"-price\"\n        }\n    }\n}\n```\nIn this example, the first row, when sorted by the price in descending order, is for the location with the highest price in the data source."
}
};
isc.B.push(isc.A.$281w=function isc_c_AI__getAnswerEngineCreateComponentMessagesBuilder(_1,_2){
var _3=this.$281i(_1,_2),
_4=_3.evalVars,
_5=_2.componentType;
var _6,
_7=this.infoByComponentType[_5];
if(_7){
_5=_7.type;
_6=_7.initialPropertiesPrompt}
_4.componentType=_5;
_4.initialPropertiesPrompt=_6;
_3.renderTemplate("AnswerEngine_createComponentPrompt");
return _3}
,isc.A.$283o=function isc_c_AI___maskCreateDashboardComponentResponseObject(_1){
_1=this.$2855(_1);
return isc.applyMask(_1,["componentOverview","nodes","$282s"])}
,isc.A.$281q=function isc_c_AI__asyncAnswerEngineCreateDashboardComponent(_1,_2){
var _3=this.$281w(_1,_2);
if(this.responseSpoofingMode!="none"&&_2.$282r){
_3.appendPrompt("$282r "+_2.$282r);
delete _2.$282r}
var _4={
cancellationController:_1.cancellationController,
messages:_3.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_4,_1.$261g)
.then(function(_5){
return isc.AI.$283o(_5.message.content)})}
);
isc.B._maxIndex=isc.C+3;
isc.AI.registerTemplates({
AnswerEngine_fixDashboardComponentPrompt:function(state,sc,j){
return isc.trimDoc`
            You generated the following palette nodes:

            \`\`\`
            ${j(state.prevNodes, true)}
            \`\`\`

            This is not correct for the following reason(s):
            ${j(state.prevValidationErrors, true)}

            Please try again to generate the palette node for creating the dashboard component, correcting the error(s).
        `}
});
isc.A=isc.AI;
isc.B=isc._allFuncs;
isc.C=isc.B._maxIndex;
isc.D=isc._funcClasses;
isc.D[isc.C]=isc.A.Class;
isc.B.push(isc.A.$281u=function isc_c_AI__asyncAnswerEngineFixDashboardComponent(_1,_2){
var _3=_2.prevValidateDashboardComponentStepResults,
_4=_3.length,
_5=_1.dataQuestion.settings.maxFixAttempts!=null
?_1.dataQuestion.settings.maxFixAttempts
:this.defaultMaxFixAttempts;
if(_4>_5){
return isc.rejectWithError("AI did not generate valid UI code in "+_5+" attempts.")}
var _6=this.$281w(_1,_2.createDashboardComponentStep),
_7=_6.evalVars;
var _8=_3[_4-1],
_9=_8.step.createDashboardComponentStepResult.paletteNodes,
_10=_9;
_7.prevNodes=_10;
_7.prevValidationErrors=_8.validationErrors;
_6.renderTemplate("AnswerEngine_fixDashboardComponentPrompt");
if(this.responseSpoofingMode!="none"&&_2.$282r){
_6.appendPrompt("$282r "+_2.$282r);
delete _2.$282r}
var _11={
cancellationController:_1.cancellationController,
messages:_6.aiMessages,
responseType:"object",
willHandleError:true
};
return this.asyncSendRequest(_11,_1.$261g)
.$2800(function(_12){
return this.$283o(_12.message.content)},
null,
this)}
);
isc.B._maxIndex=isc.C+1;
isc._nonDebugModules=(isc._nonDebugModules!=null?isc._nonDebugModules:[]);isc._nonDebugModules.push('AI_Server');isc.checkForDebugAndNonDebugModules();isc._moduleEnd=isc._AI_Server_end=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('AI_Server module init time: '+(isc._moduleEnd-isc._moduleStart)+'ms','loadTime');delete isc.definingFramework;if(isc.Page)isc.Page.handleEvent(null,"moduleLoaded",{moduleName:'AI_Server',loadTime:(isc._moduleEnd-isc._moduleStart)});}else{if(window.isc&&isc.Log&&isc.Log.logWarn)isc.Log.logWarn("Duplicate load of module 'AI_Server'.");}
