/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-01-27/LGPL Deployment (2026-01-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
isc.ClassFactory.defineClass("MathFunction", "Class");

// static properties and methods
isc.MathFunction.addClassProperties({
    

	_functions : {}                 // internal array to hold the list of registered functions
});


isc.MathFunction.addClassMethods({

//> @classMethod MathFunction.registerFunction()
// Registers a new math function for use with FormulaFields. Mixed-case names are allowed,
// and as a convenience, the following aliases are also available:<ul>
// <li> name in all lowercase 
// <li> name in all uppercase
// <li> name with first letter uppercase, and the rest unchanged</ul>
//
// Note: The aliases are shallow copies of each other, so be aware that if +link{jsFunction}
// depends on instance state, objects accessed by instance properties will be shared by all
// copies.
//
// @param newFunction (MathFunction)
// 
// @group formulaFields
// @visibility external
//<
registerFunction : function (newFunction) {
    if (!this._functions[newFunction.name]) {
        this._functions[newFunction.name] = newFunction;
    }
    // the following lines will add the math function with all lowercase name
    var newFunctionLowerCase = newFunction._copy();
    newFunctionLowerCase.name = newFunction.name.toLowerCase();
    newFunctionLowerCase.defaultSortPosition = -1;
    if (!this._functions[newFunctionLowerCase.name]) {
        this._functions[newFunctionLowerCase.name] = newFunctionLowerCase;
    }
    // the following lines will add the math function with all uppercase name
    var newFunctionUpperCase = newFunction._copy();
    newFunctionUpperCase.name = newFunction.name.toUpperCase();
    newFunctionUpperCase.defaultSortPosition = -1;
    if (!this._functions[newFunctionUpperCase.name]) {
        this._functions[newFunctionUpperCase.name] = newFunctionUpperCase;
    }
    // the following lines will add the math function with initial uppercase name
    var newFunctionInitialUpperCase = newFunction._copy();
    newFunctionInitialUpperCase.name = (newFunction.name.substr(0, 1).toUpperCase() +
                                        newFunction.name.substr(1));
    newFunctionInitialUpperCase.defaultSortPosition = -1;
    if (!this._functions[newFunctionInitialUpperCase.name]) {
        this._functions[newFunctionInitialUpperCase.name] = newFunctionInitialUpperCase;
    }
},

// Returns a list of all registered function-names
getRegisteredFunctionNames : function () {
    return isc.getKeys(this._functions);
},

// Returns a list of default function-names, sorted by defaultSortPosition
getDefaultFunctionNames : function () {
    var funcs = this.getDefaultFunctions(),
        index = funcs.makeIndex("name", false);
    return isc.getKeys(index);
},

// Returns a list of all registered functions
getRegisteredFunctions : function () {
    return isc.getValues(this._functions);
},

// Returns a list of default functions, order by defaultSortPosition
getDefaultFunctions : function () {
    var allFuncs = this.getRegisteredFunctions(),
        nonDefaults = allFuncs.findAll("defaultSortPosition", -1) || []
    ;

    for (var i=0; i<nonDefaults.length; i++) {
        var item = nonDefaults[i];
        allFuncs.remove(item);
    }

    allFuncs.sortByProperties(["defaultSortPosition"], ["true"]);
    return allFuncs;
},


//> @classMethod MathFunction.getRegisteredFunctionIndex()
// Returns an index of all registered functions by name
// 
// @return (int)
// @group formulaFields
// @visibility external
//<
getRegisteredFunctionIndex : function () {
    var x = this.getRegisteredFunctions();
    var xIndex = x.makeIndex("name", false);
    return xIndex;
},

//> @classMethod MathFunction.getDefaultFunctionIndex()
// Returns an index of all default registered functions by name, ordered by 
// +link{mathFunction.defaultSortPosition}.  (Also includes those user-registered
// functions with non-default (&gt;= 0) values for that property.)
// 
// @return (int)
//
// @see Array.makeIndex
// @see defaultSortPosition
// @group formulaFields
// @visibility external
//<
getDefaultFunctionIndex : function () {
    return this.getDefaultFunctions().makeIndex("name", false);
},

// Returns true if the named function is registered, false otherwise
isRegistered : function (name) {
    if (this._functions[name]) return true;
    return false;
}


});

isc.MathFunction.addProperties({
// attributes 
//> @attr mathFunction.name (Identifier : null : IR)
// Name of the function (what the user actually types).  For example, a name of "min" would
// indicate that the user types "min(someValue)" to use this function.
// <P>
// Mixed-case names may be used.  As a convenience, a few aliases are registered by 
// +link{registerFunction} (see that method for details).
// 
// @see registerFunction
// @group formulaFields
// @visibility external
//<

//> @attr mathFunction.description (String : null : IR)
// A short description of this function
// 
// @group formulaFields
// @visibility external
//<

//> @attr mathFunction.jsFunction (Function : null : IR)
// Javascript method to perform the calculation associated with this function
// 
// @group formulaFields
// @visibility external
//<

//> @attr mathFunction.defaultSortPosition (Integer : -1 : IR)
// Indicates the sort-order of this +link{MathFunction} in an index returned from static method
// +link{MathFunction.getDefaultFunctionIndex()}.  A lower value (&gt;= 0) will cause a function
// to appear before a +link{MathFunction} with a higher value of the property.  The default
// of -1 means to exclude the MathFunction from the index entirely.
// 
// @group formulaFields
// @see classMethod:MathFunction.getDefaultFunctionIndex()
// @visibility external
//<
defaultSortPosition: -1,

// copy a MathFunction instance

_copy : function (newProperties) {
    var instanceProperties = {};
    for (var property in this) {
        if (this.hasOwnProperty(property)) {
            instanceProperties[property] = this[property];
        }
    }
    return this.getClass().create(instanceProperties, newProperties);
}

});

// register some built in functions
// This first bunch are default ones that appear in the help list in FormulaBuilders
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "max",
        description: "Maximum of two values",
        usage: "max(value1, value2)",
        defaultSortPosition: 1,
        jsFunction: function (value1, value2) {
            return Math.max(value1, value2);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "min",
        description: "Minimum of two values",
        usage: "min(value1, value2)",
        defaultSortPosition: 2,
        jsFunction: function (value1, value2) {
            return Math.min(value1, value2);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "clamp",
        description: "Value clamped to range specified",
        usage: "clamp(value1, value2)",
        defaultSortPosition: 3,
        jsFunction: function (value, min, max) {
            return isc.Math.clamp(value, min, max);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "round",
        description: "Round a value up or down, optionally providing <i>decimalDigits</i> " +
            "as the maximum number of decimal places to round to.  For fixed or precision " +
	        "rounding, use <i>toFixed()</i> and <i>toPrecision()</i> respectively.",
        usage: "round(value,decimalDigits)",
        defaultSortPosition: 4,
        jsFunction: function (value, decimalDigits) {
            if (decimalDigits) {
                var multiplier = Math.pow(10, decimalDigits),
                    result = Math.round(value * multiplier) / multiplier;

                return result;
            } 
            return Math.round(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "ceil",
        description: "Round a value up",
        usage: "ceil(value)",
        defaultSortPosition: 5,
        jsFunction: function (value) {
            return Math.ceil(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "floor",
        description: "Round a value down",
        usage: "floor(value)",
        defaultSortPosition: 6,
        jsFunction: function (value) {
            return Math.floor(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "abs",
        description: "Absolute value",
        usage: "abs(value)",
        defaultSortPosition: 7,
        jsFunction: function (value) {
            return Math.abs(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "pow",
        description: "Value1 to the power of Value2",
        usage: "pow(value1, value2)",
        defaultSortPosition: 8,
        jsFunction: function (value1, value2) {
            return Math.pow(value1, value2);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "sqrt",
        description: "Square root of a value",
        usage: "sqrt(value)",
        defaultSortPosition: 9,
        jsFunction: function (value) {
            return Math.sqrt(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "dateAdd",
        description: "Excel&trade;-compatible dataAdd function: adds a specified time interval to a date value",
        usage: "dateAdd(Date value, TimeUnit interval, number amount)",
        defaultSortPosition: 10,
        jsFunction: function (value, interval, amount) {
            if (value == null || !isc.isA.Date(value)) return null;
            
            return isc.DateUtil.dateAdd(value, interval, amount, 1, value.logicalDate);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "year",
        description: "4-digit integer that represents the year of a date",
        usage: "year(Date value)",
        defaultSortPosition: 11,
        jsFunction: function (value) {
            if (value == null || !isc.isA.Date(value)) return null;
            return value.getFullYear();
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "month",
        description: "1-12 integer that represents the month of a date",
        usage: "month(Date value)",
        defaultSortPosition: 12,
        jsFunction: function (value) {
            if (value == null || !isc.isA.Date(value)) return null;
            return value.getMonth() + 1;
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "day",
        description: "1-31 integer that represents the day of month of a date",
        usage: "day(Date value)",
        defaultSortPosition: 13,
        jsFunction: function (value) {
            if (value == null || !isc.isA.Date(value)) return null;
            return value.getDate();
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "toPrecision",
        description: "Format a number to a length of <i>precision</i> digits, rounding or " +
            "adding a decimal point and zero-padding as necessary.  Note that the values " +
            "123, 12.3 and 1.23 have an equal precision of 3.  Returns a formatted " +
            "string and should be used as the outermost function call in a formula. " +
            "For rounding, use <i>round()</i>.",
        usage: "toPrecision(value,precision)",
        defaultSortPosition: 14,
        jsFunction: function (value, precision) {
            var localValue=value;
            if (isc.isA.String(localValue)) localValue = parseFloat(localValue);
            if (isNaN(localValue)) return value;
            return localValue.toPrecision(precision);
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "toFixed",
        description: "Round or zero-pad a number to <i>digits</i> decimal places.  Returns " +
            "a formatted string and should be used as the outermost function call in a " +
            "formula.  To round values or restrict precision, use <i>round()</i> and " +
            "<i>toPrecision()</i> respectively.",
        usage: "toFixed(value,digits)",
        defaultSortPosition: 15,
        jsFunction: function (value, digits) {
            var localValue=value;
            if (isc.isA.String(localValue)) localValue = parseFloat(localValue);
            if (isNaN(localValue)) return value;
            return localValue.toFixed(digits);
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "sin",
        description: "Sine of a value",
        usage: "sin(value)",
        defaultSortPosition: 16,
        jsFunction: function (value) {
            return Math.sin(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "cos",
        description: "Cosine of a value",
        usage: "cos(value)",
        defaultSortPosition: 17,
        jsFunction: function (value) {
            return Math.cos(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "tan",
        description: "Tangent of a value",
        usage: "tan(value)",
        defaultSortPosition: 18,
        jsFunction: function (value) {
            return Math.tan(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "ln",
        description: "Natural logarithm of a value",
        usage: "ln(value)",
        defaultSortPosition: 19,
        jsFunction: function (value) {
            return Math.log(value);
        }
    })
);


isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "log",
        description: "logarithm of a value with the specified <i>base</i>",
        usage: "log(base, value)",
        defaultSortPosition: 20,
        jsFunction: function (base, value) {
            // 1 arg means the "base" is the value to create a log for
            if (arguments.length == 1) return Math.log(base);
            return Math.log(value) / Math.log(base);
        }
    })
);

// non-default functions (don't appear in the help list in FormulaBuilders)
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "asin",
        description: "Arcsine of a value",
        usage: "asin(value)",
        defaultSortPosition: 21,
        jsFunction: function (value) {
            return Math.asin(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "acos",
        description: "Arccosine of a value",
        usage: "acos(value)",
        defaultSortPosition: 22,
        jsFunction: function (value) {
            return Math.acos(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "atan",
        description: "Arctangent of a value (-PI/2 to PI/2 radians)",
        usage: "atan(value)",
        defaultSortPosition: 23,
        jsFunction: function (value) {
            return Math.atan(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "atan2",
        description: "Angle theta of a point (-PI to PI radians)",
        usage: "atan2(value1,value2)",
        defaultSortPosition: 24,
        jsFunction: function (value1, value2) {
            return Math.atan2(value1, value2);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "exp",
        description: "The value of E<sup>value</sup>",
        usage: "exp(value)",
        defaultSortPosition: 25,
        jsFunction: function (value) {
            return Math.exp(value);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "random",
        description: "Random number between 0 and 1",
        usage: "random()",
        defaultSortPosition: 26,
        jsFunction: function () {
            return Math.random();
        }
    })
);

// Additional formula functions for client-only DataSourceField.formula support.
// These replicate standard SQL Database scalar function capabilities on the client side.



//> @groupDef formulaFunction
// +link{dataSourceField.formula,DataSourceField formulas} may make use of functions to
// derive values from other fields in the record being accessed.
// <P>
// For an SQL-backed dataSource, the specified <code>dataSourceField.formula</code> will be 
// included in the SQL statements generated by the SmartClient server. These can make use of
// the scalar functions supported by the database engine. See the documentation for your
// database for a full list of available functions.
// <P>
// The following functions are available to provide equivalent functionality for 
// +link{DataSource.clientOnly,clientOnly} dataSources. Nte that the database support 
// information is for reference only - we recommend consulting your database's official
// documentation for definitive details of the functions available to you.
// <P>
// <table border=1 cellpadding=4>
// <tr>
//  <th rowspan="2"><b>Function</b></th>
//  <th rowspan="2"><b>Description</b></th>
//  <th colspan="4"><b>Database support</b></th>
// </tr>
// <tr>
//  <th><b>MySQL / MariaDB</b></th>
//  <th><b>PostgreSQL</b></th>
//  <th><b>SQL Server</b></th>
//  <th><b>SQLite</b></th>
// </tr>
// <tr>
//  <th colspan="6">Math / Numeric functions</th>
// </tr>
// <tr>
//  <td><code>round(val1, val2)</code></td>
//  <td>Round a numeric value up or down to the specified precision</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N</td>
//  <td>N</td>
// </tr>
// <tr>
//  <td><code>ceil(val1)</code></td>
//  <td>Round a numeric value up to a whole number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N <i>[available as <code>ceiling()</code>]</i></td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>ceiling(val1)</code></td>
//  <td>Round a numeric value up to a whole number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N <i>[available as <code>ceil()</code>]</i></td>
// </tr>
// <tr>
//  <td><code>floor(val1)</code></td>
//  <td>Round a numeric value down to a whole number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>mod(val1,val2)</code></td>
//  <td>Modulus operator, also available as<br><i><code>val1 % val2</code></i></td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N <i>[use <code>val1 % val2</code> instead]</i></td>
//  <td>N <i>[use <code>val1 % val2</code> instead]</i></td>
// </tr>
// <tr>
//  <td><code>greatest(val1,val2,...)</code></td>
//  <td>Maximum of a series of numeric values</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N</td>
//  <td>N</td>
// </tr>
// <tr>
//  <td><code>least(val1,val2,...)</code></td>
//  <td>Minimum of a series of numeric values</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N</td>
//  <td>N</td>
// </tr>
// <tr>
//  <td><code>sin(val1)</code></td>
//  <td>Returns the sine of the number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>cos(val1)</code></td>
//  <td>Returns the cosine of the number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>tan(val1)</code></td>
//  <td>Returns the tangent of the number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>log(value)</code> or <code>log(base, value)</code></td>
//  <td>Returns the log of the numeric value. 
//  If one argument is passed, this will be the natural log. If two arguments are passed 
//  returns the log in the specified base.<br>
//  <td>Y</td>
//  <td>Differs: In PostgreSQL if log() is passed a single value it will return the base 10 log rather than natural log.<br>
//      If passed 2 values, behavior matches the client.</td>
//  <td>Differs: In SQL Server if log() is passed two arguments, the first argument is the value and the second is the base<br>
//      If passed 1 value, behavior matches the client.</td>
//  <td>Differs: In SQLite if log() is passed a single value it will return the base 10 log rather than the natural log.<br>
//      If passed 2 values, behavior matches the client.</td>
// </tr>
// <tr>
//  <td><code>ln(val1)</code></td>
//  <td>Returns the natural log of the numeric value</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>log10(val1)</code></td>
//  <td>Returns the base-10 log of the numeric value</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>exp(val1)</code></td>
//  <td>Returns exponent of the numeric value</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>abs(val1)</code></td>
//  <td>Returns the absolute value of the numeric value</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>power(val1,val2)</code></td>
//  <td>Returns val1 raised to the power of val2</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>asin(val1)</code></td>
//  <td>Returns arcsin or inverse sine of the number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>acos(val1)</code></td>
//  <td>Returns arccos or inverse cosine of the number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>atan(val1)</code></td>
//  <td>Returns arctan or inverse tangent of the number</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>atan2(val1,val2)</code></td>
//  <td>Returns two argument arctan</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>random()</code></td>
//  <td>Returns a random float value from 0 through 1, exclusive</td>
//  <td>N <i>[available as <code>rand()</code>]</i></td>
//  <td>Y</td>
//  <td>N <i>[available as <code>rand()</code>]</i></td>
//  <td>N <i>[Note: Instead of a float between 0 and 1, SQLite's random function returns pseudo-random integer between -9223372036854775808 and +9223372036854775807]</i></td>
// </tr>
// <tr>
//  <td><code>rand()</code></td>
//  <td>Returns a random float value from 0 through 1, exclusive</td>
//  <td>Y</td>
//  <td>N [available as <code>random()</code>]</td>
//  <td>Y</td>
//  <td>N</td>
// </tr>
// <tr>
//  <th colspan="6">String functions</th>
// </tr>
// <tr>
//  <td><code>concat(val1,val2,...)</code></td>
//  <td>Join multiple values together as a string</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>substring(val,start,length)</code></td>
//  <td>Returns a substring from a value</td>
//  <td>Y</td>
//  <td>N <i>[available as <code>substr()</code>]</i></td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>substr(val,start,length)</code></td>
//  <td>Returns a substring from a value</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N <i>[available as <code>substring()</code>]</i></td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>trim(value)</code></td>
//  <td>Removes leading and trailing space characters from a string</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>length(value)</code></td>
//  <td>Returns the length of a string value</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>N <i>[available as <code>len()</code>]</i></td>
//  <td>Y</td>
// </tr>
// <tr>
//  <td><code>len(value)</code></td>
//  <td>Returns the length of a string value</td>
//  <td>N <i>[available as <code>length()</code>]</i></td>
//  <td>N <i>[available as <code>length()</code>]</i></td>
//  <td>Y</td>
//  <td>N <i>[available as <code>length()</code>]</i></td>
// </tr>
// <tr>
//  <td><code>replace(value,fromText,toText)</code></td>
//  <td>Replaces all occurences of <code>fromText</code> with <code>toText</code></td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
//  <td>Y</td>
// </tr>
// </table>
// 
// @treeLocation Client Reference/Data Binding
// @title DataSourceField formula functions
// @visibility external
//<


// The following additional functions are available for DataSourceField functions
// but should not be documented for component-level formulae offered
// through the Formula builder


// Additional Math / Numeric functions
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "ceiling",
        description: "Round a value up",
        usage: "ceiling(value)",
        jsFunction: function (value) {
            // synonym for ceil
            return Math.ceil(value);
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "mod",
        description: "Returns the modulus of two numbers",
        usage: "mod(val1,val2)",
        jsFunction: function (val1,val2) {
            return val1 % val2;
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "greatest",
        description: "Returns the maximum of a series of numeric value",
        usage: "greatest(val1,val2,...)",
        jsFunction: function (...args) {
            return Math.max(...args);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "least",
        description: "Returns the minimum of a series of numeric value",
        usage: "least(val1,val2,...)",
        jsFunction: function (...args) {
            return Math.min(...args);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "log10",
        description: "Returns the base-10 log of the numeric value",
        usage: "log10(value)",
        jsFunction: function (value) {
            return Math.log10(value);
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "power",
        description: "Value1 to the power of Value2",
        usage: "power(value1, value2)",
        // synonym for "pow()"
        jsFunction: function (value1, value2) {
            return Math.pow(value1, value2);
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "rand",
        description: "Random number between 0 and 1",
        usage: "rand()",
        // synonym for "random()"
        jsFunction: function () {
            return Math.random();
        }
    })
);

// String functions
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "concat",
        description: "Join multiple string values together",
        usage: "concat(value1, value2)",
        jsFunction: function (/* ...values */) {
            return Array.prototype.join.call(arguments, "");
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "substring",
        description: "Return a substring from a value",
        usage: "substring(value, start, length)",
        jsFunction: function (value, start, length) {
            
            if (start != null) {
                if (start > 0) start-=1;
                else {
                    isc.logWarn("Formula function 'substring' passed start position of:" 
                        + start + " - note that this method expects 1-based numbering, not zero-based numbering");
                }
            }
            var end = (start == null || length == null) ? undefined : (start+length)
            return (value + "").substring(start,end);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "substr",
        description: "Return a substring from a value",
        usage: "substr(value, start, length)",
        jsFunction: function (value, start, length) {
            var end = (start == null || length == null) ? undefined : (start+length)
            if (value == null) value = "";
            return (value + "").substring(start,end);
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "trim",
        description: "Remove leading and trailing whitespace from a string",
        usage: "trim(value)",
        
        jsFunction: function (value) {
            if (value == null) value = "";
            return (value + "").trim();
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "length",
        description: "Returns the length of a string value",
        usage: "length(value)",
        
        jsFunction: function (value) {
            if (value == null) value = "";
            return (value + "").length;
        }
    })
);
isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "len",
        description: "Returns the length of a string value",
        usage: "len(value)",
        // synonym of length()
        jsFunction: function (value) {
            if (value == null) value = "";
            return (value + "").length;
        }
    })
);

isc.MathFunction.registerFunction(
    isc.MathFunction.create({
        name: "replace",
        description: "Replaces all occurences of fromText with toText",
        usage: "replace(value,fromText,toText)",
        jsFunction: function (value,fromText,toText) {
            if (value == null) value = "";
            return (value + "").replaceAll(fromText,toText);
        }
    })
);