/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-01-27/LGPL Deployment (2026-01-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
isc.defineClass("FieldGeneratorRegistry");
isc.FieldGeneratorRegistry.addClassProperties({

    _registry: {
        userFormula: {
            ID: "userFormula",

            getValues : function (field, records, context) {
                var component = context.component,
                    storagePropertyNameByFieldName = component._getStoragePropertyNameByFieldNameMap();

                // Mask out fields to be excluded, if any.
                
                records = isc.FieldGeneratorUtil._getMaskedRecords(records, context.excludeFieldNames,
                        storagePropertyNameByFieldName);

                // We inline a simplified implementation of DBC.getFormulaFieldValue() here
                // to avoid checking each record to see if the value is cached (none of the
                // values will be current), and also to avoid setting the "_cache_" flag on
                // the records (which, if `excludeFieldNames` is provided, is wasted work
                // because the records are copies without the excluded properties).

                var values = new Array(records.length),
                    formulaFunction = component.getFormulaFunction(field);
                if (formulaFunction) {
                    if (isc.isA.ListGrid(component) && !component.shouldApplyUserFormulaAfterSummary(field)) {
                        var groupSummaryRecordProperty = component.groupSummaryRecordProperty,
                            gridSummaryRecordProperty = component.gridSummaryRecordProperty;
                        for (var r = 0; r < records.length; ++r) {
                            var record = records[r];
                            // Because shouldApplyUserFormulaAfterSummary() is false, if the
                            // record is a group/grid summary record, then we're not supposed
                            // to apply the user formula to the summary record.
                            if (record[groupSummaryRecordProperty] || record[gridSummaryRecordProperty]) {
                                values[r] = record[field.name];

                            } else if (!component._shouldSkipGeneratingRecord(record)) {
                                values[r] = formulaFunction(record, component);
                            }
                        }
                    } else {
                        for (var r = 0; r < records.length; ++r) {
                            var record = records[r];
                            if (component._shouldSkipGeneratingRecord(record)) continue;
                            values[r] = formulaFunction(record, component);
                        }
                    }
                }
                return values;
            },

            getDependencies : function (field, component) {
                var userFormula = field.userFormula;
                if (userFormula && isc.FormulaBuilder) {
                    var formula = userFormula.text,
                        fieldDetails = isc.FormulaBuilder.getFieldDetailsFromValue(formula,
                                                                                   userFormula.formulaVars,
                                                                                   component.getAllFields() || [],
                                                                                   component,
                                                                                   userFormula.allowEscapedKeys);
                    return fieldDetails.usedFields.getProperty("name");
                }
            },

            settingFieldPropertyInvalidatesCache : function (field, component, propertyName, newValue) {
                if (propertyName == "userFormula") {
                    if (field.userFormula == null) return newValue != null;
                    else if (newValue == null) return true;
                    else {
                        isc.Class._assert(field.userFormula != null && newValue != null);
                        
                        return field.userFormula !== newValue;
                    }
                }
                return false;
            },

            controllingFieldProperties: ["userFormula"],

            clearCaches : function (field, component) {
                delete field._generatedFormulaFunc;
            }
        },

        userSummary: {
            ID: "userSummary",

            getValues : function (field, records, context) {
                var component = context.component,
                    storagePropertyNameByFieldName = component._getStoragePropertyNameByFieldNameMap();

                // Mask out fields to be excluded, if any.
                
                records = isc.FieldGeneratorUtil._getMaskedRecords(records, context.excludeFieldNames,
                        storagePropertyNameByFieldName);

                // We inline a simplified implementation of DBC.getSummaryFieldValue() here
                // to avoid checking each record to see if the value is cached (none of the
                // values will be current), and also to avoid setting the "_cache_" flag on
                // the records (which, if `excludeFieldNames` is provided, is wasted work
                // because the records are copies without the excluded properties).

                var values = new Array(records.length),
                    summaryFunction = component.getSummaryFunction(field);
                if (summaryFunction) {
                    var fieldName = field.name;
                    for (var r = 0; r < records.length; ++r) {
                        var record = records[r];
                        if (component._shouldSkipGeneratingRecord(record)) continue;
                        values[r] = summaryFunction(record, fieldName, component);
                    }
                }
                return values;
            },

            getDependencies : function (field, component) {
                var userSummary = field.userSummary;
                if (userSummary && isc.SummaryBuilder) {
                    var format = userSummary.text,
                        fieldDetails = isc.SummaryBuilder.getFieldDetailsFromValue(format,
                                                                                   userSummary.summaryVars,
                                                                                   component.getAllFields() || [],
                                                                                   component,
                                                                                   userSummary.allowBasicMultiCharKeys);
                    return fieldDetails.usedFields.getProperty("name");
                }
            },

            settingFieldPropertyInvalidatesCache : function (field, component, propertyName, newValue) {
                if (propertyName == "userSummary") {
                    if (field.userSummary == null) return newValue != null;
                    else if (newValue == null) return true;
                    else {
                        isc.Class._assert(field.userSummary != null && newValue != null);
                        
                        return field.userSummary !== newValue;
                    }
                }
                return false;
            },

            controllingFieldProperties: ["userSummary"],

            clearCaches : function (field, component) {
                delete field._generatedSummaryFunc;
            }
        },

        recordSummary: {
            ID: "recordSummary",

            getStoragePropertyName : function (summaryField, component) {
                if (component._getRecordSummaryAttributeProperty) {
                    return component._getRecordSummaryAttributeProperty(summaryField);
                }
                return summaryField.name;
            },

            getValues : function (summaryField, records, context) {
                var component = context.component,
                    excludeFieldNames = context.excludeFieldNames,
                    storagePropertyNameByFieldName = component._getStoragePropertyNameByFieldNameMap();

                // Mask out fields to be excluded, if any.
                records = isc.FieldGeneratorUtil._getMaskedRecords(records, excludeFieldNames,
                        storagePropertyNameByFieldName);

                var values = new Array(records.length);
                if (summaryField.getRecordSummary) {
                    for (var r = 0; r < records.length; ++r) {
                        values[r] = summaryField.getRecordSummary(records[r], summaryField, component);
                    }
                } else {
                    var summaryFunction = summaryField.recordSummaryFunction,
                        fields = component.getActiveFields(),
                        dependencies = isc.DS.getRecordSummaryFunctionDependencies(summaryFunction,
                                                fields, summaryField, component),
                        fieldNamesToInclude;
                    if (!dependencies) {
                        // If we don't have dependency information, then default to the original
                        // way of determining which fields to give to the record summary function.
                        fieldNamesToInclude = isc.DS._originalGetRecordSummaryFunctionFieldNamesToInclude(fields, summaryField, component);
                    } else {
                        fieldNamesToInclude = dependencies;
                    }

                    if (excludeFieldNames && !excludeFieldNames.isEmpty()) {
                        // The list returned by a GetRecordSummaryFunctionDependencies impl.
                        // is read-only, so we'll make a copy.
                        fieldNamesToInclude = fieldNamesToInclude.duplicate();
                        fieldNamesToInclude.removeList(excludeFieldNames);
                    }

                    var fieldsToInclude = fieldNamesToInclude.map(component.getFieldByName, component);
                    for (var r = 0; r < records.length; ++r) {
                        var record = records[r];
                        values[r] = isc.DS.applyRecordSummaryFunction(summaryFunction,
                                            record, fieldsToInclude, summaryField,
                                            component, storagePropertyNameByFieldName);
                    }
                }
                return values;
            },

            
            __getDependencies : function (summaryField, component, fields) {
                if (summaryField.getRecordSummary) {
                    if (summaryField.getRecordSummaryDependencies) {
                        return summaryField.getRecordSummaryDependencies(fields, summaryField);
                    } 
                } else {
                    var summaryFunction = summaryField.recordSummaryFunction;
                    return isc.DS.getRecordSummaryFunctionDependencies(summaryFunction, fields, summaryField, component);
                }
            },
            getDependencies : function (summaryField, component) {
                return this.__getDependencies(summaryField, component, component.getActiveFields() || isc._emptyArray);
            },

            settingActiveFieldsInvalidatesCache : function (summaryField, component, oldActiveFields, newActiveFields) {
                var oldDependencies = this.__getDependencies(summaryField, component, oldActiveFields || isc._emptyArray),
                    newDependencies = this.__getDependencies(summaryField, component, newActiveFields || isc._emptyArray);
                return !oldDependencies || !newDependencies || !oldDependencies.equals(newDependencies);
            },

            controllingFieldProperties: ["partialSummary", "recordSummaryFunction"]
        }
    },

    //>DEBUG
    init : function () {
        this.Super("init", arguments);

        // Validate consistency of built-in FieldGenerator impls.
        var registry = this._registry;
        for (var fieldGeneratorId in registry) {
            var fieldGenerator = registry[fieldGeneratorId];
            this._assert(fieldGenerator && fieldGenerator.ID == fieldGeneratorId);
        }
    },
    //<DEBUG

    
    register : function (fieldGenerator) {
        if (!this.initialized()) this.init();

        if (!fieldGenerator || !isc.isA.nonemptyString(fieldGenerator.ID)) {
            this.logError("Attempted to add null field generator, or a field generator with no ID", "fieldGeneration");
            return;
        }

        var registry = this._registry;

        // Check whether the impl is identical, and return early if so.
        
        if (registry[fieldGenerator.ID] === fieldGenerator) return;

        if (fieldGenerator.ID == "userFormula" ||
            fieldGenerator.ID == "userSummary" ||
            fieldGenerator.ID == "recordSummary")
        {
            this.logError("ID '" + fieldGenerator.ID + "' is reserved and may not be used.", "fieldGeneration");
            return;
        }

        if (!(fieldGenerator.getValue || fieldGenerator.getValues || fieldGenerator.generateValues || fieldGenerator.asyncGenerateValues)) {
            this.logError("The field generator implementation must implement at least one of getValue(), getValues(), generateValues(), or asyncGenerateValues().", "fieldGeneration");
            return;
        }

        if (fieldGenerator.ID in registry) {
            this.logWarn("Attempted to add existing field generator " + fieldGenerator.ID + " - replacing", "fieldGeneration");
        }

        registry[fieldGenerator.ID] = fieldGenerator;
    },

    
    get : function (fieldGeneratorId) {
        if (!this.initialized()) this.init();
        if (!isc.isA.nonemptyString(fieldGeneratorId)) return;
        return this._registry[fieldGeneratorId];
    }
});





isc.defineClass("PseudoFieldGeneratorRegistry").addClassProperties({
    _isHilitedPseudoFieldGeneratorImpl: {
        type: "isHilited",

        asyncGenerateValues : function (pseudoFieldInfo, records, context) {
            
        }
    },

    _generationStrategyByType: {
        hover: "lazy",
        isHilited: "eager"
    },

    
    getGenerationStrategy : function (type) {
        return this._generationStrategyByType[type];
    },

    _registryByType: {
        hover: {}
    },

    
    register : function (pseudoFieldGenerator) {
        var type;
        if (!pseudoFieldGenerator ||
            !isc.isA.nonemptyString(type = pseudoFieldGenerator.type))
        {
            this.logError("Attempted to add null pseudo-field generator, or a pseudo-field generator with no type", "fieldGeneration");
            return;
        }

        if (type == "isHilited" && this._isHilitedPseudoFieldGeneratorImpl === pseudoFieldGenerator) return;

        var pseudoFieldGeneratorId = pseudoFieldGenerator.ID;
        if (!isc.isA.nonemptyString(pseudoFieldGeneratorId)) {
            this.logError("Attempted to add a pseudo-field generator for the '" + type + "' type with no ID", "fieldGeneration");
            return;
        }

        var registry = this._registryByType[type];
        if (!registry) {
            this.logError("Cannot register pseudo-field generators for the '" + type + "' type.");
            return;
        }

        if (registry[pseudoFieldGeneratorId] === pseudoFieldGenerator) return;

        if (pseudoFieldGeneratorId in registry) {
            this.logWarn("Attempted to add existing '" + type + "'-type pseudo-field generator " + pseudoFieldGeneratorId + " - replacing", "fieldGeneration");
        }

        registry[pseudoFieldGeneratorId] = pseudoFieldGenerator;
    },

    
    get : function (type, pseudoFieldGeneratorId) {
        if (type == "isHilited") return this._isHilitedPseudoFieldGeneratorImpl;
        if (!isc.isA.nonemptyString(type) || !isc.isA.nonemptyString(pseudoFieldGeneratorId)) return;
        var registry = this._registryByType[type];
        return registry && registry[pseudoFieldGeneratorId];
    },

    getForPseudoField : function (pseudoFieldInfo) {
        return this.get(pseudoFieldInfo.type, pseudoFieldInfo.pseudoFieldGeneratorId);
    }
});



isc.defineClass("PseudoFieldGeneratorUtil").addClassProperties({
    __getDependencies : function (pseudoFieldGenerator, pseudoFieldInfo, component) {
        return pseudoFieldGenerator.getDependencies && pseudoFieldGenerator.getDependencies(pseudoFieldInfo, component);
    },

    // @classMethod PseudoFieldGeneratorUtil._getDependencies()
    _getDependencies : function (pseudoFieldGenerator, pseudoFieldInfo, component, allFieldNames) {
        var dependencies = this.__getDependencies(pseudoFieldGenerator, pseudoFieldInfo, component);
        if (dependencies != null) {
            //>DEBUG
            for (var d = 0; d < dependencies.length; ++d) {
                var dep = dependencies[d];
                if (!isc.isA.nonemptyString(dep)) {
                    component.logWarn("Pseudo-field generator '" + pseudoFieldGenerator.ID + "' for the '" + pseudoFieldGenerator.type + "' identified a dependency that is not a non-empty string.", "fieldGeneration");
                } else if (!component.getUnderlyingField(dep)) {
                    component.logWarn("Pseudo-field generator '" + pseudoFieldGenerator.ID + "' for the '" + pseudoFieldGenerator.type + "' identified a non-field dependency: '" + dep + "'", "fieldGeneration");
                }
            }
            //<DEBUG

            // Remove nulls, duplicate dependencies, and dependencies that are not actually
            // names of fields of the component.
            dependencies = allFieldNames.intersect(dependencies);
        } else {
            dependencies = allFieldNames.duplicate();
        }
        return dependencies;
    },


    __getAllNamedFields : function (component, __allFields) {
        var allFields = __allFields || component.getAllFields();
        if (!allFields) return null;
        return allFields.filter(function (field) {
            return isc.isAn.Object(field) && isc.isA.nonemptyString(field.name);
        });
    },

    // PseudoFieldGeneratorUtil.__getOrCreateFieldCC()
    __getOrCreateFieldCC : function (field, componentId) {
        var fieldCCPropertyName = "_cancellationController_" + componentId,
            fieldCC = field[fieldCCPropertyName];
        if (!fieldCC || fieldCC.canceled) {
            fieldCC = field[fieldCCPropertyName] = isc.CancellationController.create();
        }
        return fieldCC;
    },

    // Returns the current asyncNonSuccessInfo for the specified field/pseudo-field of the record,
    // or asyncNonSuccessInfo derived from any dependency with current asyncNonSuccessInfo.
    __getAsyncNonSuccessInfo : function (component, cacheOrdinal, name, recordInvalidationTime,
            asyncObj, asyncNonSuccessObj, dependencies, skipInvalidationChecks)
    {
        if (skipInvalidationChecks != true) {
            var asyncInfo = asyncObj && asyncObj[name];
            if (isc.isAn.Object(asyncInfo) && asyncInfo._cacheOrdinal == cacheOrdinal) {
                
                if ((recordInvalidationTime != null && recordInvalidationTime > asyncInfo._startTime) ||
                    (asyncInfo._invalidationTime != null && asyncInfo._invalidationTime > asyncInfo._startTime))
                {
                    var minErrorTime;
                    if (recordInvalidationTime != null) {
                        if (asyncInfo._invalidationTime != null) {
                            minErrorTime = Math.min(recordInvalidationTime, asyncInfo._invalidationTime);
                        } else {
                            minErrorTime = recordInvalidationTime;
                        }
                    } else {
                        this._assert(asyncInfo._invalidationTime != null);
                        minErrorTime = asyncInfo._invalidationTime;
                    }
                    return {
                        _cacheOrdinal: cacheOrdinal,
                        _type: "canceled",
                        _message: "The value being generated was cleared from the cache.",
                        _errorTime: minErrorTime
                    };
                }
            }
        }

        var asyncNonSuccessInfo = asyncNonSuccessObj && asyncNonSuccessObj[name];
        if (isc.isAn.Object(asyncNonSuccessInfo) && asyncNonSuccessInfo._cacheOrdinal == cacheOrdinal) return asyncNonSuccessInfo;

        for (var d = 0; d < dependencies.length; ++d) {
            var dep = dependencies[d];

            if (skipInvalidationChecks != true) {
                var asyncInfo = asyncObj && asyncObj[dep];
                if (isc.isAn.Object(asyncInfo) && asyncInfo._cacheOrdinal == cacheOrdinal) {
                    
                    if (asyncInfo._invalidationTime != null && asyncInfo._invalidationTime > asyncInfo._startTime) {
                        return {
                            _cacheOrdinal: cacheOrdinal,
                            _type: "canceled",
                            
                            _message: "A dependency (the value generated or being generated for the '" +
                                      dep + "' field) was cleared from the cache.",
                            _errorTime: asyncInfo._invalidationTime
                        };
                    }
                }
            }

            asyncNonSuccessInfo = asyncNonSuccessObj && asyncNonSuccessObj[dep];
            if (isc.isAn.Object(asyncNonSuccessInfo) && asyncNonSuccessInfo._cacheOrdinal == cacheOrdinal) {
                return {
                    _cacheOrdinal: cacheOrdinal,
                    _type: asyncNonSuccessInfo._type,
                    _message: "A dependency (the value of the '" + dep + "' field) was not successfully generated: " + asyncNonSuccessInfo._message,
                    _errorTime: asyncNonSuccessInfo._errorTime || component.ns.EH._getLastUniqueTimeStamp()
                };
            }
        }
    },

    
    __makeSharedAsyncNonSuccessInfo : function (EH, cacheOrdinal, nonSuccessfulResult) {
        //>DEBUG
        this._assert(nonSuccessfulResult.type != "success");
        //<DEBUG
        return {
            _cacheOrdinal: cacheOrdinal,
            _type: nonSuccessfulResult.type,
            _message: isc.AsyncUtil.getRawMessage(nonSuccessfulResult),
            _errorTime: EH._getLastUniqueTimeStamp()
            
        };
    },

    _getPseudoName : function (pseudoFieldInfo) {
        return "_pseudoField_" + pseudoFieldInfo.type + ":" + pseudoFieldInfo.name;
    },

    __hasRetryDelayElapsed : function (component, asyncNonSuccessInfo, retryDelay) {
        
        return retryDelay != null && asyncNonSuccessInfo._errorTime != null &&
               (component.ns.EH._getThreadTimeStamp() - asyncNonSuccessInfo._errorTime) > retryDelay;
    },

    __shouldRetry : function (component, asyncNonSuccessInfo, retryDelay) {
        return asyncNonSuccessInfo._type == "canceled" ||
               asyncNonSuccessInfo._type == "deferred" ||
               this.__hasRetryDelayElapsed(component, asyncNonSuccessInfo, retryDelay);
    },

    __isAsyncNonSuccessInfoCurrent : function (component, asyncNonSuccessInfo, retryDelay) {
        
        if (component._isCacheInfoCurrent(asyncNonSuccessInfo)) {
            var shouldRetry = this.__shouldRetry(component, asyncNonSuccessInfo, retryDelay);
            return !shouldRetry;
        }
        return false;
    },

    
    __isValueUntouched : function (record, name, component, cacheObjKey, asyncObjKey, asyncNonSuccessObjKey, retryDelay) {
        if (!record || record == Array.LOADING) return false;

        if (component._shouldSkipGeneratingRecord(record)) return false;

        // If the value is current, we don't need to regenerate it.
        var cacheObj = record[cacheObjKey];
        if (cacheObj && component._isCacheInfoCurrent(cacheObj[name])) return false;

        // If there is a pending, non-invalidated asynchronous operation to generate its current
        // value, then don't start a new one.
        var asyncObj = record[asyncObjKey];
        if (asyncObj && component._isAsyncInfoCurrent(record, asyncObj[name])) return false;

        // If there is current asyncNonSuccessInfo, then skip the record unless the non-successful
        // generation is re-triable.
        var asyncNonSuccessObj = record[asyncNonSuccessObjKey],
            asyncNonSuccessInfo = asyncNonSuccessObj && asyncNonSuccessObj[name];
        if (isc.isAn.Object(asyncNonSuccessInfo) && this.__isAsyncNonSuccessInfoCurrent(component,
                    asyncNonSuccessInfo, retryDelay))
        {
            return false;
        }

        return true;
    },

    // Adds to `names` the pseudo-names of pseudo-fields of `component` that are dependent on
    // any of the fields in `fields`.
    _augmentNamesWithDependentPseudoNames : function (component, fields, names) {
        var pseudoFieldInfos = component._getPseudoFieldInfos();
        // _getPseudoFieldInfos() can return `null`, so guard against that.
        var numPseudoFieldInfos = !pseudoFieldInfos ? 0 : pseudoFieldInfos.length;
        pseudoFieldsLoop: for (var pf = 0; pf < numPseudoFieldInfos; ++pf) {
            var pseudoFieldInfo = pseudoFieldInfos[pf],
                pseudoFieldGenerator = isc.PseudoFieldGeneratorRegistry.getForPseudoField(pseudoFieldInfo),
                deps = this._getDependencies(pseudoFieldGenerator, pseudoFieldInfo, component);
            if (deps == null) {
                names.push(this._getPseudoName(pseudoFieldInfo));
                continue pseudoFieldsLoop;
            }
            for (var d = 0; d < deps.length; ++d) {
                var dep = deps[d],
                    depField = component.getUnderlyingField(dep);
                if (fields.contains(depField)) {
                    names.push(this._getPseudoName(pseudoFieldInfo));
                    continue pseudoFieldsLoop;
                }
            }
        }
    }
});

isc.defineClass("EagerPseudoFieldGeneratorUtil", isc.PseudoFieldGeneratorUtil).addClassProperties({
    // Wrapper for an EagerPseudoFieldGenerator implementation's generateValues()/asyncGenerateValues().
    // If the Promise-based asyncGenerateValues() is available, then that will be called; otherwise,
    // the callback-based generateValues() will be called.
    _asyncGenerateValues : function (pseudoFieldGenerator, pseudoFieldInfo, records, context) {
        var givenCC = context.cancellationController;
        if (givenCC && givenCC.canceled) {
            return Promise.reject(givenCC.asCanceledResult());
        }

        if (pseudoFieldGenerator.asyncGenerateValues) {
            try {
                return pseudoFieldGenerator.asyncGenerateValues(pseudoFieldInfo, records, context)
                    //>DEBUG
                    // In debug builds we'll do some basic checks to make sure that things look right.
                    .then(function (result) {
                        if (givenCC && givenCC.canceled) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() should have rejected because the CancellationController was canceled.",
                                erroneousResult: result
                            });
                        } else if (!result || result.type != "success") {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() did not fulfill with an AsyncMultipleValuesGenerationResult having type:\"success\".",
                                erroneousResult: result
                            });
                        } else if (!isc.isAn.Array(result.generatedValues) || result.generatedValues.length != records.length) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "`result.generatedValues` either wasn't an array, or its length was not equal to `records.length`.",
                                erroneousResult: result
                            });
                        }
                        return result;
                    }, function (nonSuccessfulResult) {
                        if (givenCC && givenCC.canceled && (!nonSuccessfulResult || nonSuccessfulResult.type != "canceled")) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() did not reject with a type:\"canceled\" result.",
                                erroneousResult: nonSuccessfulResult
                            });
                        } else if (!nonSuccessfulResult) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() did not reject with a non-successful AsyncMultipleValuesGenerationResult.",
                                erroneousResult: nonSuccessfulResult
                            });
                        } else if (nonSuccessfulResult.type == "success") {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() rejected with an AsyncMultipleValuesGenerationResult having type:\"success\".",
                                erroneousResult: nonSuccessfulResult
                            });
                        }
                        return Promise.reject(nonSuccessfulResult);
                    })
                    //<DEBUG
                    ;
            } catch (e) {
                return Promise.reject(isc.defaultAsyncOperationCatchCallback(e));
            }
        }

        var resolversObj = Promise.withResolvers();
        try {
            pseudoFieldGenerator.generateValues(pseudoFieldInfo, records, context, function (result) {
                if (givenCC && givenCC.canceled && (!result || result.type != "canceled")) {
                    resolversObj.reject(givenCC.asCanceledResult({originalResult: result}));
                } else if (!result || result.type != "success") {
                    resolversObj.reject(isc.defaultAsyncOperationCatchCallback(result));
                } else if (!isc.isAn.Array(result.generatedValues) || result.generatedValues.length != records.length) {
                    resolversObj.reject({
                        type: "error",
                        errorMessage: "`result.generatedValues` either wasn't an array, or its length was not equal to `records.length`.",
                        erroneousResult: result
                    });
                } else {
                    resolversObj.resolve(result);
                }
            });
        } catch (e) {
            resolversObj.reject(isc.defaultAsyncOperationCatchCallback(e));
        }
        return resolversObj.promise;
    },

    // @classMethod EagerPseudoFieldGeneratorUtil._asyncGenerateMissingPseudoFieldValues()
    _asyncGenerateMissingPseudoFieldValues : function (generateMissingValuesContext, dabOpContext, pseudoFieldInfo) {
        var givenCC = dabOpContext.cancellationController,
            component = generateMissingValuesContext.component,
            componentId = component.getID(),
            recordInvalidationTimeKey = "_recordInvalidationTime_" + componentId,
            cacheObjKey = "_cache_" + componentId,
            asyncObjKey = "_async_" + componentId,
            asyncNonSuccessObjKey = "_asyncNonSuccess_" + componentId,
            cacheOrdinal = generateMissingValuesContext._cacheOrdinal,
            EH = component.ns.EH,
            startTime = generateMissingValuesContext.startTime,
            origRecords = generateMissingValuesContext.origRecords,
            pseudoName = this._getPseudoName(pseudoFieldInfo),
            pseudoFieldGenerator = isc.PseudoFieldGeneratorRegistry.getForPseudoField(pseudoFieldInfo),
            dependencies = generateMissingValuesContext.dependenciesByName[pseudoName],
            untouchedRecords = generateMissingValuesContext.untouchedRecordsByName[pseudoName],
            isAsyncByName = generateMissingValuesContext.isAsyncByName,
            resultByName = generateMissingValuesContext.resultByName;

        this._assert(isc.PseudoFieldGeneratorRegistry.getGenerationStrategy(pseudoFieldGenerator.type) == "eager");
        this._assert(!untouchedRecords.isEmpty());

        var nonSuccessfulResultAtOutset = resultByName[pseudoName],
            sharedAsyncNonSuccessInfo;
        if (nonSuccessfulResultAtOutset) {
            
            sharedAsyncNonSuccessInfo = this.__makeSharedAsyncNonSuccessInfo(EH, cacheOrdinal, nonSuccessfulResultAtOutset);
        }

        var prereqPromises = [],
            depFieldCCs = new Array(dependencies.length + 1); // the +1 is for `givenCC`, which we want to put at index 0
        for (var d = 0; d < dependencies.length; ++d) {
            var dep = dependencies[d],
                depResult = resultByName[dep];

            // Check for failures of synchronously-generated dependencies. If there are any,
            // then generation of the field fails as well.
            if (!nonSuccessfulResultAtOutset && isAsyncByName[dep] == false && depResult && depResult.type != "success") {
                nonSuccessfulResultAtOutset = {
                    type: "error",
                    errorMessage: "A dependency (the value of the '" + dep + "' field) was not successfully generated: " + isc.AsyncUtil.getRawMessage(depResult),
                    dependencyResult: depResult
                };
                sharedAsyncNonSuccessInfo = this.__makeSharedAsyncNonSuccessInfo(EH, cacheOrdinal, nonSuccessfulResultAtOutset);
            }

            // There may also be values of the dependency field that are being (asynchronously)
            // generated. Our promise must wait on those.
            var depField = component.getSpecifiedField(dep),
                depPromises = this._getFieldGenPromises(component, depField, false, cacheOrdinal);
            if (depPromises) prereqPromises.addList(depPromises);

            depFieldCCs[1 + d] = this.__getOrCreateFieldCC(depField, componentId);
        }

        // Go through the untouched records and mark everything to be generated asynchronously
        // as pending async or async non-success if we already know that a dependency failed.
        for (var rr = untouchedRecords.length; rr > 0; --rr) {
            var r = rr - 1,
                record = untouchedRecords[r],
                asyncNonSuccessInfo = sharedAsyncNonSuccessInfo || this.__getAsyncNonSuccessInfo(component,
                        cacheOrdinal, pseudoName, record[recordInvalidationTimeKey], record[asyncObjKey],
                        record[asyncNonSuccessObjKey], dependencies,
                        // `skipInvalidationChecks` is `true` because we are being called
                        // to re-generate, so whether the value was invalidated is moot.
                        /* skipInvalidationChecks */ true);
            if (asyncNonSuccessInfo) {
                var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
                if (!asyncNonSuccessObj) asyncNonSuccessObj = record[asyncNonSuccessObjKey] = {};
                asyncNonSuccessObj[pseudoName] = asyncNonSuccessInfo;

                untouchedRecords.removeAt(r);
            } else {
                // Touching asyncInfo is effectively putting a "lock" on the responsibility for
                // asynchronously generating the value. We need to make sure that this "lock" is
                // released when we're done.
                var asyncObj = record[asyncObjKey];
                if (!asyncObj) asyncObj = record[asyncObjKey] = {};
                component._touchAsyncInfo(asyncObj, pseudoName, startTime);
            }
        }

        if (nonSuccessfulResultAtOutset) {
            return Promise.reject(nonSuccessfulResultAtOutset);
        } else if (untouchedRecords.isEmpty()) {
            return Promise.resolve({
                type: "success",
                generatedValues: []
            });
        }

        var cancellationControllers = depFieldCCs;
        cancellationControllers[0] = givenCC;

        // Add to `cancellationControllers` the cancellation controllers of any master field(s)
        // that are not dependencies. If a master field is removed, then we are no longer interested
        // in the pseudo-field generation result.
        if (isc.isAn.Array(pseudoFieldInfo.masterFieldName)) {
            var masterFieldNames = pseudoFieldInfo.masterFieldName;
            for (var m = 0; m < masterFieldNames.length; ++m) {
                var masterFieldName = masterFieldNames[m];
                if (!dependencies.contains(masterFieldName)) {
                    var masterField = component.getSpecifiedField(masterFieldName);
                    if (masterField) cancellationControllers.push(this.__getOrCreateFieldCC(masterField, componentId));
                }
            }
        } else if (isc.isA.nonemptyString(pseudoFieldInfo.masterFieldName)) {
            var masterFieldName = pseudoFieldInfo.masterFieldName;
            if (!dependencies.contains(masterFieldName)) {
                var masterField = component.getSpecifiedField(masterFieldName);
                if (masterField) cancellationControllers.push(this.__getOrCreateFieldCC(masterField, componentId));
            }
        }

        var ownCC = isc.CancellationController.createJointController(cancellationControllers);

        

        var handleBatchResult = EH._wrapCallback("HandleBatchResult", function (records, batchResult) {
            
            if (!batchResult.records) batchResult.records = records;
            else this._assert(batchResult.records === records);

            // If our generation efforts are no longer current, or `records` is empty, then return.
            // These are the only cases where we can return early, as we must otherwise ensure
            // that the asyncInfo "locks" are released.
            if (cacheOrdinal != component._cacheOrdinal || records.isEmpty()) return;

            var wasSuccessful = batchResult.type == "success",
                sharedAsyncNonSuccessInfo,
                generatedValues;

            if (!wasSuccessful) {
                // It's okay to share the same asyncNonSuccessInfo for all of the records that
                // are part of the batch because asyncNonSuccessInfos are immutable.
                sharedAsyncNonSuccessInfo = this.__makeSharedAsyncNonSuccessInfo(EH, cacheOrdinal, batchResult);
            } else {
                generatedValues = batchResult.generatedValues;
                this._assert(records.length == generatedValues.length);
            }

            for (var rr = records.length; rr > 0; --rr) {
                var r = rr - 1,
                    record = records[r],
                    asyncObj = record[asyncObjKey],
                    asyncInfo = asyncObj && asyncObj[pseudoName];

                // It could happen that the asyncInfo is no longer current. In such a case,
                // the asyncInfo "lock" has already been released or re-acquired by another
                // field gen. operation and we aren't responsible for the record's value for
                // the pseudo-field anymore.
                if (!asyncInfo || !component._isAsyncInfoCurrent(record, asyncInfo, /* specificStartTime */ startTime)) {
                    records.removeAt(r);
                    if (wasSuccessful) generatedValues.removeAt(r);
                    continue;
                }

                var asyncNonSuccessObj = record[asyncNonSuccessObjKey],
                    asyncNonSuccessInfo = sharedAsyncNonSuccessInfo || this.__getAsyncNonSuccessInfo(
                            component, cacheOrdinal, pseudoName, record[recordInvalidationTimeKey],
                            asyncObj, asyncNonSuccessObj, dependencies,
                            // Now `skipInvalidationChecks` is `false` because the value or
                            // dependencies' values could have been invalidated in the interim.
                            /* skipInvalidationChecks */ false);

                if (asyncNonSuccessInfo) {
                    if (!asyncNonSuccessObj) asyncNonSuccessObj = record[asyncNonSuccessObjKey] = {};
                    asyncNonSuccessObj[pseudoName] = asyncNonSuccessInfo;
                } else {
                    var cacheObj = record[cacheObjKey];
                    if (!cacheObj) cacheObj = record[cacheObjKey] = {};
                    cacheObj[pseudoName] = {
                        _cacheOrdinal: record._noCache ? 0 : cacheOrdinal,
                        _value: generatedValues[r]
                    };
                }

                // Release the asyncInfo "lock" on the (formerly) untouched record.
                delete asyncInfo._cacheOrdinal;
            }

            // Fire 'dataChanged' on `origRecords` unless the List does not have an _isChangingData()
            // method, or we're already in the middle of changing it.
            if (!origRecords._isChangingData || !origRecords._isChangingData()) origRecords.dataChanged("fieldGeneration");

            if (!component.destroyed) component._pseudoFieldGenerated(pseudoFieldInfo, records, batchResult);
        }, this);

        return Promise._whenAllSettled(prereqPromises, ownCC)
            .then(function (results) {
                // Note: _whenAllSettled() never rejects.

                if (component.destroyed && !ownCC.canceled) {
                    ownCC.cancel(componentId + " was destroyed.", "application");
                }

                // If canceled, we'll let the _whenSettled() block below handle this non-successful result.
                if (ownCC.canceled) return Promise.reject(ownCC.asCanceledResult());

                var erroredOutRecords = [];
                for (var rr = untouchedRecords.length; rr > 0; --rr) {
                    var r = rr - 1,
                        record = untouchedRecords[r];
                    if (isc.PseudoFieldGeneratorUtil.__getAsyncNonSuccessInfo(component,
                                cacheOrdinal, pseudoName, record[recordInvalidationTimeKey],
                                record[asyncObjKey], record[asyncNonSuccessObjKey],
                                dependencies, /* skipInvalidationChecks */ false))
                    {
                        erroredOutRecords.push(record);
                        untouchedRecords.removeAt(r);
                    }
                }
                if (!erroredOutRecords.isEmpty()) {
                    var syntheticResult = {
                        type: "error",
                        errorMessage: "The generation of all dependencies was not successful.",
                        records: erroredOutRecords
                    };
                    handleBatchResult(erroredOutRecords, syntheticResult);
                }

                var context = isc.addPropertiesWithAssign({}, dabOpContext, {
                    cancellationController: ownCC
                });
                return isc.EagerPseudoFieldGeneratorUtil._asyncGenerateValues(
                        pseudoFieldGenerator, pseudoFieldInfo, untouchedRecords, context);
            })
            ._whenSettled(function (result) {
                // Note: Because _whenAllSettled() rejects immediately upon cancellation, it is possible
                // that not all prerequisite Promises have finished yet, so the prerequisite values
                // might not have all of their cacheInfos/asyncInfos/asyncNonSuccessInfos for which
                // they are responsible in non-transitory states. We use the asyncInfo "locks" to
                // figure out what has been finished and what is still in progress.

                handleBatchResult(untouchedRecords, result);
            })
            ._finally(function () {
                ownCC.destroy();
                
            }, this, EH);

        
    }
});

isc.defineClass("LazyPseudoFieldGeneratorUtil", isc.PseudoFieldGeneratorUtil).addClassProperties({
    // Wrapper for a LazyPseudoFieldGenerator implementation's generateValue()/asyncGenerateValue().
    // If the Promise-based asyncGenerateValue() is available, then that will be called; otherwise,
    // the callback-based generateValue() will be called.
    _asyncGenerateValue : function (pseudoFieldGenerator, pseudoFieldInfo, record, context) {
        var givenCC = context.cancellationController;
        if (givenCC && givenCC.canceled) {
            return Promise.reject(givenCC.asCanceledResult());
        }

        if (pseudoFieldGenerator.asyncGenerateValue) {
            try {
                return pseudoFieldGenerator.asyncGenerateValue(pseudoFieldInfo, record, context)
                    //>DEBUG
                    // In debug builds we'll do some basic checks to make sure that things look right.
                    .then(function (result) {
                        if (givenCC && givenCC.canceled) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValue() should have rejected because the CancellationController was canceled.",
                                erroneousResult: result
                            });
                        } else if (!result || result.type != "success") {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValue() did not fulfill with an AsyncSingleValueGenerationResult having type:\"success\".",
                                erroneousResult: result
                            });
                        } else if (!("generatedValue" in result)) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "'generatedValue' was not a property of `result`.",
                                erroneousResult: result
                            });
                        }
                        return result;
                    }, function (nonSuccessfulResult) {
                        if (givenCC && givenCC.canceled && (!nonSuccessfulResult || nonSuccessfulResult.type != "canceled")) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValue() did not reject with a type:\"canceled\" result.",
                                erroneousResult: nonSuccessfulResult
                            });
                        } else if (!nonSuccessfulResult) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValue() did not reject with a non-successful AsyncSingleValueGenerationResult.",
                                erroneousResult: nonSuccessfulResult
                            });
                        } else if (nonSuccessfulResult.type == "success") {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValue() rejected with an AsyncSingleValueGenerationResult having type:\"success\".",
                                erroneousResult: nonSuccessfulResult
                            });
                        }
                        return Promise.reject(nonSuccessfulResult);
                    })
                    //<DEBUG
                    ;
            } catch (e) {
                return Promise.reject(isc.defaultAsyncOperationCatchCallback(e));
            }
        }

        var resolversObj = Promise.withResolvers();
        try {
            pseudoFieldGenerator.generateValue(pseudoFieldInfo, record, context, function (result) {
                if (givenCC && givenCC.canceled && (!result || result.type != "canceled")) {
                    resolversObj.reject(givenCC.asCanceledResult({originalResult: result}));
                } else if (!result || result.type != "success") {
                    resolversObj.reject(isc.defaultAsyncOperationCatchCallback(result));
                } else if (!("generatedValue" in result)) {
                    resolversObj.reject({
                        type: "error",
                        errorMessage: "'generatedValue' was not a property of `result`.",
                        erroneousResult: result
                    });
                } else {
                    resolversObj.resolve(result);
                }
            });
        } catch (e) {
            resolversObj.reject(isc.defaultAsyncOperationCatchCallback(e));
        }
        return resolversObj.promise;
    },

    _getRetryDelay : function (lazyPseudoFieldGenerator, pseudoFieldInfo, component) {
        this._assert(isc.PseudoFieldGeneratorRegistry.getGenerationStrategy(lazyPseudoFieldGenerator.type) == "lazy");
        if (lazyPseudoFieldGenerator.getRetryDelay) {
            return lazyPseudoFieldGenerator.getRetryDelay(pseudoFieldInfo, component);
        }
    },

    // @classMethod LazyPseudoFieldGeneratorUtil._doGenerateIfMissingValue()
    // @param component (DataBoundComponent) The component.
    // @param pseudoFieldInfo (PseudoFieldInfo) Information about the pseudo-field.
    // @param record (Record) The record.
    // @param [cancellationController] (CancellationController)
    _doGenerateIfMissingValue : function (component, pseudoFieldInfo, record, cancellationController) {
        var cacheOrdinal = component._cacheOrdinal,
            EH = component.ns.EH,
            startTime = EH._getUniqueTimeStamp(),
            pseudoFieldGenerator = isc.PseudoFieldGeneratorRegistry.getForPseudoField(pseudoFieldInfo),
            dependencies = null;
        this._assert(isc.PseudoFieldGeneratorRegistry.getGenerationStrategy(pseudoFieldGenerator.type) == "lazy");

        var generateMissingValueContext = {
            component: component,
            _cacheOrdinal: cacheOrdinal,
            startTime: startTime,
            pseudoFieldGenerator: pseudoFieldGenerator,
            dependencies: dependencies
        };

        if (component._shouldSkipGeneratingComponent) return generateMissingValueContext;

        var componentId = component.getID(),
            cacheObjKey = "_cache_" + componentId,
            asyncObjKey = "_async_" + componentId,
            asyncNonSuccessObjKey = "_asyncNonSuccess_" + componentId,
            pseudoName = this._getPseudoName(pseudoFieldInfo);

        if (!this.__isValueUntouched(record, pseudoName, component, cacheObjKey,
                    asyncObjKey, asyncNonSuccessObjKey, this._getRetryDelay(pseudoFieldGenerator, pseudoFieldInfo, component)))
        {
            return generateMissingValueContext;
        }

        // Because we are going to re-generate the value, clear any error that we received
        // last time.
        var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
        if (asyncNonSuccessObj) {
            
            delete asyncNonSuccessObj[pseudoName];
        }

        var allNamedFields = component.getAllNamedFields() || [],
            allFieldNames = allNamedFields.getProperty("name");

        dependencies = generateMissingValueContext.dependencies = this._getDependencies(
                pseudoFieldGenerator, pseudoFieldInfo, component, allFieldNames);

        var untouchedDepFields = [],
            prereqPromises = [],
            depFieldCCs = new Array(dependencies.length + 1); // the +1 is for the async data-bound operation CC
        for (var d = 0; d < dependencies.length; ++d) {
            var dep = dependencies[d],
                depField = component.getSpecifiedField(dep);
            if (!depField) continue;

            if (component._isFieldGenerated(depField)) {
                if (this.__isValueUntouched(record, dep, component, cacheObjKey, asyncObjKey,
                            asyncNonSuccessObjKey))
                {
                    untouchedDepFields.push(depField);
                } else {
                    // Check for an error in the dependency. If there is one, then this pseudo-field
                    // gen fails as well.
                    var asyncNonSuccessObj = record[asyncNonSuccessObjKey],
                        depAsyncNonSuccessInfo = asyncNonSuccessObj && asyncNonSuccessObj[dep];
                    if (isc.isAn.Object(depAsyncNonSuccessInfo) && depAsyncNonSuccessInfo._cacheOrdinal == cacheOrdinal) {
                        asyncNonSuccessObj[pseudoName] = {
                            _cacheOrdinal: cacheOrdinal,
                            _type: depAsyncNonSuccessInfo._type,
                            _message: "A dependency (the value of the '" + dep + "' field) was not successfully generated: " + depAsyncNonSuccessInfo._message,
                            _errorTime: depAsyncNonSuccessInfo._errorTime || EH._getLastUniqueTimeStamp()
                            
                        };
                        return generateMissingValueContext;
                    }

                    var depPromises = this._getFieldGenPromises(component, depField, false, cacheOrdinal);
                    if (depPromises) prereqPromises.addList(depPromises);
                }
            }

            depFieldCCs[1 + d] = this.__getOrCreateFieldCC(depField, componentId);
        }

        // Touching asyncInfo is effectively putting a "lock" on the responsibility for
        // asynchronously generating the value. We need to make sure that this "lock" is
        // released when we're done.
        var asyncObj = record[asyncObjKey];
        if (!asyncObj) asyncObj = record[asyncObjKey] = {};
        component._touchAsyncInfo(asyncObj, pseudoName, startTime);

        var generateMissingValuesContext;
        if (!untouchedDepFields.isEmpty()) {
            generateMissingValuesContext = isc.FieldGeneratorUtil._doGenerateIfMissingValues(
                    component, untouchedDepFields, [record], cancellationController);
            if (generateMissingValuesContext.promise) {
                prereqPromises.push(generateMissingValuesContext.promise);
            }
        }

        var dabOpParams = {
            cancellationController: cancellationController,
            component: component
        };
        isc.AsyncUtil.asyncDataBoundOperation(dabOpParams, function (dabOpContext) {
            // Note: Despite the callback that we're in, it's still the same thread as above
            // because asyncDataBoundOperation() fires the impl callback synchronously.

            var cancellationControllers = depFieldCCs;
            cancellationControllers[0] = dabOpContext.cancellationController;

            // Add to `cancellationControllers` the cancellation controllers of any master field(s)
            // that are not dependencies. If a master field is removed, then we are no longer interested
            // in the pseudo-field generation result.
            if (isc.isAn.Array(pseudoFieldInfo.masterFieldName)) {
                var masterFieldNames = pseudoFieldInfo.masterFieldName;
                for (var m = 0; m < masterFieldNames.length; ++m) {
                    var masterFieldName = masterFieldNames[m];
                    if (!dependencies.contains(masterFieldName)) {
                        var masterField = component.getSpecifiedField(masterFieldName);
                        if (masterField) cancellationControllers.push(this.__getOrCreateFieldCC(masterField, componentId));
                    }
                }
            } else if (isc.isA.nonemptyString(pseudoFieldInfo.masterFieldName)) {
                var masterFieldName = pseudoFieldInfo.masterFieldName;
                if (!dependencies.contains(masterFieldName)) {
                    var masterField = component.getSpecifiedField(masterFieldName);
                    if (masterField) cancellationControllers.push(this.__getOrCreateFieldCC(masterField, componentId));
                }
            }

            var ownCC = isc.CancellationController.createJointController(cancellationControllers);

            return Promise._whenAllSettled(prereqPromises, ownCC)
                .then(function (results) {
                    // Note: _whenAllSettled() never rejects.

                    // Check for failures of dependencies. If there are any, then generation
                    // of the pseudo-field fails as well.
                    if (generateMissingValuesContext) {
                        var resultByName = generateMissingValuesContext.resultByName;
                        for (var d = 0; d < dependencies.length; ++d) {
                            var dep = dependencies[d],
                                depResult = resultByName[dep];
                            if (depResult && depResult.type != "success") {
                                return Promise.reject({
                                    type: "error",
                                    errorMessage: "A dependency (the value of the '" + dep + "' field) was not successfully generated: " + isc.AsyncUtil.getRawMessage(depResult),
                                    dependencyResult: depResult
                                });
                            }
                        }
                    }

                    if (component.destroyed && !ownCC.canceled) {
                        ownCC.cancel(componentId + " was destroyed.", "application");
                    }

                    if (ownCC.canceled) return Promise.reject(ownCC.asCanceledResult());

                    dabOpContext = isc.addPropertiesWithAssign({}, dabOpContext, {
                        cancellationController: ownCC
                    });
                    return isc.LazyPseudoFieldGeneratorUtil._asyncGenerateValue(pseudoFieldGenerator,
                            pseudoFieldInfo, record, dabOpContext);
                })._whenSettled(EH._wrapCallback("PromiseSettled", function (result) {
                    // If our generation efforts are no longer current, then return.
                    // This is the only case where we can return early, as we must otherwise ensure
                    // that the asyncInfo "lock" is released.
                    var asyncObj = record[asyncObjKey];
                    if (cacheOrdinal != component._cacheOrdinal ||
                        !asyncObj || !component._isCacheInfoCurrent(asyncObj[pseudoName]))
                    {
                        return;
                    }

                    var wasSuccessful = result.type == "success",
                        asyncNonSuccessInfo;
                    if (!wasSuccessful) {
                        asyncNonSuccessInfo = {
                            _cacheOrdinal: cacheOrdinal,
                            _type: result.type,
                            _message: isc.getAsyncMessage(result),
                            _errorTime: EH._getLastUniqueTimeStamp()
                            
                        };
                    }

                    if (!wasSuccessful) {
                        var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
                        if (!asyncNonSuccessObj) asyncNonSuccessObj = record[asyncNonSuccessObjKey] = {};
                        asyncNonSuccessObj[pseudoName] = asyncNonSuccessInfo;
                    } else {
                        var cacheObj = record[cacheObjKey];
                        if (!cacheObj) cacheObj = record[cacheObjKey] = {};
                        cacheObj[pseudoName] = {
                            _cacheOrdinal: record._noCache ? 0 : cacheOrdinal,
                            _value: result.generatedValue
                        };
                    }

                    // Release the asyncInfo "lock".
                    component._invalidateCacheInfo(asyncObj, pseudoName);

                    if (!component.destroyed) component._pseudoFieldValueGenerated(pseudoFieldInfo, record, result);
                }))["finally"](function () {
                    ownCC.destroy();
                });
        });

        return generateMissingValueContext;
    }
});

isc.defineClass("HoverPseudoFieldGeneratorUtil", isc.LazyPseudoFieldGeneratorUtil).addClassProperties({
    _getPlaceholderHoverContents : function (hoverPseudoFieldGenerator, hoverPseudoFieldInfo, record, component) {
        var placeholderContents = hoverPseudoFieldGenerator.getPlaceholderHoverContents &&
                                  hoverPseudoFieldGenerator.getPlaceholderHoverContents(hoverPseudoFieldInfo, record, component);
        if (placeholderContents == null) {
            placeholderContents = component.placeholderGeneratedHoverContents;
        }
        return placeholderContents;
    },

    _formatHoverContents : function (hoverPseudoFieldGenerator, hoverPseudoFieldInfo, record, component, generatedContents) {
        if (hoverPseudoFieldGenerator.formatHoverContents) {
            return hoverPseudoFieldGenerator.formatHoverContents(hoverPseudoFieldInfo, record, component, generatedContents);
        }
        if (!generatedContents || !(generatedContents = String(generatedContents))) {
            generatedContents = component.emptyGeneratedHoverContents;
        }
        return generatedContents;
    },

    _getErrorHoverContents : function (hoverPseudoFieldGenerator, hoverPseudoFieldInfo, component, errorMessage) {
        if (hoverPseudoFieldGenerator.getErrorHoverContents) {
            return hoverPseudoFieldGenerator.getErrorHoverContents(hoverPseudoFieldInfo, component, errorMessage);
        }
        if (!errorMessage || !(errorMessage = String(errorMessage))) {
            return component.defaultGeneratedHoverAsyncErrorContents;
        }
        return errorMessage.asHTML();
    },

    _getErrorHoverProperties : function (hoverPseudoFieldGenerator, hoverPseudoFieldInfo, component) {
        if (hoverPseudoFieldGenerator.getErrorHoverProperties) {
            return hoverPseudoFieldGenerator.getErrorHoverProperties(hoverPseudoFieldInfo, component);
        }
        return component.asyncErrorHoverProperties;
    },


    _getHoverContents : function (component, hoverPseudoFieldInfo, record) {
        var hoverPseudoFieldGenerator = isc.PseudoFieldGeneratorRegistry.getForPseudoField(hoverPseudoFieldInfo),
            pseudoName = this._getPseudoName(hoverPseudoFieldInfo),
            componentId = component.getID(),
            asyncNonSuccessObj = record["_asyncNonSuccess_" + componentId];
        if (asyncNonSuccessObj) {
            var asyncNonSuccessInfo = asyncNonSuccessObj[pseudoName];
            if (isc.isAn.Object(asyncNonSuccessInfo) && component._isCacheInfoCurrent(asyncNonSuccessInfo) &&
                asyncNonSuccessInfo._type == "error")
            {
                return this._getErrorHoverContents(hoverPseudoFieldGenerator, hoverPseudoFieldInfo,
                        component, asyncNonSuccessInfo._message);
            }
        }

        var asyncObj = record["_async_" + componentId];
        if (asyncObj && component._isAsyncInfoCurrent(record, asyncObj[pseudoName])) {
            return this._getPlaceholderHoverContents(hoverPseudoFieldGenerator, hoverPseudoFieldInfo,
                    record, component);
        }

        var cacheObj = record["_cache_" + componentId],
            cacheInfo = cacheObj && cacheObj[pseudoName],
            isCacheInfoCurrent = isc.isAn.Object(cacheInfo) && component._isCacheInfoCurrent(cacheInfo),
            generatedContents = !isCacheInfoCurrent ? null : cacheInfo._value;
        return this._formatHoverContents(hoverPseudoFieldGenerator, hoverPseudoFieldInfo, record,
                component, generatedContents);
    },

    _getHoverProperties : function (component, hoverPseudoFieldInfo, record) {
        var hoverPseudoFieldGenerator = isc.PseudoFieldGeneratorRegistry.getForPseudoField(hoverPseudoFieldInfo),
            pseudoName = this._getPseudoName(hoverPseudoFieldInfo),
            componentId = component.getID(),
            asyncNonSuccessObj = record["_asyncNonSuccess_" + componentId];
        if (asyncNonSuccessObj) {
            var asyncNonSuccessInfo = asyncNonSuccessObj[pseudoName];
            if (isc.isAn.Object(asyncNonSuccessInfo) && component._isCacheInfoCurrent(asyncNonSuccessInfo) &&
                asyncNonSuccessInfo._type == "error")
            {
                return this._getErrorHoverProperties(hoverPseudoFieldGenerator, hoverPseudoFieldInfo, component);
            }
        }

        return null;
    }
});



isc.defineClass("FieldGeneratorUtil");
isc.FieldGeneratorUtil.addClassProperties({

    __shouldRetryFieldInit : function (initResult) {
        return initResult.type == "canceled" || initResult.type == "disabled";
    },

    __asyncInitField : function (fieldGenerator, field, component) {
        if (!fieldGenerator.asyncInitField) return null;

        var componentId = component.getID(),
            initFieldCCPropertyName = "_fieldGenInitFieldCC_" + componentId,
            initFieldCC = field[initFieldCCPropertyName],
            fieldCC = this.__getOrCreateFieldCC(field, componentId),
            synchronouslyInitializedPropertyName = "_fieldGenSynchronouslyInitialized_" + componentId;
        if (fieldCC === initFieldCC && field[synchronouslyInitializedPropertyName]) return null;
        else field[synchronouslyInitializedPropertyName] = false;

        var initResultPropertyName = "_fieldGenInitResult_" + componentId;
        

        var initPromisePropertyName = "_fieldGenInitPromise_" + componentId,
            initPromise = field[initPromisePropertyName];

        if (fieldCC !== initFieldCC || !initPromise) {
            initPromise = fieldGenerator.asyncInitField(field, component, {cancellationController: fieldCC});

            initFieldCC = field[initFieldCCPropertyName] = fieldCC;

            if (initPromise == null) {
                field[synchronouslyInitializedPropertyName] = true;
                field[initPromisePropertyName] = null;
                return null;
            }

            initPromise = initPromise
                ._whenSettled(function (initResult) {
                    if (isc.FieldGeneratorUtil.__getOrCreateFieldCC(field, componentId) === initFieldCC &&
                        field[initPromisePropertyName] === initPromise)
                    {
                        field[initPromisePropertyName] = null;
                        field[initResultPropertyName] = initResult;
                    }

                    return initResult;
                });

            field[initPromisePropertyName] = initPromise;
        }

        return initPromise;
    },

    __getCurrentNonRetriableInitResult : function (field, component) {
        var componentId = component.getID(),
            initFieldCCPropertyName = "_fieldGenInitFieldCC_" + componentId,
            initFieldCC = field[initFieldCCPropertyName],
            fieldCC = this.__getOrCreateFieldCC(field, componentId),
            initResultPropertyName = "_fieldGenInitResult_" + componentId,
            initResult = field[initResultPropertyName];
        if (fieldCC === initFieldCC && initResult && !this.__shouldRetryFieldInit(initResult)) {
            return initResult;
        }
    },

    
    _getStoragePropertyName : function (fieldGenerator, field, component) {
        var storagePropertyName = field.name;
        if (fieldGenerator) {
            if (fieldGenerator.getStoragePropertyName) {
                storagePropertyName = fieldGenerator.getStoragePropertyName(field, component);
            }

            
        }
        //>DEBUG
        this._assert(isc.isA.nonemptyString(storagePropertyName));
        //<DEBUG
        return storagePropertyName;
    },

    __getFieldGenPromisesPropertyName : function (component, field, cacheOrdinal) {
        var propertyName = "_fieldGenPromises" + cacheOrdinal;
        if (field) propertyName += "_" + component.getID();
        return propertyName;
    },

    
    _getFieldGenPromises : function (component, field, createIfAbsent, cacheOrdinal, __propertyName) {
        if (!__propertyName) __propertyName = this.__getFieldGenPromisesPropertyName(component, field, cacheOrdinal || component._cacheOrdinal);

        var promises;
        if (field) {
            promises = field[__propertyName];
            if (createIfAbsent && !promises) promises = field[__propertyName] = [];
        } else {
            promises = component[__propertyName];
            if (createIfAbsent && !promises) promises = component[__propertyName] = [];
        }
        return promises;
    },

    _removeFieldGenPromise : function (component, field, cacheOrdinal, promise) {
        this._assert(!!cacheOrdinal);
        var propertyName = this.__getFieldGenPromisesPropertyName(component, field, cacheOrdinal),
            promises = this._getFieldGenPromises(component, field, false, cacheOrdinal, propertyName);
        this._assert(!!promises);
        if (promise) {
            var wasRemoved = promises.remove(promise);
            this._assert(wasRemoved);
        }
        // To prevent a small memory leak of leaving around empty arrays of promises when the
        // cacheOrdinal is incremented, we'll delete the property if the array is empty.
        if (promises.isEmpty()) {
            if (field) delete field[propertyName];
            else delete component[propertyName];
        }
    },

    _willNeedAsync : function (generatedFields, fieldGeneratorByFieldName, untouchedRecordsByName,
                               fieldGenerator, field, records, component)
    {
        

        if ((fieldGenerator.getValue || fieldGenerator.getValues) && fieldGenerator.willNeedAsync) {
            return fieldGenerator.willNeedAsync(field, records, component);
        }
        return !!(fieldGenerator.generateValues || fieldGenerator.asyncGenerateValues);
    },

    __getNonSuccessfulResultAtOutset : function (fieldGenerator, field, component) {
        if (fieldGenerator.getNonSuccessfulResultAtOutset) {
            var nonSuccessfulResult = fieldGenerator.getNonSuccessfulResultAtOutset(field, component);
            if (nonSuccessfulResult && nonSuccessfulResult.type != "success") {
                return nonSuccessfulResult;
            }
        }
    },

    _getNonSuccessfulRecordSortResultAtOutset : function (fieldGenerator, sortSpecifier, component) {
        if (fieldGenerator.getNonSuccessfulRecordSortResultAtOutset) {
            var nonSuccessfulResult = fieldGenerator.getNonSuccessfulRecordSortResultAtOutset(
                    sortSpecifier, component);
            if (nonSuccessfulResult && nonSuccessfulResult.type != "success") {
                //>DEBUG
                this._assert(!nonSuccessfulResult.sortSpecifier || nonSuccessfulResult.sortSpecifier === sortSpecifier);
                //<DEBUG
                nonSuccessfulResult.sortSpecifier = sortSpecifier;
                return nonSuccessfulResult;
            }
        }
    },

    // @classMethod FieldGeneratorUtil._getDependencies()
    _getDependencies : function (fieldGenerator, field, component, allFieldNames) {
        var dependencies = fieldGenerator.getDependencies && fieldGenerator.getDependencies(field, component);
        if (dependencies != null) {
            //>DEBUG
            for (var d = 0; d < dependencies.length; ++d) {
                var dep = dependencies[d];
                if (!isc.isA.nonemptyString(dep)) {
                    component.logWarn("Field generator '" + fieldGenerator.ID + "' identified a dependency that is not a non-empty string.", "fieldGeneration");
                } else if (!component.getUnderlyingField(dep)) {
                    component.logWarn("Field generator '" + fieldGenerator.ID + "' identified a non-field dependency: '" + dep + "'", "fieldGeneration");
                }
            }
            //<DEBUG

            // Remove nulls, duplicate dependencies, and dependencies that are not actually
            // names of fields of the component.
            dependencies = allFieldNames.intersect(dependencies);
        } else {
            dependencies = allFieldNames.duplicate();
            dependencies.remove(field.name);
        }
        return dependencies;
    },

    // @classMethod FieldGeneratorUtil._getMaskedRecords()
    _getMaskedRecords : function (records, excludeFieldNames, storagePropertyNameByFieldName) {
        if (excludeFieldNames && !excludeFieldNames.isEmpty()) {
            var newRecords = new Array(records.length),
                undef;
            for (var r = 0; r < newRecords.length; ++r) {
                var record = records[r],
                    newRecord;
                
                if (isc.Browser._supportsObjectCreate) {
                    newRecord = Object.create(record);
                } else {
                    newRecord = isc.addPropertiesWithAssign({}, record);
                }
                for (var f = 0; f < excludeFieldNames.length; ++f) {
                    var excludedFieldName = excludeFieldNames[f],
                        excludedFieldStorageProperty = excludedFieldName in storagePropertyNameByFieldName
                                                    ? storagePropertyNameByFieldName[excludedFieldName]
                                                    : excludedFieldName;
                    newRecord[excludedFieldStorageProperty] = undef;
                }
                newRecords[r] = newRecord;
            }
            records = newRecords;
        }
        return records;
    },

    // @classMethod FieldGeneratorUtil._getValues()
    // Calls +link{FieldGenerator.getValues()} if implemented by the given field generator, or
    // else calls +link{FieldGenerator.getValue()} for each record.
    // <p>
    // This utility can be used only with field generator implementations that implement
    // getValues() and/or getValue().
    //
    // @param fieldGenerator (FieldGenerator) The field generator.
    // @param field (DBCField) The field generated by the given field generator.
    // @param records (Array of Record) The records.
    // @param context (FieldGenerationContext) Context for the field generation operation.
    // @return (Array of Any) The values generated for the given field and records.
    _getValues : function (fieldGenerator, field, records, context) {
        var generatedValues;
        if (fieldGenerator.getValues) {
            generatedValues = fieldGenerator.getValues(field, records, context);
            if (!isc.isAn.Array(generatedValues)) {
                this.logWarn("The '" + fieldGenerator.ID + "' field generator's getValues() implementation did not return an Array.", "fieldGeneration");
                generatedValues = new Array(records.length);
            } else if (generatedValues.length != records.length) {
                this.logWarn("The '" + fieldGenerator.ID + "' field generator's getValues() implementation returned " + generatedValues.length + " values. Expecting " + records.length + " values.", "fieldGeneration");
                generatedValues.setLength(records.length);
            }
        } else {
            this._assert(fieldGenerator.getValue);
            generatedValues = new Array(records.length);
            for (var i = 0; i < records.length; ++i) {
                generatedValues[i] = fieldGenerator.getValue(field, records[i], context);
            }
        }
        return generatedValues;
    },

    // @classMethod FieldGeneratorUtil._asyncGenerateValues()
    _asyncGenerateValues : function (fieldGenerator, field, records, context, partialResultCallback) {
        var givenCC = context.cancellationController;
        if (givenCC && givenCC.canceled) {
            return Promise.reject(givenCC.asCanceledResult());
        }

        if (fieldGenerator.asyncGenerateValues) {
            try {
                return fieldGenerator.asyncGenerateValues(field, records, context, partialResultCallback)
                    //>DEBUG
                    // In debug builds we'll do some basic checks to make sure that things look right.
                    .then(function (result) {
                        if (givenCC && givenCC.canceled) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() should have rejected because the CancellationController was canceled.",
                                erroneousResult: result
                            });
                        } else if (!result || result.type != "success") {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() did not fulfill with an AsyncFieldGenerationResult having type:\"success\".",
                                erroneousResult: result
                            });
                        } else if (!isc.isAn.Array(result.generatedValues) || result.generatedValues.length != records.length) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "`result.generatedValues` either wasn't an array, or its length was not equal to `records.length`.",
                                erroneousResult: result
                            });
                        }
                        return result;
                    }, function (nonSuccessfulResult) {
                        if (givenCC && givenCC.canceled && (!nonSuccessfulResult || nonSuccessfulResult.type != "canceled")) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() did not reject with a type:\"canceled\" result.",
                                erroneousResult: nonSuccessfulResult
                            });
                        } else if (!nonSuccessfulResult) {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() did not reject with a non-successful AsyncFieldGenerationResult.",
                                erroneousResult: nonSuccessfulResult
                            });
                        } else if (nonSuccessfulResult.type == "success") {
                            return Promise.reject({
                                type: "error",
                                errorMessage: "The Promise returned by asyncGenerateValues() rejected with an AsyncFieldGenerationResult having type:\"success\".",
                                erroneousResult: nonSuccessfulResult
                            });
                        }
                        return Promise.reject(nonSuccessfulResult);
                    })
                    //<DEBUG
                    ;
            } catch (e) {
                return Promise.reject(isc.defaultAsyncOperationCatchCallback(e));
            }
        }

        var resolversObj = Promise.withResolvers();
        try {
            if (fieldGenerator.generateValues) {
                fieldGenerator.generateValues(field, records, context, partialResultCallback, function (result) {
                    if (givenCC && givenCC.canceled && (!result || result.type != "canceled")) {
                        resolversObj.reject(givenCC.asCanceledResult({originalResult: result}));
                    } else if (!result || result.type != "success") {
                        resolversObj.reject(isc.defaultAsyncOperationCatchCallback(result));
                    } else if (!isc.isAn.Array(result.generatedValues) || result.generatedValues.length != records.length) {
                        resolversObj.reject({
                            type: "error",
                            errorMessage: "`result.generatedValues` either wasn't an array, or its length was not equal to `records.length`.",
                            erroneousResult: result
                        });
                    } else {
                        resolversObj.resolve(result);
                    }
                });
            } else {
                
                var generatedValues = this._getValues(fieldGenerator, field, records, context);

                resolversObj.resolve({
                    type: "success",
                    generatedValues: generatedValues
                });
            }
        } catch (e) {
            resolversObj.reject(isc.defaultAsyncOperationCatchCallback(e));
        }
        return resolversObj.promise;
    },


    __getAllNamedFields : isc.PseudoFieldGeneratorUtil.__getAllNamedFields,

    __getOrCreateFieldCC : isc.PseudoFieldGeneratorUtil.__getOrCreateFieldCC,

    __getAsyncNonSuccessInfo : isc.PseudoFieldGeneratorUtil.__getAsyncNonSuccessInfo,

    __makeSharedAsyncNonSuccessInfo : isc.PseudoFieldGeneratorUtil.__makeSharedAsyncNonSuccessInfo,

    __wrapNonSuccessfulInitResult : function (fieldName, initResult) {
        var message = "Initialization of field '" + fieldName.asHTML() + "' did not succeed: " + isc.getAsyncMessage(initResult);
        if (initResult.type == "canceled") {
            return isc.addPropertiesWithAssign({}, initResult, {
                cancellationReason: message,
                initResult: initResult
            });
        }

        var additionalProperties = {initResult: initResult};
        if (initResult.type == "disabled") {
            return isc.createDisabledResult(message, additionalProperties);
        }

        return isc.createErrorResult(message, additionalProperties);
    },

    // @classMethod FieldGeneratorUtil._asyncGenerateMissingFieldValues()
    // Generates values for the specified field.
    _asyncGenerateMissingFieldValues : function (generateMissingValuesContext, dabOpContext, field) {
        var undef,
            givenCC = dabOpContext.cancellationController,
            component = generateMissingValuesContext.component,
            componentId = component.getID(),
            recordInvalidationTimeKey = "_recordInvalidationTime_" + componentId,
            cacheObjKey = "_cache_" + componentId,
            asyncObjKey = "_async_" + componentId,
            asyncNonSuccessObjKey = "_asyncNonSuccess_" + componentId,
            cacheOrdinal = generateMissingValuesContext._cacheOrdinal,
            EH = component.ns.EH,
            startTime = generateMissingValuesContext.startTime,
            origRecords = generateMissingValuesContext.origRecords,
            fieldName = field.name,
            fieldGenerator = generateMissingValuesContext.fieldGeneratorByFieldName[fieldName],
            storagePropertyName = generateMissingValuesContext.storagePropertyNameByFieldName[fieldName],
            dependencies = generateMissingValuesContext.dependenciesByName[fieldName],
            untouchedRecords = generateMissingValuesContext.untouchedRecordsByName[fieldName],
            isAsyncByName = generateMissingValuesContext.isAsyncByName,
            resultByName = generateMissingValuesContext.resultByName;

        var nonSuccessfulResultAtOutset = resultByName[fieldName],
            sharedAsyncNonSuccessInfo;
        if (nonSuccessfulResultAtOutset) {
            
            sharedAsyncNonSuccessInfo = this.__makeSharedAsyncNonSuccessInfo(EH, cacheOrdinal, nonSuccessfulResultAtOutset);
        }

        var initPromise = generateMissingValuesContext.initPromiseByFieldName[fieldName],
            prereqPromises = [];
        if (initPromise) prereqPromises.push(initPromise);

        var depFieldCCs = new Array(dependencies.length + 2); // the +2 is for `givenCC` and `fieldCC`, which we place at indices 0 and 1
        for (var d = 0; d < dependencies.length; ++d) {
            var dep = dependencies[d],
                depResult = resultByName[dep];

            // Check for failures of synchronously-generated dependencies. If there are any,
            // then generation of the field fails as well.
            if (!nonSuccessfulResultAtOutset && isAsyncByName[dep] == false && depResult && depResult.type != "success") {
                nonSuccessfulResultAtOutset = {
                    type: "error",
                    errorMessage: "A dependency (the value of the '" + dep + "' field) was not successfully generated: " + isc.AsyncUtil.getRawMessage(depResult),
                    dependencyResult: depResult
                };
                sharedAsyncNonSuccessInfo = this.__makeSharedAsyncNonSuccessInfo(EH, cacheOrdinal, nonSuccessfulResultAtOutset);
            }

            // There may also be values of the dependency field that are being (asynchronously)
            // generated. Our promise must wait on those.
            var depField = component.getSpecifiedField(dep),
                depPromises = this._getFieldGenPromises(component, depField, false, cacheOrdinal);
            if (depPromises) prereqPromises.addList(depPromises);

            depFieldCCs[2 + d] = this.__getOrCreateFieldCC(depField, componentId);
        }

        // Go through the untouched records and mark everything to be generated asynchronously
        // as pending async or async non-success if we already know that a dependency failed.
        for (var rr = untouchedRecords.length; rr > 0; --rr) {
            var r = rr - 1,
                record = untouchedRecords[r],
                asyncNonSuccessInfo = sharedAsyncNonSuccessInfo || this.__getAsyncNonSuccessInfo(
                        component, cacheOrdinal, fieldName, record[recordInvalidationTimeKey],
                        record[asyncObjKey], record[asyncNonSuccessObjKey], dependencies,
                        // `skipInvalidationChecks` is `true` because we are being called
                        // to re-generate, so whether the value or dependencies' values were
                        // invalidated is moot.
                        /* skipInvalidationChecks */ true);
            if (asyncNonSuccessInfo) {
                var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
                if (!asyncNonSuccessObj) asyncNonSuccessObj = record[asyncNonSuccessObjKey] = {};
                asyncNonSuccessObj[fieldName] = asyncNonSuccessInfo;

                untouchedRecords.removeAt(r);
            } else {
                // Touching asyncInfo is effectively putting a "lock" on the responsibility for
                // asynchronously generating the value. We need to make sure that this "lock" is
                // released when we're done - see the final call to handleBatchResult() at the end.
                var asyncObj = record[asyncObjKey];
                if (!asyncObj) asyncObj = record[asyncObjKey] = {};
                component._touchAsyncInfo(asyncObj, fieldName, startTime);
            }
        }

        if (nonSuccessfulResultAtOutset) {
            return Promise.reject(resultByName[fieldName] = nonSuccessfulResultAtOutset);
        }

        var fieldCC = this.__getOrCreateFieldCC(field, componentId);

        var cancellationControllers = depFieldCCs;
        cancellationControllers[0] = givenCC;
        cancellationControllers[1] = fieldCC;

        var ownCC = isc.CancellationController.createJointController(cancellationControllers);

        if (untouchedRecords.isEmpty()) {
            // If this call to _asyncGenerateMissingFieldValues() is *not* going to generate any
            // values, it may be that previous call(s) are generating all of the requested values.
            // Thus, the existing field gen. Promises for the field are prerequisites.
            // (Note: In the other case where this call will generate at least one value, then the
            // existing field gen. Promises are not prerequisites, as this call can generate
            // the values it is responsible for in parallel; however, we do need to wait for
            // all of the requested values to be generated.)
            
            var existingPromises = this._getFieldGenPromises(component, field, /* createIfAbsent */ false, cacheOrdinal);
            if (existingPromises) prereqPromises.addList(existingPromises);
            return Promise._whenAllSettled(prereqPromises, ownCC)
                .then(function (results) {
                    var nonSuccessfulResult = ownCC.asCanceledResult(); // Note: if `ownCC` is not canceled, then this is `undefined`.

                    if (!nonSuccessfulResult) {
                        for (var r = 0; r < results.length; ++r) {
                            var result = results[r];
                            
                            if (result && result.type != "success") {
                                nonSuccessfulResult = result;
                                break;
                            }
                        }
                    }

                    if (!resultByName[fieldName]) {
                        result = resultByName[fieldName] = nonSuccessfulResult || {
                            type: "success",
                            generatedValues: []
                        };
                    }

                    if (nonSuccessfulResult) throw nonSuccessfulResult;
                    return result;
                });
        }

        

        var handleBatchResult = EH._wrapCallback("HandleBatchResult", function (records, batchResult) {
            
            if (!batchResult.records) batchResult.records = records;
            else this._assert(batchResult.records === records);

            // If our generation efforts are no longer current, or `records` is empty, then return.
            // These are the only cases where we can return early, as we must otherwise ensure
            // that the asyncInfo "locks" are released.
            if (cacheOrdinal != component._cacheOrdinal || records.isEmpty()) return;

            var wasSuccessful = batchResult.type == "success",
                sharedAsyncNonSuccessInfo,
                generatedValues;

            if (!wasSuccessful) {
                // It's okay to share the same asyncNonSuccessInfo for all of the records that
                // are part of the batch because asyncNonSuccessInfos are immutable.
                sharedAsyncNonSuccessInfo = {
                    _cacheOrdinal: cacheOrdinal,
                    _type: batchResult.type,
                    _message: isc.getAsyncMessage(batchResult),
                    _errorTime: EH._getLastUniqueTimeStamp()
                };
            } else {
                generatedValues = batchResult.generatedValues;
                this._assert(records.length == generatedValues.length);
            }

            for (var rr = records.length; rr > 0; --rr) {
                var r = rr - 1,
                    record = records[r],
                    asyncObj = record[asyncObjKey],
                    asyncInfo = asyncObj && asyncObj[fieldName];

                // It could happen that the asyncInfo is no longer current. In such a case,
                // the asyncInfo "lock" has already been released or re-acquired by another
                // field gen. operation and we aren't responsible for the record's value for
                // the field anymore.
                if (!asyncInfo || !component._isAsyncInfoCurrent(record, asyncInfo, /* specificStartTime */ startTime)) {
                    records.removeAt(r);
                    // Also remove the corresponding generated value. `generatedValues` only
                    // exists if the batch was successful.
                    if (wasSuccessful) generatedValues.removeAt(r);
                    continue;
                }

                var asyncNonSuccessObj = record[asyncNonSuccessObjKey],
                    asyncNonSuccessInfo = sharedAsyncNonSuccessInfo || this.__getAsyncNonSuccessInfo(
                            component, cacheOrdinal, fieldName, record[recordInvalidationTimeKey],
                            asyncObj, asyncNonSuccessObj, dependencies,
                            // Now `skipInvalidationChecks` is `false` because the value or
                            // dependencies' values could have been invalidated in the interim.
                            /* skipInvalidationChecks */ false);

                if (asyncNonSuccessInfo) {
                    if (!asyncNonSuccessObj) asyncNonSuccessObj = record[asyncNonSuccessObjKey] = {};
                    asyncNonSuccessObj[fieldName] = asyncNonSuccessInfo;

                    record[storagePropertyName] = undef;
                } else {
                    record[storagePropertyName] = generatedValues[r];

                    if (!record._noCache) {
                        var cacheObj = record[cacheObjKey];
                        if (!cacheObj) cacheObj = record[cacheObjKey] = {};
                        component._touchCacheInfo(cacheObj, fieldName);
                    }
                }

                // Release the asyncInfo "lock" on the (formerly) untouched record.
                delete asyncInfo._cacheOrdinal;
            }

            // Fire 'dataChanged' on `origRecords` unless the List does not have an _isChangingData()
            // method, or we're already in the middle of changing it.
            if (!origRecords._isChangingData || !origRecords._isChangingData()) origRecords.dataChanged("fieldGeneration");

            if (!component.destroyed) component._asyncFieldGenerationPartialResult(field, batchResult);
        }, this);

        var validatingPartialResultCallback = function (partialResult) {
            // If the field generator impl did not give us anything to work with, simply return.
            // Partial result handling is optional anyway.
            if (!partialResult) return;
            if (!partialResult.records && !partialResult.generatedValues) return;

            if (ownCC.canceled) return;

            if (component.destroyed) {
                ownCC.cancel(componentId + " was destroyed.", "application");
                return;
            }

            

            
            var partialRecords = partialResult.records;
            if (!isc.isAn.Array(partialRecords)) {
                isc.FieldGeneratorUtil.logError("Field generator '" + fieldGenerator.ID + "' passed an AsyncFieldGenerationPartialResult with `null` 'records'.", "fieldGeneration");
                return;
            }
            if (partialResult.type == "success") {
                var partialGeneratedValues = partialResult.generatedValues;
                if (!isc.isAn.Array(partialGeneratedValues)) {
                    isc.FieldGeneratorUtil.logError("Field generator '" + fieldGenerator.ID + "' passed a successful AsyncFieldGenerationPartialResult with `null` 'generatedValues'.", "fieldGeneration");
                    return;
                }
                if (partialRecords.length != partialGeneratedValues.length) {
                    isc.FieldGeneratorUtil.logError("Field generator '" + fieldGenerator.ID + "' passed a successful AsyncFieldGenerationPartialResult with different-length 'records' (" + partialRecords.length + ") and 'generatedValues' (" + partialGeneratedValues.length + ").", "fieldGeneration");
                    return;
                }
            }

            //>DEBUG
            for (var r = 0; r < partialRecords.length; ++r) {
                if (!untouchedRecords.contains(partialRecords[r])) {
                    isc.FieldGeneratorUtil.logError("Field generator '" + fieldGenerator.ID + "' passed an AsyncFieldGenerationPartialResult with a novel record.", "fieldGeneration");
                }
            }
            //<DEBUG

            handleBatchResult(partialRecords, partialResult);
        };

        // A failure to generate prerequisites might be a failure to generate some (or all) of
        // the values in this field for untouched records.
        //
        // For each record in `untouchedRecords`, we look for async-non-successes in the values
        // of the dependency fields. If we find one, then we'll set asyncNonSuccessInfo for the
        // field on the record and delete the record from `untouchedRecords`. We collect all
        // errored-out records and fire a synthetic partial result. Once we have error-free
        // `untouchedRecords`, we would invoke _asyncGenerateValues() on just the error-free
        // (so far) records.
        var promise = Promise._whenAllSettled(prereqPromises, ownCC)
            .then(function (results) {
                // Note: _whenAllSettled() never rejects.

                if (component.destroyed && !ownCC.canceled) {
                    ownCC.cancel(componentId + " was destroyed.", "application");
                }

                // If failed to init or field gen. was canceled, we'll let the _whenSettled()
                // block below handle such a non-successful result.
                var initResult = generateMissingValuesContext.initResultByFieldName[fieldName];
                if (initResult && initResult.type != "success") {
                    return Promise.reject(isc.FieldGeneratorUtil.__wrapNonSuccessfulInitResult(fieldName, initResult));
                }
                if (ownCC.canceled) return Promise.reject(ownCC.asCanceledResult());

                var erroredOutRecords = [];
                for (var rr = untouchedRecords.length; rr > 0; --rr) {
                    var r = rr - 1,
                        record = untouchedRecords[r];
                    if (isc.FieldGeneratorUtil.__getAsyncNonSuccessInfo(component, cacheOrdinal,
                                fieldName, record[recordInvalidationTimeKey], record[asyncObjKey],
                                record[asyncNonSuccessObjKey], dependencies,
                                /* skipInvalidationChecks */ false))
                    {
                        erroredOutRecords.push(record);
                        untouchedRecords.removeAt(r);
                    }
                }
                if (!erroredOutRecords.isEmpty()) {
                    var syntheticPartialResult = {
                        type: "error",
                        errorMessage: "The generation of all dependencies was not successful.",
                        records: erroredOutRecords
                    };
                    handleBatchResult(erroredOutRecords, syntheticPartialResult);
                }

                var asyncFieldGenContext = isc.addPropertiesWithAssign({}, dabOpContext, {
                    cancellationController: ownCC,
                    excludeFieldNames: generateMissingValuesContext.excludeFieldNamesByFieldName[fieldName]
                });
                return isc.FieldGeneratorUtil._asyncGenerateValues(fieldGenerator, field,
                        untouchedRecords, asyncFieldGenContext, validatingPartialResultCallback);
            })
            ._whenSettled(function (result) {
                // Note: Because _whenAllSettled() rejects immediately upon cancellation, it is possible
                // that not all prerequisite Promises have finished yet, so the prerequisite values
                // might not have all of their cacheInfos/asyncInfos/asyncNonSuccessInfos for which
                // they are responsible in non-transitory states. We use the asyncInfo "locks" to
                // figure out what has been finished and what is still in progress.

                // Pass all of the records that we were supposed to touch to handleBatchResult().
                // handleBatchResult() will filter out any records that were part of a previous
                // AsyncFieldGenerationPartialResult from the field generator.
                handleBatchResult(untouchedRecords, result);
            })
            ._finally(function () {
                this._removeFieldGenPromise(component, field, cacheOrdinal, promise);
                ownCC.destroy();
                
            }, this, EH);

        var fieldGenPromises = this._getFieldGenPromises(component, field, /* createIfAbsent */ true, cacheOrdinal);
        fieldGenPromises.push(promise);
        
        return Promise._whenAllSettled(fieldGenPromises, ownCC);
    },

    _getPseudoName : isc.PseudoFieldGeneratorUtil._getPseudoName,

    __hasRetryDelayElapsed : isc.PseudoFieldGeneratorUtil.__hasRetryDelayElapsed,

    __shouldRetry : isc.PseudoFieldGeneratorUtil.__shouldRetry,

    __isAsyncNonSuccessInfoCurrent : isc.PseudoFieldGeneratorUtil.__isAsyncNonSuccessInfoCurrent,

    __isValueUntouched : isc.PseudoFieldGeneratorUtil.__isValueUntouched,

    
    _doGenerateIfMissingValues : function (component, fields, records, cancellationController,
            skipAsync, suppressSynchronousDisplay)
    {
        

        var undef,
            cacheOrdinal = component._cacheOrdinal,
            EH = component.ns.EH,
            startTime = EH._getUniqueTimeStamp(),
            
            origFields = fields,
            // Keep a reference to the original `records`, to be able to call dataChanged() on it.
            origRecords = records,
            asyncEagerPseudoFieldInfos = component._getPseudoFieldInfos("eager") || [],
            untouchedRecordsByName = {},
            generatedFields = [],
            fieldGeneratorByFieldName = {},
            initResultByFieldName = {},
            initPromiseByFieldName = {},
            storagePropertyNameByFieldName = {},
            dependenciesByName = {},
            isAsyncByName = {},
            syncGeneratedFields = [],
            asyncGeneratedFields = [],
            excludeFieldNamesByFieldName = {},
            resultByName = {};

        var generateMissingValuesContext = {
            cancellationController: cancellationController,
            component: component,
            _cacheOrdinal: cacheOrdinal,
            startTime: startTime,
            origFields: origFields,
            origRecords: origRecords,
            asyncEagerPseudoFieldInfos: asyncEagerPseudoFieldInfos,
            untouchedRecordsByName: untouchedRecordsByName,
            generatedFields: generatedFields,
            fieldGeneratorByFieldName: fieldGeneratorByFieldName,
            initResultByFieldName: initResultByFieldName,
            initPromiseByFieldName: initPromiseByFieldName,
            storagePropertyNameByFieldName: storagePropertyNameByFieldName,
            dependenciesByName: dependenciesByName,
            isAsyncByName: isAsyncByName,
            syncGeneratedFields: syncGeneratedFields,
            asyncGeneratedFields: asyncGeneratedFields,
            excludeFieldNamesByFieldName: excludeFieldNamesByFieldName,
            // We'll create AsyncFieldGenerationResults for the synchronously-generated fields as well
            // because it's convenient to do so. Later, we can look up the results of dependencies
            // of asynchronously-generated fields without needing to check whether the dependency
            // was synchronously- or asynchronously-generated.
            resultByName: resultByName,
            dataChanged: false,
            promise: null
        };

        if (component._shouldSkipGeneratingComponent) return generateMissingValuesContext;

        if (isc.isA.ResultSet && isc.isA.ResultSet(records)) {
            if (records.localData) records = records.localData;
            else records = records.getAllLoadedRows();
        } else if (isc.isA.Tree && isc.isA.Tree(records)) {
            records = records.getAllItems();
        }
        var numRecords = !records ? 0 : records.getLength();

        var allNamedFields = component.getAllNamedFields() || [],
            allFieldNames = allNamedFields.getProperty("name");

        if (!fields) {
            var activeFields = component.getActiveFields();
            if (!activeFields) fields = [];
            else fields = allNamedFields.intersect(activeFields);
            
        }

        // Remove nulls, duplicates, and unnamed fields.
        fields = allNamedFields.intersect(fields);
        

        var componentId = component.getID(),
            cacheObjKey = "_cache_" + componentId,
            asyncObjKey = "_async_" + componentId,
            asyncNonSuccessObjKey = "_asyncNonSuccess_" + componentId,
            anythingToGenerate = false;

        

        for (var rpf = asyncEagerPseudoFieldInfos.length; rpf > 0; --rpf) {
            var pseudoFieldInfo = asyncEagerPseudoFieldInfos[rpf - 1],
                pseudoName = this._getPseudoName(pseudoFieldInfo);

            // Check whether we need to generate any pseudo-field values.
            var untouchedRecords = [];
            for (var r = 0; r < numRecords; ++r) {
                var record = records.get(r);
                if (!this.__isValueUntouched(record, pseudoName, component, cacheObjKey,
                            asyncObjKey, asyncNonSuccessObjKey))
                {
                    continue;
                }

                // Because we are going to re-generate the value, clear any non-successful result
                // from last time.
                var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
                if (asyncNonSuccessObj) {
                    
                    delete asyncNonSuccessObj[pseudoName];
                }

                untouchedRecords.push(record);
            }

            if (untouchedRecords.isEmpty()) {
                // Delete the PseudoFieldInfo entry if there's nothing to generate for it, so
                // that if & when we later fire the DBC._asyncFieldGenerationStart() notification,
                // the DBC has the list of pseudo-fields that are actually going to result in
                // asynchronous computation.
                asyncEagerPseudoFieldInfos.removeAt(rpf - 1);
                continue;
            }

            anythingToGenerate = true;

            untouchedRecordsByName[pseudoName] = untouchedRecords;

            var pseudoFieldGenerator = isc.PseudoFieldGeneratorRegistry.getForPseudoField(pseudoFieldInfo),
                dependencies = dependenciesByName[pseudoName] = isc.PseudoFieldGeneratorUtil._getDependencies(
                        pseudoFieldGenerator, pseudoFieldInfo, component, allFieldNames);

            // Add any dependency fields to `fields`.
            for (var d = 0; d < dependencies.length; ++d) {
                var dep = dependencies[d],
                    depField = component.getUnderlyingField(dep);

                if (allNamedFields.contains(depField) && !fields.contains(depField)) {
                    fields.push(depField);
                }
            }
        }

        if (fields.isEmpty() && !anythingToGenerate) return generateMissingValuesContext;

        for (var f = 0; f < fields.length; ++f) {
            var field = fields[f];
            if (field.primaryKey) continue;

            var fieldGenerator = component._getFieldGenerator(field);
            if (fieldGenerator) {
                generatedFields.push(field);
                var initResult = this.__getCurrentNonRetriableInitResult(field, component),
                    storagePropertyName = this._getStoragePropertyName(fieldGenerator, field, component),
                    fieldName = field.name;
                initResultByFieldName[fieldName] = initResult;
                fieldGeneratorByFieldName[fieldName] = fieldGenerator;
                storagePropertyNameByFieldName[fieldName] = storagePropertyName;

                var forceAsync = false;
                if (initResult) {
                    if (initResult.type != "success") {
                        resultByName[fieldName] = isc.FieldGeneratorUtil.__wrapNonSuccessfulInitResult(fieldName, initResult);
                    }
                } else {
                    var initPromise = this.__asyncInitField(fieldGenerator, field, component);

                    if (initPromise) {
                        // If the field is being initialized asynchronously, then we need to
                        // force async generation of the field's values.
                        forceAsync = true;

                        initPromiseByFieldName[fieldName] = initPromise
                            ._whenSettled(function (fieldName, initResult) {
                                initResultByFieldName[fieldName] = initResult;
                                if (initResult.type != "success") resultByName[fieldName] = initResult;
                            }.bind(this, fieldName),
                            null,
                            null,
                            cancellationController);
                    }
                }

                var untouchedRecords = [];
                for (var r = 0; r < numRecords; ++r) {
                    var record = records.get(r);
                    if (!this.__isValueUntouched(record, fieldName, component, cacheObjKey,
                                asyncObjKey, asyncNonSuccessObjKey))
                    {
                        continue;
                    }
                    untouchedRecords.push(record);

                    var asyncObj = record[asyncObjKey];
                    if (asyncObj && component._isAsyncInfoCurrent(record, asyncObj[fieldName])) {
                        // If values for the field have a pending asynchrous operation, then we need to
                        // force asynchronous generation of the field.
                        forceAsync = true;
                    }

                    // Because we are going to re-generate the value, clear the stored value
                    // and clear any non-successful result from last time.
                    record[storagePropertyName] = undef;
                    var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
                    if (asyncNonSuccessObj) {
                        
                        delete asyncNonSuccessObj[fieldName];
                    }
                }

                anythingToGenerate = anythingToGenerate ||
                                     !untouchedRecords.isEmpty() ||
                                     // if something is being generated for the field, then
                                     // there's something to generate
                                     isc.isA.nonemptyArray(this._getFieldGenPromises(component, field, false, cacheOrdinal));

                

                untouchedRecordsByName[fieldName] = untouchedRecords;

                if (forceAsync) {
                    component.logDebug("Forcing '" + fieldName + "' to asynchronous generation because one of the values is pending async", "fieldGeneration");
                }

                var isAsync = isAsyncByName[fieldName] = forceAsync || this._willNeedAsync(generatedFields,
                                                                                           fieldGeneratorByFieldName,
                                                                                           untouchedRecordsByName,
                                                                                           fieldGenerator,
                                                                                           field, untouchedRecordsByName[fieldName], component),
                    dependencies = dependenciesByName[fieldName] = this._getDependencies(fieldGenerator, field, component, allFieldNames);

                (isAsync ? asyncGeneratedFields : syncGeneratedFields).push(field);

                // Add any dependency fields to `fields`.
                for (var rd = dependencies.length; rd > 0; --rd) {
                    var d = rd - 1,
                        dep = dependencies[d],
                        depField = component.getUnderlyingField(dep);

                    if (dep == fieldName) {
                        
                        if (fieldName == storagePropertyName) {
                            component.logWarn("Field generator '" + fieldGenerator.ID + "' identified a self-dependency on the generated value for field '" + fieldName + "'", "fieldGeneration");
                            var excludeFieldNames = excludeFieldNamesByFieldName[fieldName];
                            if (!excludeFieldNames) excludeFieldNames = excludeFieldNamesByFieldName[fieldName] = [];
                            excludeFieldNames.push(fieldName);
                        }
                        // Ensure that there are no self-loops in the dependencies graph.
                        // It's safe to mutate the field's `dependencies` array because _getDependencies()
                        // returns a new array.
                        dependencies.removeAt(d);
                        continue;
                    }

                    if (allNamedFields.contains(depField) && !fields.contains(depField)) {
                        fields.push(depField);
                        // Note: we don't need to restart the `for` loop over the fields because
                        // we are adding the new depfields to the end of `fields`.
                    }
                }
            }
        }

        for (var f = 0; f < generatedFields.length; ++f) {
            var field = generatedFields[f],
                fieldName = field.name,
                fieldGenerator = fieldGeneratorByFieldName[fieldName];
            resultByName[fieldName] = this.__getNonSuccessfulResultAtOutset(fieldGenerator, field, component);
        }

        // Update dependencies with the transitive dependencies.
        dependenciesByName = generateMissingValuesContext.dependenciesByName = isc.Math._transitiveClosure(dependenciesByName);

        if (!anythingToGenerate) {
            for (var f = 0; f < generatedFields.length; ++f) {
                var field = generatedFields[f],
                    fieldName = field.name;
                if (resultByName[fieldName]) continue;
                resultByName[fieldName] = {
                    type: "success",
                    generatedValues: []
                };
            }
            return generateMissingValuesContext;
        }

        // Go through the list of synchronously-generated fields, looking for any instances where
        // a synchronously-generated field depends on an asynchronously-generated field. In such
        // cases, we will switch to asynchronous generation.
        for (var f = 0; f < syncGeneratedFields.length; ++f) {
            var field = syncGeneratedFields[f],
                fieldName = field.name,
                dependencies = dependenciesByName[fieldName];

            for (var d = 0; d < dependencies.length; ++d) {
                var dep = dependencies[d],
                    depField = component.getSpecifiedField(dep),
                    depPromises = this._getFieldGenPromises(component, depField, false, cacheOrdinal);
                if (isAsyncByName[dep] || (depPromises && !depPromises.isEmpty())) {
                    // Switch the field to asynchronous generation.
                    component.logDebug("Switching generated field '" + fieldName + "' to asynchronous generation because it depends on the asynchronously-generated field '" + dep + "'", "fieldGeneration");
                    isAsyncByName[fieldName] = true;
                    syncGeneratedFields.removeAt(f);
                    asyncGeneratedFields.push(field);

                    // Because we switched a field to asynchronous generation, we need to restart
                    // the loop over the synchronously-generated fields, in case there is a different
                    // synchronously-generated field that depends on the now-asynchronously-generated
                    // field.
                    f = -1;
                    break;
                }
            }
        }

        var fieldCompareFn = function (field1, field2) {
            var field1Name = field1.name,
                field1Dependencies = dependenciesByName[field1Name],
                field2Name = field2.name,
                field2Dependencies = dependenciesByName[field2Name],
                field1DependsOnField2 = field1Dependencies.contains(field2Name),
                field2DependsOnField1 = field2Dependencies.contains(field1Name);

            if (field1DependsOnField2) {
                if (field2DependsOnField1) {
                    // The fields are co-dependent. We will add each to the other's `excludeFieldNames`
                    // array, break the co-dependency, and log an error.

                    var excludeFieldNames = excludeFieldNamesByFieldName[field1Name];
                    if (!excludeFieldNames) excludeFieldNames = excludeFieldNamesByFieldName[field1Name] = [];
                    
                    excludeFieldNames.push(field2Name);

                    excludeFieldNames = excludeFieldNamesByFieldName[field2Name];
                    if (!excludeFieldNames) excludeFieldNames = excludeFieldNamesByFieldName[field2Name] = [];
                    
                    excludeFieldNames.push(field1Name);

                    // It's safe to mutate the two fields' dependencies arrays because _getDependencies()
                    // returns a new array.
                    field1Dependencies.remove(field2Name);
                    field2Dependencies.remove(field1Name);

                    component.logError("Generated fields '" + field1Name + "' and '" + field2Name + "' were co-dependent.", "fieldGeneration");
                } else {
                    // field1 depends on field2. We want to sort field2 before field1; that is,
                    // field1 is greater than field2.
                    return 1;
                }
            } else if (field2DependsOnField1) {
                // field2 depends on field1. We want to sort field1 before field2; that is,
                // field1 is less than field2.
                return -1;
            }

            if (field1Name < field2Name) return -1;
            else {
                isc.FieldGeneratorUtil._assert(field1Name != field2Name);
                return 1;
            }
        };

        // We'll first perform synchronous generation.

        if (!syncGeneratedFields.isEmpty()) {
            syncGeneratedFields.sort(fieldCompareFn);

            for (var f = 0; f < syncGeneratedFields.length; ++f) {
                var field = syncGeneratedFields[f],
                    fieldName = field.name,
                    storagePropertyName = storagePropertyNameByFieldName[fieldName],
                    untouchedRecords = untouchedRecordsByName[fieldName];
                if (untouchedRecords.isEmpty()) {
                    if (!resultByName[fieldName]) {
                        resultByName[fieldName] = {
                            type: "success",
                            generatedValues: []
                        };
                    }
                    continue;
                }

                // If generation of any (synchronous) dependencies failed, then generation of
                // the current (synchronously-generated) field fails as well.
                
                var dependencies = dependenciesByName[fieldName];
                for (var d = 0; d < dependencies.length; ++d) {
                    var dep = dependencies[d],
                        depResult = resultByName[dep];
                    if (depResult && depResult.type != "success") {
                        resultByName[fieldName] = {
                            type: "error",
                            errorMessage: "A dependency failed: " + isc.getAsyncMessage(depResult),
                            dependencyResult: depResult
                        };
                        break;
                    }
                }

                // If we don't already have a result, go ahead and run the synchronous field generation now.
                if (!resultByName[fieldName]) {
                    var fieldGenContext = {
                        component: component,
                        excludeFieldNames: excludeFieldNamesByFieldName[fieldName]
                    };
                    try {
                        var generatedValues = this._getValues(fieldGeneratorByFieldName[fieldName],
                                field, untouchedRecords, fieldGenContext);
                    } catch (e) {
                        resultByName[fieldName] = isc.defaultAsyncOperationCatchCallback(e);
                    }
                }

                // The records are changed regardless of success: If generated successfully,
                // there are new values. Otherwise, there is information for the non-successful
                // outcome that might be displayed in the component.
                generateMissingValuesContext.dataChanged = true;

                var result = resultByName[fieldName] || (resultByName[fieldName] = {
                    type: "success",
                    generatedValues: generatedValues
                });

                var wasNonSuccessful = result.type != "success";
                if (wasNonSuccessful) {
                    var sharedNonSuccessInfo = {
                        _cacheOrdinal: cacheOrdinal,
                        _type: result.type,
                        _message: isc.AsyncUtil.getRawMessage(result),
                        _errorTime: EH._getLastUniqueTimeStamp()
                        
                    };
                }
                for (var r = 0; r < untouchedRecords.length; ++r) {
                    var record = untouchedRecords[r];

                    // If the synchronous generation of the field failed, touch the "_asyncNonSuccess_"
                    // infos. Even though the values did not result from async generation, doing so
                    // hilites the values as having failed to be generated.
                    if (wasNonSuccessful) {
                        var asyncNonSuccessObj = record[asyncNonSuccessObjKey];
                        if (!asyncNonSuccessObj) asyncNonSuccessObj = record[asyncNonSuccessObjKey] = {};
                        asyncNonSuccessObj[fieldName] = sharedNonSuccessInfo;

                        
                    } else {
                        record[storagePropertyName] = generatedValues[r];

                        if (record._noCache) continue;

                        var cacheObj = record[cacheObjKey];
                        if (!cacheObj) cacheObj = record[cacheObjKey] = {};
                        component._touchCacheInfo(cacheObj, fieldName);
                    }
                }
            }

            if (generateMissingValuesContext.dataChanged) {
                // Fire 'dataChanged' on `origRecords` unless the List does not have an _isChangingData()
                // method, or we're already in the middle of changing it.
                if (!origRecords._isChangingData || !origRecords._isChangingData()) origRecords.dataChanged("fieldGeneration");

                if (!component.destroyed) component._fieldsGenerated(generateMissingValuesContext, suppressSynchronousDisplay);
            }
        }

        if (asyncGeneratedFields.isEmpty() && asyncEagerPseudoFieldInfos.isEmpty()) {
            return generateMissingValuesContext;
        }

        if (skipAsync == true) {
            var deferredResult = {type: "deferred"};
            for (var f = 0; f < asyncGeneratedFields.length; ++f) {
                var field = asyncGeneratedFields[f],
                    fieldName = field.name;
                if (resultByName[fieldName]) continue;
                resultByName[fieldName] = deferredResult;
            }
            for (var pf = 0; pf < asyncEagerPseudoFieldInfos.length; ++pf) {
                var pseudoFieldInfo = asyncEagerPseudoFieldInfos[pf],
                    pseudoName = this._getPseudoName(pseudoFieldInfo);
                resultByName[pseudoName] = deferredResult;
            }
        }

        // Now we'll perform asynchronous generation.
        var dabOpParams = {
            cancellationController: cancellationController,
            component: component
        };
        
        var promise = generateMissingValuesContext.promise = isc.AsyncUtil.asyncDataBoundOperation(dabOpParams, function (dabOpContext) {
            // Note: Despite the callback that we're in, it's still the same thread as above
            // because asyncDataBoundOperation() fires the impl callback synchronously.

            asyncGeneratedFields.sort(fieldCompareFn);

            var promises = new Array(asyncGeneratedFields.length + asyncEagerPseudoFieldInfos.length);

            // Call _asyncGenerateMissingFieldValues() for each asynchronously-generated
            // field, and _asyncGenerateMissingPseudoFieldValues() for each eagerly-generated
            // pseudo-field.
            // Note: we can't use a ResolvedValuesMapper because we want the initial setup
            // code (such as marking the untouched records as pending async) to run synchronously
            // before calling _asyncFieldGenerationStart() to notify the component of
            // pending asynchronous field generation operation(s).
            for (var f = 0; f < asyncGeneratedFields.length; ++f) {
                promises[f] = isc.FieldGeneratorUtil._asyncGenerateMissingFieldValues(
                        generateMissingValuesContext, dabOpContext, asyncGeneratedFields[f]);
            }
            for (var pf = 0; pf < asyncEagerPseudoFieldInfos.length; ++pf) {
                promises[asyncGeneratedFields.length + pf] = isc.EagerPseudoFieldGeneratorUtil._asyncGenerateMissingPseudoFieldValues(
                        generateMissingValuesContext, dabOpContext, asyncEagerPseudoFieldInfos[pf]);
            }

            return Promise._whenAllSettled(promises, dabOpContext.cancellationController);
        }).then(function (results) {
                isc.FieldGeneratorUtil._assert(results.length >= asyncGeneratedFields.length);

                for (var f = 0; f < asyncGeneratedFields.length; ++f) {
                    var field = asyncGeneratedFields[f],
                        fieldName = field.name;
                    if (!resultByName[fieldName]) {
                        resultByName[fieldName] = results[f];
                    }
                }

                
            }, function (nonSuccessfulResult) {
                for (var f = 0; f < asyncGeneratedFields.length; ++f) {
                    var field = asyncGeneratedFields[f],
                        fieldName = field.name;
                    if (resultByName[fieldName] == null) {
                        resultByName[fieldName] = nonSuccessfulResult;
                    }
                }
            })
            ._finally(function () {
                this._removeFieldGenPromise(component, null, cacheOrdinal, promise);
                if (!component.destroyed) component._asyncFieldGenerationStop(generateMissingValuesContext);
            }, this, EH);
        this._getFieldGenPromises(component, null, true, cacheOrdinal).push(promise);
        if (!component.destroyed) component._asyncFieldGenerationStart(generateMissingValuesContext);

        return generateMissingValuesContext;
    },

    // @classMethod FieldGeneratorUtil._cancelFieldGeneration()
    _cancelFieldGeneration : function (component, field, reason, initiator) {
        
        var fieldCC = field["_cancellationController_" + component.getID()];
        if (fieldCC && !fieldCC.canceled) {
            fieldCC.cancel(reason, initiator);
        }
    },

    
    _augmentFieldsWithDependents : function (component, fields, __allFields) {
        var allNamedFields = this.__getAllNamedFields(component, __allFields);
        if (!allNamedFields || allNamedFields.isEmpty()) return;
        var allFieldNames = allNamedFields.getProperty("name"),
            allGeneratedFields = component._getGeneratedFields(allNamedFields),
            dependenciesByName = {};
        for (var f = 0; f < allGeneratedFields.length; ++f) {
            var field = allGeneratedFields[f];
            if (fields.contains(field)) continue;
            var fieldGenerator = component._getFieldGenerator(field),
                fieldName = field.name,
                dependencies = dependenciesByName[fieldName];
            if (!dependencies) {
                dependencies = dependenciesByName[fieldName] = this._getDependencies(
                        fieldGenerator, field, component, allFieldNames);
            }
            for (var d = 0; d < dependencies.length; ++d) {
                var dep = dependencies[d],
                    depField = component.getUnderlyingField(dep);
                // If the generated field depends on a field that will be invalidated, then
                // the dependent field must be invalidated, too.
                if (fields.contains(depField)) {
                    fields.push(field);
                    // Restart the loop over the generated fields because a generated field
                    // might now need to be invalidated.
                    f = -1;
                    break;
                }
            }
        }
    },

    // @classMethod FieldGeneratorUtil._cancelFieldGenerationAndInvalidateCaches()
    _cancelFieldGenerationAndInvalidateCaches : function (component, field, reason, cancellationInitiator) {
        this._cancelFieldGeneration(component, field, reason, cancellationInitiator);

        var fieldsToInvalidate = [field];
        this._augmentFieldsWithDependents(component, fieldsToInvalidate);
        component.invalidateUserCache(null, fieldsToInvalidate);
    },

    
    _copyRecordInto : function (destRecord, srcRecord, component) {
        var allNamedFields = component.getAllNamedFields(),
            numNamedFields = !allNamedFields ? 0 : allNamedFields.length,
            storagePropertyNameByFieldName = null;

        if (component._shouldSkipGeneratingRecord(destRecord)) {
            for (var f = 0; f < numNamedFields; ++f) {
                var field = allNamedFields[f],
                    fieldName = field.name;
                destRecord[fieldName] = srcRecord[fieldName];
            }

        } else {
            for (var f = 0; f < numNamedFields; ++f) {
                var field = allNamedFields[f],
                    fieldGenerator = component._getFieldGenerator(field);
                if (fieldGenerator) {
                    var storagePropertyName = this._getStoragePropertyName(fieldGenerator, field, component);
                    if (!storagePropertyNameByFieldName) storagePropertyNameByFieldName = {};
                    storagePropertyNameByFieldName[field.name] = storagePropertyName;
                }
            }

            var undef,
                componentId = component.getID(),
                recordInvalidationTimeKey = "_recordInvalidationTime_" + componentId,
                cacheObjKey = "_cache_" + componentId,
                srcCacheObj = srcRecord[cacheObjKey],
                asyncObjKey = "_async_" + componentId,
                srcAsyncObj = srcRecord[asyncObjKey],
                asyncNonSuccessObjKey = "_asyncNonSuccess_" + componentId,
                srcAsyncNonSuccessObj = srcRecord[asyncNonSuccessObjKey];

            destRecord[recordInvalidationTimeKey] = srcRecord[recordInvalidationTimeKey];

            // If there are no generated fields, then we can skip a lot of checks and simply
            // copy values for named fields.
            if (!storagePropertyNameByFieldName) {
                destRecord[cacheObjKey] = null;
                destRecord[asyncObjKey] = null;
                destRecord[asyncNonSuccessObjKey] = null;

                for (var f = 0; f < numNamedFields; ++f) {
                    var field = allNamedFields[f],
                        fieldName = field.name;
                    destRecord[fieldName] = srcRecord[fieldName];
                }

            // If `srcRecord` does not have cache, async, or asyncNonSuccess objects, then we can skip a lot
            // of checks and simply copy non-generated values for named fields, and clear the storage
            // properties for generated fields.
            } else if (!srcCacheObj && !srcAsyncObj && !srcAsyncNonSuccessObj) {
                destRecord[cacheObjKey] = null;
                destRecord[asyncObjKey] = null;
                destRecord[asyncNonSuccessObjKey] = null;

                for (var f = 0; f < numNamedFields; ++f) {
                    var field = allNamedFields[f],
                        fieldName = field.name,
                        storagePropertyName = storagePropertyNameByFieldName[fieldName];
                    if (storagePropertyName != null) {
                        // Because there was no cacheObj, we don't have the current, generated value;
                        // so, clear the storage property in the destination record.
                        destRecord[storagePropertyName] = undef;
                    } else {
                        destRecord[fieldName] = srcRecord[fieldName];
                    }
                }

                // Pseudo-field values have been cleared by setting the cache object to `null` in
                // `destRecord`.

            } else {

                // Reset the destination record's cache, async, and asyncNonSuccess objects.
                var destCacheObj = destRecord[cacheObjKey] = srcCacheObj && {},
                    destAsyncObj = destRecord[asyncObjKey] = srcAsyncObj && {},
                    destAsyncNonSuccessObj = destRecord[asyncNonSuccessObjKey] = srcAsyncNonSuccessObj && {};

                for (var f = 0; f < numNamedFields; ++f) {
                    var field = allNamedFields[f],
                        fieldName = field.name,
                        srcAsyncInfo = srcAsyncObj && srcAsyncObj[fieldName];

                    if (srcAsyncInfo && srcAsyncInfo._invalidationTime != null) {
                        destAsyncObj[fieldName] = {_invalidationTime: srcAsyncInfo._invalidationTime};
                    }

                    var storagePropertyName = storagePropertyNameByFieldName[fieldName];
                    if (storagePropertyName != null) {
                        if (srcCacheObj && component._isCacheInfoCurrent(srcCacheObj[fieldName])) {
                            destRecord[storagePropertyName] = srcRecord[storagePropertyName];
                            destCacheObj[fieldName] = isc.clone(srcCacheObj[fieldName]);
                        } else {
                            // As we do not have a current, successfully-generated value, clear the
                            // storage property in the destination record.
                            destRecord[storagePropertyName] = undef;

                            if (srcAsyncNonSuccessObj && component._isCacheInfoCurrent(srcAsyncNonSuccessObj[fieldName])) {
                                // We can safely use a reference to the same asyncNonSuccessInfo because
                                // it's immutable.
                                destAsyncNonSuccessObj[fieldName] = srcAsyncNonSuccessObj[fieldName];
                            }
                        }
                    } else {
                        // Explicitly copy the value from the source record because: if we've cleared a
                        // field value, it might not be present as an explicit null/undefined value on
                        // the updated record object.
                        destRecord[fieldName] = srcRecord[fieldName];
                    }
                }

                var pseudoFieldInfos = component._getPseudoFieldInfos(),
                    numPseudoFieldInfos = !pseudoFieldInfos ? 0 : pseudoFieldInfos.length;
                for (var pf = 0; pf < numPseudoFieldInfos; ++pf) {
                    var pseudoFieldInfo = pseudoFieldInfos[pf],
                        pseudoName = this._getPseudoName(pseudoFieldInfo),
                        srcAsyncInfo = srcAsyncObj && srcAsyncObj[pseudoName];
                    if (srcAsyncInfo && srcAsyncInfo._invalidationTime != null) {
                        destAsyncObj[pseudoName] = {_invalidationTime: srcAsyncInfo._invalidationTime};
                    }
                    if (srcCacheObj && component._isCacheInfoCurrent(srcCacheObj[pseudoName])) {
                        destCacheObj[pseudoName] = isc.clone(srcCacheObj[pseudoName]);
                    } else if (srcAsyncNonSuccessObj && component._isCacheInfoCurrent(srcAsyncNonSuccessObj[pseudoName])) {
                        // We can safely use a reference to the same asyncNonSuccessInfo because
                        // it's immutable.
                        destAsyncNonSuccessObj[pseudoName] = srcAsyncNonSuccessObj[pseudoName];
                    }
                }
            }
        }

        
        var dataSource = component.getDataSource();
        if (isc.isA.DataSource(dataSource)) {
            var dsFields = dataSource.getFields(),
                storagePropertyNames = storagePropertyNameByFieldName && isc.getValues(storagePropertyNameByFieldName);
            for (var dsFieldName in dsFields) {
                if (!Object.hasOwn(dsFields, dsFieldName) ||
                    // make sure that we're not clobbering a storage property
                    (storagePropertyNames && storagePropertyNames.contains(dsFieldName)))
                {
                    continue;
                }

                destRecord[dsFieldName] = srcRecord[dsFieldName];
            }
        }
    },

    _setAllFields : function (component, oldFields, newFields) {
        
        var numOldFields = !oldFields ? 0 : oldFields.length,
            numNewFields = !newFields ? 0 : newFields.length,
            fieldsToInvalidate = [];
        for (var f = 0; f < numOldFields; ++f) {
            var field = oldFields[f];
            // If the field was removed, cancel any field generation for it.
            
            if (numNewFields <= 0 || !newFields.contains(field)) {
                this._cancelFieldGeneration(component, field, "The '" + field.name + "' field is being removed.", "application");
                fieldsToInvalidate.push(field);
            }
        }

        

        if (!fieldsToInvalidate.isEmpty()) {
            this._augmentFieldsWithDependents(component, fieldsToInvalidate, newFields);
            component.invalidateUserCache(null, fieldsToInvalidate, "setFields");
        }
    },

    _setActiveFields : function (component, oldActiveFields, newActiveFields) {
        
        var numOldActiveFields = !oldActiveFields ? 0 : oldActiveFields.length,
            numNewActiveFields = !newActiveFields ? 0 : newActiveFields.length,
            fieldsToInvalidate = [];
        for (var f = 0; f < numOldActiveFields; ++f) {
            var field = oldActiveFields[f];
            if (numNewActiveFields > 0 && newActiveFields.contains(field)) {
                var fieldGenerator = component._getFieldGenerator(field);
                if (fieldGenerator && fieldGenerator.settingActiveFieldsInvalidatesCache) {
                    if (fieldGenerator.settingActiveFieldsInvalidatesCache(field, component, oldActiveFields, newActiveFields)) {
                        fieldsToInvalidate.push(field);
                    }
                }
            }
        }

        if (!fieldsToInvalidate.isEmpty()) {
            this._augmentFieldsWithDependents(component, fieldsToInvalidate, component.getAllFields());
            component.invalidateUserCache(null, fieldsToInvalidate, "setFields");
        }
    },

    // @classMethod FieldGeneratorUtil._beforeSetFieldProperty()
    // @return (Boolean) <code>true</code> if the cache was invalidated and field gen. ops were
    // canceled.
    _beforeSetFieldProperty : function (component, field, propertyName, newValue) {
        var fieldGenerator = component._getFieldGenerator(field);
        if (fieldGenerator) {
            
            this._assert(field.fieldGeneratorId == null || field.fieldGeneratorId == fieldGenerator.ID);
            field.fieldGeneratorId = fieldGenerator.ID;

            if (fieldGenerator.settingFieldPropertyInvalidatesCache) {
                if (fieldGenerator.settingFieldPropertyInvalidatesCache(field, propertyName, newValue)) {
                    this._cancelFieldGenerationAndInvalidateCaches(component, field, "Setting the '" + propertyName + "' property of the '" + field.name + "' field invalidates the cache.", "application");
                    return true;
                }
            } else {
                var fieldProperties = {};
                fieldProperties[propertyName] = newValue;
                return this._beforeSetFieldProperties(component, field, fieldProperties, fieldGenerator);
            }
        }
    },

    
    _beforeSetFieldProperties : function (component, field, fieldProperties, __fieldGenerator) {
        if (!__fieldGenerator) __fieldGenerator = component._getFieldGenerator(field);

        if (__fieldGenerator) {
            
            this._assert(!field.fieldGeneratorId || field.fieldGeneratorId == __fieldGenerator.ID);
            field.fieldGeneratorId = __fieldGenerator.ID;

            if (__fieldGenerator.settingFieldPropertiesInvalidatesCache &&
                __fieldGenerator.settingFieldPropertiesInvalidatesCache(field, component, fieldProperties))
            {
                this._cancelFieldGenerationAndInvalidateCaches(component, field, "Setting properties of the '" + field.name + "' field invalidates the cache.", "application");
                return true;
            } else {
                var controllingFieldProperties = __fieldGenerator.controllingFieldProperties;
                if (controllingFieldProperties || __fieldGenerator.settingFieldPropertyInvalidatesCache) {
                    for (var propertyName in fieldProperties) {
                        if (!Object.hasOwn(fieldProperties, propertyName)) continue;
                        if (controllingFieldProperties && !controllingFieldProperties.contains(propertyName)) continue;

                        // Invalidate the cache if:
                        // - `propertyName` is listed in `controllingFieldProperties` and there isn't
                        //   a settingFieldPropertyInvalidatesCache() impl.
                        // - settingFieldPropertyInvalidatesCache() returns `true`.
                        if ((controllingFieldProperties && !__fieldGenerator.settingFieldPropertyInvalidatesCache) ||
                            __fieldGenerator.settingFieldPropertyInvalidatesCache(field, component, propertyName, fieldProperties[propertyName]))
                        {
                            this._cancelFieldGenerationAndInvalidateCaches(component, field, "Setting the '" + propertyName + "' property of the '" + field.name + "' field invalidates the cache.", "application");
                            return true;
                        }
                    }
                }
            }
        }
    }
});
