/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.data;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * ResultSets are an implementation of the {@link com.smartgwt.client.data.List} interface that automatically fetches 
 *  DataSource records when items are requested from the List.  ResultSets provide robust,
 *  customizable, high-performance cache management for ListGrids and other built-in Smart GWT
 *  components, and can be used as cache managers by custom components.
 *  <P>
 *  ResultSets manage data paging, that is, loading records in batches as the user navigates
 *  the data set.  A ResultSet will switch to using client-side sorting and filtering when
 *  possible to improve responsiveness and reduce server load.  ResultSets also participate in
 *  automatic cache synchronization, observing operations on DataSources and automatically
 *  updating their caches.
 *  <P>
 *  <b>Creation</b>
 *  <P>
 *  A ResultSet can be passed to any component that expects a List, and the List APIs can be
 *  called directly on the ResultSet as long as the caller is able to deal with asynchronous
 *  loading; see {@link com.smartgwt.client.data.ResultSet#getRange getRange()}.
 *  <P>
 *  Generally ResultSets do not need to be created directly, but are created by DataBound
 *  components as an automatic consequence of calling 
 *  {@link com.smartgwt.client.docs.DataBoundComponentMethods DataBound Component Methods}.  
 * For example, the {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} causes {@link
 * com.smartgwt.client.widgets.grid.ListGrid#getData ListGrid.data} to become an
 *  automatically created <code>ResultSet</code> object.  Automatically created ResultSets
 * can be customized via properties on ListGrids such as {@link com.smartgwt.client.widgets.grid.ListGrid#getDataPageSize
 * ListGrid.dataPageSize} and
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getDataProperties ListGrid.dataProperties}.  All ResultSets for a given
 * DataSource may also be 
 * customized via setting {@link com.smartgwt.client.data.DataSource#getResultSetClass DataSource.resultSetClass} to the
 * name of a ResultSet 
 *  {@link com.smartgwt.client.util.isc#defineClass subclass} in which 
 *   defaults have been changed.
 *  <P>
 * A ResultSet defaults to using data paging, setting {@link com.smartgwt.client.data.DSRequest#getStartRow
 * DSRequest.startRow} and
 * {@link com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow} in issued dsRequests.  Server code may always
 * return more rows than
 *  the ResultSet requests and the ResultSet will correctly integrate those rows based on
 * {@link com.smartgwt.client.data.DSResponse#getStartRow DSResponse.startRow}/{@link
 * com.smartgwt.client.data.DSResponse#getEndRow endRow}.  
 *  Hence the server can always avoid paging mode by simply returning all matching rows.
 *  <P>
 *  A ResultSet can be created directly with just the ID of a {@link com.smartgwt.client.data.DataSource}:
 *  
 *  
 *  <pre>
 *       ResultSet resultSet = new ResultSet();
 *       resultSet.setDataSource(dataSourceID);
 *  </pre>
 *  
 *  <P>
 *  Directly created ResultSets are typically used by custom components, or as a means of
 *  managing datasets that will be used by several components.
 *  <P>
 *  When created directly rather than via a dataBoundComponent, a newly created ResultSet will
 *  not issue it's first "fetch" {@link com.smartgwt.client.data.DSRequest} until data is accessed (for example, via
 *  {@link com.smartgwt.client.data.ResultSet#get get()}).  
 *  <P>
 *  <b>Paging and total dataset length</b>
 *  <P>
 *  When using data paging, the server communicates the total number of records that match the
 * current search criteria by setting {@link com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows}.  The
 * ResultSet will then
 *  return this number from {@link com.smartgwt.client.data.ResultSet#getLength getLength()}, and ListGrids and other
 *  components will show a scrollbar that allows the user to jump to the end of the dataset
 *  directly.
 *  <P>
 *  However, the ResultSet does not require that the server calculate the true length of the
 *  dataset, which can be costly for an extremely large, searchable dataset.  Instead, the
 *  server <i>may</i> advertise a <code>totalRows</code> value that is one page larger
 *  than the last row loaded.  This results in a UI sometimes called "progressive loading",
 *  where the user may load more rows by scrolling past the end of the currently loaded rows,
 *  but is not allowed to skip to the end of the dataset.
 *  <P>
 *  The Smart GWT server offers built in support for progressive loading at the 
 *  {@link com.smartgwt.client.data.DataSource#getProgressiveLoading dataSource},
 *  {@link com.smartgwt.client.docs.serverds.OperationBinding#progressiveLoading operationBinding} and
 *  {@link com.smartgwt.client.data.DSRequest#getProgressiveLoading request} level for SQL-backed dataSources.
 * Setting {@link com.smartgwt.client.data.ResultSet#getProgressiveLoading progressiveLoading} or {@link
 * com.smartgwt.client.widgets.DataBoundComponent#getProgressiveLoading DataBoundComponent.progressiveLoading} to
 *  true will also enable this feature where available.
 *  <P>
 *  Where available, progressive loading will also be enabled automatically
 *  for very large data sets if a
 * {@link com.smartgwt.client.docs.serverds.DataSource#progressiveLoadingThreshold DataSource.progressiveLoadingThreshold}
 * is specified.
 *  <P>
 *  Note that the Smart GWT server is not a requirement for progressive loading -
 *  any DataSource implementation can enable progressive loading by simply populating 
 *  the {@link com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows} property with an appropriate value. 
 * We recommend the {@link com.smartgwt.client.data.DSResponse#getProgressiveLoading DSResponse.progressiveLoading}
 * attribute be set to true
 *  as well - this allows client side logic to treat the reported totalRows 
 *  value specially if necessary.
 *  <P>
 *  No client-side settings are required to enable this mode - it is entirely server-driven.
 * However, it is usually coupled with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSort disabling sorting},
 * since
 *  server-side sorting would also force the server to traverse the entire dataset.
 *  <P>
 *  <b>Client-side Sorting and Filtering</b>
 *  <P>
 *  If a ResultSet obtains a full cache for the current set of filter criteria, it will 
 *  automatically switch to client-side sorting, and will also use client-side filtering 
 *  if the filter criteria are later changed but appear to be <i>more restrictive</i> than the
 *  criteria in use when the ResultSet obtained a full cache.
 *  <P>
 *  The {@link com.smartgwt.client.data.ResultSet#getUseClientSorting useClientSorting} and 
 *  {@link com.smartgwt.client.data.ResultSet#getUseClientFiltering useClientFiltering} flags can be used to disable
 *  client-side sorting and filtering respectively if these behaviors don't match server-based
 *  sorting and filtering.  However, because client-side sorting and filtering radically improve
 *  responsiveness and reduce server load, it is better to customize the ResultSet so that it
 *  can match server-side sorting and filtering behaviors.
 *  <P>
 *  Sorting behavior is primarily customized via the "sort normalizer" passed to
 * {@link com.smartgwt.client.data.ResultSet#sortByProperty sortByProperty()}, either via direct calls on a standalone
 * ResultSet, or via
 * {@link com.smartgwt.client.widgets.grid.ListGridField#sortNormalizer ListGridField.sortNormalizer()} for a
 * ListGrid-managed ResultSet.
 *  <P>
 *  By default, client-side filtering interprets the {@link com.smartgwt.client.data.Criteria criteria} passed to
 *  {@link com.smartgwt.client.data.ResultSet#setCriteria setCriteria()} as a set of field values that records must match
 *  (similarly to the built-in SQL/Hibernate connectors built into the Smart GWT Server).
 *  Custom client-side filtering logic can be implemented by overriding
 *  {@link com.smartgwt.client.data.ResultSet#applyFilter applyFilter()}.  Overriding
 *  {@link com.smartgwt.client.data.ResultSet#compareCriteria compareCriteria()} allows you to control when the ResultSet
 *  uses client-side vs server-side filtering, and the ResultSet has two default 
 *  {@link com.smartgwt.client.data.ResultSet#getCriteriaPolicy criteria policies} built-in.
 *  <P>
 *  <b>Modifying ResultSets</b>
 *  <P>
 *  Records cannot be directly added or removed from a ResultSet via {@link com.smartgwt.client.data.List}
 *  APIs such as {@link com.smartgwt.client.data.List#removeAt removeAt()}, unless it always filters locally, since
 *  this would break the consistency of server and client row numbering needed for data paging,
 *  and also create some issues with automatic cache synchronization.  Set 
 * {@link com.smartgwt.client.data.ResultSet#getModifiable modifiable} to enable the {@link com.smartgwt.client.data.List}
 * modification APIs on a
 *  {@link com.smartgwt.client.data.ResultSet#getFetchMode fetchMode}:"local" ResultSet. Note that the special 
 *  {@link com.smartgwt.client.data.FilteredList} class sets this property to allow developers to modify its data.
 *  <P>
 * Use {@link com.smartgwt.client.data.DataSource#addData DataSource.addData()}/{@link
 * com.smartgwt.client.data.DataSource#removeData removeData()} to add/remove
 *  rows from the {@link com.smartgwt.client.data.DataSource}, and the ResultSet will reflect the changes automatically.
 * Alternatively, the {@link com.smartgwt.client.data.DataSource#updateCaches DataSource.updateCaches()} method may be
 * called to only update
 *  local caches of the DataSource in question, without generating any server traffic.
 *  <P>
 *  To create a locally modifiable cache of Records from a DataSource, you
 * can use {@link com.smartgwt.client.data.DataSource#fetchData DataSource.fetchData()} to retrieve a List of Records which
 * can
 *  be modified directly, or you can create a client-only {@link com.smartgwt.client.data.DataSource} from
 *  the retrieved data to share a modifiable cache between several
 *  DataBoundComponents.
 *  <P>
 *  <b>Updates and Automatic Cache Synchronization</b>
 *  <P>
 *  Once a ResultSet has retrieved data or has been initialized with data, the ResultSet will observe any
 *  successful "update", "add" or "remove" dsRequests against their DataSource, regardless of the
 *  component that initiated them.  A ResultSet with a full cache for the current filter criteria will
 *  integrate updates into the cache automatically.
 *  <P>
 *  Updated rows that no longer match the current filter criteria will be removed
 * automatically.  To prevent this, you can set {@link com.smartgwt.client.data.ResultSet#getNeverDropUpdatedRows
 * neverDropUpdatedRows}.
 *  Added rows will similarly be added to the cache only if they match current filter criteria.
 *  <P>
 *  Note that the client-side filtering described above is also used to determine whether 
 *  updated or added rows should be in the cache.  If any aspect of automated cache update is
 *  ever incorrect, {@link com.smartgwt.client.data.ResultSet#getDropCacheOnUpdate dropCacheOnUpdate} can be set for the
 * ResultSet or {@link com.smartgwt.client.data.DSResponse#getInvalidateCache DSResponse.invalidateCache} can be set for an
 * individual dsResponse.
 *  <P>
 *  If automatic cache synchronization isn't working, troubleshoot the problem using the steps
 *  suggested <a href='http://forums.smartclient.com/showthread.php?t=8159#aGrid' target='_blank'>in the FAQ</a>.
 *  <P>
 *  Regarding {@link com.smartgwt.client.data.OperationBinding#getOperationId operationIds} and how they affect caching,
 *  take into account that cache sync is based on the fetch used - any add or update operation
 *  uses a fetch to retrieve updated data, and the operationId of that fetch can be set via
 *  {@link com.smartgwt.client.data.OperationBinding#getCacheSyncOperation cacheSyncOperation}.
 *  If the operationId of the cache is different from the operationId of the cache update data,
 *  it won't be used to update the cache, since the fields included and other aspects of the
 *  data are allowed to be different across different operationIds. This allows to maintain
 *  distinct caches on a per component basis, so when two components are using separate
 *  operationIds they are assumed to have distinct caches, because updates performed with
 *  one operationId will not affect the cache obtained via another operationId.
 *  Also, take into account that operationId must be unique per DataSource, across all
 *  operationTypes for that DataSource.
 * 
 *  <P>
 *  <b>Data Paging with partial cache</b>
 *  <P>
 *  When in paging mode with a partial cache, a ResultSet relies on server side sorting, setting 
 * {@link com.smartgwt.client.data.DSRequest#getSortBy DSRequest.sortBy} to the current sort field and direction.  In order
 * for the cache to 
 *  remain coherent, row numbering must continue to agree between server and client as new
 *  fetches are issued, otherwise, duplicate rows or missing rows may occur.  
 *  <P>
 *  If concurrent modifications by other users are allowed, generally the server should set
 * {@link com.smartgwt.client.data.DSResponse#getInvalidateCache DSResponse.invalidateCache} to clear the cache when
 * concurrent modification is
 *  detected.
 *  <P>
 *  In paging mode with a partial cache, any successful "update" or "add" operation may cause
 *  client and server row numbering to become out of sync.  This happens because the update
 *  may affect the sort order, and client and server cannot be guaranteed to match for sets of
 *  records that have equivalent values for the sort field.
 *  <P>
 *  For this reason, after an "add" or "update" operation with a partial cache, the ResultSet
 *  will automatically mark cache for invalidation the next time a fetch operation is performed.
 * Alternatively, if {@link com.smartgwt.client.data.ResultSet#getUpdatePartialCache updatePartialCache} is set to false,
 * the ResultSet will
 *  simply invalidate cache immediately in this circumstance.
 * @see com.smartgwt.client.widgets.DataBoundComponent
 * @see com.smartgwt.client.data.DataSource#getResultSetClass
 * @see com.smartgwt.client.data.ResultSet#getRange
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("ResultSet")
public class ResultSet extends RecordList implements com.smartgwt.client.data.events.HasDataArrivedHandlers {

    public static ResultSet getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (ResultSet) obj;
        } else {
            return new ResultSet(jsObj);
        }
    }

    public void setJavaScriptObject(JavaScriptObject jsObj) {
        internalSetID(jsObj);
        JSOHelper.setObjectAttribute(jsObj, SC.REF, this);
        JSOHelper.setObjectAttribute(jsObj, SC.MODULE, BeanFactory.getSGWTModule());
        if (!JSOHelper.isScClassInstance(jsObj)) {
            setConfig(jsObj);
            return;
        }
        JSOHelper.setObjectAttribute(getConfig(), SC.REF, this);
        JSOHelper.setObjectAttribute(getConfig(), SC.MODULE, BeanFactory.getSGWTModule());
        this.jsObj = jsObj;
        onBind();
    }
        


    public ResultSet(){
        scClassName = "ResultSet";
    }

    public ResultSet(JavaScriptObject jsObj){
        super(jsObj);
        scClassName = "ResultSet";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        if (this.@com.smartgwt.client.data.ResultSet::ensuringCreated) {
            var selfJ = this;
            return $wnd.isc.ResultSet.create(config, {
                init : $entry(function () {
                    selfJ.@com.smartgwt.client.data.RecordList::jsObj = this;
                    return this.Super("init", arguments);
                })
            });
        }
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * If the complete set of records for a resultSet is available when the resultSet is created, it can be made available to
     * the resultSet via this property at initialization time. This data will then be considered cached meaning sorting and
     * filtering can occur on the client (no need for server fetch). <p> This cached data can be dropped via a call to {@link
     * com.smartgwt.client.data.ResultSet#invalidateCache invalidateCache()}. <p> See also {@link
     * com.smartgwt.client.data.ResultSet#getInitialData initialData} and {@link
     * com.smartgwt.client.data.ResultSet#getInitialLength initialLength} as an alternative approach for initializing a
     * ResultSet with a partial cache, such that data paging will occur as uncached rows are requested. <P> Note that
     * developers wishing to synchronously access a filtered set of client side data may wish to consider creating a {@link
     * com.smartgwt.client.data.FilteredList}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.data.ResultSet#getAllRows allRows} client-side cache of data at runtime. <P> This method is useful for cases where a full, unfiltered set of data is present on the client and developers wish to filter that data-set locally without going through a fetch operation against a DataSource. <P> Developers using this pattern may also wish to consider the {@link com.smartgwt.client.data.FilteredList} class.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param allRows New set of unfiltered cache data. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setAllRows(Record... allRows)  throws IllegalStateException {
        return (ResultSet)setAttribute("allRows", allRows, false);
    }

    /**
     * If the complete set of records for a resultSet is available when the resultSet is created, it can be made available to
     * the resultSet via this property at initialization time. This data will then be considered cached meaning sorting and
     * filtering can occur on the client (no need for server fetch). <p> This cached data can be dropped via a call to {@link
     * com.smartgwt.client.data.ResultSet#invalidateCache invalidateCache()}. <p> See also {@link
     * com.smartgwt.client.data.ResultSet#getInitialData initialData} and {@link
     * com.smartgwt.client.data.ResultSet#getInitialLength initialLength} as an alternative approach for initializing a
     * ResultSet with a partial cache, such that data paging will occur as uncached rows are requested. <P> Note that
     * developers wishing to synchronously access a filtered set of client side data may wish to consider creating a {@link
     * com.smartgwt.client.data.FilteredList}.
     *
     * @return Current allRows value. Default value is null
     */
    public Record[] getAllRows()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfRecord(getAttributeAsJavaScriptObject("allRows"));
    }
    

    /**
     * If true, records requested only for visible area.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param alwaysRequestVisibleRows New alwaysRequestVisibleRows value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setAlwaysRequestVisibleRows(Boolean alwaysRequestVisibleRows)  throws IllegalStateException {
        return (ResultSet)setAttribute("alwaysRequestVisibleRows", alwaysRequestVisibleRows, false);
    }

    /**
     * If true, records requested only for visible area.
     *
     * @return Current alwaysRequestVisibleRows value. Default value is false
     */
    public Boolean getAlwaysRequestVisibleRows()  {
        Boolean result = getAttributeAsBoolean("alwaysRequestVisibleRows");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading} is active for a ResultSet we may
     * not know the true size of the data set being displayed. <P> However the exact length may be known thanks to {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows}  containing an exact row count,
     * or due to an explicit {@link com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch} having been performed.
     * <P> If we have an accurate, exact row count, should this be applied to our {@link
     * com.smartgwt.client.data.ResultSet#getLength length} automatically? Doing so means that if this ResultSet is displayed
     * in a {@link com.smartgwt.client.widgets.grid.ListGrid},  the scrollable area will reflect the true size of the data set
     * and the user may drag-scroll all the way to the end of this data set. Depending on how the server side data storage is
     * implemented and the generated request, requesting row ranges starting at a very large  index can be expensive, so this
     * is not always desirable.  <P> Note that developers may always explicitly tell a ResultSet the true size of its data set
     * while progressive loading is active via {@link com.smartgwt.client.data.ResultSet#setFullLength setFullLength()}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param applyRowCountToLength New applyRowCountToLength value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public ResultSet setApplyRowCountToLength(boolean applyRowCountToLength)  throws IllegalStateException {
        return (ResultSet)setAttribute("applyRowCountToLength", applyRowCountToLength, false);
    }

    /**
     * If {@link com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading} is active for a ResultSet we may
     * not know the true size of the data set being displayed. <P> However the exact length may be known thanks to {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows}  containing an exact row count,
     * or due to an explicit {@link com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch} having been performed.
     * <P> If we have an accurate, exact row count, should this be applied to our {@link
     * com.smartgwt.client.data.ResultSet#getLength length} automatically? Doing so means that if this ResultSet is displayed
     * in a {@link com.smartgwt.client.widgets.grid.ListGrid},  the scrollable area will reflect the true size of the data set
     * and the user may drag-scroll all the way to the end of this data set. Depending on how the server side data storage is
     * implemented and the generated request, requesting row ranges starting at a very large  index can be expensive, so this
     * is not always desirable.  <P> Note that developers may always explicitly tell a ResultSet the true size of its data set
     * while progressive loading is active via {@link com.smartgwt.client.data.ResultSet#setFullLength setFullLength()}
     *
     * @return Current applyRowCountToLength value. Default value is false
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public boolean getApplyRowCountToLength()  {
        Boolean result = getAttributeAsBoolean("applyRowCountToLength");
        return result == null ? false : result;
    }
    

    /**
     * If this ResultSet does not know its length due to {@link com.smartgwt.client.data.DataSource#getProgressiveLoading
     * DataSource.progressiveLoading}, should a {@link com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch}
     * automatically when data is loaded? <P> The fetch will be issued when the first page of data arrives from the server as
     * part of a progressive-loading response. If the cache is invalidated or the criteria change, a new row count fetch will
     * be issued automatically when new data arrives that does not have an accurate row count.
     *
     * @param autoFetchRowCount New autoFetchRowCount value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setAutoFetchRowCount(boolean autoFetchRowCount) {
        return (ResultSet)setAttribute("autoFetchRowCount", autoFetchRowCount, true);
    }

    /**
     * If this ResultSet does not know its length due to {@link com.smartgwt.client.data.DataSource#getProgressiveLoading
     * DataSource.progressiveLoading}, should a {@link com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch}
     * automatically when data is loaded? <P> The fetch will be issued when the first page of data arrives from the server as
     * part of a progressive-loading response. If the cache is invalidated or the criteria change, a new row count fetch will
     * be issued automatically when new data arrives that does not have an accurate row count.
     *
     * @return Current autoFetchRowCount value. Default value is false
     */
    public boolean getAutoFetchRowCount()  {
        Boolean result = getAttributeAsBoolean("autoFetchRowCount");
        return result == null ? false : result;
    }
    

    /**
     * Will the {@link com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch operation} block user interaction by
     * having {@link com.smartgwt.client.rpc.RPCRequest#getShowPrompt showPrompt:true}?
     *
     * @param blockingRowCountFetch New blockingRowCountFetch value. Default value is true
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public ResultSet setBlockingRowCountFetch(boolean blockingRowCountFetch)  throws IllegalStateException {
        return (ResultSet)setAttribute("blockingRowCountFetch", blockingRowCountFetch, false);
    }

    /**
     * Will the {@link com.smartgwt.client.data.ResultSet#fetchRowCount row count fetch operation} block user interaction by
     * having {@link com.smartgwt.client.rpc.RPCRequest#getShowPrompt showPrompt:true}?
     *
     * @return Current blockingRowCountFetch value. Default value is true
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public boolean getBlockingRowCountFetch()  {
        Boolean result = getAttributeAsBoolean("blockingRowCountFetch");
        return result == null ? true : result;
    }
    

    /**
     * Filter criteria used whenever records are retrieved. <P> Use {@link com.smartgwt.client.data.ResultSet#setCriteria
     * setCriteria()} to change the criteria after initialization.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Set the filter criteria to use when fetching rows. <P> Depending on the result of {@link com.smartgwt.client.data.ResultSet#compareCriteria compareCriteria()} and settings for {@link com.smartgwt.client.data.ResultSet#getUseClientFiltering useClientFiltering} / {@link com.smartgwt.client.types.FetchMode}, setting criteria may cause a trip to the server to get a new set of rows, or may simply cause already-fetched rows to be re-filtered according to the new Criteria.  In either case, the dataset length available from {@link com.smartgwt.client.data.ResultSet#getLength getLength()} may change and rows will appear at different indices. <P> The filter criteria can be changed while server fetches for data matching the old criteria are still outstanding.  If this is the case, the ResultSet will make sure that any records received matching the old criteria are not added to the cache for the new criteria.  Any callbacks for responses to the outstanding requests are fired as normal, and the responses' {@link com.smartgwt.client.data.DSResponse#getTotalRows totalRows} counts are kept (as they are still potentially meaningful to components using the ResultSet), but the response data is cleared so that it won't be used inadvertently as data matching the new criteria. <P> Note: for simple Criteria, any field values in the criteria explicitly specified as null will be passed to the server.  By default the server then returns only records whose value is null for that field. This differs from certain higher level methods such as  {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} which prune null criteria fields before performing a fetch operation.
     *
     * @param criteria the filter criteria. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setCriteria(Criteria criteria) {
        if (criteria instanceof Criterion) {
            criteria.setAttribute("_constructor", "AdvancedCriteria");
        }
        return (ResultSet)setAttribute("criteria", criteria == null ? null : criteria.getJsObj(), true);
    }

    /**
     * Filter criteria used whenever records are retrieved. <P> Use {@link com.smartgwt.client.data.ResultSet#setCriteria
     * setCriteria()} to change the criteria after initialization.
     *
     * @return Get the current criteria for this ResultSet. Default value is null
     */
    public Criteria getCriteria()  {
        return new Criteria(getAttributeAsJavaScriptObject("criteria"));
    }
    

    /**
     * Decides under what conditions the cache should be dropped when the {@link com.smartgwt.client.data.Criteria} changes.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param criteriaPolicy New criteriaPolicy value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @see com.smartgwt.client.data.Criteria
     * @see com.smartgwt.client.data.DataSource#setCriteriaPolicy
     */
    public ResultSet setCriteriaPolicy(CriteriaPolicy criteriaPolicy) {
        return (ResultSet)setAttribute("criteriaPolicy", criteriaPolicy == null ? null : criteriaPolicy.getValue(), true);
    }

    /**
     * Decides under what conditions the cache should be dropped when the {@link com.smartgwt.client.data.Criteria} changes.
     *
     * @return Current criteriaPolicy value. Default value is null
     * @see com.smartgwt.client.data.Criteria
     * @see com.smartgwt.client.data.DataSource#getCriteriaPolicy
     */
    public CriteriaPolicy getCriteriaPolicy()  {
        return EnumUtil.getEnum(CriteriaPolicy.values(), getAttribute("criteriaPolicy"));
    }
    

    /**
     * What {@link com.smartgwt.client.data.DataSource} is this resultSet associated with?
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.Databinding DataBinding
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_ds_fields" target="examples">DataSource fields Example</a>
     */
    public ResultSet setDataSource(DataSource dataSource)  throws IllegalStateException {
        return (ResultSet)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj(), false);
    }

    /**
     * What {@link com.smartgwt.client.data.DataSource} is this resultSet associated with?
     *
     * @return Current dataSource value. Default value is null
     * @see com.smartgwt.client.docs.Databinding DataBinding
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_ds_fields" target="examples">DataSource fields Example</a>
     */
    public DataSource getDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("dataSource"));
    }
    

    /**
     * By default when the data of this ResultSet's dataSource is modified, the ResultSet will be updated to display these
     * changes. Set this flag to true to disable this behavior.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param disableCacheSync New disableCacheSync value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setDisableCacheSync(Boolean disableCacheSync)  throws IllegalStateException {
        return (ResultSet)setAttribute("disableCacheSync", disableCacheSync, false);
    }

    /**
     * By default when the data of this ResultSet's dataSource is modified, the ResultSet will be updated to display these
     * changes. Set this flag to true to disable this behavior.
     *
     * @return Current disableCacheSync value. Default value is false
     */
    public Boolean getDisableCacheSync()  {
        Boolean result = getAttributeAsBoolean("disableCacheSync");
        return result == null ? false : result;
    }
    

    /**
     * Whether to discard all cached rows when a modification operation (add, update, remove) occurs on the ResultSet's
     * DataSource. <P> A ResultSet that has a complete cache for the current filter criteria can potentially incorporate a
     * newly created or updated row based on the data that the server returns when a modification operation completes.  However
     * this is not always possible for ResultSets that show some types of joins, or when the server cannot easily return update
     * data.  In this case set <code>dropCacheOnUpdate</code> to cause the cache to be discarded when an update occurs. <P>
     * <code>dropCacheOnUpdate</code> can be set either directly on a ResultSet, or on a DataSource in order to affect all
     * ResultSets on that DataSource.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dropCacheOnUpdate New dropCacheOnUpdate value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setDropCacheOnUpdate(Boolean dropCacheOnUpdate)  throws IllegalStateException {
        return (ResultSet)setAttribute("dropCacheOnUpdate", dropCacheOnUpdate, false);
    }

    /**
     * Whether to discard all cached rows when a modification operation (add, update, remove) occurs on the ResultSet's
     * DataSource. <P> A ResultSet that has a complete cache for the current filter criteria can potentially incorporate a
     * newly created or updated row based on the data that the server returns when a modification operation completes.  However
     * this is not always possible for ResultSets that show some types of joins, or when the server cannot easily return update
     * data.  In this case set <code>dropCacheOnUpdate</code> to cause the cache to be discarded when an update occurs. <P>
     * <code>dropCacheOnUpdate</code> can be set either directly on a ResultSet, or on a DataSource in order to affect all
     * ResultSets on that DataSource.
     *
     * @return Current dropCacheOnUpdate value. Default value is false
     */
    public Boolean getDropCacheOnUpdate()  {
        Boolean result = getAttributeAsBoolean("dropCacheOnUpdate");
        return result == null ? false : result;
    }
    

    /**
     * Delay in milliseconds before fetching rows. <P> When a get() or getRange() call asked for rows that haven't been loaded,
     * the ResultSet will wait before actually triggering the request.  If, during the delay, more get() or getRange() calls
     * are made for missing rows, the final fetch to the server will reflect the most recently requested rows. <P> The intent
     * of this delay is to avoid triggering many unnecessary fetches during drag-scrolling and similar user interactions.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fetchDelay New fetchDelay value. Default value is 0
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setFetchDelay(int fetchDelay) {
        return (ResultSet)setAttribute("fetchDelay", fetchDelay, true);
    }

    /**
     * Delay in milliseconds before fetching rows. <P> When a get() or getRange() call asked for rows that haven't been loaded,
     * the ResultSet will wait before actually triggering the request.  If, during the delay, more get() or getRange() calls
     * are made for missing rows, the final fetch to the server will reflect the most recently requested rows. <P> The intent
     * of this delay is to avoid triggering many unnecessary fetches during drag-scrolling and similar user interactions.
     *
     * @return Current fetchDelay value. Default value is 0
     */
    public int getFetchDelay()  {
        return getAttributeAsInt("fetchDelay");
    }
    

    /**
     * Mode of fetching records from the server. If unset, will default to <code>"local"</code> if {@link
     * com.smartgwt.client.data.ResultSet#getAllRows allRows} is specified, otherwise <code>"paged"</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fetchMode New fetchMode value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.types.FetchMode
     */
    public ResultSet setFetchMode(FetchMode fetchMode)  throws IllegalStateException {
        return (ResultSet)setAttribute("fetchMode", fetchMode == null ? null : fetchMode.getValue(), false);
    }

    /**
     * Mode of fetching records from the server. If unset, will default to <code>"local"</code> if {@link
     * com.smartgwt.client.data.ResultSet#getAllRows allRows} is specified, otherwise <code>"paged"</code>.
     *
     * @return Current fetchMode value. Default value is null
     * @see com.smartgwt.client.types.FetchMode
     */
    public FetchMode getFetchMode()  {
        return EnumUtil.getEnum(FetchMode.values(), getAttribute("fetchMode"));
    }
    

    /**
     * The {@link com.smartgwt.client.data.DSRequest#getOperationId operationId} this ResultSet should use when performing
     * fetch operations. <P> <b>Note:</b> if this property is not explicitly set and, for ResultSets automatically created by a
     * component, {@link com.smartgwt.client.widgets.DataBoundComponent#getFetchOperation DataBoundComponent.fetchOperation} is
     * also unset, a placeholder value of &lt;dataSourceId&gt;_&lt;operationType&gt; may be reported (e.g. "supplyItem_fetch").
     *
     * @param fetchOperation New fetchOperation value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setFetchOperation(String fetchOperation)  throws IllegalStateException {
        return (ResultSet)setAttribute("fetchOperation", fetchOperation, false);
    }

    /**
     * The {@link com.smartgwt.client.data.DSRequest#getOperationId operationId} this ResultSet should use when performing
     * fetch operations. <P> <b>Note:</b> if this property is not explicitly set and, for ResultSets automatically created by a
     * component, {@link com.smartgwt.client.widgets.DataBoundComponent#getFetchOperation DataBoundComponent.fetchOperation} is
     * also unset, a placeholder value of &lt;dataSourceId&gt;_&lt;operationType&gt; may be reported (e.g. "supplyItem_fetch").
     *
     * @return Current fetchOperation value. Default value is null
     */
    public String getFetchOperation()  {
        return getAttributeAsString("fetchOperation");
    }
    

    /**
     * Criteria that are never shown to or edited by the user and are cumulative with any  criteria provided via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getInitialCriteria DataBoundComponent.initialCriteria}, {@link
     * com.smartgwt.client.data.ResultSet#setCriteria setCriteria()} etc.
     *
     * @param implicitCriteria New implicitCriteria value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setImplicitCriteria(Criteria implicitCriteria) {
        if (implicitCriteria instanceof Criterion) {
            implicitCriteria.setAttribute("_constructor", "AdvancedCriteria");
        }
        return (ResultSet)setAttribute("implicitCriteria", implicitCriteria == null ? null : implicitCriteria.getJsObj(), true);
    }

    /**
     * Criteria that are never shown to or edited by the user and are cumulative with any  criteria provided via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getInitialCriteria DataBoundComponent.initialCriteria}, {@link
     * com.smartgwt.client.data.ResultSet#setCriteria setCriteria()} etc.
     *
     * @return Current implicitCriteria value. Default value is null
     */
    public Criteria getImplicitCriteria()  {
        return new Criteria(getAttributeAsJavaScriptObject("implicitCriteria"));
    }
    

    /**
     * List of property names to create indexes for. Property indexes accelerate find operations by providing O(1) Map-based
     * lookups instead of O(n) linear scans. Indexes are only built for cached records and do not trigger fetches. <P> When
     * data is partially loaded (paging), indexes only contain entries for loaded records. This means find operations may
     * return null even though matching records exist on the server but have not been loaded yet. To ensure complete results,
     * either: <ul> <li>Use {@link com.smartgwt.client.data.ResultSet#allRowsCached allRowsCached()} to verify all data is
     * loaded before relying on     indexed find operations</li> <li>Set {@link com.smartgwt.client.data.ResultSet#getFetchMode
     * fetchMode} to "local" to ensure complete data is available</li> </ul> Indexes are automatically maintained as records
     * are added, removed, or updated in the cache.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param indexedProperties New indexedProperties value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.Caching Caching
     */
    public ResultSet setIndexedProperties(String... indexedProperties)  throws IllegalStateException {
        return (ResultSet)setAttribute("indexedProperties", indexedProperties, false);
    }

    /**
     * List of property names to create indexes for. Property indexes accelerate find operations by providing O(1) Map-based
     * lookups instead of O(n) linear scans. Indexes are only built for cached records and do not trigger fetches. <P> When
     * data is partially loaded (paging), indexes only contain entries for loaded records. This means find operations may
     * return null even though matching records exist on the server but have not been loaded yet. To ensure complete results,
     * either: <ul> <li>Use {@link com.smartgwt.client.data.ResultSet#allRowsCached allRowsCached()} to verify all data is
     * loaded before relying on     indexed find operations</li> <li>Set {@link com.smartgwt.client.data.ResultSet#getFetchMode
     * fetchMode} to "local" to ensure complete data is available</li> </ul> Indexes are automatically maintained as records
     * are added, removed, or updated in the cache.
     *
     * @return Current indexedProperties value. Default value is null
     * @see com.smartgwt.client.docs.Caching Caching
     */
    public String[] getIndexedProperties()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("indexedProperties"));
    }
    

    /**
     * Whether to automatically maintain property indices on filtered data (localData) when client-side filtering narrows the
     * visible dataset from the complete cache (allRows). <P> When this feature is enabled and property indices have been
     * created via {@link com.smartgwt.client.data.ResultSet#createIndex createIndex()}, the ResultSet will automatically build
     * and maintain secondary indices on the filtered dataset whenever localData becomes a subset of allRows due to more
     * restrictive criteria. <P> This provides O(1) performance for {@link com.smartgwt.client.data.ResultSet#find find()},
     * {@link com.smartgwt.client.data.ResultSet#findAll findAll()}, and {@link
     * com.smartgwt.client.data.ResultSet#getUniquePropertyValues getUniquePropertyValues()} operations on filtered data,
     * rather than requiring linear scans of the filtered dataset. <P> <b>Default behavior:</b> When null (the default),
     * filtered indices are automatically maintained if any property indices have been created via createIndex(). Set
     * explicitly to false to disable this behavior even when indices exist, or true to enable it unconditionally. <P>
     * <b>Automatic maintenance:</b> Filtered indices are: <ul> <li>Built during the existing filtering traversal (no extra
     * iteration cost)</li> <li>Updated automatically when records are added, updated, or removed</li> <li>Invalidated when
     * criteria change to become less restrictive or when the cache is cleared</li> <li>Re-created when criteria narrow further
     * from an already-filtered state</li> </ul> <P> <b>Memory impact:</b> When active, this feature maintains a second set of
     * index structures for the filtered data. For large datasets with many indices, this approximately doubles the memory
     * overhead of indexing. The indices are automatically freed when no longer needed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param indexFilteredData New indexFilteredData value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setIndexFilteredData(Boolean indexFilteredData) {
        return (ResultSet)setAttribute("indexFilteredData", indexFilteredData, true);
    }

    /**
     * Whether to automatically maintain property indices on filtered data (localData) when client-side filtering narrows the
     * visible dataset from the complete cache (allRows). <P> When this feature is enabled and property indices have been
     * created via {@link com.smartgwt.client.data.ResultSet#createIndex createIndex()}, the ResultSet will automatically build
     * and maintain secondary indices on the filtered dataset whenever localData becomes a subset of allRows due to more
     * restrictive criteria. <P> This provides O(1) performance for {@link com.smartgwt.client.data.ResultSet#find find()},
     * {@link com.smartgwt.client.data.ResultSet#findAll findAll()}, and {@link
     * com.smartgwt.client.data.ResultSet#getUniquePropertyValues getUniquePropertyValues()} operations on filtered data,
     * rather than requiring linear scans of the filtered dataset. <P> <b>Default behavior:</b> When null (the default),
     * filtered indices are automatically maintained if any property indices have been created via createIndex(). Set
     * explicitly to false to disable this behavior even when indices exist, or true to enable it unconditionally. <P>
     * <b>Automatic maintenance:</b> Filtered indices are: <ul> <li>Built during the existing filtering traversal (no extra
     * iteration cost)</li> <li>Updated automatically when records are added, updated, or removed</li> <li>Invalidated when
     * criteria change to become less restrictive or when the cache is cleared</li> <li>Re-created when criteria narrow further
     * from an already-filtered state</li> </ul> <P> <b>Memory impact:</b> When active, this feature maintains a second set of
     * index structures for the filtered data. For large datasets with many indices, this approximately doubles the memory
     * overhead of indexing. The indices are automatically freed when no longer needed.
     *
     * @return Current indexFilteredData value. Default value is null
     */
    public Boolean getIndexFilteredData()  {
        return getAttributeAsBoolean("indexFilteredData");
    }
    

    /**
     * Initial set of data for the ResultSet. <P> This data will be treated exactly as though it were the data returned from
     * the ResultSet's first server fetch. <P> By default, <code>initialData</code> will be considered a complete response (all
     * rows that match the {@link com.smartgwt.client.data.Criteria} which the ResultSet was initialized with). <P> Set {@link
     * com.smartgwt.client.data.ResultSet#getInitialLength initialLength} to treat <code>initialData</code> as a partial
     * response, equivalent to receiving a {@link com.smartgwt.client.data.DSResponse} with <code>startRow:0</code>,
     * <code>endRow:initialData.length</code> and <code>totalRows:initialLength</code>. Normal data paging will then occur if
     * data is requested for row indices not filled via  <code>initialData</code>. <P> <code>initialData</code> may be provided
     * as a "sparse" array, that is, slots may be left null indicating rows that have not been loaded.  In this way you can
     * create a ResultSet that is missing rows at the beginning of the dataset, but has loaded rows toward the end, so that you
     * can create a component that is scrolled to a particular position of a dataset without loading rows at the beginning. <P>
     * To keep the logic simple and support partial <code>initialData</code>, the data is assumed to be already sorted and
     * filtered according to the {@link com.smartgwt.client.data.ResultSet#getSortSpecifiers sortSpecifiers} and {@link
     * com.smartgwt.client.data.ResultSet#getCriteria criteria} supplied to the ResultSet, since otherwise, for partial
     * <code>initialData</code>, sorting or filtering would immediately cause the data to be discarded. <P> If
     * <code>initialData</code> is complete and needs to be sorted or filtered, then don't pass the {@link
     * com.smartgwt.client.data.ResultSet#getSortSpecifiers sortSpecifiers} or {@link
     * com.smartgwt.client.data.ResultSet#getCriteria criteria}, respectively, when creating the ResultSet.  Instead, call
     * {@link com.smartgwt.client.data.ResultSet#setCriteria setCriteria()} or {@link
     * com.smartgwt.client.data.ResultSet#setSort setSort()}, respectively, on the instance afterwards.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param initialData New initialData value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.data.ResultSet#setFetchMode
     * @see com.smartgwt.client.data.ResultSet#setUseClientFiltering
     */
    public ResultSet setInitialData(Record... initialData)  throws IllegalStateException {
        return (ResultSet)setAttribute("initialData", initialData, false);
    }
    

    /**
     * Initial value of the data set length. <P> To create a ResultSet with it's cache partly filled, see {@link
     * com.smartgwt.client.data.ResultSet#getInitialData initialData}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param initialLength New initialLength value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setInitialLength(Integer initialLength)  throws IllegalStateException {
        return (ResultSet)setAttribute("initialLength", initialLength, false);
    }
    

    /**
     * When true, allows the ResultSet to be modified by list APIs {@link com.smartgwt.client.data.List#addAt List.addAt()},
     * {@link com.smartgwt.client.data.List#set List.set()}, and {@link com.smartgwt.client.data.List#removeAt
     * List.removeAt()}.  Only applies to  {@link com.smartgwt.client.data.ResultSet#getFetchMode fetchMode}:"local"
     * ResultSets, since in all other cases, such modifications would break the consistency of server and client row numbering
     * needed for data paging, and also create some issues with automatic cache synchronization.  See the "Modifying
     * ResultSets" subtopic in the {@link com.smartgwt.client.data.ResultSet ResultSet Overview} for the alternative approach
     * of updating the {@link com.smartgwt.client.data.DataSource}. <P> One known case where modification can be useful is when
     * an array has been passed to {@link com.smartgwt.client.widgets.grid.ListGrid#setData ListGrid.setData()} for a ListGrid
     * with {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData ListGrid.filterLocalData}:true.  If the data is
     * filtered using the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filterEditor}, then a new local
     * ResultSet will be created as {@link com.smartgwt.client.widgets.grid.ListGrid#getData data} to reflect the filtering.
     *
     * @param modifiable New modifiable value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @see com.smartgwt.client.data.DataSource#addData
     * @see com.smartgwt.client.data.DataSource#removeData
     * @see com.smartgwt.client.data.DataSource#updateCaches
     */
    public ResultSet setModifiable(boolean modifiable) {
        return (ResultSet)setAttribute("modifiable", modifiable, true);
    }

    /**
     * When true, allows the ResultSet to be modified by list APIs {@link com.smartgwt.client.data.List#addAt List.addAt()},
     * {@link com.smartgwt.client.data.List#set List.set()}, and {@link com.smartgwt.client.data.List#removeAt
     * List.removeAt()}.  Only applies to  {@link com.smartgwt.client.data.ResultSet#getFetchMode fetchMode}:"local"
     * ResultSets, since in all other cases, such modifications would break the consistency of server and client row numbering
     * needed for data paging, and also create some issues with automatic cache synchronization.  See the "Modifying
     * ResultSets" subtopic in the {@link com.smartgwt.client.data.ResultSet ResultSet Overview} for the alternative approach
     * of updating the {@link com.smartgwt.client.data.DataSource}. <P> One known case where modification can be useful is when
     * an array has been passed to {@link com.smartgwt.client.widgets.grid.ListGrid#setData ListGrid.setData()} for a ListGrid
     * with {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterLocalData ListGrid.filterLocalData}:true.  If the data is
     * filtered using the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filterEditor}, then a new local
     * ResultSet will be created as {@link com.smartgwt.client.widgets.grid.ListGrid#getData data} to reflect the filtering.
     *
     * @return Current modifiable value. Default value is false
     * @see com.smartgwt.client.data.DataSource#addData
     * @see com.smartgwt.client.data.DataSource#removeData
     * @see com.smartgwt.client.data.DataSource#updateCaches
     */
    public boolean getModifiable()  {
        Boolean result = getAttributeAsBoolean("modifiable");
        return result == null ? false : result;
    }
    

    /**
     * By default when a row is returned by the server, the current {@link com.smartgwt.client.data.ResultSet#setCriteria
     * filter\n criteria} are applied to it, and it may disappear from the cache. <P> Set this flag to true to disable this
     * behavior.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param neverDropUpdatedRows New neverDropUpdatedRows value. Default value is false
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setNeverDropUpdatedRows(Boolean neverDropUpdatedRows)  throws IllegalStateException {
        return (ResultSet)setAttribute("neverDropUpdatedRows", neverDropUpdatedRows, false);
    }

    /**
     * By default when a row is returned by the server, the current {@link com.smartgwt.client.data.ResultSet#setCriteria
     * filter\n criteria} are applied to it, and it may disappear from the cache. <P> Set this flag to true to disable this
     * behavior.
     *
     * @return Current neverDropUpdatedRows value. Default value is false
     */
    public Boolean getNeverDropUpdatedRows()  {
        Boolean result = getAttributeAsBoolean("neverDropUpdatedRows");
        return result == null ? false : result;
    }
    

    /**
     * Error message used when the prerequisite generation of missing values in a field was not successful.
     *
     * @param prerequisiteFieldGenerationNotSuccessfulErrorMessage New prerequisiteFieldGenerationNotSuccessfulErrorMessage value. Default value is "The generation of missing values for the ${fieldTitle} field was not successful: ${errorMessage}"
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public ResultSet setPrerequisiteFieldGenerationNotSuccessfulErrorMessage(String prerequisiteFieldGenerationNotSuccessfulErrorMessage) {
        return (ResultSet)setAttribute("prerequisiteFieldGenerationNotSuccessfulErrorMessage", prerequisiteFieldGenerationNotSuccessfulErrorMessage, true);
    }

    /**
     * Error message used when the prerequisite generation of missing values in a field was not successful.
     *
     * @return Current prerequisiteFieldGenerationNotSuccessfulErrorMessage value. Default value is "The generation of missing values for the ${fieldTitle} field was not successful: ${errorMessage}"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getPrerequisiteFieldGenerationNotSuccessfulErrorMessage()  {
        return getAttributeAsString("prerequisiteFieldGenerationNotSuccessfulErrorMessage");
    }
    

    /**
     * Sets {@link com.smartgwt.client.data.DataSource#getProgressiveLoading progressive loading mode} for this ResultSet. Any
     * {@link com.smartgwt.client.data.DSRequest}s issued by this ResultSet will copy this setting onto the request, overriding
     * the OperationBinding- and DataSource-level settings. <P> This setting is applied automatically by {@link
     * com.smartgwt.client.widgets.DataBoundComponent}s that have their  own explicit setting for {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getProgressiveLoading progressiveLoading} <P> See also the {@link
     * com.smartgwt.client.data.ResultSet#getRememberDynamicProgressiveLoading rememberDynamicProgressiveLoading} attribute.
     *
     * @param progressiveLoading New progressiveLoading value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @see com.smartgwt.client.data.DataSource#setProgressiveLoading
     * @see com.smartgwt.client.docs.serverds.OperationBinding#progressiveLoading
     * @see com.smartgwt.client.data.DSRequest#setProgressiveLoading
     * @see com.smartgwt.client.docs.ProgressiveLoading Progressive Loading
     */
    public ResultSet setProgressiveLoading(Boolean progressiveLoading) {
        return (ResultSet)setAttribute("progressiveLoading", progressiveLoading, true);
    }

    /**
     * Sets {@link com.smartgwt.client.data.DataSource#getProgressiveLoading progressive loading mode} for this ResultSet. Any
     * {@link com.smartgwt.client.data.DSRequest}s issued by this ResultSet will copy this setting onto the request, overriding
     * the OperationBinding- and DataSource-level settings. <P> This setting is applied automatically by {@link
     * com.smartgwt.client.widgets.DataBoundComponent}s that have their  own explicit setting for {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getProgressiveLoading progressiveLoading} <P> See also the {@link
     * com.smartgwt.client.data.ResultSet#getRememberDynamicProgressiveLoading rememberDynamicProgressiveLoading} attribute.
     *
     * @return Current progressiveLoading value. Default value is null
     * @see com.smartgwt.client.data.DataSource#getProgressiveLoading
     * @see com.smartgwt.client.docs.serverds.OperationBinding#progressiveLoading
     * @see com.smartgwt.client.data.DSRequest#getProgressiveLoading
     * @see com.smartgwt.client.docs.ProgressiveLoading Progressive Loading
     */
    public Boolean getProgressiveLoading()  {
        return getAttributeAsBoolean("progressiveLoading");
    }
    

    /**
     * To avoid needless work, the ResultSet by default doesn't refilter the data when methods such as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} are called with unchanged criteria. 
     * However, this property can be set true for backward compatibility to force refiltering if we're {@link
     * com.smartgwt.client.data.ResultSet#filterLocalData filtering locally} and the criteria haven't changed. but are narrower
     * than the criteria used to fetch the current cache. <P> Going forward, we may deprecate this property, so you should move
     * to approach that doesn't require such notification in the case of unchanged criteria.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reapplyUnchangedLocalFilter New reapplyUnchangedLocalFilter value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @see com.smartgwt.client.data.ResultSet#willFetchData
     */
    public ResultSet setReapplyUnchangedLocalFilter(Boolean reapplyUnchangedLocalFilter) {
        return (ResultSet)setAttribute("reapplyUnchangedLocalFilter", reapplyUnchangedLocalFilter, true);
    }

    /**
     * To avoid needless work, the ResultSet by default doesn't refilter the data when methods such as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} are called with unchanged criteria. 
     * However, this property can be set true for backward compatibility to force refiltering if we're {@link
     * com.smartgwt.client.data.ResultSet#filterLocalData filtering locally} and the criteria haven't changed. but are narrower
     * than the criteria used to fetch the current cache. <P> Going forward, we may deprecate this property, so you should move
     * to approach that doesn't require such notification in the case of unchanged criteria.
     *
     * @return Current reapplyUnchangedLocalFilter value. Default value is null
     * @see com.smartgwt.client.data.ResultSet#willFetchData
     */
    public Boolean getReapplyUnchangedLocalFilter()  {
        return getAttributeAsBoolean("reapplyUnchangedLocalFilter");
    }
    

    /**
     * If {@link com.smartgwt.client.data.ResultSet#getProgressiveLoading progressiveLoading} is not explicitly set, but the
     * ResultSet recieves a response from the server where {@link com.smartgwt.client.data.DSResponse#getProgressiveLoading
     * DSResponse.progressiveLoading} is  set to true, should subsequent requests for other rows in the same data set
     * explicitly request progressiveLoading via {@link com.smartgwt.client.data.DSRequest#getProgressiveLoading
     * DSRequest.progressiveLoading}, as long as the criteria are unchanged and the cache is not explicitly invalidated? <P>
     * This property is useful for the case where the server side  {@link
     * com.smartgwt.client.docs.serverds.DataSource#progressiveLoadingThreshold DataSource.progressiveLoadingThreshold} enabled
     * progressive loading after the row-count query determined that the requested data set was very large. By explicitly
     * {@link com.smartgwt.client.data.DSRequest#getProgressiveLoading requesting progressive loading} for subsequent fetches
     * the server is able to avoid an unnecessary and potentially expensive row-count query while returning other rows from the
     * same data set.
     *
     * @param rememberDynamicProgressiveLoading New rememberDynamicProgressiveLoading value. Default value is true
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.ProgressiveLoading Progressive Loading
     */
    public ResultSet setRememberDynamicProgressiveLoading(boolean rememberDynamicProgressiveLoading) {
        return (ResultSet)setAttribute("rememberDynamicProgressiveLoading", rememberDynamicProgressiveLoading, true);
    }

    /**
     * If {@link com.smartgwt.client.data.ResultSet#getProgressiveLoading progressiveLoading} is not explicitly set, but the
     * ResultSet recieves a response from the server where {@link com.smartgwt.client.data.DSResponse#getProgressiveLoading
     * DSResponse.progressiveLoading} is  set to true, should subsequent requests for other rows in the same data set
     * explicitly request progressiveLoading via {@link com.smartgwt.client.data.DSRequest#getProgressiveLoading
     * DSRequest.progressiveLoading}, as long as the criteria are unchanged and the cache is not explicitly invalidated? <P>
     * This property is useful for the case where the server side  {@link
     * com.smartgwt.client.docs.serverds.DataSource#progressiveLoadingThreshold DataSource.progressiveLoadingThreshold} enabled
     * progressive loading after the row-count query determined that the requested data set was very large. By explicitly
     * {@link com.smartgwt.client.data.DSRequest#getProgressiveLoading requesting progressive loading} for subsequent fetches
     * the server is able to avoid an unnecessary and potentially expensive row-count query while returning other rows from the
     * same data set.
     *
     * @return Current rememberDynamicProgressiveLoading value. Default value is true
     * @see com.smartgwt.client.docs.ProgressiveLoading Progressive Loading
     */
    public boolean getRememberDynamicProgressiveLoading()  {
        Boolean result = getAttributeAsBoolean("rememberDynamicProgressiveLoading");
        return result == null ? true : result;
    }
    

    /**
     * Allows to set a DSRequest properties to this ResulSet.
     *
     * @param requestProperties New requestProperties value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setRequestProperties(DSRequest requestProperties)  throws IllegalStateException {
        JavaScriptObject config = requestProperties == null ? null : requestProperties.getJsObj();
        return (ResultSet)setAttribute("requestProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Allows to set a DSRequest properties to this ResulSet.
     *
     * @return Current requestProperties value. Default value is null
     */
    public DSRequest getRequestProperties()  {
        return DSRequest.getOrCreateRef(getAttributeAsJavaScriptObject("requestProperties"));
    }
    

    /**
     * How many rows to retrieve at once. <P> Applicable only with <code>fetchMode: "paged"</code>.  When a paged ResultSet is
     * asked for rows that have not yet been loaded, it will fetch adjacent rows that are likely to be required soon, in
     * batches of this size.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param resultSize New resultSize value. Default value is 75
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setResultSize(int resultSize) {
        return (ResultSet)setAttribute("resultSize", resultSize, true);
    }

    /**
     * How many rows to retrieve at once. <P> Applicable only with <code>fetchMode: "paged"</code>.  When a paged ResultSet is
     * asked for rows that have not yet been loaded, it will fetch adjacent rows that are likely to be required soon, in
     * batches of this size.
     *
     * @return Current resultSize value. Default value is 75
     */
    public int getResultSize()  {
        return getAttributeAsInt("resultSize");
    }
    

    /**
     * Request properties for row-count fetch operations performed by {@link com.smartgwt.client.data.ResultSet#fetchRowCount
     * fetchRowCount()}. <P> The row-count fetch operation will ultimately be constructed as follows: <ul><li>Default operation
     * properties will be constructed by combining the         {@link com.smartgwt.client.data.ResultSet#getRowCountContext
     * rowCountContext} with the {@link com.smartgwt.client.data.ResultSet#getRequestProperties resultSet context},        
     * with rowCountContext properties taking precedence</li>     <li>The operation will have type "fetch" and {@link
     * com.smartgwt.client.data.DSRequest#getStartRow DSRequest.startRow} and {@link
     * com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow}         set to zero, and {@link
     * com.smartgwt.client.data.DSRequest#getProgressiveLoading DSRequest.progressiveLoading} will be explicitly set to false. 
     * The request will also have {@link com.smartgwt.client.rpc.RPCRequest#getShowPrompt DSRequest.showPrompt} set to {@link
     * com.smartgwt.client.data.ResultSet#getBlockingRowCountFetch blockingRowCountFetch}         so user interactions can be
     * blocked while the row count is actively being performed.</li>     <li>To override these defaults or specify additional
     * properties, developers may use the          <code>dsRequest</code> parameter of the {@link
     * com.smartgwt.client.data.ResultSet#fetchRowCount fetchRowCount()} method.</li> </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowCountContext New rowCountContext value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public ResultSet setRowCountContext(DSRequest rowCountContext)  throws IllegalStateException {
        return (ResultSet)setAttribute("rowCountContext", rowCountContext == null ? null : rowCountContext.getJsObj(), false);
    }

    /**
     * Request properties for row-count fetch operations performed by {@link com.smartgwt.client.data.ResultSet#fetchRowCount
     * fetchRowCount()}. <P> The row-count fetch operation will ultimately be constructed as follows: <ul><li>Default operation
     * properties will be constructed by combining the         {@link com.smartgwt.client.data.ResultSet#getRowCountContext
     * rowCountContext} with the {@link com.smartgwt.client.data.ResultSet#getRequestProperties resultSet context},        
     * with rowCountContext properties taking precedence</li>     <li>The operation will have type "fetch" and {@link
     * com.smartgwt.client.data.DSRequest#getStartRow DSRequest.startRow} and {@link
     * com.smartgwt.client.data.DSRequest#getEndRow DSRequest.endRow}         set to zero, and {@link
     * com.smartgwt.client.data.DSRequest#getProgressiveLoading DSRequest.progressiveLoading} will be explicitly set to false. 
     * The request will also have {@link com.smartgwt.client.rpc.RPCRequest#getShowPrompt DSRequest.showPrompt} set to {@link
     * com.smartgwt.client.data.ResultSet#getBlockingRowCountFetch blockingRowCountFetch}         so user interactions can be
     * blocked while the row count is actively being performed.</li>     <li>To override these defaults or specify additional
     * properties, developers may use the          <code>dsRequest</code> parameter of the {@link
     * com.smartgwt.client.data.ResultSet#fetchRowCount fetchRowCount()} method.</li> </ul>
     *
     * @return Current rowCountContext value. Default value is null
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public DSRequest getRowCountContext()  {
        return DSRequest.getOrCreateRef(getAttributeAsJavaScriptObject("rowCountContext"));
    }
    

    /**
     * The {@link com.smartgwt.client.data.DSRequest#getOperationId operationId} this ResultSet should use when performing a
     * row-count fetch operation due to {@link com.smartgwt.client.data.ResultSet#fetchRowCount fetchRowCount()}. <P> See also
     * {@link com.smartgwt.client.data.ResultSet#getRowCountContext rowCountContext}
     *
     * @param rowCountOperation New rowCountOperation value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public ResultSet setRowCountOperation(String rowCountOperation)  throws IllegalStateException {
        return (ResultSet)setAttribute("rowCountOperation", rowCountOperation, false);
    }

    /**
     * The {@link com.smartgwt.client.data.DSRequest#getOperationId operationId} this ResultSet should use when performing a
     * row-count fetch operation due to {@link com.smartgwt.client.data.ResultSet#fetchRowCount fetchRowCount()}. <P> See also
     * {@link com.smartgwt.client.data.ResultSet#getRowCountContext rowCountContext}
     *
     * @return Current rowCountOperation value. Default value is null
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public String getRowCountOperation()  {
        return getAttributeAsString("rowCountOperation");
    }
    

    /**
     * Initial sort specifiers for a ResultSet. Use {@link com.smartgwt.client.data.ResultSet#setSort setSort()} and  {@link
     * com.smartgwt.client.data.ResultSet#getSort getSort()} to sort the data after initialization rather than attempting to
     * read or modify this property directly. <P> Note: if {@link com.smartgwt.client.data.ResultSet#getInitialData
     * initialData} was specified, the data is assumed to already be sorted to match this sort configuration.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortSpecifiers New sortSpecifiers value. Default value is null
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setSortSpecifiers(SortSpecifier... sortSpecifiers)  throws IllegalStateException {
        return (ResultSet)setAttribute("sortSpecifiers", sortSpecifiers, false);
    }
    

    /**
     * When a successful Add, Update or Remove type operation fires on this ResultSet's  dataSource, if {@link
     * com.smartgwt.client.data.DSResponse#getData DSResponse.data} is unset, should we integrate the submitted data values
     * (from the request) into our data-set? This attribute will be passed to {@link
     * com.smartgwt.client.data.DataSource#getUpdatedData DataSource.getUpdatedData()} as the <code>useDataFromRequest</code>
     * parameter.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param updateCacheFromRequest New updateCacheFromRequest value. Default value is true
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setUpdateCacheFromRequest(Boolean updateCacheFromRequest)  throws IllegalStateException {
        return (ResultSet)setAttribute("updateCacheFromRequest", updateCacheFromRequest, false);
    }

    /**
     * When a successful Add, Update or Remove type operation fires on this ResultSet's  dataSource, if {@link
     * com.smartgwt.client.data.DSResponse#getData DSResponse.data} is unset, should we integrate the submitted data values
     * (from the request) into our data-set? This attribute will be passed to {@link
     * com.smartgwt.client.data.DataSource#getUpdatedData DataSource.getUpdatedData()} as the <code>useDataFromRequest</code>
     * parameter.
     *
     * @return Current updateCacheFromRequest value. Default value is true
     */
    public Boolean getUpdateCacheFromRequest()  {
        Boolean result = getAttributeAsBoolean("updateCacheFromRequest");
        return result == null ? true : result;
    }
    

    /**
     * If set to true, updated and added rows will be integrated into the client-side cache even if paging is enabled and cache
     * is partial.  If <code>updatePartialCache</code> is false, the cache will be invalidated and new data fetched. <P> If
     * updatePartialCache is enabled and an "add" or "update" operation succeeds with a partial cache: <ul> <li> updated rows
     * will remain in their current position.  No attempt will be made to sort them into a new position even if the sort field
     * was updated. <li> newly added rows will be added at either the end (first preference) or beginning of the dataset if
     * that part of the dataset is cached and was most recently requested. If not, the new row is added at the end of the most
     * recently requested contiguously cached range. </ul> The cache will then be dropped the next time rows are fetched, to
     * prevent problems with inconsistent row numbering between the server and client, which could otherwise lead to duplicate
     * rows or rows being skipped entirely.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param updatePartialCache New updatePartialCache value. Default value is true
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public ResultSet setUpdatePartialCache(Boolean updatePartialCache)  throws IllegalStateException {
        return (ResultSet)setAttribute("updatePartialCache", updatePartialCache, false);
    }

    /**
     * If set to true, updated and added rows will be integrated into the client-side cache even if paging is enabled and cache
     * is partial.  If <code>updatePartialCache</code> is false, the cache will be invalidated and new data fetched. <P> If
     * updatePartialCache is enabled and an "add" or "update" operation succeeds with a partial cache: <ul> <li> updated rows
     * will remain in their current position.  No attempt will be made to sort them into a new position even if the sort field
     * was updated. <li> newly added rows will be added at either the end (first preference) or beginning of the dataset if
     * that part of the dataset is cached and was most recently requested. If not, the new row is added at the end of the most
     * recently requested contiguously cached range. </ul> The cache will then be dropped the next time rows are fetched, to
     * prevent problems with inconsistent row numbering between the server and client, which could otherwise lead to duplicate
     * rows or rows being skipped entirely.
     *
     * @return Current updatePartialCache value. Default value is true
     */
    public Boolean getUpdatePartialCache()  {
        Boolean result = getAttributeAsBoolean("updatePartialCache");
        return result == null ? true : result;
    }
    

    /**
     * Whether to filter data locally when we have a complete cache of all DataSource records  for the current criteria, and
     * the user further restricts the criteria (see  {@link com.smartgwt.client.data.DataSource#compareCriteria
     * DataSource.compareCriteria()}). <P> This may need to be disabled if client-side filtering differs from server-side
     * filtering in a way that affects functionality or is surprising. <p> Note that you can also prevent client-side filtering
     * for certain fields, by setting them to {@link com.smartgwt.client.data.DataSourceField#getFilterOn filterOn:
     * 'serverOnly'}. <P> This setting is distinct from <code>fetchMode:"local"</code>, which explicitly loads all available
     * DataSource records up front and always performs all filtering on the client. <P> See {@link
     * com.smartgwt.client.data.ResultSet#applyFilter applyFilter()} for default filtering behavior. <P> <b>NOTE:</b> even with
     * useClientFiltering false, client-side filtering will be used during cache sync to determine if an updated or added row
     * matches the current criteria. To avoid relying on client-side filtering in this case, either:<br> - avoid returning
     * update data when the updated row doesn't match the current filter<br> - set dropCacheOnUpdate<br>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param useClientFiltering New useClientFiltering value. Default value is true
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setUseClientFiltering(Boolean useClientFiltering) {
        return (ResultSet)setAttribute("useClientFiltering", useClientFiltering, true);
    }

    /**
     * Whether to filter data locally when we have a complete cache of all DataSource records  for the current criteria, and
     * the user further restricts the criteria (see  {@link com.smartgwt.client.data.DataSource#compareCriteria
     * DataSource.compareCriteria()}). <P> This may need to be disabled if client-side filtering differs from server-side
     * filtering in a way that affects functionality or is surprising. <p> Note that you can also prevent client-side filtering
     * for certain fields, by setting them to {@link com.smartgwt.client.data.DataSourceField#getFilterOn filterOn:
     * 'serverOnly'}. <P> This setting is distinct from <code>fetchMode:"local"</code>, which explicitly loads all available
     * DataSource records up front and always performs all filtering on the client. <P> See {@link
     * com.smartgwt.client.data.ResultSet#applyFilter applyFilter()} for default filtering behavior. <P> <b>NOTE:</b> even with
     * useClientFiltering false, client-side filtering will be used during cache sync to determine if an updated or added row
     * matches the current criteria. To avoid relying on client-side filtering in this case, either:<br> - avoid returning
     * update data when the updated row doesn't match the current filter<br> - set dropCacheOnUpdate<br>
     *
     * @return Current useClientFiltering value. Default value is true
     */
    public Boolean getUseClientFiltering()  {
        Boolean result = getAttributeAsBoolean("useClientFiltering");
        return result == null ? true : result;
    }
    

    /**
     * Whether to sort data locally when all records matching the current criteria have been cached. <P> This may need to be
     * disabled if client-side sort order differs from server-side sort order in a way that affects functionality or is
     * surprising.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param useClientSorting New useClientSorting value. Default value is true
     * @return {@link com.smartgwt.client.data.ResultSet ResultSet} instance, for chaining setter calls
     */
    public ResultSet setUseClientSorting(Boolean useClientSorting) {
        return (ResultSet)setAttribute("useClientSorting", useClientSorting, true);
    }

    /**
     * Whether to sort data locally when all records matching the current criteria have been cached. <P> This may need to be
     * disabled if client-side sort order differs from server-side sort order in a way that affects functionality or is
     * surprising.
     *
     * @return Current useClientSorting value. Default value is true
     */
    public Boolean getUseClientSorting()  {
        Boolean result = getAttributeAsBoolean("useClientSorting");
        return result == null ? true : result;
    }
    

    // ********************* Methods ***********************
	/**
     * Do we have a complete client-side cache of records for the current filter criteria? <P> Returns <code>false</code> if
     * this is a paged data set, and the entire set of records that match the current criteria has not been retrieved from the
     * server. In other words, a return value of <code>false</code> means that this <code>ResultSet</code> has a partial cache.
     *
     * @return whether all matching rows are cached
     */
    public native boolean allMatchingRowsCached() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "allMatchingRowsCached", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.allMatchingRowsCached();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Do we have a complete client-side cache of all records for this DataSource? <P> Becomes true only when the ResultSet
     * obtains a complete cache after a fetch with empty criteria.
     *
     * @return whether all rows are cached
     */
    public native boolean allRowsCached() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "allRowsCached", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.allRowsCached();
        return ret == null ? false : ret;
    }-*/;

	/**
     * The ResultSet will call applyFilter() when it needs to determine whether rows match the current filter criteria. <P>
     * Default behavior is to call {@link com.smartgwt.client.data.DataSource#applyFilter DataSource.applyFilter()} to
     * determine which rows match that provided criteria. <P> Override this method or {@link
     * com.smartgwt.client.data.DataSource#applyFilter DataSource.applyFilter()} to implement your own client-side filtering
     * behavior.
     * @param data the list of rows
     * @param criteria the filter criteria
     *
     * @return the list of matching rows
     */
    public native String[] applyFilter(String[] data, Criteria criteria) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applyFilter", "String[],Criteria");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(criteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(criteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.applyFilter(data, criteria == null ? null : criteria.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * The ResultSet will call applyFilter() when it needs to determine whether rows match the current filter criteria. <P>
     * Default behavior is to call {@link com.smartgwt.client.data.DataSource#applyFilter DataSource.applyFilter()} to
     * determine which rows match that provided criteria. <P> Override this method or {@link
     * com.smartgwt.client.data.DataSource#applyFilter DataSource.applyFilter()} to implement your own client-side filtering
     * behavior.
     * @param data the list of rows
     * @param criteria the filter criteria
     * @param requestProperties dataSource request properties
     *
     * @return the list of matching rows
     */
    public native String[] applyFilter(String[] data, Criteria criteria, DSRequest requestProperties) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "applyFilter", "String[],Criteria,DSRequest");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(criteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(criteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.applyFilter(data, criteria == null ? null : criteria.@com.smartgwt.client.core.DataClass::getJsObj()(), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Default behavior is to call {@link com.smartgwt.client.data.DataSource#compareCriteria DataSource.compareCriteria()} to
     * determine whether new criteria is guaranteed more restrictive, equivalent to the old criteria, or not guaranteed more
     * restrictive, returning 1, 0 or -1 respectively.  See {@link com.smartgwt.client.data.DataSource#compareCriteria
     * DataSource.compareCriteria()} for a full explanation of the default behavior. <P> Override this method or {@link
     * com.smartgwt.client.data.DataSource#compareCriteria DataSource.compareCriteria()} to implement your own client-side
     * filtering behavior.
     * @param newCriteria new filter criteria
     * @param oldCriteria old filter criteria
     *
     * @return 0 if the filters are equivalent, 1 if newFilter is guaranteed more                      restrictive, and -1 if newFilter
     * is not guaranteed more restrictive
     * @see com.smartgwt.client.types.CriteriaPolicy
     */
    public native int compareCriteria(Criteria newCriteria, Criteria oldCriteria) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "compareCriteria", "Criteria,Criteria");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(newCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(newCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(oldCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(oldCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.compareCriteria(newCriteria == null ? null : newCriteria.@com.smartgwt.client.core.DataClass::getJsObj()(), oldCriteria == null ? null : oldCriteria.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;

    /**
     * See {@link ResultSet#compareCriteria(com.smartgwt.client.data.Criteria, com.smartgwt.client.data.Criteria, com.smartgwt.client.data.DSRequest, java.lang.String) compareCriteria()}
     */
    public int compareCriteria(Criteria newCriteria, Criteria oldCriteria, DSRequest requestProperties){
        return compareCriteria(newCriteria, oldCriteria, requestProperties, null);
    }

	/**
     * Default behavior is to call {@link com.smartgwt.client.data.DataSource#compareCriteria DataSource.compareCriteria()} to
     * determine whether new criteria is guaranteed more restrictive, equivalent to the old criteria, or not guaranteed more
     * restrictive, returning 1, 0 or -1 respectively.  See {@link com.smartgwt.client.data.DataSource#compareCriteria
     * DataSource.compareCriteria()} for a full explanation of the default behavior. <P> Override this method or {@link
     * com.smartgwt.client.data.DataSource#compareCriteria DataSource.compareCriteria()} to implement your own client-side
     * filtering behavior.
     * @param newCriteria new filter criteria
     * @param oldCriteria old filter criteria
     * @param requestProperties dataSource request properties
     * @param policy overrides {@link com.smartgwt.client.types.CriteriaPolicy}
     *
     * @return 0 if the filters are equivalent, 1 if newFilter is guaranteed more                      restrictive, and -1 if newFilter
     * is not guaranteed more restrictive
     * @see com.smartgwt.client.types.CriteriaPolicy
     */
    public native int compareCriteria(Criteria newCriteria, Criteria oldCriteria, DSRequest requestProperties, String policy) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "compareCriteria", "Criteria,Criteria,DSRequest,String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(newCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(newCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(oldCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(oldCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.compareCriteria(newCriteria == null ? null : newCriteria.@com.smartgwt.client.core.DataClass::getJsObj()(), oldCriteria == null ? null : oldCriteria.@com.smartgwt.client.core.DataClass::getJsObj()(), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()(), policy);
        return ret;
    }-*/;
	
	/**
     * Create a property index on this ResultSet to accelerate find operations. Indexes are only built for cached records
     * (allRows) and do not trigger fetches. When data is partially loaded, indexes only contain entries for loaded records.
     * <P> To check if all data is loaded before relying on indexed results, use {@link
     * com.smartgwt.client.data.ResultSet#allRowsCached allRowsCached()}.
     * @param property Name of the property to index
     *
     * @return this ResultSet (for chaining)
     * @see com.smartgwt.client.docs.Caching Caching
     */
    public native ResultSet createIndex(String property) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "createIndex", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.createIndex(property);
        if(ret == null) return null;
        return @com.smartgwt.client.data.ResultSet::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * Add a dataArrived handler.
     * <p>
     * Notification fired when data has arrived from the server and has been successfully integrated into the cache. <P> When
     * <code>dataArrived()</code> fires, an immediate call to <code>getRange()</code> with the <code>startRow</code> and
     * <code>endRow</code> passed as arguments will return a List with no {@link
     * com.smartgwt.client.data.ResultSet#getLoadingMarker loading markers}. <P> Note that <code>dataArrived()</code> won't
     * fire in the case of the owning component filtering with unchanged criteria (for example using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()}).  To support backward compatibility, the
     * property {@link com.smartgwt.client.data.ResultSet#getReapplyUnchangedLocalFilter ResultSet.reapplyUnchangedLocalFilter}
     * can be set to force <code>dataArrived()</code> to be called if the ResultSet is {@link
     * com.smartgwt.client.data.ResultSet#filterLocalData filtering locally} and the criteria haven't changed but are narrower
     * than the criteria used to fetch the current cache.
     *
     * @param handler the dataArrived handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addDataArrivedHandler(com.smartgwt.client.data.events.DataArrivedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.data.events.DataArrivedEvent.getType()) == 0) setupDataArrivedEvent();
        return doAddHandler(handler, com.smartgwt.client.data.events.DataArrivedEvent.getType());
    }

    private native void setupDataArrivedEvent() /*-{
        var obj;
        var selfJ = this;
        var dataArrived = $entry(function(){
            var param = {"_this": this, "startRow" : arguments[0], "endRow" : arguments[1]};
                var event = @com.smartgwt.client.data.events.DataArrivedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
                selfJ.@com.smartgwt.client.core.BaseClass::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
                selfJ.@com.smartgwt.client.data.ResultSet::handleTearDownDataArrivedEvent()();
            });
        if(this.@com.smartgwt.client.core.BaseClass::isCreated()()) {
            obj = this.@com.smartgwt.client.core.BaseClass::getJsObj()();
            obj.addProperties({dataArrived:  dataArrived              });
        } else {
            obj = this.@com.smartgwt.client.core.BaseClass::getConfig()();
            obj.dataArrived =  dataArrived             ;
        }
    }-*/;

    private void handleTearDownDataArrivedEvent() {
        if (getHandlerCount(com.smartgwt.client.data.events.DataArrivedEvent.getType()) == 0) tearDownDataArrivedEvent();
    }

    private native void tearDownDataArrivedEvent() /*-{
        var obj;
        if(this.@com.smartgwt.client.core.BaseClass::isCreated()()) {
            obj = this.@com.smartgwt.client.core.BaseClass::getJsObj()();
        } else {
            obj = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        }
        if (obj && obj.hasOwnProperty("dataArrived")) delete obj.dataArrived;
    }-*/;

	/**
     * For cases where the exact size of the data set is not known due to {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading}, this method may be used to issue an
     * explicit fetch request to the data source, asking for an accurate row count for the  criteria currently applied to this
     * ResultSet. The  row count will then be available via {@link com.smartgwt.client.data.ResultSet#getRowCount
     * getRowCount()}, and if {@link com.smartgwt.client.data.ResultSet#getApplyRowCountToLength applyRowCountToLength} is
     * true, the {@link com.smartgwt.client.data.ResultSet#getLength length} of the ResultSet will be updated to reflect the 
     * reported value. <P> If the {@link com.smartgwt.client.data.ResultSet#setCriteria criteria} for the ResultSet change
     * while a row count fetch is in progress, the {@link com.smartgwt.client.data.ResultSet#getRowCount rowCount} for the
     * resultSet will not be updated. In this case the callback passed to this method will still fire, with the  
     * criteriaChanged parameter set to <code>true</code> <P> Note the fetch request sent to the dataSource will have {@link
     * com.smartgwt.client.data.DSRequest#getProgressiveLoading DSRequest.progressiveLoading}  explicitly set to false and
     * {@link com.smartgwt.client.data.DSRequest#getStartRow startRow:0} and {@link
     * com.smartgwt.client.data.DSRequest#getEndRow endRow:0}. See {@link com.smartgwt.client.data.ResultSet#getRowCountContext
     * rowCountContext} for full details of the request that will be sent to the dataSource. <P> Smart GWT server side
     * dataSources will process such a request by calculating the row-count (for {@link
     * com.smartgwt.client.docs.serverds.DataSource#serverType serverType:"sql"}, this means issuing a row-count  database
     * query), skipping any logic to retrieve actual data, and return a response with  {@link
     * com.smartgwt.client.data.DSResponse#getProgressiveLoading progressiveLoading:false} and an accurate {@link
     * com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows}. <P> If this ResultSet is backed by a custom
     * dataSource implementation, it is recommended that the dataSource either also returns a response with  {@link
     * com.smartgwt.client.data.DSResponse#getProgressiveLoading progressiveLoading:false} and an accurate  {@link
     * com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows}, or uses the {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} attribute to indicate an
     * accurate row count for the data set. <P> The fetch issued by this method will be marked as a {@link
     * com.smartgwt.client.rpc.RPCRequest#getIsBackgroundRequest background request}.
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public native void fetchRowCount() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fetchRowCount", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.fetchRowCount();
    }-*/;

    /**
     * See {@link ResultSet#fetchRowCount(com.smartgwt.client.callbacks.RowCountCallback, com.smartgwt.client.data.DSRequest) fetchRowCount()}
     */
    public void fetchRowCount(RowCountCallback callback){
        fetchRowCount(callback, null);
    }

	/**
     * For cases where the exact size of the data set is not known due to {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressiveLoading}, this method may be used to issue an
     * explicit fetch request to the data source, asking for an accurate row count for the  criteria currently applied to this
     * ResultSet. The  row count will then be available via {@link com.smartgwt.client.data.ResultSet#getRowCount
     * getRowCount()}, and if {@link com.smartgwt.client.data.ResultSet#getApplyRowCountToLength applyRowCountToLength} is
     * true, the {@link com.smartgwt.client.data.ResultSet#getLength length} of the ResultSet will be updated to reflect the 
     * reported value. <P> If the {@link com.smartgwt.client.data.ResultSet#setCriteria criteria} for the ResultSet change
     * while a row count fetch is in progress, the {@link com.smartgwt.client.data.ResultSet#getRowCount rowCount} for the
     * resultSet will not be updated. In this case the callback passed to this method will still fire, with the  
     * criteriaChanged parameter set to <code>true</code> <P> Note the fetch request sent to the dataSource will have {@link
     * com.smartgwt.client.data.DSRequest#getProgressiveLoading DSRequest.progressiveLoading}  explicitly set to false and
     * {@link com.smartgwt.client.data.DSRequest#getStartRow startRow:0} and {@link
     * com.smartgwt.client.data.DSRequest#getEndRow endRow:0}. See {@link com.smartgwt.client.data.ResultSet#getRowCountContext
     * rowCountContext} for full details of the request that will be sent to the dataSource. <P> Smart GWT server side
     * dataSources will process such a request by calculating the row-count (for {@link
     * com.smartgwt.client.docs.serverds.DataSource#serverType serverType:"sql"}, this means issuing a row-count  database
     * query), skipping any logic to retrieve actual data, and return a response with  {@link
     * com.smartgwt.client.data.DSResponse#getProgressiveLoading progressiveLoading:false} and an accurate {@link
     * com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows}. <P> If this ResultSet is backed by a custom
     * dataSource implementation, it is recommended that the dataSource either also returns a response with  {@link
     * com.smartgwt.client.data.DSResponse#getProgressiveLoading progressiveLoading:false} and an accurate  {@link
     * com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows}, or uses the {@link
     * com.smartgwt.client.data.DSResponse#getEstimatedTotalRows DSResponse.estimatedTotalRows} attribute to indicate an
     * accurate row count for the data set. <P> The fetch issued by this method will be marked as a {@link
     * com.smartgwt.client.rpc.RPCRequest#getIsBackgroundRequest background request}.
     * @param callback Callback to fire when the fetch request completes.  To retrieve details of the row-count that was retrieved from the
     * server, use  the <code>getRowCount()</code> and <code>getRowCountStatus()</code> methods.
     * @param dsRequest Custom properties for the row count fetch request
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public native void fetchRowCount(RowCountCallback callback, DSRequest dsRequest) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "fetchRowCount", "RowCountCallback,DSRequest");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.fetchRowCount(
			$entry( function(resultSet, dsResponse, invalidated) { 
				if(callback!=null) callback.@com.smartgwt.client.callbacks.RowCountCallback::execute(Lcom/smartgwt/client/data/ResultSet;Lcom/smartgwt/client/data/DSResponse;Z)(
					resultSet != null ? @com.smartgwt.client.data.ResultSet::new(Lcom/google/gwt/core/client/JavaScriptObject;)(resultSet) : null, 
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					invalidated == null ? false : invalidated
				);
			}), dsRequest == null ? null : dsRequest.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Derive the current filtered set of data from the cache of all matching rows. <P> This method is automatically called by
     * {@link com.smartgwt.client.data.ResultSet#setCriteria setCriteria()} when criteria have actually changed, as well as in
     * various other situations.  You could only need to call this method directly if: <ul> <li> you know that client-side
     * filtering is enabled ({@link com.smartgwt.client.data.ResultSet#getUseClientFiltering useClientFiltering}:true) and
     * active {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached allMatchingRowsCached()}. <li> you have directly,
     * programmatically modified data within the ResultSet such that it no longer matches the filter criteria <li> you want
     * your modified records to disappear from the list of visible records (that is, those accessible via {@link
     * com.smartgwt.client.data.ResultSet#get get()}) </ul>
     */
    public native void filterLocalData() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "filterLocalData", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.filterLocalData();
    }-*/;

	/**
     * Attempt to find the record in the resultSet that has a primary key value that matches the  passed in parameter value.
     * Only the locally cached data will be searched.  Checks only loaded rows and will not trigger a fetch. Returns null if
     * there is no match,  data is not loaded, or there is no {@link com.smartgwt.client.data.ResultSet#getDataSource
     * dataSource}. <p> Note, if you pass a simple value to this method, it will be matched against the first  primaryKey
     * field.  For DataSources with a composite primary key (multiple primaryKey fields), pass  a Criteria instance containing
     * just primaryKey entries.
     * @param keyValue primary key value to search for
     *
     * @return the record with a matching primary key field, or null if not found
     */
    public native Record findByKey(Map keyValue) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "findByKey", "Map");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.findByKey(keyValue == null ? null : @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(keyValue));
        if(ret == null) return null;
        return @com.smartgwt.client.data.Record::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns the index of the first and last cached row around a given row, or null if the row itself is not cached.  The
     * last cached row value is inclusive.
     * @param rowNum row to check
     *
     * @return first and last cached row indices, or null
     */
    public native int[] getCachedRange(int rowNum) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getCachedRange", "int");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getCachedRange(rowNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfint(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns a copy of all {@link com.smartgwt.client.data.ResultSet#getCriteria explicit} and  {@link
     * com.smartgwt.client.data.ResultSet#getImplicitCriteria implicit} criteria currently applied to this
     * <code>ResultSet</code>.
     *
     * @return combined criteria
     */
    public native Criteria getCombinedCriteria() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getCombinedCriteria", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getCombinedCriteria();
        if(ret == null) return null;
        return @com.smartgwt.client.data.Criteria::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns a copy of all {@link com.smartgwt.client.data.ResultSet#getCriteria explicit} and  {@link
     * com.smartgwt.client.data.ResultSet#getImplicitCriteria implicit} criteria currently applied to this
     * <code>ResultSet</code>.
     *
     * @return combined criteria
     */
    public native AdvancedCriteria getCombinedCriteriaAsAdvancedCriteria() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getCombinedCriteriaAsAdvancedCriteria", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getCombinedCriteria();
        if(ret == null) return null;
        return @com.smartgwt.client.data.AdvancedCriteria::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Return the total number of records that match the current filter criteria. <P> This length can only be known, even
     * approximately, when the first results are retrieved from the server.  Before then, the ResultSet returns a large length
     * in order to encourage viewers to ask for rows.  {@link com.smartgwt.client.data.ResultSet#lengthIsKnown
     * ResultSet.lengthIsKnown()} can be called to determine whether an actual length is known. <P> Note that if {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressive loading} is active, the length advertised by the
     * server may not be an accurate total row count for the data set. {@link
     * com.smartgwt.client.data.ResultSet#lengthIsProgressive ResultSet.lengthIsProgressive()} can be called to determine
     * whether this is the case.
     *
     * @return number of items in the list
     */
    public native int getLength() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getLength", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getLength();
        return ret;
    }-*/;

	/**
     * Like {@link com.smartgwt.client.data.List#getProperty List.getProperty()}.  Checks only loaded rows and will not trigger
     * a fetch.
     * @param property name of the property to look for
     *
     * @return array of the values of property in each item of this list
     */
    public native String[] getProperty(String property) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getProperty", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getProperty(property);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * This method retrieves the row-count for this data set. If progressive loading is active,  this may differ from {@link
     * com.smartgwt.client.data.ResultSet#getLength getLength()}. See {@link
     * com.smartgwt.client.data.ResultSet#getRowCountStatus getRowCountStatus()} for more information.
     *
     * @return Current row-count for this grid
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public native int getRowCount() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getRowCount", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getRowCount();
        return ret;
    }-*/;

	/**
     * If {@link com.smartgwt.client.data.ResultSet#getRowCountStatus getRowCountStatus()} is "range" this method will return a
     * two element array containing the lower and upper bound for the rowCount. In all other cases it will return a two element
     * array where the first element is the result of {@link com.smartgwt.client.data.ResultSet#getRowCount getRowCount()} and
     * the second element is null
     *
     * @return row count lower and upper bound
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public native Integer[] getRowCountRange() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getRowCountRange", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getRowCountRange();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfInteger(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * This method indicates whether {@link com.smartgwt.client.data.ResultSet#getRowCount getRowCount()} reflects an accurate
     * row-count for this data set. An accurate row count may not currently be available if {@link
     * com.smartgwt.client.data.ResultSet#getProgressiveLoading progressiveLoading} is active. <P> See {@link
     * com.smartgwt.client.types.RowCountStatus} for further details.
     *
     * @return Current row-count status for this grid
     * @see com.smartgwt.client.docs.RowRangeDisplay Grid row-range and row-count display
     */
    public native RowCountStatus getRowCountStatus() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getRowCountStatus", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getRowCountStatus();
        if(ret == null) return null;
        var enumValues = @com.smartgwt.client.types.RowCountStatus::values()();
        return @com.smartgwt.client.util.EnumUtil::getEnum([Lcom/smartgwt/client/types/ValueEnum;Ljava/lang/String;)(enumValues, ret);
    }-*/;

	/**
     * Return the current sort-specification for this ResultSet as an Array of {@link com.smartgwt.client.data.SortSpecifier}s.
     *
     * @return the list of {@link com.smartgwt.client.data.SortSpecifier}s currently applied to   this ResultSet
     */
    public native SortSpecifier[] getSort() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getSort", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getSort();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfSortSpecifier(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns an array of unique values for the specified property from loaded records only. This method operates only on
     * cached data and does not trigger fetches. <P> For partial caches, only loaded records are examined. Use {@link
     * com.smartgwt.client.data.ResultSet#allRowsCached allRowsCached()} to check if all data is loaded before relying on
     * complete results. <P> This override works directly with the ResultSet's cache structure to avoid triggering data
     * fetches. When a property index exists, this method uses the appropriate index for O(1) performance: <ul> <li>When {@link
     * com.smartgwt.client.data.ResultSet#getIndexFilteredData filtered indexing} is enabled and criteria     have narrowed the
     * visible dataset, filtered indices are used to return only values from     records matching the current filter</li>
     * <li>When no filtering is active and all data is cached, primary indices are used</li> <li>Otherwise, a single-pass
     * iteration of the available data is performed</li> </ul> <P> <b>Important:</b> This method respects client-side
     * filtering. When criteria are active and {@link com.smartgwt.client.data.ResultSet#getUseClientFiltering client
     * filtering} is enabled, only unique values from records matching the current criteria are returned, not from all cached
     * data.
     * @param property the property name to extract unique values from
     *
     * @return array of unique property values from loaded records only
     * @see com.smartgwt.client.docs.Caching Caching
     */
    public native String[] getUniquePropertyValues(String property) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getUniquePropertyValues", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getUniquePropertyValues(property);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Get a map of the form <code>{ item[idField] -&gt; item[displayField] }</code>, for all  items in the list.  If more than
     * one item has the same <code>idProperty</code>,  the value for the later item in the list will clobber the value for the
     * earlier item. <P> If this method is called when the {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached
     * cache is incomplete}, it will trigger fetches, and will return a valueMap reflecting only the currently loaded rows.
     * @param idField Property to use as ID (data value) in the valueMap
     * @param displayField Property to use as a display value in the valueMap
     *
     * @return valueMap object
     * @see com.smartgwt.client.data.ResultSet#allMatchingRowsCached
     */
    public native Map getValueMap(String idField, String displayField) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getValueMap", "String,String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getValueMap(idField, displayField);
        return @com.smartgwt.client.util.JSOHelper::convertToMap(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Return the position in the list of the first instance of the specified object. <p> If pos is specified, starts looking
     * after that position. <p> Returns -1 if not found. <p> <b>NOTE:</b> ResultSet.indexOf() only inspects the current cache
     * of records, so it is only appropriate for temporary presentation purposes.  For example, it would not be appropriate to
     * hold onto a record and attempt to use indexOf() to determine if it had been deleted.
     * @param obj object to look for
     *
     * @return position of the item, if found, -1 if not found
     */
    public native int indexOf(Object obj) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "indexOf", "Object");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.indexOf(obj);
        return ret;
    }-*/;

    /**
     * See {@link ResultSet#indexOf(java.lang.Object, int, int) indexOf()}
     */
    public int indexOf(Object obj, int pos){
        return indexOf(obj, pos, (Integer) null);
    }

	/**
     * Return the position in the list of the first instance of the specified object. <p> If pos is specified, starts looking
     * after that position. <p> Returns -1 if not found. <p> <b>NOTE:</b> ResultSet.indexOf() only inspects the current cache
     * of records, so it is only appropriate for temporary presentation purposes.  For example, it would not be appropriate to
     * hold onto a record and attempt to use indexOf() to determine if it had been deleted.
     * @param obj object to look for
     * @param pos earliest index to consider
     * @param endPos last index to consider
     *
     * @return position of the item, if found, -1 if not found
     */
    public native int indexOf(Object obj, int pos, int endPos) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "indexOf", "Object,int,int");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.indexOf(obj, pos, endPos);
        return ret;
    }-*/;
	
	/**
     * Manually invalidate this ResultSet's cache. <P> Generally a ResultSet will observe and incorporate updates to the
     * DataSource that provides its records, but when this is not possible, <code>invalidateCache()</code> allows manual cache
     * invalidation. <P> <code>invalidateCache()</code> fires <code>dataChanged()</code>, which may cause components  using
     * this ResultSet to request new data for display, triggering server fetches.
     */
    public native void invalidateCache() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "invalidateCache", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.invalidateCache();
    }-*/;

	/**
     * Whether the ResultSet knows the length of its data set. <P> When the ResultSet fetches data from the DataSource in
     * response to {@link com.smartgwt.client.data.ResultSet#getRange getRange()} or similar methods, {@link
     * com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows} from the fetch lets the ResultSet know the full
     * dataset size. <P> Prior to the completion of the first fetch, (or after {@link
     * com.smartgwt.client.data.ResultSet#invalidateCache dropping cache}) the ResultSet will not know how many records  are
     * available. At this time <code>lengthIsKnown()</code> will return false, and a call to {@link
     * com.smartgwt.client.data.ResultSet#getLength getLength()} will return an arbitrary,  large value. <P> Note: If {@link
     * com.smartgwt.client.data.DataSource#getProgressiveLoading progressive loading} is active the reported {@link
     * com.smartgwt.client.data.DSResponse#getTotalRows DSResponse.totalRows} value may not accurately reflect the true dataset
     * size on the server. In this case <code>lengthIsKnown()</code> returns true, but the {@link
     * com.smartgwt.client.data.ResultSet#getLength reported length} of the ResultSet may change as additional rows are
     * retrieved from the server. The {@link com.smartgwt.client.data.ResultSet#lengthIsProgressive lengthIsProgressive()}
     * method will indicate when the resultSet is in this state.
     *
     * @return whether length is known
     */
    public native boolean lengthIsKnown() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "lengthIsKnown", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.lengthIsKnown();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Does the length of this ResultSet as returned by {@link com.smartgwt.client.data.ResultSet#getLength getLength()} 
     * reflect the {@link com.smartgwt.client.data.DSResponse#getTotalRows totalRows} reported by a DataSource with {@link
     * com.smartgwt.client.docs.ProgressiveLoading} enabled? <P> If true, this row count may not be an accurate reflection of
     * the true size of the data set. <P> This method relies on the {@link
     * com.smartgwt.client.data.DSResponse#getProgressiveLoading DSResponse.progressiveLoading} attribute having been set
     * accurately by the server. Note that if the user has scrolled to the end of a progressively loaded data set, or {@link
     * com.smartgwt.client.data.ResultSet#setFullLength setFullLength()} has been explicitly called, this method will no longer
     * return true.
     *
     * @return true if the length of this ResultSet was derived from   a {@link
     * com.smartgwt.client.data.DSResponse#getProgressiveLoading progressiveLoading:true} dsResponse.
     * @see com.smartgwt.client.docs.ProgressiveLoading Progressive Loading
     */
    public native boolean lengthIsProgressive() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "lengthIsProgressive", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.lengthIsProgressive();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Whether the given range of rows has been loaded. Unlike getRange(), will not trigger a server fetch.
     * @param startRow start position, inclusive
     * @param endRow end position, exclusive
     *
     * @return true if all rows in the given range have been loaded, false if any rows in                   the range have not been
     * loaded or are still in the process of being loaded
     */
    public native boolean rangeIsLoaded(int startRow, int endRow) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "rangeIsLoaded", "int,int");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.rangeIsLoaded(startRow, endRow);
        return ret == null ? false : ret;
    }-*/;

	/**
     * Remove a property index created by {@link com.smartgwt.client.data.ResultSet#createIndex createIndex()}.
     * @param property Name of the indexed property to remove
     *
     * @return this ResultSet (for chaining)
     * @see com.smartgwt.client.docs.Caching Caching
     */
    public native ResultSet removeIndex(String property) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "removeIndex", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.removeIndex(property);
        if(ret == null) return null;
        return @com.smartgwt.client.data.ResultSet::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Forcibly resort this ResultSet by the current list of {@link com.smartgwt.client.data.SortSpecifier}s.
     */
    public native void resort() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "resort", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.resort();
    }-*/;

	/**
     * Whether the given row has been loaded. <p> Unlike get(), will not trigger a server fetch.
     * @param rowNum row to check
     *
     * @return true if the given row has been loaded, false if it has not been                   loaded or is still in the process of
     * being loaded
     */
    public native boolean rowIsLoaded(int rowNum) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "rowIsLoaded", "int");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.rowIsLoaded(rowNum);
        return ret == null ? false : ret;
    }-*/;

	/**
     * Set the total number of rows available from the server that match the current filter  criteria for this ResultSet. <P>
     * This is an advanced feature. One use case for this method would be for a ResultSet populated with {@link
     * com.smartgwt.client.docs.ProgressiveLoading progressive loading} - if application code determines an accurate row count
     * for the current filter criteria it may be applied directly to the ResultSet via this method.
     * @param length total rows available from the server
     */
    public native void setFullLength(int length) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setFullLength", "int");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setFullLength(length);
    }-*/;

	/**
     * Sort this ResultSet by the passed list of {@link com.smartgwt.client.data.SortSpecifier}s.  <P> If the ResultSet is
     * already sorted and this method is called with an identical list of specifiers, this method will no-op.  To cause data to
     * be resorted with the same set of specifiers, use {@link com.smartgwt.client.data.ResultSet#resort resort()}. <P> To
     * clear an existing sort, pass in explicit null or empty array.
     */
    public native void setSort() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setSort", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setSort();
    }-*/;

	/**
     * Sort this ResultSet by a property of each record. <P> Sorting is performed on the client for a ResultSet that has a full
     * cache for the current filter criteria.  Otherwise, sorting is performed by the server, and changing the sort order will
     * invalidate the cache. <P> <b>NOTE:</b> normalizers are not supported by ResultSets in "paged" mode, although valueMaps
     * in the DataSource are respected by the SQLDataSource.
     * @param property name of the property to sort by
     * @param up true == sort ascending, false == sort descending
     *
     * @return this ResultSet
     */
    public native ResultSet sortByProperty(String property, boolean up) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "sortByProperty", "String,boolean");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.sortByProperty(property, up);
        if(ret == null) return null;
        return @com.smartgwt.client.data.ResultSet::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Sort this ResultSet by a property of each record. <P> Sorting is performed on the client for a ResultSet that has a full
     * cache for the current filter criteria.  Otherwise, sorting is performed by the server, and changing the sort order will
     * invalidate the cache. <P> <b>NOTE:</b> normalizers are not supported by ResultSets in "paged" mode, although valueMaps
     * in the DataSource are respected by the SQLDataSource.
     * @param property name of the property to sort by
     * @param up true == sort ascending, false == sort descending
     *
     * @return this ResultSet
     */
    public native Object[] sortByPropertyAsObjectArray(String property, boolean up) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "sortByPropertyAsObjectArray", "String,boolean");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.sortByProperty(property, up);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * See {@link ResultSet#sortByProperty(java.lang.String, boolean, com.smartgwt.client.core.Function, java.lang.Object) sortByProperty()}
     */
    public ResultSet sortByProperty(String property, boolean up, Function normalizer){
        return sortByProperty(property, up, normalizer, null);
    }

	/**
     * Sort this ResultSet by a property of each record. <P> Sorting is performed on the client for a ResultSet that has a full
     * cache for the current filter criteria.  Otherwise, sorting is performed by the server, and changing the sort order will
     * invalidate the cache. <P> <b>NOTE:</b> normalizers are not supported by ResultSets in "paged" mode, although valueMaps
     * in the DataSource are respected by the SQLDataSource.
     * @param property name of the property to sort by
     * @param up true == sort ascending, false == sort descending
     * @param normalizer May be specified as a function, with signature               <code>normalize(item, propertyName, context)</code>, where
     * <code>item</code> is              a pointer to the item in the array, <code>propertyName</code> is the              
     * property by which the array is being sorted, and <code>context</code> is the              arbitrary context passed into
     * this method. Normalizer function should return              the value normalized for sorting.<br>              May also
     * be specified as a ValueMap which maps property values to sortable values.
     * @param context Callers may pass an arbitrary context into the sort method, which                          will then be made available
     * to the normalizer function
     *
     * @return this ResultSet
     */
    public native ResultSet sortByProperty(String property, boolean up, Function normalizer, Object context) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "sortByProperty", "String,boolean,Function,Object");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.sortByProperty(property, up, 
			$entry( function() { 
				if(normalizer!=null) normalizer.@com.smartgwt.client.core.Function::execute()(
				);
			}), context);
        if(ret == null) return null;
        return @com.smartgwt.client.data.ResultSet::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Clear any {@link com.smartgwt.client.data.ResultSet#setSort sort specifiers} applied to this ResultSet, while
     * maintaining the current order of records. This feature is not supported for all lists. This method returns true if
     * supported. <P> If a {@link com.smartgwt.client.data.ResultSet#getFetchMode paged resultSet} has a partial cache, the
     * order of records in the local data must always match the order of records as  provided by the {@link
     * com.smartgwt.client.data.DataSource} - otherwise the wrong set of records will be  returned as new pages of data are
     * fetched  (in response to a user scrolling a ListGrid, for example). <P> It's therefore not possible to unsort a paged
     * resultSet with a partial cache and maintain the current order of any loaded records. If this method is called on  a
     * resultSet in this state, it will always no-op and return false. <P> If you need to force a partially loaded ResultSet to
     * discard it's current sort, and explicit call to {@link com.smartgwt.client.data.ResultSet#setSort setSort(null)} may be
     * used. This will drop the current sort specifiers and {@link com.smartgwt.client.data.ResultSet#invalidateCache
     * invalidateCache()}.
     *
     * @return true == list supports unsorting, false == not supported.
     */
    public native boolean unsort() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "unsort", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.unsort();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Refresh a property index after records have been loaded or modified. This is automatically called when records are
     * added/removed/updated, but can be called manually if direct modifications were made to the cache.
     * @param property Name of the indexed property to refresh
     *
     * @return this ResultSet (for chaining)
     * @see com.smartgwt.client.docs.Caching Caching
     */
    public native ResultSet updateIndex(String property) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "updateIndex", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.updateIndex(property);
        if(ret == null) return null;
        return @com.smartgwt.client.data.ResultSet::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Determine whether the ResultSet is showing a filtered, proper subset of the cached rows. This happens if {@link
     * com.smartgwt.client.data.ResultSet#getUseClientFiltering client filtering} is enabled.  Rows may have been loaded from
     * the server when a more restrictive criteria is applied such that filtering could be performed on the client side. <P>
     * This method returns false if data is not loaded yet.
     *
     * @return true if the ResultSet is showing a filtered subset of the cached rows, false otherwise.
     * @see com.smartgwt.client.data.ResultSet#getAllCachedRows
     */
    public native boolean usingFilteredData() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "usingFilteredData", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.usingFilteredData();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Will changing the criteria for this resultSet require fetching new data from the server,  or can the new criteria be
     * satisfied from data already cached on the client?<br> Second <code>textMatchStyle</code> parameter determines whether a
     * change of text-match style will require a server fetch - for example if filter is being changed between an exact match
     * (from e.g: {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()}) and a substring match 
     * (from e.g: {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()}).<br> This method can be
     * used to determine whether {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} would cause a server side fetch when passed
     * a certain set of  criteria. <p> Note that to predict correctly the decision that will be made by filter/fetch, you'll
     * need to pass the same {@link com.smartgwt.client.types.TextMatchStyle} that will be used by the future filter/fetch. 
     * Fetching manually (e.g. {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()}) will by
     * default use "exact" while filtering (e.g. {@link com.smartgwt.client.widgets.grid.ListGrid#filterData
     * ListGrid.filterData()}) will by default use "substring".  If the component is configured for autofetch (i.e. {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchData ListGrid.autoFetchData}: true), that will use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle ListGrid.autoFetchTextMatchStyle}, which defaults
     * to "substring".  If nothing/null is passed for the style, this method assumes you want the style from the last
     * filter/fetch. <p> To determine what {@link com.smartgwt.client.types.TextMatchStyle} is being used, check the RPC Tab of
     * the {@link com.smartgwt.client.docs.Debugging Smart GWT Developer Console} and check the relevant {@link
     * com.smartgwt.client.data.DSRequest}.
     * @param newCriteria new criteria to test.
     *
     * @return true if server fetch would be required to satisfy new criteria.
     */
    public native boolean willFetchData(Criteria newCriteria) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "willFetchData", "Criteria");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(newCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(newCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.willFetchData(newCriteria == null ? null : newCriteria.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret == null ? false : ret;
    }-*/;

	/**
     * Will changing the criteria for this resultSet require fetching new data from the server,  or can the new criteria be
     * satisfied from data already cached on the client?<br> Second <code>textMatchStyle</code> parameter determines whether a
     * change of text-match style will require a server fetch - for example if filter is being changed between an exact match
     * (from e.g: {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()}) and a substring match 
     * (from e.g: {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()}).<br> This method can be
     * used to determine whether {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} would cause a server side fetch when passed
     * a certain set of  criteria. <p> Note that to predict correctly the decision that will be made by filter/fetch, you'll
     * need to pass the same {@link com.smartgwt.client.types.TextMatchStyle} that will be used by the future filter/fetch. 
     * Fetching manually (e.g. {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()}) will by
     * default use "exact" while filtering (e.g. {@link com.smartgwt.client.widgets.grid.ListGrid#filterData
     * ListGrid.filterData()}) will by default use "substring".  If the component is configured for autofetch (i.e. {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchData ListGrid.autoFetchData}: true), that will use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle ListGrid.autoFetchTextMatchStyle}, which defaults
     * to "substring".  If nothing/null is passed for the style, this method assumes you want the style from the last
     * filter/fetch. <p> To determine what {@link com.smartgwt.client.types.TextMatchStyle} is being used, check the RPC Tab of
     * the {@link com.smartgwt.client.docs.Debugging Smart GWT Developer Console} and check the relevant {@link
     * com.smartgwt.client.data.DSRequest}.
     * @param newCriteria new criteria to test.
     * @param textMatchStyle New text match style. If not passed, assumes       textMatchStyle will not be modified.
     *
     * @return true if server fetch would be required to satisfy new criteria.
     */
    public native boolean willFetchData(Criteria newCriteria, TextMatchStyle textMatchStyle) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "willFetchData", "Criteria,TextMatchStyle");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(newCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(newCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.willFetchData(newCriteria == null ? null : newCriteria.@com.smartgwt.client.core.DataClass::getJsObj()(), textMatchStyle == null ? null : textMatchStyle.@com.smartgwt.client.types.TextMatchStyle::getValue()());
        return ret == null ? false : ret;
    }-*/;
	

    // ********************* Static Methods ***********************


    // ***********************************************************



    private boolean ensuringCreated = false;

    public ResultSet(DataSource dataSource) {
        setDataSource(dataSource);
        scClassName = "ResultSet";
    }

    /**
     * Returns the existing SGWT ResultSet, or creates and returns one if none exist,
     * associated with the supplied {@link com.google.gwt.core.client.JavaScriptObject}.  If
     * the supplied object is not a SmartClient ResultSet, a warning will be logged and null
     * returned; otherwise the SGWT ResultSet will be returned.
     *
     * @param jsObj SmartClient ResultSet whose wrapper is wanted
     *
     * @return wrapping SGWT ResultSet or null
     */
    public static native ResultSet asSGWTComponent(JavaScriptObject jsObj) /*-{
       if ($wnd.isc.isA.ResultSet(jsObj)) {
           return @com.smartgwt.client.data.ResultSet::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(jsObj);
       } 
       var className = $wnd.isc.isAn.Instance(jsObj) ? jsObj.getScClassName() : "none";
       @com.smartgwt.client.util.SC::logWarn(Ljava/lang/String;)("ResultSet.asSGWTComponent(): " +
           "The supplied JS object must be a ResultSet - actual class is " + className + ".");
       return null;
    }-*/;

    /**
     * Ensures that the underlying SmartClient ResultSet object is created for this ResultSet
     * instance. If the SmartClient object has already been created, then calling this method
     * amounts to a no-op. Otherwise, the <code>isc.ResultSet.create()</code> function is
     * executed to create the SmartClient ResultSet object wrapped by this instance.
     * <p>
     * This method is required to be called for standalone usage of a ResultSet. In addition,
     * it can only be called after all initial configuration ({@link #getDataSource() dataSource},
     * {@link #setAllRows(Record[]) allRows} if being used, etc.) has been set.
     * 
     * @throws IllegalStateException if no dataSource has been set
     */
    public void ensureCreated() throws IllegalStateException {
        if (jsObj == null) {
            final JavaScriptObject dataSource = JSOHelper.getAttributeAsJavaScriptObject(getConfig(), "dataSource");
            if (dataSource == null) throw new IllegalStateException("Cannot create the ResultSet without a dataSource.");
        }
        this.ensuringCreated = true;
        getOrCreateJsObj();
        this.ensuringCreated = false;
    }

    /** 
     * This method returns a Map of config properties suitable for use as the "defaults" 
     * attribute of a {@link com.smartgwt.client.tools.PaletteNode}.  Use it when you need to
     * work with PaletteNodes indirectly, such when setting up 
     * {@link com.smartgwt.client.widgets.tile.TileRecord}s that will be used in a 
     * {@link com.smartgwt.client.tools.TilePalette}.  See 
     * {@link com.smartgwt.client.docs.DevTools the dev tools overview} for examples of how to
     * assemble and acquire a suitable defaults object when you are creating a PaletteNode 
     * indirectly
     */
    public Map getPaletteDefaults() {
        if (isCreated()) {
            ConfigUtil.warnOfPreConfigInstantiation(this.getClass(), "getPaletteDefaults", (String)null);
        }
        return JSOHelper.convertToMap(JSOHelper.cleanProperties(getConfig(), true));
    }

    // ********************* Properties / Attributes ***********************

    /**
     * Initial multi property sort specification for this ResultSet's data. If a ResultSet is being
     * explicitly created and seeded with {@link #setInitialData(Record[])}, this method may be used
     * to notify the ResultSet that the data is already sorted such that a call to {@link #setSort(SortSpecifier...)} will
     * not require a new fetch unless additional data beyond the ends of the specified initialData are required.
     * @param sortSpecifiers Initial sort specification
     */
    public void setInitialSort(SortSpecifier... sortSpecifiers){
        JavaScriptObject jsSortArray = JSOHelper.convertToJavaScriptArray(sortSpecifiers);
        setAttribute("sortSpecifiers", jsSortArray, false);
    }

    // ********************* Methods ***********************

    /**
     * Return the position in the list of the first instance of the specified object. <p> If pos is specified, starts looking
     * after that position. <p> Returns -1 if not found. <p> <b>NOTE:</b> ResultSet.indexOf() only inspects the current cache
     * of records, so it is only appropriate for temporary presentation purposes.  For example, it would not be appropriate to
     * hold onto a record and attempt to use indexOf() to determine if it had been deleted.
     * @param record object to look for
     *
     * @return position of the item, if found, -1 if not found
     */
    public native int indexOf(Record record) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.indexOf(record.@com.smartgwt.client.data.Record::getJsObj()());
    }-*/;

    /**
     * Return the position in the list of the first instance of the specified object. <p> If pos is specified, starts looking
     * after that position. <p> Returns -1 if not found. <p> <b>NOTE:</b> ResultSet.indexOf() only inspects the current cache
     * of records, so it is only appropriate for temporary presentation purposes.  For example, it would not be appropriate to
     * hold onto a record and attempt to use indexOf() to determine if it had been deleted.
     * @param record object to look for
     * @param pos earliest index to consider
     * @param endPos last index to consider
     *
     * @return position of the item, if found, -1 if not found
     */
    public native int indexOf(Record record, int pos, int endPos) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.indexOf(record.@com.smartgwt.client.data.Record::getJsObj()(), pos, endPos);
    }-*/;

    /**
     * Returns the record at the specified position. <P> All List access methods of the ResultSet have the semantics described
     * in <code>getRange()</code>.
     * @param pos position of the element to get
     *
     * @return whatever's at that position, null if not found
     */
    public native Record get(int pos) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordJS = self.get(pos);
        return recordJS == null || recordJS === undefined ? null : @com.smartgwt.client.data.Record::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(recordJS);
    }-*/;

    /**
     * Return the items between position start and end, non-inclusive at the end, possibly  containing markers for records that
     * haven't loaded yet. <P> Calling getRange for records that have not yet loaded will trigger an asynchronous fetch.  The
     * returned data will contain the {@link ResultSet#getLoadingMarker() loading marker} as a placeholder for records being fetched.  If
     * any rows needed to be fetched, <code>dataArrived()</code> will fire when they arrive.
     * @param start start position
     * @param end end position
     *
     * @return subset of the array from start -> end-1
     */
    public native Record[] getRange(int start, int end) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS =  self.getRange(start, end);
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Return a RecordList with the items between position start and end, non-inclusive at the end.
     * @param start start position
     * @param end end position
     *
     * @return a RecordList containing the items from start -> end-1
     */
    public native RecordList getRangeAsRecordList(int start, int end) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS =  self.getRange(start, end);
        return (recordsJS == null || recordsJS === undefined) ? null :
                @com.smartgwt.client.data.RecordList::new(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Returns a list of the currently visible data, that is, all rows that match the current
     * criteria, with null entries or {@link ResultSet#getLoadingMarker() loading markers} for
     * rows that are not yet loaded or in the process of loading, respectively.
     * <P>
     * This method will not trigger a fetch to load more records.  getAllVisibileRows() will return
     * null if {@link ResultSet#lengthIsKnown()} is false.
     * <P>
     * Records are returned in a new List but the Records within it are the same
     * instances that the ResultSet is holding onto.  Hence it's safe to add or remove records from
     * the List without affecting the ResultSet but modifying the Records themselves is a direct
     * modification of the client-side cache.
     * @return the records in the cache that match the current criteria, possibly null
     */
    public native RecordList getAllVisibleRows() /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS =  self.getAllVisibleRows();
        return (recordsJS == null || recordsJS === undefined) ? null :
                @com.smartgwt.client.data.RecordList::new(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Returns a list of all rows that have been cached.  This is potentially a superset of all rows that are
     * available via {@link ResultSet#getAllVisibleRows()} if the ResultSet is using client-side filtering to
     * display a subset of loaded rows (see the {@link ResultSet ResultSet overview}).
     * <P>
     * If {@link ResultSet#usingFilteredData()} returns false, this is the same list as would be returned by
     * {@link ResultSet#getAllVisibleRows()}.
     * <P>
     * This method will not trigger a fetch to load more records.  getAllCachedRows() will return
     * null if {@link ResultSet#lengthIsKnown()} is false.
     * <P>
     * Records are returned in a new List but the Records within it are the same
     * instances that the ResultSet is holding onto.  Hence it's safe to add or remove records from
     * the List without affecting the ResultSet but modifying the Records themselves is a direct
     * modification of the client-side cache.
     * @return the records in the cache, possibly null
     */
    public native RecordList getAllCachedRows() /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS =  self.getAllCachedRows();
        return (recordsJS == null || recordsJS === undefined) ? null :
                @com.smartgwt.client.data.RecordList::new(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Attempt to find the record in the resultSet that has a primary key value that matches the  passed in parameter value.
     * Only the locally cached data will be searched.  Checks only loaded rows and will not trigger a fetch. Returns null if
     * there is no match,  data is not loaded, or there is no {@link ResultSet#getDataSource
     * 'dataSource'}.
     * @param keyValue primary key value to search for
     *
     * @return the record with a matching primary key field, or null if not found
     */
    public native Record findByKey(String keyValue) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.findByKey(keyValue);
        if(ret == null || ret === undefined) return null;
        var retVal = @com.smartgwt.client.core.RefDataClass::getRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
        if(retVal == null) {
            retVal = @com.smartgwt.client.data.Record::new(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
        }
        return retVal;
    }-*/;


    /**
     * Notification fired when data has arrived from the server and has been successfully integrated into the cache. <P> When
     * <code>dataArrived()</code> fires, an immediate call to <code>getRange()</code> with the <code>startRow</code> and
     * <code>endRow</code> passed as arguments will return a List with no {@link ResultSet#getLoadingMarker() loading markers}.
     * @param startRow starting index of rows that have just loaded
     * @param endRow ending index of rows that have just loaded, non-inclusive
     * @deprecated This method is <b>not</b> an override point in SmartGWT.  Use {@link #addDataArrivedHandler} instead.
     */
    public native void dataArrived(int startRow, int endRow) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.dataArrived(startRow, endRow);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     *
     * @param properties set of properties and values to match
     *
     * @return all matching Records or null if none found
     */
    public native Record[] findAll(Map properties) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(@com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(properties));
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(String propertyName, String value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(propertyName, value);
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(String propertyName, int value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(propertyName, value);
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     * <P> Note: JavaScript has no long type, so the long value becomes a JavaScript Number, which has a lesser range than Java long.
     * The range for integer numbers in Javascript is [-9007199254740992,9007199254740992] or [-Math.pow(2,53),Math.pow(2,53)].
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(String propertyName, Long value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(propertyName, value);
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(String propertyName, float value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(propertyName, value);
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(String propertyName, boolean value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(propertyName, value);
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Find all objects where property == value in the object.
     *
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(String propertyName, Date value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(propertyName, @com.smartgwt.client.util.JSOHelper::convertToJavaScriptDate(Ljava/util/Date;)(value));
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Filters all objects according to the AdvancedCriteria passed and will not trigger a fetch.
     *
     * @param adCriteria AdvancedCriteria to use to filter results
     *
     * @return all matching Objects or null if none found
     */
    public native Record[] findAll(AdvancedCriteria adCriteria) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordsJS = self.findAll(adCriteria.@com.smartgwt.client.core.DataClass::getJsObj()());
        return recordsJS == null || recordsJS === undefined ? null : @com.smartgwt.client.data.Record::convertToRecordArray(Lcom/google/gwt/core/client/JavaScriptObject;)(recordsJS);
    }-*/;

    /**
     * Checks only loaded rows and will not trigger a fetch.
     * @param properties set of properties and values to match
     *
     * @return first matching object or null if not found
     */
    public native Record find(Map  properties) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordJS = self.find(@com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(properties));
        return recordJS == null || recordJS === undefined ? null : @com.smartgwt.client.data.Record::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(recordJS);
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#find}.  Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     *
     * @return first matching object or null if not found
     */
    public native Record find(String propertyName, Object value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var recordJS = self.find(propertyName, value);
        return recordJS == null || recordJS === undefined ? null : @com.smartgwt.client.data.Record::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(recordJS);
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param properties set of properties and values to
     * match
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(Map properties) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(@com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(properties));
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(String propertyName, String value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(propertyName, value);
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(String propertyName, int value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(propertyName, value);
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * <P> Note: JavaScript has no long type, so the long value becomes a JavaScript Number, which has a lesser range than Java long.
     * The range for integer numbers in Javascript is [-9007199254740992,9007199254740992] or [-Math.pow(2,53),Math.pow(2,53)].
     * @param propertyName property to match
     * @param value value to compare against
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(String propertyName, Long value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(propertyName, value);
    }-*/;
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(String propertyName, float value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(propertyName, value);
    }-*/;
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(String propertyName, boolean value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(propertyName, value);
    }-*/;
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param propertyName property to match
     * @param value value to compare against
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findIndex(String propertyName, Date value) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findIndex(propertyName, @com.smartgwt.client.util.JSOHelper::convertToJavaScriptDate(Ljava/util/Date;)(value));
    }-*/;    
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param startIndex first index to consider
     * @param properties set of properties and values to match
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, Map properties) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, @com.smartgwt.client.util.JSOHelper::convertMapToJavascriptObject(Ljava/util/Map;)(properties));
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param startIndex first index to consider
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     * @param endIndex last index to consider
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, String propertyName, String value, int endIndex) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, propertyName, value, endIndex);
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param startIndex first index to consider
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     * @param endIndex last index to consider
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, String propertyName, int value, int endIndex) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, propertyName, value, endIndex);
    }-*/;

    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * <P> Note: JavaScript has no long type, so the long value becomes a JavaScript Number, which has a lesser range than Java long.
     * The range for integer numbers in Javascript is [-9007199254740992,9007199254740992] or [-Math.pow(2,53),Math.pow(2,53)].
     * @param startIndex first index to consider
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     * @param endIndex last index to consider
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, String propertyName, Long value, int endIndex) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, propertyName, value, endIndex);
    }-*/;
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param startIndex first index to consider
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     * @param endIndex last index to consider
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, String propertyName, float value, int endIndex) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, propertyName, value, endIndex);
    }-*/;
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param startIndex first index to consider
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     * @param endIndex last index to consider
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, String propertyName, boolean value, int endIndex) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, propertyName, value, endIndex);
    }-*/;
    
    /**
     * Like {@link com.smartgwt.client.data.RecordList#findNextIndex}.  Checks only loaded rows and will not trigger a fetch.
     * @param startIndex first index to consider
     * @param propertyName property to match
     * @param value value to compare against (if propertyName is a string)
     * @param endIndex last index to consider
     *
     * @return index of the first matching Record or -1 if not found
     */
    public native int findNextIndex(int startIndex, String propertyName, Date value, int endIndex) /*-{
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        return self.findNextIndex(startIndex, propertyName, @com.smartgwt.client.util.JSOHelper::convertToJavaScriptDate(Ljava/util/Date;)(value), endIndex);
    }-*/;    

    // ********************* Static Methods ***********************

    public static native boolean isResultSet(JavaScriptObject data) /*-{
        return $wnd.isc.isA.ResultSet(data);
    }-*/;

    /**
     * Returns the singleton marker object that is used as a placeholder for records that are being
     * loaded from the server.
     * @return the loading marker
     */
    public static native Record getLoadingMarker() /*-{
        var recordJS = $wnd.isc.ResultSet.getLoadingMarker();
        return @com.smartgwt.client.core.RefDataClass::getRef(Lcom/google/gwt/core/client/JavaScriptObject;)(recordJS);
    }-*/;

}
