
package com.smartgwt.client.docs;

/**
 * <h3>ComboBoxItem criteria</h3>
 * A ComboBoxItem generates two different types of criteria in different circumstances:
 * <ol><li>The criteria used against the {@link
 * com.smartgwt.client.widgets.form.fields.ComboBoxItem#getOptionDataSource optionDataSource}     
 * to retrieve what is shown in the drop-down {@link
 * com.smartgwt.client.widgets.form.fields.ComboBoxItem#getPickList pickList},          and also
 * to retrieve individual display values via the {@link
 * com.smartgwt.client.widgets.form.fields.TextItem#getFetchMissingValues fetchMissingValues}     
 * behavior</li>     <li>The criteria that are generated for searching in some other component    
 * when the ComboBoxItem is used as part of a {@link com.smartgwt.client.widgets.form.SearchForm},
 * such as in the          {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
 * FilterEditor of a ListGrid}, or in a          separate SearchForm (perhaps configured via
 * {@link com.smartgwt.client.widgets.grid.ListGrid#getSearchForm ListGrid.searchForm})</li> </ol>
 * This overview covers the latter case: how a ComboBoxItem creates criteria for searching some in
 * some other component. <P> <b>Explicitly selected option:</b><br> If a user explicitly selects
 * an option from the ComboBox drop down pickList,  default behavior is to generate an {@link
 * com.smartgwt.client.widgets.form.fields.ComboBoxItem#hasAdvancedCriteria advanced criterion}
 * with {@link com.smartgwt.client.types.OperatorId operator:"equals"} to exactly match the
 * selected option. <P> This reflects user expectation.  If you are, for example, filtering a grid
 * of Orders,  and you have a ComboBoxItem as part of a search interface that allows you to pick a
 * specific salesRep, then you expect to see only orders handled by that salesRep. <P> Exceptions:
 * If the target DataSource does not  {@link
 * com.smartgwt.client.data.DataSource#supportsAdvancedCriteria support advanced criteria}, or
 * {@link com.smartgwt.client.widgets.form.fields.ComboBoxItem#getGenerateExactMatchCriteria
 * ComboBoxItem.generateExactMatchCriteria} has been explicitly set to false, simple criteria will
 * be generated. Also note that if a {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#getOperator ComboBoxItem.operator} has been
 * specified, it will be used instead of setting the operator to <code>"equals"</code>. <P>
 * <b>Unrecognized value:</b><br> If, instead of picking an option, a user enters some text into
 * the ComboBoxItem's  textbox that does not exactly match one of the available options, the
 * generated filter criterion will not be an advanced criterion by default.  Instead it will
 * behave like a normal {@link com.smartgwt.client.widgets.form.fields.TextItem}, generating a
 * simple criterion value unless advanced criteria were  {@link
 * com.smartgwt.client.widgets.form.DynamicForm#getValuesAsAdvancedCriteria explicitly requested},
 * or the item also has a specified {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#getOperator ComboBoxItem.operator}. <P> This
 * again reflects user expectation.  If you are, for example, filtering a grid  of Orders, and you
 * have a ComboBoxItem as part of a search interface that  allows you to pick Sales Reps, then if
 * you enter just "John",  you would expect to see all orders that were handled by anyone named
 * "John". <P> <b>Criterion field</b>:<br> By default, if a specific value has been chosen,  the
 * generated Criterion targets the valueField with an exact match  (with exceptions explained
 * above). <P> However, if a search value has been entered without picking a specific record,  the
 * generated Criterion targets the displayField if it differs from the valueField.  This is
 * correct behavior - if we consider the example of showing all Orders entered by any Sales Rep
 * called "John", we'd need to apply criteria to the  display field (containing the Sales Reps'
 * names) rather than the  valueField (likely to be an ID or similar). <P> Developers may override
 * this behavior by specifying an explicit  {@link
 * com.smartgwt.client.widgets.form.fields.FormItem#getCriteriaField ComboBoxItem.criteriaField}.
 * If specified this will be used in the generated criteria whether the user selected an option
 * from the pickList or entered a new value into the text box.
 */
public interface ComboBoxItemCriteria {
}
