/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.Authentication;
import com.isomorphic.auth.ConfigAuthenticator;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.RegexRule;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
extends URIRegexFilter {
    public String loginPage = "/isomorphic/login/iscAuth/login.html";
    public String logoutPage = "/isomorphic/login/iscAuth/logout.html";
    public String maxLoginAttemptsExceededPage = "/isomorphic/login/iscAuth/maxLoginAttemptsExceeded.html";
    public String defaultLoginRedirect = "/";
    public String initialTargetParam = "initialTarget";
    public int maxTries = -1;
    public String realm;
    public int securityLevel = 0;
    public String username;
    public String password;
    protected IAuthenticator authenticator = null;
    protected Logger log;
    protected boolean enabled = Authentication.enabled;
    protected String filterName;

    public void setLoginPage(String value) {
        this.loginPage = value;
    }

    public void setLogoutPage(String value) {
        this.logoutPage = value;
    }

    public void setMaxLoginAttemptsExceededPage(String value) {
        this.maxLoginAttemptsExceededPage = value;
    }

    public void setDefaultLoginRedirect(String value) {
        this.defaultLoginRedirect = value;
    }

    public void setInitialTargetParam(String value) {
        this.initialTargetParam = value;
    }

    public void setMaxTries(String value) {
        this.maxTries = Integer.valueOf(value);
    }

    public void setRealm(String value) {
        this.realm = value;
    }

    public void setSecurityLevel(String value) {
        this.securityLevel = Integer.valueOf(value);
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setAuthenticator(String value) throws Exception {
        this.authenticator = Authentication.getAuthenticator(value);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.username != null && this.password != null && ServletTools.servletOrFilterParametersToMap(filterConfig).get("authenticator") == null) {
            try {
                this.setAuthenticator("simpleConfig");
            }
            catch (Exception e) {
                this.log.error((Object)"can't auto-initialize simpleConfig authenticator - check your configuration", e);
                throw new ServletException(e.toString());
            }
        }
        if (this.authenticator instanceof ConfigAuthenticator) {
            if (this.username != null) {
                ((ConfigAuthenticator)this.authenticator).username = this.username;
            }
            if (this.password != null) {
                ((ConfigAuthenticator)this.authenticator).password = this.password;
            }
        }
        if (this.realm == null) {
            this.realm = filterConfig.getFilterName();
        }
        this.log = new Logger(this.getClass().getName(), filterConfig.getFilterName() + " (realm: " + this.realm + ", securityLevel: " + this.securityLevel + ")");
        try {
            if (!this.enabled) {
                this.log.warn("AuthenticationFilter present in web.xml, but authentication globally disabled in config via authentication.enabled: false.  Not initializing, will allow all requests without any checks.");
                return;
            }
            this.setDefaultAction("match");
            if (this.rules == null) {
                this.log.info("No rules file defined, treating all intercepted resources as private");
            } else {
                try {
                    this.rules.add(0, new RegexRule("match:#^/isomorphic/login/loginSuccessMarker.html#", "authFilter default"));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error initializing known good regex rule", e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize AuthenticationFilter.", e);
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        RequestContext context = null;
        boolean pushedLogContext = false;
        try {
            block106: {
                RegexRule matchedRule;
                String comparePath;
                block108: {
                    Iterator i;
                    block109: {
                        block107: {
                            if (!this.enabled) {
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                return;
                            }
                            request.setAttribute("_isc_authenticationEnabled", (Object)new Boolean(true));
                            context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
                            context.session = request.getSession(true);
                            Authentication.setAuthenticator(context, this.authenticator);
                            Authentication.setRealm(context, this.realm);
                            comparePath = ServletTools.getCanonicalRequestURI(request);
                            String initialTarget = context.request.getQueryParameter(this.initialTargetParam);
                            if (comparePath.equals(this.loginPage) && initialTarget != null) {
                                Authentication.setInitialTarget(context, initialTarget);
                            }
                            if (initialTarget == null) {
                                initialTarget = Authentication.getInitialTarget(context);
                            }
                            Object user = null;
                            if (this.authenticator.containsCredentials(context)) {
                                int loginCounter = Authentication.getLoginCounter(context);
                                if (this.maxTries > 0 && loginCounter < this.maxTries || this.maxTries < 0) {
                                    user = this.authenticator.authenticate(context);
                                    if (user != null) {
                                        this.log.info("Authentication attempt succeeded");
                                        String username = this.authenticator.getUsername(context, user);
                                        Authentication.setUsername(context, username);
                                        if (user instanceof Serializable) {
                                            Authentication.setUser(context, user);
                                        } else {
                                            this.log.debug("User object is not serializeable, will not be available in session.  Object is of type: " + user.getClass().getName());
                                        }
                                        Authentication.setLoginCounter(context, 0);
                                        if (this.securityLevel > Authentication.getAchievedSecurityLevel(context)) {
                                            Authentication.setAchievedSecurityLevel(context, this.securityLevel);
                                        }
                                        Authentication.setInitialTarget(context, null);
                                        ServletTools.clearCookie("loginRedirect", context, this.loginPage, null);
                                        if (comparePath.equals(this.loginPage)) {
                                            if (initialTarget == null) {
                                                initialTarget = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                                            }
                                            this.log.debug("Sending to initial target: " + initialTarget);
                                            response.sendRedirect(initialTarget);
                                            return;
                                        }
                                    } else {
                                        if (this.maxTries > 0) {
                                            Authentication.setLoginCounter(context, ++loginCounter);
                                        }
                                        this.log.info("Authentication failed, try # " + loginCounter);
                                    }
                                }
                                if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                                    this.log.debug("Attempt to authenticate, but maxTries (" + this.maxTries + ") has been reached");
                                    this.maxLoginsExceeded(context, comparePath);
                                    return;
                                }
                            }
                            if (comparePath.equals("/favicon.ico")) {
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                return;
                            }
                            if (comparePath.equals(this.maxLoginAttemptsExceededPage)) {
                                context.setNoCacheHeaders();
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                return;
                            }
                            if (comparePath.equals(this.logoutPage)) {
                                this.log.debug("Logging out (uid: " + Authentication.getUsername(context) + ")");
                                Authentication.clearAuthInfo(context);
                                context.setNoCacheHeaders();
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                return;
                            }
                            if (comparePath.equals(this.loginPage)) {
                                String currentRedirect;
                                String loginRedirect = Authentication.getInitialTarget(context);
                                if (loginRedirect == null) {
                                    loginRedirect = ServletTools.adjustForContextPath(this.defaultLoginRedirect, request);
                                }
                                if ((currentRedirect = ServletTools.getCookieValue("loginRedirect", (HttpServletRequest)context.request)) == null) {
                                    ServletTools.setCookie(context, "loginRedirect", loginRedirect, this.loginPage);
                                }
                                if (Authentication.getInitialTargetJsCallback(context) != null) {
                                    RPCManager.writeIframePrefix(response.getWriter(), null, context, Authentication.getInitialTargetJsCallback(context));
                                }
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                if (Authentication.getInitialTargetJsCallback(context) == null) return;
                                RPCManager.writeIframePostfix(response.getWriter());
                                Authentication.clearInitialTargetJsCallback(context);
                                return;
                            }
                            matchedRule = null;
                            if (this.rules == null) break block107;
                            if (this.useURICache) {
                                matchedRule = (RegexRule)this.uriCache.get(comparePath);
                            }
                            if (matchedRule != null) break block108;
                            i = this.rules.iterator();
                            break block109;
                        }
                        matchedRule = this.defaultRule;
                        break block108;
                    }
                    while (i.hasNext()) {
                        RegexRule rule = (RegexRule)i.next();
                        boolean match = false;
                        try {
                            match = rule.match(comparePath);
                        }
                        catch (Exception e) {
                            this.log.warn("Syntax error in rule: " + rule.toString() + " - ignoring rule");
                        }
                        if (!match) continue;
                        matchedRule = rule;
                        break;
                    }
                    if (matchedRule == null) {
                        matchedRule = this.defaultRule;
                    }
                    if (this.useURICache) {
                        this.uriCache.put(comparePath, matchedRule);
                    }
                }
                if (matchedRule.getAction().equals("block")) {
                    context.response.sendError(404);
                    this.log.warn("DENIED to access blocked resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
                    return;
                }
                if (matchedRule.getAction().equals("match")) {
                    int achievedSecurityLevel = Authentication.getAchievedSecurityLevel(context);
                    if (Authentication.getUser(context) != null && achievedSecurityLevel >= this.securityLevel) {
                        this.log.debug("ALLOWED authenticated access (uid: " + Authentication.getUsername(context) + ") to private resource: " + comparePath);
                        break block106;
                    } else {
                        Map reqProps;
                        String t;
                        context.setNoCacheHeaders();
                        int loginCounter = Authentication.getLoginCounter(context);
                        if (this.maxTries > 0 && loginCounter >= this.maxTries) {
                            this.maxLoginsExceeded(context, comparePath);
                            return;
                        }
                        Authentication.setInitialTarget(context, this.getInitialTarget(context));
                        if (context.request.isMultipart() && (t = (String)(reqProps = context.request.getStringParams()).get("_transaction")) != null) {
                            ValidationContext vc = new ValidationContext();
                            vc.setRestrictedXMLMode(true);
                            Object to = XML.toDSRecords(new StringReader(t), vc);
                            vc.freeResources();
                            Authentication.setInitialTargetJsCallback(context, (String)((Map)to).get("jscallback"));
                        }
                        response.sendRedirect(ServletTools.adjustForContextPath(this.loginPage, request));
                        String why = "not authenticated for realm: " + this.realm;
                        if (achievedSecurityLevel < this.securityLevel) {
                            why = "resource requires securityLevel: " + this.securityLevel + ", user has achieved securityLevel: " + achievedSecurityLevel;
                        }
                        this.log.debug("REDIRECTING user to login page: " + this.loginPage + " for access to private resource: " + comparePath + " (" + why + ")");
                        return;
                    }
                }
                this.log.debug("ALLOWED access to public resource: " + comparePath + " (matched by rule: " + matchedRule.toString() + ")");
            }
            String uid = Authentication.getUsername(context);
            if (uid != null && request.getAttribute("isc_auth_uid") == null) {
                Logger.pushContext("uid: " + uid);
                pushedLogContext = true;
                request.setAttribute("isc_auth_uid", (Object)uid);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            this.log.error("Caught exception in doFilter() - for URI: " + request.getRequestURI() + "\n" + DataTools.getStackTrace(e));
            return;
        }
        finally {
            if (pushedLogContext) {
                Logger.popContext();
            }
            if (context != null) {
                try {
                    context.completeResponse();
                }
                catch (Exception exception) {}
                try {
                    response.flushBuffer();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getInitialTarget(RequestContext context) {
        String queryString = context.request.getQueryString();
        String initialTarget = context.requestPath;
        if (queryString != null && queryString.length() > 0) {
            if (!queryString.startsWith("?")) {
                initialTarget = initialTarget + "?";
            }
            initialTarget = initialTarget + queryString;
        }
        return initialTarget;
    }

    private void maxLoginsExceeded(RequestContext context, String comparePath) throws Exception {
        context.request.setAttribute("isc.TOO_MANY_LOGIN_ATTEMPTS", new Integer(this.maxTries));
        String maxTriesURL = this.maxLoginAttemptsExceededPage;
        if (maxTriesURL == null) {
            this.log.warn("maxTries is set, but maxLoginAttemptsExceededPage is not defined, defaulting to loginPage");
            maxTriesURL = this.loginPage;
        }
        this.log.debug("REDIRECTING user to: " + maxTriesURL + " for access to private resource: " + comparePath + " (user exceeded maximum login attempts limit of " + this.maxTries + ")");
        context.response.sendRedirect(ServletTools.adjustForContextPath(maxTriesURL, (HttpServletRequest)context.request));
    }
}

