/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.CanParseCriterion;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperatorBase
implements CanParseCriterion,
Operator {
    public static final String CRITERIA_KEY = "criteria";
    public static final String VALUE_KEY = "value";
    public static final String FIELD_NAME_KEY = "fieldName";
    public static final String OPERATOR_KEY = "operator";

    @Override
    public Criterion parseCriterion(Map criteriaData) {
        String operatorId = (String)criteriaData.get(OPERATOR_KEY);
        if (!operatorId.equals(this.getID())) {
            return null;
        }
        String fieldName = (String)criteriaData.get(FIELD_NAME_KEY);
        if (this.isRequiresFieldName() && StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        Object value = criteriaData.get(VALUE_KEY);
        if (this.isRequiresValue() && value == null) {
            return null;
        }
        List rawCriteriaList = (List)criteriaData.get(CRITERIA_KEY);
        if (this.isRequiresCriteria() && rawCriteriaList == null) {
            return null;
        }
        ArrayList<Criterion> criteria = null;
        if (rawCriteriaList != null) {
            criteria = new ArrayList<Criterion>(rawCriteriaList.size());
            for (Object c : rawCriteriaList) {
                if (c instanceof Map) {
                    criteria.add(Evaluator.parseCriterion((Map)c));
                    continue;
                }
                if (!(c instanceof Criterion)) continue;
                criteria.add((Criterion)c);
            }
        }
        return this.parseCriterion(fieldName, value, criteria);
    }

    public abstract boolean isRequiresFieldName();

    public abstract boolean isRequiresValue();

    public abstract boolean isRequiresCriteria();

    public abstract Criterion parseCriterion(String var1, Object var2, List<Criterion> var3);

    public abstract Map convertToMap(Criterion var1);
}

