/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.ExcelFormulaParser;
import com.isomorphic.rpc.OOXMLDataExport;
import com.isomorphic.util.DataTools;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDataExport
extends Base {
    private static Logger log = new Logger(ExcelDataExport.class.getName());
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+");
    private Workbook workbook;
    List<String> headers;
    private boolean exportSpans;
    CellStyle headerSpanStyle;
    List<HeaderSpan> headerSpans = new ArrayList<HeaderSpan>();
    private Map colorCache = new HashMap();
    private Map styleCache = new HashMap();
    private Map fontCache = new HashMap();
    private Map formatCache = new HashMap();

    public static Class getExportObjectType() throws ClassNotFoundException {
        return Reflection.classForName("org.apache.poi.ss.usermodel.Workbook");
    }

    static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out, null, null);
    }

    static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out1, Writer out2, Map settings, DataSource dataSource) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out1, out2, settings, dataSource);
    }

    static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out1, Writer out2, OutputStream os1, OutputStream os2, Map settings, DataSource dataSource) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out1, out2, os1, os2, settings, dataSource);
    }

    public static void exportResultSet(DataExport export, boolean ooxml, List dataRows, Map columnRemap, OutputStream out) throws Exception {
        new ExcelDataExport().export(export, ooxml, dataRows, columnRemap, out, null, null);
    }

    void export(DataExport export, boolean ooxml, List dataRows, Map columnRemap, OutputStream out, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataRows, columnRemap, null, null, out, null, settings, dataSource);
    }

    void export(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataRows, columnRemap, out, null, null, null, settings, dataSource);
    }

    void export(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out1, Writer out2, Map settings, DataSource dataSource) throws Exception {
        this.export(export, ooxml, dataRows, columnRemap, out1, out2, null, null, settings, dataSource);
    }

    public void export(DataExport export, boolean ooxml, List dataRows, Map columnRemap, Writer out1, Writer out2, OutputStream os1, OutputStream os2, Map settings, DataSource dataSource) throws Exception {
        this.writeExportObject(this.getExportObject(export, ooxml, dataRows, columnRemap, settings, dataSource), out1, out2, os1, os2);
    }

    public Object getExportObject(DataExport export, boolean ooxml, List dataRows, Map<String, String> columnRemap, Map settings, DataSource dataSource) throws Exception {
        try {
            String exportFooter;
            Row row;
            Collection<String> columns;
            if (ooxml) {
                try {
                    this.workbook = OOXMLDataExport.getXSSFWorkbook();
                }
                catch (NoClassDefFoundError e) {
                    throw new Exception("Trouble loading Apache POI OOXML classes - are the poi-ooxml and poi-ooxml-schemas .jar files deployed?  These are required in addition to the base POI .jar if you want to export in Excel 2007 format", e);
                }
            } else {
                this.workbook = new HSSFWorkbook();
            }
            if (settings == null) {
                settings = new HashMap();
                if (export.settings == null) {
                    export.settings = settings;
                }
            }
            Sheet worksheet = this.workbook.createSheet();
            if (export.order != null) {
                columns = export.order;
                if (columnRemap == null) {
                    this.headers = new ArrayList<String>(columns);
                } else {
                    this.headers = new ArrayList<String>();
                    for (String col : export.order) {
                        String remapped = (String)columnRemap.get(col);
                        if (remapped != null) {
                            this.headers.add(remapped);
                            continue;
                        }
                        this.headers.add(col);
                    }
                }
            } else {
                if (columnRemap == null) {
                    columnRemap = export.getColumnNames(dataRows);
                }
                columns = columnRemap.keySet();
                this.headers = new ArrayList(columnRemap.values());
            }
            int rowIndex = 0;
            int cellIndex = 0;
            String exportHeader = (String)settings.get("exportHeader");
            if (exportHeader != null && !exportHeader.equals("")) {
                row = worksheet.createRow(rowIndex++);
                worksheet.addMergedRegion(new CellRangeAddress(0, 0, 0, this.headers.size() - 1));
                Cell cell = row.createCell(0, 1);
                cell.setCellValue(exportHeader);
                row = worksheet.createRow(rowIndex++);
            }
            boolean headerless = false;
            int headerRow = 0;
            if (settings.get("exportHeaderless") != null) {
                headerless = DataTools.asBoolean(settings.get("exportHeaderless"), false);
            }
            if (!headerless) {
                this.headerSpanStyle = this.workbook.createCellStyle();
                this.headerSpanStyle.setAlignment((short)2);
                rowIndex = this.calcHeaderSpans(worksheet, export, rowIndex);
                this.calcOtherFields(worksheet, export, rowIndex);
                headerRow = rowIndex++;
            }
            CellStyle wrapStyle = this.workbook.createCellStyle();
            wrapStyle.setWrapText(true);
            List formulaFields = (List)settings.get("formulaFields");
            List formulaRemap = (List)settings.get("formulaRemap");
            HashMap<String, Integer> indexedColumns = new HashMap<String, Integer>();
            Integer index = 0;
            Iterator<String> i = columns.iterator();
            while (i.hasNext()) {
                indexedColumns.put(i.next(), index);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            FormulaEvaluator evaluator = null;
            HashMap<String, Map> formulas = new HashMap<String, Map>();
            if (formulaFields != null) {
                evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
                for (int i2 = 0; i2 < formulaFields.size(); ++i2) {
                    Map formulaField = (Map)formulaFields.get(i2);
                    Map vars = (Map)formulaField.get("formulaVars");
                    HashMap newVars = new HashMap();
                    if (vars != null) {
                        for (Map.Entry e : vars.entrySet()) {
                            String key = (String)e.getKey();
                            if (newVars.containsKey(key)) continue;
                            newVars.put(key, indexedColumns.get(e.getValue()));
                        }
                    }
                    formulaField.put("newVars", newVars);
                    formulas.put((String)formulaField.get("name"), formulaField);
                }
            }
            Iterator i3 = dataRows.iterator();
            while (i3.hasNext() && (ooxml || rowIndex < 65536)) {
                Map record;
                Object o = i3.next();
                if (o instanceof Map) {
                    record = (Map)o;
                } else if (dataSource != null) {
                    record = dataSource.getProperties(o);
                } else {
                    log.warn("Either provide a collection of Maps or a DataSource; can't export " + o.getClass().getName());
                    continue;
                }
                if (record == null) continue;
                row = worksheet.createRow(rowIndex++);
                cellIndex = 0;
                for (String columnName : columns) {
                    if (columnName.indexOf("$style") != -1) continue;
                    Object cellValue = record.get(columnName);
                    String stringifiedValue = cellValue == null ? null : cellValue.toString();
                    Cell cell = null;
                    Object styleObj = record.get(columnName + "$style");
                    ArrayList styles = null;
                    if (styleObj != null) {
                        if (styleObj instanceof List) {
                            styles = (ArrayList)styleObj;
                        } else {
                            styles = new ArrayList();
                            styles.add(styleObj);
                        }
                    }
                    boolean formulaWasSet = false;
                    Map formula = (Map)formulas.get(columnName);
                    if (formula != null) {
                        String text = (String)formula.get("text");
                        Map vars = (Map)formula.get("newVars");
                        Matcher matcher = WORD_PATTERN.matcher(text);
                        StringBuffer replaceBuffer = new StringBuffer();
                        while (matcher.find()) {
                            Integer mappedIndex = (Integer)vars.get(matcher.group());
                            if (mappedIndex == null) continue;
                            String newVar = new CellReference(row.getRowNum(), mappedIndex.intValue()).formatAsString();
                            matcher.appendReplacement(replaceBuffer, newVar);
                        }
                        matcher.appendTail(replaceBuffer);
                        String transformedFormula = ExcelFormulaParser.transform(replaceBuffer.toString());
                        cell = row.createCell(cellIndex, 2);
                        cell.setCellFormula(transformedFormula);
                        if (evaluator.evaluateFormulaCell(cell) == 5) {
                            cell.setCellFormula(null);
                        } else {
                            formulaWasSet = true;
                        }
                    }
                    this.normalizeBackgroundColor(styles);
                    Map styleElements = null;
                    if (styles != null) {
                        styleElements = (Map)styles.get(0);
                    }
                    if (!(formulaWasSet || cellValue == null && styleElements == null)) {
                        DSField field;
                        char trailing;
                        String work;
                        if (styleElements != null && styleElements.get("rawValue") != null) {
                            cellValue = styleElements.get("rawValue");
                        }
                        if (cellValue instanceof String && ((String)cellValue).trim().indexOf("0") != 0 && (work = ((String)cellValue).trim()).length() > 0 && !Character.isLetter(trailing = work.charAt(work.length() - 1))) {
                            try {
                                cellValue = new Double((String)cellValue);
                            }
                            catch (NumberFormatException replaceBuffer) {
                                // empty catch block
                            }
                        }
                        if (cellValue instanceof Number) {
                            cell = row.createCell(cellIndex, 0);
                            cell.setCellValue(((Number)cellValue).doubleValue());
                        } else if (cellValue instanceof Date) {
                            if (DataTools.getBoolean(settings, "exportDatesAsFormattedString")) {
                                cell = row.createCell(cellIndex, 1);
                                cell.setCellValue(DataTools.fastDateFormat((Date)cellValue));
                            } else {
                                cell = row.createCell(cellIndex, 0);
                                double excelDateValue = DateUtil.getExcelDate((Date)((Date)cellValue));
                                cell.setCellValue(excelDateValue);
                            }
                        } else if (cellValue instanceof Collection) {
                            String separator;
                            String value = null;
                            if (dataSource != null && dataSource.getField(columnName) != null && (separator = (field = dataSource.getField(columnName)).getProperty("multipleValueSeparator")) != null && field.isMultiple()) {
                                for (Object element : (Collection)cellValue) {
                                    if (element == null) continue;
                                    if (value == null) {
                                        value = element.toString();
                                        continue;
                                    }
                                    value = value + separator + element.toString();
                                }
                            }
                            if (value == null) {
                                value = cellValue == null ? null : cellValue.toString();
                            }
                            cell = row.createCell(cellIndex, 1);
                            cell.setCellValue(value);
                        } else {
                            cell = row.createCell(cellIndex, 1);
                            cell.setCellValue(cellValue == null ? null : cellValue.toString());
                        }
                        if (styleElements != null) {
                            if (styleElements.get("style") != null) {
                                styleElements = (Map)styleElements.get("style");
                            }
                            if (cellValue instanceof Date) {
                                String dateFormatter = (String)styleElements.get("dateFormatter");
                                if (dateFormatter != null) {
                                    cell.setCellStyle(this.getCellStyle(styleElements, false, null));
                                } else {
                                    cellValue = stringifiedValue;
                                }
                            } else {
                                cell.setCellStyle(this.getCellStyle(styleElements, false, null));
                            }
                        } else if (cellValue instanceof Date) {
                            String dsfDateFormatter = null;
                            if (dataSource != null && (field = dataSource.getField(columnName)) != null) {
                                dsfDateFormatter = field.getProperty("dateFormatter");
                            }
                            cell.setCellStyle(this.getCellStyle(null, true, dsfDateFormatter));
                        } else {
                            cell.setCellStyle(wrapStyle);
                        }
                        if (styles != null && styles.size() > 1) {
                            cell.setCellValue(this.buildRichTextString(styles, stringifiedValue));
                        }
                    }
                    ++cellIndex;
                }
            }
            if (!ooxml && rowIndex >= 65536) {
                log.warn("Dataset contains more than 65535 rows, making it too large for the XLS format.  Exporting just the first 65535 rows");
            }
            if ((exportFooter = (String)settings.get("exportFooter")) != null && !exportFooter.equals("") && (ooxml || rowIndex < 65535)) {
                row = worksheet.createRow(rowIndex++);
                row = worksheet.createRow(rowIndex);
                worksheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, this.headers.size() - 1));
                Cell cell = row.createCell(0, 1);
                cell.setCellValue(exportFooter);
            }
            if (!headerless) {
                if (this.exportSpans) {
                    this.outputHeaderSpans(worksheet);
                } else {
                    row = worksheet.createRow(headerRow);
                    cellIndex = 0;
                    for (String header : this.headers) {
                        if (header.indexOf("$style") != -1) continue;
                        if (header != null) {
                            Cell cell = row.createCell(cellIndex, 1);
                            cell.setCellValue(header);
                        }
                        ++cellIndex;
                    }
                }
            }
            for (int i4 = 0; i4 < columns.size(); ++i4) {
                try {
                    worksheet.autoSizeColumn(i4);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.workbook;
    }

    protected int calcHeaderSpans(Sheet worksheet, DataExport export, int rowIndex) {
        List spans = (List)export.settings.get("exportHeaderSpans");
        boolean bl = this.exportSpans = spans != null && spans.size() > 0;
        if (this.exportSpans && export.settings.containsKey("exportShowHeaderSpanTitles")) {
            this.exportSpans = DataTools.asBoolean(export.settings.get("exportShowHeaderSpanTitles"));
        }
        if (!this.exportSpans) {
            return rowIndex;
        }
        return this._calcHeaderSpans(worksheet, spans, rowIndex, 0);
    }

    protected int _calcHeaderSpans(Sheet worksheet, List spans, int rowIndex, int colIndex) {
        int tmpRowIndex = rowIndex + 1;
        for (Map span : spans) {
            List fields;
            String title = (String)span.get("title");
            List<Integer> columnsSpanned = this.getColumnsSpanned(span);
            List subSpans = (List)span.get("spans");
            if (subSpans != null) {
                tmpRowIndex = Math.max(tmpRowIndex, rowIndex + this._calcHeaderSpans(worksheet, subSpans, rowIndex + 1, colIndex));
            }
            colIndex += columnsSpanned.size();
            int first = -1;
            int last = -1;
            for (int j = 0; j < columnsSpanned.size(); ++j) {
                int colNum = columnsSpanned.get(j);
                if (first == -1) {
                    first = colNum;
                } else if (colNum != last + 1) {
                    this.rearrangeSpannedColumns(columnsSpanned);
                    break;
                }
                last = colNum;
            }
            if (first <= -1 || last <= -1) {
                last = first = colIndex;
            }
            HeaderSpan hs = new HeaderSpan();
            hs.row = rowIndex;
            hs.startCol = first;
            hs.endCol = last;
            hs.title = title;
            this.headerSpans.add(hs);
            if (subSpans != null || (fields = (List)span.get("fields")) == null) continue;
            for (Map field : fields) {
                hs = new HeaderSpan();
                hs.row = rowIndex + 1;
                hs.endCol = hs.startCol = this.headers.indexOf(field.get("name"));
                hs.title = (String)field.get("title");
                this.headerSpans.add(hs);
            }
        }
        return tmpRowIndex;
    }

    protected List<Integer> getColumnsSpanned(Map span) {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        List subSpans = (List)span.get("spans");
        if (subSpans != null) {
            Iterator i = subSpans.iterator();
            while (i.hasNext()) {
                columns.addAll(this.getColumnsSpanned((Map)i.next()));
            }
        } else {
            List fields = (List)span.get("fields");
            if (fields == null) {
                log.warn("Found a headerSpan definition with neither spans nor fields defined - ignoring");
            } else {
                for (Map field : fields) {
                    if (field == null) continue;
                    String fieldName = (String)field.get("name");
                    int colNum = this.headers.indexOf(fieldName);
                    if (colNum == -1) {
                        log.warn("headerSpan definition names an unknown field '" + fieldName + "' - ignoring");
                        continue;
                    }
                    columns.add(colNum);
                }
            }
        }
        Collections.sort(columns);
        return columns;
    }

    protected void rearrangeSpannedColumns(List<Integer> cols) {
        int first;
        ArrayList<String> copyHeaders = new ArrayList<String>(this.headers);
        int last = first = cols.get(0).intValue();
        for (int i = 1; i < cols.size(); ++i) {
            int colNum = cols.get(i);
            if (colNum == last + 1) continue;
            String colName = this.headers.get(colNum);
            String lastColName = this.headers.get(last);
            copyHeaders.remove(colName);
            copyHeaders.add(copyHeaders.indexOf(lastColName) + 1, colName);
        }
        this.headers = copyHeaders;
    }

    protected void calcOtherFields(Sheet worksheet, DataExport export, int rowIndex) {
        Map otherFields = (Map)export.settings.get("exportOtherFields");
        if (otherFields != null) {
            ArrayList<String> copyHeaders = this.exportSpans ? this.headers : new ArrayList<String>(this.headers);
            for (Map.Entry e : otherFields.entrySet()) {
                int pos = copyHeaders.indexOf(e.getKey());
                if (pos < 0) continue;
                String title = (String)e.getValue();
                if (this.exportSpans) {
                    HeaderSpan hs = new HeaderSpan();
                    hs.row = 0;
                    hs.endRow = rowIndex;
                    hs.endCol = hs.startCol = pos;
                    hs.title = title;
                    this.headerSpans.add(hs);
                    continue;
                }
                this.headers.set(pos, title);
            }
        }
    }

    protected void outputHeaderSpans(Sheet worksheet) {
        for (HeaderSpan hs : this.headerSpans) {
            Row row = worksheet.getRow(hs.row);
            if (row == null) {
                row = worksheet.createRow(hs.row);
            }
            for (int j = hs.startCol; j <= hs.endCol; ++j) {
                Cell cell = row.createCell(j, 1);
                if (j == hs.startCol) {
                    cell.setCellValue(hs.title);
                }
                cell.setCellStyle(this.headerSpanStyle);
            }
            if (hs.startCol == hs.endCol && (hs.endRow < 0 || hs.row == hs.endRow)) continue;
            worksheet.addMergedRegion(new CellRangeAddress(hs.row, hs.endRow >= 0 ? hs.endRow : hs.row, hs.startCol, hs.endCol));
        }
    }

    public void writeExportObject(Object exportObject, Writer out1, Writer out2, OutputStream os1, OutputStream os2) throws Exception {
        if (!this.workbook.getClass().isAssignableFrom(exportObject.getClass())) {
            throw new Exception("The supplied export object is of type " + exportObject.getClass().getName() + ".  We were expecting an object of type " + this.workbook.getClass().getName() + " (or a subclass)");
        }
        if (os1 != null) {
            this.workbook.write(os1);
            if (os2 != null) {
                this.workbook.write(os2);
            }
        } else {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)stream);
            byte[] byteArray = stream.toByteArray();
            char[] charArray = new char[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                charArray[i] = (char)(byteArray[i] & 0xFF);
            }
            out1.write(charArray);
            if (out2 != null) {
                out2.write(charArray);
            }
        }
    }

    public void setExportObject(Object exportObject) throws Exception {
        if (!ExcelDataExport.getExportObjectType().isAssignableFrom(exportObject.getClass())) {
            throw new Exception("The supplied export object is of type " + exportObject.getClass().getName() + ".  We were expecting an object of type " + ExcelDataExport.getExportObjectType().getName() + " (or a subclass)");
        }
        this.workbook = (Workbook)exportObject;
    }

    private void normalizeBackgroundColor(List styles) {
        if (styles == null) {
            return;
        }
        Map firstStyle = (Map)styles.get(0);
        if (firstStyle.get("value") == null) {
            return;
        }
        if ((firstStyle = (Map)firstStyle.get("style")) != null && firstStyle.get("backgroundColor") != null) {
            return;
        }
        for (int i = 0; i < styles.size(); ++i) {
            Map style = (Map)((Map)styles.get(i)).get("style");
            if (style == null || style.get("backgroundColor") == null) continue;
            if (firstStyle == null) {
                firstStyle = (Map)styles.get(0);
                firstStyle.put("style", new HashMap());
                firstStyle = (Map)firstStyle.get("style");
            }
            firstStyle.put("backgroundColor", style.get("backgroundColor"));
            break;
        }
    }

    private short getClosestColor(String targetColor) {
        if (this.colorCache.get(targetColor) != null) {
            return (Short)this.colorCache.get(targetColor);
        }
        int red = Integer.parseInt(targetColor.substring(1, 3), 16);
        int green = Integer.parseInt(targetColor.substring(3, 5), 16);
        int blue = Integer.parseInt(targetColor.substring(5), 16);
        int[] targetHsl = this.rgbToHsl(red, green, blue);
        Hashtable excelColors = HSSFColor.getIndexHash();
        float smallestDelta = 960.0f;
        short closestColor = 64;
        for (Integer excelColorIndex : excelColors.keySet()) {
            float lumDelta;
            float satDelta;
            HSSFColor excelColor = (HSSFColor)excelColors.get(excelColorIndex);
            short[] triplet = excelColor.getTriplet();
            int[] hsl = this.rgbToHsl(triplet[0], triplet[1], triplet[2]);
            float hueDelta = Math.abs(targetHsl[0] - hsl[0]);
            if (!(hueDelta + (satDelta = (float)Math.abs(targetHsl[1] - hsl[1])) + (lumDelta = (float)Math.abs(targetHsl[2] - hsl[2])) < smallestDelta)) continue;
            smallestDelta = hueDelta + satDelta + lumDelta;
            closestColor = (short)excelColorIndex.intValue();
        }
        this.colorCache.put(targetColor, new Short(closestColor));
        return closestColor;
    }

    private int[] rgbToHsl(int r, int g, int b) {
        double wr = (double)r / 255.0;
        double wg = (double)g / 255.0;
        double wb = (double)b / 255.0;
        double min = Math.min(Math.min(wr, wg), wb);
        double max = Math.max(Math.max(wr, wg), wb);
        double delta = max - min;
        double h = 0.0;
        double s = 0.0;
        double l = 0.0;
        l = (max + min) / 2.0;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            s = l < 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min);
            h = wr == max ? (wg - wb) / delta : (wg == max ? 2.0 + (wb - wr) / delta : 4.0 + (wr - wg) / delta);
        }
        h = Math.floor(h * 40.0 + 0.5);
        if (h < 0.0) {
            h += 240.0;
        }
        s = Math.floor(s * 40.0 + 0.5);
        l = Math.floor(l * 40.0 + 0.5);
        int[] rtnVal = new int[]{(int)h, (int)s, (int)l};
        return rtnVal;
    }

    private CellStyle getCellStyle(Map cellStyleElements, boolean justApplyDateFormatter, String dsfDateFormatter) {
        String combo;
        Font font = null;
        DataFormat format = null;
        CellStyle style = null;
        String color = null;
        String backgroundColor = null;
        String dateFormatter = null;
        if (cellStyleElements != null) {
            color = (String)cellStyleElements.get("color");
            backgroundColor = (String)cellStyleElements.get("backgroundColor");
            dateFormatter = (String)cellStyleElements.get("dateFormatter");
        }
        if (dateFormatter == null) {
            dateFormatter = dsfDateFormatter;
        }
        if (this.styleCache.get(combo = color + backgroundColor + dateFormatter) != null) {
            style = (CellStyle)this.styleCache.get(combo);
        } else {
            font = this.getFont(cellStyleElements);
            if (dateFormatter != null || justApplyDateFormatter) {
                if (this.formatCache.get(dateFormatter) != null) {
                    format = (DataFormat)this.formatCache.get(dateFormatter);
                } else {
                    format = this.workbook.createDataFormat();
                    this.formatCache.put(dateFormatter, format);
                }
            }
            style = this.workbook.createCellStyle();
            if (backgroundColor != null) {
                style.setFillForegroundColor(this.getClosestColor(backgroundColor));
                style.setFillPattern((short)1);
            }
            if (font != null) {
                style.setFont(font);
            }
            if (format != null) {
                short dataFormat = format.getFormat(this.excelFormatFromSmartClientDateFormatter(dateFormatter));
                style.setDataFormat(dataFormat);
            }
            style.setWrapText(true);
            this.styleCache.put(combo, style);
        }
        return style;
    }

    private Font getFont(Map cellStyleElements) {
        Font font = null;
        if (cellStyleElements != null) {
            String color = (String)cellStyleElements.get("color");
            String fontFamily = (String)cellStyleElements.get("fontFamily");
            String fontWeight = (String)cellStyleElements.get("fontWeight");
            String fontSize = (String)cellStyleElements.get("fontSize");
            String fontStyle = (String)cellStyleElements.get("fontStyle");
            if (color != null || fontFamily != null || fontWeight != null || fontSize != null || fontStyle != null) {
                String key = color + fontFamily + fontWeight + fontSize + fontStyle;
                if (this.fontCache.get(key) != null) {
                    font = (Font)this.fontCache.get(key);
                } else {
                    font = this.workbook.createFont();
                    if (color != null) {
                        font.setColor(this.getClosestColor(color));
                    }
                    if (fontFamily != null) {
                        font.setFontName(this.mapFontFamily(fontFamily));
                    }
                    if (fontWeight != null) {
                        font.setBoldweight(this.mapFontWeight(fontWeight));
                    }
                    if (fontSize != null) {
                        font.setFontHeightInPoints(this.mapFontSize(fontSize));
                    }
                    if (fontStyle != null) {
                        font.setItalic(this.isFontItalic(fontStyle));
                    }
                    this.fontCache.put(key, font);
                }
            }
        }
        return font;
    }

    protected String mapFontFamily(String cssFontName) {
        return cssFontName;
    }

    protected short mapFontWeight(String fontWeight) {
        if ("bold".equals(fontWeight) || "bolder".equals(fontWeight) || "500".compareTo(fontWeight) <= 0 && "900".compareTo(fontWeight) >= 0) {
            return 700;
        }
        return 400;
    }

    protected short mapFontSize(String fontSize) {
        return Short.parseShort(fontSize);
    }

    protected boolean isFontItalic(String fontStyle) {
        return "italic".equals(fontStyle) || "oblique".equals(fontStyle);
    }

    private String excelFormatFromSmartClientDateFormatter(String scFormatter) {
        String excelFormat = "toUSShortDate".equals(scFormatter) ? "MM/DD/YYYY" : ("toUSShortDateTime".equals(scFormatter) ? "MM/DD/YYYY HH:MM" : ("toEuropeanShortDate".equals(scFormatter) ? "DD/MM/YYYY" : ("toEuropeanShortDateTime".equals(scFormatter) ? "DD/MM/YYYY HH:MM" : ("toJapanShortDate".equals(scFormatter) ? "YYYY/MM/DD" : ("toJapanShortDateTime".equals(scFormatter) ? "YYYY/MM/DD HH:MM" : ("toSerializeableDate".equals(scFormatter) ? "YYYY-MM-DD HH:MM:SS" : ("toDateStamp".equals(scFormatter) ? "YYYYMMDDTHHMMSS" : "DDD MMM DD YYYY HH:MM:SS")))))));
        return excelFormat;
    }

    private String excelFormatFromFormattedString(String formattedString) {
        return "\"" + formattedString + "\";\"" + formattedString + "\"";
    }

    private RichTextString buildRichTextString(List styles, String stringValue) throws Exception {
        RichTextString styledString = this.workbook.getCreationHelper().createRichTextString(stringValue);
        String firstValue = (String)((Map)styles.get(0)).get("value");
        int offset = firstValue.length();
        for (int i = 1; i < styles.size(); ++i) {
            Map style = (Map)styles.get(i);
            String styledValue = (String)style.get("value");
            Font font = this.getFont(style = (Map)style.get("style"));
            if (font != null) {
                styledString.applyFont(offset, offset + styledValue.length(), font);
            }
            offset += styledValue.length();
        }
        return styledString;
    }

    private class HeaderSpan {
        public int row;
        public int endRow = -1;
        public int startCol;
        public int endCol;
        public String title;

        private HeaderSpan() {
        }
    }
}

