/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RestRequestParser;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RESTHandler
extends BaseServlet {
    Logger log = new Logger(((Object)((Object)this)).getClass().getCanonicalName());
    public static final String WRAP_JSON_RESPONSES = "wrapJSONResponses";
    public static final String JSON_PREFIX_PARAM_NAME = "jsonPrefix";
    public static final String JSON_SUFFIX_PARAM_NAME = "jsonSuffix";
    private Boolean wrapJSONResponses;
    private String jsonPrefix;
    private String jsonSuffix;
    public static final String DEFAULT_DATA_FORMAT = "defaultDataFormat";
    private String defaultDataFormat;
    public static final String DYNAMIC_DATA_FORMAT_PARAM_NAME = "dynamicDataFormatParamName";
    private String dynamicDataFormatParamName;

    public void init() throws ServletException {
        super.init();
        this.wrapJSONResponses = Boolean.TRUE;
        String parameterWrapJSON = this.getInitParameter(WRAP_JSON_RESPONSES);
        if (parameterWrapJSON != null) {
            this.wrapJSONResponses = new Boolean(parameterWrapJSON);
        } else {
            parameterWrapJSON = this.getServletContext().getInitParameter(WRAP_JSON_RESPONSES);
            if (parameterWrapJSON != null) {
                this.wrapJSONResponses = new Boolean(parameterWrapJSON);
            }
        }
        this.log.debug("Wrapping json responses:" + this.wrapJSONResponses.toString());
        String parameterJSONPrefix = this.getInitParameter(JSON_PREFIX_PARAM_NAME);
        if (parameterJSONPrefix != null) {
            this.jsonPrefix = parameterJSONPrefix;
        } else {
            parameterJSONPrefix = this.getServletContext().getInitParameter(JSON_PREFIX_PARAM_NAME);
            if (parameterJSONPrefix != null) {
                this.jsonPrefix = parameterJSONPrefix;
            }
        }
        this.log.debug("json prefix:" + this.jsonPrefix);
        String parameterJSONSuffix = this.getInitParameter(JSON_SUFFIX_PARAM_NAME);
        if (parameterJSONSuffix != null) {
            this.jsonSuffix = parameterJSONSuffix;
        } else {
            parameterJSONSuffix = this.getServletContext().getInitParameter(JSON_SUFFIX_PARAM_NAME);
            if (parameterJSONSuffix != null) {
                this.jsonSuffix = parameterJSONSuffix;
            }
        }
        this.log.debug("json suffix:" + this.jsonSuffix);
        String parameterDefaultDataFormat = this.getInitParameter(DEFAULT_DATA_FORMAT);
        if (parameterDefaultDataFormat == null) {
            parameterDefaultDataFormat = this.getServletContext().getInitParameter(DEFAULT_DATA_FORMAT);
        }
        if (parameterDefaultDataFormat != null) {
            if ("xml".equalsIgnoreCase(parameterDefaultDataFormat) || "json".equalsIgnoreCase(parameterDefaultDataFormat)) {
                this.defaultDataFormat = parameterDefaultDataFormat.toLowerCase();
            } else {
                this.defaultDataFormat = "xml";
                this.log.warn("Specified incorrect 'defaultDataFormat':" + parameterDefaultDataFormat + ". Using default - xml");
            }
        } else {
            this.defaultDataFormat = "xml";
        }
        this.log.debug("Default response data format:" + this.defaultDataFormat);
        String dynamicDataFormatParamName = this.getInitParameter(DYNAMIC_DATA_FORMAT_PARAM_NAME);
        if (dynamicDataFormatParamName == null) {
            parameterDefaultDataFormat = this.getServletContext().getInitParameter(DYNAMIC_DATA_FORMAT_PARAM_NAME);
        }
        this.dynamicDataFormatParamName = dynamicDataFormatParamName != null ? dynamicDataFormatParamName : "isc_dataFormat";
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/json;charset=" + encoding);
        }
        RequestTimer requestTimer = new RequestTimer(request);
        RPCManager rpc = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            try {
                RestRequestParser parser = new RestRequestParser(this.defaultDataFormat, this.dynamicDataFormatParamName);
                parser.setWrapJSONResponses(this.wrapJSONResponses);
                parser.setJSONPrefix(this.jsonPrefix);
                parser.setJSONSuffix(this.jsonSuffix);
                rpc = new RPCManager((Servlet)this, request, response, parser);
            }
            catch (ClientMustResubmitException cmre) {
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            this.log.info("Performing " + rpc.requestCount() + " operation(s)");
            for (Object r : rpc.getRequests()) {
                if (!(r instanceof DSRequest)) continue;
                DSRequest dsRequest = (DSRequest)r;
                try {
                    rpc.send(dsRequest, this.handleDSRequest(dsRequest, rpc, context));
                }
                catch (Exception e) {
                    Logger.observeThread();
                    try {
                        this.log.error((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rpc.sendFailure((Object)dsRequest, e);
                }
            }
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    public DSResponse handleDSRequest(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return dsRequest.execute();
        }
        catch (Exception e) {
            RequestContext.staticLog.warn((Object)"dsRequest.execute() failed: ", e);
            DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
            if (e instanceof UpdateWithoutPKException) {
                dsResponse.setStatus(-9);
            } else {
                dsResponse.setStatus(DSResponse.STATUS_FAILURE);
            }
            dsResponse.setData(e.getMessage());
            return dsResponse;
        }
    }
}

