/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocaleMessage {
    private String key;
    private String bundleName;
    protected static Logger log = new Logger(LocaleMessage.class);

    public LocaleMessage(String key, String bundleName) {
        this.key = key;
        this.bundleName = bundleName;
    }

    public void setBundle(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getMessage(Locale locale) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName, locale);
            return bundle.getString(this.key);
        }
        catch (MissingResourceException mre) {
            String[] packages = new String[]{};
            String packagesString = Config.getGlobal().getString("i18n.resourceBundle.packages");
            if (packagesString != null) {
                packages = packagesString.split(",");
            }
            for (int i = 0; i < packages.length; ++i) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(packages[i].trim() + "." + this.bundleName, locale);
                    return bundle.getString(this.key);
                }
                catch (MissingResourceException missingResourceException) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            log.warn(e);
        }
        return "<fmt:message key=\"" + this.key + "\">";
    }

    public String toString() {
        String message = this.getMessage(Locale.getDefault());
        return "i18n message: key=" + this.key + ", message=" + message;
    }
}

