/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LifeCycle;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.Pool;

public class ThreadPool
implements LifeCycle,
Serializable {
    static Log log = LogFactory.getLog(ThreadPool.class);
    private static int __pool = 0;
    public static final String __DAEMON = "org.openqa.jetty.util.ThreadPool.daemon";
    public static final String __PRIORITY = "org.openqa.jetty.util.ThreadPool.priority";
    private Pool _pool;
    private Object _join = "";
    private transient boolean _started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool() {
        String name = this.getClass().getName();
        int ld = name.lastIndexOf(46);
        if (ld >= 0) {
            name = name.substring(ld + 1);
        }
        Class<ThreadPool> clazz = ThreadPool.class;
        synchronized (ThreadPool.class) {
            name = String.valueOf(name) + __pool++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this._pool = new Pool();
            this._pool.setPoolClass(PoolThread.class);
            this.setName(name);
            return;
        }
    }

    public String getName() {
        return this._pool.getPoolName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Class<Pool> clazz = Pool.class;
        synchronized (Pool.class) {
            if (this.isStarted()) {
                if (name == null && this._pool.getPoolName() != null || name != null && !name.equals(this._pool.getPoolName())) {
                    throw new IllegalStateException("started");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (name == null) {
                if (this._pool.getPoolName() != null) {
                    this._pool = new Pool();
                    this._pool.setPoolName(this.getName());
                }
            } else if (!name.equals(this.getName())) {
                Pool pool = Pool.getPool(name);
                if (pool == null) {
                    this._pool.setPoolName(name);
                } else {
                    this._pool = pool;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getPoolName() {
        return this.getName();
    }

    public void setPoolName(String name) {
        this.setName(name);
    }

    public boolean isDaemon() {
        return this._pool.getAttribute(__DAEMON) != null;
    }

    public void setDaemon(boolean daemon) {
        this._pool.setAttribute(__DAEMON, daemon ? "true" : null);
    }

    @Override
    public boolean isStarted() {
        return this._started;
    }

    public int getThreads() {
        return this._pool.size();
    }

    public int getIdleThreads() {
        return this._pool.available();
    }

    public int getMinThreads() {
        return this._pool.getMinSize();
    }

    public void setMinThreads(int minThreads) {
        this._pool.setMinSize(minThreads);
    }

    public int getMaxThreads() {
        return this._pool.getMaxSize();
    }

    public void setMaxThreads(int maxThreads) {
        this._pool.setMaxSize(maxThreads);
    }

    public int getMaxIdleTimeMs() {
        return this._pool.getMaxIdleTimeMs();
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._pool.setMaxIdleTimeMs(maxIdleTimeMs);
    }

    public int getThreadsPriority() {
        int priority = 5;
        Object o = this._pool.getAttribute(__PRIORITY);
        if (o != null) {
            priority = (Integer)o;
        }
        return priority;
    }

    public void setThreadsPriority(int priority) {
        this._pool.setAttribute(__PRIORITY, new Integer(priority));
    }

    public void setMaxStopTimeMs(int ms) {
        log.warn((Object)"setMaxStopTimeMs is deprecated. No longer required.");
    }

    @Override
    public void start() throws Exception {
        this._started = true;
        this._pool.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws InterruptedException {
        this._started = false;
        this._pool.stop();
        Object object = this._join;
        synchronized (object) {
            this._join.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        while (this.isStarted() && this._pool != null) {
            Object object = this._join;
            synchronized (object) {
                try {
                    if (this.isStarted() && this._pool != null) {
                        this._join.wait(30000L);
                    }
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
        }
    }

    public void shrink() throws InterruptedException {
        this._pool.shrink();
    }

    public void run(Object job) throws InterruptedException {
        if (job == null) {
            return;
        }
        try {
            PoolThread thread = (PoolThread)this._pool.get(this.getMaxIdleTimeMs());
            if (thread != null) {
                thread.run(this, job);
            } else {
                log.warn((Object)("No thread for " + job));
                this.stopJob(null, job);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    protected void handle(Object job) throws InterruptedException {
        if (job != null && job instanceof Runnable) {
            ((Runnable)job).run();
        } else {
            log.warn((Object)("Invalid job: " + job));
        }
    }

    protected void stopJob(Thread thread, Object job) {
    }

    public static class PoolThread
    extends Thread
    implements Pool.PondLife {
        Pool _pool;
        ThreadPool _jobPool;
        Object _job;
        ThreadPool _runPool;
        Object _run;
        int _id;
        String _name;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterPool(Pool pool, int id) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = pool;
                this._id = id;
                this._name = String.valueOf(this._pool.getPoolName()) + "-" + id;
                this.setName(this._name);
                this.setDaemon(pool.getAttribute(ThreadPool.__DAEMON) != null);
                Object o = pool.getAttribute(ThreadPool.__PRIORITY);
                if (o != null) {
                    this.setPriority((Integer)o);
                }
                this.start();
            }
        }

        @Override
        public int getID() {
            return this._id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void poolClosing() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._run == null) {
                    this.notify();
                } else {
                    this.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void leavePool() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._jobPool == null && this._runPool == null) {
                    this.notify();
                }
                if (this._job != null && this._jobPool != null) {
                    this._jobPool.stopJob(this, this._job);
                    this._job = null;
                    this._jobPool = null;
                }
                if (this._run != null && this._runPool != null) {
                    this._runPool.stopJob(this, this._run);
                    this._run = null;
                    this._runPool = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ThreadPool pool, Object job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._jobPool = pool;
                this._job = job;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object run = null;
            ThreadPool runPool = null;
            while (this._pool != null && this._pool.isStarted()) {
                boolean got;
                PoolThread poolThread;
                try {
                    try {
                        PoolThread poolThread2 = this;
                        synchronized (poolThread2) {
                            if (run == null && this._pool != null && this._pool.isStarted() && this._job == null) {
                                this.wait(this._pool.getMaxIdleTimeMs());
                            }
                            if (this._job != null) {
                                run = this._run = this._job;
                                this._job = null;
                                runPool = this._runPool = this._jobPool;
                                this._jobPool = null;
                            }
                        }
                        if (run != null && runPool != null) {
                            runPool.handle(run);
                        } else if (run == null && this._pool != null) {
                            this._pool.shrink();
                        }
                    }
                    catch (InterruptedException e) {
                        LogSupport.ignore(log, e);
                        poolThread = this;
                        synchronized (poolThread) {
                            got = run != null;
                            this._run = null;
                            run = null;
                            this._runPool = null;
                            runPool = null;
                            try {
                                if (got && this._pool != null) {
                                    this._pool.put(this);
                                }
                            }
                            catch (InterruptedException e2) {
                                LogSupport.ignore(log, e2);
                            }
                            continue;
                        }
                    }
                }
                catch (Throwable throwable) {
                    poolThread = this;
                    synchronized (poolThread) {
                        got = run != null;
                        this._run = null;
                        run = null;
                        this._runPool = null;
                        runPool = null;
                        try {
                            if (got && this._pool != null) {
                                this._pool.put(this);
                            }
                        }
                        catch (InterruptedException e) {
                            LogSupport.ignore(log, e);
                        }
                    }
                    throw throwable;
                }
                poolThread = this;
                synchronized (poolThread) {
                    got = run != null;
                    this._run = null;
                    run = null;
                    this._runPool = null;
                    runPool = null;
                    try {
                        if (got && this._pool != null) {
                            this._pool.put(this);
                        }
                    }
                    catch (InterruptedException e) {
                        LogSupport.ignore(log, e);
                    }
                }
            }
        }

        @Override
        public String toString() {
            return this._name;
        }
    }
}

