/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SmartClientWebDriver;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class ScActions {
    private Actions actions;

    public ScActions(SmartClientWebDriver driver) {
        this.actions = new Actions((WebDriver)driver);
    }

    private void moveIfNecessaryTo(WebElement element) {
        if (element != null) {
            this.actions.moveToElement(element);
        }
    }

    public ScActions sendKeys(WebElement element, CharSequence ... keysToSend) {
        this.moveIfNecessaryTo(element);
        this.actions.sendKeys(keysToSend);
        return this;
    }

    public ScActions keyDown(WebElement element, Keys keys) {
        this.moveIfNecessaryTo(element);
        this.actions.keyDown(keys);
        return this;
    }

    public ScActions keyUp(WebElement element, Keys keys) {
        this.moveIfNecessaryTo(element);
        this.actions.keyUp(keys);
        return this;
    }

    public ScActions click(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.click();
        return this;
    }

    public ScActions doubleClick(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.doubleClick();
        return this;
    }

    public ScActions clickAndHold(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.clickAndHold();
        return this;
    }

    public ScActions release(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.release();
        return this;
    }

    public ScActions mouseMove(WebElement element) {
        this.moveIfNecessaryTo(element);
        return this;
    }

    public ScActions dragAndDrop(WebElement source, WebElement target) {
        this.moveIfNecessaryTo(source);
        Dimension size = target.getSize();
        this.actions.clickAndHold(source);
        this.actions.moveToElement(target, size.width - 1, size.height - 1);
        this.actions.release();
        return this;
    }

    public ScActions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        this.moveIfNecessaryTo(source);
        this.actions.dragAndDropBy(source, xOffset, yOffset);
        return this;
    }

    public ScActions dragEdgeAndDropBy(WebElement webElement, int deltaX, int deltaY, int xOffset, int yOffset) {
        System.err.println("dragEdgeAndDropBy: " + deltaX + "," + deltaY);
        this.moveIfNecessaryTo(webElement);
        this.actions.moveToElement(webElement, deltaX, deltaY);
        this.actions.clickAndHold();
        this.actions.moveByOffset(xOffset, yOffset);
        this.actions.release();
        return this;
    }

    public void perform() {
        this.actions.perform();
    }

    public ScActions moveToElement(WebElement element) {
        this.moveIfNecessaryTo(element);
        return this;
    }
}

