/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.google.common.base.Function;
import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.ScActions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SmartClientWebDriver
implements WebDriver,
HasInputDevices {
    private static final int WAIT_TIMEOUT_MILLIS = 30000;
    private static final int WAIT_QUANTUM_MILLIS = 100;
    private String baseUrl = "";
    private JavascriptExecutor js;
    private RemoteWebDriver driver;
    private ScActions actions;
    private int[] keysDown = new int[256];

    SmartClientWebDriver(RemoteWebDriver driver) {
        this.driver = driver;
        this.driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
        this.js = driver;
        Capabilities localCapabilities = driver.getCapabilities();
        ((DesiredCapabilities)localCapabilities).setJavascriptEnabled(true);
        this.actions = new ScActions(this);
    }

    private String appendScSeleniumQueryToURL(String url) {
        String baseUrl = url;
        String fragment = "";
        int index = url.indexOf(35);
        if (index >= 0) {
            fragment = url.substring(index);
            baseUrl = url.substring(0, index);
        }
        baseUrl = (index = baseUrl.indexOf(63)) >= 0 ? baseUrl + "&sc_selenium=true" : baseUrl + "?sc_selenium=true";
        return baseUrl + fragment;
    }

    public boolean waitForElementClickable(By by) {
        return this.waitForJavascriptFunction(by, "isElementClickable");
    }

    public boolean waitForFrameToLoad(String frameLocator, int secondsMax) {
        WebDriverWait wait = new WebDriverWait((WebDriver)this.driver, (long)secondsMax);
        try {
            wait.until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)frameLocator));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public boolean waitForElementNotPresent(By by) {
        return new Waiter(){

            @Override
            boolean success(List<WebElement> results, String string) {
                return results.size() == 0;
            }
        }.waitFor(null, by);
    }

    public boolean waitForText(By by, String string) {
        return this.waitForText(string, by);
    }

    public boolean waitForText(String string, By by) {
        return new Waiter(){

            @Override
            boolean success(List<WebElement> results, String string) {
                return results.size() > 0 && string.equals(results.get(0).getText());
            }
        }.waitFor(string, by);
    }

    public boolean waitForGridDone(By by) {
        return this.waitForJavascriptFunction(by, "isGridDone");
    }

    public boolean waitForCondition(String javascript, Long timeout) {
        return this.waitForJavascriptFunction(null, javascript.replace("selenium.browserbot.getCurrentWindow().", ""));
    }

    private boolean waitForJavascriptFunction(By by, String function) {
        return new Waiter(){

            @Override
            boolean success(List<WebElement> results, String string) {
                return results.size() > 0 && SmartClientWebDriver.this.performJavascriptFunction(results.get(0), string);
            }
        }.waitFor(function, by);
    }

    private boolean performJavascriptFunction(WebElement element, String function) {
        try {
            Boolean done = (Boolean)this.js.executeScript("return isc.AutoTest." + function + "(arguments[0])", new Object[]{element});
            if (Boolean.TRUE.equals(done)) {
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Exception in WebDriver." + function + ":" + e);
            e.printStackTrace(System.err);
        }
        return false;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private void reset() {
        for (int i = 0; i < this.keysDown.length; ++i) {
            this.keysDown[i] = 0;
        }
    }

    public void get(String relativeUrl) {
        this.driver.get(this.baseUrl + this.appendScSeleniumQueryToURL(relativeUrl));
        if (this.driver.getCapabilities().getCapability("nativeEvents") == null) {
            System.err.println("*** Warning: Native events are not enabled. You may need to update your WebDriver version ***");
        }
        this.driver.manage().window().maximize();
        this.reset();
    }

    public void showConsole() {
        this.js.executeScript("isc.showConsole()", new Object[0]);
    }

    public void setClientLogLevel(String category, int level) {
        this.js.executeScript("isc.Log.setPriority(category, isc.Log[" + level + "])", new Object[0]);
    }

    public void setClientLogLevel(String category, String level) {
        this.js.executeScript("isc.Log.setPriority(category, isc.Log['" + level + "'])", new Object[0]);
    }

    public void setServerLogLevel(String category, String level) {
        this.js.executeScript("var requestElement = document.createElement('IscSeleniumConfigureServerLogsElement');requestElement.setAttribute('arguments', ['" + category + "','" + level + "']);" + "document.documentElement.appendChild(requestElement);" + "var autWindowEvent = document.createEvent('Events');" + "autWindowEvent.initEvent('IscSeleniumConfigureServerLogsEvent', true, false);" + "requestElement.dispatchEvent(autWindowEvent);", new Object[0]);
    }

    public SmartClientWebDriver sendKeys(By by, CharSequence ... keysToSend) {
        this.actions.sendKeys(this.findElement(by), keysToSend).perform();
        return this;
    }

    public SmartClientWebDriver type(By by) {
        return this.type(by, "");
    }

    public SmartClientWebDriver type(By by, String keysToSend) {
        WebElement e = this.findElement(by);
        this.actions.moveToElement(e).perform();
        this.findElement(by).click();
        this.findElement(by).clear();
        this.findElement(by).sendKeys(new CharSequence[]{keysToSend});
        return this;
    }

    public SmartClientWebDriver type(By by, Long keysToSend) {
        this.type(by, keysToSend.toString());
        return this;
    }

    public SmartClientWebDriver keyPress(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        if (this.keysDown[charToSend.intValue()] <= 0) {
            this.actions.sendKeys(null, new CharSequence[]{key}).perform();
        }
        return this;
    }

    public SmartClientWebDriver keyPress(By by, String keysToSend) {
        this.actions.sendKeys(null, keysToSend).perform();
        return this;
    }

    public SmartClientWebDriver keyDown(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        if (key.equals((Object)Keys.ENTER)) {
            this.actions.sendKeys(this.findElement(by), new CharSequence[]{key}).perform();
            return this;
        }
        try {
            if (this.keysDown[charToSend.intValue()] == 0) {
                this.keyDown(null, key);
            }
            int n = charToSend.intValue();
            this.keysDown[n] = this.keysDown[n] + 1;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: keyDown ignored for: " + charToSend + " @ " + by);
            e.printStackTrace(System.err);
        }
        return this;
    }

    private Keys getWebDriverKey(int seleniumCode) {
        switch (seleniumCode) {
            case 8: {
                return Keys.BACK_SPACE;
            }
            case 9: {
                return Keys.TAB;
            }
            case 13: {
                return Keys.ENTER;
            }
            case 16: {
                return Keys.SHIFT;
            }
            case 17: {
                return Keys.CONTROL;
            }
            case 32: {
                return Keys.SPACE;
            }
            case 35: {
                return Keys.END;
            }
            case 36: {
                return Keys.HOME;
            }
            case 37: {
                return Keys.ARROW_LEFT;
            }
            case 38: {
                return Keys.ARROW_UP;
            }
            case 39: {
                return Keys.ARROW_RIGHT;
            }
            case 40: {
                return Keys.ARROW_DOWN;
            }
            case 46: {
                return Keys.DELETE;
            }
        }
        System.err.println("Unmapped selenium keyCode: " + seleniumCode);
        return null;
    }

    public SmartClientWebDriver keyUp(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        try {
            int n = charToSend.intValue();
            this.keysDown[n] = this.keysDown[n] - 1;
            if (this.keysDown[charToSend.intValue()] == 0) {
                this.keyUp(null, key);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: keyUp ignored for: " + charToSend + " @ " + by);
        }
        return this;
    }

    public SmartClientWebDriver keyDown(By by, Keys theKey) {
        this.actions.keyDown(this.findElement(by), theKey).perform();
        return this;
    }

    public SmartClientWebDriver keyUp(By by, Keys theKey) {
        this.actions.keyUp(this.findElement(by), theKey).perform();
        return this;
    }

    SmartClientWebDriver shiftKeyDown(By by) {
        return this.keyDown(null, 16L);
    }

    SmartClientWebDriver shiftKeyUp(By by) {
        return this.keyUp(null, 16L);
    }

    public SmartClientWebDriver shiftKeyDown() {
        return this.shiftKeyDown(null);
    }

    public SmartClientWebDriver shiftKeyUp() {
        return this.shiftKeyUp(null);
    }

    public SmartClientWebDriver controlKeyDown() {
        return this.keyDown(null, 17L);
    }

    public SmartClientWebDriver controlKeyUp() {
        return this.keyUp(null, 17L);
    }

    public SmartClientWebDriver click(By by) {
        this.js.executeScript("if (isc.EH._isSecondClick == null){ isc.EH._isSecondClick = false;}", new Object[0]);
        this.findElement(by).click();
        this.js.executeScript("isc.EH._isSecondClick = null;", new Object[0]);
        return this;
    }

    public SmartClientWebDriver secondClick(By by) {
        this.js.executeScript("isc.EH._isSecondClick = true;", new Object[0]);
        this.actions.click(this.findElement(by)).perform();
        this.js.executeScript("isc.EH._isSecondClick = null;", new Object[0]);
        return this;
    }

    public SmartClientWebDriver doubleClick(By by) {
        return this.click(by).secondClick(by);
    }

    public SmartClientWebDriver clickAndHold(By by) {
        this.actions.clickAndHold(this.findElement(by)).perform();
        return this;
    }

    public SmartClientWebDriver release(By by) {
        this.actions.release(this.findElement(by)).perform();
        return this;
    }

    public SmartClientWebDriver mouseMove(By by) {
        this.actions.moveToElement(this.driver.findElement(by)).perform();
        return this;
    }

    SmartClientWebDriver dragAndDropToObject(By sourceBy, By targetBy) {
        return this.dragAndDrop(sourceBy, targetBy);
    }

    public SmartClientWebDriver dragAndDrop(By sourceBy, By targetBy) {
        this.actions.dragAndDrop(this.findElement(sourceBy), this.findElement(targetBy)).perform();
        return this;
    }

    public SmartClientWebDriver dragAndDrop(By sourceBy, String offset) {
        String[] xy = offset.split(",");
        return this.dragAndDropBy(sourceBy, Integer.parseInt(xy[0].replace("+", "")), Integer.parseInt(xy[1].replace("+", "")));
    }

    public SmartClientWebDriver dragAndDropBy(By sourceBy, int xOffset, int yOffset) {
        if (sourceBy instanceof ByScLocator) {
            ByScLocator locator = (ByScLocator)sourceBy;
            if (locator.isEdgeLocator()) {
                long width = (Long)this.js.executeScript("return isc.AutoTest.locateCanvasFromDOMElement(isc.AutoTest.getElement(arguments[0])).getVisibleWidth()", new Object[]{locator.getBaseLocator()});
                long height = (Long)this.js.executeScript("return isc.AutoTest.locateCanvasFromDOMElement(isc.AutoTest.getElement(arguments[0])).getVisibleHeight()", new Object[]{locator.getBaseLocator()});
                long margin = (Long)this.js.executeScript("return isc.AutoTest.locateCanvasFromDOMElement(isc.AutoTest.getElement(arguments[0])).edgeMarginSize", new Object[]{locator.getBaseLocator()});
                System.err.println("dims: " + width + "," + height + "," + margin);
                this.actions.dragEdgeAndDropBy(this.findElement(sourceBy), locator.getEdgeOffsetX(width, margin), locator.getEdgeOffsetY(height, margin), xOffset, yOffset).perform();
            } else {
                this.actions.dragAndDropBy(this.findElement(sourceBy), xOffset, yOffset).perform();
            }
        } else {
            this.actions.dragAndDropBy(this.findElement(sourceBy), xOffset, yOffset).perform();
        }
        return this;
    }

    public boolean verifyValue(By scLocator, Boolean b) {
        Boolean done = (Boolean)this.js.executeScript("return isc.AutoTest.getValue(arguments[0])", new Object[]{((ByScLocator)scLocator).getLocatorString()});
        return b.equals(done);
    }

    public boolean verifyValue(By scLocator, Long val) {
        Long found = (Long)this.js.executeScript("return isc.AutoTest.getValue(arguments[0])", new Object[]{((ByScLocator)scLocator).getLocatorString()});
        if (val == null) {
            boolean match;
            boolean bl = match = found == null;
            if (!match) {
                System.err.println("Expected: NULL, found: '" + found + "'");
            }
            return match;
        }
        boolean match = val.equals(found);
        if (!match) {
            System.err.println("Expected: '" + val + "', found: '" + found + "'");
        }
        return match;
    }

    public boolean assertEval(String javaScript, Boolean value) {
        return value.equals(this.js.executeScript(javaScript.replace("selenium.browserbot.getCurrentWindow().", ""), new Object[]{value}));
    }

    public boolean verifyValue(By scLocator, String string) {
        return this.verifyText(scLocator, string);
    }

    public boolean verifyText(By scLocator) {
        return this.verifyText(scLocator, "");
    }

    public boolean verifyText(By scLocator, Long val) {
        return this.verifyText(scLocator, val.toString());
    }

    public boolean verifyText(By scLocator, String string) {
        String text = (String)this.js.executeScript("return isc.AutoTest.getValue(arguments[0])", new Object[]{((ByScLocator)scLocator).getLocatorString()});
        if (string == null) {
            boolean match;
            boolean bl = match = text == null;
            if (!match) {
                System.err.println("Expected: NULL, found: '" + text + "'");
            }
            return match;
        }
        String pattern = string.replace("*", ".*").replace("$", "\\$").replace(" ", "\\s*");
        boolean match = text != null ? Pattern.matches(pattern.trim(), text.trim()) : false;
        if (!match) {
            System.err.println("Expected: '" + pattern + "', found: '" + text + "'");
        }
        return match;
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        if (by == null) {
            return null;
        }
        return this.driver.findElement(by);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Keyboard getKeyboard() {
        return this.driver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.driver.getMouse();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Waiter {
        private Waiter() {
        }

        List<WebElement> operation(By by) {
            if (by == null) {
                return Collections.emptyList();
            }
            return SmartClientWebDriver.this.findElements(by);
        }

        abstract boolean success(List<WebElement> var1, String var2);

        public boolean waitFor(String string, By by) {
            int maximumTicks = 300;
            try {
                for (int tick = 0; tick <= maximumTicks; ++tick) {
                    List<WebElement> elements = this.operation(by);
                    if (this.success(elements, string)) {
                        return true;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                System.err.println("WebDriver.waiter interrupted:" + e);
            }
            return false;
        }
    }
}

