/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.LocaleMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FirebirdDriver
extends SQLDriver {
    private static Logger log = new Logger(FirebirdDriver.class.getName());

    public FirebirdDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public FirebirdDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new FirebirdDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new FirebirdDriver(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public boolean supportsSQLLimit() {
        return true;
    }

    public boolean limitRequiresSQLOrderClause() {
        return false;
    }

    public String limitQuery(String query, long startRow, long batchSize, List outputColumns) {
        String token = "SELECT ";
        int insertPoint = query.indexOf(token);
        if (insertPoint == -1) {
            return query;
        }
        return query.substring(0, insertPoint += token.length()) + "FIRST " + batchSize + " SKIP " + startRow + " " + query.substring(insertPoint);
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("No existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue(sequenceName, ds);
            if (sequence == null) continue;
            Object obj = FirebirdDriver.getScalarResult("SELECT " + sequence + " FROM RDB$DATABASE", this.dbConnection, this.dbName, this, req);
            BigDecimal value = new BigDecimal(obj.toString());
            primaryKeys.put(sequenceName, value.toString());
        }
        return primaryKeys;
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        return "GEN_ID(" + sequenceName + ", 0)";
    }

    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        return "NEXT VALUE FOR " + sequenceName;
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\'g", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String escapeClause() {
        return " {ESCAPE '\\'}";
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        if (config.getBoolean((Object)("sql." + this.dbName + ".useCaseForSortBy"), false)) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue;
            if (valueMap.get(actualValue) instanceof LocaleMessage) {
                Locale locale = request != null ? request.context.getLocale() : Locale.getDefault();
                displayValue = ((LocaleMessage)valueMap.get(actualValue)).getMessage(locale);
            } else {
                displayValue = valueMap.get(actualValue) == null ? null : valueMap.get(actualValue).toString();
            }
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    public int caseInsensitiveStrategy() {
        return 2;
    }

    public InputStream handleInputStream(InputStream in) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtil.copyStreams((InputStream)in, (OutputStream)os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public String getDriverNameForURL(Config driverConfig) {
        return "firebirdsql";
    }

    public String getNaturalTableName(String tableName) {
        return tableName.toUpperCase();
    }
}

