/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ForeignKeyNotFoundException;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.datasource.StreamingResponseIterator;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCManagerCompletionCallback;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.sql.CacheDriver;
import com.isomorphic.sql.EscapedValuesMap;
import com.isomorphic.sql.HSQLDBDriver;
import com.isomorphic.sql.OracleDriver;
import com.isomorphic.sql.PostgresDriver;
import com.isomorphic.sql.SQLAnsiJoinClause;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDSGenerator;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLJoinWhereClause;
import com.isomorphic.sql.SQLOrderClause;
import com.isomorphic.sql.SQLSelectClause;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.sql.SQLTableClause;
import com.isomorphic.sql.SQLTableCreator;
import com.isomorphic.sql.SQLTransaction;
import com.isomorphic.sql.SQLTransform;
import com.isomorphic.sql.SQLValuesClause;
import com.isomorphic.sql.SQLWhereClause;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDataSource
extends BasicDataSource
implements ISQLDataSource,
RPCManagerCompletionCallback {
    private static Logger log = new Logger(SQLDataSource.class.getName());
    private static List doNotSandboxTables = config.getList((Object)"doNotSandboxTables", new ArrayList());
    private static boolean wwwProduction = config.getBoolean((Object)"wwwProduction", false);
    private static long count = 0L;
    private static Map<String, Long> countsById = new HashMap<String, Long>();
    private static Map<String, List<Long>> instancesById = new HashMap<String, List<Long>>();
    private static List<Map> createTrace;
    private static final String TIMING_LOG_PAGED_FETCH = "Paged fetch";
    private static final String TIMING_LOG_GET_CONNECTION = "get connection";
    private static final String TIMING_LOG_QUERY = "query";
    private static final String TIMING_LOG_SQLTRANSFORM = "SQLTransform";
    private static final String TIMING_LOG_JDBCSCROLL_FETCH = "JDBC scroll fetch";
    private static final String TIMING_LOG_JDBCSCROLL_FETCH_SCROLL = "scroll";
    private static final String TIMING_LOG_COUNT_QUERY = "Rowcount query";
    protected SQLTable table;
    protected SQLDriver driver;
    protected Object lastRow = null;
    protected Map lastPrimaryKeys = null;
    protected Map lastPrimaryKeysData = null;
    private DSRequest downloadDsRequest;
    private static final int MAX_TABLENAME_LENGTH = 64;
    private static final List supportedAggregationFunctions;

    public static long getCreationCount() {
        return count;
    }

    public static long getCreationCount(String dsId) {
        return countsById.get(dsId) == null ? 0L : countsById.get(dsId);
    }

    public static List<Long> getInstanceIds(String dsId) {
        return instancesById.get(dsId) == null ? new ArrayList() : instancesById.get(dsId);
    }

    public static Map<String, List<Long>> getInstanceIdsForPrefix(String prefix) {
        HashMap<String, List<Long>> rtn = new HashMap<String, List<Long>>();
        for (String key : instancesById.keySet()) {
            if (!key.startsWith(prefix)) continue;
            rtn.put(key, instancesById.get(key));
        }
        return rtn;
    }

    public static void clearInstanceIds(String dsId) {
        instancesById.remove(dsId);
    }

    public static void clearCreateTrace() {
        if (config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
            createTrace = new ArrayList<Map>();
        }
    }

    public static void dumpCreateTrace(String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        if (!config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
            return;
        }
        SQLDataSource.dumpCreateTrace(createTrace, (String)dsName, (String)filename, (boolean)dumpStack, (boolean)dumpConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        Object ID;
        Object obj;
        if (wwwProduction) {
            String tableName = (String)theConfig.get("tableName");
            if (tableName == null) {
                tableName = (String)theConfig.get("ID");
            }
            if (!doNotSandboxTables.contains(tableName)) {
                theConfig = DataTools.mapMerge((Map)theConfig, (Map)new LinkedMap());
                theConfig.put("dbName", "webdemos");
            }
        }
        Map fields = (obj = theConfig.get("fields")) instanceof List ? DataTools.makeIndex((Collection)((List)obj), (String)"name") : (Map)obj;
        Object autoDerive = theConfig.get("autoDeriveSchema");
        if (autoDerive != null && autoDerive.toString().equals("true") || theConfig.get("schemaBean") != null) {
            ID = (String)theConfig.get("ID") + "_inheritsFrom";
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile((String)ID);
            if (dsObject instanceof DataSource) {
                this.autoDeriveDS = (DataSource)dsObject;
            } else {
                this.createAutoDeriveDS(theConfig);
                if (this.autoDeriveDS == null) {
                    String tableName = (String)theConfig.get("tableName");
                    if (tableName == null) {
                        tableName = (String)theConfig.get("ID");
                    }
                    String serverType = (String)theConfig.get("serverType");
                    String dsName = (String)theConfig.get("ID");
                    String dbName = (String)theConfig.get("dbName");
                    String schema = (String)theConfig.get("schema");
                    Map autoDeriveSchemaOperation = null;
                    List operationBindings = DataSource.getOperationBindings((Map)theConfig);
                    if (operationBindings != null) {
                        for (Map operationBinding : operationBindings) {
                            String isAutoDeriveSchemaOperation = (String)operationBinding.get("autoDeriveSchemaOperation");
                            if (!"true".equals(isAutoDeriveSchemaOperation)) continue;
                            autoDeriveSchemaOperation = operationBinding;
                        }
                    }
                    log.info((Object)("Deriving dataSource " + dsName + (tableName != null ? " from table: " + tableName : "") + (autoDeriveSchemaOperation != null ? " using operation: " + DataTools.prettyPrint((Object)autoDeriveSchemaOperation) : "")));
                    this.autoDeriveDS = SQLDataSource.fromTable(null, tableName, schema, (String)ID, serverType, dbName, autoDeriveSchemaOperation, true, fields, (Boolean)theConfig.get("autoDeriveFKs"));
                }
                if (this.autoDeriveDS != null) {
                    theConfig.put("autoDeriveSchema", true);
                }
            }
        }
        super.init(theConfig, dsRequest);
        ID = SQLDataSource.class;
        synchronized (SQLDataSource.class) {
            ++count;
            String id = (String)theConfig.get("ID");
            Long c = countsById.get(id);
            countsById.put(id, c == null ? 1L : c + 1L);
            if (config.getBoolean((Object)"datasources.sql.maintain.instanceId.map", false)) {
                List<Long> ids = instancesById.get(id);
                if (ids == null) {
                    ids = new ArrayList<Long>();
                    instancesById.put(id, ids);
                }
                ids.add(this.instanceId);
            }
            // ** MonitorExit[ID] (shouldn't be in output)
            if (config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
                LinkedMap map = new LinkedMap();
                map.put("time", System.currentTimeMillis());
                map.put("ID", theConfig.get("ID"));
                map.put("instanceId", this.instanceId);
                map.put("config", theConfig);
                map.put("stack", new Exception().getStackTrace());
                List<Map> list = createTrace;
                synchronized (list) {
                    createTrace.add((Map)map);
                }
            }
            this.table = this.buildSQLTable();
            String dbName = (String)this.dsConfig.get("dbName");
            if (dbName == null) {
                dbName = config.getString((Object)"sql.defaultDatabase");
            }
            if (dbName == null) {
                throw new Exception("datasource '" + this.dsName + "' does not define a target" + " database and sql.defaultDatabase is not specified" + " in the master config.  Unable to determine target database");
            }
            this.driver = SQLDriver.instance(dbName, this.table);
            return;
        }
    }

    private SQLTable buildSQLTable() throws Exception {
        HashMap<String, String> sequences = new HashMap<String, String>();
        HashMap<String, String> fieldTypes = new HashMap<String, String>();
        Map fieldMap = this.native2DSFieldMap;
        if (this.getSuper() != null) {
            fieldMap.putAll(this.getSuper().native2DSFieldMap());
        }
        Iterator i = fieldMap.keySet().iterator();
        while (i.hasNext()) {
            String column = (String)fieldMap.get(i.next());
            if (column == null || !column.contains(".")) continue;
            i.remove();
        }
        for (String columnName : fieldMap.keySet()) {
            Object fieldNameObj = fieldMap.get(columnName);
            String fieldName = null;
            fieldName = fieldNameObj instanceof List ? (String)((List)fieldNameObj).get(0) : (String)fieldNameObj;
            DSField field = this.getField(fieldName);
            String fieldType = field.getType();
            fieldTypes.put(columnName, fieldType);
            if (!"sequence".equals(fieldType) && (!"integer".equals(fieldType) || !field.isAutoGenerated())) continue;
            String sequenceName = (String)field.get((Object)"sequenceName");
            if (sequenceName == null) {
                sequenceName = "__default";
            }
            sequences.put(columnName, sequenceName);
        }
        String tableName = (String)this.dsConfig.get("tableName");
        if (tableName == null) {
            tableName = this.getName();
        }
        String dsQuotedColumnNames = (String)this.dsConfig.get("quoteColumnNames");
        String oracleQuotedColumnNames = (String)this.dsConfig.get("OracleQuotedColumnNames");
        String genericQuotedColumnNames = (String)this.dsConfig.get("quotedColumnNames");
        if (genericQuotedColumnNames == null) {
            genericQuotedColumnNames = oracleQuotedColumnNames;
        }
        return new SQLTable(tableName, this.primaryKeys, fieldTypes, fieldMap, sequences, dsQuotedColumnNames == null ? genericQuotedColumnNames : dsQuotedColumnNames);
    }

    public String getColumnName(String fieldName) {
        return (String)this.getCorrectDs2NativeFieldMap().get(fieldName);
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    protected DSResponse processRequest(DSRequest req) throws Exception {
        String operationType = req.getOperationType();
        if (SQLDataSource.isFetch((String)operationType) || SQLDataSource.isAdd((String)operationType) || SQLDataSource.isRemove((String)operationType) || SQLDataSource.isUpdate((String)operationType) || SQLDataSource.isCustom((String)operationType) || operationType.equals("replace")) {
            Object dsProperty;
            DSResponse validationFailure = this.validateDSRequest(req);
            if (validationFailure != null) {
                return validationFailure;
            }
            req.setRequestStarted(true);
            Map opConfig = req.operationConfig();
            SQLDataSource dsObject = null;
            if (opConfig != null && (dsProperty = opConfig.get("dataSource")) != null && dsProperty instanceof List && ((List)dsProperty).size() > 1) {
                dsObject = dsProperty;
            }
            return SQLDataSource.SQLExecute(req, (Object)(dsObject != null ? dsObject : this));
        }
        throw new Exception("Unrecognized operationType '" + operationType + "'.  If you " + "intended to create a new custom operationType with this " + "name, override SQLDataSource.execute() and handle it there");
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        String fieldName = req.getDownloadFieldName();
        Map criteria = req.getCriteria();
        this.downloadDsRequest = new DSRequest(this.getName(), "fetch");
        this.downloadDsRequest.setRPCManager(req.getRPCManager());
        this.downloadDsRequest.setCriteria((Object)criteria);
        this.downloadDsRequest.setFreeOnExecute(req.getFreeOnExecute());
        DSResponse resp = this.downloadDsRequest.execute();
        req.setFreeOnExecute(this.downloadDsRequest.getFreeOnExecute());
        if (resp.getData() instanceof List) {
            try {
                resp.setData(this.forceSingleObject(resp.getDataList()));
            }
            catch (Exception e) {
                String msg = "Found more than one record when looking up a binary value on DataSource '" + this.getID() + "' with criteria " + req.getCriteria() + ". Does the DataSource have a primaryKey declared?";
                log.error((Object)msg);
                throw new Exception(msg);
            }
        }
        return resp;
    }

    public SQLDriver getDriver() {
        return this.driver;
    }

    public Connection getTransactionalConnection(DSRequest req) throws Exception {
        Connection conn = null;
        if (this.shouldAutoJoinTransaction(req)) {
            conn = (Connection)this.getTransactionObject(req);
            if (conn == null && this.shouldAutoStartTransaction(req, false)) {
                SQLTransaction.startTransaction(req.rpc, this.driver.getDBName());
                conn = (Connection)this.getTransactionObject(req);
                if (req != null && req.rpc != null) {
                    req.rpc.registerCallback((RPCManagerCompletionCallback)this);
                }
            }
            if (conn != null && req != null) {
                req.setPartOfTransaction(true);
            }
        }
        return conn;
    }

    public Connection getConnection() throws Exception {
        return SQLConnectionManager.getConnection(this.driver.getDBName());
    }

    public void freeConnection(Connection conn) throws Exception {
        SQLConnectionManager.free(conn);
    }

    public SQLTable getTable() {
        return this.table;
    }

    public List executeNativeQuery(String nativeCommand) throws Exception {
        return this.executeNativeQuery(nativeCommand, null, null);
    }

    public List executeNativeQuery(String nativeCommand, DSRequest req) throws Exception {
        return this.executeNativeQuery(nativeCommand, null, req);
    }

    public List executeNativeQuery(String nativeCommand, List dataSources, DSRequest req) throws Exception {
        return this.executeNativeQuery(nativeCommand, dataSources, null, req, null);
    }

    public List executeNativeQuery(String nativeCommand, DataSource ds, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        if (ds == null) {
            return this.executeNativeQuery(nativeCommand, (List)null, opConfig, req, resp);
        }
        return this.executeNativeQuery(nativeCommand, DataTools.makeList((Object)ds), opConfig, req, resp);
    }

    public List executeNativeQuery(String nativeCommand, List dataSources, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        return this.driver.executeQuery(nativeCommand, dataSources, opConfig, req, resp);
    }

    public int executeNativeUpdate(String nativeCommand) throws Exception {
        return this.executeNativeUpdate(nativeCommand, null);
    }

    public int executeNativeUpdate(String nativeCommand, List data, DSRequest req) throws Exception {
        return this.driver.executeUpdate(nativeCommand, data, req);
    }

    public int executeNativeUpdate(String nativeCommand, DSRequest req) throws Exception {
        return this.driver.executeUpdate(nativeCommand, req);
    }

    public Map getSequences() {
        Map localSequences = this.getTable().getSequences();
        if (localSequences != null && localSequences.keySet().size() > 0) {
            return localSequences;
        }
        Map seq = new HashMap();
        if (this.getSuper() != null) {
            seq = ((SQLDataSource)this.getSuper()).getSequences();
        }
        return seq;
    }

    public void clearCache() {
        this.lastRow = null;
        this.lastPrimaryKeys = null;
        this.lastPrimaryKeysData = null;
    }

    public void finalize() throws Throwable {
        if (this.driver != null) {
            this.driver.clearState();
        }
    }

    public void clearState() {
        this.clearCache();
        if (this.driver != null) {
            this.driver.clearState();
        }
        super.clearState();
    }

    public Object getLastRow() throws Exception {
        return this.getLastRow(null, true);
    }

    public Object getLastRow(DSRequest req, boolean qualifyColumnNames) throws Exception {
        Map syncOpBinding;
        if (this.lastRow != null) {
            return this.lastRow;
        }
        Map primaryKeys = this.getLastPrimaryKeys(req);
        log.info((Object)("primaryKeys: " + primaryKeys));
        String schema = (String)this.getConfig().get("schema");
        String schemaClause = "";
        if (schema != null) {
            schemaClause = schema + this.getDriver().getQualifiedSchemaSeparator();
        }
        String cacheSyncOperation = null;
        Map updateOperationBinding = this.getOperationBinding(req.getOperationType(), req.getOperationId());
        if (updateOperationBinding != null) {
            cacheSyncOperation = (String)updateOperationBinding.get("cacheSyncOperation");
        }
        if ((syncOpBinding = this.getOperationBinding("fetch", cacheSyncOperation)) != null) {
            Object cacheSyncObj;
            boolean useIt = true;
            if (cacheSyncOperation == null && (cacheSyncObj = syncOpBinding.get("useForCacheSync")) != null) {
                useIt = Boolean.parseBoolean(cacheSyncObj.toString());
            }
            if (useIt) {
                if (cacheSyncOperation != null) {
                    log.info((Object)(this.driver.getDBName() + " getLastRow(): using specific cacheSyncOperation " + cacheSyncOperation));
                } else {
                    log.info((Object)(this.driver.getDBName() + " getLastRow(): using default operationBinding"));
                }
            }
        }
        DSRequest csReq = new DSRequest(this.getName(), "fetch");
        csReq.setDataSource(req.getDataSource());
        csReq.setOperationId(cacheSyncOperation);
        csReq.setCriteria((Object)this.getLastPrimaryKeys(req));
        csReq.context = req.context;
        csReq.setRPCManager(req.getRPCManager());
        csReq.setClientRequest(true);
        csReq.setParameter((Object)"additionalOutputs", req.getParameter((Object)"additionalOutputs"));
        csReq.setTextMatchStyle(req.getTextMatchStyle());
        Iterator i = req.getAttributeNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            csReq.setAttribute(key, req.getAttribute(key));
        }
        csReq.setPrimaryDSRequest(req);
        req.addSubRequest(csReq);
        DSResponse csResp = csReq.execute();
        if (csReq.getDroppedFields() != null) {
            Iterator i2 = csReq.getDroppedFields().iterator();
            while (i2.hasNext()) {
                req.removeField((String)i2.next(), true);
            }
        }
        this.lastRow = csResp.getData();
        return this.lastRow;
    }

    public void setLastPrimaryKeys(Map primaryKeys) {
        this.lastPrimaryKeys = primaryKeys;
    }

    public Map getLastPrimaryKeys(DSRequest req) throws Exception {
        if (this.lastPrimaryKeys != null) {
            return this.lastPrimaryKeys;
        }
        if (this.lastPrimaryKeysData == null) {
            throw new Exception("getLastPrimaryKeys() called before valid insert/replace/update operation has been performed");
        }
        Map submittedPrimaryKeys = DataTools.subsetMap((Map)this.lastPrimaryKeysData, (List)this.getPrimaryKeys());
        for (String keyName : submittedPrimaryKeys.keySet()) {
            if (submittedPrimaryKeys.get(keyName) != null) continue;
            submittedPrimaryKeys.remove(keyName);
        }
        List sequencesNotPresent = DataTools.setDisjunction((Collection)this.getPrimaryKeys(), (Collection)DataTools.keysAsList((Map)submittedPrimaryKeys));
        if (sequencesNotPresent.isEmpty()) {
            this.lastPrimaryKeys = submittedPrimaryKeys;
            return this.lastPrimaryKeys;
        }
        this.lastPrimaryKeys = this.driver.fetchLastPrimaryKeys(submittedPrimaryKeys, sequencesNotPresent, this, req);
        return this.lastPrimaryKeys;
    }

    public void setLastPrimaryKeysData(Map keys) {
        this.lastPrimaryKeysData = DataTools.subsetMap((Map)keys, (List)this.getPrimaryKeys());
    }

    public String escapeColumnName(Object columnName) {
        return this.driver.escapeColumnName(columnName);
    }

    public String escapeValue(Object value) {
        return this.driver.escapeValue(value);
    }

    public String escapeValueForFilter(Object value) {
        return this.driver.escapeValueForFilter(value, null);
    }

    public String escapeValueForWhereClause(Object value, Object field) {
        return this.valueForWhereClause(value, field, false);
    }

    public String valueForWhereClause(Object value, Object field) {
        return this.valueForWhereClause(value, field, false);
    }

    public String valueForWhereClause(Object value, Object field, boolean filter) {
        String columnType = null;
        DSField dsField = this.getField(field.toString());
        if (dsField != null) {
            columnType = dsField.getType();
        }
        try {
            if (columnType != null) {
                columnType = this.getSimpleBaseType(columnType);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Exception trying to get simpleBaseType for field " + field.toString()), (Throwable)e);
        }
        if (columnType == null) {
            columnType = value instanceof Date ? "date" : (value instanceof Number ? (value instanceof Float || value instanceof Double ? "float" : "integer") : "text");
        }
        if ("text".equals(columnType) || "string".equals(columnType)) {
            if (!filter) {
                return this.driver.sqlInTransform(value, dsField, this);
            }
            return this.driver.sqlFilterTransform(value, dsField, this, null);
        }
        if (SQLDataSource.typeIsNumeric(columnType)) {
            if (value instanceof String) {
                try {
                    value = SQLDataSource.typeIsDecimal(columnType) ? new BigDecimal((String)value).toString() : new BigInteger((String)value).toString();
                }
                catch (Exception e) {
                    log.warn((Object)("Got non-numeric value '" + value + "' for numeric column '" + field.toString() + "', creating literal false expression"));
                    return "'0'='1'";
                }
            }
            return value.toString();
        }
        return this.driver.sqlInTransform(value, dsField, this);
    }

    public static boolean typeIsDate(String type) {
        return "date".equals(type) || "time".equals(type) || "datetime".equals(type);
    }

    public static boolean typeIsBoolean(String type) {
        return "boolean".equals(type);
    }

    public static boolean typeIsDecimal(String type) {
        return "float".equals(type) || "decimal".equals(type) || "double".equals(type);
    }

    public static boolean typeIsNumeric(String type) {
        return "number".equals(type) || "float".equals(type) || "decimal".equals(type) || "double".equals(type) || "int".equals(type) || "intEnum".equals(type) || "integer".equals(type) || "sequence".equals(type);
    }

    public String getNextSequenceValue(String columnName) throws Exception {
        return this.driver.getNextSequenceValue(columnName, this);
    }

    public String sqlValueForFieldValue(String columnName, Object columnValue) {
        DSField field = this.getField(columnName);
        String columnType = field.getType();
        if (columnValue == null) {
            return "NULL";
        }
        if (field.isMultiple() && columnValue instanceof Collection) {
            String sqlValue = "";
            Collection coll = (Collection)columnValue;
            for (Object entry : coll) {
                if (sqlValue.length() != 0) {
                    sqlValue = sqlValue + ",";
                }
                sqlValue = sqlValue + entry;
            }
            columnValue = sqlValue;
        }
        if (SQLDataSource.typeIsNumeric(columnType)) {
            if ("".equals(columnValue)) {
                return "NULL";
            }
            return columnValue.toString();
        }
        return this.driver.sqlInTransform(columnValue, field, this);
    }

    private static String getClause(DSRequest request, String clauseName, String defaultValue) throws Exception {
        String clause = (String)request.getOperationProperty(clauseName);
        if (clause != null) {
            return clause;
        }
        Map operationBinding = request.getDataSource().getOperationBinding(request.getOperationType(), request.getOperationId());
        if (operationBinding == null) {
            return defaultValue;
        }
        Object clauseValue = operationBinding.get(clauseName);
        String string = clause = clauseValue != null ? clauseValue.toString() : null;
        if (clause != null) {
            return clause;
        }
        return defaultValue;
    }

    public static String generateSQLStatement(DSRequest request, Map parameters) throws Exception {
        String statement;
        String opType = request.getOperationType();
        String command = (String)request.getOperationProperty("command");
        DataSource ds = request.getDataSource();
        if (command != null) {
            return Velocity.evaluateAsString((String)command, (Map)parameters, (String)opType, (DataSource)ds, (boolean)true);
        }
        String customSQL = SQLDataSource.getClause(request, "customSQL", null);
        if (customSQL != null) {
            String trimmed = new String(customSQL.trim());
            if (trimmed.endsWith(";")) {
                trimmed = trimmed.substring(0, trimmed.length() - 1);
            }
            return Velocity.evaluateAsString((String)trimmed, (Map)parameters, (String)opType, (DataSource)ds, (boolean)true);
        }
        String selectClause = SQLDataSource.getClause(request, "selectClause", "$defaultSelectClause");
        String tableClause = SQLDataSource.getClause(request, "tableClause", "$defaultTableClause");
        String ansiJoinClause = SQLDataSource.getClause(request, "ansiJoinClause", "$defaultAnsiJoinClause");
        String whereClause = SQLDataSource.getClause(request, "whereClause", "$defaultWhereClause");
        String joinWhereClause = SQLDataSource.getClause(request, "joinWhereClause", "$defaultJoinWhereClause");
        String valuesClause = SQLDataSource.getClause(request, "valuesClause", "$defaultValuesClause");
        String groupClause = SQLDataSource.getClause(request, "groupClause", "$defaultGroupClause");
        String groupWhereClause = SQLDataSource.getClause(request, "groupWhereClause", "$defaultGroupWhereClause");
        String orderClause = SQLDataSource.getClause(request, "orderClause", "$defaultOrderClause");
        if (SQLDataSource.isFetch((String)opType)) {
            String defaultGroupClause;
            statement = "SELECT " + selectClause + " FROM " + tableClause;
            boolean emittedJoinClause = false;
            if (!"$defaultAnsiJoinClause".equals(ansiJoinClause) || parameters.get("defaultAnsiJoinClause") != null) {
                statement = statement + ansiJoinClause;
                emittedJoinClause = true;
            }
            boolean emittedWhere = false;
            if (!"$defaultWhereClause".equals(whereClause) || parameters.get("defaultWhereClause") != null) {
                statement = statement + " WHERE " + whereClause;
                emittedWhere = true;
            }
            if (!(emittedJoinClause || "$defaultJoinWhereClause".equals(joinWhereClause) && (parameters.get("defaultJoinWhereClause") == null || "".equals(parameters.get("defaultJoinWhereClause"))))) {
                statement = !emittedWhere ? statement + " WHERE " + joinWhereClause : statement + " AND " + joinWhereClause;
            }
            if ((defaultGroupClause = (String)parameters.get("defaultGroupClause")) != null && !"".equals(defaultGroupClause)) {
                groupClause = defaultGroupClause;
            }
            if (!"$defaultGroupClause".equals(groupClause)) {
                statement = statement + " GROUP BY " + groupClause;
            }
            if (!"$defaultGroupWhereClause".equals(groupWhereClause)) {
                statement = "SELECT * FROM (" + statement + ") work WHERE " + groupWhereClause;
            }
            Object defaultOrderClause = parameters.get("defaultOrderClause");
            if (!"$defaultOrderClause".equals(orderClause) || defaultOrderClause != null && !defaultOrderClause.equals("")) {
                statement = statement + " ORDER BY " + orderClause;
            }
            log.info((Object)("derived query: " + statement));
        } else if (SQLDataSource.isAdd((String)opType)) {
            statement = "INSERT INTO " + tableClause + " " + valuesClause;
        } else if (SQLDataSource.isUpdate((String)opType)) {
            statement = "UPDATE " + tableClause + " SET " + valuesClause + " WHERE " + whereClause;
        } else if (SQLDataSource.isRemove((String)opType)) {
            statement = "DELETE FROM " + tableClause + " WHERE " + whereClause;
        } else if ("replace".equals(opType)) {
            statement = "REPLACE INTO " + tableClause + " " + valuesClause;
        } else if ("custom".equals(opType)) {
            statement = "";
        } else {
            throw new Exception("Operation type " + opType + " not supported by generateSQLStatement");
        }
        return Velocity.evaluateAsString((String)statement, (Map)parameters, (String)opType, (DataSource)ds, (boolean)true);
    }

    public static void sandbox(DSRequest req) throws Exception {
        SQLDataSource sqlds;
        HttpSession session = null;
        if (!config.getBoolean((Object)"wwwProduction", false)) {
            return;
        }
        if (req == null || req.context == null || req.context.request == null || req.context.request.getSession() == null) {
            return;
        }
        session = req.context.request.getSession();
        DataSource ds = req.getDataSource();
        if (ds instanceof SQLDataSource && !(sqlds = (SQLDataSource)ds).isModificationOperation(req.getOperationType(), req.getOperationId())) {
            return;
        }
        if (session.getAttribute("isc_sandbox") != null) {
            return;
        }
        HashMap<String, String> sandbox = new HashMap<String, String>();
        session.setAttribute("isc_sandbox", sandbox);
        List doNotSandbox = config.getList((Object)"doNotSandboxTables", new ArrayList());
        SQLDriver driver = SQLDriver.instance("webdemos");
        String tableSchema = config.getString((Object)("sql." + driver.getDBName() + ".driver.databaseName"), "isomorphic");
        List qryResults = driver.executeQuery("SHOW TABLES", null);
        List<String> tables = new ArrayList();
        for (Map row : qryResults) {
            String tableInSchema = (String)row.get("Tables_in_" + tableSchema);
            if (tableInSchema == null) {
                tableInSchema = (String)row.get("TABLE_NAME");
            }
            if (tableInSchema != null) {
                if (tableInSchema.indexOf("_sbx_") != -1) continue;
                tables.add(tableInSchema);
                continue;
            }
            log.warn((Object)("Error - did not find the expected attribute in this row from the resultset returned by SHOW TABLES: " + row));
        }
        tables = DataTools.setDisjunction(tables, (Collection)doNotSandbox);
        for (String tableName : tables) {
            String sandboxTable = tableName + "_sbx_" + session.getId();
            int trimChars = sandboxTable.length() - 64;
            if (trimChars > 0) {
                if (trimChars > tableName.length()) {
                    log.warn((Object)"Sandboxed table name was too long, and this cannot be resolved by trimming the base name because the amount of excess length is greater than the length of the base name");
                    return;
                }
                String trimmedName = tableName.substring(0, tableName.length() - trimChars);
                sandboxTable = trimmedName + "_sbx_" + session.getId();
                int rchar = 0;
                String replacementChar = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                while (sandbox.containsValue(sandboxTable) && rchar < replacementChar.length()) {
                    sandboxTable = trimmedName.substring(0, trimmedName.length() - 2) + "_" + replacementChar.substring(rchar++, rchar) + "_sbx_" + session.getId();
                }
                if (sandbox.get(sandboxTable) != null) {
                    log.warn((Object)"Sandboxed table name was too long, and attempting to resolve this by trimming the base name failed because every attempted variation on the base name was already in use");
                    return;
                }
            }
            driver.execute("CREATE TABLE `" + sandboxTable + "` LIKE `" + tableName + "`");
            driver.execute("INSERT INTO `" + sandboxTable + "` SELECT * FROM `" + tableName + "`");
            log.warn((Object)("Created sandbox copy of " + tableName + " as: " + sandboxTable));
            sandbox.put(tableName, sandboxTable);
        }
    }

    public static String applySandboxNames(String statement, DSRequest req) throws Exception {
        HttpSession session = null;
        if (req != null && req.context != null && req.context.request != null) {
            session = req.context.request.getSession();
        }
        if (session == null) {
            return statement;
        }
        Map sandbox = (Map)session.getAttribute("isc_sandbox");
        if (sandbox == null) {
            return statement;
        }
        String delimiters = " \t\n\r\f.,()";
        StringTokenizer st = new StringTokenizer(statement, delimiters, true);
        StringBuffer sandboxedStatement = new StringBuffer("");
        String[] tokens = new String[st.countTokens()];
        int c = 0;
        while (st.hasMoreTokens()) {
            tokens[c++] = st.nextToken();
        }
        boolean hitSelect = false;
        boolean hitFrom = false;
        boolean hitSet = false;
        boolean hitWhere = false;
        boolean hitOrderBy = false;
        boolean hitInsertInto = false;
        boolean hitOpeningParen = false;
        for (int j = 0; j < c; ++j) {
            String token = tokens[j];
            boolean check = true;
            if ("SELECT".equals(token)) {
                hitSelect = true;
                check = false;
            }
            if ("FROM".equals(token)) {
                hitFrom = true;
                check = false;
            }
            if ("SET".equals(token)) {
                hitSet = true;
                check = false;
            }
            if ("WHERE".equals(token)) {
                hitWhere = true;
                check = false;
            }
            if ("ORDER".equals(token) && j + 2 < c && "BY".equals(tokens[j + 2])) {
                hitOrderBy = true;
                check = false;
            }
            if ("INSERT".equals(token) && j + 2 < c && "INTO".equals(tokens[j + 2])) {
                hitInsertInto = true;
                check = false;
            }
            if ("(".equals(token)) {
                hitOpeningParen = true;
                check = false;
            }
            if (delimiters.indexOf(token) != -1) {
                check = false;
            }
            if ((hitSelect && !hitFrom || hitInsertInto && hitOpeningParen || hitSet || hitWhere || hitOrderBy) && (j + 1 >= c || !".".equals(tokens[j + 1]))) {
                check = false;
            }
            if (check) {
                for (String origTable : sandbox.keySet()) {
                    if (!origTable.equals(token)) continue;
                    token = (String)sandbox.get(origTable);
                    break;
                }
            }
            sandboxedStatement.append(token);
        }
        return sandboxedStatement.toString();
    }

    private static boolean shouldInvalidateCache(DSRequest req, SQLDriver driver) throws Exception {
        Object invalCache;
        if (req.forceInvalidateCache()) {
            return true;
        }
        Map opBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        if (opBinding != null && (invalCache = opBinding.get("invalidateCache")) != null && invalCache.toString().toLowerCase().equals("true")) {
            return true;
        }
        if (driver instanceof CacheDriver) {
            return true;
        }
        String work = SQLDataSource.getClause(req, "canSyncCache", null);
        if (work != null) {
            return work.toString().toLowerCase().equals("false");
        }
        if (SQLDataSource.getClause(req, "cacheSyncOperation", null) != null) {
            return false;
        }
        if (req.getOperationProperty("command") != null) {
            return true;
        }
        if (SQLDataSource.getClause(req, "customSQL", null) != null) {
            return true;
        }
        String opType = req.getOperationType();
        if (SQLDataSource.isAdd((String)opType) || "replace".equals(opType)) {
            return SQLDataSource.getClause(req, "valuesClause", null) != null;
        }
        if (SQLDataSource.isRemove((String)opType) || SQLDataSource.isUpdate((String)opType)) {
            return SQLDataSource.getClause(req, "whereClause", null) != null;
        }
        log.warning((Object)"shouldInvalidateCache called for a DSRequest with a non-update operation; returning false");
        return false;
    }

    private static boolean needJSONFiltering(DSRequest req) {
        List propsToKeep = req.getConsolidatedOutputs();
        List groupByColumns = req.getGroupByFields();
        if (propsToKeep != null && req.isGroupBy()) {
            groupByColumns.removeAll(propsToKeep);
            if (!groupByColumns.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static DSResponse SQLExecute(DSRequest req) throws Exception {
        return SQLDataSource.SQLExecute(req, null);
    }

    public static DSResponse SQLExecute(DSRequest req, Object dsObject) throws Exception {
        List keysMissing;
        List dataSources;
        SQLDataSource.sandbox(req);
        Map opConfig = req.operationConfig();
        String opType = req.getOperationType();
        if (log.isInfoEnabled()) {
            List values = req.getValueSets();
            JSTranslater jsTrans = JSTranslater.instance().enablePrettyPrinting(false);
            String valuesString = "";
            if (values != null) {
                valuesString = values.size() == 1 ? "\tvalues: " + jsTrans.toJS(values.get(0)) : "\tvalues: " + values.size() + " valueSets";
            }
            log.info((Object)("Performing " + opType + " operation with\n" + (req.constraints() != null ? "\tconstraints: " + req.constraints() : "") + (req.outputs() != null ? "\toutputs: " + req.outputs() : "") + (req.getRawCriteria() != null ? "\tcriteria: " + jsTrans.toJS(req.getRawCriteria()) : "") + valuesString));
        }
        if (dsObject == null) {
            if (opConfig == null) {
                throw new Exception("no datasources specified in argument and no operation config to look them up; can't proceed");
            }
            dsObject = opConfig.get("dataSource");
        }
        if (dsObject instanceof String || dsObject instanceof SQLDataSource) {
            dataSources = SQLDataSource.getDataSources(DataTools.makeList((Object)dsObject), req);
        } else if (dsObject instanceof List) {
            dataSources = SQLDataSource.getDataSources((List)dsObject, req);
        } else {
            throw new Exception("in the app operation config, datasource must be set to a string or list");
        }
        SQLDataSource firstDS = (SQLDataSource)((Object)dataSources.get(0));
        List valueSets = req.getValueSets();
        if (SQLDataSource.isAdd((String)opType) && valueSets.size() > 1) {
            return SQLDataSource.executeMultipleInsert(req, valueSets, dataSources);
        }
        if (opType.equals("replace") && !firstDS.getDriver().supportsNativeReplace()) {
            req.setOperationType("remove");
            SQLDataSource.SQLExecute(req, dataSources);
            req.setOperationType("add");
            return SQLDataSource.SQLExecute(req, dataSources);
        }
        Map operationBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        List customFields = SQLDataSource.getCustomFields(operationBinding);
        List customCriteriaFields = SQLDataSource.getCustomCriteriaFields(operationBinding);
        List customValueFields = SQLDataSource.getCustomValueFields(operationBinding);
        List excludeValueFields = SQLDataSource.getExcludeValueFields(operationBinding);
        if (customCriteriaFields == null) {
            customCriteriaFields = customFields;
        }
        if (customValueFields == null) {
            customValueFields = customFields;
        }
        boolean qualifyColumnNames = SQLDataSource.shouldQualifyColumnNames(operationBinding, (DataSource)firstDS);
        if ("add".equals(opType) && (keysMissing = req.getMissingPrimaryKeysForAdd()).size() > 0) {
            throw new UpdateWithoutPKException("Criteria received from the client for add operation is missing the following non-sequence primary key fields: " + keysMissing.toString() + ". Either provide all primary " + "key fields that are not sequences, or set " + "allowMultiUpdate on the OperationBinding");
        }
        Map context = SQLDataSource.getClausesContext(req, dataSources, qualifyColumnNames, customCriteriaFields, customValueFields, excludeValueFields, operationBinding);
        if (!(!SQLDataSource.isAdd((String)opType) && !SQLDataSource.isUpdate((String)opType) && !opType.equals("replace") || req.getOperationProperty("command") != null || operationBinding != null && operationBinding.containsKey("customSQL") || operationBinding != null && operationBinding.containsKey("valuesClause") || req.getOperationProperty("valuesClause") != null || context.get("defaultValuesClause") != null)) {
            log.warn((Object)"Insert, update or replace operation is not a full query; check DataSource configuration (operationBinding, valuesClause);check submitted parameters (valuesClause, command) for operation.");
            throw new Exception("Insert, update or replace operation is not a full query; check DataSource configuration (operationBinding, valuesClause);check submitted parameters (valuesClause, command) for operation.");
        }
        if (opConfig != null || operationBinding != null) {
            context.putAll(SQLDataSource.getVariablesContext(req, dataSources));
        }
        String statement = SQLDataSource.generateSQLStatement(req, context);
        statement = SQLDataSource.applySandboxNames(statement, req);
        DSResponse result = new DSResponse((DataSource)firstDS);
        if (SQLDataSource.isCustom((String)opType) && "".equals(statement)) {
            result.setStatus(0);
        } else if (SQLDataSource.isFetch((String)opType) || SQLDataSource.isCustom((String)opType) && operationBinding != null && !"update".equals(operationBinding.get("sqlType"))) {
            String paging = null;
            if (req.isPaged()) {
                if (operationBinding != null) {
                    paging = (String)operationBinding.get("sqlPaging");
                }
                if (paging == null && (req.getOperationProperty("command") != null || operationBinding != null && operationBinding.containsKey("customSQL"))) {
                    boolean progLoading = DataTools.asBoolean(firstDS.getConfig().get("progressiveLoading"), (boolean)false);
                    if (opConfig != null && opConfig.containsKey("progressiveLoading")) {
                        progLoading = DataTools.asBoolean(opConfig.get("progressiveLoading"), (boolean)false);
                    }
                    if (req.getParameter((Object)"progressiveLoading") != null) {
                        progLoading = DataTools.asBoolean((Object)req.getParameter((Object)"progressiveLoading"), (boolean)false);
                    }
                    if ((paging = progLoading ? config.getString((Object)"sql.defaultCustomSQLProgressivePaging") : config.getString((Object)"sql.defaultCustomSQLPaging")) == null) {
                        paging = config.getBoolean((Object)"sql.customSQLReturnsAllRows", true) ? "none" : "jdbcScroll";
                    }
                } else if (paging == null) {
                    if (paging == null) {
                        paging = firstDS.getProperty("sqlPaging");
                    }
                    if (paging == null && (paging = config.getString((Object)"sql.defaultPaging")) == null) {
                        Object useSQLLimit = firstDS.getConfig().get("useSQLLimit");
                        paging = useSQLLimit == null || useSQLLimit.toString().equals("true") ? "sqlLimit" : "none";
                    }
                }
            }
            if (req.isPaged() && !"none".equals(paging)) {
                long start = System.currentTimeMillis();
                result = SQLDataSource.executeWindowedSelect(req, dataSources, context, statement, paging);
                long end = System.currentTimeMillis();
                Logger.timing.debug((Object)("Query time: " + (end - start) + "ms"));
            } else {
                log.info((Object)(firstDS.getInstanceId() + ": " + "Executing SQL query on '" + firstDS.getDriver().dbName + "'"), (Object)statement);
                List results = firstDS.executeNativeQuery(statement, (DataSource)firstDS, operationBinding, req, result);
                if (!req.shouldStreamResults()) {
                    if (SQLDataSource.needJSONFiltering(req)) {
                        result.setData((Object)new JSONFilter((Object)results, (Collection)req.getConsolidatedOutputs()));
                    } else {
                        result.setData((Object)results);
                    }
                    result.setTotalRows((long)results.size());
                    result.setStartRow(0L);
                    result.setEndRow((long)results.size());
                }
            }
        } else {
            firstDS.clearCache();
            ArrayList streams = new ArrayList();
            List binaryStreams = config.getBoolean((Object)"oldBinaryStreamHandling", false) ? req.getUploadedFileStreams() : req.getBinaryStreams();
            int binaryStreamsIndex = 0;
            List sortedFields = DataTools.getSortedList((List)firstDS.getFieldNames());
            for (String fieldName : sortedFields) {
                DSField dsField = firstDS.getField(fieldName);
                if (firstDS.getDriver().fieldAssignableInline(dsField)) continue;
                if (dsField.isBinary()) {
                    boolean skipCustomSQLCheck = false;
                    if (customValueFields != null) {
                        Iterator iter = customValueFields.iterator();
                        while (iter.hasNext()) {
                            if (!iter.next().equals(dsField.getName())) continue;
                            skipCustomSQLCheck = true;
                            break;
                        }
                    }
                    if (!skipCustomSQLCheck && dsField.getBoolean("customSQL")) continue;
                    if (binaryStreams != null && binaryStreams.size() > binaryStreamsIndex) {
                        streams.add(binaryStreams.get(binaryStreamsIndex++));
                        continue;
                    }
                    if (!req.getValues().containsKey(fieldName)) continue;
                    streams.add(null);
                    continue;
                }
                String s = (String)req.getValues().get(fieldName);
                if (s != null) {
                    streams.add(new StringBuffer(s));
                    continue;
                }
                if (!req.getValues().containsKey(fieldName)) continue;
                streams.add(null);
            }
            int rowsAffected = firstDS.executeNativeUpdate(statement, streams, req);
            result.setAffectedRows((long)rowsAffected);
            if (!SQLDataSource.isCustom((String)opType)) {
                if (rowsAffected > 0) {
                    log.debug((Object)(opType + " operation affected " + rowsAffected + " rows"));
                    if (SQLDataSource.shouldInvalidateCache(req, firstDS.getDriver())) {
                        result.setInvalidateCache(true);
                    } else {
                        HashMap storeValues = req.getCriteria();
                        if (SQLDataSource.isAdd((String)opType)) {
                            storeValues = new HashMap(req.getCriteria());
                            Iterator i = storeValues.keySet().iterator();
                            while (i.hasNext()) {
                                String fieldName = (String)i.next();
                                DSField field = firstDS.getField(fieldName);
                                if (field == null || !"sequence".equals(field.getType())) continue;
                                i.remove();
                            }
                        }
                        firstDS.setLastPrimaryKeysData(storeValues);
                        if (req.getAllowMultiUpdate()) {
                            result.setInvalidateCache(true);
                        } else {
                            Object data = SQLDataSource.isRemove((String)opType) ? firstDS.getLastPrimaryKeys(req) : firstDS.getLastRow(req, qualifyColumnNames);
                            result.setData(data instanceof JSONFilter ? data : DataTools.makeListIfSingle((Object)data));
                        }
                    }
                } else {
                    log.warning((Object)(opType + " operation affected no rows"));
                }
            }
        }
        return result;
    }

    protected static boolean shouldQualifyColumnNames(Map operationBinding, DataSource ds) {
        boolean qualifyColumnNames = true;
        if (operationBinding != null) {
            Object qual = operationBinding.get("qualifyColumnNames");
            if (qual != null) {
                if (qual.toString().toLowerCase().equals("false")) {
                    qualifyColumnNames = false;
                }
            } else {
                qual = ds.getConfig().get("qualifyColumnNames");
                if (qual != null && qual.toString().toLowerCase().equals("false")) {
                    qualifyColumnNames = false;
                }
            }
        } else {
            Object qual = ds.getConfig().get("qualifyColumnNames");
            if (qual != null && qual.toString().toLowerCase().equals("false")) {
                qualifyColumnNames = false;
            }
        }
        return qualifyColumnNames;
    }

    protected static List getCustomFields(Map opBinding) {
        ArrayList<String> fieldList = null;
        if (opBinding != null) {
            Object customFieldObj = opBinding.get("customFields");
            if (customFieldObj instanceof List) {
                fieldList = (ArrayList<String>)customFieldObj;
            } else if (customFieldObj != null) {
                fieldList = new ArrayList<String>();
                String[] fields = customFieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    protected static List getCustomCriteriaFields(Map opBinding) {
        ArrayList<String> fieldList = null;
        if (opBinding != null) {
            Object customCriteriaFieldObj = opBinding.get("customCriteriaFields");
            if (customCriteriaFieldObj instanceof List) {
                fieldList = (ArrayList<String>)customCriteriaFieldObj;
            } else if (customCriteriaFieldObj != null) {
                fieldList = new ArrayList<String>();
                String[] fields = customCriteriaFieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    protected static List getCustomValueFields(Map opBinding) {
        ArrayList<String> fieldList = null;
        if (opBinding != null) {
            Object customValueFieldObj = opBinding.get("customValueFields");
            if (customValueFieldObj instanceof List) {
                fieldList = (ArrayList<String>)customValueFieldObj;
            } else if (customValueFieldObj != null) {
                fieldList = new ArrayList<String>();
                String[] fields = customValueFieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    protected static List getExcludeValueFields(Map opBinding) {
        ArrayList<String> fieldList = null;
        if (opBinding != null) {
            Object excludeCriteriaFieldObj = opBinding.get("excludeCriteriaFields");
            if (excludeCriteriaFieldObj instanceof List) {
                fieldList = (ArrayList<String>)excludeCriteriaFieldObj;
            } else if (excludeCriteriaFieldObj != null) {
                fieldList = new ArrayList<String>();
                String[] fields = excludeCriteriaFieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    private static DSResponse executeMultipleInsert(DSRequest req, List valueSets, List dataSources) throws Exception {
        DSResponse result = null;
        boolean invalidateCache = false;
        ArrayList resultSets = new ArrayList();
        for (Object values : valueSets) {
            if (!(values instanceof Map)) {
                throw new Exception("values must be set to a map or list of maps; was set to list of " + values.getClass().getName());
            }
            req.setValues(values);
            result = SQLDataSource.SQLExecute(req, dataSources);
            List currentRS = result.getDataList();
            if (currentRS != null && !currentRS.isEmpty()) {
                resultSets.add(currentRS.get(0));
            }
            if (!result.getInvalidateCache()) continue;
            invalidateCache = true;
        }
        result.setAffectedRows((long)valueSets.size());
        result.setData(resultSets);
        result.setInvalidateCache(invalidateCache);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DSResponse executeWindowedSelect(DSRequest req, List dataSources, Map context, String rowFetchQuery, String paging) throws Exception {
        DSResponse result = new DSResponse((DataSource)dataSources.get(0));
        SQLDataSource firstDS = (SQLDataSource)((Object)dataSources.get(0));
        SQLDriver driver = firstDS.getDriver();
        Map opConfig = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        boolean progLoading = DataTools.asBoolean(firstDS.getConfig().get("progressiveLoading"), (boolean)false);
        if (opConfig != null && opConfig.containsKey("progressiveLoading")) {
            progLoading = DataTools.asBoolean(opConfig.get("progressiveLoading"), (boolean)false);
        }
        if (req.getParameter((Object)"progressiveLoading") != null) {
            progLoading = DataTools.asBoolean((Object)req.getParameter((Object)"progressiveLoading"), (boolean)false);
        }
        result.setProgressiveLoading(progLoading);
        boolean useRowCount = !req.isGroupBy() && !progLoading && (opConfig == null || !"true".equals(opConfig.get("skipRowCount")));
        boolean wrapSqlForRowCount = false;
        if (opConfig != null && (opConfig.containsKey("customSQL") || opConfig.containsKey("command"))) {
            useRowCount = false;
            Boolean work = null;
            if (opConfig.containsKey("useSubselectForRowCount")) {
                work = DataTools.getBooleanObject((Map)opConfig, (Object)"useSubselectForRowCount");
            }
            if (work == null && firstDS.getConfig().containsKey("useSubselectForRowCount")) {
                work = DataTools.getBooleanObject((Map)firstDS.getConfig(), (Object)"useSubselectForRowCount");
            }
            if (work == null) {
                work = config.getBoolean((Object)"useSubselectForRowCount", false);
            }
            wrapSqlForRowCount = Boolean.TRUE.equals(work);
        }
        String selectString = SQLDataSource.getClause(req, "selectClause", "$defaultSelectClause");
        String tableString = SQLDataSource.getClause(req, "tableClause", "$defaultTableClause");
        String ansiJoinString = SQLDataSource.getClause(req, "ansiJoinClause", "$defaultAnsiJoinClause");
        String whereString = SQLDataSource.getClause(req, "whereClause", "$defaultWhereClause");
        String joinWhereString = SQLDataSource.getClause(req, "joinWhereClause", "$defaultJoinWhereClause");
        String groupString = SQLDataSource.getClause(req, "groupClause", "$defaultGroupClause");
        String groupWhereString = SQLDataSource.getClause(req, "groupWhereClause", "$defaultGroupWhereClause");
        String orderClause = SQLDataSource.getClause(req, "orderClause", "$defaultOrderClause");
        long start = System.currentTimeMillis();
        if (useRowCount) {
            String rowCountQueryString = driver.getRowCountQueryString(selectString, tableString, ansiJoinString, whereString, joinWhereString, groupString, groupWhereString, context);
            progLoading = SQLDataSource.runRowCountQuery(rowCountQueryString, context, req, result, firstDS);
            if (result.getTotalRows() == 0L) {
                return result;
            }
        } else if (!progLoading && !wrapSqlForRowCount) {
            log.info((Object)"Skipping row count query - Row count will be obtained by traversing the entire dataset");
        }
        if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
            req.setBatchSize(req.getEndRow() - req.getStartRow());
        }
        if (progLoading) {
            req.setBatchSize(req.getBatchSize() + (long)firstDS.getLookAhead());
            result.setRequestEndRow(req.getStartRow() + req.getBatchSize());
        }
        if (paging.equals("sqlLimit") && !driver.supportsSQLLimit()) {
            if (opConfig != null && opConfig.get("sqlPaging") != null) {
                log.warn((Object)("DataSource '" + firstDS.getName() + "'" + (opConfig == null ? "" : ", OperationBinding '" + opConfig.get("operationId")) + ": sqlPaging was explicitly specified as 'sqlLimit', but " + "the underlying database (" + driver.getDBType() + ") does " + "not support SQL limit queries.  Falling back to 'jdbcScroll'"));
            }
            paging = "jdbcScroll";
        }
        if (wrapSqlForRowCount) {
            String rowCountQuery = "SELECT COUNT(*) FROM (" + rowFetchQuery + ")";
            if (!driver.aliasForbiddenForSubselect()) {
                rowCountQuery = rowCountQuery + " rc";
            }
            log.debug((Object)("SQL windowed select - using subselect to obtain rowCount: " + rowCountQuery));
            try {
                progLoading = SQLDataSource.runRowCountQuery(rowCountQuery, context, req, result, firstDS);
            }
            catch (Exception e) {
                log.error((Object)("We attempted to use a subselect to form a rowCount query for customSQL operation " + (opConfig.get("operationName") == null ? "{default}" : "'" + opConfig.get("operationName'")) + ", but an exception was thrown.  Please disable subselect " + "counting by setting useSubselectForRowCount: false in your " + "server.properties file or DataSource/Operation config"));
                throw e;
            }
            if (result.getTotalRows() == 0L) {
                return result;
            }
            if (progLoading) {
                req.setBatchSize(req.getBatchSize() + (long)firstDS.getLookAhead());
                result.setRequestEndRow(req.getStartRow() + req.getBatchSize());
            }
        }
        if (paging.equals("sqlLimit")) {
            List outputs;
            log.debug((Object)"Using SQL Limit query");
            Map remap = new HashMap();
            for (SQLDataSource ds : dataSources) {
                remap = DataTools.orderedMapUnion(remap, (Map)ds.ds2NativeFieldMap());
            }
            List constraints = (List)req.constraints();
            if (constraints != null) {
                remap = DataTools.subsetMap(remap, (List)constraints);
            }
            if ((outputs = req.outputs()) != null) {
                remap = DataTools.subsetMap(remap, (List)outputs);
            }
            if (driver.limitRequiresSQLOrderClause()) {
                if (orderClause == null || orderClause.equals("")) {
                    List pkList = result.getDataSource().getPrimaryKeys();
                    if (driver instanceof OracleDriver) {
                        orderClause = "rownum";
                    } else if (!pkList.isEmpty()) {
                        orderClause = "";
                        for (String fieldName : pkList) {
                            if (fieldName == null) continue;
                            if (!"".equals(orderClause)) {
                                orderClause = orderClause + ",";
                            }
                            orderClause = orderClause + driver.escapeColumnName(fieldName);
                        }
                        log.debug((Object)("Using PK as default sorter: " + orderClause));
                    } else {
                        Iterator<Object> i = remap.keySet().iterator();
                        if (i.hasNext()) {
                            orderClause = (String)i.next();
                        }
                        if ((orderClause = (String)DataTools.enumToList(remap.values().iterator()).get(0)) != null) {
                            if (orderClause.contains(".")) {
                                orderClause = orderClause.substring(orderClause.lastIndexOf(".") + 1);
                            }
                            orderClause = driver.escapeColumnName(orderClause);
                        }
                        log.debug((Object)("Using first field as default sorter: " + orderClause));
                    }
                }
                rowFetchQuery = driver.limitQuery(rowFetchQuery, req.getStartRow(), req.getBatchSize(), DataTools.enumToList(remap.values().iterator()), orderClause, req, dataSources);
            } else {
                rowFetchQuery = driver.limitQuery(rowFetchQuery, req.getStartRow(), req.getBatchSize(), DataTools.enumToList(remap.values().iterator()), req);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SQL windowed select rows " + req.getStartRow() + "->" + req.getEndRow() + ", result size " + req.getBatchSize() + ". Query"), (Object)rowFetchQuery);
            }
            Statement s = null;
            ResultSet rs = null;
            Connection conn = null;
            boolean userTransaction = true;
            boolean streaming = req.shouldStreamResults();
            req.recordTimingData(TIMING_LOG_PAGED_FETCH, DSRequest.TimingLogType.START);
            try {
                start = System.currentTimeMillis();
                req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
                try {
                    conn = firstDS.getTransactionalConnection(req);
                    if (conn == null) {
                        if (driver.dbConnection != null) {
                            conn = driver.dbConnection;
                        } else {
                            driver.dbConnection = conn = SQLConnectionManager.getConnection(driver.getDBName());
                        }
                        userTransaction = false;
                    }
                    req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
                    start = System.currentTimeMillis();
                    req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
                    s = driver.createFetchStatement(conn, streaming, req.getBatchSize());
                    rs = s.executeQuery(rowFetchQuery);
                }
                catch (SQLException se) {
                    if (userTransaction) throw se;
                    SQLConnectionManager.free(conn);
                    driver.dbConnection = conn = SQLConnectionManager.getNewConnection(driver.getDBName());
                    s = driver.createFetchStatement(conn, streaming, req.getBatchSize());
                    rs = s.executeQuery(rowFetchQuery);
                }
                Logger.timing.debug((Object)("Time to execute fetch query: " + (System.currentTimeMillis() - start) + "ms"));
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
                if (req.getBatchSize() != -1L && !(driver instanceof PostgresDriver) && !(driver instanceof HSQLDBDriver)) {
                    rs.setFetchSize((int)(req.getBatchSize() + 1L));
                }
                if (streaming) {
                    log.debug((Object)"Streaming the response");
                    result.setData((Object)new StreamingResponseIterator(result));
                    HashMap<String, Object> sContext = new HashMap<String, Object>();
                    sContext.put("resultSet", rs);
                    sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                    sContext.put("dataSources", dataSources);
                    sContext.put("opConfig", opConfig);
                    sContext.put("dsRequest", req);
                    result.setStreamingContext(sContext);
                    result.setStartRow(req.getStartRow());
                    result.setEndRow(req.getStartRow());
                    result._setHasNextRecord(rs.next());
                    if (!result.hasNextRecord() && progLoading && req.getStartRow() != 0L) {
                        result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                    }
                } else {
                    long ss = System.currentTimeMillis();
                    req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
                    List rows = SQLTransform.toListOfMapsOrBeans(rs, driver, dataSources, opConfig, req);
                    Logger.timing.debug((Object)("SQLTransform took: " + (System.currentTimeMillis() - ss) + "ms"));
                    req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
                    result.setData((Object)rows);
                    result.setEndRow(req.getStartRow() + (long)rows.size());
                    result.setStartRow(req.getStartRow());
                    if (rows.size() == 0 && progLoading && req.getStartRow() != 0L) {
                        result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                    }
                    if (!(useRowCount || progLoading || wrapSqlForRowCount)) {
                        if (paging.equals("jdbcScroll")) {
                            rs.last();
                            int rowNum = rs.getRow();
                            result.setTotalRows((long)(rowNum - 1));
                        }
                        String error = "";
                        if (opConfig == null && "sqlLimit".equals(config.get((Object)"sql.defaultCustomSQLPaging"))) {
                            error = "server.properties entry 'defaultCustomSQLPaging' is set to 'sqlLimit'.  SmartClient Server does not currently support sqlLimit paging for customSQL operations: only the first page will be returned.";
                        } else if (opConfig != null) {
                            error = "DataSource '" + firstDS.getName() + "', " + "operationId: '" + opConfig.get("operationId") + "'" + " is a customSQL operation, but specifies " + "sqlPaging: 'sqlLimit'.  SmartClient Server does not currently " + "support sqlLimit paging for customSQL operations: only " + "the first page will be returned.";
                        }
                        log.warn((Object)error);
                    } else if (progLoading && (long)rows.size() == req.getBatchSize()) {
                        result.setTotalRows(req.getEndRow() + (long)firstDS.getEndGap());
                    }
                    if ((long)rows.size() < req.getBatchSize()) {
                        result.setTotalRows(result.getEndRow());
                    }
                }
                DSResponse dSResponse = result;
                return dSResponse;
            }
            finally {
                if (!streaming) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                req.recordTimingData(TIMING_LOG_PAGED_FETCH, DSRequest.TimingLogType.END);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JDBC driver windowed select rows " + req.getStartRow() + "->" + req.getEndRow() + ", result size " + req.getBatchSize() + ". Query"), (Object)rowFetchQuery);
        }
        Statement s = null;
        ResultSet rs = null;
        Connection conn = null;
        boolean userTransaction = true;
        boolean streaming = req.shouldStreamResults();
        req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH, DSRequest.TimingLogType.START);
        try {
            start = System.currentTimeMillis();
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
            try {
                ISCHttpServletRequest servletReq = null;
                if (req.context != null && req.context.request != null) {
                    servletReq = req.context.request;
                }
                if ((conn = firstDS.getTransactionalConnection(req)) == null) {
                    if (driver.dbConnection != null) {
                        conn = driver.dbConnection;
                    } else {
                        driver.dbConnection = conn = SQLConnectionManager.getConnection(driver.getDBName());
                    }
                    userTransaction = false;
                }
                req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
                start = System.currentTimeMillis();
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
                s = streaming ? driver.createFetchStatement(conn, streaming, req.getBatchSize() + 1L) : driver.createScrollableFetchStatement(conn, req.getBatchSize() + 1L);
                rs = s.executeQuery(rowFetchQuery);
            }
            catch (SQLException se) {
                if (userTransaction) throw se;
                SQLConnectionManager.free(conn);
                driver.dbConnection = conn = SQLConnectionManager.getNewConnection(driver.getDBName());
                s = streaming ? driver.createFetchStatement(conn, streaming, req.getBatchSize() + 1L) : driver.createScrollableFetchStatement(conn, req.getBatchSize() + 1L);
                rs = s.executeQuery(rowFetchQuery);
            }
            long executeTime = System.currentTimeMillis() - start;
            req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
            start = System.currentTimeMillis();
            req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH_SCROLL, DSRequest.TimingLogType.START);
            if (paging.equals("jdbcScroll") && !streaming) {
                log.debug((Object)("Using paging strategy 'jdbcScroll' - scrolling to absolute position " + (req.getStartRow() + 1L)));
                rs.absolute((int)req.getStartRow() + 1);
            } else {
                log.debug((Object)("Using fallback paging strategy 'dropAtServer' - scrolling to absolute position " + (req.getStartRow() + 1L) + " by reading " + "and discarding all intervening rows"));
                int i = 0;
                while ((long)i <= req.getStartRow() && rs.next()) {
                    ++i;
                }
            }
            long scrollTime = System.currentTimeMillis() - start;
            log.debug((Object)("Scrolling / positioning took " + scrollTime + "ms"));
            req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH_SCROLL, DSRequest.TimingLogType.END);
            if (streaming) {
                log.debug((Object)"Streaming the response");
                result.setData((Object)new StreamingResponseIterator(result));
                HashMap<String, Object> sContext = new HashMap<String, Object>();
                sContext.put("resultSet", rs);
                sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                sContext.put("dataSources", dataSources);
                sContext.put("opConfig", opConfig);
                sContext.put("dsRequest", req);
                result.setStreamingContext(sContext);
                result.setStartRow(req.getStartRow());
                result.setEndRow(req.getStartRow());
                result._setHasNextRecord(rs.next());
                if (!result.hasNextRecord() && progLoading && req.getStartRow() != 0L) {
                    result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                }
            } else {
                if (req.getBatchSize() != -1L && driver.canSetFetchSize()) {
                    rs.setFetchSize((int)(req.getBatchSize() + 1L));
                }
                start = System.currentTimeMillis();
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
                List rows = SQLTransform.toListOfMapsOrBeans(rs, req.getBatchSize(), driver, dataSources, opConfig, req);
                long fetchTime = System.currentTimeMillis() - start;
                Logger.timing.debug((Object)("Execute: " + executeTime + "ms, Scroll: " + scrollTime + "ms, Fetch: " + fetchTime + "ms, Total: " + (executeTime + scrollTime + fetchTime) + "ms"));
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
                result.setData((Object)rows);
                result.setEndRow(req.getStartRow() + (long)rows.size());
                result.setStartRow(req.getStartRow());
                if (rows.size() == 0 && progLoading && req.getStartRow() != 0L) {
                    result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                }
                if (!(useRowCount || progLoading || wrapSqlForRowCount)) {
                    long rc = result.getEndRow() + 1L;
                    rs.last();
                    rc = rs.getRow();
                    result.setTotalRows(rc);
                } else if (progLoading && (long)rows.size() == req.getBatchSize()) {
                    result.setTotalRows(req.getEndRow() + (long)firstDS.getEndGap());
                }
                if ((long)rows.size() < req.getBatchSize()) {
                    result.setTotalRows(result.getEndRow());
                }
            }
            DSResponse dSResponse = result;
            return dSResponse;
        }
        finally {
            if (!streaming) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
            req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH, DSRequest.TimingLogType.END);
        }
    }

    private static DSResponse retryProgressiveFetch(DSRequest req, List dataSources, Map context, String paging) throws Exception {
        req.setStartRow(0L);
        BasicDataSource firstDS = (BasicDataSource)dataSources.get(0);
        if (firstDS.getReturnToTop()) {
            req.setEndRow(req.getBatchSize() - (long)firstDS.getLookAhead());
        }
        String statement = SQLDataSource.generateSQLStatement(req, context);
        statement = SQLDataSource.applySandboxNames(statement, req);
        log.debug((Object)("Fetched no records, attempting refetch from 0 to " + req.getEndRow()));
        DSResponse result = SQLDataSource.executeWindowedSelect(req, dataSources, context, statement, paging);
        if (firstDS.getReturnToTop()) {
            result.setInvalidateCache(true);
        }
        return result;
    }

    private static boolean runRowCountQuery(String rowCountQueryString, Map context, DSRequest req, DSResponse result, SQLDataSource firstDS) throws Exception {
        Integer count;
        long start;
        block5: {
            start = System.currentTimeMillis();
            req.recordTimingData(TIMING_LOG_COUNT_QUERY, DSRequest.TimingLogType.START);
            SQLDriver driver = firstDS.getDriver();
            log.debug((Object)"Executing row count query", (Object)rowCountQueryString);
            String rowCountQuery = Velocity.evaluateAsString((String)rowCountQueryString, (Map)context, (String)req.getOperationType(), (DataSource)firstDS, (boolean)true);
            rowCountQuery = SQLDataSource.applySandboxNames(rowCountQuery, req);
            log.debug((Object)"Eval'd row count query", (Object)rowCountQuery);
            String sCount = driver.executeScalar(rowCountQuery, req).toString();
            count = null;
            try {
                count = new Integer(sCount);
            }
            catch (NumberFormatException nfe) {
                int dotIndex = sCount.indexOf(".");
                if (dotIndex == -1) break block5;
                sCount = sCount.substring(0, dotIndex);
                count = new Integer(sCount);
            }
        }
        long end = System.currentTimeMillis();
        req.recordTimingData(TIMING_LOG_COUNT_QUERY, DSRequest.TimingLogType.END);
        boolean dsRequestProgressiveLoading = DataTools.asBoolean((Object)req.getParameter((Object)"progressiveLoading"), (boolean)true);
        if (count != null && count > firstDS.getProgressiveLoadingThreshold() && firstDS.getProgressiveLoadingThreshold() >= 0 && dsRequestProgressiveLoading) {
            log.info((Object)("Row count query found " + count + " rows, which exceeds the " + "DataSource's progressiveLoadingThreshold of " + firstDS.getProgressiveLoadingThreshold() + ".  Switching to " + "progressive loading mode."));
            return true;
        }
        result.setTotalRows((long)count.intValue());
        Logger.timing.debug((Object)("Counted " + result.getTotalRows() + " total rows in result set: " + (end - start) + "ms"));
        if (result.getTotalRows() == 0L) {
            result.setData(new ArrayList());
            result.setStartRow(0L);
            result.setEndRow(0L);
        }
        if (req.getStartRow() > result.getTotalRows() || result.getTotalRows() - req.getStartRow() < req.getBatchSize()) {
            long newStartRow = Math.max(result.getTotalRows() - req.getBatchSize(), 0L);
            req.setStartRow(newStartRow);
        }
        return false;
    }

    private static Map getClausesContext(DSRequest req, List dataSources, boolean qualifyColumnNames, List customCriteriaFields, List customValueFields, List excludeCriteriaFields, Map operationBinding) throws Exception {
        SQLValuesClause valuesClause;
        String opType = req.getOperationType();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("defaultTableClause", new SQLTableClause(req, dataSources).getSQLString());
        ArrayList<DataSource> includeDataSources = new ArrayList<DataSource>(dataSources);
        for (int i = 0; i < dataSources.size(); ++i) {
            BasicDataSource ds = (BasicDataSource)dataSources.get(i);
            if (!(ds.autoDeriveDS instanceof BasicDataSource)) continue;
            includeDataSources.add(ds.autoDeriveDS);
        }
        if (SQLDataSource.isFetch((String)opType) || SQLDataSource.isCustom((String)opType)) {
            SQLSelectClause selectClause = new SQLSelectClause(req, includeDataSources, qualifyColumnNames);
            selectClause.setCustomValueFields(customValueFields);
            context.put("defaultSelectClause", selectClause.getSQLString());
            if (selectClause.isGroupBy()) {
                context.put("defaultGroupClause", selectClause.getGroupByString());
            }
            SQLOrderClause orderClause = new SQLOrderClause(req, dataSources, qualifyColumnNames);
            orderClause.setCustomValueFields(customValueFields);
            if (orderClause.size() > 0) {
                context.put("defaultOrderClause", orderClause.getSQLString());
            }
        }
        if ((SQLDataSource.isAdd((String)opType) || SQLDataSource.isUpdate((String)opType) || SQLDataSource.isCustom((String)opType) || "replace".equals(opType)) && (valuesClause = new SQLValuesClause(req, (SQLDataSource)((Object)dataSources.get(0)))).size() > 0) {
            if (SQLDataSource.isUpdate((String)opType)) {
                context.put("defaultValuesClause", valuesClause.getSQLStringForUpdate());
            } else {
                context.put("defaultValuesClause", valuesClause.getSQLStringForInsert());
            }
        }
        if (!SQLDataSource.isAdd((String)opType)) {
            boolean isFilter = "filter".equals(opType) || ("fetch".equals(opType) || "select".equals(opType)) && ("substring".equals(req.getTextMatchStyle()) || "startsWith".equals(req.getTextMatchStyle()));
            SQLWhereClause whereClause = new SQLWhereClause(qualifyColumnNames, req, dataSources, isFilter, req.getTextMatchStyle());
            whereClause.setCustomCriteriaFields(customCriteriaFields);
            whereClause.setExcludeCriteriaFields(excludeCriteriaFields);
            if (SQLDataSource.isRemove((String)opType) && whereClause.isEmpty() && (operationBinding == null || !operationBinding.containsKey("customSQL") && !operationBinding.containsKey("whereClause"))) {
                throw new SQLException("empty where clause on delete operation - would  destroy table - ignoring.");
            }
            context.put("defaultWhereClause", whereClause.getSQLString());
            if (req.getIncludeFrom() != null && req.getIncludeFrom().size() > 0) {
                boolean oneSQLIncludeFrom = false;
                Iterator i = req.getIncludeFrom().iterator();
                while (i.hasNext()) {
                    if (!SQLDataSource.isAllSql((IncludeFromDefinition)i.next())) continue;
                    oneSQLIncludeFrom = true;
                    break;
                }
                if (oneSQLIncludeFrom) {
                    Boolean useAnsiJoins = DataTools.asBooleanObject(req.getDataSource().getConfig().get("useAnsiJoins"));
                    if (useAnsiJoins == null) {
                        useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
                    }
                    if (useAnsiJoins != null && useAnsiJoins.booleanValue()) {
                        SQLAnsiJoinClause ansiJoinClause = new SQLAnsiJoinClause(req, dataSources, qualifyColumnNames);
                        context.put("defaultAnsiJoinClause", ansiJoinClause.getSQLString());
                    } else {
                        SQLJoinWhereClause joinWhereClause = new SQLJoinWhereClause(req, dataSources, qualifyColumnNames);
                        context.put("defaultJoinWhereClause", joinWhereClause.getSQLString());
                    }
                }
            }
        }
        return context;
    }

    private static boolean isAllSql(IncludeFromDefinition incFrom) throws Exception {
        while (incFrom != null) {
            if (!incFrom.getDataSource().canJoinIncludedFields()) {
                return false;
            }
            incFrom = incFrom.getTargetIncludeFrom();
        }
        return true;
    }

    private static Map getVariablesContext(DSRequest req, List dataSources) throws Exception {
        String opType = req.getOperationType();
        Map context = Velocity.getStandardContextMap((DSRequest)req);
        context.put("where", req.getCriteria());
        context.put("filter", new EscapedValuesMap(req.getCriteria(), dataSources, 2));
        context.put("equals", new EscapedValuesMap(req.getCriteria(), dataSources, 3));
        context.put("substringMatches", new EscapedValuesMap(req.getCriteria(), dataSources, 4));
        if (!(dataSources.get(0) instanceof SQLDataSource)) {
            return context;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        HashMap<String, String> qfields = new HashMap<String, String>();
        SQLDataSource firstDS = (SQLDataSource)((Object)dataSources.get(0));
        Map remapTable = SQLDataSource.getField2ColumnMap(dataSources);
        Map column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        for (String key : firstDS.getFieldNames()) {
            String tableName;
            String columnName = (String)remapTable.get(key);
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            if ((tableName = (String)column2TableMap.get(columnName)) == null) {
                tableName = firstDS.getTable().getName();
            }
            for (int j = 0; j < dataSources.size(); ++j) {
                DataSource ds = (DataSource)dataSources.get(j);
                DSField field = ds.getField(key);
                if (field == null) continue;
                if (field.get((Object)"tableName") == null) break;
                tableName = field.get((Object)"tableName").toString();
                break;
            }
            if (columnName == null) continue;
            qfields.put(key, firstDS.getDriver().sqlOutTransform(columnName, key, tableName));
            fields.put(key, firstDS.getDriver().sqlOutTransform(columnName, key, null));
        }
        context.put("fields", fields);
        context.put("qfields", qfields);
        HashMap rawValue = new HashMap();
        Iterator i = context.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            rawValue.put(key, context.get(key));
        }
        context.put("rawValue", rawValue);
        return context;
    }

    private static List getDataSources(List dataSourceList, DSRequest dsRequest) throws Exception {
        ArrayList dataSources = new ArrayList();
        for (Object ds : dataSourceList) {
            if (ds instanceof SQLDataSource) {
                dataSources.add(ds);
                continue;
            }
            SQLDataSource SQLds = (SQLDataSource)DataSourceManager.getDataSource((String)((String)ds), (DSRequest)dsRequest);
            if (SQLds == null) continue;
            dataSources.add(SQLds);
        }
        return dataSources;
    }

    public static Map getField2ColumnMap(List dataSources) {
        return SQLDataSource.getField2ColumnMap(dataSources, false);
    }

    public static Map getField2ColumnMap(List dataSources, boolean primaryKeysOnly) {
        Map combinedRemap = new HashMap();
        for (SQLDataSource ds : dataSources) {
            Map singleRemap = ds.getCorrectDs2NativeFieldMap();
            if (primaryKeysOnly) {
                singleRemap = DataTools.subsetMap((Map)singleRemap, (List)ds.getPrimaryKeys());
            }
            combinedRemap = DataTools.orderedMapUnion(combinedRemap, (Map)singleRemap);
        }
        return combinedRemap;
    }

    public static Map getColumn2TableMap(List dataSources) {
        return SQLDataSource.getColumn2TableMap(dataSources, false);
    }

    public static Map getColumn2TableMap(List dataSources, boolean primaryKeysOnly) {
        HashMap column2TableMap = new HashMap();
        for (SQLDataSource ds : dataSources) {
            Map singleRemap = ds.ds2NativeFieldMap();
            if (primaryKeysOnly) {
                singleRemap = DataTools.subsetMap((Map)singleRemap, (List)ds.getPrimaryKeys());
            }
            for (Object field : singleRemap.keySet()) {
                Object column = singleRemap.get(field);
                if (column instanceof List) {
                    column = ((List)column).get(0);
                }
                String columnName = (String)column;
                if (column2TableMap.containsKey(field)) continue;
                if (columnName != null && columnName.contains(".")) {
                    column2TableMap.put(field, columnName.substring(0, columnName.indexOf(".")));
                    continue;
                }
                column2TableMap.put(field, ds.getTable().getName());
            }
        }
        return column2TableMap;
    }

    public static Map getCombinedValueMaps(List dataSources, List sortBy) {
        Map valueMaps = new HashMap();
        for (SQLDataSource ds : dataSources) {
            valueMaps = DataTools.orderedMapUnion(valueMaps, (Map)ds.getValueMaps(sortBy));
        }
        return valueMaps;
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, tableName, schema, null, null, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, null, null, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, serverType, null, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, serverType, dbName, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName, Map autoDeriveSchemaOperation, boolean cacheDS, Map overriddenFields, Boolean autoDeriveFKs) throws Exception {
        if (serverType == null) {
            serverType = "sql";
        }
        if (tableName == null) {
            tableName = ID;
        }
        if (ID == null) {
            ID = tableName;
        }
        String wkTableName = tableName.endsWith("_inheritsFrom") ? tableName.substring(0, tableName.lastIndexOf("_inheritsFrom")) : tableName;
        Map config = SQLDataSource.getConfigFromTable(conn, wkTableName, schema, ID, serverType, dbName, autoDeriveSchemaOperation, overriddenFields, autoDeriveFKs);
        config.put("__autoConstruct", "DataSource");
        if ("hibernate".equals(serverType) && tableName.endsWith("_inheritsFrom")) {
            config.put("_inheritsFrom", "true");
        }
        if (cacheDS) {
            config.put("dbName", dbName);
        }
        DataSource ds = DataSource.fromConfig((Map)config, null);
        if (cacheDS) {
            if (tableName.endsWith("_inheritsFrom")) {
                DataStructCache.addCachedObjectWithNoConfigFile((String)(ID + "_inheritsFrom"), (Object)ds);
            } else {
                DataStructCache.addCachedObjectWithNoConfigFile((String)ID, (Object)ds);
            }
        }
        return ds;
    }

    public static Map getConfigFromTable(String tableName, String schema, String serverType, String dbName) throws Exception {
        return SQLDataSource.getConfigFromTable(null, tableName, tableName, schema, serverType, dbName, null, null, null);
    }

    public static Map getConfigFromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName, Map autoDeriveSchemaOperation, Map overriddenFields, Boolean autoDeriveFKs) throws Exception {
        SQLDSGenerator generator = new SQLDSGenerator(tableName, schema, dbName, serverType);
        generator.setConn(conn);
        generator.setID(ID);
        generator.setOverriddenFields(overriddenFields);
        if (autoDeriveSchemaOperation != null) {
            generator.setAutoDeriveSchemaOperation(autoDeriveSchemaOperation);
        }
        generator.setAutoDeriveFKs(autoDeriveFKs);
        return generator.generate();
    }

    public static List getFieldsFromTable(Connection conn, String tableName, String schema) throws Exception {
        return SQLDSGenerator.getFieldsFromTable(conn, tableName, schema);
    }

    protected Boolean autoJoinAtProviderLevel(DSRequest req) {
        String autoJoin;
        String dbName = (String)this.dsConfig.get("dbName");
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if ((autoJoin = config.getString((Object)("sql." + dbName + ".autoJoinTransactions"))) == null) {
            return null;
        }
        if (autoJoin.toLowerCase().equals("true") || autoJoin.equals("ALL")) {
            return Boolean.TRUE;
        }
        if (autoJoin.toLowerCase().equals("false") || autoJoin.equals("NONE")) {
            return Boolean.FALSE;
        }
        if (req != null && req.rpc != null) {
            if (autoJoin.equals("FROM_FIRST_CHANGE")) {
                return req.rpc.requestQueueIncludesUpdates();
            }
            if (autoJoin.equals("ANY_CHANGE")) {
                return req.rpc.requestQueueIncludesUpdates();
            }
        }
        return null;
    }

    public int getProviderLevelTransactionPolicy(DSRequest req) {
        String autoJoin;
        String dbName = (String)this.dsConfig.get("dbName");
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if ((autoJoin = config.getString((Object)("sql." + dbName + ".autoJoinTransactions"))) == null) {
            return 0;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return 3;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return 4;
        }
        if (req != null && req.rpc != null) {
            if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
                return 1;
            }
            if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
                return 2;
            }
        }
        return 0;
    }

    public String getTransactionObjectKey() throws Exception {
        return "_isc_sql_connection_" + this.driver.getDBName();
    }

    public void onSuccess(RPCManager rpc) throws Exception {
        SQLTransaction.commitTransaction(rpc, this.driver.getDBName());
    }

    public void onFailure(RPCManager rpc, boolean transactionFailed) throws Exception {
        if (transactionFailed) {
            SQLTransaction.rollbackTransaction(rpc, this.driver.getDBName());
        } else {
            SQLTransaction.commitTransaction(rpc, this.driver.getDBName());
        }
    }

    public void freeResources(DSRequest req) {
        try {
            if (req != null && req.getRPCManager() != null && !req.getFreeOnExecute() && SQLTransaction.getConnection(req.getRPCManager(), this.driver.dbName) != null) {
                SQLTransaction.endTransaction(req.getRPCManager(), this.driver.dbName);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception while ending transaction connection", (Throwable)e);
        }
        super.freeResources(req);
    }

    public boolean canJoinIncludedFields() {
        return true;
    }

    public boolean inheritsParentForJoin() throws Exception {
        if (this.dsConfig.containsKey("autoInheritParent") && DataTools.getBoolean((Map)this.dsConfig, (Object)"autoInheritParent")) {
            return false;
        }
        if (DataSource.DSInheritanceMode.FULL.equals((Object)this.getInheritanceMode()) || DataSource.DSInheritanceMode.NONE.equals((Object)this.getInheritanceMode())) {
            return false;
        }
        if (!(this.getSuper() instanceof SQLDataSource)) {
            return false;
        }
        return this.isRelatedThroughPrimaryKey((DataSource)this.getSuper());
    }

    public List getPrimaryKeys() {
        if (this.primaryKeys != null && this.primaryKeys.size() > 0) {
            return this.primaryKeys;
        }
        List pks = new ArrayList();
        if (this.getSuper() != null) {
            pks = this.getSuper().getPrimaryKeys();
        }
        return pks;
    }

    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = (DSField)this.dsFields.get(fieldName);
        if (field != null) {
            return field;
        }
        if (this.getSuper() != null) {
            field = this.getSuper().getField(fieldName);
        }
        if (field != null && "sequence".equals(field.getType())) {
            Iterator i = this.dsFields.keySet().iterator();
            while (i.hasNext()) {
                DSField localField = (DSField)this.dsFields.get(i.next());
                if (localField == null || !"sequence".equals(localField.getType())) continue;
                DSField changedField = new DSField((Map)field);
                changedField.put((Object)"type", (Object)"integer");
                return changedField;
            }
        }
        return field;
    }

    public Map getCorrectDs2NativeFieldMap() {
        if (DataSource.DSInheritanceMode.NONE.equals((Object)this.getInheritanceMode())) {
            return this.ds2NativeFieldMap;
        }
        return this.getExpandedDs2NativeFieldMap();
    }

    public boolean supportsGroupFunction(String functionName) {
        if (functionName == null) {
            return false;
        }
        if ("CONCAT".equals(functionName.toUpperCase()) && !"ORACLE".equals(this.getDriver().getDBName().toUpperCase())) {
            log.warn((Object)"Aggregation function 'Concat' is supported with Oracle database only.");
            return false;
        }
        return supportedAggregationFunctions.contains(functionName.toUpperCase());
    }

    public boolean shouldUseUTCDateTimes() {
        if (this.dsConfig.get("useUTCDateTimes") != null) {
            return DataTools.getBoolean((Map)this.dsConfig, (Object)"useUTCDateTimes");
        }
        if (this.driver != null) {
            return this.driver.useUTCDateTimes;
        }
        return true;
    }

    public static String getSQLClause(SQLClauseType type, DSRequest dsRequest) throws Exception {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        DataSource ds = dsRequest.getDataSource();
        dataSources.add(ds);
        Map opBinding = ds.getOperationBinding(dsRequest);
        List customFields = SQLDataSource.getCustomFields(opBinding);
        List customCriteriaFields = SQLDataSource.getCustomCriteriaFields(opBinding);
        List customValueFields = SQLDataSource.getCustomValueFields(opBinding);
        List excludeValueFields = SQLDataSource.getExcludeValueFields(opBinding);
        if (customCriteriaFields == null) {
            customCriteriaFields = customFields;
        }
        if (customValueFields == null) {
            customValueFields = customFields;
        }
        Map context = SQLDataSource.getVariablesContext(dsRequest, dataSources);
        dsRequest.buildFieldData(false);
        context.putAll(SQLDataSource.getClausesContext(dsRequest, dataSources, SQLDataSource.shouldQualifyColumnNames(opBinding, ds), customCriteriaFields, customValueFields, excludeValueFields, opBinding));
        String clauseName = (Object)((Object)type) + "Clause";
        String defaultClause = "$default" + clauseName;
        clauseName = clauseName.substring(0, 1).toLowerCase() + clauseName.substring(1);
        String sql = type == SQLClauseType.All ? SQLDataSource.generateSQLStatement(dsRequest, context) : SQLDataSource.getClause(dsRequest, clauseName, defaultClause);
        return Velocity.evaluateAsString((String)sql, (Map)context, (String)("getSQLClause(" + (Object)((Object)type) + ")"), (DataSource)ds, (boolean)true);
    }

    public Object streamNextRecordAsObject(DSResponse response) throws StreamingResponseException {
        return this._streamNextRecord(response, true);
    }

    public Map streamNextRecord(DSResponse response, Map context) throws StreamingResponseException {
        Object obj = this._streamNextRecord(response, false);
        if (obj == null || obj instanceof Map) {
            return (Map)obj;
        }
        throw new StreamingResponseException("Unexpected object type " + obj.getClass().getName() + "returned from SQLTransform");
    }

    private Object _streamNextRecord(DSResponse response, boolean convertToBeans) throws StreamingResponseException {
        try {
            Map context = response._getStreamingContext();
            ResultSet resultSet = (ResultSet)context.get("resultSet");
            List dataSources = (List)context.get("dataSources");
            Boolean brokenCursorAPIs = (Boolean)context.get("brokenCursorAPIs");
            Map opConfig = (Map)context.get("opConfig");
            DSRequest dsRequest = (DSRequest)context.get("dsRequest");
            List work = SQLTransform.toListOfMapsOrBeans(resultSet, 1L, brokenCursorAPIs, dataSources, opConfig, dsRequest, convertToBeans, response);
            return work.get(0);
        }
        catch (Exception e) {
            if (e instanceof StreamingResponseException) {
                throw (StreamingResponseException)e;
            }
            StreamingResponseException sre = new StreamingResponseException("Exception trying to stream the next record in a SQLDataSource DSResponse");
            sre.initCause((Throwable)e);
            throw sre;
        }
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    public DataSource.DSInheritanceMode getInheritanceMode() {
        return "none".equals(this.dsConfig.get("inheritanceMode")) ? DataSource.DSInheritanceMode.NONE : DataSource.DSInheritanceMode.FULL;
    }

    public Relation getRelation(DataSource relatedDS) throws Exception {
        try {
            return super.getRelation(relatedDS, false);
        }
        catch (ForeignKeyNotFoundException fknfe) {
            if (relatedDS instanceof SQLDataSource) {
                SQLDataSource relatedSQLDS = (SQLDataSource)relatedDS;
                String relatedTableName = (String)relatedSQLDS.getConfig().get("tableName");
                if (relatedTableName == null) {
                    relatedTableName = (String)relatedSQLDS.getConfig().get("ID");
                }
                CaseInsensitiveMap native2DS = new CaseInsensitiveMap(relatedSQLDS.native2DSFieldMap());
                String fields = "";
                for (DSField field : this.getFields()) {
                    String relatedFieldName;
                    String[] parts;
                    String nativeFK = field.getNativeFK();
                    if (nativeFK == null || (parts = nativeFK.split("\\.")).length < 2 || !parts[0].equalsIgnoreCase(relatedTableName) || (relatedFieldName = (String)native2DS.get((Object)parts[1])) == null) continue;
                    String fkDefinition = relatedSQLDS.getID() + "." + relatedFieldName;
                    field.setForeignKey(fkDefinition);
                    fields = fields + ("".equals(fields) ? "" : ", ") + field.getName();
                }
                try {
                    return super.getRelation(relatedDS, true);
                }
                catch (ForeignKeyNotFoundException fknfe2) {
                    log.warn((Object)("NOTE: This failure to find a relation happened despite an attempt to use native FKs derived from the schema metadata.  " + (fields.equals("") ? "No valid native FK fields were found" : "We found the following native FK fields: " + fields)));
                }
            }
            throw fknfe;
        }
    }

    public void createStorage(boolean dropFirst) throws Exception {
        try {
            SQLTableCreator.createTable(this, dropFirst);
        }
        catch (Exception ex) {
            log.warn((Object)("Error creating storage for DataSource " + this.getName() + (dropFirst ? " after dropping tables" : " without dropping tables") + " first"), (Throwable)ex);
            throw ex;
        }
    }

    public String getEnumTranslateStrategy() {
        String value = (String)this.dsConfig.get("enumTranslateStrategy");
        if (value == null) {
            value = "string";
        }
        return value;
    }

    static {
        if (config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
            createTrace = new ArrayList<Map>();
        }
        supportedAggregationFunctions = new ArrayList(){
            {
                this.add("MIN");
                this.add("MAX");
                this.add("AVG");
                this.add("SUM");
                this.add("COUNT");
                this.add("CONCAT");
            }
        };
    }
}

