/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class SQLTransaction
extends Base {
    public static final String CONNECTION_ATTR = "_isc_sql_connection_";
    public static final String DBNAME_ATTR = "_isc_default_dbName";
    private static Logger log = new Logger(SQLTransaction.class.getName());
    private static boolean autoEndTransactions = false;

    public static void setAutoEndTransactions(boolean autoEnd) {
        autoEndTransactions = autoEnd;
    }

    public static boolean startTransaction(RPCManager rpc) throws Exception {
        String dbName = null;
        List dsReqs = rpc.getRequests();
        for (Object req : dsReqs) {
            DSRequest dsReq;
            DataSource ds;
            if (!(req instanceof DSRequest) || !((ds = (dsReq = (DSRequest)req).getDataSource()) instanceof SQLDataSource)) continue;
            dbName = ((SQLDataSource)ds).getDriver().dbName;
            break;
        }
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        rpc.setAttribute(DBNAME_ATTR, (Object)dbName);
        return SQLTransaction.startTransaction(rpc, dbName);
    }

    public static boolean startTransaction(RPCManager rpc, String dbName) throws SQLException {
        HashMap trxInfo = new HashMap();
        Connection connection = (Connection)rpc.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            connection = SQLConnectionManager.getConnection(dbName);
            connection.setAutoCommit(false);
            rpc.setAttribute(DBNAME_ATTR, (Object)dbName);
            rpc.setAttribute(CONNECTION_ATTR + dbName, (Object)connection);
            log.debug((Object)("Started new " + dbName + " transaction \"" + connection.hashCode() + "\""));
            return true;
        }
        log.debug((Object)("startTransaction called but transaction \"" + connection.hashCode() + "\" was already active - ignoring the startTransaction request"));
        return true;
    }

    public static Connection getConnection(RPCManager rpc) throws Exception {
        List dsReqs = rpc.getRequests();
        for (Object req : dsReqs) {
            DSRequest dsReq;
            DataSource ds;
            if (!(req instanceof DSRequest) || !((ds = (dsReq = (DSRequest)req).getDataSource()) instanceof SQLDataSource)) continue;
            String dbName = ((SQLDataSource)ds).getDriver().dbName;
            if (dbName == null) {
                dbName = config.getString((Object)"sql.defaultDatabase");
            }
            rpc.setAttribute(DBNAME_ATTR, (Object)dbName);
            return SQLTransaction.getConnection(rpc, dbName);
        }
        throw new Exception("Could not find a DSRequest for a SQLDataSource in getConnection");
    }

    public static Connection getConnection(RPCManager rpc, String dbName) throws Exception {
        Connection connection = (Connection)rpc.getAttribute(CONNECTION_ATTR + dbName);
        log.debug((Object)("Returning transactional connection for " + dbName + (connection == null ? " (connection is null)" : " with hashcode \"" + connection.hashCode() + "\"")));
        return connection;
    }

    public static void rollbackTransaction(RPCManager rpc) throws Exception {
        String dbName = (String)rpc.getAttribute(DBNAME_ATTR);
        SQLTransaction.rollbackTransaction(rpc, dbName);
    }

    public static void rollbackTransaction(RPCManager rpc, String dbName) throws Exception {
        Connection connection = (Connection)rpc.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            throw new Exception("No current connection for '" + dbName + "'");
        }
        log.debug((Object)("Rolling back " + dbName + " transaction \"" + connection.hashCode() + "\""));
        connection.rollback();
        if (autoEndTransactions) {
            SQLTransaction.endTransaction(rpc, dbName);
        }
    }

    public static void commitTransaction(RPCManager rpc) throws Exception {
        String dbName = (String)rpc.getAttribute(DBNAME_ATTR);
        SQLTransaction.commitTransaction(rpc, dbName);
    }

    public static void commitTransaction(RPCManager rpc, String dbName) throws Exception {
        Connection connection = (Connection)rpc.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            throw new Exception("No current connection for '" + dbName + "'");
        }
        log.debug((Object)("Committing " + dbName + " transaction \"" + connection.hashCode() + "\""));
        connection.commit();
        if (autoEndTransactions) {
            SQLTransaction.endTransaction(rpc, dbName);
        }
    }

    public static void endTransaction(RPCManager rpc) throws Exception {
        String dbName = (String)rpc.getAttribute(DBNAME_ATTR);
        SQLTransaction.endTransaction(rpc, dbName);
    }

    public static void endTransaction(RPCManager rpc, String dbName) throws Exception {
        Connection connection = (Connection)rpc.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            throw new Exception("No current connection for '" + dbName + "'");
        }
        log.debug((Object)("Ending " + dbName + " transaction \"" + connection.hashCode() + "\""));
        SQLConnectionManager.free(connection);
        rpc.removeAttribute(DBNAME_ATTR);
        rpc.removeAttribute(CONNECTION_ATTR + dbName);
    }
}

