/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLTransform;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLMetaData
extends Base {
    private static Logger log = new Logger(SQLMetaData.class.getName());
    static String defaultDatabase = config.getString((Object)"sql.defaultDatabase");
    public String database;
    public Connection conn;

    public SQLMetaData() {
        this(null, null);
    }

    public SQLMetaData(Connection conn) {
        this(conn == null ? null : "derivedFromConnection", conn);
    }

    public SQLMetaData(String database) {
        this(database, null);
    }

    public SQLMetaData(String database, Connection conn) {
        this.database = database;
        if (database == null) {
            this.database = defaultDatabase;
        }
        this.conn = conn;
    }

    public Connection conn() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            try {
                this.conn = SQLConnectionManager.getUnpooledConnection(this.database);
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
        }
        return this.conn;
    }

    protected void finalize() throws Throwable {
        this.conn.close();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn().getMetaData();
    }

    public List mapValuesAsList(List list) throws SQLException {
        ArrayList results = new ArrayList();
        for (Map map : list) {
            if (map.size() != 1) {
                throw new SQLException("Expected single key/value pair - map size is: " + map.size());
            }
            results.add(map.values().iterator().next());
        }
        return results;
    }

    public List mapValuesAsListForKey(Object key, List list) throws SQLException {
        ArrayList results = new ArrayList();
        for (Map map : list) {
            if (map.size() < 1) {
                throw new SQLException("Expected at least one  key/value pair - map size is: " + map.size());
            }
            Object result = map.get(key);
            if (result == null) {
                result = map.get(key.toString().toLowerCase());
            }
            if (result == null) {
                result = map.get(key.toString().toUpperCase());
            }
            if (result == null) {
                throw new SQLException("Unable to get value for key: " + key.toString());
            }
            results.add(result);
        }
        return results;
    }

    public List mapValuesAsListForKeySet(Set keys, List list) throws SQLException {
        ArrayList results = new ArrayList();
        for (Map map : list) {
            if (map.size() < 1) {
                throw new SQLException("Expected at least one  key/value pair - map size is: " + map.size());
            }
            HashMap resultMap = new HashMap();
            Iterator j = keys.iterator();
            while (j.hasNext()) {
                String key = j.next().toString();
                Object result = map.get(key);
                if (result == null) {
                    result = map.get(key.toLowerCase());
                }
                if (result == null) {
                    result = map.get(key.toUpperCase());
                }
                if (result == null) continue;
                resultMap.put(key, result);
            }
            results.add(resultMap);
        }
        return results;
    }

    public Map getProductNameAndVersion() throws SQLException {
        String name = this.getMetaData().getDatabaseProductName();
        String version = this.getMetaData().getDatabaseProductVersion();
        String driverVersion = this.getMetaData().getDriverVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("productName", name);
        map.put("productVersion", version);
        map.put("driverVersion", driverVersion);
        return map;
    }

    public List getCatalogs() throws SQLException {
        return this.mapValuesAsList(SQLTransform.toListOfMaps(this.getMetaData().getCatalogs()));
    }

    public List getSchemas() throws SQLException {
        return this.mapValuesAsList(SQLTransform.toListOfMaps(this.getMetaData().getSchemas()));
    }

    public List getTableTypes() throws SQLException {
        return this.mapValuesAsList(SQLTransform.toListOfMaps(this.getMetaData().getTableTypes()));
    }

    public List getViews(String catalog) throws SQLException {
        return this.getTablesOfType(catalog, "VIEW");
    }

    public List getTables(String catalog) throws SQLException {
        return this.getTablesOfType(catalog, "TABLE");
    }

    public List getTableNamesAndRemarks(String catalog, String schema, List types) throws SQLException {
        return this.getBasicTableDetailsForType(catalog, schema, types);
    }

    public List getTablesOfType(String catalog, String type) throws SQLException {
        String[] types = new String[]{type};
        List results = SQLTransform.toListOfMaps(this.getMetaData().getTables(catalog, null, null, types));
        return this.mapValuesAsListForKey("TABLE_NAME", results);
    }

    public List getBasicTableDetailsForType(String catalog, String schema, List types) throws SQLException {
        String[] typesArr = new String[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            typesArr[i] = (String)types.get(i);
        }
        List results = SQLTransform.toListOfMaps(this.getMetaData().getTables(catalog, schema, null, typesArr));
        HashSet<String> keys = new HashSet<String>();
        keys.add("TABLE_NAME");
        keys.add("REMARKS");
        keys.add("TABLE_SCHEM");
        keys.add("TABLE_TYPE");
        return this.mapValuesAsListForKeySet(keys, results);
    }

    public List getColumnNames(String catalog, String table) throws SQLException {
        List results = SQLTransform.toListOfMaps(this.getMetaData().getColumns(catalog, null, table, null));
        return this.mapValuesAsListForKey("COLUMN_NAME", results);
    }

    public List getPrimaryKeys(String catalog, String table) throws SQLException {
        ResultSet rs = this.getMetaData().getPrimaryKeys(catalog, null, table);
        List results = SQLTransform.toListOfMaps(rs);
        return this.mapValuesAsListForKey("COLUMN_NAME", results);
    }

    public List getForeignKeys(String catalog, String schemaName, String table) throws SQLException {
        ResultSet rs = this.getMetaData().getImportedKeys(catalog, schemaName, table);
        return SQLTransform.toListOfMaps(rs);
    }

    public List getColumnMetaData(String catalog, String schemaName, String table) throws SQLException {
        List results = SQLTransform.toListOfMaps(this.getMetaData().getColumns(catalog, schemaName, table, null));
        if (results == null || results.size() == 0) {
            return new ArrayList();
        }
        return results;
    }

    public Map getColumnMetaData(String catalog, String schemaName, String table, String column) throws SQLException {
        List results = SQLTransform.toListOfMaps(this.getMetaData().getColumns(catalog, schemaName, table, column));
        if (results == null || results.size() == 0) {
            return new HashMap();
        }
        return (Map)results.get(0);
    }
}

