/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.CanParseCriterion;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.SimpleCriteria;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.log.Logger;
import java.util.HashMap;
import java.util.Map;

public class Evaluator {
    public static Logger log = new Logger(Evaluator.class.getName());
    Map<String, Operator> customOperators;

    public void addSearchOperator(Operator op) {
        if (this.customOperators == null) {
            this.customOperators = new HashMap<String, Operator>();
        }
        if (this.customOperators.containsValue(op)) {
            log.warn("Attempted to add existing operator " + op.getID() + " - replacing");
        } else if (this.customOperators.containsKey(op.getID())) {
            log.warn("Two different operators have the same ID " + op.getID() + " - replacing.");
        }
        this.customOperators.put(op.getID(), op);
    }

    Operator getSearchOperator(String id) {
        Operator o = DefaultOperators.getDefaultOperatorMap().get(id);
        if (o == null && this.customOperators != null) {
            o = this.customOperators.get(id);
        }
        return o;
    }

    public boolean valuesMatchCriteria(Map values, SimpleCriteria sc, String textMatchStyle) throws Exception {
        return sc.valuesMatchCriteria(values, textMatchStyle);
    }

    public boolean valuesMatchCriteria(Map values, AdvancedCriteria ac) throws Exception {
        return this.evaluateCriterion(values, ac.criteria);
    }

    public boolean evaluateCriterion(Map values, Criterion criterion) throws Exception {
        if (criterion == null) {
            throw new Exception("Null criterion found (Invalid operator ID probably used)");
        }
        Operator op = this.getSearchOperator(criterion.getOperatorId());
        if (op == null) {
            throw new Exception("No operator for id=" + criterion.getOperatorId());
        }
        try {
            return op.condition(values, criterion, this);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AdvancedCriteria parseAdvancedCriteria(Map rawCriteria) {
        Criterion criterion = Evaluator.parseCriterion(rawCriteria);
        String constructor = (String)rawCriteria.get("_constructor");
        return new AdvancedCriteria(criterion, constructor);
    }

    public static Criterion parseCriterion(Map rawCriteria) {
        String operatorId = (String)rawCriteria.get("operator");
        Map<String, Operator> operators = DefaultOperators.getDefaultOperatorMap();
        Operator o = operators.get(operatorId);
        if (o != null && o instanceof CanParseCriterion) {
            return ((CanParseCriterion)((Object)o)).parseCriterion(rawCriteria);
        }
        return new CustomCriterion(operatorId, rawCriteria);
    }

    public static Object getPathValue(Map values, String fieldPath) {
        if (!fieldPath.contains(".")) {
            return values.get(fieldPath);
        }
        String[] path = fieldPath.split("\\.");
        Map o = values;
        for (String pathPart : path) {
            o = o.get(pathPart);
        }
        return o;
    }
}

