/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.auth.Authenticator;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import java.util.Map;

public class DataSourceAuthenticator
extends Authenticator {
    public String datasource = "users";
    public String usernameField = "username";
    public String passwordField = "password";
    private static Logger log = new Logger(DataSourceAuthenticator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object authenticate(RequestContext context) throws Exception {
        String submittedUsername = this.getSubmittedUsername(context);
        String submittedPassword = this.getSubmittedPassword(context);
        if (submittedUsername == null) {
            log.debug("attempt to authenticate with a null username");
            return null;
        }
        if (submittedPassword == null) {
            log.debug("attempt to authenticate with a null password with username: " + submittedUsername);
            return null;
        }
        DataSource ds = DataSourceManager.getDataSource(this.datasource, null);
        if (ds == null) {
            throw new Exception("Unable to load datasource: " + this.datasource + " for authentication");
        }
        try {
            Map user = ds.selectSingle(this.usernameField, submittedUsername);
            if (user == null || user.size() == 0) {
                log.debug("no user record for username: " + submittedUsername);
                Object var6_6 = null;
                return var6_6;
            }
            String dsPassword = (String)user.get(this.passwordField);
            if (dsPassword.equals(submittedPassword)) {
                log.debug("datasource auth succeded for username: " + submittedUsername);
                user.remove(this.passwordField);
                Map map = user;
                return map;
            }
            log.info("password incorrect for username: " + submittedUsername);
            Object var7_10 = null;
            return var7_10;
        }
        finally {
            try {
                DataSourceManager.freeDataSource(ds);
            }
            catch (Exception exception) {}
        }
    }
}

