/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.base.IScriptSource;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.FreeResourcesHandler;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class DataSourceDMI
implements IScriptSource,
FreeResourcesHandler {
    private static Logger log = new Logger(DataSourceDMI.class.getName());
    private static Config config = Config.getGlobal();
    DSRequest dsRequest;
    RPCManager rpc;
    RequestContext context;
    private List operationTypesNotRequiringExplicitBindings = config.getList("DMI.operationTypesNotRequiringExplicitBindings", new ArrayList());

    public static DSResponse execute(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        return new DataSourceDMI(dsRequest, rpc, context).execute();
    }

    public DataSourceDMI(DSRequest dsRequest, RPCManager rpc, RequestContext context) {
        this.dsRequest = dsRequest;
        this.rpc = rpc;
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DSResponse execute() throws Exception {
        Object returnValue;
        Class<?> returnValueClass;
        boolean dropExtraFields;
        DataSource ds;
        block45: {
            String methodName;
            String explicitMethodName;
            ServerObject serverObject;
            Map operationBinding;
            String operationType;
            block47: {
                Map serverObjectConfig;
                block46: {
                    boolean opLevelServerObject;
                    Map defaultServerObjectConfig;
                    String operationBindingString;
                    String operationId;
                    block44: {
                        block43: {
                            this.dsRequest.setBeenThroughDMI(true);
                            String dsName = this.dsRequest.getDataSourceName();
                            ds = this.dsRequest.getDataSource();
                            if (ds == null) {
                                return null;
                            }
                            operationType = this.dsRequest.getOperationType();
                            operationId = this.dsRequest.getOperationId();
                            if (operationId == null) {
                                operationId = ds.getAutoOperationId(operationType);
                            }
                            boolean operationIdIsAuto = operationId != null && operationId.equals(ds.getAutoOperationId(operationType));
                            Map testOperationBinding = ds.getOperationBinding(this.dsRequest);
                            if (this.dsRequest.getIsAdvancedCriteria()) {
                                Object allowAdvancedCriteria;
                                boolean skipDataSourceCheck = false;
                                if (testOperationBinding != null && (allowAdvancedCriteria = testOperationBinding.get("allowAdvancedCriteria")) != null) {
                                    if (!DataTools.asBoolean(allowAdvancedCriteria)) throw new Exception("DSRequest for DataSource '" + ds.getName() + "' with operation type '" + operationType + "' and " + "operationId '" + operationId + "' contained AdvancedCriteria, " + "but the OperationBinding is explicitly flagged as not " + "supporting AdvancedCriteria");
                                    skipDataSourceCheck = true;
                                }
                                if (!skipDataSourceCheck && ds != null && !ds.allowAdvancedCriteria()) {
                                    throw new Exception("DSRequest for DataSource '" + ds.getName() + "' contained AdvancedCriteria, which the DataSource " + "does not support");
                                }
                            }
                            if ((operationBinding = this.validateOperationBinding()) == null) {
                                return null;
                            }
                            operationBindingString = "operationBinding for DataSource: " + ds.getName() + " with operationType: " + operationType + (operationIdIsAuto || operationId == null ? "" : ", operationId: ") + operationId;
                            defaultServerObjectConfig = ds.getServerObjectConfig();
                            DSResponse validationFailure = ds.validateDSRequest(this.dsRequest);
                            if (validationFailure != null) {
                                return validationFailure;
                            }
                            serverObjectConfig = (Map)operationBinding.get("serverObject");
                            opLevelServerObject = false;
                            if (serverObjectConfig == null) {
                                serverObjectConfig = defaultServerObjectConfig;
                            } else {
                                opLevelServerObject = true;
                            }
                            dropExtraFields = config.getBoolean((Object)"DMI.dropExtraFields", true);
                            if (ds.dropExtraFieldsDefined()) {
                                dropExtraFields = ds.dropExtraFields();
                            }
                            if (serverObjectConfig != null && serverObjectConfig.get("dropExtraFields") != null) {
                                dropExtraFields = "true".equals(serverObjectConfig.get("dropExtraFields").toString().toLowerCase());
                            }
                            if (operationBinding.get("dropExtraFields") != null) {
                                dropExtraFields = "true".equals(operationBinding.get("dropExtraFields").toString().toLowerCase());
                            } else if ("custom".equals(operationType)) {
                                dropExtraFields = false;
                            }
                            returnValueClass = null;
                            returnValue = null;
                            if (operationBinding.get("script") != null) break block43;
                            if (ds.getConfig().get("script") == null) break block44;
                            if (!DataSource.isCrud(operationType)) break block44;
                        }
                        returnValueClass = (returnValue = this.evalInlineScript(operationBinding)) == null ? null : returnValue.getClass();
                        break block45;
                    }
                    ReflectionArgument[] factoryOptionalArgs = new ReflectionArgument[]{new ReflectionArgument(RPCManager.class, this.rpc, false, false), new ReflectionArgument(DSRequest.class, this.dsRequest, false, false)};
                    serverObject = null;
                    try {
                        try {
                            serverObject = new ServerObject(serverObjectConfig, this.context, factoryOptionalArgs, operationBindingString);
                        }
                        catch (Throwable t) {
                            if (defaultServerObjectConfig == null) throw t;
                            log.warn("Failed to create serverObject using operation level config. Will try to use DataSource level config instead. Actual error: " + t.getMessage());
                            serverObject = new ServerObject(defaultServerObjectConfig, this.context, "Default serverObject for DataSource " + ds.getName());
                        }
                    }
                    catch (Throwable t) {
                        Exception exception;
                        if (t instanceof Exception) {
                            exception = (Exception)t;
                            throw exception;
                        }
                        exception = new Exception(t);
                        throw exception;
                    }
                    explicitMethodName = null;
                    if (!opLevelServerObject) break block46;
                    explicitMethodName = (String)serverObjectConfig.get("methodName");
                    if (explicitMethodName != null) {
                        if (operationBinding.get("serverMethod") != null) {
                            log.warn("DataSource " + ds.getName() + ", operationId " + operationId + ": " + "Found a 'methodName' (" + explicitMethodName + ") on the " + "serverObject AND a 'serverMethod' (" + operationBinding.get("serverMethod") + ") on the operationBinding. " + "serverObject.methodName takes precedence: calling " + explicitMethodName);
                        }
                        break block47;
                    } else {
                        explicitMethodName = (String)operationBinding.get("serverMethod");
                    }
                    break block47;
                }
                explicitMethodName = (String)operationBinding.get("serverMethod");
                if (explicitMethodName == null && serverObjectConfig != null) {
                    explicitMethodName = (String)serverObjectConfig.get("methodName");
                }
            }
            if ((methodName = explicitMethodName) == null) {
                String opId = (String)operationBinding.get("operationId");
                methodName = opId != null && opId.indexOf("methodName_") == 0 ? opId.substring("methodName_".length()) : operationType;
            }
            Class serverObjectClass = serverObject._getClass();
            Method method = serverObject.getMethod(methodName);
            if (method == null) {
                if (explicitMethodName != null) throw new Exception("DataSourceDMI: operationBinding specifies methodName=\"" + explicitMethodName + "\", but no such public method is available on class: " + serverObjectClass.getName());
                log.debug("DataSourceDMI: no public method name: " + methodName + " available on class: " + serverObjectClass.getName() + " - defaulting to builtin operations.");
                return null;
            }
            Object serverObjectInstance = serverObject.getInstance(method);
            String methodArguments = (String)operationBinding.get("methodArguments");
            ReflectionArgument[] requiredArgs = null;
            ReflectionArgument[] optionalArgs = null;
            Map criteriaOrValues = this.dsRequest.getValues() == null ? this.dsRequest.getCriteria() : this.dsRequest.getValues();
            Connection sqlConnection = null;
            boolean connectionIsTransactional = true;
            if (methodArguments == null) {
                HttpSession session = null;
                if (Reflection.methodTakesArgType(method, HttpSession.class) && this.context != null) {
                    session = this.context.request.getSession(true);
                }
                if (Reflection.methodTakesArgType(method, Connection.class) && ds instanceof ISQLDataSource && (sqlConnection = ((ISQLDataSource)((Object)ds)).getTransactionalConnection(this.dsRequest)) == null) {
                    connectionIsTransactional = false;
                    sqlConnection = ((ISQLDataSource)((Object)ds)).getConnection();
                }
                optionalArgs = this.context != null ? new ReflectionArgument[]{new ReflectionArgument(RequestContext.class, this.context, false, false), new ReflectionArgument(HttpServletRequest.class, (Object)this.context.request, false, false), new ReflectionArgument(HttpServletResponse.class, this.context.response, false, false), new ReflectionArgument(ServletContext.class, this.context.servletContext, false, false), new ReflectionArgument(HttpSession.class, session, false, false), new ReflectionArgument(RPCManager.class, this.rpc, false, false), new ReflectionArgument(DSRequest.class, this.dsRequest, false, false), new ReflectionArgument(DataSource.class, ds, false, false), new ReflectionArgument(Connection.class, sqlConnection, false, false), new ReflectionArgument(Logger.class, log, false, false), new ReflectionArgument(Map.class, criteriaOrValues, true, true)} : new ReflectionArgument[]{new ReflectionArgument(RequestContext.class, null, false, false), new ReflectionArgument(HttpServletRequest.class, null, false, false), new ReflectionArgument(HttpServletResponse.class, null, false, false), new ReflectionArgument(ServletContext.class, null, false, false), new ReflectionArgument(HttpSession.class, null, false, false), new ReflectionArgument(RPCManager.class, this.rpc, false, false), new ReflectionArgument(DSRequest.class, this.dsRequest, false, false), new ReflectionArgument(DataSource.class, ds, false, false), new ReflectionArgument(Connection.class, sqlConnection, false, false), new ReflectionArgument(Logger.class, log, false, false), new ReflectionArgument(Map.class, criteriaOrValues, true, true)};
            } else {
                List methodArgList = DataTools.simpleSplit(methodArguments, ",");
                requiredArgs = new ReflectionArgument[methodArgList.size()];
                VelocityEngine vEngine = Velocity.getEngine();
                VelocityContext vContext = new VelocityContext(Velocity.getStandardContextMap(this.dsRequest));
                vContext.put("dataSource", (Object)this.dsRequest.getDataSource());
                vContext.put("rpcManager", (Object)this.dsRequest.getRPCManager());
                if (this.context != null) {
                    vContext.put("context", (Object)this.context);
                    vContext.put("request", (Object)this.context.request);
                    vContext.put("response", (Object)this.context.response);
                    vContext.put("servletContext", (Object)this.context.servletContext);
                }
                if (this.rpc != null) {
                    vContext.put("rpc", (Object)this.rpc);
                    vContext.put("rpcManager", (Object)this.rpc);
                }
                vContext.put("ds", (Object)ds);
                vContext.put("dataSource", (Object)ds);
                vContext.put("criteriaOrValues", (Object)criteriaOrValues);
                StringWriter out = new StringWriter();
                for (int i = 0; i < requiredArgs.length; ++i) {
                    String methodArg = (String)methodArgList.get(i);
                    vEngine.evaluate((Context)vContext, (Writer)out, "DataSourceDMI", "#set($iscResult = " + methodArg + ")\n");
                    Object value = vContext.get("iscResult");
                    log.debug("assigning: " + methodArg + " type: " + (value == null ? "null" : value.getClass().getName()));
                    requiredArgs[i] = new ReflectionArgument(value != null ? value.getClass() : null, value);
                }
            }
            this.dsRequest.setRequestStarted(true);
            try {
                returnValue = Reflection.adaptArgsAndInvoke(serverObjectInstance, method, requiredArgs, optionalArgs, ds, this.dsRequest);
            }
            catch (InvocationTargetException e) {
                Throwable t = Reflection.getRealTargetException(e);
                log.debug((Object)"Invocation threw exception", t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                log.error((Object)"Invocation threw exception", t);
                Exception x = new Exception("RPCDMI invocation threw a: " + t.getClass().getName() + " with error: " + t.getMessage());
                throw x;
            }
            finally {
                if (sqlConnection != null && !connectionIsTransactional) {
                    ((ISQLDataSource)((Object)ds)).freeConnection(sqlConnection);
                }
            }
            returnValueClass = returnValue == null ? null : returnValue.getClass();
        }
        DSResponse dsResponse = null;
        if (returnValueClass != null && DSResponse.class.isAssignableFrom(returnValueClass)) {
            dsResponse = (DSResponse)returnValue;
        } else {
            dsResponse = new DSResponse(ds);
            dsResponse.setData(returnValue);
            dsResponse.setStatus(DSResponse.STATUS_SUCCESS);
        }
        if (dsResponse == null) return dsResponse;
        if (dsResponse.getDropExtraFields() != null) return dsResponse;
        dsResponse.setDropExtraFields(new Boolean(dropExtraFields));
        return dsResponse;
    }

    /*
     * Unable to fully structure code
     */
    public Map validateOperationBinding() throws Exception {
        block30: {
            block31: {
                dsName = this.dsRequest.getDataSourceName();
                if (dsName == null) {
                    return null;
                }
                ds = this.dsRequest.getDataSource();
                if (ds == null) {
                    return null;
                }
                operationType = this.dsRequest.getOperationType();
                operationId = this.dsRequest.getOperationId();
                if (operationId == null) {
                    operationId = ds.getAutoOperationId(operationType);
                }
                operationIdIsAuto = operationId != null && operationId.equals(ds.getAutoOperationId(operationType)) != false;
                operationBindingString = "operationBinding for DataSource: " + ds.getName() + " with operationType: " + operationType + (operationIdIsAuto != false || operationId == null ? "" : ", operationId: ") + operationId;
                operationBinding = ds.getOperationBinding(operationType, operationId);
                v0 = haveExplicitBinding = operationBinding != null;
                if (ds.getConfig().get("script") == null) ** GOTO lbl-1000
                if (DataSource.isCrud(operationType)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = haveScriptCrudOperationBinding = false;
                }
                if (!haveExplicitBinding && !operationIdIsAuto) {
                    DataSourceDMI.log.warn("DataSource " + ds.getName() + ": received a request to execute an " + "operation of type '" + operationType + "' named '" + operationId + "', but this operation is not defined to the dataSource.  Falling " + "back to default behavior for operationType '" + operationType + "'");
                }
                defaultServerObjectConfig = ds.getServerObjectConfig();
                if (!haveExplicitBinding && defaultServerObjectConfig == null && !haveScriptCrudOperationBinding) {
                    return null;
                }
                if (!haveExplicitBinding && defaultServerObjectConfig != null && defaultServerObjectConfig.get("methodName") != null) {
                    operationBinding = DataTools.buildMap("operationType", operationType);
                    operationBinding.put("operationId", "methodName_" + defaultServerObjectConfig.get("methodName"));
                }
                if (!haveExplicitBinding) {
                    if (this.explicitBindingNotRequired(operationType)) {
                        operationBinding = DataTools.buildMap("operationType", operationType);
                        if (operationId != null) {
                            operationBinding.put("operationId", operationId);
                        }
                    } else {
                        throw new Exception("Attempt to call unknown operationType: " + operationType);
                    }
                }
                serverObjectConfig = (Map)operationBinding.get("serverObject");
                opLevelServerObject = false;
                if (serverObjectConfig == null) {
                    serverObjectConfig = defaultServerObjectConfig;
                } else {
                    opLevelServerObject = true;
                }
                if (operationBinding.get("script") != null) break block30;
                if (ds.getConfig().get("script") == null) break block31;
                if (DataSource.isCrud(operationType)) break block30;
            }
            if (haveExplicitBinding && serverObjectConfig == null) {
                allow = false;
                props = DataSourceDMI.config.getList("operationBinding.properties.modifying.builtin");
                for (String prop : props) {
                    if (!operationBinding.containsKey(prop)) continue;
                    allow = true;
                    break;
                }
                if ("custom".equals(operationType) || "clientExport".equals(operationType)) {
                    allow = true;
                }
                if (ds.getConfig().get("serverConstructor") != null) {
                    allow = true;
                }
                if (allow) {
                    if ("sql".equals(ds.getType())) {
                        // empty if block
                    }
                    return null;
                }
            }
            if (serverObjectConfig == null) {
                if (this.dsRequest.isGroupBy()) {
                    return null;
                }
                DataSourceDMI.log.warn(operationBindingString + " does not have a <serverObject> in force and does not specify any " + "operationBinding settings that could affect its behavior. This " + "operation will almost certainly give the same result as a default " + "operation, and so is almost certainly unnecessary");
                return null;
            }
            if (!opLevelServerObject && operationBinding.get("serverMethod") == null) {
                crudOnlyObj = serverObjectConfig.get("crudOnly");
                crudOnly = true;
                if (crudOnlyObj != null && crudOnlyObj.toString().equals("false")) {
                    crudOnly = false;
                }
                if (crudOnly) {
                    if (!DataSource.isCrud(operationType)) {
                        return null;
                    }
                }
            }
        }
        return ds.validateOperationBinding(this.dsRequest, operationBinding);
    }

    protected VelocityEngine getVelocityEngine() throws Exception {
        VelocityEngine vEngine = new VelocityEngine();
        Properties properties = new Properties();
        properties.put("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        properties.put("runtime.log.logsystem.log4j.category", "org.apache.Velocity");
        vEngine.init(properties);
        return vEngine;
    }

    protected boolean explicitBindingNotRequired(String operationType) {
        return this.operationTypesNotRequiringExplicitBindings.contains(operationType);
    }

    public int getScriptSourceOffset(Map scriptSourceContext) throws Exception {
        String source = null;
        DataSource ds = this.dsRequest.getDataSource();
        try {
            String dsConfigFile = ds.getConfigFilename();
            if (dsConfigFile != null) {
                source = new ISCFile(dsConfigFile).getAsString();
            }
        }
        catch (Exception dsConfigFile) {
            // empty catch block
        }
        if (source == null) {
            throw new Exception("DataSource " + ds.getName() + " does not have source - unable to obtain line offset for script code");
        }
        String script = (String)scriptSourceContext.get("script");
        String operationType = this.dsRequest.getOperationType();
        String operationId = this.dsRequest.getOperationId();
        int operationTypeIndex = source.indexOf(operationType);
        if (operationTypeIndex == -1) {
            return -1;
        }
        int operationIdIndex = source.indexOf(operationId);
        int maxIndex = Math.max(operationIdIndex, operationTypeIndex);
        int scriptIndex = source.indexOf(script, maxIndex);
        if (scriptIndex == -1 && (scriptIndex = source.indexOf(script.replace("\n", "\r\n"), maxIndex)) == -1) {
            return -1;
        }
        return DataTools.countCompleteLines(source.substring(0, scriptIndex));
    }

    public String getScriptSourceName(Map scriptSourceContext) throws Exception {
        DataSource ds = this.dsRequest.getDataSource();
        return "DataSource " + ds.getName() + ": " + this.dsRequest.getOperationType() + "/" + this.dsRequest.getOperationId();
    }

    public String getScriptSourceFilename(Map scriptSourceContext) throws Exception {
        DataSource ds = this.dsRequest.getDataSource();
        return ds.getConfigFilename();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalInlineScript(Map operationBinding) throws Exception {
        Map map;
        Object returnValue = null;
        DataSource ds = this.dsRequest.getDataSource();
        Object scriptObject = operationBinding.get("script");
        String script = null;
        String scriptLanguage = null;
        String scriptArgs = null;
        Object imports = null;
        if (scriptObject != null) {
            imports = operationBinding.get("scriptImport");
            if (scriptObject instanceof String) {
                script = (String)scriptObject;
                scriptLanguage = (String)operationBinding.get("language");
                scriptArgs = (String)operationBinding.get("args");
            } else {
                map = (Map)scriptObject;
                script = (String)map.get("#text");
                scriptLanguage = (String)map.get("language");
                if (scriptLanguage == null) {
                    scriptLanguage = (String)operationBinding.get("language");
                }
                if ((scriptArgs = (String)map.get("args")) == null) {
                    scriptArgs = (String)operationBinding.get("args");
                }
            }
        } else {
            imports = ds.getConfig().get("scriptImport");
            scriptObject = ds.getConfig().get("script");
            if (scriptObject instanceof String) {
                script = (String)scriptObject;
            } else {
                map = (Map)scriptObject;
                script = (String)map.get("#text");
                scriptLanguage = (String)map.get("language");
                scriptArgs = (String)map.get("args");
            }
        }
        if (scriptLanguage == null) {
            scriptLanguage = (String)Config.getProperty("script.defaultLanguage");
        }
        boolean supportsFullJavaReflection = config.getBoolean((Object)("scripting." + scriptLanguage.toLowerCase() + ".supportsFullJavaReflection"), true);
        Map criteriaOrValues = this.dsRequest.getValues() == null ? this.dsRequest.getCriteria() : this.dsRequest.getValues();
        HashMap<String, String> bindingsClassName = new HashMap<String, String>();
        bindingsClassName.put("requestContext", RequestContext.class.getName());
        bindingsClassName.put("request", ISCHttpServletRequest.class.getName());
        bindingsClassName.put("response", HttpServletResponse.class.getName());
        bindingsClassName.put("session", HttpSession.class.getName());
        bindingsClassName.put("servletContext", ServletContext.class.getName());
        bindingsClassName.put("beanFactory", Object.class.getName());
        bindingsClassName.put("applicationContext", Object.class.getName());
        bindingsClassName.put("rpc", RPCManager.class.getName());
        bindingsClassName.put("ds", DataSource.class.getName());
        bindingsClassName.put("dataSource", DataSource.class.getName());
        bindingsClassName.put("dsRequest", DSRequest.class.getName());
        bindingsClassName.put("criteria", Map.class.getName());
        bindingsClassName.put("values", Map.class.getName());
        bindingsClassName.put("oldValues", Map.class.getName());
        bindingsClassName.put("criteriaOrValues", Map.class.getName());
        bindingsClassName.put("log", Logger.class.getName());
        bindingsClassName.put("sqlConnection", Connection.class.getName());
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        if (supportsFullJavaReflection) {
            if (this.context != null) {
                bindings.put("requestContext", this.context);
                bindings.put("request", (Object)this.context.request);
                bindings.put("response", this.context.response);
                if (this.context.request != null) {
                    bindings.put("session", this.context.request.getSession(false));
                }
                bindings.put("servletContext", this.context.servletContext);
                try {
                    ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                    if (beanFactory != null) {
                        bindings.put("beanFactory", beanFactory.getBeanFactory(this.context.servletContext));
                        bindings.put("applicationContext", beanFactory.getBeanFactory(this.context.servletContext));
                    }
                }
                catch (Throwable beanFactory) {
                    // empty catch block
                }
            }
            if (this.rpc != null) {
                bindings.put("rpc", this.rpc);
                bindings.put("rpcManager", this.rpc);
            }
            bindings.put("ds", ds);
            bindings.put("dataSource", ds);
            bindings.put("dsRequest", this.dsRequest);
            bindings.put("log", log);
        }
        bindings.put("criteria", this.dsRequest.getCriteria());
        bindings.put("values", this.dsRequest.getValues());
        bindings.put("oldValues", this.dsRequest.getOldValues());
        bindings.put("criteriaOrValues", criteriaOrValues);
        DataTypeMap params = new DataTypeMap();
        params.put("engineName", scriptLanguage);
        params.put("script", script);
        params.put("bindings", bindings);
        params.put("bindingsClassName", bindingsClassName);
        params.put("imports", imports);
        HashMap<String, String> scriptSourceContext = new HashMap<String, String>();
        scriptSourceContext.put("operationType", this.dsRequest.getOperationType());
        scriptSourceContext.put("operationId", this.dsRequest.getOperationId());
        params.put("scriptSource", this);
        params.put("scriptSourceContext", scriptSourceContext);
        Connection sqlConnection = null;
        boolean connectionIsTransactional = true;
        if (ds instanceof ISQLDataSource) {
            sqlConnection = ((ISQLDataSource)((Object)ds)).getTransactionalConnection(this.dsRequest);
            if (sqlConnection == null) {
                connectionIsTransactional = false;
                sqlConnection = ((ISQLDataSource)((Object)ds)).getConnection();
            }
            bindings.put("sqlConnection", sqlConnection);
        }
        try {
            RPCResponse rpcResponse = BuiltinRPC.evalServerScript(params);
            Map result = (Map)rpcResponse.getData();
            returnValue = result.get("evalResult");
        }
        finally {
            if (!connectionIsTransactional) {
                ((ISQLDataSource)((Object)ds)).freeConnection(sqlConnection);
            }
            this.dsRequest.registerFreeResourcesHandler(this);
        }
        return returnValue;
    }

    public void freeResources(DSRequest req) {
        log.debug("Freeing resources in DataSourceDMI...");
        try {
            String sqlTrx;
            if (req != null && req.getRPCManager() != null && !req.getFreeOnExecute() && Reflection.invokeStaticMethod(sqlTrx = "com.isomorphic.sql.SQLTransaction", "getConnection", req.getRPCManager()) != null) {
                Reflection.invokeStaticMethod(sqlTrx, "endTransaction", req.getRPCManager());
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception while ending transaction connection form DataSourceDMI", e);
        }
    }

    public void freeQueueResources(DSRequest req) {
        DataSourceManager.free(req.ds);
    }
}

