/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.amazonaws.services.ec2.model.Instance;
import com.isomorphic.autotest.AwsHelper;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AwsInstancesDao {
    private static final int NUMBER_OF_VPN_KEYS = 5;
    private static Logger log = new Logger(AwsInstancesDao.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";

    public static void registerKeyOrdinalWithInstance(int keyOrdinal, String instanceId, Date batchStartTime) {
        String logMessage = "instance " + instanceId + " with VPN key ordinal " + keyOrdinal;
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "add");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("vpnKeyOrdinal", keyOrdinal);
            dataMap.put("instanceId", instanceId);
            dataMap.put("batchStartTime", batchStartTime);
            dsReq.setValues(dataMap);
            dsReq.execute();
            log.info((Object)("registered " + logMessage));
        }
        catch (Exception e) {
            log.info((Object)("failed to register " + logMessage), (Throwable)e);
        }
    }

    public static int getKeyOrdinal(List<Instance> liveInstances) {
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            List data = dsReq.execute().getDataList();
            HashSet<Integer> results = new HashSet<Integer>();
            ArrayList<Date> deletedRows = new ArrayList<Date>();
            for (Object object : data) {
                Map row = (Map)object;
                int vpnKeyOrdinal = (Integer)row.get("vpnKeyOrdinal");
                Date batchStartTime = (Date)row.get("batchStartTime");
                String instanceId = (String)row.get("instanceId");
                boolean isKeyUsed = false;
                for (Instance liveInstance : liveInstances) {
                    String liveInstanceId = liveInstance.getInstanceId();
                    if (!liveInstanceId.equals(instanceId)) continue;
                    results.add(vpnKeyOrdinal);
                    isKeyUsed = true;
                }
                if (isKeyUsed) continue;
                deletedRows.add(batchStartTime);
                dsReq = new DSRequest("awsInstances", "remove");
                dsReq.setCriteria("vpnKeyOrdinal", (Object)vpnKeyOrdinal);
                dsReq.execute();
            }
            log.info((Object)("beginning failsafe check of " + deletedRows.size() + " deleted AWS Instance rows"));
            Collections.sort(deletedRows);
            Iterator i$ = deletedRows.iterator();
            while (i$.hasNext()) {
                Date row;
                Date batchStartTime = row = (Date)i$.next();
                String branch = BatchRunDao.getBranch(batchStartTime);
                log.info((Object)("checking batch " + batchStartTime));
                if (AwsInstancesDao.areAnyOlderBatchesAliveForBranch(batchStartTime, branch)) continue;
                log.info((Object)("there are no batches older than " + batchStartTime + " so calling validate"));
                TestRunner.validateCommitRecord(batchStartTime, branch);
                Date successorBatchTime = BatchRunDao.getSuccessorBatchStartTime(batchStartTime, branch);
                while (successorBatchTime != null && AwsInstancesDao.getAwsInstanceId(successorBatchTime) == null && BatchRunDao.getAwsInstanceId(successorBatchTime) != null) {
                    log.info((Object)("calling forward validate for batch " + successorBatchTime));
                    TestRunner.validateCommitRecord(successorBatchTime, branch);
                    successorBatchTime = BatchRunDao.getSuccessorBatchStartTime(successorBatchTime, branch);
                }
            }
            log.info((Object)"completed failsafe check of deleted AWS Instance rows");
            for (int i = 1; i <= 5; ++i) {
                if (results.contains(i)) continue;
                return i;
            }
        }
        catch (Exception e) {
            log.error((Object)"exception thrown while searching for a valid VPN key ordinal", (Throwable)e);
        }
        return 0;
    }

    public static List<AwsHelper.ZombieProperties> getZombieInstances() {
        TestRunnerConfiguration config = TestRunner.getConfiguration();
        ArrayList<AwsHelper.ZombieProperties> zombies = new ArrayList<AwsHelper.ZombieProperties>();
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            List data = dsReq.execute().getDataList();
            for (Object object : data) {
                Map row = (Map)object;
                Date batchStartTime = (Date)row.get("batchStartTime");
                String instanceId = (String)row.get("instanceId");
                long lifespan = new Date().getTime() - batchStartTime.getTime();
                if (lifespan <= (long)config.getAwsMaximumLifespan()) continue;
                AwsHelper.ZombieProperties properties = new AwsHelper.ZombieProperties();
                properties.instanceId = instanceId;
                properties.batchStartTime = batchStartTime;
                properties.lifespanMinutes = lifespan / 60000L;
                zombies.add(properties);
            }
        }
        catch (Exception e) {
            log.error((Object)"exception thrown while searching for zombie AWS servers", (Throwable)e);
        }
        return zombies;
    }

    public static String getAwsInstanceId(Date batchStartTime) {
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            if (data.size() != 1) {
                return null;
            }
            Map row = (Map)data.get(0);
            return (String)row.get("instanceId");
        }
        catch (Exception e) {
            log.error((Object)("encountered exception finding AWS instance for batch " + batchStartTime + ":"), (Throwable)e);
            return null;
        }
    }

    public static boolean areAnyOlderBatchesAliveForBranch(Date batchStartTime, String branch) {
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            List data = dsReq.execute().getDataList();
            for (Object object : data) {
                Map row = (Map)object;
                Date rowBatchTime = (Date)row.get("batchStartTime");
                if (!branch.equals(BatchRunDao.getBranch(rowBatchTime)) || rowBatchTime.getTime() >= batchStartTime.getTime()) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("encounered exception finding AWS instance for batch " + batchStartTime + ":"), (Throwable)e);
        }
        return false;
    }
}

