/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestResultDao
extends ConfiguredBase {
    private static Logger log = new Logger(TestResultDao.class.getName());

    public static void add(TestResult tr) {
        DSRequest dsReq = new DSRequest(config.getTestResultDS(), "add");
        HashMap<String, Object> rows = new HashMap<String, Object>();
        rows.put("testFile", tr.getTestFile());
        rows.put("batchStartTime", tr.getBatchStartTime());
        rows.put("startTime", tr.getStartTime());
        rows.put("endTime", tr.getEndTime());
        rows.put("description", tr.getDescription());
        rows.put("result", tr.getResult());
        rows.put("branch", tr.getBranch());
        if (!"success".equalsIgnoreCase(tr.getResult())) {
            rows.put("details", tr.getDetails());
            rows.put("messages", tr.getMessages());
        }
        if (config.canParseLog()) {
            rows.put("testNumber", tr.getTestNumber());
            rows.put("showcase", tr.getShowcase());
        }
        try {
            File imageFile;
            FileInputStream stream = null;
            File file = imageFile = tr.getImageFile() != null ? new File(tr.getImageFile()) : null;
            if (imageFile != null) {
                stream = new FileInputStream(imageFile);
                tr.setImageFile(tr.getTestFile().replaceAll("\\.rctest.html$", ".png"));
                rows.put("capture_filename", tr.getImageFile());
                rows.put("capture_filesize", tr.getImageSize());
                rows.put("capture", stream);
            }
            dsReq.setValues(rows);
            dsReq.forceInvalidateCache(true);
            dsReq.execute();
            if (imageFile != null) {
                ((InputStream)stream).close();
                imageFile.delete();
            }
        }
        catch (Exception e) {
            log.error((Object)("encountered exception trying to add test result for test " + tr.getTestFile() + " #" + tr.getTestNumber() + ": "), (Throwable)e);
        }
    }

    public static List<Date> getLastBatchesTime(String showcase, String branch) throws Exception {
        DSRequest dsReq = new DSRequest(config.getTestResultDS(), "fetch");
        dsReq.setOperationId("batchTimes");
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("branch", branch);
        if (config.canParseLog()) {
            criteria.put("showcase", showcase);
        }
        dsReq.setCriteria(criteria);
        DSResponse dsResp = dsReq.execute();
        List data = dsResp.getDataList();
        ArrayList<Date> result = new ArrayList<Date>();
        for (Object dateRow : data) {
            Map row = (Map)dateRow;
            Date d = (Date)row.get("batchStartTime");
            result.add(d);
        }
        Collections.sort(result, (Comparator)Collections.reverseOrder());
        return result;
    }

    public static List<TestResult> getTestsForBatch(Date date, String showcase, String branch) throws Exception {
        DSRequest dsReq = new DSRequest(config.getTestResultDS(), "fetch");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("batchStartTime", date);
        criteria.put("branch", branch);
        if (config.canParseLog()) {
            criteria.put("showcase", showcase);
        }
        dsReq.setCriteria(criteria);
        List data = dsReq.execute().getDataList();
        ArrayList<TestResult> result = new ArrayList<TestResult>();
        for (Object record : data) {
            result.add(new TestResult((Map)record));
        }
        return result;
    }
}

