/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.DriverConfiguration;
import com.isomorphic.autotest.InconsistentBatchRunTableException;
import com.isomorphic.autotest.SgwtRunnerHelper;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerDriver;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestShowcaseHelper;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.base.ISCInit;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.MailMessage;
import com.isomorphic.mail.TemplatedMailMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.mail.Message;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;

public class TestRunner
extends ConfiguredBase {
    private static final int COMMIT_SEARCH_DEPTH = 20;
    private static Logger log = new Logger(TestRunner.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private static int totalTests = 0;
    private static int passedTests = 0;
    private static int totalTestFiles = 0;
    private static int passedTestFiles = 0;
    private static List<TestResult> regressions = new ArrayList<TestResult>();
    private static List<TestResult> fixed = new ArrayList<TestResult>();
    private static ArrayList<TestResult> localResults = null;

    public static void main(String[] args) throws Exception {
        ISCInit.go((String)TestRunner.class.getName());
        PosixParser parser = new PosixParser();
        Options options = new Options();
        TestRunnerLauncher.addOptions(options);
        String details = "Sets the OPT for this batch run; it will be included in any commit to the BatchRun DS and in any email notification";
        options.addOption("un", "user-name", true, details.replaceFirst("OPT", "user name"));
        options.addOption("lg", "batch-log", true, details.replaceFirst("OPT", "log message"));
        options.addOption("re", "repeat-email", true, "Recipient(s) to email if no fixes or regressions have occurred in batch");
        options.addOption("ms", "mail-subject", true, "Subject line to use for email");
        options.addOption("se", "sender-email", true, "Sender email address to set for all batch reports");
        options = TestRunnerLauncher.filterAndAddOptions(options, DriverConfiguration.class);
        options.addOption("lp", "piped-log", false, "Signals that a log message will be piped to stdin of the TestRunner process. Message itself used identically to that of -lg option");
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (MissingOptionException moe) {
            Utils.outputHelp("[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.", options, moe.getMessage());
            return;
        }
        if (line.hasOption("h")) {
            Utils.outputHelp("[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.", options);
            System.exit(0);
        }
        TestRunnerLauncher.launch(null, line, "[OPT1] [ARG1] [OPT2] [ARG2] ... [PATTERN1] [PATTERN2] ...\nRuns the Java TestRunner Framework using the options provided. If any extra arguments are supplied on the command line without associated options, they are interpreted as regex patterns to match against any test scripts underneath the test script root directory.", options, TestRunnerDriver.class);
    }

    protected static void testAll(final Date batchStartTime, String browser, boolean storeToDb, boolean noSelenium, boolean noUsualTests, boolean batch, String showcase, String branch, String[] scripts) {
        TestRunnerHelper.TestCallback callback = new TestRunnerHelper.TestCallback(){

            @Override
            public void onTestResults(TestCaseResults testCaseResults) {
                if (testCaseResults.isTimeoutError()) {
                    int timeout = testCaseResults.getTimeoutInSeconds();
                    log.error((Object)(testCaseResults.getTestName() + ": test failed due to timeout"));
                    if (localResults != null) {
                        TestResult timeoutResult = new TestResult();
                        timeoutResult.setBatchStartTime(batchStartTime);
                        timeoutResult.setResult("timeout");
                        String details = "TestCase results have not appeared after " + timeout + " seconds" + testCaseResults.getPartialReport();
                        timeoutResult.setDetails(details);
                        timeoutResult.setStartTime(testCaseResults.getStartTime());
                        timeoutResult.setEndTime(testCaseResults.getEndTime());
                        timeoutResult.setTestNumber(1);
                        timeoutResult.setTestFile(testCaseResults.getTestName());
                        localResults.add(timeoutResult);
                    }
                } else if (testCaseResults.getUnparsableResponse() != null) {
                    log.error((Object)(testCaseResults.getTestName() + ": test response incorrect:\n" + testCaseResults.getUnparsableResponse()));
                    if (localResults != null) {
                        TestResult unparseableResult = new TestResult();
                        unparseableResult.setBatchStartTime(batchStartTime);
                        unparseableResult.setResult("failure");
                        unparseableResult.setDetails("TestCase results contains unparseable data.");
                        unparseableResult.setStartTime(testCaseResults.getStartTime());
                        unparseableResult.setEndTime(testCaseResults.getEndTime());
                        localResults.add(unparseableResult);
                    }
                } else if (testCaseResults.getSeleniumError() != null) {
                    log.error((Object)(testCaseResults.getTestName() + ": Selenium exception reported:\n" + testCaseResults.getSeleniumError()));
                    if (localResults != null) {
                        TestResult errorResult = new TestResult();
                        errorResult.setBatchStartTime(batchStartTime);
                        errorResult.setResult("failure");
                        errorResult.setDetails("Selenium error:\n" + testCaseResults.getSeleniumError());
                        errorResult.setStartTime(testCaseResults.getStartTime());
                        errorResult.setEndTime(testCaseResults.getEndTime());
                        errorResult.setTestNumber(1);
                        errorResult.setTestFile(testCaseResults.getTestName());
                        localResults.add(errorResult);
                    }
                } else {
                    log.info((Object)("results for " + testCaseResults.getTestName() + ":"));
                    for (TestResult tr : testCaseResults.getTestResults()) {
                        if ("success".equals(tr.getResult())) {
                            log.info((Object)("success:" + tr.getDetails()));
                        } else {
                            log.error((Object)("error:" + tr.getDetails()));
                        }
                        if (localResults == null) continue;
                        tr.setBatchStartTime(batchStartTime);
                        localResults.add(tr);
                    }
                }
            }
        };
        if (showcase == null) {
            TestRunnerHelper.testAll(browser, !noSelenium, !noUsualTests, scripts, batch, callback);
        } else {
            ShowcaseSpecifier specifier = new ShowcaseSpecifier(showcase);
            if (specifier.isSmartGWTRunner()) {
                SgwtRunnerHelper.testAll(browser, scripts, specifier, callback);
            } else {
                TestShowcaseHelper.testAll(browser, !noSelenium, !noUsualTests, scripts, specifier, callback);
            }
        }
        if (storeToDb) {
            try {
                for (TestResult tr : localResults) {
                    tr.setShowcase(showcase);
                    tr.setBranch(branch);
                    TestResultDao.add(new TestResult(tr, true));
                }
            }
            catch (Exception e) {
                log.error((Object)"unable to persist test results", (Throwable)e);
            }
        }
    }

    protected static void testUrl(Date batchStartTime, String url, String browser, boolean storeToDb) {
        log.info((Object)("testing " + url));
        TestCaseResults results = TestRunnerHelper.test(url, browser);
        if (results.isTimeoutError()) {
            log.error((Object)"test failed due timeout");
        } else {
            for (TestResult tr : results.getTestResults()) {
                if ("success".equals(tr.getResult())) {
                    log.info((Object)("success:" + tr.getDetails()));
                } else {
                    log.error((Object)("error:" + tr.getDetails()));
                }
                if (!storeToDb && localResults == null) continue;
                try {
                    tr.setBatchStartTime(batchStartTime);
                    if (storeToDb) {
                        TestResultDao.add(tr);
                        continue;
                    }
                    localResults.add(tr);
                }
                catch (Exception e) {
                    log.error((Object)"unable to persist test results", (Throwable)e);
                }
            }
        }
    }

    protected static void createBatchRunRecord(Date batchStartTime, String batchLog, String user, String branch, boolean parseLog) throws Exception {
        BatchRunDao.add(batchStartTime, user, branch, parseLog ? Utils.getModifiedFilesFromCommitSpam(batchLog) : "", batchLog);
    }

    protected static void completeBatchRunRecord(Date batchStartTime) throws Exception {
        BatchRunDao.setBatchEndTime(batchStartTime, new Date());
    }

    protected static void sendLocalDifferencesEmail(String alertEmail, String repeatEmail, String ccEmail, String timestamp, String showcase, String branch) throws Exception {
        boolean important;
        List<BatchResults> lastBatches = TestRunner.lastBatchesForTimestamp(timestamp, showcase, branch, 1);
        boolean firstBatchFound = lastBatches.size() > 0;
        List<Object> firstBatch = firstBatchFound ? lastBatches.get(0).getResults() : new ArrayList();
        TestRunner.compareBatches(localResults, firstBatch);
        TemplatedMailMessage msg = new TemplatedMailMessage();
        boolean bl = important = fixed.size() > 0 || regressions.size() > 0;
        if (!TestRunner.addEmailRecipients(msg, alertEmail, repeatEmail, ccEmail, important)) {
            return;
        }
        TestRunner.setEmailSubjectAndFromField((MailMessage)msg, "Local", showcase, firstBatchFound, null, null, null, null);
        msg.addHeader("Content-Type", "text/html");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("fixed", fixed);
        dataMap.put("regression", regressions);
        if (TestRunner.hasMultipleTestsPerFile(showcase)) {
            dataMap.put("totalTests", totalTests);
            dataMap.put("passedTests", passedTests);
        }
        dataMap.put("totalTestFiles", totalTestFiles);
        dataMap.put("passedTestFiles", passedTestFiles);
        dataMap.put("firstBatchFound", firstBatchFound);
        msg.setContextMap(dataMap);
        String mailTemplate = config.getMailTemplate();
        msg.setTemplateFile(mailTemplate);
        msg.buildMessage(dataMap, mailTemplate);
        try {
            msg.send();
        }
        catch (Exception e) {
            log.warn((Object)e);
            e.printStackTrace();
        }
    }

    private static void sendDifferencesEmailInternal(String alertEmail, String repeatEmail, String ccEmail, List<BatchResults> batchesToCompare, String user, String batchLog, String cvsDate, String showcase, String branch, String newState) throws Exception {
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        log.info((Object)("email targets: " + alertEmail + ", " + repeatEmail + ", " + ccEmail));
        if (batchesToCompare.size() > 1) {
            boolean important;
            BatchResults newBatch = batchesToCompare.get(0);
            BatchResults oldBatch = batchesToCompare.get(1);
            TestRunner.compareBatches(newBatch.getResults(), oldBatch.getResults());
            int nHistoricalResults = config.getHistoryDepth();
            if ((regressions.size() > 0 || fixed.size() > 0) && nHistoricalResults > 0) {
                TestRunner.addHistoryForChanges(oldBatch.getBatchStartTime(), showcase, branch, nHistoricalResults);
            }
            TemplatedMailMessage msg = new TemplatedMailMessage();
            boolean bl = important = fixed.size() > 0 || regressions.size() > 0;
            if (!TestRunner.addEmailRecipients(msg, alertEmail, repeatEmail, ccEmail, important)) {
                return;
            }
            Date newBatchStartTime = newBatch.getBatchStartTime();
            TestRunner.setEmailSubjectAndFromField((MailMessage)msg, "Auto", showcase, true, user, newBatchStartTime, launcher.extractCommitMessage(batchLog), branch);
            msg.addHeader("Content-Type", "text/html");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("fixed", fixed);
            dataMap.put("regression", regressions);
            if (important && "R!".equalsIgnoreCase(newState)) {
                dataMap.put("bestEffortDiff", true);
            }
            if (config.canParseLog()) {
                if (Utils.isCvsSpam(batchLog)) {
                    int bodyIndex = batchLog.indexOf("<body>") + "<body>".length();
                    String cvsSpamHeader = batchLog.substring(0, bodyIndex);
                    String cvsSpamFooter = batchLog.substring(bodyIndex);
                    dataMap.put("cvsSpamHeader", cvsSpamHeader);
                    dataMap.put("cvsSpamFooter", cvsSpamFooter);
                    dataMap.put("rcsName", "CVS");
                } else {
                    dataMap.put("cvsSpamFooter", batchLog);
                    dataMap.put("rcsName", "SVN");
                }
                dataMap.put("cvsCommitDate", cvsDate);
            } else {
                dataMap.put("batchLog", batchLog);
            }
            if (TestRunner.hasMultipleTestsPerFile(showcase)) {
                dataMap.put("totalTests", totalTests);
                dataMap.put("passedTests", passedTests);
            }
            dataMap.put("firstBatchFound", true);
            dataMap.put("totalTestFiles", totalTestFiles);
            dataMap.put("passedTestFiles", passedTestFiles);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dataMap.put("batchStartTime", dateFormat.format(newBatch.getBatchStartTime()));
            dataMap.put("branch", branch);
            dataMap.put("batchMillis", newBatch.getBatchStartTime().getTime());
            dataMap.put("showcase", ShowcaseSpecifier.getShowcaseAsUrlParameter(showcase));
            msg.setContextMap(dataMap);
            String mailTemplate = config.getMailTemplate();
            msg.setTemplateFile(mailTemplate);
            msg.buildMessage(dataMap, mailTemplate);
            try {
                msg.send();
            }
            catch (Exception e) {
                log.warn((Object)e);
                e.printStackTrace();
            }
        }
    }

    protected static void sendDifferencesEmailFromBatchTimes(String user, String alertEmail, final Date batchStartTimeNew, final Date batchStartTimeOld, String cvsSpam, String cvsDate, String showcase, String branch, String newState) throws Exception {
        final List<TestResult> newTests = TestResultDao.getTestsForBatch(batchStartTimeNew, showcase, branch);
        final List<TestResult> oldTests = TestResultDao.getTestsForBatch(batchStartTimeOld, showcase, branch);
        if (oldTests == null || oldTests.size() == 0) {
            log.error((Object)("Older test results can't be found for " + batchStartTimeOld + ", showcase " + showcase + ", branch " + branch + "!"));
            return;
        }
        if (newTests == null || newTests.size() == 0) {
            log.error((Object)("Newer test results can't be found for " + batchStartTimeNew + ", showcase " + showcase + ", branch " + branch + "!"));
            return;
        }
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        TestRunner.sendDifferencesEmailInternal(alertEmail, launcher.getEmailForUser(user), launcher.getCcEmail(), (List<BatchResults>)new ArrayList<BatchResults>(){
            {
                this.add(new BatchResults(batchStartTimeNew, newTests));
                this.add(new BatchResults(batchStartTimeOld, oldTests));
            }
        }, user, cvsSpam, cvsDate, showcase, branch, newState);
        BatchRunDao.setState(batchStartTimeNew, showcase, newState);
        log.info((Object)("Changed the state of batch " + batchStartTimeNew + " to " + newState));
    }

    protected static void sendDifferencesEmail(String alertEmail, String repeatEmail, String ccEmail, String user, String timestamp, String batchLog, String cvsDate, String showcase, String branch, Date batchStartTime, boolean onAwsServer) throws Exception {
        TestRunnerLauncher.InstanceProperties properties;
        if (!onAwsServer) {
            List<BatchResults> lastBatches = TestRunner.lastBatchesForTimestamp(timestamp, showcase, branch, 2);
            TestRunner.sendDifferencesEmailInternal(alertEmail, repeatEmail, ccEmail, lastBatches, user, batchLog, cvsDate, showcase, branch, null);
            return;
        }
        log.info((Object)("Beginning sendDifferencesEmail processing for batch " + batchStartTime));
        BatchRunDao.assertState(batchStartTime, showcase, "t");
        Date predecessorBatchTime = BatchRunDao.getPredecessorBatchStartTime(batchStartTime, branch);
        if (predecessorBatchTime == null) {
            throw new InconsistentBatchRunTableException("No predecessor found for " + batchStartTime + ", branch " + branch);
        }
        String predecessorState = BatchRunDao.getState(predecessorBatchTime, showcase);
        log.info((Object)("Predecessor for batch " + batchStartTime + ", batch " + predecessorBatchTime + " has state " + predecessorState));
        if (Utils.matchRegExp("/T|R/i", predecessorState)) {
            TestRunner.sendDifferencesEmailFromBatchTimes(user, alertEmail, batchStartTime, predecessorBatchTime, batchLog, cvsDate, showcase, branch, "r");
            log.info((Object)("Attempted to send differences email for batches " + batchStartTime + " (current) and " + predecessorBatchTime + " (predecessor)"));
        } else {
            log.info((Object)("Predecessor batch " + predecessorBatchTime + " current state doesn't " + "permit us to send out a differences email"));
        }
        TestRunner.clearTestResults();
        Date successorBatchTime = BatchRunDao.getSuccessorBatchStartTime(batchStartTime, branch);
        if (successorBatchTime != null && (properties = TestRunnerLauncher.getInstanceProperties(successorBatchTime, true)) != null) {
            String successorState = BatchRunDao.getState(properties.instanceBatchTime, showcase);
            log.info((Object)("The successor batch " + successorBatchTime + " has state " + successorState));
            if (successorState != null && successorState.equals("T")) {
                TestRunner.sendDifferencesEmailFromBatchTimes(properties.instanceUsername, properties.instanceEmail, properties.instanceBatchTime, batchStartTime, properties.instanceCvsSpam, properties.instanceCvsDate, showcase, branch, "R");
                log.info((Object)("Attempted to send differences email for batches " + successorBatchTime + " (successor) and " + batchStartTime + " (current)"));
            }
        }
        log.info((Object)("Completed sendDifferencesEmail processing for batch " + batchStartTime));
    }

    protected static String reportAndValidateBatch(Date currentBatchStartTime, Date earlierBatchStartTime, String showcase, String branch, String validatedState, String validatedMessage, String earlierBatchType) throws Exception {
        TestRunnerLauncher.InstanceProperties properties;
        String earlierState;
        if (earlierBatchStartTime != null && Utils.matchRegExp("/T|R/i", earlierState = BatchRunDao.getState(earlierBatchStartTime, showcase)) && (properties = TestRunnerLauncher.getInstanceProperties(currentBatchStartTime, false)) != null) {
            TestRunner.sendDifferencesEmailFromBatchTimes(properties.instanceUsername, properties.instanceEmail, currentBatchStartTime, earlierBatchStartTime, properties.instanceCvsSpam, properties.instanceCvsDate, showcase, branch, validatedState);
            log.info((Object)("Attempted to send failsafe " + validatedMessage + " for batches " + currentBatchStartTime + " (current) and " + earlierBatchStartTime + " " + earlierBatchType));
        }
        return BatchRunDao.getState(currentBatchStartTime, showcase);
    }

    protected static void validateCommitRecord(Date batchStartTime, String branch) throws Exception {
        if (BatchRunDao.isBatchValidated(batchStartTime) || !TestRunnerLauncher.isBranchApproved(branch)) {
            return;
        }
        Date predecessorBatchTime = BatchRunDao.getPredecessorBatchStartTime(batchStartTime, branch);
        String failsafeReport = "";
        List<String> showcases = ShowcaseSpecifier.getValidShowcases(branch, batchStartTime);
        log.info((Object)("Beginning validateCommitRecord for batch " + batchStartTime));
        for (int i = 0; i < showcases.size(); ++i) {
            String showcase = showcases.get(i);
            String showcaseName = ShowcaseSpecifier.getPrintableShowcaseDescription(showcase);
            String state = BatchRunDao.getState(batchStartTime, showcase);
            if ("T".equalsIgnoreCase(state)) {
                state = TestRunner.reportAndValidateBatch(batchStartTime, predecessorBatchTime, showcase, branch, "R", "differences email", "(predecessor)");
            }
            if ("T".equalsIgnoreCase(state)) {
                Date latestComparableBatchTime = BatchRunDao.getLatestPassingBatchStartTime(batchStartTime, showcase, branch, null);
                state = TestRunner.reportAndValidateBatch(batchStartTime, latestComparableBatchTime, showcase, branch, "R!", "best-effort differences email", "(earlier)");
            }
            if (state == null) {
                failsafeReport = failsafeReport + showcaseName + " never launched<br>";
            } else if ("L".equalsIgnoreCase(state)) {
                failsafeReport = failsafeReport + showcaseName + " failed before completion<br>";
            } else if ("T".equalsIgnoreCase(state)) {
                failsafeReport = failsafeReport + showcaseName + " did not report test result differences<br>";
            }
            TestRunner.clearTestResults();
        }
        BatchRunDao.updateBatchStatus(batchStartTime, "awsCrash", true);
        if (failsafeReport.length() > 0) {
            String currentInstanceId = BatchRunDao.getAwsInstanceId(batchStartTime);
            String predecessorInstanceId = BatchRunDao.getAwsInstanceId(predecessorBatchTime);
            log.info((Object)("Sending a report of commit record for batch " + batchStartTime));
            Runtime.getRuntime().exec(new String[]{"reportCommitDebug.sh", failsafeReport, currentInstanceId, predecessorInstanceId});
        }
        log.info((Object)("Completed validateCommitRecord for batch " + batchStartTime));
    }

    protected static void collectLocalResults() {
        localResults = new ArrayList();
    }

    private static Map<String, TestResult> processBatch(List<TestResult> firstBatch) {
        HashMap<String, TestResult> result = new HashMap<String, TestResult>();
        for (TestResult testResult : firstBatch) {
            result.put(testResult.getTestFile() + "_" + testResult.getTestNumber(), testResult);
        }
        return result;
    }

    private static String getRootResult(Map<String, TestResult> results, String testFile) {
        TestResult root;
        if (results != null && testFile != null && (root = results.get(testFile + "_1")) != null) {
            return root.getResult();
        }
        return null;
    }

    private static List<BatchResults> lastBatchesForTimestamp(String timestamp, String showcase, String branch, int nRequired) throws Exception {
        Date targetBatch = timestamp == null ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(timestamp);
        return TestRunner.lastBatchesForTimestamp(targetBatch, showcase, branch, nRequired);
    }

    private static List<BatchResults> lastBatchesForTimestamp(Date targetBatch, String showcase, String branch, int nRequired) throws Exception {
        ArrayList<BatchResults> lastBatches = new ArrayList<BatchResults>();
        if (targetBatch == null || nRequired > 2) {
            log.info((Object)("looking for last batch with " + config.getBatchRunDS() + " record"));
            List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
            int nCommitsToSearch = Math.min(commits.size(), 20 + config.getHistoryDepth());
            for (int i = 0; i < nCommitsToSearch && lastBatches.size() < nRequired; ++i) {
                List<TestResult> results;
                Date batchStartTime = commits.get(i);
                if (targetBatch != null && targetBatch.compareTo(batchStartTime) < 0 || (results = TestResultDao.getTestsForBatch(batchStartTime, showcase, branch)).size() <= 0 && targetBatch == null) continue;
                lastBatches.add(new BatchResults(batchStartTime, results));
            }
        } else {
            log.info((Object)("looking for batch created at " + targetBatch));
            List<Date> batchTimes = TestResultDao.getLastBatchesTime(showcase, branch);
            if (batchTimes.size() >= nRequired) {
                int startIndex = 0;
                if (nRequired > 1) {
                    Date last = batchTimes.get(0);
                    lastBatches.add(new BatchResults(last, TestResultDao.getTestsForBatch(last, showcase, branch)));
                    ++startIndex;
                }
                Date closest = null;
                for (int i = startIndex; i < batchTimes.size(); ++i) {
                    Date bt = batchTimes.get(i);
                    if (closest != null && Math.abs(targetBatch.getTime() - closest.getTime()) <= Math.abs(targetBatch.getTime() - bt.getTime())) continue;
                    closest = bt;
                }
                lastBatches.add(new BatchResults(closest, TestResultDao.getTestsForBatch(closest, showcase, branch)));
            }
        }
        return lastBatches;
    }

    private static void addHistoryForChanges(Date batchStartTime, String showcase, String branch, int nBatches) throws Exception {
        List<BatchResults> historicalBatches = TestRunner.lastBatchesForTimestamp(batchStartTime, showcase, branch, nBatches);
        List changes = ListUtils.union(regressions, fixed);
        Map<String, TestResult> changeMap = TestRunner.processBatch(changes);
        for (int i = 0; i < historicalBatches.size(); ++i) {
            BatchResults currentBatch = historicalBatches.get(i);
            HashSet currentChanges = new HashSet(changes);
            Date currentBatchStartTime = currentBatch.getBatchStartTime();
            for (TestResult testResult : currentBatch.getResults()) {
                String result;
                String testFile = testResult.getTestFile();
                String key = testFile + "_" + testResult.getTestNumber();
                TestResult change = changeMap.get(key);
                if (change == null) continue;
                change.addPastResult(result, Utils.linkify(branch, currentBatchStartTime, showcase, testFile, false, "success".equals(result = testResult.getResult()) ? "green" : "red"));
                currentChanges.remove(change);
            }
            for (TestResult testResult : currentChanges) {
                String state = BatchRunDao.getState(currentBatchStartTime, showcase);
                String status = BatchRunDao.getBatchProperty(currentBatchStartTime, "completionStatus");
                String flag = Utils.matchRegExp("/T|R/i", state) || status != null ? "-" : "?";
                testResult.addPastResult(flag, null);
            }
        }
        for (TestResult testResult : changes) {
            testResult.setPastResults();
        }
    }

    protected static void compareBatches(List<TestResult> firstBatch, List<TestResult> secondBatch) {
        Map<String, TestResult> secondBatchTests = TestRunner.processBatch(secondBatch);
        HashSet<String> passedTestFileSet = new HashSet<String>();
        for (TestResult test : firstBatch) {
            passedTestFileSet.add(test.getTestFile());
        }
        totalTestFiles = passedTestFileSet.size();
        Collections.sort(firstBatch, new Comparator(){

            public int compare(Object object1, Object object2) {
                TestResult testResult1 = (TestResult)object1;
                TestResult testResult2 = (TestResult)object2;
                if (testResult1.getTestFile().equals(testResult2.getTestFile())) {
                    return testResult1.getTestNumber() - testResult2.getTestNumber();
                }
                return testResult1.getTestFile().compareTo(testResult2.getTestFile());
            }
        });
        for (TestResult first : firstBatch) {
            String secondRootResult;
            ++totalTests;
            String testName = first.getTestFile() + "_" + first.getTestNumber();
            TestResult second = secondBatchTests.get(testName);
            if (first != null && "success".equals(first.getResult())) {
                ++passedTests;
            } else {
                passedTestFileSet.remove(first.getTestFile());
            }
            if (first == null) continue;
            if (second != null) {
                if ("success".equals(first.getResult()) && !"success".equals(second.getResult())) {
                    fixed.add(first);
                    log.info((Object)("fixed: " + first.getTestFile() + "#" + first.getTestNumber()));
                    continue;
                }
                if ("success".equals(first.getResult()) || !"success".equals(second.getResult())) continue;
                regressions.add(first);
                log.info((Object)("regression: " + first.getTestFile() + "#" + first.getTestNumber()));
                continue;
            }
            if ("success".equals(first.getResult()) || "timeout".equals(secondRootResult = TestRunner.getRootResult(secondBatchTests, first.getTestFile()))) continue;
            regressions.add(first);
            log.info((Object)("first run failure: " + first.getTestFile() + "#" + first.getTestNumber()));
            String oldDetails = first.getDetails();
            String newDetails = "***Initial Failure of New Test***";
            if (oldDetails != null) {
                newDetails = newDetails + ": " + oldDetails;
            }
            first.setDetails(newDetails);
        }
        passedTestFiles = passedTestFileSet.size();
    }

    private static void setEmailSubjectAndFromField(MailMessage msg, String mode, String showcase, boolean foundCommit, String user, Date batchStartTime, String commitMessage, String branch) {
        String subject = config.getMailSubject();
        if (subject == null) {
            subject = Utils.getSubjectBaseAndSetFromFieldForEmail(msg, mode, showcase, branch);
        } else {
            msg.setFrom(((TestRunnerLauncher)config).getSenderEmail());
        }
        StringBuilder builder = new StringBuilder(subject);
        if (foundCommit) {
            if (regressions.size() > 1) {
                builder.append(regressions.size()).append(" regressions ");
            } else if (regressions.size() == 1) {
                builder.append("1 regression ");
            }
            if (fixed.size() > 0) {
                builder.append(fixed.size()).append(" fixed ");
            }
            if (regressions.size() == 0 && fixed.size() == 0) {
                builder.append("no changes ");
            }
        }
        if (user != null) {
            builder.append("on checkin by ").append(user);
        }
        if (commitMessage != null) {
            int fLineEnd = commitMessage.indexOf("\n");
            if (fLineEnd > 0) {
                commitMessage = commitMessage.substring(0, fLineEnd);
            }
            builder.append(" \"").append(commitMessage).append("\"");
        }
        if (config.canParseLog()) {
            String summary = passedTestFiles + "/" + totalTestFiles;
            if (batchStartTime != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                summary = dateFormat.format(batchStartTime) + " " + summary;
            }
            try {
                String instanceId = null;
                if ("Local".equals(mode)) {
                    instanceId = "local";
                } else {
                    DSRequest dsReq = new DSRequest("sourceCommit", "fetch");
                    dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
                    Map sourceCommit = dsReq.execute().getDataMap();
                    instanceId = (String)sourceCommit.get("instanceId");
                }
                summary = instanceId + " " + summary;
            }
            catch (Exception shouldNotHappen) {
                log.error((Object)("Unable to obtain instanceId for batchStartTime: " + batchStartTime.toString()));
            }
            builder.append(" [" + summary + "]");
        }
        msg.setSubject(builder.toString());
    }

    private static boolean addEmailRecipients(TemplatedMailMessage msg, String alertEmail, String repeatEmail, String ccEmail, boolean resultsChanged) {
        String toEmail;
        if (alertEmail == null) {
            alertEmail = repeatEmail;
        } else if (repeatEmail == null) {
            repeatEmail = alertEmail;
        }
        String string = toEmail = resultsChanged ? alertEmail : repeatEmail;
        if (StringUtils.isEmpty((String)toEmail) || ".".equals(toEmail)) {
            log.warn((Object)"email enabled, but no valid to address was available for this batch run, based on your configuration - no email sent");
            return false;
        }
        msg.addRecipients(toEmail, Message.RecipientType.TO);
        if (!StringUtils.isEmpty((String)ccEmail)) {
            msg.addRecipients(ccEmail, Message.RecipientType.CC);
        }
        return true;
    }

    private static boolean hasMultipleTestsPerFile(String showcase) {
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        if (showcase == null) {
            return !launcher.noUsualTests();
        }
        return new ShowcaseSpecifier(showcase).isSmartGWTRunner();
    }

    protected static void clearTestResults() {
        totalTests = 0;
        totalTestFiles = 0;
        passedTests = 0;
        passedTestFiles = 0;
        fixed = new ArrayList<TestResult>();
        regressions = new ArrayList<TestResult>();
    }

    protected static double getPassRatio() {
        double totalTests = TestRunner.totalTests;
        return totalTests > 0.0 ? (double)passedTests / totalTests : 0.0;
    }

    public static void setConfiguration(TestRunnerConfiguration config) {
        TestRunner.config = config;
        TestRunnerHelper.setConfiguration(config);
        TestShowcaseHelper.setConfiguration(config);
        BatchRunDao.setConfiguration(config);
        TestResultDao.setConfiguration(config);
    }

    public static class BatchResults {
        private Date batchStartTime;
        private List<TestResult> results;

        protected Date getBatchStartTime() {
            return this.batchStartTime;
        }

        protected List<TestResult> getResults() {
            return this.results;
        }

        public BatchResults(Date batchStartTime, List<TestResult> results) {
            this.batchStartTime = batchStartTime;
            this.results = results;
        }
    }
}

